/*  sane - Scanner Access Now Easy.

    Copyright (C) 2020 Povilas Kanapickas <povilas@radix.lt>

    This file is part of the SANE package.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#define DEBUG_DECLARE_ONLY

#include "low.h"

namespace genesys {

StaticInit<std::vector<MemoryLayout>> s_memory_layout;

void genesys_init_memory_layout_tables()
{
    s_memory_layout.init();

    MemoryLayout ml;
    ml.models = { ModelId::CANON_IMAGE_FORMULA_101 };
    // FIXME: this scanner does not set all required registers
    ml.regs = {
        { 0xe0, 0x00 }, { 0xe1, 0xb0 }, { 0xe2, 0x05 }, { 0xe3, 0xe7 },
        { 0xe4, 0x05 }, { 0xe5, 0xe8 }, { 0xe6, 0x0b }, { 0xe7, 0x1f },
        { 0xe8, 0x0b }, { 0xe9, 0x20 },
    };
    s_memory_layout->push_back(ml);


    ml = MemoryLayout();
    ml.models = { ModelId::PLUSTEK_OPTICBOOK_3800 };
    // FIXME: this scanner does not set all required registers
    ml.regs = {
        { 0xe0, 0x00 }, { 0xe1, 0x68 }, { 0xe2, 0x03 }, { 0xe3, 0x00 },
        { 0xe4, 0x03 }, { 0xe5, 0x01 }, { 0xe6, 0x05 }, { 0xe7, 0x99 },
        { 0xe8, 0x05 }, { 0xe9, 0x9a },
    };
    s_memory_layout->push_back(ml);

    ml = MemoryLayout();
    ml.models = { ModelId::PLUSTEK_OPTICFILM_7400, ModelId::PLUSTEK_OPTICFILM_8200I };
    ml.regs = {
        { 0x81, 0x6d }, { 0x82, 0x00 }, { 0x83, 0x00 }, { 0x84, 0x00 },
        { 0x85, 0x00 }, { 0x86, 0x00 },
        { 0xd0, 0x0a }, { 0xd1, 0x0a }, { 0xd2, 0x0a },
        { 0xe0, 0x00 }, { 0xe1, 0x68 }, { 0xe2, 0x03 }, { 0xe3, 0x00 },
        { 0xe4, 0x03 }, { 0xe5, 0x01 }, { 0xe6, 0x05 }, { 0xe7, 0x99 },
        { 0xe8, 0x05 }, { 0xe9, 0x9a }, { 0xea, 0x08 }, { 0xeb, 0x32 },
        { 0xec, 0x08 }, { 0xed, 0x33 }, { 0xee, 0x0a }, { 0xef, 0xcb },
        { 0xf0, 0x0a }, { 0xf1, 0xcc }, { 0xf2, 0x0d }, { 0xf3, 0x64 },
        { 0xf4, 0x0d }, { 0xf5, 0x65 }, { 0xf6, 0x0f }, { 0xf7, 0xfd },
    };
    s_memory_layout->push_back(ml);


    /*  On GL847 and GL124, the values of the base address for shading data must be multiplied by
        8192=0x4000 to give address on AHB

        On GL847 and GL124, the values of the base address for scanned data must be multiplied by
        1024*2=0x0800 to give address on AHB
    */
    ml = MemoryLayout();
    ml.models = { ModelId::CANON_5600F };
    ml.regs = {
        { 0xd0, 0x0a },
        { 0xe0, 0x01 }, { 0xe1, 0x2c }, { 0xe2, 0x06 }, { 0xe3, 0x4e },
        { 0xe4, 0x06 }, { 0xe5, 0x4f }, { 0xe6, 0x0b }, { 0xe7, 0x71 },
        { 0xe8, 0x0b }, { 0xe9, 0x72 }, { 0xea, 0x10 }, { 0xeb, 0x94 },
        { 0xec, 0x10 }, { 0xed, 0x95 }, { 0xee, 0x15 }, { 0xef, 0xb7 },
        { 0xf0, 0x15 }, { 0xf1, 0xb8 }, { 0xf2, 0x1a }, { 0xf3, 0xda },
        { 0xf4, 0x1a }, { 0xf5, 0xdb }, { 0xf6, 0x1f }, { 0xf7, 0xfd },
        { 0xf8, 0x05 }
    };
    s_memory_layout->push_back(ml);


    ml = MemoryLayout();
    ml.models = { ModelId::CANON_LIDE_100 };
    ml.regs = {
        { 0xd0, 0x0a }, { 0xd1, 0x15 }, { 0xd2, 0x20 },
        { 0xe0, 0x00 }, { 0xe1, 0xac }, { 0xe2, 0x02 }, { 0xe3, 0x55 },
        { 0xe4, 0x02 }, { 0xe5, 0x56 }, { 0xe6, 0x03 }, { 0xe7, 0xff },
        { 0xe8, 0x00 }, { 0xe9, 0xac }, { 0xea, 0x02 }, { 0xeb, 0x55 },
        { 0xec, 0x02 }, { 0xed, 0x56 }, { 0xee, 0x03 }, { 0xef, 0xff },
        { 0xf0, 0x00 }, { 0xf1, 0xac }, { 0xf2, 0x02 }, { 0xf3, 0x55 },
        { 0xf4, 0x02 }, { 0xf5, 0x56 }, { 0xf6, 0x03 }, { 0xf7, 0xff },
    };
    s_memory_layout->push_back(ml);


    ml = MemoryLayout();
    ml.models = { ModelId::CANON_LIDE_200 };
    ml.regs = {
        { 0xd0, 0x0a }, { 0xd1, 0x1f }, { 0xd2, 0x34 },
        { 0xe0, 0x01 }, { 0xe1, 0x24 }, { 0xe2, 0x02 }, { 0xe3, 0x91 },
        { 0xe4, 0x02 }, { 0xe5, 0x92 }, { 0xe6, 0x03 }, { 0xe7, 0xff },
        { 0xe8, 0x01 }, { 0xe9, 0x24 }, { 0xea, 0x02 }, { 0xeb, 0x91 },
        { 0xec, 0x02 }, { 0xed, 0x92 }, { 0xee, 0x03 }, { 0xef, 0xff },
        { 0xf0, 0x01 }, { 0xf1, 0x24 }, { 0xf2, 0x02 }, { 0xf3, 0x91 },
        { 0xf4, 0x02 }, { 0xf5, 0x92 }, { 0xf6, 0x03 }, { 0xf7, 0xff },
    };
    s_memory_layout->push_back(ml);


    ml = MemoryLayout();
    ml.models = { ModelId::CANON_LIDE_700F };
    ml.regs = {
        { 0xd0, 0x0a }, { 0xd1, 0x33 }, { 0xd2, 0x5c },
        { 0xe0, 0x02 }, { 0xe1, 0x14 }, { 0xe2, 0x09 }, { 0xe3, 0x09 },
        { 0xe4, 0x09 }, { 0xe5, 0x0a }, { 0xe6, 0x0f }, { 0xe7, 0xff },
        { 0xe8, 0x02 }, { 0xe9, 0x14 }, { 0xea, 0x09 }, { 0xeb, 0x09 },
        { 0xec, 0x09 }, { 0xed, 0x0a }, { 0xee, 0x0f }, { 0xef, 0xff },
        { 0xf0, 0x02 }, { 0xf1, 0x14 }, { 0xf2, 0x09 }, { 0xf3, 0x09 },
        { 0xf4, 0x09 }, { 0xf5, 0x0a }, { 0xf6, 0x0f }, { 0xf7, 0xff },
    };
    s_memory_layout->push_back(ml);


    ml = MemoryLayout();
    ml.models = { ModelId::CANON_LIDE_110, ModelId::CANON_LIDE_120 };
    ml.regs = {
        { 0xd0, 0x0a }, { 0xd1, 0x15 }, { 0xd2, 0x20 },
        { 0xe0, 0x00 }, { 0xe1, 0xac }, { 0xe2, 0x08 }, { 0xe3, 0x55 },
        { 0xe4, 0x08 }, { 0xe5, 0x56 }, { 0xe6, 0x0f }, { 0xe7, 0xff },
        { 0xe8, 0x00 }, { 0xe9, 0xac }, { 0xea, 0x08 }, { 0xeb, 0x55 },
        { 0xec, 0x08 }, { 0xed, 0x56 }, { 0xee, 0x0f }, { 0xef, 0xff },
        { 0xf0, 0x00 }, { 0xf1, 0xac }, { 0xf2, 0x08 }, { 0xf3, 0x55 },
        { 0xf4, 0x08 }, { 0xf5, 0x56 }, { 0xf6, 0x0f }, { 0xf7, 0xff },

    };
    s_memory_layout->push_back(ml);


    ml = MemoryLayout();
    ml.models = { ModelId::CANON_LIDE_210, ModelId::CANON_LIDE_220 };
    ml.regs = {
        { 0xd0, 0x0a }, { 0xd1, 0x1f }, { 0xd2, 0x34 },
        { 0xe0, 0x01 }, { 0xe1, 0x24 }, { 0xe2, 0x08 }, { 0xe3, 0x91 },
        { 0xe4, 0x08 }, { 0xe5, 0x92 }, { 0xe6, 0x0f }, { 0xe7, 0xff },
        { 0xe8, 0x01 }, { 0xe9, 0x24 }, { 0xea, 0x08 }, { 0xeb, 0x91 },
        { 0xec, 0x08 }, { 0xed, 0x92 }, { 0xee, 0x0f }, { 0xef, 0xff },
        { 0xf0, 0x01 }, { 0xf1, 0x24 }, { 0xf2, 0x08 }, { 0xf3, 0x91 },
        { 0xf4, 0x08 }, { 0xf5, 0x92 }, { 0xf6, 0x0f }, { 0xf7, 0xff },
    };
    s_memory_layout->push_back(ml);
}

} // namespace genesys
