// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1/clusters.proto

/*
Package dataproc is a generated protocol buffer package.

It is generated from these files:
	google/cloud/dataproc/v1/clusters.proto
	google/cloud/dataproc/v1/jobs.proto
	google/cloud/dataproc/v1/operations.proto

It has these top-level messages:
	Cluster
	ClusterConfig
	GceClusterConfig
	InstanceGroupConfig
	ManagedGroupConfig
	AcceleratorConfig
	DiskConfig
	NodeInitializationAction
	ClusterStatus
	SoftwareConfig
	ClusterMetrics
	CreateClusterRequest
	UpdateClusterRequest
	DeleteClusterRequest
	GetClusterRequest
	ListClustersRequest
	ListClustersResponse
	DiagnoseClusterRequest
	DiagnoseClusterResults
	LoggingConfig
	HadoopJob
	SparkJob
	PySparkJob
	QueryList
	HiveJob
	SparkSqlJob
	PigJob
	JobPlacement
	JobStatus
	JobReference
	YarnApplication
	Job
	JobScheduling
	SubmitJobRequest
	GetJobRequest
	ListJobsRequest
	UpdateJobRequest
	ListJobsResponse
	CancelJobRequest
	DeleteJobRequest
	ClusterOperationStatus
	ClusterOperationMetadata
*/
package dataproc

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf4 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The cluster state.
type ClusterStatus_State int32

const (
	// The cluster state is unknown.
	ClusterStatus_UNKNOWN ClusterStatus_State = 0
	// The cluster is being created and set up. It is not ready for use.
	ClusterStatus_CREATING ClusterStatus_State = 1
	// The cluster is currently running and healthy. It is ready for use.
	ClusterStatus_RUNNING ClusterStatus_State = 2
	// The cluster encountered an error. It is not ready for use.
	ClusterStatus_ERROR ClusterStatus_State = 3
	// The cluster is being deleted. It cannot be used.
	ClusterStatus_DELETING ClusterStatus_State = 4
	// The cluster is being updated. It continues to accept and process jobs.
	ClusterStatus_UPDATING ClusterStatus_State = 5
)

var ClusterStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "DELETING",
	5: "UPDATING",
}
var ClusterStatus_State_value = map[string]int32{
	"UNKNOWN":  0,
	"CREATING": 1,
	"RUNNING":  2,
	"ERROR":    3,
	"DELETING": 4,
	"UPDATING": 5,
}

func (x ClusterStatus_State) String() string {
	return proto.EnumName(ClusterStatus_State_name, int32(x))
}
func (ClusterStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 0} }

type ClusterStatus_Substate int32

const (
	ClusterStatus_UNSPECIFIED ClusterStatus_Substate = 0
	// The cluster is known to be in an unhealthy state
	// (for example, critical daemons are not running or HDFS capacity is
	// exhausted).
	//
	// Applies to RUNNING state.
	ClusterStatus_UNHEALTHY ClusterStatus_Substate = 1
	// The agent-reported status is out of date (may occur if
	// Cloud Dataproc loses communication with Agent).
	//
	// Applies to RUNNING state.
	ClusterStatus_STALE_STATUS ClusterStatus_Substate = 2
)

var ClusterStatus_Substate_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "UNHEALTHY",
	2: "STALE_STATUS",
}
var ClusterStatus_Substate_value = map[string]int32{
	"UNSPECIFIED":  0,
	"UNHEALTHY":    1,
	"STALE_STATUS": 2,
}

func (x ClusterStatus_Substate) String() string {
	return proto.EnumName(ClusterStatus_Substate_name, int32(x))
}
func (ClusterStatus_Substate) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 1} }

// Describes the identifying information, config, and status of
// a cluster of Google Compute Engine instances.
type Cluster struct {
	// Required. The Google Cloud Platform project ID that the cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The cluster name. Cluster names within a project must be
	// unique. Names of deleted clusters can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// Required. The cluster config. Note that Cloud Dataproc may set
	// default values, and values may change when clusters are updated.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
	// Optional. The labels to associate with this cluster.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// No more than 32 labels can be associated with a cluster.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Output-only. Cluster status.
	Status *ClusterStatus `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	// Output-only. The previous cluster status.
	StatusHistory []*ClusterStatus `protobuf:"bytes,7,rep,name=status_history,json=statusHistory" json:"status_history,omitempty"`
	// Output-only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
	// generates this value when it creates the cluster.
	ClusterUuid string `protobuf:"bytes,6,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
	// Contains cluster daemon metrics such as HDFS and YARN stats.
	//
	// **Beta Feature**: This report is available for testing purposes only. It may
	// be changed before final release.
	Metrics *ClusterMetrics `protobuf:"bytes,9,opt,name=metrics" json:"metrics,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Cluster) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Cluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetStatus() *ClusterStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Cluster) GetStatusHistory() []*ClusterStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

func (m *Cluster) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

func (m *Cluster) GetMetrics() *ClusterMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// The cluster config.
type ClusterConfig struct {
	// Optional. A Google Cloud Storage staging bucket used for sharing generated
	// SSH keys and config. If you do not specify a staging bucket, Cloud
	// Dataproc will determine an appropriate Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the Google
	// Compute Engine zone where your cluster is deployed, and then it will create
	// and manage this project-level, per-location bucket for you.
	ConfigBucket string `protobuf:"bytes,1,opt,name=config_bucket,json=configBucket" json:"config_bucket,omitempty"`
	// Required. The shared Google Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `protobuf:"bytes,8,opt,name=gce_cluster_config,json=gceClusterConfig" json:"gce_cluster_config,omitempty"`
	// Optional. The Google Compute Engine config settings for
	// the master instance in a cluster.
	MasterConfig *InstanceGroupConfig `protobuf:"bytes,9,opt,name=master_config,json=masterConfig" json:"master_config,omitempty"`
	// Optional. The Google Compute Engine config settings for
	// worker instances in a cluster.
	WorkerConfig *InstanceGroupConfig `protobuf:"bytes,10,opt,name=worker_config,json=workerConfig" json:"worker_config,omitempty"`
	// Optional. The Google Compute Engine config settings for
	// additional worker instances in a cluster.
	SecondaryWorkerConfig *InstanceGroupConfig `protobuf:"bytes,12,opt,name=secondary_worker_config,json=secondaryWorkerConfig" json:"secondary_worker_config,omitempty"`
	// Optional. The config settings for software inside the cluster.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,13,opt,name=software_config,json=softwareConfig" json:"software_config,omitempty"`
	// Optional. Commands to execute on each node after config is
	// completed. By default, executables are run on master and all worker nodes.
	// You can test a node's `role` metadata to run an executable on
	// a master or worker node, as shown below using `curl` (you can also use `wget`):
	//
	//     ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role)
	//     if [[ "${ROLE}" == 'Master' ]]; then
	//       ... master specific actions ...
	//     else
	//       ... worker specific actions ...
	//     fi
	InitializationActions []*NodeInitializationAction `protobuf:"bytes,11,rep,name=initialization_actions,json=initializationActions" json:"initialization_actions,omitempty"`
}

func (m *ClusterConfig) Reset()                    { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()               {}
func (*ClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ClusterConfig) GetConfigBucket() string {
	if m != nil {
		return m.ConfigBucket
	}
	return ""
}

func (m *ClusterConfig) GetGceClusterConfig() *GceClusterConfig {
	if m != nil {
		return m.GceClusterConfig
	}
	return nil
}

func (m *ClusterConfig) GetMasterConfig() *InstanceGroupConfig {
	if m != nil {
		return m.MasterConfig
	}
	return nil
}

func (m *ClusterConfig) GetWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSecondaryWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSoftwareConfig() *SoftwareConfig {
	if m != nil {
		return m.SoftwareConfig
	}
	return nil
}

func (m *ClusterConfig) GetInitializationActions() []*NodeInitializationAction {
	if m != nil {
		return m.InitializationActions
	}
	return nil
}

// Common config settings for resources of Google Compute Engine cluster
// instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	// Optional. The zone where the Google Compute Engine cluster will be located.
	// On a create request, it is required in the "global" region. If omitted
	// in a non-global Cloud Dataproc region, the service will pick a zone in the
	// corresponding Compute Engine region. On a get request, zone will
	// always be present.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
	// * `projects/[project_id]/zones/[zone]`
	// * `us-central1-f`
	ZoneUri string `protobuf:"bytes,1,opt,name=zone_uri,json=zoneUri" json:"zone_uri,omitempty"`
	// Optional. The Google Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// `network_uri` nor `subnetwork_uri` is specified, the "default" network of
	// the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// [Using Subnetworks](/compute/docs/subnetworks) for more information).
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default`
	// * `projects/[project_id]/regions/global/default`
	// * `default`
	NetworkUri string `protobuf:"bytes,2,opt,name=network_uri,json=networkUri" json:"network_uri,omitempty"`
	// Optional. The Google Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network_uri.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/sub0`
	// * `projects/[project_id]/regions/us-east1/sub0`
	// * `sub0`
	SubnetworkUri string `protobuf:"bytes,6,opt,name=subnetwork_uri,json=subnetworkUri" json:"subnetwork_uri,omitempty"`
	// Optional. If true, all instances in the cluster will only have internal IP
	// addresses. By default, clusters are not restricted to internal IP addresses,
	// and will have ephemeral external IP addresses assigned to each instance.
	// This `internal_ip_only` restriction can only be enabled for subnetwork
	// enabled networks, and all off-cluster dependencies must be configured to be
	// accessible without external IP addresses.
	InternalIpOnly bool `protobuf:"varint,7,opt,name=internal_ip_only,json=internalIpOnly" json:"internal_ip_only,omitempty"`
	// Optional. The service account of the instances. Defaults to the default
	// Google Compute Engine service account. Custom service accounts need
	// permissions equivalent to the folloing IAM roles:
	//
	// * roles/logging.logWriter
	// * roles/storage.objectAdmin
	//
	// (see https://cloud.google.com/compute/docs/access/service-accounts#custom_service_accounts
	// for more information).
	// Example: `[account_id]@[project_id].iam.gserviceaccount.com`
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
	// Optional. The URIs of service account scopes to be included in Google
	// Compute Engine instances. The following base set of scopes is always
	// included:
	//
	// * https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// * https://www.googleapis.com/auth/devstorage.read_write
	// * https://www.googleapis.com/auth/logging.write
	//
	// If no scopes are specified, the following defaults are also provided:
	//
	// * https://www.googleapis.com/auth/bigquery
	// * https://www.googleapis.com/auth/bigtable.admin.table
	// * https://www.googleapis.com/auth/bigtable.data
	// * https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `protobuf:"bytes,3,rep,name=service_account_scopes,json=serviceAccountScopes" json:"service_account_scopes,omitempty"`
	// The Google Compute Engine tags to add to all instances (see
	// [Tagging instances](/compute/docs/label-or-tag-resources#tags)).
	Tags []string `protobuf:"bytes,4,rep,name=tags" json:"tags,omitempty"`
	// The Google Compute Engine metadata entries to add to all instances (see
	// [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GceClusterConfig) Reset()                    { *m = GceClusterConfig{} }
func (m *GceClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*GceClusterConfig) ProtoMessage()               {}
func (*GceClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GceClusterConfig) GetZoneUri() string {
	if m != nil {
		return m.ZoneUri
	}
	return ""
}

func (m *GceClusterConfig) GetNetworkUri() string {
	if m != nil {
		return m.NetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetSubnetworkUri() string {
	if m != nil {
		return m.SubnetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetInternalIpOnly() bool {
	if m != nil {
		return m.InternalIpOnly
	}
	return false
}

func (m *GceClusterConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *GceClusterConfig) GetServiceAccountScopes() []string {
	if m != nil {
		return m.ServiceAccountScopes
	}
	return nil
}

func (m *GceClusterConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *GceClusterConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Optional. The config settings for Google Compute Engine resources in
// an instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	// Optional. The number of VM instances in the instance group.
	// For master instance groups, must be set to 1.
	NumInstances int32 `protobuf:"varint,1,opt,name=num_instances,json=numInstances" json:"num_instances,omitempty"`
	// Optional. The list of instance names. Cloud Dataproc derives the names from
	// `cluster_name`, `num_instances`, and the instance group if not set by user
	// (recommended practice is to let Cloud Dataproc derive the name).
	InstanceNames []string `protobuf:"bytes,2,rep,name=instance_names,json=instanceNames" json:"instance_names,omitempty"`
	// Output-only. The Google Compute Engine image resource used for cluster
	// instances. Inferred from `SoftwareConfig.image_version`.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
	// Optional. The Google Compute Engine machine type used for cluster instances.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
	// * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
	// * `n1-standard-2`
	MachineTypeUri string `protobuf:"bytes,4,opt,name=machine_type_uri,json=machineTypeUri" json:"machine_type_uri,omitempty"`
	// Optional. Disk option config settings.
	DiskConfig *DiskConfig `protobuf:"bytes,5,opt,name=disk_config,json=diskConfig" json:"disk_config,omitempty"`
	// Optional. Specifies that this instance group contains preemptible instances.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible" json:"is_preemptible,omitempty"`
	// Output-only. The config for Google Compute Engine Instance Group
	// Manager that manages this group.
	// This is only used for preemptible instance groups.
	ManagedGroupConfig *ManagedGroupConfig `protobuf:"bytes,7,opt,name=managed_group_config,json=managedGroupConfig" json:"managed_group_config,omitempty"`
	// Optional. The Google Compute Engine accelerator configuration for these
	// instances.
	//
	// **Beta Feature**: This feature is still under development. It may be
	// changed before final release.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,8,rep,name=accelerators" json:"accelerators,omitempty"`
}

func (m *InstanceGroupConfig) Reset()                    { *m = InstanceGroupConfig{} }
func (m *InstanceGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*InstanceGroupConfig) ProtoMessage()               {}
func (*InstanceGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *InstanceGroupConfig) GetNumInstances() int32 {
	if m != nil {
		return m.NumInstances
	}
	return 0
}

func (m *InstanceGroupConfig) GetInstanceNames() []string {
	if m != nil {
		return m.InstanceNames
	}
	return nil
}

func (m *InstanceGroupConfig) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetMachineTypeUri() string {
	if m != nil {
		return m.MachineTypeUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetDiskConfig() *DiskConfig {
	if m != nil {
		return m.DiskConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetIsPreemptible() bool {
	if m != nil {
		return m.IsPreemptible
	}
	return false
}

func (m *InstanceGroupConfig) GetManagedGroupConfig() *ManagedGroupConfig {
	if m != nil {
		return m.ManagedGroupConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetAccelerators() []*AcceleratorConfig {
	if m != nil {
		return m.Accelerators
	}
	return nil
}

// Specifies the resources used to actively manage an instance group.
type ManagedGroupConfig struct {
	// Output-only. The name of the Instance Template used for the Managed
	// Instance Group.
	InstanceTemplateName string `protobuf:"bytes,1,opt,name=instance_template_name,json=instanceTemplateName" json:"instance_template_name,omitempty"`
	// Output-only. The name of the Instance Group Manager for this group.
	InstanceGroupManagerName string `protobuf:"bytes,2,opt,name=instance_group_manager_name,json=instanceGroupManagerName" json:"instance_group_manager_name,omitempty"`
}

func (m *ManagedGroupConfig) Reset()                    { *m = ManagedGroupConfig{} }
func (m *ManagedGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*ManagedGroupConfig) ProtoMessage()               {}
func (*ManagedGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ManagedGroupConfig) GetInstanceTemplateName() string {
	if m != nil {
		return m.InstanceTemplateName
	}
	return ""
}

func (m *ManagedGroupConfig) GetInstanceGroupManagerName() string {
	if m != nil {
		return m.InstanceGroupManagerName
	}
	return ""
}

// Specifies the type and number of accelerator cards attached to the instances
// of an instance group (see [GPUs on Compute Engine](/compute/docs/gpus/)).
type AcceleratorConfig struct {
	// Full URL, partial URI, or short name of the accelerator type resource to
	// expose to this instance. See [Google Compute Engine AcceleratorTypes](
	// /compute/docs/reference/beta/acceleratorTypes)
	//
	// Examples
	// * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80`
	// * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80`
	// * `nvidia-tesla-k80`
	AcceleratorTypeUri string `protobuf:"bytes,1,opt,name=accelerator_type_uri,json=acceleratorTypeUri" json:"accelerator_type_uri,omitempty"`
	// The number of the accelerator cards of this type exposed to this instance.
	AcceleratorCount int32 `protobuf:"varint,2,opt,name=accelerator_count,json=acceleratorCount" json:"accelerator_count,omitempty"`
}

func (m *AcceleratorConfig) Reset()                    { *m = AcceleratorConfig{} }
func (m *AcceleratorConfig) String() string            { return proto.CompactTextString(m) }
func (*AcceleratorConfig) ProtoMessage()               {}
func (*AcceleratorConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *AcceleratorConfig) GetAcceleratorTypeUri() string {
	if m != nil {
		return m.AcceleratorTypeUri
	}
	return ""
}

func (m *AcceleratorConfig) GetAcceleratorCount() int32 {
	if m != nil {
		return m.AcceleratorCount
	}
	return 0
}

// Specifies the config of disk options for a group of VM instances.
type DiskConfig struct {
	// Optional. Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int32 `protobuf:"varint,1,opt,name=boot_disk_size_gb,json=bootDiskSizeGb" json:"boot_disk_size_gb,omitempty"`
	// Optional. Number of attached SSDs, from 0 to 4 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
	// If one or more SSDs are attached, this runtime bulk
	// data is spread across them, and the boot disk contains only basic
	// config and installed binaries.
	NumLocalSsds int32 `protobuf:"varint,2,opt,name=num_local_ssds,json=numLocalSsds" json:"num_local_ssds,omitempty"`
}

func (m *DiskConfig) Reset()                    { *m = DiskConfig{} }
func (m *DiskConfig) String() string            { return proto.CompactTextString(m) }
func (*DiskConfig) ProtoMessage()               {}
func (*DiskConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *DiskConfig) GetBootDiskSizeGb() int32 {
	if m != nil {
		return m.BootDiskSizeGb
	}
	return 0
}

func (m *DiskConfig) GetNumLocalSsds() int32 {
	if m != nil {
		return m.NumLocalSsds
	}
	return 0
}

// Specifies an executable to run on a fully configured node and a
// timeout period for executable completion.
type NodeInitializationAction struct {
	// Required. Google Cloud Storage URI of executable file.
	ExecutableFile string `protobuf:"bytes,1,opt,name=executable_file,json=executableFile" json:"executable_file,omitempty"`
	// Optional. Amount of time executable has to complete. Default is
	// 10 minutes. Cluster creation fails with an explanatory error message (the
	// name of the executable that caused the error and the exceeded timeout
	// period) if the executable is not completed at end of the timeout period.
	ExecutionTimeout *google_protobuf4.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout" json:"execution_timeout,omitempty"`
}

func (m *NodeInitializationAction) Reset()                    { *m = NodeInitializationAction{} }
func (m *NodeInitializationAction) String() string            { return proto.CompactTextString(m) }
func (*NodeInitializationAction) ProtoMessage()               {}
func (*NodeInitializationAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *NodeInitializationAction) GetExecutableFile() string {
	if m != nil {
		return m.ExecutableFile
	}
	return ""
}

func (m *NodeInitializationAction) GetExecutionTimeout() *google_protobuf4.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// The status of a cluster and its instances.
type ClusterStatus struct {
	// Output-only. The cluster's state.
	State ClusterStatus_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.dataproc.v1.ClusterStatus_State" json:"state,omitempty"`
	// Output-only. Optional details of cluster's state.
	Detail string `protobuf:"bytes,2,opt,name=detail" json:"detail,omitempty"`
	// Output-only. Time when this state was entered.
	StateStartTime *google_protobuf3.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime" json:"state_start_time,omitempty"`
	// Output-only. Additional state information that includes
	// status reported by the agent.
	Substate ClusterStatus_Substate `protobuf:"varint,4,opt,name=substate,enum=google.cloud.dataproc.v1.ClusterStatus_Substate" json:"substate,omitempty"`
}

func (m *ClusterStatus) Reset()                    { *m = ClusterStatus{} }
func (m *ClusterStatus) String() string            { return proto.CompactTextString(m) }
func (*ClusterStatus) ProtoMessage()               {}
func (*ClusterStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ClusterStatus) GetState() ClusterStatus_State {
	if m != nil {
		return m.State
	}
	return ClusterStatus_UNKNOWN
}

func (m *ClusterStatus) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *ClusterStatus) GetStateStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

func (m *ClusterStatus) GetSubstate() ClusterStatus_Substate {
	if m != nil {
		return m.Substate
	}
	return ClusterStatus_UNSPECIFIED
}

// Specifies the selection and config of software inside the cluster.
type SoftwareConfig struct {
	// Optional. The version of software inside the cluster. It must match the
	// regular expression `[0-9]+\.[0-9]+`. If unspecified, it defaults to the
	// latest version (see [Cloud Dataproc Versioning](/dataproc/versioning)).
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion" json:"image_version,omitempty"`
	// Optional. The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, such as
	// `core:fs.defaultFS`. The following are supported prefixes
	// and their mappings:
	//
	// * capacity-scheduler: `capacity-scheduler.xml`
	// * core:   `core-site.xml`
	// * distcp: `distcp-default.xml`
	// * hdfs:   `hdfs-site.xml`
	// * hive:   `hive-site.xml`
	// * mapred: `mapred-site.xml`
	// * pig:    `pig.properties`
	// * spark:  `spark-defaults.conf`
	// * yarn:   `yarn-site.xml`
	//
	// For more information, see
	// [Cluster properties](/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SoftwareConfig) Reset()                    { *m = SoftwareConfig{} }
func (m *SoftwareConfig) String() string            { return proto.CompactTextString(m) }
func (*SoftwareConfig) ProtoMessage()               {}
func (*SoftwareConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SoftwareConfig) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *SoftwareConfig) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Contains cluster daemon metrics, such as HDFS and YARN stats.
//
// **Beta Feature**: This report is available for testing purposes only. It may
// be changed before final release.
type ClusterMetrics struct {
	// The HDFS metrics.
	HdfsMetrics map[string]int64 `protobuf:"bytes,1,rep,name=hdfs_metrics,json=hdfsMetrics" json:"hdfs_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// The YARN metrics.
	YarnMetrics map[string]int64 `protobuf:"bytes,2,rep,name=yarn_metrics,json=yarnMetrics" json:"yarn_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *ClusterMetrics) Reset()                    { *m = ClusterMetrics{} }
func (m *ClusterMetrics) String() string            { return proto.CompactTextString(m) }
func (*ClusterMetrics) ProtoMessage()               {}
func (*ClusterMetrics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ClusterMetrics) GetHdfsMetrics() map[string]int64 {
	if m != nil {
		return m.HdfsMetrics
	}
	return nil
}

func (m *ClusterMetrics) GetYarnMetrics() map[string]int64 {
	if m != nil {
		return m.YarnMetrics
	}
	return nil
}

// A request to create a cluster.
type CreateClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster to create.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// A request to update a cluster.
type UpdateClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,5,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// Required. The changes to the cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
	// Required. Specifies the path, relative to `Cluster`, of
	// the field to update. For example, to change the number of workers
	// in a cluster to 5, the `update_mask` parameter would be
	// specified as `config.worker_config.num_instances`,
	// and the `PATCH` request body would specify the new value, as follows:
	//
	//     {
	//       "config":{
	//         "workerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// Similarly, to change the number of preemptible workers in a cluster to 5,
	// the `update_mask` parameter would be
	// `config.secondary_worker_config.num_instances`, and the `PATCH` request
	// body would be set as follows:
	//
	//     {
	//       "config":{
	//         "secondaryWorkerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// <strong>Note:</strong> Currently, only the following fields can be updated:
	//
	//  <table>
	//  <tbody>
	//  <tr>
	//  <td><strong>Mask</strong></td>
	//  <td><strong>Purpose</strong></td>
	//  </tr>
	//  <tr>
	//  <td><strong><em>labels</em></strong></td>
	//  <td>Update labels</td>
	//  </tr>
	//  <tr>
	//  <td><strong><em>config.worker_config.num_instances</em></strong></td>
	//  <td>Resize primary worker group</td>
	//  </tr>
	//  <tr>
	//  <td><strong><em>config.secondary_worker_config.num_instances</em></strong></td>
	//  <td>Resize secondary worker group</td>
	//  </tr>
	//  </tbody>
	//  </table>
	UpdateMask *google_protobuf5.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *UpdateClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *UpdateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *UpdateClusterRequest) GetUpdateMask() *google_protobuf5.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request to delete a cluster.
type DeleteClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// Request to get the resource representation for a cluster in a project.
type GetClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *GetClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// A request to list the clusters in a project.
type ListClustersRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// Optional. A filter constraining the clusters to list. Filters are
	// case-sensitive and have the following syntax:
	//
	// field = value [AND [field = value]] ...
	//
	// where **field** is one of `status.state`, `clusterName`, or `labels.[KEY]`,
	// and `[KEY]` is a label key. **value** can be `*` to match all values.
	// `status.state` can be one of the following: `ACTIVE`, `INACTIVE`,
	// `CREATING`, `RUNNING`, `ERROR`, `DELETING`, or `UPDATING`. `ACTIVE`
	// contains the `CREATING`, `UPDATING`, and `RUNNING` states. `INACTIVE`
	// contains the `DELETING` and `ERROR` states.
	// `clusterName` is the name of the cluster provided at creation time.
	// Only the logical `AND` operator is supported; space-separated items are
	// treated as having an implicit `AND` operator.
	//
	// Example filter:
	//
	// status.state = ACTIVE AND clusterName = mycluster
	// AND labels.env = staging AND labels.starred = *
	Filter string `protobuf:"bytes,5,opt,name=filter" json:"filter,omitempty"`
	// Optional. The standard List page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. The standard List page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListClustersRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The list of all clusters in a project.
type ListClustersResponse struct {
	// Output-only. The clusters in the project.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// Output-only. This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent `ListClustersRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DiagnoseClusterRequest) Reset()                    { *m = DiagnoseClusterRequest{} }
func (m *DiagnoseClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterRequest) ProtoMessage()               {}
func (*DiagnoseClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *DiagnoseClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// The location of diagnostic output.
type DiagnoseClusterResults struct {
	// Output-only. The Google Cloud Storage URI of the diagnostic output.
	// The output report is a plain text file with a summary of collected
	// diagnostics.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
}

func (m *DiagnoseClusterResults) Reset()                    { *m = DiagnoseClusterResults{} }
func (m *DiagnoseClusterResults) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterResults) ProtoMessage()               {}
func (*DiagnoseClusterResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *DiagnoseClusterResults) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func init() {
	proto.RegisterType((*Cluster)(nil), "google.cloud.dataproc.v1.Cluster")
	proto.RegisterType((*ClusterConfig)(nil), "google.cloud.dataproc.v1.ClusterConfig")
	proto.RegisterType((*GceClusterConfig)(nil), "google.cloud.dataproc.v1.GceClusterConfig")
	proto.RegisterType((*InstanceGroupConfig)(nil), "google.cloud.dataproc.v1.InstanceGroupConfig")
	proto.RegisterType((*ManagedGroupConfig)(nil), "google.cloud.dataproc.v1.ManagedGroupConfig")
	proto.RegisterType((*AcceleratorConfig)(nil), "google.cloud.dataproc.v1.AcceleratorConfig")
	proto.RegisterType((*DiskConfig)(nil), "google.cloud.dataproc.v1.DiskConfig")
	proto.RegisterType((*NodeInitializationAction)(nil), "google.cloud.dataproc.v1.NodeInitializationAction")
	proto.RegisterType((*ClusterStatus)(nil), "google.cloud.dataproc.v1.ClusterStatus")
	proto.RegisterType((*SoftwareConfig)(nil), "google.cloud.dataproc.v1.SoftwareConfig")
	proto.RegisterType((*ClusterMetrics)(nil), "google.cloud.dataproc.v1.ClusterMetrics")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.cloud.dataproc.v1.CreateClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.cloud.dataproc.v1.UpdateClusterRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.cloud.dataproc.v1.DeleteClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.cloud.dataproc.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.cloud.dataproc.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.cloud.dataproc.v1.ListClustersResponse")
	proto.RegisterType((*DiagnoseClusterRequest)(nil), "google.cloud.dataproc.v1.DiagnoseClusterRequest")
	proto.RegisterType((*DiagnoseClusterResults)(nil), "google.cloud.dataproc.v1.DiagnoseClusterResults")
	proto.RegisterEnum("google.cloud.dataproc.v1.ClusterStatus_State", ClusterStatus_State_name, ClusterStatus_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1.ClusterStatus_Substate", ClusterStatus_Substate_name, ClusterStatus_Substate_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterController service

type ClusterControllerClient interface {
	// Creates a cluster in a project.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type clusterControllerClient struct {
	cc *grpc.ClientConn
}

func NewClusterControllerClient(cc *grpc.ClientConn) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterController service

type ClusterControllerServer interface {
	// Creates a cluster in a project.
	CreateCluster(context.Context, *CreateClusterRequest) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*google_longrunning.Operation, error)
}

func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	s.RegisterService(&_ClusterController_serviceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/clusters.proto",
}

func init() { proto.RegisterFile("google/cloud/dataproc/v1/clusters.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1944 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcd, 0x73, 0x23, 0x47,
	0x15, 0xcf, 0x58, 0xfe, 0x90, 0x9f, 0x3e, 0x2c, 0x77, 0x1c, 0xa3, 0x28, 0x09, 0x71, 0x26, 0x81,
	0x75, 0x36, 0x20, 0xed, 0x3a, 0x50, 0x24, 0x6b, 0x12, 0xb0, 0x2d, 0xad, 0xd7, 0xc4, 0x96, 0xcd,
	0x48, 0xda, 0x24, 0x14, 0x30, 0xd5, 0x9a, 0x69, 0x6b, 0x1b, 0x8f, 0x66, 0x26, 0xd3, 0x3d, 0x4e,
	0xbc, 0x5b, 0x7b, 0xe1, 0x40, 0x15, 0x70, 0xa4, 0x8a, 0x33, 0x07, 0xa8, 0xa2, 0x72, 0x84, 0x1b,
	0xff, 0x00, 0x17, 0x8a, 0x0b, 0x47, 0xae, 0x9c, 0xf8, 0x2b, 0xa8, 0xfe, 0x18, 0x69, 0xc6, 0x5f,
	0x92, 0x97, 0xad, 0x9c, 0x34, 0xf3, 0xfa, 0xf7, 0xde, 0xfb, 0xf5, 0x7b, 0xaf, 0x5f, 0xbf, 0x11,
	0xdc, 0x1a, 0x04, 0xc1, 0xc0, 0x23, 0x0d, 0xc7, 0x0b, 0x62, 0xb7, 0xe1, 0x62, 0x8e, 0xc3, 0x28,
	0x70, 0x1a, 0xa7, 0x77, 0x1b, 0x8e, 0x17, 0x33, 0x4e, 0x22, 0x56, 0x0f, 0xa3, 0x80, 0x07, 0xa8,
	0xaa, 0x80, 0x75, 0x09, 0xac, 0x27, 0xc0, 0xfa, 0xe9, 0xdd, 0xda, 0xab, 0xda, 0x04, 0x0e, 0x69,
	0x03, 0xfb, 0x7e, 0xc0, 0x31, 0xa7, 0x81, 0xaf, 0xf5, 0x6a, 0x6f, 0x5f, 0xe9, 0x20, 0x08, 0x49,
	0x94, 0x81, 0xbe, 0xa9, 0xa1, 0x5e, 0xe0, 0x0f, 0xa2, 0xd8, 0xf7, 0xa9, 0x3f, 0xb8, 0x08, 0xfa,
	0xba, 0x06, 0xc9, 0xb7, 0x7e, 0x7c, 0xdc, 0x70, 0x63, 0x05, 0xd0, 0xeb, 0x6b, 0xe7, 0xd7, 0x8f,
	0x29, 0xf1, 0x5c, 0x7b, 0x88, 0xd9, 0x89, 0x46, 0xbc, 0x7e, 0x1e, 0xc1, 0xe9, 0x90, 0x30, 0x8e,
	0x87, 0xa1, 0x02, 0x98, 0xbf, 0x9a, 0x85, 0x85, 0x1d, 0xb5, 0x7b, 0xf4, 0x1a, 0x40, 0x18, 0x05,
	0xbf, 0x20, 0x0e, 0xb7, 0xa9, 0x5b, 0x35, 0xd6, 0x8c, 0xf5, 0x45, 0x6b, 0x51, 0x4b, 0xf6, 0x5c,
	0xf4, 0x06, 0x14, 0x75, 0x9c, 0x6c, 0x1f, 0x0f, 0x49, 0x75, 0x46, 0x02, 0x0a, 0x5a, 0xd6, 0xc6,
	0x43, 0x82, 0x7e, 0x00, 0xf3, 0x4e, 0xe0, 0x1f, 0xd3, 0x41, 0x35, 0xb7, 0x66, 0xac, 0x17, 0x36,
	0x6e, 0xd5, 0xaf, 0x8a, 0x64, 0x5d, 0x3b, 0xdd, 0x91, 0x70, 0x4b, 0xab, 0xa1, 0x16, 0xcc, 0x7b,
	0xb8, 0x4f, 0x3c, 0x56, 0xcd, 0xaf, 0xe5, 0xd6, 0x0b, 0x1b, 0xdf, 0x9e, 0x68, 0xa0, 0xbe, 0x2f,
	0xf1, 0x2d, 0x9f, 0x47, 0x67, 0x96, 0x56, 0x16, 0x3c, 0x18, 0xc7, 0x3c, 0x66, 0xd5, 0xd9, 0x29,
	0x79, 0x74, 0x24, 0xdc, 0xd2, 0x6a, 0xa8, 0x0d, 0x65, 0xf5, 0x64, 0x3f, 0xa2, 0x8c, 0x07, 0xd1,
	0x59, 0x75, 0x41, 0xf2, 0x99, 0xda, 0x50, 0x49, 0xa9, 0x3f, 0x50, 0xda, 0xe9, 0xd8, 0xc5, 0x31,
	0x75, 0xab, 0xf3, 0x99, 0xd8, 0xf5, 0x62, 0xea, 0xa2, 0x6d, 0x58, 0x18, 0x12, 0x1e, 0x51, 0x87,
	0x55, 0x17, 0x25, 0xe9, 0xf5, 0x89, 0xbe, 0x0e, 0x14, 0xde, 0x4a, 0x14, 0x6b, 0xef, 0x43, 0x21,
	0x15, 0x0e, 0x54, 0x81, 0xdc, 0x09, 0x39, 0xd3, 0x99, 0x14, 0x8f, 0x68, 0x05, 0xe6, 0x4e, 0xb1,
	0x17, 0x27, 0xc9, 0x53, 0x2f, 0xf7, 0x66, 0xde, 0x33, 0xcc, 0x7f, 0xcf, 0x42, 0x29, 0x93, 0x13,
	0xf4, 0x26, 0x94, 0x54, 0x56, 0xec, 0x7e, 0xec, 0x9c, 0x10, 0xae, 0xed, 0x14, 0x95, 0x70, 0x5b,
	0xca, 0xd0, 0x27, 0x80, 0x06, 0x0e, 0xb1, 0x93, 0xcd, 0xe9, 0xec, 0xe7, 0xe5, 0x06, 0x6e, 0x5f,
	0xbd, 0x81, 0x5d, 0x87, 0x64, 0x0b, 0xa0, 0x32, 0x38, 0x27, 0x41, 0x16, 0x94, 0x86, 0x38, 0x6d,
	0x54, 0x45, 0xe5, 0x9a, 0x8a, 0xd8, 0xf3, 0x19, 0xc7, 0xbe, 0x43, 0x76, 0xa3, 0x20, 0x0e, 0xb5,
	0xdd, 0xa2, 0xb2, 0x31, 0xb6, 0xf9, 0x79, 0x10, 0x9d, 0x8c, 0x6d, 0xc2, 0x33, 0xd9, 0x54, 0x36,
	0xb4, 0x4d, 0x02, 0x5f, 0x63, 0xc4, 0x09, 0x7c, 0x17, 0x47, 0x67, 0x76, 0xd6, 0x7a, 0xf1, 0x59,
	0xac, 0xbf, 0x34, 0xb2, 0xf6, 0x71, 0xda, 0xcd, 0x8f, 0x61, 0x89, 0x05, 0xc7, 0xfc, 0x73, 0x1c,
	0x91, 0xc4, 0x7c, 0x69, 0x52, 0x99, 0x74, 0xb4, 0x82, 0xb6, 0x5c, 0x66, 0x99, 0x77, 0x44, 0x61,
	0x95, 0xfa, 0x94, 0x53, 0xec, 0xd1, 0xc7, 0xb2, 0xad, 0xd8, 0xd8, 0x91, 0xed, 0xa7, 0x5a, 0x90,
	0xc5, 0xbe, 0x71, 0xb5, 0xe5, 0x76, 0xe0, 0x92, 0xbd, 0x8c, 0xee, 0x96, 0x54, 0xb5, 0x5e, 0xa2,
	0x97, 0x48, 0x99, 0xf9, 0xa7, 0x1c, 0x54, 0xce, 0xe7, 0x1c, 0xbd, 0x0c, 0xf9, 0xc7, 0x81, 0x4f,
	0xec, 0x38, 0xa2, 0xba, 0xb6, 0x16, 0xc4, 0x7b, 0x2f, 0xa2, 0xe8, 0x75, 0x28, 0xf8, 0x84, 0x8b,
	0x68, 0xca, 0x55, 0x55, 0xad, 0xa0, 0x45, 0x02, 0xf0, 0x0d, 0x28, 0xb3, 0xb8, 0x9f, 0xc6, 0xa8,
	0x23, 0x55, 0x1a, 0x4b, 0x05, 0x6c, 0x1d, 0x2a, 0xd4, 0xe7, 0x24, 0xf2, 0xb1, 0x67, 0xd3, 0xd0,
	0x0e, 0x7c, 0x4f, 0x9c, 0x64, 0x63, 0x3d, 0x6f, 0x95, 0x13, 0xf9, 0x5e, 0x78, 0xe8, 0x7b, 0x67,
	0xe8, 0x16, 0x2c, 0x31, 0x12, 0x9d, 0x52, 0x87, 0xd8, 0xd8, 0x71, 0x82, 0xd8, 0xe7, 0xb2, 0x8a,
	0x17, 0xad, 0xb2, 0x16, 0x6f, 0x29, 0x29, 0xfa, 0x0e, 0xac, 0x9e, 0x03, 0xda, 0xcc, 0x09, 0x42,
	0xc2, 0xaa, 0xb9, 0xb5, 0xdc, 0xfa, 0xa2, 0xb5, 0x92, 0xc5, 0x77, 0xe4, 0x1a, 0x42, 0x30, 0xcb,
	0xf1, 0x40, 0xf4, 0x23, 0x81, 0x91, 0xcf, 0xa8, 0x0b, 0xf9, 0x21, 0xe1, 0x58, 0xc4, 0xb5, 0x3a,
	0x27, 0x23, 0xfe, 0xde, 0xf4, 0x27, 0xa6, 0x7e, 0xa0, 0x55, 0x55, 0xe7, 0x1b, 0x59, 0xaa, 0x6d,
	0x42, 0x29, 0xb3, 0x74, 0xa3, 0x2e, 0xf0, 0xf7, 0x1c, 0xbc, 0x78, 0x49, 0x51, 0x8a, 0x5e, 0xe0,
	0xc7, 0x43, 0x9b, 0xea, 0x25, 0x26, 0xad, 0xcd, 0x59, 0x45, 0x3f, 0x1e, 0x26, 0x70, 0x26, 0x72,
	0x92, 0x00, 0xe4, 0x0d, 0xc1, 0xaa, 0x33, 0x72, 0xb7, 0xa5, 0x44, 0x2a, 0xee, 0x08, 0x86, 0x5e,
	0x81, 0x45, 0x3a, 0xc4, 0x03, 0x95, 0xf7, 0x9c, 0x64, 0x90, 0x97, 0x02, 0x9d, 0xb0, 0x21, 0x76,
	0x1e, 0x51, 0x9f, 0xd8, 0xfc, 0x2c, 0x54, 0x98, 0x59, 0x95, 0x07, 0x2d, 0xef, 0x9e, 0x85, 0x12,
	0xd9, 0x82, 0x82, 0x4b, 0xd9, 0x49, 0x72, 0x18, 0xe6, 0xe4, 0x61, 0x78, 0xeb, 0xea, 0x00, 0x36,
	0x29, 0x3b, 0xd1, 0x07, 0x01, 0xdc, 0xd1, 0xb3, 0x24, 0xcd, 0xec, 0x30, 0x22, 0x64, 0x18, 0x72,
	0xda, 0xf7, 0x88, 0x2c, 0xa4, 0xbc, 0x55, 0xa2, 0xec, 0x68, 0x2c, 0x44, 0x3f, 0x87, 0x95, 0x21,
	0xf6, 0xf1, 0x80, 0xb8, 0xf6, 0x40, 0xc4, 0x25, 0x71, 0xbb, 0x20, 0xdd, 0x7e, 0xeb, 0x6a, 0xb7,
	0x07, 0x4a, 0x2b, 0x7d, 0xc2, 0xd1, 0xf0, 0x82, 0x0c, 0x1d, 0x42, 0x11, 0x3b, 0x0e, 0xf1, 0xc4,
	0x04, 0x10, 0x44, 0xc9, 0xf5, 0xf7, 0xce, 0xd5, 0x76, 0xb7, 0xc6, 0xe8, 0xa4, 0x2d, 0xa5, 0x0d,
	0x98, 0xbf, 0x36, 0x00, 0x5d, 0xf4, 0x2d, 0xaa, 0x77, 0x94, 0x23, 0x4e, 0x86, 0xa1, 0x87, 0xb9,
	0x4a, 0x96, 0xae, 0x8f, 0x95, 0x64, 0xb5, 0xab, 0x17, 0xe5, 0xbd, 0xfe, 0x01, 0xbc, 0x32, 0xd2,
	0x52, 0xdb, 0x57, 0x5b, 0xc8, 0x4c, 0x02, 0x55, 0x9a, 0x2e, 0x1c, 0xe5, 0x5b, 0x8e, 0x05, 0x66,
	0x04, 0xcb, 0x17, 0xe8, 0xa2, 0x3b, 0xb0, 0x92, 0x22, 0x3c, 0xce, 0xb6, 0xe2, 0x81, 0x52, 0x6b,
	0x49, 0xc6, 0xdf, 0x81, 0xe5, 0xb4, 0x86, 0x3a, 0xa4, 0x33, 0xb2, 0x10, 0x2b, 0x38, 0x6d, 0x3f,
	0xf6, 0xb9, 0xf9, 0x33, 0x80, 0x71, 0xc6, 0xd1, 0xdb, 0xb0, 0xdc, 0x0f, 0x02, 0x6e, 0xcb, 0x8a,
	0x61, 0xf4, 0x31, 0xb1, 0x07, 0x7d, 0x5d, 0xc3, 0x65, 0xb1, 0x20, 0xa0, 0x1d, 0xfa, 0x98, 0xec,
	0xf6, 0xd1, 0x5b, 0x50, 0x16, 0xa5, 0xee, 0x05, 0x0e, 0xf6, 0x6c, 0xc6, 0x5c, 0xa6, 0x5d, 0x88,
	0x5a, 0xdf, 0x17, 0xc2, 0x0e, 0x73, 0x99, 0xf9, 0x5b, 0x03, 0xaa, 0x57, 0x35, 0x41, 0xd1, 0x4b,
	0xc8, 0x17, 0xc4, 0x89, 0x39, 0xee, 0x7b, 0xc4, 0x3e, 0xa6, 0x5e, 0x12, 0xdd, 0xf2, 0x58, 0x7c,
	0x9f, 0x7a, 0x04, 0xdd, 0x87, 0x65, 0x25, 0x11, 0xcd, 0x57, 0x8c, 0x66, 0x41, 0xac, 0x76, 0x54,
	0xd8, 0x78, 0x39, 0x49, 0x7d, 0x32, 0xba, 0xd5, 0x9b, 0x7a, 0xf8, 0xb3, 0x2a, 0x23, 0x9d, 0xae,
	0x52, 0x31, 0x7f, 0x9f, 0x1b, 0x5d, 0xde, 0x6a, 0xfe, 0x40, 0x3b, 0x30, 0x27, 0x26, 0x10, 0xe5,
	0xb8, 0x3c, 0xc5, 0x1c, 0xa5, 0xf4, 0xea, 0xe2, 0x87, 0x58, 0x4a, 0x17, 0xad, 0xc2, 0xbc, 0x4b,
	0x38, 0xa6, 0x9e, 0xce, 0xb0, 0x7e, 0x43, 0x4d, 0xa8, 0x48, 0x80, 0xcd, 0x38, 0x8e, 0xb8, 0x24,
	0xae, 0x07, 0xbe, 0xda, 0x05, 0xd6, 0xdd, 0x64, 0xe0, 0xb4, 0xe4, 0x44, 0x45, 0x3a, 0x42, 0x45,
	0x08, 0xd1, 0x3e, 0xe4, 0x59, 0xdc, 0x57, 0x2c, 0x67, 0x25, 0xcb, 0x3b, 0x53, 0xb3, 0xd4, 0x7a,
	0xd6, 0xc8, 0x82, 0xf9, 0x10, 0xe6, 0x24, 0x77, 0x54, 0x80, 0x85, 0x5e, 0xfb, 0xa3, 0xf6, 0xe1,
	0xc7, 0xed, 0xca, 0x0b, 0xa8, 0x08, 0xf9, 0x1d, 0xab, 0xb5, 0xd5, 0xdd, 0x6b, 0xef, 0x56, 0x0c,
	0xb1, 0x64, 0xf5, 0xda, 0x6d, 0xf1, 0x32, 0x83, 0x16, 0x61, 0xae, 0x65, 0x59, 0x87, 0x56, 0x25,
	0x27, 0x50, 0xcd, 0xd6, 0x7e, 0x4b, 0xa2, 0x66, 0xc5, 0x5b, 0xef, 0xa8, 0xa9, 0x74, 0xe6, 0xcc,
	0xef, 0x43, 0x3e, 0xf1, 0x86, 0x96, 0xa0, 0xd0, 0x6b, 0x77, 0x8e, 0x5a, 0x3b, 0x7b, 0xf7, 0xf7,
	0x5a, 0xcd, 0xca, 0x0b, 0xa8, 0x04, 0x8b, 0xbd, 0xf6, 0x83, 0xd6, 0xd6, 0x7e, 0xf7, 0xc1, 0xa7,
	0x15, 0x03, 0x55, 0xa0, 0xd8, 0xe9, 0x6e, 0xed, 0xb7, 0xec, 0x4e, 0x77, 0xab, 0xdb, 0xeb, 0x54,
	0x66, 0xcc, 0x7f, 0x1a, 0x50, 0xce, 0xde, 0xc2, 0xa2, 0x95, 0xaa, 0xf6, 0x77, 0x4a, 0x22, 0x46,
	0x03, 0x3f, 0x19, 0xab, 0xa4, 0xf0, 0xa1, 0x92, 0xa1, 0x4f, 0xe4, 0x28, 0x1e, 0x92, 0x88, 0x53,
	0xdd, 0x46, 0xaf, 0xbd, 0x1c, 0xb2, 0x2e, 0xea, 0x47, 0x23, 0x55, 0x75, 0x39, 0xa4, 0x6c, 0xd5,
	0x3e, 0x80, 0xa5, 0x73, 0xcb, 0x37, 0xba, 0x20, 0xfe, 0x31, 0x03, 0xe5, 0xec, 0xf4, 0x89, 0x7e,
	0x0a, 0xc5, 0x47, 0xee, 0x31, 0xb3, 0x93, 0xe9, 0xd5, 0x90, 0x6c, 0xdf, 0x9f, 0x76, 0x7a, 0xad,
	0x3f, 0x70, 0x8f, 0x99, 0x7e, 0x56, 0x74, 0x0b, 0x8f, 0xc6, 0x12, 0x61, 0xfd, 0x0c, 0x47, 0xfe,
	0xc8, 0xfa, 0xcc, 0x0d, 0xad, 0x7f, 0x8a, 0x23, 0x3f, 0x6b, 0xfd, 0x6c, 0x2c, 0xa9, 0x7d, 0x08,
	0x95, 0xf3, 0xee, 0x27, 0x85, 0x23, 0x97, 0x0a, 0x87, 0xd0, 0x3f, 0xef, 0xe0, 0x26, 0xfa, 0xe6,
	0x6f, 0x0c, 0x58, 0xd9, 0x89, 0x08, 0xe6, 0xc9, 0xe5, 0x6e, 0x91, 0xcf, 0x62, 0xc2, 0xf8, 0xa4,
	0x6f, 0xb1, 0x55, 0x98, 0x8f, 0xc8, 0x40, 0x54, 0x8f, 0xba, 0x40, 0xf5, 0x1b, 0xda, 0x84, 0x05,
	0x3d, 0x8a, 0xeb, 0x36, 0xf2, 0xc6, 0xc4, 0x40, 0x59, 0x89, 0x86, 0xf9, 0x5f, 0x03, 0x56, 0x7a,
	0xa1, 0xfb, 0x7f, 0x90, 0x99, 0xcb, 0x90, 0x99, 0xe2, 0x83, 0x31, 0xc5, 0x37, 0x77, 0x53, 0xbe,
	0x68, 0x13, 0x0a, 0xb1, 0xa4, 0x2b, 0xbf, 0x78, 0xf5, 0xa7, 0xde, 0xc5, 0x0e, 0x74, 0x5f, 0x7c,
	0x14, 0x1f, 0x60, 0x76, 0x62, 0x81, 0x82, 0x8b, 0x67, 0x33, 0x84, 0x95, 0x26, 0xf1, 0xc8, 0xf3,
	0x0a, 0xfc, 0xe4, 0xbd, 0x9a, 0x43, 0x58, 0xde, 0x25, 0xfc, 0x2b, 0x73, 0xf7, 0x07, 0x03, 0x5e,
	0xdc, 0xa7, 0x2c, 0x71, 0xc8, 0x6e, 0xec, 0x71, 0x36, 0xe3, 0x71, 0x15, 0xe6, 0x8f, 0xa9, 0x27,
	0x12, 0xa5, 0x93, 0xac, 0xde, 0xc4, 0x34, 0x17, 0x8a, 0x6e, 0x26, 0x2e, 0x55, 0x7d, 0x53, 0xe6,
	0x85, 0x40, 0xdc, 0xa6, 0xd2, 0x97, 0x58, 0xe4, 0xc1, 0x09, 0x49, 0xb6, 0x20, 0xe1, 0x5d, 0x21,
	0x30, 0x9f, 0xc2, 0x4a, 0x96, 0x21, 0x0b, 0x03, 0x9f, 0x89, 0x71, 0x23, 0x9f, 0xfc, 0x23, 0xa3,
	0xbb, 0xc9, 0x14, 0x65, 0x31, 0x52, 0x41, 0xdf, 0x84, 0x25, 0x9f, 0x7c, 0xc1, 0xed, 0x94, 0x6b,
	0x15, 0x9f, 0x92, 0x10, 0x1f, 0x8d, 0xdc, 0x47, 0xb0, 0xda, 0xa4, 0x78, 0xe0, 0x07, 0xec, 0xab,
	0x2b, 0x82, 0xef, 0x5d, 0xe2, 0x93, 0xc5, 0x1e, 0x67, 0xc2, 0x67, 0x10, 0xf3, 0x30, 0xe6, 0xa9,
	0x29, 0x68, 0x51, 0x49, 0x7a, 0x11, 0xdd, 0xf8, 0x4b, 0x1e, 0x96, 0xc7, 0x1f, 0x00, 0x3c, 0x0a,
	0x3c, 0x8f, 0x44, 0xe8, 0x8f, 0x06, 0x94, 0x32, 0xfd, 0x03, 0xd5, 0xaf, 0x89, 0xd4, 0x25, 0x8d,
	0xa6, 0xf6, 0x5a, 0x82, 0x4f, 0xfd, 0x13, 0x55, 0x3f, 0x4c, 0xfe, 0x89, 0x32, 0x9b, 0xbf, 0xfc,
	0xd7, 0x7f, 0x7e, 0x37, 0xf3, 0xa1, 0xf9, 0x6e, 0xe3, 0xf4, 0x6e, 0x43, 0x47, 0x80, 0x35, 0x9e,
	0x8c, 0xa3, 0xf3, 0xb4, 0xa1, 0x36, 0xcf, 0x1a, 0x4f, 0xd4, 0xc3, 0xd3, 0xd1, 0xbf, 0x69, 0xf7,
	0x46, 0x27, 0xf5, 0xaf, 0x06, 0x94, 0x32, 0x9d, 0xe5, 0x3a, 0x9a, 0x97, 0xb5, 0xa0, 0x49, 0x34,
	0x3b, 0x92, 0xe6, 0xc1, 0xc6, 0xf6, 0x33, 0xd0, 0x6c, 0x3c, 0x49, 0x27, 0xed, 0xe9, 0x98, 0xf5,
	0x97, 0x06, 0x94, 0x32, 0x3d, 0xe2, 0x3a, 0xd6, 0x97, 0x35, 0x93, 0x49, 0xac, 0x7f, 0x24, 0x59,
	0x37, 0x6f, 0x3f, 0x07, 0xd6, 0xe8, 0xcf, 0x06, 0xc0, 0xb8, 0xbd, 0xa0, 0x6b, 0xbe, 0x1c, 0x2e,
	0x34, 0xa1, 0xda, 0xe4, 0xd3, 0x95, 0x50, 0x45, 0xcf, 0x83, 0xea, 0x97, 0x06, 0x14, 0xd3, 0xe7,
	0x1e, 0x5d, 0x33, 0x9d, 0x5e, 0xd2, 0xc1, 0x6a, 0xf5, 0x69, 0xe1, 0xaa, 0x9d, 0x98, 0x9b, 0x92,
	0xfb, 0x77, 0xd1, 0xb3, 0xd4, 0x30, 0xfa, 0x9b, 0x01, 0x4b, 0xe7, 0x4e, 0x2c, 0xba, 0x73, 0xdd,
	0x57, 0xe6, 0x65, 0x0d, 0x65, 0x52, 0x21, 0x3c, 0x94, 0x0c, 0x8f, 0xcc, 0x8f, 0x9e, 0x43, 0xf9,
	0xba, 0x9a, 0xc1, 0x3d, 0xe3, 0xf6, 0xf6, 0x67, 0xf0, 0xaa, 0x13, 0x0c, 0xaf, 0x64, 0xbb, 0x9d,
	0x7c, 0x34, 0xb0, 0x23, 0x71, 0x59, 0x1e, 0x19, 0x3f, 0xf9, 0xa1, 0x86, 0x0e, 0x02, 0x0f, 0xfb,
	0x83, 0x7a, 0x10, 0x0d, 0x1a, 0x03, 0xe2, 0xcb, 0xab, 0xb4, 0xa1, 0x96, 0x70, 0x48, 0xd9, 0xc5,
	0x3f, 0xb8, 0x37, 0x93, 0xe7, 0xfe, 0xbc, 0x04, 0xbf, 0xfb, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xe5, 0xf5, 0x02, 0xd0, 0x6d, 0x17, 0x00, 0x00,
}
