#! /usr/bin/perl 

#makes programm work AFTER install 
use lib qw( /usr/lib/perl );

use RRDs;
use FileHandle;
use IO::Handle;

# this simpulates a standard mrtg-2.x setup ... we can use this to
# compare performance ...

$main::DEBUG=0;
$delay = 5;
$nhosts = 9;
$rrd = "loads.rrd";
$gif = "loads.gif";
$png = "loads.png";

$start = time();

print "Creating RRD for load1/load5/load15 at time = $start\n";

RRDs::create ($rrd, "--start",$start, "--step",$delay,
      "DS:load1:GAUGE:10:U:U",
      "DS:load5:GAUGE:10:U:U",
      "DS:load15:GAUGE:10:U:U",
      "RRA:AVERAGE:0.5:1:10");
my $ERROR = RRDs::error;
die "$0: unable to create `$rrd': $ERROR\n" if $ERROR;

print "Filling RRD with 9 values from wulflogger in a delayed loop.\n";

open(STDIN ,"./wulflogger -t 1 -d $delay | ") || die "Sorry, I couldn't open stdin: $!\n";
# open(STDIN ,"<-") || die "Sorry, I couldn't open stdin: $!\n";
while(<STDIN>){
  chop;
  if(!/^#/){
    @fields =  split(/\s+/,$_);
    ($node,$stat,$time,$load1,$load5,$load15) = split(/\s+/,$_);
    $time = int($time);
    print "$node: $stat $time $load1 $load5 $load15\n";
    RRDs::update $rrd, "$time:$load1:$load5:$load15";
    if ($ERROR = RRDs::error) {
      die "$0: unable to update `$rrd': $ERROR\n";
    }
    RRDs::graph "localhost.png",
      "--title", 'localhost Loads', 
      "--start", $start,
      "--end", $time,
      "--interlace", 
      "--imgformat","PNG",
      "--width=450",
      "DEF:load1=$rrd:load1:AVERAGE",
      "DEF:load5=$rrd:load5:AVERAGE",
      "DEF:load15=$rrd:load15:AVERAGE",
      "LINE1:load1#ff4400:load1 envelope\\c",
      "LINE1:load5#22FF00:load5 envelope\\c",
      "LINE1:load15#0011FF:load15 envelope\\c";
    if ($ERROR = RRDs::error) {
      print "ERROR: $ERROR\n";
    };

  }

}
    
