/*
*  Rubrica
*  file: 
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <glade/glade.h>

#include "libral.h"

#ifndef RUBRICA_TYPES_H
#define RUBRICA_TYPES_H

#define RUBRICA_GET_ENTRY(x) g_strdup(gtk_entry_get_text(GTK_ENTRY(x)))
#define RUBRICA_GET_CHECK(x) gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(x))


typedef enum {
  VAL_STRING,
  VAL_INT
} valtype;


/** Models **/
typedef enum {
  ADDRESS_MODEL,
  NET_MODEL,
  TELEPHONE_MODEL,
  INFO_MODEL,
} RubricaModelType;


/** Columns types **/
typedef enum {
  ADDRESS_COLUMNS,
  URI_COLUMNS,  
  TELEPHONE_COLUMNS,
  INFO_COLUMNS,
} RubricaColumnsType;



/*  PersonalCardColumns
 */
typedef enum {
  CARD_COLUMN = 0,
  FIRST_NAME_COLUMN,
  LAST_NAME_COLUMN,
  PROFESSION_COLUMN,
  CITY_COLUMN,
  COUNTRY_COLUMN,
  WEB_CARD_COLUMN,
  EMAIL_CARD_COLUMN,
  TELEPHONE_COLUMN,
  COMPANY_COLUMN,
  ASSIGNMENT_COLUMN,
  ID_COLUMN,
  COLUMNS
} PersonalCardColumns;


/*  RubricaGroupColumnType
*/
typedef enum {
  GROUP_BELONG_COLUMN = 0,       // card belongs to this group
  GROUP_PIXMAP_COLUMN,           // group pixmap
  GROUP_NAME_COLUMN,             // group name 
  GROUP_LABEL_COLUMN,            // group label
  GROUP_OWNER_COLUMN,            // group owner (hidden column) 
  GROUP_PIXMAP_PATH,             // group pixmap's path
  GROUP_ID,                      // group's id 
  GROUP_LAST_COLUMN               
} RubricaGroupColumnType;



/*  RubricaAddressColumnType
    columns in address model/treeview 
 */
typedef enum {
  ADDRESS_STREET_COLUMN = 0,    // visible
  ADDRESS_NUMBER_COLUMN,        // visible
  ADDRESS_CITY_COLUMN,          // visible
  ADDRESS_LABEL_COLUMN,         // visible
  ADDRESS_TYPE_COLUMN,          // hidden
  ADDRESS_ZIP_COLUMN,           // hidden
  ADDRESS_PROVINCE_COLUMN,      // hidden
  ADDRESS_STATE_COLUMN,         // hidden
  ADDRESS_COUNTRY_COLUMN,       // hidden
  LAST_ADDRESS_COLUMN
} RubricaAddressColumnType;


/*  RubricaNetColumnType
    colums in net model/treeview 
 */
typedef enum {
  URI_COLUMN = 0,
  URI_TYPE_COLUMN,
  LAST_NET_COLUMN
} RubricaNetColumnType;


/*  RubricaPhoneColumnType
    columns in telephone model/treeview 
*/
typedef enum {
  TELEPHONE_NUMBER_COLUMN = 0,
  TELEPHONE_TYPE_COLUMN,
  LAST_TEL_COLUMN
} RubricaPhoneColumnType;


/*  RubricaInfoColumnType
*/
typedef enum {
  INFO_CARD_LABEL_COLUMN = 0,
  INFO_FIRST_NAME_COLUMN,
  INFO_LAST_NAME_COLUMN,
  INFO_ASSIGNMENT_COLUMN,
  INFO_TELEPHONE_COLUMN,
  INFO_EMAIL_COLUMN,
  INFO_ID_COLUMN,
  LAST_INFO_COLUMN
} RubricaInfoColumnType;


/*  RubricaGroupType
*/
typedef enum {
  NO_GROUP         = 0,
  ALL_GROUP,
  FAVORITES_GROUP,
  HOT_GROUP,
  FRIENDS_GROUP,
  HEART_GROUP, 
  RELATIVES_GROUP,
  HOLIDAYS_GROUP,
  HOBBIES_GROUP,
  SPORT_GROUP,
  BUSSINES_GROUP,
  COMPANY_GROUP,
  WORK_GROUP,
  CUSTOMER_GROUP,
  STRATEGIES_GROUP,
  PROGRAMMERS_GROUP,
  BSD_GROUP,
  PLUTO_GROUP
} RubricaGroupType;


/*  RubricaComboColumnType
*/
typedef enum {
  COMBO_PIXMAP,
  COMBO_LABEL,
  COMBO_LAST_COLUMN
} RubricaComboColumnType;



typedef enum {
  WEB_LINK,
  EMAIL_LINK,
  IRC_LINK,
  TELEPHONE_LINK,
  UNKNOWN_LINK
} RubricaLinkType;


typedef enum {
  PIXMAP_RATE_NONE = R_RATE_NONE,
  PIXMAP_RATE_FEW,
  PIXMAP_RATE_NORMAL,
  PIXMAP_RATE_HIGHT,
  PIXMAP_RATE_VERY_HIGHT,
  PIXMAP_UNLOCK,
  PIXMAP_LOCK
} RubricaPixmap;



typedef struct {
  gchar* label;
  gchar* icon;
  gchar* exec;
} RubricaThemedItem;


typedef struct {
  gchar* uri;
  RubricaLinkType type;
} RubricaLink;


typedef struct {
  gchar* pixmap;
  gchar* name;
  gchar* label;
} RubricaDefaultCategories;


typedef struct {
  SearchType type;

  gint first;           // date/first date
  gint second;          // second date
} RubricaSearch;


typedef struct  {
  gchar* icon;
  gchar* label;
} RubricaCombo;



#endif
