# Announce: Rakudo Perl 6 compiler, Release #107 (2017.01)

On behalf of the Rakudo development team, I’m very happy to announce the
January 2017 release of Rakudo Perl 6 #107. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.01:
 + Fixes:
    + Fixed importing globals nested in imported packages [85d8b14]
    + Fixed "Object of type A in QAST::Var value, but not in SC" [43d20eb]
    + Fixed use Foo::Bar; class Foo {my Foo::Bar $bar} not finding Foo::Bar [5c4db5e]
    + Fixed class Foo { use Foo::Bar; my Foo $foo; } not finding Foo [226cb36]
    + Fixed our scoped nested package swallowed by lexically scoped parent [85b9d8a]
    + Fixed imported nested enum colliding with symbols from outer scope [a962928]
    + Multiple methods that return listy things now throw instead of failing to
        avoid accidental Failure silencing through 1-elem lists [99e33fc][bd4e1f4]
    + Made List.roll always return a Seq [bd4e1f4]
    + Fixed SEGVs and GC panics in certain deep recursions [58c79e2]
    + Fixed detection of runtime errors in threads [b8df3a6]
    + Made sure .sort on shaped arrays uses the leaves [a4bc51a]
    + Made U+2212 infix:<−> and prefix:<−> same as regular `-` for all types [91af128]
    + Made sub MAIN usage ignore anon *% param [38ec79c]
    + Fixed lack of warning on unitilized values in infix:<x> [c498d5b]
    + Fixed Distribution::Path bin/resources file format [393afcf]
    + Fixed spurious warnings in List.reduce [1ee24cc]
    + Sorting uninitialized List now returns a new list [005166e]
    + Made .sort always return a .Seq [434bf75]
    + Fixed combinations() incorrectly returning 1-item list in some cases [d86c419]
    + Made combinations() always return a Seq on succcess [db1836a]
    + Fixed useless "useless use" warnings in hypered ++ and -- [7193df1]
    + Fixed numerous bugs with $limit in lines() [19df358]
    + Fixed regression with mutability of .pairs on shaped arrays [dc7b688]
    + Fixed regression with infinite lists assignment to shaped arrays [aa35065]
    + Fixed regression with looping over uninitialized shaped array [696b1f4]
    + Fixed regression with regex match against NFC [8d35951]
    + Fixed infix:<cmp> with 0-denominator rationals [a567eb4]
    + Fixed crashes in X::OutOfRange reporting with 0-denominator rationals [b2332c2]
    + Fixed &infix:<==> on 0-denominator rationals [73182d4]
    + Fixed &infix:<===> on 0-denominator rationals [cb2476f]
    + Fixed incorrect .isNaN result for 0/0 rationals [7434a8f]
    + Fixed IO::Socket::INET.new not parsing IPv6 URLs
        correctly [cb9ec03][df20d8b][fbd061b][8751f05]
    + Made IO::Socket::INET.new fail when invalid port or family is given [cb9ec03]
    + Fixed Range.AT-POS on int ranges failing for too-high indexes [c5e54ef]
    + Fixed (^) set operator on Baggies to take weights into account [a687d95]
    + Fixed incorrect dispatch in some cases of multi subs with where clauses [0c0dd82]
    + Fixed unwanted role punning due to attached Pod [d487657]
    + Made Routine.prec(key) return '' rather than Nil on fail [d7d76b7]
    + Moved .prec from Routine to Code [a7ccfc6]
    + Fixed an occasional heap profiler crash, and prevent heap profiler
        from greatly reducing the number of full GC collections [e182deb]
    + Fixed specializer log slots keeping alive, and so leaking,
        objects once specialized code has been produced [e182deb]
    + Fixed build under some versions of MSVC [e182deb]
    + Fixed code-gen bug in dispatch:<hyper> [3d86286][ba8a284]
    + Fixed `1,*,3 Z~ <a b c>` case using Whatever value for the rest of list [471f4ba]
    + Fixed threading issues in ||=, //=, and &&= [d1c2e76]
    + Fixed GC in spesh triggered by managed mutex use [25615c7]
    + Fixed bugs in interaction between inlining, GC, and threads [25615c7]
    + Fixed endpoint-exclusion on string ranges with non-alphanumeric chars [daf7e51]
    + Fixed fatality of Nil.chomp/chop (back to just a warning) [7c81bec]
    + Fixed infix:<eqv> on NaN and signed zeros [3f80e13]
    + Fixed crash in infix:<cmp> when comparing Real and RatStr [8ec54ba]
    + [TEST] Test.pm tests no longer backslash every backslash in descriptions [b183cab]
    + [TEST] Fixed TAP::Harness parsing of single backslashes in test descriptions [b120ac4]
    + [TEST] Fixed TAP::Harness failing to parse full-file skip directive [aee7af3]
    + [UNI] Fixed `ISO_Comment` property in uniprop [4ff2fb2]
    + [UNI] Fixed uniname() on "\x[80]", "\0" and other controls [8163113]
    + [UNI] Made unival() use full Unicode names for Numeric_Value_* [dbbf9dd]
    + [UNI] Fixed several aliases for Unicode characters [5ba982a][644cd34]
    + [UNI] Fixed number of characters reported for hundreds of Unicode Emoji [823f0f7]
    + [UNI] Fixed compilation of /:ignoremark \"/ to actually ignore marks [6188771]
    + [UNI] Fixed mismatched closers on U+298D/U+2990/U+298E/U+298F brackets [76283f6]
    + [UNI] Fixed return value of uniprop Bidi_Mirroring_Glyph if no BMG [48e8ccc]
    + [UNI] Fixed breaking after Prepend characters [7c8b705]
    + [JVM] Fixed build issues [7bba13a][adcfb8b][e6ccb47][29f487e]
        [fb4f161][4320fdc][39bf63f]
    + Assorted improvements in error reporting
 + Additions:
    + Made importing globals from loaded modules lexical [4b529c8]
    + Added degenerate Any.match [3fe5893][cc0f836]
    + Added infix +/- for DateTime/Duration [6b850ba]
    + parse-base() now allows for omitted whole part [3282813]
    + Using a Bool:D literal as type constraint in signatures now warns [b01dfcd]
    + Made Bool.ACCEPTS work with Junctions [9fc616f]
    + Made Proc::Async sub-class friendly [a2cc58a][1dc0c01]
    + Implemented .clone for SetHash, BagHash, and MixHash [1ee9c82]
    + Implemented .List on shaped arrays [8568dd1]
    + Added own .perl method to Empty [ec0258a]
    + Made Inf and Whatever work as part of rotor()'s cycle [7ddc5f7]
    + Made it possible to use Inf and Whatever in .head and .tail [93b0ffa]
    + Implemented `next` in `whenever` blocks [f97d5c2]
    + [TEST] Test::is() now handles Mu types [268dc92]
    + [UNI] uniprop now handles Emoji properties [3baffe7]
    + [UNI] Implemented Bidi_Mirroring_Glyph as an integer property [7c8b705]
    + [UNI] Implemented Emoji grapheme breaking and other combined codes [7c8b705]
    + [UNI] Added Emoji Unicode properties [7c8b705]
    + [UNI] Added secondary and tertiary Unicode collation support [ee38721]
    + [UNI] Re-implemented UTF8-C8 streaming decode [7c8b705][ee38721][e182deb]
    + [UNI] Made all Nd chars accepted in ${} special variables [eba3fe0]
    + [UNI] Made all Nd chars accepted as regex quantifiers [e40a129]
 + Removals:
    + [UNI] Unicode 1 character names are now deprecated and issue a warning [e7c1d51]
    + Removed IO::Path:U.chdir candidate on account of it being a footgun [94df18c]
 + Efficiency:
    + [UNI] Made unival() slightly faster for repeated lookups [dbbf9dd]
    + [UNI] Made decoding UTF-8 text 14% faster [528ec53]
    + Made improvements to memory management of various aspects of invocation records
        (aka call frames), greatly reducing memory pressure in a number of cases,
        especially in applications that produce and store a large number of closures.
        Up to 20% improvement to CORE.setting build time and ~10% peak memory use
        reduction observed [e182deb]
    + Made I/O memory buffers properly contribute to full collection criteria,
        reducing memory overhead required [e182deb]
    + Made @a[*-1] 13% faster [b39c0d8][ab26b58]
    + Removed unnecessary caching on .elems in core code [ab26b58]
    + perl6 -ne '' <large file> is now about 40% faster [541d127]
    + Made IO::ArgFiles.lines about 10% faster [73797b7]
    + Made List.sort() about 4x faster [8d33b89]
    + Made native @a.sort() about 12x faster [4b2cea0]
    + Made Str.split(<a b c>) about 3x faster [f0398fb] and then 10%-40% faster
        on top of that, based on length of string [2496963]
    + Made Any.sort(&by) about 40% faster [1374fcf][def5262]
    + Made List.sort(&by) about 5% faster on reified List/Array [1e54371]
    + Made .sort on 0- and 1-element lists 10%-40% faster [340bc90]
    + Made .sort on 2-element lists about 50% faster [4724bd6]
    + Made Supply.sort a multi for faster dispatch [54cc06b]
    + Made Cursor.MATCH about 10-15% faster [9eef565]
    + Made QuantHash.AT-POS and Baggy.new about 5%-8% faster [c13e67b]
    + Made is nodal check a bit faster [0f25d83][996ab6a]
    + Made Capture.Bool about 3x faster [516e527]
    + Made sorting of 0,1,2 element native arrays about 30% faster [4038c6c]
    + Made generating iterator after List.eager does not reify again [7a759d7]
    + Added Seq.join that's 25% faster than List.join [3c52aa0]
    + Make @a Z @a 5x faster [4ab020f][3d1d699]
    + Made slow-path in grep 10% faster [362f674]
    + Made fast-path in grep about 1.4x slower as a result of a bug fix [362f674]
    + Made internal improvements with Empty and SlippyIterator [ebe9147]
    + Streamlined .prec on operators [caba0d3]
    + Made zip(@a,@b,:with(&[+|~]) about 12x faster [62f7027]
    + Made zip(@a,@b,:with(&op)) about 7x faster [62f7027]
    + Made zip with generic listinfix ops (e.g. zip(@a,@a,:with(&[minmax]))
        about 2x as fast [5c685f2]
    + Made zip(@a,@a,:with(&[=>])) about 5x faster [46cdf16]
    + Made generic right-assoc zip ops in zip(@a,@a,:with(...)) form
        at least 2x faster [6703b4c]
    + Made Zop handling (except for non-LHS-thunky ops) 13x faster [f66d4b3]
    + Made List.from-iterator about 10% faster [8f3476d]
    + Streamlined Array.from-iterator, making it 30% faster in some cases [fab1a14]
    + Improved ||=, //=, and &&= by avoiding thunking and invocation [d1c2e76]
    + Made List.combinations(N) about 20% faster [1a54bba] and on top of that
        made List.combinations() 1.5x, List.combinations(3..5) 2x faster [502fc77]
    + Made permutations() 2x to 24x faster [78edbbb][b5293c2][c64aeb3]
    + Made roundrobin() about 4x faster [73d0cec]
    + Made X and cross(...,:with) about 5x faster [8a3ff7b]
    + Made Xop about 7x faster [a26f513]
    + Made 1 X foo about 20% faster [d4a5b69]
    + Made List.rotor between 15x and 20x faster [d7b8214]
    + Made Range.excludes-(min|max|infinite|is-int) 2.5x as fast [99b186b]
    + Made reified List.Array about 3x faster [c9a9bc8]
    + Made List/Array.sum about 30% faster [017c6cf]
    + Made List/Array.fmt with no args about 60x faster [22e589a]
    + Made List/Array.fmt("%s") about 60x faster [7ef3682]
    + Made List/Array.join about 20% faster [ed482ec]


The following people contributed to this release:

Elizabeth Mattijsen, Zoffix Znet, Samantha McVey, Pawel Murias, 
Wenzel P. P. Peppmeyer, Jonathan Worthington, Will "Coke" Coleda, 
Christian Bartolomäus, Daniel Green, Stefan Seifert, Itsuki Toyota, 
Moritz Lenz, Larry Wall, Tom Browder, Ronald Schmidt, Douglas Jenkins, 
Jan-Olof Hendig, Armand Halbert, Aleks-Daniel Jakimenko-Aleksejev, 
Altai-man, Bahtiar `kalkin-` Gadimov, faraco, Will Coleda, Brian S. Julin, 
Steve Mynott, Jonathan Stowe, Alexis, Timo Paulssen, Naoum Hankache, 
Joachim Durchholz, Nick Logan, Nic Q, JJ Merelo, Douglas L. Schrag, dugword, 
Juan Julián Merelo Guervós, flussence, Elise, Jonathan Scott Duff, 
Siavash Askari Nasr, Paweł Murias, Bart Wiegmans, brian d foy, smls, 
Lucas Buchala, Fernando Correa de Oliveira, ab5tract, Tommy Stanton, 
Dagfinn Ilmari Mannsåker

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#108), is tentatively scheduled for 2017-02-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation, 
and other software that can be used with the Rakudo compiler to enhance its utility.

