% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{using}
\alias{using}
\title{Use an extension package.}
\usage{
using(package, quietly = TRUE)
}
\arguments{
\item{package}{the name of the extension package, given as name or character string.}

\item{quietly}{Passed to \code{\link{require}}.}
}
\value{
A named \code{list}, with the package name and the names of the
  functions registered by \code{package} to extend \pkg{tinytest}. A message
  is emitted when the package registers no extension functions.
}
\description{
Loads and attaches a package to the search path, and picks up the
\pkg{tinytest} extension functions registered by the package. Package
authors \emph{must} call this function in \emph{every} test file where an
extension is used, or otherwise results from the extension package are not
recorded (without a warning). Calling \code{using} in every file
where an extension is used also ensures that tests can be run in parallel.
}
\examples{
\dontrun{
  # In interactive session: see which functions are exported
  # by checkmate.tinytest
  out <- using(checkmate.tinytest)
  print(out)
}

}
\seealso{
Other extensions: 
\code{\link{register_tinytest_extension}()},
\code{\link{tinytest}()}
}
\concept{extensions}
