% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_model.extract.R
\name{pmodel.response}
\alias{pmodel.response}
\alias{pmodel.response.plm}
\alias{pmodel.response.data.frame}
\alias{pmodel.response.formula}
\title{A function to extract the model.response}
\usage{
pmodel.response(object, ...)

\method{pmodel.response}{plm}(object, ...)

\method{pmodel.response}{data.frame}(object, ...)

\method{pmodel.response}{formula}(object, data, ...)
}
\arguments{
\item{object}{an object of class \code{"plm"}, or a formula of
class \code{"Formula"},}

\item{\dots}{further arguments.}

\item{data}{a \code{data.frame}}
}
\value{
A pseries except if model responses' of a \code{"between"}
or \code{"fd"} model as these models "compress" the data (the number
of observations used in estimation is smaller than the original
data due to the specific transformation). A numeric is returned
for the \code{"between"} and \code{"fd"} model.
}
\description{
pmodel.response has several methods to conveniently extract the
response of several objects.
}
\details{
The model response is extracted from a \code{pdata.frame} (where the
response must reside in the first column; this is the case for a
model frame), a \code{pFormula} + \code{data} or a \code{plm} object, and the
transformation specified by \code{effect} and \code{model} is applied to
it.\cr Constructing the model frame first ensures proper \code{NA}
handling and the response being placed in the first column, see
also \strong{Examples} for usage.
}
\examples{

# First, make a pdata.frame
data("Grunfeld", package = "plm")
pGrunfeld <- pdata.frame(Grunfeld)

# then make a model frame from a pFormula and a pdata.frame


form <- inv ~ value + capital
mf <- model.frame(pGrunfeld, form)
# construct (transformed) response of the within model
resp <- pmodel.response(form, data = mf, model = "within", effect = "individual")
# retrieve (transformed) response directly from model frame
resp_mf <- pmodel.response(mf, model = "within", effect = "individual")

# retrieve (transformed) response from a plm object, i.e., an estimated model
fe_model <- plm(form, data = pGrunfeld, model = "within")
pmodel.response(fe_model)

# same as constructed before
all.equal(resp, pmodel.response(fe_model), check.attributes = FALSE) # TRUE

}
\seealso{
\code{plm}'s \code{\link[=model.matrix]{model.matrix()}} for (transformed)
model matrix and the corresponding \code{\link[=model.frame]{model.frame()}}
method to construct a model frame.
}
\author{
Yves Croissant
}
\keyword{manip}
