% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{setMsgComposer}
\alias{setMsgComposer}
\title{Sets message composer for logger.}
\usage{
setMsgComposer(composer_f, container = "")
}
\arguments{
\item{composer_f}{message composer function (type: function(msg, ...))}

\item{container}{name of logger to reser message composer for (type: character)}
}
\description{
Message composer is used to compose log message out of formating string and arguments.
It is function with signature \code{function(msg, ...)}. Formating message is passed under msg
and formating arguments are passed as \code{...}.
}
\details{
If message composer is not set default is in use (realized with \code{sprintf}). If message
composer is not set for sub-logger, parent's message composer will be used.
}
\examples{
setMsgComposer(function(msg, ...) paste0("s-", msg, "-e"))
loginfo("a message") # will log '<TS> INFO::s-a message-e'
resetMsgComposer()
loginfo("a message") # will log '<TS> INFO::a message'

}
