from typing import Any, Callable, Union

from .paths import AlternativePath, InvPath, NegatedPath, Path, SequencePath

class Node: ...

class Identifier(Node, str):
    def __new__(cls, value): ...
    def eq(self, other): ...
    def neq(self, other): ...
    def __ne__(self, other): ...
    def __eq__(self, other): ...
    def __gt__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __ge__(self, other): ...
    def startswith(self, prefix, start=..., end=...) -> bool: ...
    __hash__: Any

class URIRef(Identifier):
    __or__: Callable[[URIRef, Union[URIRef, Path]], AlternativePath]
    __invert__: Callable[[URIRef], InvPath]
    __neg__: Callable[[URIRef], NegatedPath]
    __truediv__: Callable[[URIRef, Union[URIRef, Path]], SequencePath]
    def __new__(cls, value, base: Any | None = ...): ...
    def toPython(self): ...
    def n3(self, namespace_manager: Any | None = ...) -> str: ...
    def defrag(self): ...
    def __reduce__(self): ...
    def __getnewargs__(self): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __mod__(self, other): ...
    def de_skolemize(self): ...

class Genid(URIRef): ...
class RDFLibGenid(Genid): ...

class BNode(Identifier):
    def __new__(cls, value: Any | None = ..., _sn_gen=..., _prefix=...): ...
    def toPython(self): ...
    def n3(self, namespace_manager: Any | None = ...): ...
    def __getnewargs__(self): ...
    def __reduce__(self): ...
    def skolemize(self, authority: Any | None = ..., basepath: Any | None = ...): ...

class Literal(Identifier):
    __doc__: str
    def __new__(
        cls,
        lexical_or_value,
        lang: Any | None = ...,
        datatype: Any | None = ...,
        normalize: Any | None = ...,
    ): ...
    def normalize(self): ...
    @property
    def value(self): ...
    @property
    def language(self): ...
    @property
    def datatype(self): ...
    def __reduce__(self): ...
    def __add__(self, val): ...
    def __bool__(self): ...
    def __neg__(self): ...
    def __pos__(self): ...
    def __abs__(self): ...
    def __invert__(self): ...
    def __gt__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __ge__(self, other): ...
    def __hash__(self): ...
    def __eq__(self, other): ...
    def eq(self, other): ...
    def neq(self, other): ...
    def n3(self, namespace_manager: Any | None = ...): ...
    def toPython(self): ...

def bind(
    datatype,
    pythontype,
    constructor: Any | None = ...,
    lexicalizer: Any | None = ...,
    datatype_specific: bool = ...,
) -> None: ...

class Variable(Identifier):
    def __new__(cls, value): ...
    def toPython(self): ...
    def n3(self, namespace_manager: Any | None = ...): ...
    def __reduce__(self): ...

class Statement(Node, tuple):
    def __new__(cls, triple, context): ...
    def __reduce__(self): ...
    def toPython(self): ...
