# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding webcam example
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Loïc Molinari <loic@fluendo.com>

import sys, pgm, gobject, gst

# Works with my cam, certainly not with yours, adapt the caps.
PIPELINE = 'v4lsrc autoprobe-fps=false ! '                            \
           'video/x-raw-yuv,width=320,height=240,framerate=225/16 ! ' \
           'ffmpegcolorspace ! '                                      \
           'pgmimagesink name="sink"'

# Terminate the mainloop on 'Escape' or 'q' key press event
def on_key_press(viewport, event, pipeline):
    if event.keyval == pgm.keysyms.q or event.keyval == pgm.keysyms.Escape:
        pgm.main_quit()

# Terminate the mainloop on a delete event
def on_delete(viewport, event, pipeline):
    pipeline.set_state(gst.STATE_NULL)
    pgm.main_quit()

def main(args):
    # GObject threads initialization
    gobject.threads_init()

    # OpenGL viewport creation
    gl = pgm.viewport_factory_make('opengl')
    gl.title = 'Webcam'
    gl.alpha_blending = False

    # Canvas and image drawable creation
    cvs = pgm.Canvas()
    img = pgm.Image()

    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(cvs)

    # Image properties
    img.position = (0.0, 0.0, 0.0)
    img.size = (4.0, 3.0)
    img.bg_color = (0, 0, 0, 0)
    img.show()

    # Add it to the middle layer of the canvas
    cvs.add(pgm.DRAWABLE_MIDDLE, img)

    # GStreamer pipeline setup
    pipeline = gst.parse_launch(PIPELINE)
    sink = pipeline.get_by_name('sink')
    sink.set_property('image', img)
    pipeline.set_state(gst.STATE_PLAYING)

    # Let's start the mainloop
    gl.connect('delete-event', on_delete, pipeline)
    gl.connect('key-press-event', on_key_press, pipeline)
    gl.show()
    pgm.main()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
