(function(root,factory){if(typeof define==="function"&&define.amd){define(["d3"],function(d3){return root.Rickshaw=factory(d3)})}else if(typeof exports==="object"){module.exports=factory(require("d3"))}else{root.Rickshaw=factory(d3)}})(this,function(d3){var Rickshaw={namespace:function(namespace,obj){var parts=namespace.split(".");var parent=Rickshaw;for(var i=1,length=parts.length;i<length;i++){var currentPart=parts[i];parent[currentPart]=parent[currentPart]||{};parent=parent[currentPart]}return parent},keys:function(obj){var keys=[];for(var key in obj)keys.push(key);return keys},extend:function(destination,source){for(var property in source){destination[property]=source[property]}return destination},clone:function(obj){return JSON.parse(JSON.stringify(obj))}};(function(globalContext){var _toString=Object.prototype.toString,NULL_TYPE="Null",UNDEFINED_TYPE="Undefined",BOOLEAN_TYPE="Boolean",NUMBER_TYPE="Number",STRING_TYPE="String",OBJECT_TYPE="Object",FUNCTION_CLASS="[object Function]";function isFunction(object){return _toString.call(object)===FUNCTION_CLASS}function extend(destination,source){for(var property in source)if(source.hasOwnProperty(property))destination[property]=source[property];return destination}function keys(object){if(Type(object)!==OBJECT_TYPE){throw new TypeError}var results=[];for(var property in object){if(object.hasOwnProperty(property)){results.push(property)}}return results}function Type(o){switch(o){case null:return NULL_TYPE;case void 0:return UNDEFINED_TYPE}var type=typeof o;switch(type){case"boolean":return BOOLEAN_TYPE;case"number":return NUMBER_TYPE;case"string":return STRING_TYPE}return OBJECT_TYPE}function isUndefined(object){return typeof object==="undefined"}var slice=Array.prototype.slice;function argumentNames(fn){var names=fn.toString().match(/^[\s\(]*function[^(]*\(([^)]*)\)/)[1].replace(/\/\/.*?[\r\n]|\/\*(?:.|[\r\n])*?\*\//g,"").replace(/\s+/g,"").split(",");return names.length==1&&!names[0]?[]:names}function wrap(fn,wrapper){var __method=fn;return function(){var a=update([bind(__method,this)],arguments);return wrapper.apply(this,a)}}function update(array,args){var arrayLength=array.length,length=args.length;while(length--)array[arrayLength+length]=args[length];return array}function merge(array,args){array=slice.call(array,0);return update(array,args)}function bind(fn,context){if(arguments.length<2&&isUndefined(arguments[0]))return this;var __method=fn,args=slice.call(arguments,2);return function(){var a=merge(args,arguments);return __method.apply(context,a)}}var emptyFunction=function(){};var Class=function(){var IS_DONTENUM_BUGGY=function(){for(var p in{toString:1}){if(p==="toString")return false}return true}();function subclass(){}function create(){var parent=null,properties=[].slice.apply(arguments);if(isFunction(properties[0]))parent=properties.shift();function klass(){this.initialize.apply(this,arguments)}extend(klass,Class.Methods);klass.superclass=parent;klass.subclasses=[];if(parent){subclass.prototype=parent.prototype;klass.prototype=new subclass;try{parent.subclasses.push(klass)}catch(e){}}for(var i=0,length=properties.length;i<length;i++)klass.addMethods(properties[i]);if(!klass.prototype.initialize)klass.prototype.initialize=emptyFunction;klass.prototype.constructor=klass;return klass}function addMethods(source){var ancestor=this.superclass&&this.superclass.prototype,properties=keys(source);if(IS_DONTENUM_BUGGY){if(source.toString!=Object.prototype.toString)properties.push("toString");if(source.valueOf!=Object.prototype.valueOf)properties.push("valueOf")}for(var i=0,length=properties.length;i<length;i++){var property=properties[i],value=source[property];if(ancestor&&isFunction(value)&&argumentNames(value)[0]=="$super"){var method=value;value=wrap(function(m){return function(){return ancestor[m].apply(this,arguments)}}(property),method);value.valueOf=bind(method.valueOf,method);value.toString=bind(method.toString,method)}this.prototype[property]=value}return this}return{create:create,Methods:{addMethods:addMethods}}}();if(globalContext.exports){globalContext.exports.Class=Class}else{globalContext.Class=Class}})(Rickshaw);Rickshaw.namespace("Rickshaw.Compat.ClassList");Rickshaw.Compat.ClassList=function(){if(typeof document!=="undefined"&&!("classList"in document.createElement("a"))){(function(view){"use strict";var classListProp="classList",protoProp="prototype",elemCtrProto=(view.HTMLElement||view.Element)[protoProp],objCtr=Object,strTrim=String[protoProp].trim||function(){return this.replace(/^\s+|\s+$/g,"")},arrIndexOf=Array[protoProp].indexOf||function(item){var i=0,len=this.length;for(;i<len;i++){if(i in this&&this[i]===item){return i}}return-1},DOMEx=function(type,message){this.name=type;this.code=DOMException[type];this.message=message},checkTokenAndGetIndex=function(classList,token){if(token===""){throw new DOMEx("SYNTAX_ERR","An invalid or illegal string was specified")}if(/\s/.test(token)){throw new DOMEx("INVALID_CHARACTER_ERR","String contains an invalid character")}return arrIndexOf.call(classList,token)},ClassList=function(elem){var trimmedClasses=strTrim.call(elem.className),classes=trimmedClasses?trimmedClasses.split(/\s+/):[],i=0,len=classes.length;for(;i<len;i++){this.push(classes[i])}this._updateClassName=function(){elem.className=this.toString()}},classListProto=ClassList[protoProp]=[],classListGetter=function(){return new ClassList(this)};DOMEx[protoProp]=Error[protoProp];classListProto.item=function(i){return this[i]||null};classListProto.contains=function(token){token+="";return checkTokenAndGetIndex(this,token)!==-1};classListProto.add=function(token){token+="";if(checkTokenAndGetIndex(this,token)===-1){this.push(token);this._updateClassName()}};classListProto.remove=function(token){token+="";var index=checkTokenAndGetIndex(this,token);if(index!==-1){this.splice(index,1);this._updateClassName()}};classListProto.toggle=function(token){token+="";if(checkTokenAndGetIndex(this,token)===-1){this.add(token)}else{this.remove(token)}};classListProto.toString=function(){return this.join(" ")};if(objCtr.defineProperty){var classListPropDesc={get:classListGetter,enumerable:true,configurable:true};try{objCtr.defineProperty(elemCtrProto,classListProp,classListPropDesc)}catch(ex){if(ex.number===-2146823252){classListPropDesc.enumerable=false;objCtr.defineProperty(elemCtrProto,classListProp,classListPropDesc)}}}else if(objCtr[protoProp].__defineGetter__){elemCtrProto.__defineGetter__(classListProp,classListGetter)}})(window)}};if(typeof RICKSHAW_NO_COMPAT!=="undefined"&&!RICKSHAW_NO_COMPAT||typeof RICKSHAW_NO_COMPAT==="undefined"){new Rickshaw.Compat.ClassList}Rickshaw.namespace("Rickshaw.Graph");Rickshaw.Graph=function(args){var self=this;this.initialize=function(args){if(!args.element)throw"Rickshaw.Graph needs a reference to an element";if(args.element.nodeType!==1)throw"Rickshaw.Graph element was defined but not an HTML element";this.element=args.element;this.series=args.series;this.window={};this.updateCallbacks=[];this.configureCallbacks=[];this.defaults={interpolation:"cardinal",offset:"zero",min:undefined,max:undefined,preserve:false,xScale:undefined,yScale:undefined,stack:true};this._loadRenderers();this.configure(args);this.validateSeries(args.series);this.series.active=function(){return self.series.filter(function(s){return!s.disabled})};this.setSize({width:args.width,height:args.height});this.element.classList.add("rickshaw_graph");this.vis=d3.select(this.element).append("svg:svg").attr("width",this.width).attr("height",this.height);this.discoverRange()};this._loadRenderers=function(){for(var name in Rickshaw.Graph.Renderer){if(!name||!Rickshaw.Graph.Renderer.hasOwnProperty(name))continue;var r=Rickshaw.Graph.Renderer[name];if(!r||!r.prototype||!r.prototype.render)continue;self.registerRenderer(new r({graph:self}))}};this.validateSeries=function(series){if(!Array.isArray(series)&&!(series instanceof Rickshaw.Series)){var seriesSignature=Object.prototype.toString.apply(series);throw"series is not an array: "+seriesSignature}var pointsCount;series.forEach(function(s){if(!(s instanceof Object)){throw"series element is not an object: "+s}if(!s.data){throw"series has no data: "+JSON.stringify(s)}if(!Array.isArray(s.data)){throw"series data is not an array: "+JSON.stringify(s.data)}if(s.data.length>0){var x=s.data[0].x;var y=s.data[0].y;if(typeof x!="number"||typeof y!="number"&&y!==null){throw"x and y properties of points should be numbers instead of "+typeof x+" and "+typeof y}}if(s.data.length>=3){if(s.data[2].x<s.data[1].x||s.data[1].x<s.data[0].x||s.data[s.data.length-1].x<s.data[0].x){throw"series data needs to be sorted on x values for series name: "+s.name}}},this)};this.dataDomain=function(){var data=this.series.map(function(s){return s.data});var min=d3.min(data.map(function(d){return d[0].x}));var max=d3.max(data.map(function(d){return d[d.length-1].x}));return[min,max]};this.discoverRange=function(){var domain=this.renderer.domain();this.x=(this.xScale||d3.scale.linear()).copy().domain(domain.x).range([0,this.width]);this.y=(this.yScale||d3.scale.linear()).copy().domain(domain.y).range([this.height,0]);this.x.magnitude=d3.scale.linear().domain([domain.x[0]-domain.x[0],domain.x[1]-domain.x[0]]).range([0,this.width]);this.y.magnitude=d3.scale.linear().domain([domain.y[0]-domain.y[0],domain.y[1]-domain.y[0]]).range([0,this.height])};this.render=function(){var stackedData=this.stackData();this.discoverRange();this.renderer.render();this.updateCallbacks.forEach(function(callback){callback()})};this.update=this.render;this.stackData=function(){var data=this.series.active().map(function(d){return d.data}).map(function(d){return d.filter(function(d){return this._slice(d)},this)},this);var preserve=this.preserve;if(!preserve){this.series.forEach(function(series){if(series.scale){preserve=true}})}data=preserve?Rickshaw.clone(data):data;this.series.active().forEach(function(series,index){if(series.scale){var seriesData=data[index];if(seriesData){seriesData.forEach(function(d){d.y=series.scale(d.y)})}}});this.stackData.hooks.data.forEach(function(entry){data=entry.f.apply(self,[data])});var stackedData;if(!this.renderer.unstack){this._validateStackable();var layout=d3.layout.stack();layout.offset(self.offset);stackedData=layout(data)}stackedData=stackedData||data;if(this.renderer.unstack){stackedData.forEach(function(seriesData){seriesData.forEach(function(d){d.y0=d.y0===undefined?0:d.y0})})}this.stackData.hooks.after.forEach(function(entry){stackedData=entry.f.apply(self,[data])});var i=0;this.series.forEach(function(series){if(series.disabled)return;series.stack=stackedData[i++]});this.stackedData=stackedData;return stackedData};this._validateStackable=function(){var series=this.series;var pointsCount;series.forEach(function(s){pointsCount=pointsCount||s.data.length;if(pointsCount&&s.data.length!=pointsCount){throw"stacked series cannot have differing numbers of points: "+pointsCount+" vs "+s.data.length+"; see Rickshaw.Series.fill()"}},this)};this.stackData.hooks={data:[],after:[]};this._slice=function(d){if(this.window.xMin||this.window.xMax){var isInRange=true;if(this.window.xMin&&d.x<this.window.xMin)isInRange=false;if(this.window.xMax&&d.x>this.window.xMax)isInRange=false;return isInRange}return true};this.onUpdate=function(callback){this.updateCallbacks.push(callback)};this.onConfigure=function(callback){this.configureCallbacks.push(callback)};this.registerRenderer=function(renderer){this._renderers=this._renderers||{};this._renderers[renderer.name]=renderer};this.configure=function(args){this.config=this.config||{};if(args.width||args.height){this.setSize(args)}Rickshaw.keys(this.defaults).forEach(function(k){this.config[k]=k in args?args[k]:k in this?this[k]:this.defaults[k]},this);Rickshaw.keys(this.config).forEach(function(k){this[k]=this.config[k]},this);if("stack"in args)args.unstack=!args.stack;var renderer=args.renderer||this.renderer&&this.renderer.name||"stack";this.setRenderer(renderer,args);this.configureCallbacks.forEach(function(callback){callback(args)})};this.setRenderer=function(r,args){if(typeof r=="function"){this.renderer=new r({graph:self});this.registerRenderer(this.renderer)}else{if(!this._renderers[r]){throw"couldn't find renderer "+r}this.renderer=this._renderers[r]}if(typeof args=="object"){this.renderer.configure(args)}};this.setSize=function(args){args=args||{};if(typeof window!==undefined){var style=window.getComputedStyle(this.element,null);var elementWidth=parseInt(style.getPropertyValue("width"),10);var elementHeight=parseInt(style.getPropertyValue("height"),10)}this.width=args.width||elementWidth||400;this.height=args.height||elementHeight||250;this.vis&&this.vis.attr("width",this.width).attr("height",this.height)};this.initialize(args)};Rickshaw.namespace("Rickshaw.Fixtures.Color");Rickshaw.Fixtures.Color=function(){this.schemes={};this.schemes.spectrum14=["#ecb796","#dc8f70","#b2a470","#92875a","#716c49","#d2ed82","#bbe468","#a1d05d","#e7cbe6","#d8aad6","#a888c2","#9dc2d3","#649eb9","#387aa3"].reverse();this.schemes.spectrum2000=["#57306f","#514c76","#646583","#738394","#6b9c7d","#84b665","#a7ca50","#bfe746","#e2f528","#fff726","#ecdd00","#d4b11d","#de8800","#de4800","#c91515","#9a0000","#7b0429","#580839","#31082b"];this.schemes.spectrum2001=["#2f243f","#3c2c55","#4a3768","#565270","#6b6b7c","#72957f","#86ad6e","#a1bc5e","#b8d954","#d3e04e","#ccad2a","#cc8412","#c1521d","#ad3821","#8a1010","#681717","#531e1e","#3d1818","#320a1b"];this.schemes.classic9=["#423d4f","#4a6860","#848f39","#a2b73c","#ddcb53","#c5a32f","#7d5836","#963b20","#7c2626","#491d37","#2f254a"].reverse();this.schemes.httpStatus={503:"#ea5029",502:"#d23f14",500:"#bf3613",410:"#efacea",409:"#e291dc",403:"#f457e8",408:"#e121d2",401:"#b92dae",405:"#f47ceb",404:"#a82a9f",400:"#b263c6",301:"#6fa024",302:"#87c32b",307:"#a0d84c",304:"#28b55c",200:"#1a4f74",206:"#27839f",201:"#52adc9",202:"#7c979f",203:"#a5b8bd",204:"#c1cdd1"};this.schemes.colorwheel=["#b5b6a9","#858772","#785f43","#96557e","#4682b4","#65b9ac","#73c03a","#cb513a"].reverse();this.schemes.cool=["#5e9d2f","#73c03a","#4682b4","#7bc3b8","#a9884e","#c1b266","#a47493","#c09fb5"];this.schemes.munin=["#00cc00","#0066b3","#ff8000","#ffcc00","#330099","#990099","#ccff00","#ff0000","#808080","#008f00","#00487d","#b35a00","#b38f00","#6b006b","#8fb300","#b30000","#bebebe","#80ff80","#80c9ff","#ffc080","#ffe680","#aa80ff","#ee00cc","#ff8080","#666600","#ffbfff","#00ffcc","#cc6699","#999900"]};Rickshaw.namespace("Rickshaw.Fixtures.RandomData");Rickshaw.Fixtures.RandomData=function(timeInterval){var addData;timeInterval=timeInterval||1;var lastRandomValue=200;var timeBase=Math.floor((new Date).getTime()/1e3);this.addData=function(data){var randomValue=Math.random()*100+15+lastRandomValue;var index=data[0].length;var counter=1;data.forEach(function(series){var randomVariance=Math.random()*20;var v=randomValue/25+counter++ +(Math.cos(index*counter*11/960)+2)*15+(Math.cos(index/7)+2)*7+(Math.cos(index/17)+2)*1;series.push({x:index*timeInterval+timeBase,y:v+randomVariance})});lastRandomValue=randomValue*.85};this.removeData=function(data){data.forEach(function(series){series.shift()});timeBase+=timeInterval}};Rickshaw.namespace("Rickshaw.Fixtures.Time");Rickshaw.Fixtures.Time=function(){var self=this;this.months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];this.units=[{name:"decade",seconds:86400*365.25*10,formatter:function(d){return parseInt(d.getUTCFullYear()/10,10)*10}},{name:"year",seconds:86400*365.25,formatter:function(d){return d.getUTCFullYear()}},{name:"month",seconds:86400*30.5,formatter:function(d){return self.months[d.getUTCMonth()]}},{name:"week",seconds:86400*7,formatter:function(d){return self.formatDate(d)}},{name:"day",seconds:86400,formatter:function(d){return d.getUTCDate()}},{name:"6 hour",seconds:3600*6,formatter:function(d){return self.formatTime(d)}},{name:"hour",seconds:3600,formatter:function(d){return self.formatTime(d)}},{name:"15 minute",seconds:60*15,formatter:function(d){return self.formatTime(d)}},{name:"minute",seconds:60,formatter:function(d){return d.getUTCMinutes()}},{name:"15 second",seconds:15,formatter:function(d){return d.getUTCSeconds()+"s"}},{name:"second",seconds:1,formatter:function(d){return d.getUTCSeconds()+"s"}},{name:"decisecond",seconds:1/10,formatter:function(d){return d.getUTCMilliseconds()+"ms"}},{name:"centisecond",seconds:1/100,formatter:function(d){return d.getUTCMilliseconds()+"ms"}}];this.unit=function(unitName){return this.units.filter(function(unit){return unitName==unit.name}).shift()};this.formatDate=function(d){return d3.time.format("%b %e")(d)};this.formatTime=function(d){return d.toUTCString().match(/(\d+:\d+):/)[1]};this.ceil=function(time,unit){var date,floor,year;if(unit.name=="month"){date=new Date(time*1e3);floor=Date.UTC(date.getUTCFullYear(),date.getUTCMonth())/1e3;if(floor==time)return time;year=date.getUTCFullYear();var month=date.getUTCMonth();if(month==11){month=0;year=year+1}else{month+=1}return Date.UTC(year,month)/1e3}if(unit.name=="year"){date=new Date(time*1e3);floor=Date.UTC(date.getUTCFullYear(),0)/1e3;if(floor==time)return time;year=date.getUTCFullYear()+1;return Date.UTC(year,0)/1e3}return Math.ceil(time/unit.seconds)*unit.seconds}};Rickshaw.namespace("Rickshaw.Fixtures.Time.Local");Rickshaw.Fixtures.Time.Local=function(){var self=this;this.months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];this.units=[{name:"decade",seconds:86400*365.25*10,formatter:function(d){return parseInt(d.getFullYear()/10,10)*10}},{name:"year",seconds:86400*365.25,formatter:function(d){return d.getFullYear()}},{name:"month",seconds:86400*30.5,formatter:function(d){return self.months[d.getMonth()]}},{name:"week",seconds:86400*7,formatter:function(d){return self.formatDate(d)}},{name:"day",seconds:86400,formatter:function(d){return d.getDate()}},{name:"6 hour",seconds:3600*6,formatter:function(d){return self.formatTime(d)}},{name:"hour",seconds:3600,formatter:function(d){return self.formatTime(d)}},{name:"15 minute",seconds:60*15,formatter:function(d){return self.formatTime(d)}},{name:"minute",seconds:60,formatter:function(d){return d.getMinutes()}},{name:"15 second",seconds:15,formatter:function(d){return d.getSeconds()+"s"}},{name:"second",seconds:1,formatter:function(d){return d.getSeconds()+"s"}},{name:"decisecond",seconds:1/10,formatter:function(d){return d.getMilliseconds()+"ms"}},{name:"centisecond",seconds:1/100,formatter:function(d){return d.getMilliseconds()+"ms"}}];this.unit=function(unitName){return this.units.filter(function(unit){return unitName==unit.name}).shift()};this.formatDate=function(d){return d3.time.format("%b %e")(d)};this.formatTime=function(d){return d.toString().match(/(\d+:\d+):/)[1]};this.ceil=function(time,unit){var date,floor,year;if(unit.name=="day"){var nearFuture=new Date((time+unit.seconds-1)*1e3);var rounded=new Date(0);rounded.setMilliseconds(0);rounded.setSeconds(0);rounded.setMinutes(0);rounded.setHours(0);rounded.setDate(nearFuture.getDate());rounded.setMonth(nearFuture.getMonth());rounded.setFullYear(nearFuture.getFullYear());return rounded.getTime()/1e3}if(unit.name=="month"){date=new Date(time*1e3);floor=new Date(date.getFullYear(),date.getMonth()).getTime()/1e3;if(floor==time)return time;year=date.getFullYear();var month=date.getMonth();if(month==11){month=0;year=year+1}else{month+=1}return new Date(year,month).getTime()/1e3}if(unit.name=="year"){date=new Date(time*1e3);floor=new Date(date.getUTCFullYear(),0).getTime()/1e3;if(floor==time)return time;year=date.getFullYear()+1;return new Date(year,0).getTime()/1e3}return Math.ceil(time/unit.seconds)*unit.seconds}};Rickshaw.namespace("Rickshaw.Fixtures.Number");Rickshaw.Fixtures.Number.formatKMBT=function(y){var abs_y=Math.abs(y);if(abs_y>=1e12){return y/1e12+"T"}else if(abs_y>=1e9){return y/1e9+"B"}else if(abs_y>=1e6){return y/1e6+"M"}else if(abs_y>=1e3){return y/1e3+"K"}else if(abs_y<1&&y>0){return y.toFixed(2)}else if(abs_y===0){return""}else{return y}};Rickshaw.Fixtures.Number.formatBase1024KMGTP=function(y){var abs_y=Math.abs(y);if(abs_y>=0x4000000000000){return y/0x4000000000000+"P"}else if(abs_y>=1099511627776){return y/1099511627776+"T"}else if(abs_y>=1073741824){return y/1073741824+"G"}else if(abs_y>=1048576){return y/1048576+"M"}else if(abs_y>=1024){return y/1024+"K"}else if(abs_y<1&&y>0){return y.toFixed(2)}else if(abs_y===0){return""}else{return y}};Rickshaw.namespace("Rickshaw.Color.Palette");Rickshaw.Color.Palette=function(args){var color=new Rickshaw.Fixtures.Color;args=args||{};this.schemes={};this.scheme=color.schemes[args.scheme]||args.scheme||color.schemes.colorwheel;this.runningIndex=0;this.generatorIndex=0;if(args.interpolatedStopCount){var schemeCount=this.scheme.length-1;var i,j,scheme=[];for(i=0;i<schemeCount;i++){scheme.push(this.scheme[i]);var generator=d3.interpolateHsl(this.scheme[i],this.scheme[i+1]);for(j=1;j<args.interpolatedStopCount;j++){scheme.push(generator(1/args.interpolatedStopCount*j))}}scheme.push(this.scheme[this.scheme.length-1]);this.scheme=scheme}this.rotateCount=this.scheme.length;this.color=function(key){return this.scheme[key]||this.scheme[this.runningIndex++]||this.interpolateColor()||"#808080"};this.interpolateColor=function(){if(!Array.isArray(this.scheme))return;var color;if(this.generatorIndex==this.rotateCount*2-1){color=d3.interpolateHsl(this.scheme[this.generatorIndex],this.scheme[0])(.5);this.generatorIndex=0;this.rotateCount*=2}else{color=d3.interpolateHsl(this.scheme[this.generatorIndex],this.scheme[this.generatorIndex+1])(.5);this.generatorIndex++}this.scheme.push(color);return color}};Rickshaw.namespace("Rickshaw.Graph.Ajax");Rickshaw.Graph.Ajax=Rickshaw.Class.create({initialize:function(args){this.dataURL=args.dataURL;this.onData=args.onData||function(d){return d};this.onComplete=args.onComplete||function(){};this.onError=args.onError||function(){};this.args=args;this.request()},request:function(){jQuery.ajax({url:this.dataURL,dataType:"json",success:this.success.bind(this),error:this.error.bind(this)})},error:function(){console.log("error loading dataURL: "+this.dataURL);this.onError(this)},success:function(data,status){data=this.onData(data);this.args.series=this._splice({data:data,series:this.args.series});this.graph=this.graph||new Rickshaw.Graph(this.args);this.graph.render();this.onComplete(this)},_splice:function(args){var data=args.data;var series=args.series;if(!args.series)return data;series.forEach(function(s){var seriesKey=s.key||s.name;if(!seriesKey)throw"series needs a key or a name";data.forEach(function(d){var dataKey=d.key||d.name;if(!dataKey)throw"data needs a key or a name";if(seriesKey==dataKey){var properties=["color","name","data"];properties.forEach(function(p){if(d[p])s[p]=d[p]})}})});return series}});Rickshaw.namespace("Rickshaw.Graph.Annotate");Rickshaw.Graph.Annotate=function(args){var graph=this.graph=args.graph;this.elements={timeline:args.element};var self=this;this.data={};this.elements.timeline.classList.add("rickshaw_annotation_timeline");this.add=function(time,content,end_time){self.data[time]=self.data[time]||{boxes:[]};self.data[time].boxes.push({content:content,end:end_time})};this.update=function(){Rickshaw.keys(self.data).forEach(function(time){var annotation=self.data[time];var left=self.graph.x(time);if(left<0||left>self.graph.x.range()[1]){if(annotation.element){annotation.line.classList.add("offscreen");annotation.element.style.display="none"}annotation.boxes.forEach(function(box){if(box.rangeElement)box.rangeElement.classList.add("offscreen")});return}if(!annotation.element){var element=annotation.element=document.createElement("div");element.classList.add("annotation");this.elements.timeline.appendChild(element);element.addEventListener("click",function(e){element.classList.toggle("active");annotation.line.classList.toggle("active");annotation.boxes.forEach(function(box){if(box.rangeElement)box.rangeElement.classList.toggle("active")})},false)}annotation.element.style.left=left+"px";annotation.element.style.display="block";annotation.boxes.forEach(function(box){var element=box.element;if(!element){element=box.element=document.createElement("div");element.classList.add("content");element.innerHTML=box.content;annotation.element.appendChild(element);annotation.line=document.createElement("div");annotation.line.classList.add("annotation_line");self.graph.element.appendChild(annotation.line);if(box.end){box.rangeElement=document.createElement("div");box.rangeElement.classList.add("annotation_range");self.graph.element.appendChild(box.rangeElement)}}if(box.end){var annotationRangeStart=left;var annotationRangeEnd=Math.min(self.graph.x(box.end),self.graph.x.range()[1]);if(annotationRangeStart>annotationRangeEnd){annotationRangeEnd=left;annotationRangeStart=Math.max(self.graph.x(box.end),self.graph.x.range()[0])}var annotationRangeWidth=annotationRangeEnd-annotationRangeStart;box.rangeElement.style.left=annotationRangeStart+"px";box.rangeElement.style.width=annotationRangeWidth+"px";box.rangeElement.classList.remove("offscreen")}annotation.line.classList.remove("offscreen");annotation.line.style.left=left+"px"})},this)};this.graph.onUpdate(function(){self.update()})};Rickshaw.namespace("Rickshaw.Graph.Axis.Time");Rickshaw.Graph.Axis.Time=function(args){var self=this;this.graph=args.graph;this.elements=[];this.ticksTreatment=args.ticksTreatment||"plain";this.fixedTimeUnit=args.timeUnit;var time=args.timeFixture||new Rickshaw.Fixtures.Time;this.appropriateTimeUnit=function(){var unit;var units=time.units;var domain=this.graph.x.domain();var rangeSeconds=domain[1]-domain[0];units.forEach(function(u){if(Math.floor(rangeSeconds/u.seconds)>=2){unit=unit||u}});return unit||time.units[time.units.length-1]};this.tickOffsets=function(){var domain=this.graph.x.domain();var unit=this.fixedTimeUnit||this.appropriateTimeUnit();var count=Math.ceil((domain[1]-domain[0])/unit.seconds);var runningTick=domain[0];var offsets=[];for(var i=0;i<count;i++){var tickValue=time.ceil(runningTick,unit);runningTick=tickValue+unit.seconds/2;offsets.push({value:tickValue,unit:unit})}return offsets};this.render=function(){this.elements.forEach(function(e){e.parentNode.removeChild(e)});this.elements=[];var offsets=this.tickOffsets();offsets.forEach(function(o){if(self.graph.x(o.value)>self.graph.x.range()[1])return;var element=document.createElement("div");element.style.left=self.graph.x(o.value)+"px";element.classList.add("x_tick");element.classList.add(self.ticksTreatment);var title=document.createElement("div");title.classList.add("title");title.innerHTML=o.unit.formatter(new Date(o.value*1e3));element.appendChild(title);self.graph.element.appendChild(element);self.elements.push(element)})};this.graph.onUpdate(function(){self.render()})};Rickshaw.namespace("Rickshaw.Graph.Axis.X");Rickshaw.Graph.Axis.X=function(args){var self=this;var berthRate=.1;this.initialize=function(args){this.graph=args.graph;this.orientation=args.orientation||"top";this.pixelsPerTick=args.pixelsPerTick||75;if(args.ticks)this.staticTicks=args.ticks;if(args.tickValues)this.tickValues=args.tickValues;this.tickSize=args.tickSize||4;this.ticksTreatment=args.ticksTreatment||"plain";if(args.element){this.element=args.element;this._discoverSize(args.element,args);this.vis=d3.select(args.element).append("svg:svg").attr("height",this.height).attr("width",this.width).attr("class","rickshaw_graph x_axis_d3");this.element=this.vis[0][0];this.element.style.position="relative";this.setSize({width:args.width,height:args.height})}else{this.vis=this.graph.vis}this.graph.onUpdate(function(){self.render()})};this.setSize=function(args){args=args||{};if(!this.element)return;this._discoverSize(this.element.parentNode,args);this.vis.attr("height",this.height).attr("width",this.width*(1+berthRate));var berth=Math.floor(this.width*berthRate/2);this.element.style.left=-1*berth+"px"};this.render=function(){if(this._renderWidth!==undefined&&this.graph.width!==this._renderWidth)this.setSize({auto:true});var axis=d3.svg.axis().scale(this.graph.x).orient(this.orientation);axis.tickFormat(args.tickFormat||function(x){return x});if(this.tickValues)axis.tickValues(this.tickValues);this.ticks=this.staticTicks||Math.floor(this.graph.width/this.pixelsPerTick);var berth=Math.floor(this.width*berthRate/2)||0;var transform;if(this.orientation=="top"){var yOffset=this.height||this.graph.height;transform="translate("+berth+","+yOffset+")"}else{transform="translate("+berth+", 0)"}if(this.element){this.vis.selectAll("*").remove()}this.vis.append("svg:g").attr("class",["x_ticks_d3",this.ticksTreatment].join(" ")).attr("transform",transform).call(axis.ticks(this.ticks).tickSubdivide(0).tickSize(this.tickSize));var gridSize=(this.orientation=="bottom"?1:-1)*this.graph.height;this.graph.vis.append("svg:g").attr("class","x_grid_d3").call(axis.ticks(this.ticks).tickSubdivide(0).tickSize(gridSize)).selectAll("text").each(function(){this.parentNode.setAttribute("data-x-value",this.textContent)});this._renderHeight=this.graph.height};this._discoverSize=function(element,args){if(typeof window!=="undefined"){var style=window.getComputedStyle(element,null);var elementHeight=parseInt(style.getPropertyValue("height"),10);if(!args.auto){var elementWidth=parseInt(style.getPropertyValue("width"),10)}}this.width=(args.width||elementWidth||this.graph.width)*(1+berthRate);this.height=args.height||elementHeight||40};this.initialize(args)};Rickshaw.namespace("Rickshaw.Graph.Axis.Y");Rickshaw.Graph.Axis.Y=Rickshaw.Class.create({initialize:function(args){this.graph=args.graph;this.orientation=args.orientation||"right";this.pixelsPerTick=args.pixelsPerTick||75;if(args.ticks)this.staticTicks=args.ticks;if(args.tickValues)this.tickValues=args.tickValues;this.tickSize=args.tickSize||4;this.ticksTreatment=args.ticksTreatment||"plain";this.tickFormat=args.tickFormat||function(y){return y};this.berthRate=.1;if(args.element){this.element=args.element;this.vis=d3.select(args.element).append("svg:svg").attr("class","rickshaw_graph y_axis");this.element=this.vis[0][0];this.element.style.position="relative";this.setSize({width:args.width,height:args.height})}else{this.vis=this.graph.vis}var self=this;this.graph.onUpdate(function(){self.render()})},setSize:function(args){args=args||{};if(!this.element)return;if(typeof window!=="undefined"){var style=window.getComputedStyle(this.element.parentNode,null);var elementWidth=parseInt(style.getPropertyValue("width"),10);if(!args.auto){var elementHeight=parseInt(style.getPropertyValue("height"),10)}}this.width=args.width||elementWidth||this.graph.width*this.berthRate;this.height=args.height||elementHeight||this.graph.height;this.vis.attr("width",this.width).attr("height",this.height*(1+this.berthRate));var berth=this.height*this.berthRate;if(this.orientation=="left"){this.element.style.top=-1*berth+"px"}},render:function(){if(this._renderHeight!==undefined&&this.graph.height!==this._renderHeight)this.setSize({auto:true});this.ticks=this.staticTicks||Math.floor(this.graph.height/this.pixelsPerTick);var axis=this._drawAxis(this.graph.y);this._drawGrid(axis);this._renderHeight=this.graph.height},_drawAxis:function(scale){var axis=d3.svg.axis().scale(scale).orient(this.orientation);axis.tickFormat(this.tickFormat);if(this.tickValues)axis.tickValues(this.tickValues);if(this.orientation=="left"){var berth=this.height*this.berthRate;var transform="translate("+this.width+", "+berth+")"}if(this.element){this.vis.selectAll("*").remove()}this.vis.append("svg:g").attr("class",["y_ticks",this.ticksTreatment].join(" ")).attr("transform",transform).call(axis.ticks(this.ticks).tickSubdivide(0).tickSize(this.tickSize));return axis},_drawGrid:function(axis){var gridSize=(this.orientation=="right"?1:-1)*this.graph.width;this.graph.vis.append("svg:g").attr("class","y_grid").call(axis.ticks(this.ticks).tickSubdivide(0).tickSize(gridSize)).selectAll("text").each(function(){this.parentNode.setAttribute("data-y-value",this.textContent)
})}});Rickshaw.namespace("Rickshaw.Graph.Axis.Y.Scaled");Rickshaw.Graph.Axis.Y.Scaled=Rickshaw.Class.create(Rickshaw.Graph.Axis.Y,{initialize:function($super,args){if(typeof args.scale==="undefined"){throw new Error("Scaled requires scale")}this.scale=args.scale;if(typeof args.grid==="undefined"){this.grid=true}else{this.grid=args.grid}$super(args)},_drawAxis:function($super,scale){var domain=this.scale.domain();var renderDomain=this.graph.renderer.domain().y;var extents=[Math.min.apply(Math,domain),Math.max.apply(Math,domain)];var extentMap=d3.scale.linear().domain([0,1]).range(extents);var adjExtents=[extentMap(renderDomain[0]),extentMap(renderDomain[1])];var adjustment=d3.scale.linear().domain(extents).range(adjExtents);var adjustedScale=this.scale.copy().domain(domain.map(adjustment)).range(scale.range());return $super(adjustedScale)},_drawGrid:function($super,axis){if(this.grid){$super(axis)}}});Rickshaw.namespace("Rickshaw.Graph.Behavior.Series.Highlight");Rickshaw.Graph.Behavior.Series.Highlight=function(args){this.graph=args.graph;this.legend=args.legend;var self=this;var colorSafe={};var activeLine=null;var disabledColor=args.disabledColor||function(seriesColor){return d3.interpolateRgb(seriesColor,d3.rgb("#d8d8d8"))(.8).toString()};this.addHighlightEvents=function(l){l.element.addEventListener("mouseover",function(e){if(activeLine)return;else activeLine=l;self.legend.lines.forEach(function(line){if(l===line){if(self.graph.renderer.unstack&&(line.series.renderer?line.series.renderer.unstack:true)){var seriesIndex=self.graph.series.indexOf(line.series);line.originalIndex=seriesIndex;var series=self.graph.series.splice(seriesIndex,1)[0];self.graph.series.push(series)}return}colorSafe[line.series.name]=colorSafe[line.series.name]||line.series.color;line.series.color=disabledColor(line.series.color)});self.graph.update()},false);l.element.addEventListener("mouseout",function(e){if(!activeLine)return;else activeLine=null;self.legend.lines.forEach(function(line){if(l===line&&line.hasOwnProperty("originalIndex")){var series=self.graph.series.pop();self.graph.series.splice(line.originalIndex,0,series);delete line.originalIndex}if(colorSafe[line.series.name]){line.series.color=colorSafe[line.series.name]}});self.graph.update()},false)};if(this.legend){this.legend.lines.forEach(function(l){self.addHighlightEvents(l)})}};Rickshaw.namespace("Rickshaw.Graph.Behavior.Series.Order");Rickshaw.Graph.Behavior.Series.Order=function(args){this.graph=args.graph;this.legend=args.legend;var self=this;if(typeof window.jQuery=="undefined"){throw"couldn't find jQuery at window.jQuery"}if(typeof window.jQuery.ui=="undefined"){throw"couldn't find jQuery UI at window.jQuery.ui"}jQuery(function(){jQuery(self.legend.list).sortable({containment:"parent",tolerance:"pointer",update:function(event,ui){var series=[];jQuery(self.legend.list).find("li").each(function(index,item){if(!item.series)return;series.push(item.series)});for(var i=self.graph.series.length-1;i>=0;i--){self.graph.series[i]=series.shift()}self.graph.update()}});jQuery(self.legend.list).disableSelection()});this.graph.onUpdate(function(){var h=window.getComputedStyle(self.legend.element).height;self.legend.element.style.height=h})};Rickshaw.namespace("Rickshaw.Graph.Behavior.Series.Toggle");Rickshaw.Graph.Behavior.Series.Toggle=function(args){this.graph=args.graph;this.legend=args.legend;var self=this;this.addAnchor=function(line){var anchor=document.createElement("a");anchor.innerHTML="&#10004;";anchor.classList.add("action");line.element.insertBefore(anchor,line.element.firstChild);anchor.onclick=function(e){if(line.series.disabled){line.series.enable();line.element.classList.remove("disabled")}else{if(this.graph.series.filter(function(s){return!s.disabled}).length<=1)return;line.series.disable();line.element.classList.add("disabled")}}.bind(this);var label=line.element.getElementsByTagName("span")[0];label.onclick=function(e){var disableAllOtherLines=line.series.disabled;if(!disableAllOtherLines){for(var i=0;i<self.legend.lines.length;i++){var l=self.legend.lines[i];if(line.series===l.series){}else if(l.series.disabled){}else{disableAllOtherLines=true;break}}}if(disableAllOtherLines){line.series.enable();line.element.classList.remove("disabled");self.legend.lines.forEach(function(l){if(line.series===l.series){}else{l.series.disable();l.element.classList.add("disabled")}})}else{self.legend.lines.forEach(function(l){l.series.enable();l.element.classList.remove("disabled")})}}};if(this.legend){var $=jQuery;if(typeof $!="undefined"&&$(this.legend.list).sortable){$(this.legend.list).sortable({start:function(event,ui){ui.item.bind("no.onclick",function(event){event.preventDefault()})},stop:function(event,ui){setTimeout(function(){ui.item.unbind("no.onclick")},250)}})}this.legend.lines.forEach(function(l){self.addAnchor(l)})}this._addBehavior=function(){this.graph.series.forEach(function(s){s.disable=function(){if(self.graph.series.length<=1){throw"only one series left"}s.disabled=true;self.graph.update()};s.enable=function(){s.disabled=false;self.graph.update()}})};this._addBehavior();this.updateBehaviour=function(){this._addBehavior()}};Rickshaw.namespace("Rickshaw.Graph.HoverDetail");Rickshaw.Graph.HoverDetail=Rickshaw.Class.create({initialize:function(args){var graph=this.graph=args.graph;this.xFormatter=args.xFormatter||function(x){return new Date(x*1e3).toUTCString()};this.yFormatter=args.yFormatter||function(y){return y===null?y:y.toFixed(2)};var element=this.element=document.createElement("div");element.className="detail";this.visible=true;graph.element.appendChild(element);this.lastEvent=null;this._addListeners();this.onShow=args.onShow;this.onHide=args.onHide;this.onRender=args.onRender;this.formatter=args.formatter||this.formatter},formatter:function(series,x,y,formattedX,formattedY,d){return series.name+":&nbsp;"+formattedY},update:function(e){e=e||this.lastEvent;if(!e)return;this.lastEvent=e;if(!e.target.nodeName.match(/^(path|svg|rect|circle)$/))return;var graph=this.graph;var eventX=e.offsetX||e.layerX;var eventY=e.offsetY||e.layerY;var j=0;var points=[];var nearestPoint;this.graph.series.active().forEach(function(series){var data=this.graph.stackedData[j++];if(!data.length)return;var domainX=graph.x.invert(eventX);var domainIndexScale=d3.scale.linear().domain([data[0].x,data.slice(-1)[0].x]).range([0,data.length-1]);var approximateIndex=Math.round(domainIndexScale(domainX));if(approximateIndex==data.length-1)approximateIndex--;var dataIndex=Math.min(approximateIndex||0,data.length-1);for(var i=approximateIndex;i<data.length-1;){if(!data[i]||!data[i+1])break;if(data[i].x<=domainX&&data[i+1].x>domainX){dataIndex=Math.abs(domainX-data[i].x)<Math.abs(domainX-data[i+1].x)?i:i+1;break}if(data[i+1].x<=domainX){i++}else{i--}}if(dataIndex<0)dataIndex=0;var value=data[dataIndex];var distance=Math.sqrt(Math.pow(Math.abs(graph.x(value.x)-eventX),2)+Math.pow(Math.abs(graph.y(value.y+value.y0)-eventY),2));var xFormatter=series.xFormatter||this.xFormatter;var yFormatter=series.yFormatter||this.yFormatter;var point={formattedXValue:xFormatter(value.x),formattedYValue:yFormatter(series.scale?series.scale.invert(value.y):value.y),series:series,value:value,distance:distance,order:j,name:series.name};if(!nearestPoint||distance<nearestPoint.distance){nearestPoint=point}points.push(point)},this);if(!nearestPoint)return;nearestPoint.active=true;var domainX=nearestPoint.value.x;var formattedXValue=nearestPoint.formattedXValue;this.element.innerHTML="";this.element.style.left=graph.x(domainX)+"px";this.visible&&this.render({points:points,detail:points,mouseX:eventX,mouseY:eventY,formattedXValue:formattedXValue,domainX:domainX})},hide:function(){this.visible=false;this.element.classList.add("inactive");if(typeof this.onHide=="function"){this.onHide()}},show:function(){this.visible=true;this.element.classList.remove("inactive");if(typeof this.onShow=="function"){this.onShow()}},render:function(args){var graph=this.graph;var points=args.points;var point=points.filter(function(p){return p.active}).shift();if(point.value.y===null)return;var formattedXValue=point.formattedXValue;var formattedYValue=point.formattedYValue;this.element.innerHTML="";this.element.style.left=graph.x(point.value.x)+"px";var xLabel=document.createElement("div");xLabel.className="x_label";xLabel.innerHTML=formattedXValue;this.element.appendChild(xLabel);var item=document.createElement("div");item.className="item";var series=point.series;var actualY=series.scale?series.scale.invert(point.value.y):point.value.y;item.innerHTML=this.formatter(series,point.value.x,actualY,formattedXValue,formattedYValue,point);item.style.top=this.graph.y(point.value.y0+point.value.y)+"px";this.element.appendChild(item);var dot=document.createElement("div");dot.className="dot";dot.style.top=item.style.top;dot.style.borderColor=series.color;this.element.appendChild(dot);if(point.active){item.classList.add("active");dot.classList.add("active")}var alignables=[xLabel,item];alignables.forEach(function(el){el.classList.add("left")});this.show();var leftAlignError=this._calcLayoutError(alignables);if(leftAlignError>0){alignables.forEach(function(el){el.classList.remove("left");el.classList.add("right")});var rightAlignError=this._calcLayoutError(alignables);if(rightAlignError>leftAlignError){alignables.forEach(function(el){el.classList.remove("right");el.classList.add("left")})}}if(typeof this.onRender=="function"){this.onRender(args)}},_calcLayoutError:function(alignables){var parentRect=this.element.parentNode.getBoundingClientRect();var error=0;var alignRight=alignables.forEach(function(el){var rect=el.getBoundingClientRect();if(!rect.width){return}if(rect.right>parentRect.right){error+=rect.right-parentRect.right}if(rect.left<parentRect.left){error+=parentRect.left-rect.left}});return error},_addListeners:function(){this.graph.element.addEventListener("mousemove",function(e){this.visible=true;this.update(e)}.bind(this),false);this.graph.onUpdate(function(){this.update()}.bind(this));this.graph.element.addEventListener("mouseout",function(e){if(e.relatedTarget&&!(e.relatedTarget.compareDocumentPosition(this.graph.element)&Node.DOCUMENT_POSITION_CONTAINS)){this.hide()}}.bind(this),false)}});Rickshaw.namespace("Rickshaw.Graph.JSONP");Rickshaw.Graph.JSONP=Rickshaw.Class.create(Rickshaw.Graph.Ajax,{request:function(){jQuery.ajax({url:this.dataURL,dataType:"jsonp",success:this.success.bind(this),error:this.error.bind(this)})}});Rickshaw.namespace("Rickshaw.Graph.Legend");Rickshaw.Graph.Legend=Rickshaw.Class.create({className:"rickshaw_legend",initialize:function(args){this.element=args.element;this.graph=args.graph;this.naturalOrder=args.naturalOrder;this.element.classList.add(this.className);this.list=document.createElement("ul");this.element.appendChild(this.list);this.render();this.graph.onUpdate(function(){})},render:function(){var self=this;while(this.list.firstChild){this.list.removeChild(this.list.firstChild)}this.lines=[];var series=this.graph.series.map(function(s){return s});if(!this.naturalOrder){series=series.reverse()}series.forEach(function(s){self.addLine(s)})},addLine:function(series){var line=document.createElement("li");line.className="line";if(series.disabled){line.className+=" disabled"}if(series.className){d3.select(line).classed(series.className,true)}var swatch=document.createElement("div");swatch.className="swatch";swatch.style.backgroundColor=series.color;line.appendChild(swatch);var label=document.createElement("span");label.className="label";label.innerHTML=series.name;line.appendChild(label);this.list.appendChild(line);line.series=series;if(series.noLegend){line.style.display="none"}var _line={element:line,series:series};if(this.shelving){this.shelving.addAnchor(_line);this.shelving.updateBehaviour()}if(this.highlighter){this.highlighter.addHighlightEvents(_line)}this.lines.push(_line);return line}});Rickshaw.namespace("Rickshaw.Graph.RangeSlider");Rickshaw.Graph.RangeSlider=Rickshaw.Class.create({initialize:function(args){var element=this.element=args.element;var graph=this.graph=args.graph;this.slideCallbacks=[];this.build();graph.onUpdate(function(){this.update()}.bind(this))},build:function(){var element=this.element;var graph=this.graph;var $=jQuery;var domain=graph.dataDomain();var self=this;$(function(){$(element).slider({range:true,min:domain[0],max:domain[1],values:[domain[0],domain[1]],slide:function(event,ui){if(ui.values[1]<=ui.values[0])return;graph.window.xMin=ui.values[0];graph.window.xMax=ui.values[1];graph.update();var domain=graph.dataDomain();if(domain[0]==ui.values[0]){graph.window.xMin=undefined}if(domain[1]==ui.values[1]){graph.window.xMax=undefined}self.slideCallbacks.forEach(function(callback){callback(graph,graph.window.xMin,graph.window.xMax)})}})});$(element)[0].style.width=graph.width+"px"},update:function(){var element=this.element;var graph=this.graph;var $=jQuery;var values=$(element).slider("option","values");var domain=graph.dataDomain();$(element).slider("option","min",domain[0]);$(element).slider("option","max",domain[1]);if(graph.window.xMin==null){values[0]=domain[0]}if(graph.window.xMax==null){values[1]=domain[1]}$(element).slider("option","values",values)},onSlide:function(callback){this.slideCallbacks.push(callback)}});Rickshaw.namespace("Rickshaw.Graph.RangeSlider.Preview");Rickshaw.Graph.RangeSlider.Preview=Rickshaw.Class.create({initialize:function(args){if(!args.element)throw"Rickshaw.Graph.RangeSlider.Preview needs a reference to an element";if(!args.graph&&!args.graphs)throw"Rickshaw.Graph.RangeSlider.Preview needs a reference to an graph or an array of graphs";this.element=args.element;this.element.style.position="relative";this.graphs=args.graph?[args.graph]:args.graphs;this.defaults={height:75,width:400,gripperColor:undefined,frameTopThickness:3,frameHandleThickness:10,frameColor:"#d4d4d4",frameOpacity:1,minimumFrameWidth:0,heightRatio:.2};this.heightRatio=args.heightRatio||this.defaults.heightRatio;this.defaults.gripperColor=d3.rgb(this.defaults.frameColor).darker().toString();this.configureCallbacks=[];this.slideCallbacks=[];this.previews=[];if(!args.width)this.widthFromGraph=true;if(!args.height)this.heightFromGraph=true;if(this.widthFromGraph||this.heightFromGraph){this.graphs[0].onConfigure(function(){this.configure(args);this.render()}.bind(this))}args.width=args.width||this.graphs[0].width||this.defaults.width;args.height=args.height||this.graphs[0].height*this.heightRatio||this.defaults.height;this.configure(args);this.render()},onSlide:function(callback){this.slideCallbacks.push(callback)},onConfigure:function(callback){this.configureCallbacks.push(callback)},configure:function(args){this.config=this.config||{};this.configureCallbacks.forEach(function(callback){callback(args)});Rickshaw.keys(this.defaults).forEach(function(k){this.config[k]=k in args?args[k]:k in this.config?this.config[k]:this.defaults[k]},this);if("width"in args||"height"in args){if(this.widthFromGraph){this.config.width=this.graphs[0].width}if(this.heightFromGraph){this.config.height=this.graphs[0].height*this.heightRatio;this.previewHeight=this.config.height}this.previews.forEach(function(preview){var height=this.previewHeight/this.graphs.length-this.config.frameTopThickness*2;var width=this.config.width-this.config.frameHandleThickness*2;preview.setSize({width:width,height:height});if(this.svg){var svgHeight=height+this.config.frameHandleThickness*2;var svgWidth=width+this.config.frameHandleThickness*2;this.svg.style("width",svgWidth+"px");this.svg.style("height",svgHeight+"px")}},this)}},render:function(){var self=this;this.svg=d3.select(this.element).selectAll("svg.rickshaw_range_slider_preview").data([null]);this.previewHeight=this.config.height-this.config.frameTopThickness*2;this.previewWidth=this.config.width-this.config.frameHandleThickness*2;this.currentFrame=[0,this.previewWidth];var buildGraph=function(parent,index){var graphArgs=Rickshaw.extend({},parent.config);var height=self.previewHeight/self.graphs.length;var renderer=parent.renderer.name;Rickshaw.extend(graphArgs,{element:this.appendChild(document.createElement("div")),height:height,width:self.previewWidth,series:parent.series,renderer:renderer});var graph=new Rickshaw.Graph(graphArgs);self.previews.push(graph);parent.onUpdate(function(){graph.render();self.render()});parent.onConfigure(function(args){delete args.height;args.width=args.width-self.config.frameHandleThickness*2;graph.configure(args);graph.render()});graph.render()};var graphContainer=d3.select(this.element).selectAll("div.rickshaw_range_slider_preview_container").data(this.graphs);var translateCommand="translate("+this.config.frameHandleThickness+"px, "+this.config.frameTopThickness+"px)";graphContainer.enter().append("div").classed("rickshaw_range_slider_preview_container",true).style("-webkit-transform",translateCommand).style("-moz-transform",translateCommand).style("-ms-transform",translateCommand).style("transform",translateCommand).each(buildGraph);graphContainer.exit().remove();var masterGraph=this.graphs[0];var domainScale=d3.scale.linear().domain([0,this.previewWidth]).range(masterGraph.dataDomain());var currentWindow=[masterGraph.window.xMin,masterGraph.window.xMax];this.currentFrame[0]=currentWindow[0]===undefined?0:Math.round(domainScale.invert(currentWindow[0]));if(this.currentFrame[0]<0)this.currentFrame[0]=0;this.currentFrame[1]=currentWindow[1]===undefined?this.previewWidth:domainScale.invert(currentWindow[1]);if(this.currentFrame[1]-this.currentFrame[0]<self.config.minimumFrameWidth){this.currentFrame[1]=(this.currentFrame[0]||0)+self.config.minimumFrameWidth}this.svg.enter().append("svg").classed("rickshaw_range_slider_preview",true).style("height",this.config.height+"px").style("width",this.config.width+"px").style("position","absolute").style("top",0);this._renderDimming();this._renderFrame();this._renderGrippers();this._renderHandles();this._renderMiddle();this._registerMouseEvents()},_renderDimming:function(){var element=this.svg.selectAll("path.dimming").data([null]);element.enter().append("path").attr("fill","white").attr("fill-opacity","0.7").attr("fill-rule","evenodd").classed("dimming",true);var path="";path+=" M "+this.config.frameHandleThickness+" "+this.config.frameTopThickness;path+=" h "+this.previewWidth;path+=" v "+this.previewHeight;path+=" h "+-this.previewWidth;path+=" z ";path+=" M "+Math.max(this.currentFrame[0],this.config.frameHandleThickness)+" "+this.config.frameTopThickness;path+=" H "+Math.min(this.currentFrame[1]+this.config.frameHandleThickness*2,this.previewWidth+this.config.frameHandleThickness);path+=" v "+this.previewHeight;path+=" H "+Math.max(this.currentFrame[0],this.config.frameHandleThickness);path+=" z";element.attr("d",path)},_renderFrame:function(){var element=this.svg.selectAll("path.frame").data([null]);element.enter().append("path").attr("stroke","white").attr("stroke-width","1px").attr("stroke-linejoin","round").attr("fill",this.config.frameColor).attr("fill-opacity",this.config.frameOpacity).attr("fill-rule","evenodd").classed("frame",true);var path="";path+=" M "+this.currentFrame[0]+" 0";path+=" H "+(this.currentFrame[1]+this.config.frameHandleThickness*2);path+=" V "+this.config.height;path+=" H "+this.currentFrame[0];path+=" z";path+=" M "+(this.currentFrame[0]+this.config.frameHandleThickness)+" "+this.config.frameTopThickness;path+=" H "+(this.currentFrame[1]+this.config.frameHandleThickness);path+=" v "+this.previewHeight;path+=" H "+(this.currentFrame[0]+this.config.frameHandleThickness);path+=" z";element.attr("d",path)},_renderGrippers:function(){var gripper=this.svg.selectAll("path.gripper").data([null]);gripper.enter().append("path").attr("stroke",this.config.gripperColor).classed("gripper",true);var path="";[.4,.6].forEach(function(spacing){path+=" M "+Math.round(this.currentFrame[0]+this.config.frameHandleThickness*spacing)+" "+Math.round(this.config.height*.3);path+=" V "+Math.round(this.config.height*.7);path+=" M "+Math.round(this.currentFrame[1]+this.config.frameHandleThickness*(1+spacing))+" "+Math.round(this.config.height*.3);path+=" V "+Math.round(this.config.height*.7)}.bind(this));gripper.attr("d",path)},_renderHandles:function(){var leftHandle=this.svg.selectAll("rect.left_handle").data([null]);leftHandle.enter().append("rect").attr("width",this.config.frameHandleThickness).style("cursor","ew-resize").style("fill-opacity","0").classed("left_handle",true);leftHandle.attr("x",this.currentFrame[0]).attr("height",this.config.height);var rightHandle=this.svg.selectAll("rect.right_handle").data([null]);rightHandle.enter().append("rect").attr("width",this.config.frameHandleThickness).style("cursor","ew-resize").style("fill-opacity","0").classed("right_handle",true);rightHandle.attr("x",this.currentFrame[1]+this.config.frameHandleThickness).attr("height",this.config.height)},_renderMiddle:function(){var middleHandle=this.svg.selectAll("rect.middle_handle").data([null]);middleHandle.enter().append("rect").style("cursor","move").style("fill-opacity","0").classed("middle_handle",true);middleHandle.attr("width",Math.max(0,this.currentFrame[1]-this.currentFrame[0])).attr("x",this.currentFrame[0]+this.config.frameHandleThickness).attr("height",this.config.height)},_registerMouseEvents:function(){var element=d3.select(this.element);var drag={target:null,start:null,stop:null,left:false,right:false,rigid:false};var self=this;function onMousemove(datum,index){drag.stop=self._getClientXFromEvent(d3.event,drag);var distanceTraveled=drag.stop-drag.start;var frameAfterDrag=self.frameBeforeDrag.slice(0);var minimumFrameWidth=self.config.minimumFrameWidth;if(drag.rigid){minimumFrameWidth=self.frameBeforeDrag[1]-self.frameBeforeDrag[0]}if(drag.left){frameAfterDrag[0]=Math.max(frameAfterDrag[0]+distanceTraveled,0)}if(drag.right){frameAfterDrag[1]=Math.min(frameAfterDrag[1]+distanceTraveled,self.previewWidth)}var currentFrameWidth=frameAfterDrag[1]-frameAfterDrag[0];if(currentFrameWidth<=minimumFrameWidth){if(drag.left){frameAfterDrag[0]=frameAfterDrag[1]-minimumFrameWidth}if(drag.right){frameAfterDrag[1]=frameAfterDrag[0]+minimumFrameWidth}if(frameAfterDrag[0]<=0){frameAfterDrag[1]-=frameAfterDrag[0];frameAfterDrag[0]=0}if(frameAfterDrag[1]>=self.previewWidth){frameAfterDrag[0]-=frameAfterDrag[1]-self.previewWidth;frameAfterDrag[1]=self.previewWidth}}self.graphs.forEach(function(graph){var domainScale=d3.scale.linear().interpolate(d3.interpolateNumber).domain([0,self.previewWidth]).range(graph.dataDomain());var windowAfterDrag=[domainScale(frameAfterDrag[0]),domainScale(frameAfterDrag[1])];self.slideCallbacks.forEach(function(callback){callback(graph,windowAfterDrag[0],windowAfterDrag[1])});if(frameAfterDrag[0]===0){windowAfterDrag[0]=undefined}if(frameAfterDrag[1]===self.previewWidth){windowAfterDrag[1]=undefined}graph.window.xMin=windowAfterDrag[0];graph.window.xMax=windowAfterDrag[1];graph.update()})}function onMousedown(){drag.target=d3.event.target;drag.start=self._getClientXFromEvent(d3.event,drag);self.frameBeforeDrag=self.currentFrame.slice();d3.event.preventDefault?d3.event.preventDefault():d3.event.returnValue=false;d3.select(document).on("mousemove.rickshaw_range_slider_preview",onMousemove);d3.select(document).on("mouseup.rickshaw_range_slider_preview",onMouseup);d3.select(document).on("touchmove.rickshaw_range_slider_preview",onMousemove);d3.select(document).on("touchend.rickshaw_range_slider_preview",onMouseup);d3.select(document).on("touchcancel.rickshaw_range_slider_preview",onMouseup)}function onMousedownLeftHandle(datum,index){drag.left=true;onMousedown()}function onMousedownRightHandle(datum,index){drag.right=true;onMousedown()}function onMousedownMiddleHandle(datum,index){drag.left=true;drag.right=true;drag.rigid=true;onMousedown()}function onMouseup(datum,index){d3.select(document).on("mousemove.rickshaw_range_slider_preview",null);d3.select(document).on("mouseup.rickshaw_range_slider_preview",null);d3.select(document).on("touchmove.rickshaw_range_slider_preview",null);d3.select(document).on("touchend.rickshaw_range_slider_preview",null);d3.select(document).on("touchcancel.rickshaw_range_slider_preview",null);delete self.frameBeforeDrag;drag.left=false;drag.right=false;drag.rigid=false}element.select("rect.left_handle").on("mousedown",onMousedownLeftHandle);element.select("rect.right_handle").on("mousedown",onMousedownRightHandle);element.select("rect.middle_handle").on("mousedown",onMousedownMiddleHandle);element.select("rect.left_handle").on("touchstart",onMousedownLeftHandle);element.select("rect.right_handle").on("touchstart",onMousedownRightHandle);element.select("rect.middle_handle").on("touchstart",onMousedownMiddleHandle)},_getClientXFromEvent:function(event,drag){switch(event.type){case"touchstart":case"touchmove":var touchList=event.changedTouches;var touch=null;for(var touchIndex=0;touchIndex<touchList.length;touchIndex++){if(touchList[touchIndex].target===drag.target){touch=touchList[touchIndex];break}}return touch!==null?touch.clientX:undefined;default:return event.clientX}}});Rickshaw.namespace("Rickshaw.Graph.Renderer");Rickshaw.Graph.Renderer=Rickshaw.Class.create({initialize:function(args){this.graph=args.graph;this.tension=args.tension||this.tension;this.configure(args)},seriesPathFactory:function(){},seriesStrokeFactory:function(){},defaults:function(){return{tension:.8,strokeWidth:2,unstack:true,padding:{top:.01,right:0,bottom:.01,left:0},stroke:false,fill:false}},domain:function(data){var stackedData=data||this.graph.stackedData||this.graph.stackData();var xMin=+Infinity;var xMax=-Infinity;var yMin=+Infinity;var yMax=-Infinity;stackedData.forEach(function(series){series.forEach(function(d){if(d.y==null)return;var y=d.y+d.y0;if(y<yMin)yMin=y;if(y>yMax)yMax=y});if(!series.length)return;if(series[0].x<xMin)xMin=series[0].x;if(series[series.length-1].x>xMax)xMax=series[series.length-1].x});xMin-=(xMax-xMin)*this.padding.left;xMax+=(xMax-xMin)*this.padding.right;yMin=this.graph.min==="auto"?yMin:this.graph.min||0;yMax=this.graph.max===undefined?yMax:this.graph.max;if(this.graph.min==="auto"||yMin<0){yMin-=(yMax-yMin)*this.padding.bottom}if(this.graph.max===undefined){yMax+=(yMax-yMin)*this.padding.top}return{x:[xMin,xMax],y:[yMin,yMax]}},render:function(args){args=args||{};var graph=this.graph;var series=args.series||graph.series;var vis=args.vis||graph.vis;vis.selectAll("*").remove();var data=series.filter(function(s){return!s.disabled}).map(function(s){return s.stack});var pathNodes=vis.selectAll("path.path").data(data).enter().append("svg:path").classed("path",true).attr("d",this.seriesPathFactory());if(this.stroke){var strokeNodes=vis.selectAll("path.stroke").data(data).enter().append("svg:path").classed("stroke",true).attr("d",this.seriesStrokeFactory())}var i=0;series.forEach(function(series){if(series.disabled)return;series.path=pathNodes[0][i];if(this.stroke)series.stroke=strokeNodes[0][i];this._styleSeries(series);i++},this)},_styleSeries:function(series){var fill=this.fill?series.color:"none";var stroke=this.stroke?series.color:"none";series.path.setAttribute("fill",fill);series.path.setAttribute("stroke",stroke);series.path.setAttribute("stroke-width",this.strokeWidth);if(series.className){d3.select(series.path).classed(series.className,true)}if(series.className&&this.stroke){d3.select(series.stroke).classed(series.className,true)}},configure:function(args){args=args||{};Rickshaw.keys(this.defaults()).forEach(function(key){if(!args.hasOwnProperty(key)){this[key]=this[key]||this.graph[key]||this.defaults()[key];return}if(typeof this.defaults()[key]=="object"){Rickshaw.keys(this.defaults()[key]).forEach(function(k){this[key][k]=args[key][k]!==undefined?args[key][k]:this[key][k]!==undefined?this[key][k]:this.defaults()[key][k]},this)}else{this[key]=args[key]!==undefined?args[key]:this[key]!==undefined?this[key]:this.graph[key]!==undefined?this.graph[key]:this.defaults()[key]}},this)},setStrokeWidth:function(strokeWidth){if(strokeWidth!==undefined){this.strokeWidth=strokeWidth}},setTension:function(tension){if(tension!==undefined){this.tension=tension}}});Rickshaw.namespace("Rickshaw.Graph.Renderer.Line");Rickshaw.Graph.Renderer.Line=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"line",defaults:function($super){return Rickshaw.extend($super(),{unstack:true,fill:false,stroke:true})},seriesPathFactory:function(){var graph=this.graph;var factory=d3.svg.line().x(function(d){return graph.x(d.x)}).y(function(d){return graph.y(d.y)}).interpolate(this.graph.interpolation).tension(this.tension);factory.defined&&factory.defined(function(d){return d.y!==null});return factory}});Rickshaw.namespace("Rickshaw.Graph.Renderer.Stack");Rickshaw.Graph.Renderer.Stack=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"stack",defaults:function($super){return Rickshaw.extend($super(),{fill:true,stroke:false,unstack:false})},seriesPathFactory:function(){var graph=this.graph;var factory=d3.svg.area().x(function(d){return graph.x(d.x)}).y0(function(d){return graph.y(d.y0)}).y1(function(d){return graph.y(d.y+d.y0)}).interpolate(this.graph.interpolation).tension(this.tension);factory.defined&&factory.defined(function(d){return d.y!==null});return factory}});Rickshaw.namespace("Rickshaw.Graph.Renderer.Bar");Rickshaw.Graph.Renderer.Bar=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"bar",defaults:function($super){var defaults=Rickshaw.extend($super(),{gapSize:.05,unstack:false});delete defaults.tension;return defaults},initialize:function($super,args){args=args||{};this.gapSize=args.gapSize||this.gapSize;$super(args)},domain:function($super){var domain=$super();var frequentInterval=this._frequentInterval(this.graph.stackedData.slice(-1).shift());domain.x[1]+=Number(frequentInterval.magnitude);return domain},barWidth:function(series){var frequentInterval=this._frequentInterval(series.stack);var barWidth=this.graph.x.magnitude(frequentInterval.magnitude)*(1-this.gapSize);return barWidth},render:function(args){args=args||{};var graph=this.graph;var series=args.series||graph.series;var vis=args.vis||graph.vis;vis.selectAll("*").remove();var barWidth=this.barWidth(series.active()[0]);var barXOffset=0;var activeSeriesCount=series.filter(function(s){return!s.disabled}).length;var seriesBarWidth=this.unstack?barWidth/activeSeriesCount:barWidth;var transform=function(d){var matrix=[1,0,0,d.y<0?-1:1,0,d.y<0?graph.y.magnitude(Math.abs(d.y))*2:0];return"matrix("+matrix.join(",")+")"};series.forEach(function(series){if(series.disabled)return;var barWidth=this.barWidth(series);var nodes=vis.selectAll("path").data(series.stack.filter(function(d){return d.y!==null})).enter().append("svg:rect").attr("x",function(d){return graph.x(d.x)+barXOffset}).attr("y",function(d){return graph.y(d.y0+Math.abs(d.y))*(d.y<0?-1:1)}).attr("width",seriesBarWidth).attr("height",function(d){return graph.y.magnitude(Math.abs(d.y))}).attr("transform",transform);Array.prototype.forEach.call(nodes[0],function(n){n.setAttribute("fill",series.color)});if(this.unstack)barXOffset+=seriesBarWidth},this)},_frequentInterval:function(data){var intervalCounts={};for(var i=0;i<data.length-1;i++){var interval=data[i+1].x-data[i].x;intervalCounts[interval]=intervalCounts[interval]||0;intervalCounts[interval]++}var frequentInterval={count:0,magnitude:1};Rickshaw.keys(intervalCounts).forEach(function(i){if(frequentInterval.count<intervalCounts[i]){frequentInterval={count:intervalCounts[i],magnitude:i}}});return frequentInterval}});Rickshaw.namespace("Rickshaw.Graph.Renderer.Area");Rickshaw.Graph.Renderer.Area=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"area",defaults:function($super){return Rickshaw.extend($super(),{unstack:false,fill:false,stroke:false})},seriesPathFactory:function(){var graph=this.graph;var factory=d3.svg.area().x(function(d){return graph.x(d.x)}).y0(function(d){return graph.y(d.y0)}).y1(function(d){return graph.y(d.y+d.y0)}).interpolate(graph.interpolation).tension(this.tension);
factory.defined&&factory.defined(function(d){return d.y!==null});return factory},seriesStrokeFactory:function(){var graph=this.graph;var factory=d3.svg.line().x(function(d){return graph.x(d.x)}).y(function(d){return graph.y(d.y+d.y0)}).interpolate(graph.interpolation).tension(this.tension);factory.defined&&factory.defined(function(d){return d.y!==null});return factory},render:function(args){args=args||{};var graph=this.graph;var series=args.series||graph.series;var vis=args.vis||graph.vis;vis.selectAll("*").remove();var method=this.unstack?"append":"insert";var data=series.filter(function(s){return!s.disabled}).map(function(s){return s.stack});var nodes=vis.selectAll("path").data(data).enter()[method]("svg:g","g");nodes.append("svg:path").attr("d",this.seriesPathFactory()).attr("class","area");if(this.stroke){nodes.append("svg:path").attr("d",this.seriesStrokeFactory()).attr("class","line")}var i=0;series.forEach(function(series){if(series.disabled)return;series.path=nodes[0][i++];this._styleSeries(series)},this)},_styleSeries:function(series){if(!series.path)return;d3.select(series.path).select(".area").attr("fill",series.color);if(this.stroke){d3.select(series.path).select(".line").attr("fill","none").attr("stroke",series.stroke||d3.interpolateRgb(series.color,"black")(.125)).attr("stroke-width",this.strokeWidth)}if(series.className){series.path.setAttribute("class",series.className)}}});Rickshaw.namespace("Rickshaw.Graph.Renderer.ScatterPlot");Rickshaw.Graph.Renderer.ScatterPlot=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"scatterplot",defaults:function($super){return Rickshaw.extend($super(),{unstack:true,fill:true,stroke:false,padding:{top:.01,right:.01,bottom:.01,left:.01},dotSize:4})},initialize:function($super,args){$super(args)},render:function(args){args=args||{};var graph=this.graph;var series=args.series||graph.series;var vis=args.vis||graph.vis;var dotSize=this.dotSize;vis.selectAll("*").remove();series.forEach(function(series){if(series.disabled)return;var nodes=vis.selectAll("path").data(series.stack.filter(function(d){return d.y!==null})).enter().append("svg:circle").attr("cx",function(d){return graph.x(d.x)}).attr("cy",function(d){return graph.y(d.y)}).attr("r",function(d){return"r"in d?d.r:dotSize});if(series.className){nodes.classed(series.className,true)}Array.prototype.forEach.call(nodes[0],function(n){n.setAttribute("fill",series.color)})},this)}});Rickshaw.namespace("Rickshaw.Graph.Renderer.Multi");Rickshaw.Graph.Renderer.Multi=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"multi",initialize:function($super,args){$super(args)},defaults:function($super){return Rickshaw.extend($super(),{unstack:true,fill:false,stroke:true})},configure:function($super,args){args=args||{};this.config=args;$super(args)},domain:function($super){this.graph.stackData();var domains=[];var groups=this._groups();this._stack(groups);groups.forEach(function(group){var data=group.series.filter(function(s){return!s.disabled}).map(function(s){return s.stack});if(!data.length)return;var domain=null;if(group.renderer&&group.renderer.domain){domain=group.renderer.domain(data)}else{domain=$super(data)}domains.push(domain)});var xMin=d3.min(domains.map(function(d){return d.x[0]}));var xMax=d3.max(domains.map(function(d){return d.x[1]}));var yMin=d3.min(domains.map(function(d){return d.y[0]}));var yMax=d3.max(domains.map(function(d){return d.y[1]}));return{x:[xMin,xMax],y:[yMin,yMax]}},_groups:function(){var graph=this.graph;var renderGroups={};graph.series.forEach(function(series){if(series.disabled)return;if(!renderGroups[series.renderer]){var ns="http://www.w3.org/2000/svg";var vis=document.createElementNS(ns,"g");graph.vis[0][0].appendChild(vis);var renderer=graph._renderers[series.renderer];var config={};var defaults=[this.defaults(),renderer.defaults(),this.config,this.graph];defaults.forEach(function(d){Rickshaw.extend(config,d)});renderer.configure(config);renderGroups[series.renderer]={renderer:renderer,series:[],vis:d3.select(vis)}}renderGroups[series.renderer].series.push(series)},this);var groups=[];Object.keys(renderGroups).forEach(function(key){var group=renderGroups[key];groups.push(group)});return groups},_stack:function(groups){groups.forEach(function(group){var series=group.series.filter(function(series){return!series.disabled});var data=series.map(function(series){return series.stack});if(!group.renderer.unstack){var layout=d3.layout.stack();var stackedData=Rickshaw.clone(layout(data));series.forEach(function(series,index){series._stack=Rickshaw.clone(stackedData[index])})}},this);return groups},render:function(){this.graph.series.forEach(function(series){if(!series.renderer){throw new Error("Each series needs a renderer for graph 'multi' renderer")}});this.graph.vis.selectAll("*").remove();var groups=this._groups();groups=this._stack(groups);groups.forEach(function(group){var series=group.series.filter(function(series){return!series.disabled});series.active=function(){return series};group.renderer.render({series:series,vis:group.vis});series.forEach(function(s){s.stack=s._stack||s.stack||s.data})})}});Rickshaw.namespace("Rickshaw.Graph.Renderer.LinePlot");Rickshaw.Graph.Renderer.LinePlot=Rickshaw.Class.create(Rickshaw.Graph.Renderer,{name:"lineplot",defaults:function($super){return Rickshaw.extend($super(),{unstack:true,fill:false,stroke:true,padding:{top:.01,right:.01,bottom:.01,left:.01},dotSize:3,strokeWidth:2})},seriesPathFactory:function(){var graph=this.graph;var factory=d3.svg.line().x(function(d){return graph.x(d.x)}).y(function(d){return graph.y(d.y)}).interpolate(this.graph.interpolation).tension(this.tension);factory.defined&&factory.defined(function(d){return d.y!==null});return factory},render:function(args){args=args||{};var graph=this.graph;var series=args.series||graph.series;var vis=args.vis||graph.vis;var dotSize=this.dotSize;vis.selectAll("*").remove();var data=series.filter(function(s){return!s.disabled}).map(function(s){return s.stack});var nodes=vis.selectAll("path").data(data).enter().append("svg:path").attr("d",this.seriesPathFactory());var i=0;series.forEach(function(series){if(series.disabled)return;series.path=nodes[0][i++];this._styleSeries(series)},this);series.forEach(function(series){if(series.disabled)return;var nodes=vis.selectAll("x").data(series.stack.filter(function(d){return d.y!==null})).enter().append("svg:circle").attr("cx",function(d){return graph.x(d.x)}).attr("cy",function(d){return graph.y(d.y)}).attr("r",function(d){return"r"in d?d.r:dotSize});Array.prototype.forEach.call(nodes[0],function(n){if(!n)return;n.setAttribute("data-color",series.color);n.setAttribute("fill","white");n.setAttribute("stroke",series.color);n.setAttribute("stroke-width",this.strokeWidth)}.bind(this))},this)}});Rickshaw.namespace("Rickshaw.Graph.Smoother");Rickshaw.Graph.Smoother=Rickshaw.Class.create({initialize:function(args){this.graph=args.graph;this.element=args.element;this.aggregationScale=1;this.build();this.graph.stackData.hooks.data.push({name:"smoother",orderPosition:50,f:this.transformer.bind(this)})},build:function(){var self=this;var $=jQuery;if(this.element){$(function(){$(self.element).slider({min:1,max:100,slide:function(event,ui){self.setScale(ui.value);self.graph.update()}})})}},setScale:function(scale){if(scale<1){throw"scale out of range: "+scale}this.aggregationScale=scale;this.graph.update()},transformer:function(data){if(this.aggregationScale==1)return data;var aggregatedData=[];data.forEach(function(seriesData){var aggregatedSeriesData=[];while(seriesData.length){var avgX=0,avgY=0;var slice=seriesData.splice(0,this.aggregationScale);slice.forEach(function(d){avgX+=d.x/slice.length;avgY+=d.y/slice.length});aggregatedSeriesData.push({x:avgX,y:avgY})}aggregatedData.push(aggregatedSeriesData)}.bind(this));return aggregatedData}});Rickshaw.namespace("Rickshaw.Graph.Socketio");Rickshaw.Graph.Socketio=Rickshaw.Class.create(Rickshaw.Graph.Ajax,{request:function(){var socket=io.connect(this.dataURL);var self=this;socket.on("rickshaw",function(data){self.success(data)})}});Rickshaw.namespace("Rickshaw.Series");Rickshaw.Series=Rickshaw.Class.create(Array,{initialize:function(data,palette,options){options=options||{};this.palette=new Rickshaw.Color.Palette(palette);this.timeBase=typeof options.timeBase==="undefined"?Math.floor((new Date).getTime()/1e3):options.timeBase;var timeInterval=typeof options.timeInterval=="undefined"?1e3:options.timeInterval;this.setTimeInterval(timeInterval);if(data&&typeof data=="object"&&Array.isArray(data)){data.forEach(function(item){this.addItem(item)},this)}},addItem:function(item){if(typeof item.name==="undefined"){throw"addItem() needs a name"}item.color=item.color||this.palette.color(item.name);item.data=item.data||[];if(item.data.length===0&&this.length&&this.getIndex()>0){this[0].data.forEach(function(plot){item.data.push({x:plot.x,y:0})})}else if(item.data.length===0){item.data.push({x:this.timeBase-(this.timeInterval||0),y:0})}this.push(item);if(this.legend){this.legend.addLine(this.itemByName(item.name))}},addData:function(data,x){var index=this.getIndex();Rickshaw.keys(data).forEach(function(name){if(!this.itemByName(name)){this.addItem({name:name})}},this);this.forEach(function(item){item.data.push({x:x||(index*this.timeInterval||1)+this.timeBase,y:data[item.name]||0})},this)},getIndex:function(){return this[0]&&this[0].data&&this[0].data.length?this[0].data.length:0},itemByName:function(name){for(var i=0;i<this.length;i++){if(this[i].name==name)return this[i]}},setTimeInterval:function(iv){this.timeInterval=iv/1e3},setTimeBase:function(t){this.timeBase=t},dump:function(){var data={timeBase:this.timeBase,timeInterval:this.timeInterval,items:[]};this.forEach(function(item){var newItem={color:item.color,name:item.name,data:[]};item.data.forEach(function(plot){newItem.data.push({x:plot.x,y:plot.y})});data.items.push(newItem)});return data},load:function(data){if(data.timeInterval){this.timeInterval=data.timeInterval}if(data.timeBase){this.timeBase=data.timeBase}if(data.items){data.items.forEach(function(item){this.push(item);if(this.legend){this.legend.addLine(this.itemByName(item.name))}},this)}}});Rickshaw.Series.zeroFill=function(series){Rickshaw.Series.fill(series,0)};Rickshaw.Series.fill=function(series,fill){var x;var i=0;var data=series.map(function(s){return s.data});while(i<Math.max.apply(null,data.map(function(d){return d.length}))){x=Math.min.apply(null,data.filter(function(d){return d[i]}).map(function(d){return d[i].x}));data.forEach(function(d){if(!d[i]||d[i].x!=x){d.splice(i,0,{x:x,y:fill})}});i++}};Rickshaw.namespace("Rickshaw.Series.FixedDuration");Rickshaw.Series.FixedDuration=Rickshaw.Class.create(Rickshaw.Series,{initialize:function(data,palette,options){options=options||{};if(typeof options.timeInterval==="undefined"){throw new Error("FixedDuration series requires timeInterval")}if(typeof options.maxDataPoints==="undefined"){throw new Error("FixedDuration series requires maxDataPoints")}this.palette=new Rickshaw.Color.Palette(palette);this.timeBase=typeof options.timeBase==="undefined"?Math.floor((new Date).getTime()/1e3):options.timeBase;this.setTimeInterval(options.timeInterval);if(this[0]&&this[0].data&&this[0].data.length){this.currentSize=this[0].data.length;this.currentIndex=this[0].data.length}else{this.currentSize=0;this.currentIndex=0}this.maxDataPoints=options.maxDataPoints;if(data&&typeof data=="object"&&Array.isArray(data)){data.forEach(function(item){this.addItem(item)},this);this.currentSize+=1;this.currentIndex+=1}this.timeBase-=(this.maxDataPoints-this.currentSize)*this.timeInterval;if(typeof this.maxDataPoints!=="undefined"&&this.currentSize<this.maxDataPoints){for(var i=this.maxDataPoints-this.currentSize-1;i>1;i--){this.currentSize+=1;this.currentIndex+=1;this.forEach(function(item){item.data.unshift({x:((i-1)*this.timeInterval||1)+this.timeBase,y:0,i:i})},this)}}},addData:function($super,data,x){$super(data,x);this.currentSize+=1;this.currentIndex+=1;if(this.maxDataPoints!==undefined){while(this.currentSize>this.maxDataPoints){this.dropData()}}},dropData:function(){this.forEach(function(item){item.data.splice(0,1)});this.currentSize-=1},getIndex:function(){return this.currentIndex}});return Rickshaw});function do_pie(name,update_url,url_params,units,refresh){var pie=new PieChart(name,update_url,url_params,units,refresh);if(refresh)pie.setInterval(setInterval(function(){pie.update()},refresh));return pie}function PieChart(name,update_url,url_params,units,refresh){this.name=name;this.update_url=update_url;this.url_params=url_params;this.units=units;this.refresh=refresh;this.pieInterval;var pieData=[];var oldPieData=[];var filteredPieData=[];var rsp=create_pie_chart(name,units);var arc_group=rsp[0];var donut=rsp[1];var totalValue=rsp[2];var totalUnits=rsp[3];var color=rsp[4];var tweenDuration=rsp[5];var arc=rsp[6];var label_group=rsp[7];var center_group=rsp[8];var r=rsp[9];var textOffset=rsp[10];this.update=function(){$.ajax({type:"GET",url:this.update_url,data:this.url_params,success:function(content){update_pie_chart(jQuery.parseJSON(content))}})};this.update();this.update();function update_pie_chart(data){streakerDataAdded=data;oldPieData=filteredPieData;pieData=donut(streakerDataAdded);var totalOctets=0;filteredPieData=pieData.filter(filterData);function filterData(element,index,array){element.name=streakerDataAdded[index].label;element.value=streakerDataAdded[index].value;element.url=streakerDataAdded[index].url;totalOctets+=element.value;return element.value>0}if(filteredPieData.length>0&&oldPieData.length>0){arc_group.selectAll("circle").remove();if(totalValue){totalValue.text(function(){var kb=totalOctets/1024;return kb.toFixed(1)})}paths=arc_group.selectAll("path").data(filteredPieData);paths.enter().append("svg:path").attr("stroke","white").attr("stroke-width",.5).attr("fill",function(d,i){return color(i)}).transition().duration(tweenDuration).attrTween("d",pieTween);paths.transition().duration(tweenDuration).attrTween("d",pieTween);paths.exit().transition().duration(tweenDuration).attrTween("d",removePieTween).remove();lines=label_group.selectAll("line").data(filteredPieData);lines.enter().append("svg:line").attr("x1",0).attr("x2",0).attr("y1",-r-3).attr("y2",-r-8).attr("stroke","gray").attr("transform",function(d){return"rotate("+(d.startAngle+d.endAngle)/2*(180/Math.PI)+")"});lines.transition().duration(tweenDuration).attr("transform",function(d){return"rotate("+(d.startAngle+d.endAngle)/2*(180/Math.PI)+")"});lines.exit().remove();valueLabels=label_group.selectAll("text.value").data(filteredPieData).attr("dy",function(d){if((d.startAngle+d.endAngle)/2>Math.PI/2&&(d.startAngle+d.endAngle)/2<Math.PI*1.5){return 5}else{return-7}}).attr("text-anchor",function(d){if((d.startAngle+d.endAngle)/2<Math.PI){return"beginning"}else{return"end"}}).text(function(d){var percentage=d.value/totalOctets*100;return percentage.toFixed(1)+"%"});valueLabels.enter().append("svg:text").attr("class","value").attr("transform",function(d){return"translate("+Math.cos((d.startAngle+d.endAngle-Math.PI)/2)*(r+textOffset)+","+Math.sin((d.startAngle+d.endAngle-Math.PI)/2)*(r+textOffset)+")"}).attr("dy",function(d){if((d.startAngle+d.endAngle)/2>Math.PI/2&&(d.startAngle+d.endAngle)/2<Math.PI*1.5){return 5}else{return-7}}).attr("text-anchor",function(d){if((d.startAngle+d.endAngle)/2<Math.PI){return"beginning"}else{return"end"}}).text(function(d){var percentage=d.value/totalOctets*100;return percentage.toFixed(1)+"%"});valueLabels.transition().duration(tweenDuration).attrTween("transform",textTween);valueLabels.exit().remove();nameLabels=label_group.selectAll("text.units").data(filteredPieData).attr("dy",function(d){if((d.startAngle+d.endAngle)/2>Math.PI/2&&(d.startAngle+d.endAngle)/2<Math.PI*1.5){return 17}else{return 5}}).attr("text-anchor",function(d){if((d.startAngle+d.endAngle)/2<Math.PI){return"beginning"}else{return"end"}}).text(function(d){return d.name}).on("click",function(d){if(d.url)window.location.href=d.url});nameLabels.enter().append("svg:text").attr("class","units").attr("transform",function(d){return"translate("+Math.cos((d.startAngle+d.endAngle-Math.PI)/2)*(r+textOffset)+","+Math.sin((d.startAngle+d.endAngle-Math.PI)/2)*(r+textOffset)+")"}).attr("dy",function(d){if((d.startAngle+d.endAngle)/2>Math.PI/2&&(d.startAngle+d.endAngle)/2<Math.PI*1.5){return 17}else{return 5}}).attr("text-anchor",function(d){if((d.startAngle+d.endAngle)/2<Math.PI){return"beginning"}else{return"end"}}).text(function(d){return d.name}).on("click",function(d){if(d.url)window.location.href=d.url});nameLabels.transition().duration(tweenDuration).attrTween("transform",textTween);nameLabels.exit().remove()}}function pieTween(d,i){var s0;var e0;if(oldPieData[i]){s0=oldPieData[i].startAngle;e0=oldPieData[i].endAngle}else if(!oldPieData[i]&&oldPieData[i-1]){s0=oldPieData[i-1].endAngle;e0=oldPieData[i-1].endAngle}else if(!oldPieData[i-1]&&oldPieData.length>0){s0=oldPieData[oldPieData.length-1].endAngle;e0=oldPieData[oldPieData.length-1].endAngle}else{s0=0;e0=0}var i=d3.interpolate({startAngle:s0,endAngle:e0},{startAngle:d.startAngle,endAngle:d.endAngle});return function(t){var b=i(t);return arc(b)}}function removePieTween(d,i){s0=2*Math.PI;e0=2*Math.PI;var i=d3.interpolate({startAngle:d.startAngle,endAngle:d.endAngle},{startAngle:s0,endAngle:e0});return function(t){var b=i(t);return arc(b)}}function textTween(d,i){var a;if(oldPieData[i]){a=(oldPieData[i].startAngle+oldPieData[i].endAngle-Math.PI)/2}else if(!oldPieData[i]&&oldPieData[i-1]){a=(oldPieData[i-1].startAngle+oldPieData[i-1].endAngle-Math.PI)/2}else if(!oldPieData[i-1]&&oldPieData.length>0){a=(oldPieData[oldPieData.length-1].startAngle+oldPieData[oldPieData.length-1].endAngle-Math.PI)/2}else{a=0}var b=(d.startAngle+d.endAngle-Math.PI)/2;var fn=d3.interpolateNumber(a,b);return function(t){var val=fn(t);return"translate("+Math.cos(val)*(r+textOffset)+","+Math.sin(val)*(r+textOffset)+")"}}}PieChart.prototype.setUrlParams=function(url_params){this.url_params=url_params;this.forceUpdate()};PieChart.prototype.forceUpdate=function(url_params){this.stopInterval();this.update();this.startInterval()};PieChart.prototype.setInterval=function(p_pieInterval){this.pieInterval=p_pieInterval};PieChart.prototype.stopInterval=function(){clearInterval(this.pieInterval)};PieChart.prototype.startInterval=function(){this.pieInterval=setInterval(this.update(),this.refresh)};function create_pie_chart(name,units){var w=500;var h=325;var ir=52;var textOffset=14;var tweenDuration=250;var r=116;if($(name).hasClass("pie-chart-small")){w=330;h=250;r=w/5+15;ir=r/2}var lines,valueLabels,nameLabels;var donut=d3.layout.pie().value(function(d){if(d.value==0){d.value=1}return d.value});var color=d3.scale.category20();var arc=d3.svg.arc().startAngle(function(d){return d.startAngle}).endAngle(function(d){return d.endAngle}).innerRadius(ir).outerRadius(r);var vis=d3.select(name).append("svg:svg").attr("width",w).attr("height",h).attr("viewBox","0 0 "+w+" "+h).attr("preserveAspectRatio","xMidYMid");var arc_group=vis.append("svg:g").attr("class","arc").attr("transform","translate("+w/2+","+h/2+")");var label_group=vis.append("svg:g").attr("class","label_group").attr("transform","translate("+w/2+","+h/2+")");var center_group=vis.append("svg:g").attr("class","center_group").attr("transform","translate("+w/2+","+h/2+")");var paths=arc_group.append("svg:circle").attr("fill","#EFEFEF").attr("r",r);var whiteCircle=center_group.append("svg:circle").attr("fill","white").attr("r",ir);var totalUnits=null;var totalLabel=null;var totalValue=null;if(units){totalLabel=center_group.append("svg:text").attr("class","label").attr("dy",-15).attr("text-anchor","middle").text("TOTAL");totalValue=center_group.append("svg:text").attr("class","total").attr("dy",7).attr("text-anchor","middle").text("Waiting...");totalUnits=center_group.append("svg:text").attr("class","units").attr("dy",21).attr("text-anchor","middle").text(units)}return[arc_group,donut,totalValue,totalUnits,color,tweenDuration,arc,label_group,center_group,r,textOffset]}(function(){var AnimatedText,AnimatedTextFactory,Bar,BaseDonut,BaseGauge,Donut,Gauge,GaugePointer,TextRenderer,ValueUpdater,addCommas,cutHex,formatNumber,mergeObjects,secondsToString,updateObjectValues,_ref,_ref1,__hasProp={}.hasOwnProperty,__extends=function(child,parent){for(var key in parent){if(__hasProp.call(parent,key))child[key]=parent[key]}function ctor(){this.constructor=child}ctor.prototype=parent.prototype;child.prototype=new ctor;child.__super__=parent.prototype;return child};(function(){var browserRequestAnimationFrame,isCancelled,lastId,vendor,vendors,_i,_len;vendors=["ms","moz","webkit","o"];for(_i=0,_len=vendors.length;_i<_len;_i++){vendor=vendors[_i];if(window.requestAnimationFrame){break}window.requestAnimationFrame=window[vendor+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendor+"CancelAnimationFrame"]||window[vendor+"CancelRequestAnimationFrame"]}browserRequestAnimationFrame=null;lastId=0;isCancelled={};if(!requestAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime,id,lastTime,timeToCall;currTime=(new Date).getTime();timeToCall=Math.max(0,16-(currTime-lastTime));id=window.setTimeout(function(){return callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};return window.cancelAnimationFrame=function(id){return clearTimeout(id)}}else if(!window.cancelAnimationFrame){browserRequestAnimationFrame=window.requestAnimationFrame;window.requestAnimationFrame=function(callback,element){var myId;myId=++lastId;browserRequestAnimationFrame(function(){if(!isCancelled[myId]){return callback()}},element);return myId};return window.cancelAnimationFrame=function(id){return isCancelled[id]=true}}})();String.prototype.hashCode=function(){var char,hash,i,_i,_ref;hash=0;if(this.length===0){return hash}for(i=_i=0,_ref=this.length;0<=_ref?_i<_ref:_i>_ref;i=0<=_ref?++_i:--_i){char=this.charCodeAt(i);hash=(hash<<5)-hash+char;hash=hash&hash}return hash};secondsToString=function(sec){var hr,min;hr=Math.floor(sec/3600);min=Math.floor((sec-hr*3600)/60);sec-=hr*3600+min*60;sec+="";min+="";while(min.length<2){min="0"+min}while(sec.length<2){sec="0"+sec}hr=hr?hr+":":"";return hr+min+":"+sec};formatNumber=function(num){return addCommas(num.toFixed(0))};updateObjectValues=function(obj1,obj2){var key,val;for(key in obj2){if(!__hasProp.call(obj2,key))continue;val=obj2[key];obj1[key]=val}return obj1};mergeObjects=function(obj1,obj2){var key,out,val;out={};for(key in obj1){if(!__hasProp.call(obj1,key))continue;val=obj1[key];out[key]=val}for(key in obj2){if(!__hasProp.call(obj2,key))continue;val=obj2[key];out[key]=val}return out};addCommas=function(nStr){var rgx,x,x1,x2;nStr+="";x=nStr.split(".");x1=x[0];x2="";if(x.length>1){x2="."+x[1]}rgx=/(\d+)(\d{3})/;while(rgx.test(x1)){x1=x1.replace(rgx,"$1"+","+"$2")}return x1+x2};cutHex=function(nStr){if(nStr.charAt(0)==="#"){return nStr.substring(1,7)}return nStr};ValueUpdater=function(){ValueUpdater.prototype.animationSpeed=32;function ValueUpdater(addToAnimationQueue,clear){if(addToAnimationQueue==null){addToAnimationQueue=true}this.clear=clear!=null?clear:true;if(addToAnimationQueue){AnimationUpdater.add(this)}}ValueUpdater.prototype.update=function(force){var diff;if(force==null){force=false}if(force||this.displayedValue!==this.value){if(this.ctx&&this.clear){this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height)}diff=this.value-this.displayedValue;if(Math.abs(diff/this.animationSpeed)<=.001){this.displayedValue=this.value}else{this.displayedValue=this.displayedValue+diff/this.animationSpeed}this.render();return true}return false};return ValueUpdater}();BaseGauge=function(_super){__extends(BaseGauge,_super);function BaseGauge(){_ref=BaseGauge.__super__.constructor.apply(this,arguments);return _ref}BaseGauge.prototype.displayScale=1;BaseGauge.prototype.setTextField=function(textField){return this.textField=textField instanceof TextRenderer?textField:new TextRenderer(textField)};BaseGauge.prototype.setMinValue=function(minValue,updateStartValue){var gauge,_i,_len,_ref1,_results;this.minValue=minValue;if(updateStartValue==null){updateStartValue=true}if(updateStartValue){this.displayedValue=this.minValue;_ref1=this.gp||[];_results=[];for(_i=0,_len=_ref1.length;_i<_len;_i++){gauge=_ref1[_i];_results.push(gauge.displayedValue=this.minValue)}return _results}};BaseGauge.prototype.setOptions=function(options){if(options==null){options=null}this.options=mergeObjects(this.options,options);if(this.textField){this.textField.el.style.fontSize=options.fontSize+"px"}if(this.options.angle>.5){this.gauge.options.angle=.5}this.configDisplayScale();return this};BaseGauge.prototype.configDisplayScale=function(){var backingStorePixelRatio,devicePixelRatio,height,prevDisplayScale,width;prevDisplayScale=this.displayScale;if(this.options.highDpiSupport===false){delete this.displayScale}else{devicePixelRatio=window.devicePixelRatio||1;backingStorePixelRatio=this.ctx.webkitBackingStorePixelRatio||this.ctx.mozBackingStorePixelRatio||this.ctx.msBackingStorePixelRatio||this.ctx.oBackingStorePixelRatio||this.ctx.backingStorePixelRatio||1;this.displayScale=devicePixelRatio/backingStorePixelRatio}if(this.displayScale!==prevDisplayScale){width=this.canvas.G__width||this.canvas.width;height=this.canvas.G__height||this.canvas.height;this.canvas.width=width*this.displayScale;this.canvas.height=height*this.displayScale;this.canvas.style.width=""+width+"px";this.canvas.style.height=""+height+"px";this.canvas.G__width=width;this.canvas.G__height=height}return this};return BaseGauge}(ValueUpdater);TextRenderer=function(){function TextRenderer(el){this.el=el}TextRenderer.prototype.render=function(gauge){return this.el.innerHTML=formatNumber(gauge.displayedValue)};return TextRenderer}();AnimatedText=function(_super){__extends(AnimatedText,_super);AnimatedText.prototype.displayedValue=0;AnimatedText.prototype.value=0;AnimatedText.prototype.setVal=function(value){return this.value=1*value};function AnimatedText(elem,text){this.elem=elem;this.text=text!=null?text:false;this.value=1*this.elem.innerHTML;if(this.text){this.value=0}}AnimatedText.prototype.render=function(){var textVal;if(this.text){textVal=secondsToString(this.displayedValue.toFixed(0))}else{textVal=addCommas(formatNumber(this.displayedValue))}return this.elem.innerHTML=textVal};return AnimatedText}(ValueUpdater);AnimatedTextFactory={create:function(objList){var elem,out,_i,_len;out=[];for(_i=0,_len=objList.length;_i<_len;_i++){elem=objList[_i];out.push(new AnimatedText(elem))}return out}};GaugePointer=function(_super){__extends(GaugePointer,_super);GaugePointer.prototype.displayedValue=0;GaugePointer.prototype.value=0;GaugePointer.prototype.options={strokeWidth:.035,length:.1,color:"#000000"};function GaugePointer(gauge){this.gauge=gauge;this.ctx=this.gauge.ctx;this.canvas=this.gauge.canvas;GaugePointer.__super__.constructor.call(this,false,false);this.setOptions()}GaugePointer.prototype.setOptions=function(options){if(options==null){options=null}updateObjectValues(this.options,options);this.length=this.canvas.height*this.options.length;this.strokeWidth=this.canvas.height*this.options.strokeWidth;this.maxValue=this.gauge.maxValue;this.minValue=this.gauge.minValue;this.animationSpeed=this.gauge.animationSpeed;return this.options.angle=this.gauge.options.angle};GaugePointer.prototype.render=function(){var angle,centerX,centerY,endX,endY,startX,startY,x,y;angle=this.gauge.getAngle.call(this,this.displayedValue);centerX=this.canvas.width/2;centerY=this.canvas.height*.9;x=Math.round(centerX+this.length*Math.cos(angle));y=Math.round(centerY+this.length*Math.sin(angle));startX=Math.round(centerX+this.strokeWidth*Math.cos(angle-Math.PI/2));startY=Math.round(centerY+this.strokeWidth*Math.sin(angle-Math.PI/2));endX=Math.round(centerX+this.strokeWidth*Math.cos(angle+Math.PI/2));endY=Math.round(centerY+this.strokeWidth*Math.sin(angle+Math.PI/2));this.ctx.fillStyle=this.options.color;this.ctx.beginPath();this.ctx.arc(centerX,centerY,this.strokeWidth,0,Math.PI*2,true);this.ctx.fill();this.ctx.beginPath();this.ctx.moveTo(startX,startY);this.ctx.lineTo(x,y);this.ctx.lineTo(endX,endY);return this.ctx.fill()};return GaugePointer}(ValueUpdater);Bar=function(){function Bar(elem){this.elem=elem}Bar.prototype.updateValues=function(arrValues){this.value=arrValues[0];this.maxValue=arrValues[1];this.avgValue=arrValues[2];return this.render()};Bar.prototype.render=function(){var avgPercent,valPercent;if(this.textField){this.textField.text(formatNumber(this.value))}if(this.maxValue===0){this.maxValue=this.avgValue*2}valPercent=this.value/this.maxValue*100;avgPercent=this.avgValue/this.maxValue*100;$(".bar-value",this.elem).css({width:valPercent+"%"});return $(".typical-value",this.elem).css({width:avgPercent+"%"})};return Bar}();Gauge=function(_super){__extends(Gauge,_super);Gauge.prototype.elem=null;Gauge.prototype.value=[20];Gauge.prototype.maxValue=80;Gauge.prototype.minValue=0;Gauge.prototype.displayedAngle=0;Gauge.prototype.displayedValue=0;Gauge.prototype.lineWidth=40;Gauge.prototype.paddingBottom=.1;Gauge.prototype.percentColors=null;Gauge.prototype.options={colorStart:"#6fadcf",colorStop:void 0,gradientType:0,strokeColor:"#e0e0e0",pointer:{length:.8,strokeWidth:.035},angle:.15,lineWidth:.44,fontSize:40,limitMax:false,percentColors:[[0,"#a9d70b"],[.5,"#f9c802"],[1,"#ff0000"]]};function Gauge(canvas){this.canvas=canvas;Gauge.__super__.constructor.call(this);this.percentColors=null;if(typeof G_vmlCanvasManager!=="undefined"){this.canvas=window.G_vmlCanvasManager.initElement(this.canvas)}this.ctx=this.canvas.getContext("2d");this.gp=[new GaugePointer(this)];this.setOptions();this.render()}Gauge.prototype.setOptions=function(options){var gauge,_i,_len,_ref1;if(options==null){options=null}Gauge.__super__.setOptions.call(this,options);this.configPercentColors();this.lineWidth=this.canvas.height*(1-this.paddingBottom)*this.options.lineWidth;this.radius=this.canvas.height*(1-this.paddingBottom)-this.lineWidth;this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height);this.render();_ref1=this.gp;for(_i=0,_len=_ref1.length;_i<_len;_i++){gauge=_ref1[_i];gauge.setOptions(this.options.pointer);gauge.render()}return this};Gauge.prototype.configPercentColors=function(){var bval,gval,i,rval,_i,_ref1,_results;this.percentColors=null;if(this.options.percentColors!==void 0){this.percentColors=new Array;_results=[];for(i=_i=0,_ref1=this.options.percentColors.length-1;0<=_ref1?_i<=_ref1:_i>=_ref1;i=0<=_ref1?++_i:--_i){rval=parseInt(cutHex(this.options.percentColors[i][1]).substring(0,2),16);gval=parseInt(cutHex(this.options.percentColors[i][1]).substring(2,4),16);bval=parseInt(cutHex(this.options.percentColors[i][1]).substring(4,6),16);_results.push(this.percentColors[i]={pct:this.options.percentColors[i][0],color:{r:rval,g:gval,b:bval}})}return _results}};Gauge.prototype.set=function(value){var i,max_hit,val,_i,_j,_len,_ref1;if(!(value instanceof Array)){value=[value]}if(value.length>this.gp.length){for(i=_i=0,_ref1=value.length-this.gp.length;0<=_ref1?_i<_ref1:_i>_ref1;i=0<=_ref1?++_i:--_i){this.gp.push(new GaugePointer(this))}}i=0;max_hit=false;for(_j=0,_len=value.length;_j<_len;_j++){val=value[_j];if(val>this.maxValue){this.maxValue=this.value*1.1;max_hit=true}this.gp[i].value=val;this.gp[i++].setOptions({maxValue:this.maxValue,angle:this.options.angle})}this.value=value[value.length-1];if(max_hit){if(!this.options.limitMax){return AnimationUpdater.run()}}else{return AnimationUpdater.run()}};Gauge.prototype.getAngle=function(value){return(1+this.options.angle)*Math.PI+(value-this.minValue)/(this.maxValue-this.minValue)*(1-this.options.angle*2)*Math.PI};Gauge.prototype.getColorForPercentage=function(pct,grad){var color,endColor,i,rangePct,startColor,_i,_ref1;if(pct===0){color=this.percentColors[0].color}else{color=this.percentColors[this.percentColors.length-1].color;for(i=_i=0,_ref1=this.percentColors.length-1;0<=_ref1?_i<=_ref1:_i>=_ref1;i=0<=_ref1?++_i:--_i){if(pct<=this.percentColors[i].pct){if(grad===true){startColor=this.percentColors[i-1];
endColor=this.percentColors[i];rangePct=(pct-startColor.pct)/(endColor.pct-startColor.pct);color={r:Math.floor(startColor.color.r*(1-rangePct)+endColor.color.r*rangePct),g:Math.floor(startColor.color.g*(1-rangePct)+endColor.color.g*rangePct),b:Math.floor(startColor.color.b*(1-rangePct)+endColor.color.b*rangePct)}}else{color=this.percentColors[i].color}break}}}return"rgb("+[color.r,color.g,color.b].join(",")+")"};Gauge.prototype.getColorForValue=function(val,grad){var pct;pct=(val-this.minValue)/(this.maxValue-this.minValue);return this.getColorForPercentage(pct,grad)};Gauge.prototype.render=function(){var displayedAngle,fillStyle,gauge,h,w,_i,_len,_ref1,_results;w=this.canvas.width/2;h=this.canvas.height*(1-this.paddingBottom);displayedAngle=this.getAngle(this.displayedValue);if(this.textField){this.textField.render(this)}this.ctx.lineCap="butt";if(this.options.customFillStyle!==void 0){fillStyle=this.options.customFillStyle(this)}else if(this.percentColors!==null){fillStyle=this.getColorForValue(this.displayedValue,true)}else if(this.options.colorStop!==void 0){if(this.options.gradientType===0){fillStyle=this.ctx.createRadialGradient(w,h,9,w,h,70)}else{fillStyle=this.ctx.createLinearGradient(0,0,w,0)}fillStyle.addColorStop(0,this.options.colorStart);fillStyle.addColorStop(1,this.options.colorStop)}else{fillStyle=this.options.colorStart}this.ctx.strokeStyle=fillStyle;this.ctx.beginPath();this.ctx.arc(w,h,this.radius,(1+this.options.angle)*Math.PI,displayedAngle,false);this.ctx.lineWidth=this.lineWidth;this.ctx.stroke();this.ctx.strokeStyle=this.options.strokeColor;this.ctx.beginPath();this.ctx.arc(w,h,this.radius,displayedAngle,(2-this.options.angle)*Math.PI,false);this.ctx.stroke();_ref1=this.gp;_results=[];for(_i=0,_len=_ref1.length;_i<_len;_i++){gauge=_ref1[_i];_results.push(gauge.update(true))}return _results};return Gauge}(BaseGauge);BaseDonut=function(_super){__extends(BaseDonut,_super);BaseDonut.prototype.lineWidth=15;BaseDonut.prototype.displayedValue=0;BaseDonut.prototype.value=33;BaseDonut.prototype.maxValue=80;BaseDonut.prototype.minValue=0;BaseDonut.prototype.options={lineWidth:.1,colorStart:"#6f6ea0",colorStop:"#c0c0db",strokeColor:"#eeeeee",shadowColor:"#d5d5d5",angle:.35};function BaseDonut(canvas){this.canvas=canvas;BaseDonut.__super__.constructor.call(this);if(typeof G_vmlCanvasManager!=="undefined"){this.canvas=window.G_vmlCanvasManager.initElement(this.canvas)}this.ctx=this.canvas.getContext("2d");this.setOptions();this.render()}BaseDonut.prototype.getAngle=function(value){return(1-this.options.angle)*Math.PI+(value-this.minValue)/(this.maxValue-this.minValue)*(2+this.options.angle-(1-this.options.angle))*Math.PI};BaseDonut.prototype.setOptions=function(options){if(options==null){options=null}BaseDonut.__super__.setOptions.call(this,options);this.lineWidth=this.canvas.height*this.options.lineWidth;this.radius=this.canvas.height/2-this.lineWidth/2;return this};BaseDonut.prototype.set=function(value){this.value=value;if(this.value>this.maxValue){this.maxValue=this.value*1.1}return AnimationUpdater.run()};BaseDonut.prototype.render=function(){var displayedAngle,grdFill,h,start,stop,w;displayedAngle=this.getAngle(this.displayedValue);w=this.canvas.width/2;h=this.canvas.height/2;if(this.textField){this.textField.render(this)}grdFill=this.ctx.createRadialGradient(w,h,39,w,h,70);grdFill.addColorStop(0,this.options.colorStart);grdFill.addColorStop(1,this.options.colorStop);start=this.radius-this.lineWidth/2;stop=this.radius+this.lineWidth/2;this.ctx.strokeStyle=this.options.strokeColor;this.ctx.beginPath();this.ctx.arc(w,h,this.radius,(1-this.options.angle)*Math.PI,(2+this.options.angle)*Math.PI,false);this.ctx.lineWidth=this.lineWidth;this.ctx.lineCap="round";this.ctx.stroke();this.ctx.strokeStyle=grdFill;this.ctx.beginPath();this.ctx.arc(w,h,this.radius,(1-this.options.angle)*Math.PI,displayedAngle,false);return this.ctx.stroke()};return BaseDonut}(BaseGauge);Donut=function(_super){__extends(Donut,_super);function Donut(){_ref1=Donut.__super__.constructor.apply(this,arguments);return _ref1}Donut.prototype.strokeGradient=function(w,h,start,stop){var grd;grd=this.ctx.createRadialGradient(w,h,start,w,h,stop);grd.addColorStop(0,this.options.shadowColor);grd.addColorStop(.12,this.options._orgStrokeColor);grd.addColorStop(.88,this.options._orgStrokeColor);grd.addColorStop(1,this.options.shadowColor);return grd};Donut.prototype.setOptions=function(options){var h,start,stop,w;if(options==null){options=null}Donut.__super__.setOptions.call(this,options);w=this.canvas.width/2;h=this.canvas.height/2;start=this.radius-this.lineWidth/2;stop=this.radius+this.lineWidth/2;this.options._orgStrokeColor=this.options.strokeColor;this.options.strokeColor=this.strokeGradient(w,h,start,stop);return this};return Donut}(BaseDonut);window.AnimationUpdater={elements:[],animId:null,addAll:function(list){var elem,_i,_len,_results;_results=[];for(_i=0,_len=list.length;_i<_len;_i++){elem=list[_i];_results.push(AnimationUpdater.elements.push(elem))}return _results},add:function(object){return AnimationUpdater.elements.push(object)},run:function(){var animationFinished,elem,_i,_len,_ref2;animationFinished=true;_ref2=AnimationUpdater.elements;for(_i=0,_len=_ref2.length;_i<_len;_i++){elem=_ref2[_i];if(elem.update()){animationFinished=false}}if(!animationFinished){return AnimationUpdater.animId=requestAnimationFrame(AnimationUpdater.run)}else{return cancelAnimationFrame(AnimationUpdater.animId)}}};window.Gauge=Gauge;window.Donut=Donut;window.BaseDonut=BaseDonut;window.TextRenderer=TextRenderer}).call(this);(function(exports){crossfilter.version="1.3.12";function crossfilter_identity(d){return d}crossfilter.permute=permute;function permute(array,index){for(var i=0,n=index.length,copy=new Array(n);i<n;++i){copy[i]=array[index[i]]}return copy}var bisect=crossfilter.bisect=bisect_by(crossfilter_identity);bisect.by=bisect_by;function bisect_by(f){function bisectLeft(a,x,lo,hi){while(lo<hi){var mid=lo+hi>>>1;if(f(a[mid])<x)lo=mid+1;else hi=mid}return lo}function bisectRight(a,x,lo,hi){while(lo<hi){var mid=lo+hi>>>1;if(x<f(a[mid]))hi=mid;else lo=mid+1}return lo}bisectRight.right=bisectRight;bisectRight.left=bisectLeft;return bisectRight}var heap=crossfilter.heap=heap_by(crossfilter_identity);heap.by=heap_by;function heap_by(f){function heap(a,lo,hi){var n=hi-lo,i=(n>>>1)+1;while(--i>0)sift(a,i,n,lo);return a}function sort(a,lo,hi){var n=hi-lo,t;while(--n>0)t=a[lo],a[lo]=a[lo+n],a[lo+n]=t,sift(a,1,n,lo);return a}function sift(a,i,n,lo){var d=a[--lo+i],x=f(d),child;while((child=i<<1)<=n){if(child<n&&f(a[lo+child])>f(a[lo+child+1]))child++;if(x<=f(a[lo+child]))break;a[lo+i]=a[lo+child];i=child}a[lo+i]=d}heap.sort=sort;return heap}var heapselect=crossfilter.heapselect=heapselect_by(crossfilter_identity);heapselect.by=heapselect_by;function heapselect_by(f){var heap=heap_by(f);function heapselect(a,lo,hi,k){var queue=new Array(k=Math.min(hi-lo,k)),min,i,x,d;for(i=0;i<k;++i)queue[i]=a[lo++];heap(queue,0,k);if(lo<hi){min=f(queue[0]);do{if(x=f(d=a[lo])>min){queue[0]=d;min=f(heap(queue,0,k)[0])}}while(++lo<hi)}return queue}return heapselect}var insertionsort=crossfilter.insertionsort=insertionsort_by(crossfilter_identity);insertionsort.by=insertionsort_by;function insertionsort_by(f){function insertionsort(a,lo,hi){for(var i=lo+1;i<hi;++i){for(var j=i,t=a[i],x=f(t);j>lo&&f(a[j-1])>x;--j){a[j]=a[j-1]}a[j]=t}return a}return insertionsort}var quicksort=crossfilter.quicksort=quicksort_by(crossfilter_identity);quicksort.by=quicksort_by;function quicksort_by(f){var insertionsort=insertionsort_by(f);function sort(a,lo,hi){return(hi-lo<quicksort_sizeThreshold?insertionsort:quicksort)(a,lo,hi)}function quicksort(a,lo,hi){var sixth=(hi-lo)/6|0,i1=lo+sixth,i5=hi-1-sixth,i3=lo+hi-1>>1,i2=i3-sixth,i4=i3+sixth;var e1=a[i1],x1=f(e1),e2=a[i2],x2=f(e2),e3=a[i3],x3=f(e3),e4=a[i4],x4=f(e4),e5=a[i5],x5=f(e5);var t;if(x1>x2)t=e1,e1=e2,e2=t,t=x1,x1=x2,x2=t;if(x4>x5)t=e4,e4=e5,e5=t,t=x4,x4=x5,x5=t;if(x1>x3)t=e1,e1=e3,e3=t,t=x1,x1=x3,x3=t;if(x2>x3)t=e2,e2=e3,e3=t,t=x2,x2=x3,x3=t;if(x1>x4)t=e1,e1=e4,e4=t,t=x1,x1=x4,x4=t;if(x3>x4)t=e3,e3=e4,e4=t,t=x3,x3=x4,x4=t;if(x2>x5)t=e2,e2=e5,e5=t,t=x2,x2=x5,x5=t;if(x2>x3)t=e2,e2=e3,e3=t,t=x2,x2=x3,x3=t;if(x4>x5)t=e4,e4=e5,e5=t,t=x4,x4=x5,x5=t;var pivot1=e2,pivotValue1=x2,pivot2=e4,pivotValue2=x4;a[i1]=e1;a[i2]=a[lo];a[i3]=e3;a[i4]=a[hi-1];a[i5]=e5;var less=lo+1,great=hi-2;var pivotsEqual=pivotValue1<=pivotValue2&&pivotValue1>=pivotValue2;if(pivotsEqual){for(var k=less;k<=great;++k){var ek=a[k],xk=f(ek);if(xk<pivotValue1){if(k!==less){a[k]=a[less];a[less]=ek}++less}else if(xk>pivotValue1){while(true){var greatValue=f(a[great]);if(greatValue>pivotValue1){great--;continue}else if(greatValue<pivotValue1){a[k]=a[less];a[less++]=a[great];a[great--]=ek;break}else{a[k]=a[great];a[great--]=ek;break}}}}}else{for(var k=less;k<=great;k++){var ek=a[k],xk=f(ek);if(xk<pivotValue1){if(k!==less){a[k]=a[less];a[less]=ek}++less}else{if(xk>pivotValue2){while(true){var greatValue=f(a[great]);if(greatValue>pivotValue2){great--;if(great<k)break;continue}else{if(greatValue<pivotValue1){a[k]=a[less];a[less++]=a[great];a[great--]=ek}else{a[k]=a[great];a[great--]=ek}break}}}}}}a[lo]=a[less-1];a[less-1]=pivot1;a[hi-1]=a[great+1];a[great+1]=pivot2;sort(a,lo,less-1);sort(a,great+2,hi);if(pivotsEqual){return a}if(less<i1&&great>i5){var lessValue,greatValue;while((lessValue=f(a[less]))<=pivotValue1&&lessValue>=pivotValue1)++less;while((greatValue=f(a[great]))<=pivotValue2&&greatValue>=pivotValue2)--great;for(var k=less;k<=great;k++){var ek=a[k],xk=f(ek);if(xk<=pivotValue1&&xk>=pivotValue1){if(k!==less){a[k]=a[less];a[less]=ek}less++}else{if(xk<=pivotValue2&&xk>=pivotValue2){while(true){var greatValue=f(a[great]);if(greatValue<=pivotValue2&&greatValue>=pivotValue2){great--;if(great<k)break;continue}else{if(greatValue<pivotValue1){a[k]=a[less];a[less++]=a[great];a[great--]=ek}else{a[k]=a[great];a[great--]=ek}break}}}}}}return sort(a,less,great+1)}return sort}var quicksort_sizeThreshold=32;var crossfilter_array8=crossfilter_arrayUntyped,crossfilter_array16=crossfilter_arrayUntyped,crossfilter_array32=crossfilter_arrayUntyped,crossfilter_arrayLengthen=crossfilter_arrayLengthenUntyped,crossfilter_arrayWiden=crossfilter_arrayWidenUntyped;if(typeof Uint8Array!=="undefined"){crossfilter_array8=function(n){return new Uint8Array(n)};crossfilter_array16=function(n){return new Uint16Array(n)};crossfilter_array32=function(n){return new Uint32Array(n)};crossfilter_arrayLengthen=function(array,length){if(array.length>=length)return array;var copy=new array.constructor(length);copy.set(array);return copy};crossfilter_arrayWiden=function(array,width){var copy;switch(width){case 16:copy=crossfilter_array16(array.length);break;case 32:copy=crossfilter_array32(array.length);break;default:throw new Error("invalid array width!")}copy.set(array);return copy}}function crossfilter_arrayUntyped(n){var array=new Array(n),i=-1;while(++i<n)array[i]=0;return array}function crossfilter_arrayLengthenUntyped(array,length){var n=array.length;while(n<length)array[n++]=0;return array}function crossfilter_arrayWidenUntyped(array,width){if(width>32)throw new Error("invalid array width!");return array}function crossfilter_filterExact(bisect,value){return function(values){var n=values.length;return[bisect.left(values,value,0,n),bisect.right(values,value,0,n)]}}function crossfilter_filterRange(bisect,range){var min=range[0],max=range[1];return function(values){var n=values.length;return[bisect.left(values,min,0,n),bisect.left(values,max,0,n)]}}function crossfilter_filterAll(values){return[0,values.length]}function crossfilter_null(){return null}function crossfilter_zero(){return 0}function crossfilter_reduceIncrement(p){return p+1}function crossfilter_reduceDecrement(p){return p-1}function crossfilter_reduceAdd(f){return function(p,v){return p+ +f(v)}}function crossfilter_reduceSubtract(f){return function(p,v){return p-f(v)}}exports.crossfilter=crossfilter;function crossfilter(){var crossfilter={add:add,remove:removeData,dimension:dimension,groupAll:groupAll,size:size};var data=[],n=0,m=0,M=8,filters=crossfilter_array8(0),filterListeners=[],dataListeners=[],removeDataListeners=[];function add(newData){var n0=n,n1=newData.length;if(n1){data=data.concat(newData);filters=crossfilter_arrayLengthen(filters,n+=n1);dataListeners.forEach(function(l){l(newData,n0,n1)})}return crossfilter}function removeData(){var newIndex=crossfilter_index(n,n),removed=[];for(var i=0,j=0;i<n;++i){if(filters[i])newIndex[i]=j++;else removed.push(i)}filterListeners.forEach(function(l){l(0,[],removed)});removeDataListeners.forEach(function(l){l(newIndex)});for(var i=0,j=0,k;i<n;++i){if(k=filters[i]){if(i!==j)filters[j]=k,data[j]=data[i];++j}}data.length=j;while(n>j)filters[--n]=0}function dimension(value){var dimension={filter:filter,filterExact:filterExact,filterRange:filterRange,filterFunction:filterFunction,filterAll:filterAll,top:top,bottom:bottom,group:group,groupAll:groupAll,dispose:dispose,remove:dispose};var one=~m&-~m,zero=~one,values,index,newValues,newIndex,sort=quicksort_by(function(i){return newValues[i]}),refilter=crossfilter_filterAll,refilterFunction,indexListeners=[],dimensionGroups=[],lo0=0,hi0=0;dataListeners.unshift(preAdd);dataListeners.push(postAdd);removeDataListeners.push(removeData);m|=one;if(M>=32?!one:m&-(1<<M)){filters=crossfilter_arrayWiden(filters,M<<=1)}preAdd(data,0,n);postAdd(data,0,n);function preAdd(newData,n0,n1){newValues=newData.map(value);newIndex=sort(crossfilter_range(n1),0,n1);newValues=permute(newValues,newIndex);var bounds=refilter(newValues),lo1=bounds[0],hi1=bounds[1],i;if(refilterFunction){for(i=0;i<n1;++i){if(!refilterFunction(newValues[i],i))filters[newIndex[i]+n0]|=one}}else{for(i=0;i<lo1;++i)filters[newIndex[i]+n0]|=one;for(i=hi1;i<n1;++i)filters[newIndex[i]+n0]|=one}if(!n0){values=newValues;index=newIndex;lo0=lo1;hi0=hi1;return}var oldValues=values,oldIndex=index,i0=0,i1=0;values=new Array(n);index=crossfilter_index(n,n);for(i=0;i0<n0&&i1<n1;++i){if(oldValues[i0]<newValues[i1]){values[i]=oldValues[i0];index[i]=oldIndex[i0++]}else{values[i]=newValues[i1];index[i]=newIndex[i1++]+n0}}for(;i0<n0;++i0,++i){values[i]=oldValues[i0];index[i]=oldIndex[i0]}for(;i1<n1;++i1,++i){values[i]=newValues[i1];index[i]=newIndex[i1]+n0}bounds=refilter(values),lo0=bounds[0],hi0=bounds[1]}function postAdd(newData,n0,n1){indexListeners.forEach(function(l){l(newValues,newIndex,n0,n1)});newValues=newIndex=null}function removeData(reIndex){for(var i=0,j=0,k;i<n;++i){if(filters[k=index[i]]){if(i!==j)values[j]=values[i];index[j]=reIndex[k];++j}}values.length=j;while(j<n)index[j++]=0;var bounds=refilter(values);lo0=bounds[0],hi0=bounds[1]}function filterIndexBounds(bounds){var lo1=bounds[0],hi1=bounds[1];if(refilterFunction){refilterFunction=null;filterIndexFunction(function(d,i){return lo1<=i&&i<hi1});lo0=lo1;hi0=hi1;return dimension}var i,j,k,added=[],removed=[];if(lo1<lo0){for(i=lo1,j=Math.min(lo0,hi1);i<j;++i){filters[k=index[i]]^=one;added.push(k)}}else if(lo1>lo0){for(i=lo0,j=Math.min(lo1,hi0);i<j;++i){filters[k=index[i]]^=one;removed.push(k)}}if(hi1>hi0){for(i=Math.max(lo1,hi0),j=hi1;i<j;++i){filters[k=index[i]]^=one;added.push(k)}}else if(hi1<hi0){for(i=Math.max(lo0,hi1),j=hi0;i<j;++i){filters[k=index[i]]^=one;removed.push(k)}}lo0=lo1;hi0=hi1;filterListeners.forEach(function(l){l(one,added,removed)});return dimension}function filter(range){return range==null?filterAll():Array.isArray(range)?filterRange(range):typeof range==="function"?filterFunction(range):filterExact(range)}function filterExact(value){return filterIndexBounds((refilter=crossfilter_filterExact(bisect,value))(values))}function filterRange(range){return filterIndexBounds((refilter=crossfilter_filterRange(bisect,range))(values))}function filterAll(){return filterIndexBounds((refilter=crossfilter_filterAll)(values))}function filterFunction(f){refilter=crossfilter_filterAll;filterIndexFunction(refilterFunction=f);lo0=0;hi0=n;return dimension}function filterIndexFunction(f){var i,k,x,added=[],removed=[];for(i=0;i<n;++i){if(!(filters[k=index[i]]&one)^!!(x=f(values[i],i))){if(x)filters[k]&=zero,added.push(k);else filters[k]|=one,removed.push(k)}}filterListeners.forEach(function(l){l(one,added,removed)})}function top(k){var array=[],i=hi0,j;while(--i>=lo0&&k>0){if(!filters[j=index[i]]){array.push(data[j]);--k}}return array}function bottom(k){var array=[],i=lo0,j;while(i<hi0&&k>0){if(!filters[j=index[i]]){array.push(data[j]);--k}i++}return array}function group(key){var group={top:top,all:all,reduce:reduce,reduceCount:reduceCount,reduceSum:reduceSum,order:order,orderNatural:orderNatural,size:size,dispose:dispose,remove:dispose};dimensionGroups.push(group);var groups,groupIndex,groupWidth=8,groupCapacity=crossfilter_capacity(groupWidth),k=0,select,heap,reduceAdd,reduceRemove,reduceInitial,update=crossfilter_null,reset=crossfilter_null,resetNeeded=true,groupAll=key===crossfilter_null;if(arguments.length<1)key=crossfilter_identity;filterListeners.push(update);indexListeners.push(add);removeDataListeners.push(removeData);add(values,index,0,n);function add(newValues,newIndex,n0,n1){var oldGroups=groups,reIndex=crossfilter_index(k,groupCapacity),add=reduceAdd,initial=reduceInitial,k0=k,i0=0,i1=0,j,g0,x0,x1,g,x;if(resetNeeded)add=initial=crossfilter_null;groups=new Array(k),k=0;groupIndex=k0>1?crossfilter_arrayLengthen(groupIndex,n):crossfilter_index(n,groupCapacity);if(k0)x0=(g0=oldGroups[0]).key;while(i1<n1&&!((x1=key(newValues[i1]))>=x1))++i1;while(i1<n1){if(g0&&x0<=x1){g=g0,x=x0;reIndex[i0]=k;if(g0=oldGroups[++i0])x0=g0.key}else{g={key:x1,value:initial()},x=x1}groups[k]=g;while(!(x1>x)){groupIndex[j=newIndex[i1]+n0]=k;if(!(filters[j]&zero))g.value=add(g.value,data[j]);if(++i1>=n1)break;x1=key(newValues[i1])}groupIncrement()}while(i0<k0){groups[reIndex[i0]=k]=oldGroups[i0++];groupIncrement()}if(k>i0)for(i0=0;i0<n0;++i0){groupIndex[i0]=reIndex[groupIndex[i0]]}j=filterListeners.indexOf(update);if(k>1){update=updateMany;reset=resetMany}else{if(!k&&groupAll){k=1;groups=[{key:null,value:initial()}]}if(k===1){update=updateOne;reset=resetOne}else{update=crossfilter_null;reset=crossfilter_null}groupIndex=null}filterListeners[j]=update;function groupIncrement(){if(++k===groupCapacity){reIndex=crossfilter_arrayWiden(reIndex,groupWidth<<=1);groupIndex=crossfilter_arrayWiden(groupIndex,groupWidth);groupCapacity=crossfilter_capacity(groupWidth)}}}function removeData(){if(k>1){var oldK=k,oldGroups=groups,seenGroups=crossfilter_index(oldK,oldK);for(var i=0,j=0;i<n;++i){if(filters[i]){seenGroups[groupIndex[j]=groupIndex[i]]=1;++j}}groups=[],k=0;for(i=0;i<oldK;++i){if(seenGroups[i]){seenGroups[i]=k++;groups.push(oldGroups[i])}}if(k>1){for(var i=0;i<j;++i)groupIndex[i]=seenGroups[groupIndex[i]]}else{groupIndex=null}filterListeners[filterListeners.indexOf(update)]=k>1?(reset=resetMany,update=updateMany):k===1?(reset=resetOne,update=updateOne):reset=update=crossfilter_null}else if(k===1){if(groupAll)return;for(var i=0;i<n;++i)if(filters[i])return;groups=[],k=0;filterListeners[filterListeners.indexOf(update)]=update=reset=crossfilter_null}}function updateMany(filterOne,added,removed){if(filterOne===one||resetNeeded)return;var i,k,n,g;for(i=0,n=added.length;i<n;++i){if(!(filters[k=added[i]]&zero)){g=groups[groupIndex[k]];g.value=reduceAdd(g.value,data[k])}}for(i=0,n=removed.length;i<n;++i){if((filters[k=removed[i]]&zero)===filterOne){g=groups[groupIndex[k]];g.value=reduceRemove(g.value,data[k])}}}function updateOne(filterOne,added,removed){if(filterOne===one||resetNeeded)return;var i,k,n,g=groups[0];for(i=0,n=added.length;i<n;++i){if(!(filters[k=added[i]]&zero)){g.value=reduceAdd(g.value,data[k])}}for(i=0,n=removed.length;i<n;++i){if((filters[k=removed[i]]&zero)===filterOne){g.value=reduceRemove(g.value,data[k])}}}function resetMany(){var i,g;for(i=0;i<k;++i){groups[i].value=reduceInitial()}for(i=0;i<n;++i){if(!(filters[i]&zero)){g=groups[groupIndex[i]];g.value=reduceAdd(g.value,data[i])}}}function resetOne(){var i,g=groups[0];g.value=reduceInitial();for(i=0;i<n;++i){if(!(filters[i]&zero)){g.value=reduceAdd(g.value,data[i])}}}function all(){if(resetNeeded)reset(),resetNeeded=false;return groups}function top(k){var top=select(all(),0,groups.length,k);return heap.sort(top,0,top.length)}function reduce(add,remove,initial){reduceAdd=add;reduceRemove=remove;reduceInitial=initial;resetNeeded=true;return group}function reduceCount(){return reduce(crossfilter_reduceIncrement,crossfilter_reduceDecrement,crossfilter_zero)}function reduceSum(value){return reduce(crossfilter_reduceAdd(value),crossfilter_reduceSubtract(value),crossfilter_zero)}function order(value){select=heapselect_by(valueOf);heap=heap_by(valueOf);function valueOf(d){return value(d.value)}return group}function orderNatural(){return order(crossfilter_identity)}function size(){return k}function dispose(){var i=filterListeners.indexOf(update);if(i>=0)filterListeners.splice(i,1);i=indexListeners.indexOf(add);if(i>=0)indexListeners.splice(i,1);i=removeDataListeners.indexOf(removeData);if(i>=0)removeDataListeners.splice(i,1);return group}return reduceCount().orderNatural()}function groupAll(){var g=group(crossfilter_null),all=g.all;delete g.all;delete g.top;delete g.order;delete g.orderNatural;delete g.size;g.value=function(){return all()[0].value};return g}function dispose(){dimensionGroups.forEach(function(group){group.dispose()});var i=dataListeners.indexOf(preAdd);if(i>=0)dataListeners.splice(i,1);i=dataListeners.indexOf(postAdd);if(i>=0)dataListeners.splice(i,1);i=removeDataListeners.indexOf(removeData);if(i>=0)removeDataListeners.splice(i,1);m&=zero;return filterAll()}return dimension}function groupAll(){var group={reduce:reduce,reduceCount:reduceCount,reduceSum:reduceSum,value:value,dispose:dispose,remove:dispose};var reduceValue,reduceAdd,reduceRemove,reduceInitial,resetNeeded=true;filterListeners.push(update);dataListeners.push(add);add(data,0,n);function add(newData,n0){var i;if(resetNeeded)return;for(i=n0;i<n;++i){if(!filters[i]){reduceValue=reduceAdd(reduceValue,data[i])}}}function update(filterOne,added,removed){var i,k,n;if(resetNeeded)return;for(i=0,n=added.length;i<n;++i){if(!filters[k=added[i]]){reduceValue=reduceAdd(reduceValue,data[k])}}for(i=0,n=removed.length;i<n;++i){if(filters[k=removed[i]]===filterOne){reduceValue=reduceRemove(reduceValue,data[k])}}}function reset(){var i;reduceValue=reduceInitial();for(i=0;i<n;++i){if(!filters[i]){reduceValue=reduceAdd(reduceValue,data[i])}}}function reduce(add,remove,initial){reduceAdd=add;reduceRemove=remove;reduceInitial=initial;resetNeeded=true;return group}function reduceCount(){return reduce(crossfilter_reduceIncrement,crossfilter_reduceDecrement,crossfilter_zero)}function reduceSum(value){return reduce(crossfilter_reduceAdd(value),crossfilter_reduceSubtract(value),crossfilter_zero)}function value(){if(resetNeeded)reset(),resetNeeded=false;return reduceValue}function dispose(){var i=filterListeners.indexOf(update);if(i>=0)filterListeners.splice(i);i=dataListeners.indexOf(add);if(i>=0)dataListeners.splice(i);return group}return reduceCount()}function size(){return n}return arguments.length?add(arguments[0]):crossfilter}function crossfilter_index(n,m){return(m<257?crossfilter_array8:m<65537?crossfilter_array16:crossfilter_array32)(n)}function crossfilter_range(n){var range=crossfilter_index(n,n);for(var i=-1;++i<n;)range[i]=i;return range}function crossfilter_capacity(w){return w===8?256:w===16?65536:4294967296}})(typeof exports!=="undefined"&&exports||this);+function($){"use strict";var Validator=function(element,options){this.$element=$(element);this.options=options;options.errors=$.extend({},Validator.DEFAULTS.errors,options.errors);for(var custom in options.custom){if(!options.errors[custom])throw new Error("Missing default error message for custom validator: "+custom)}$.extend(Validator.VALIDATORS,options.custom);this.$element.attr("novalidate",true);this.toggleSubmit();this.$element.on("input.bs.validator change.bs.validator focusout.bs.validator",$.proxy(this.validateInput,this));this.$element.on("submit.bs.validator",$.proxy(this.onSubmit,this));this.$element.find("[data-match]").each(function(){var $this=$(this);var target=$this.data("match");$(target).on("input.bs.validator",function(e){$this.val()&&$this.trigger("input.bs.validator")})})};Validator.INPUT_SELECTOR=':input:not([type="submit"], button):enabled:visible';Validator.DEFAULTS={delay:500,html:false,disable:true,custom:{},errors:{match:"Does not match",minlength:"Not long enough"},feedback:{success:"glyphicon-ok",error:"glyphicon-remove"}};Validator.VALIDATORS={"native":function($el){var el=$el[0];return el.checkValidity?el.checkValidity():true},match:function($el){var target=$el.data("match");return!$el.val()||$el.val()===$(target).val()},minlength:function($el){var minlength=$el.data("minlength");return!$el.val()||$el.val().length>=minlength}};Validator.prototype.validateInput=function(e){var $el=$(e.target);var prevErrors=$el.data("bs.validator.errors");var errors;if($el.is('[type="radio"]'))$el=this.$element.find('input[name="'+$el.attr("name")+'"]');this.$element.trigger(e=$.Event("validate.bs.validator",{relatedTarget:$el[0]}));if(e.isDefaultPrevented())return;var self=this;this.runValidators($el).done(function(errors){$el.data("bs.validator.errors",errors);errors.length?self.showErrors($el):self.clearErrors($el);if(!prevErrors||errors.toString()!==prevErrors.toString()){e=errors.length?$.Event("invalid.bs.validator",{relatedTarget:$el[0],detail:errors}):$.Event("valid.bs.validator",{relatedTarget:$el[0],detail:prevErrors});self.$element.trigger(e)}self.toggleSubmit();self.$element.trigger($.Event("validated.bs.validator",{relatedTarget:$el[0]}))})};Validator.prototype.runValidators=function($el){var errors=[];var deferred=$.Deferred();var options=this.options;$el.data("bs.validator.deferred")&&$el.data("bs.validator.deferred").reject();$el.data("bs.validator.deferred",deferred);function getErrorMessage(key){return $el.data(key+"-error")||$el.data("error")||key=="native"&&$el[0].validationMessage||options.errors[key]}$.each(Validator.VALIDATORS,$.proxy(function(key,validator){if(($el.data(key)||key=="native")&&!validator.call(this,$el)){var error=getErrorMessage(key);!~errors.indexOf(error)&&errors.push(error)}},this));if(!errors.length&&$el.val()&&$el.data("remote")){this.defer($el,function(){var data={};data[$el.attr("name")]=$el.val();$.get($el.data("remote"),data).fail(function(jqXHR,textStatus,error){errors.push(getErrorMessage("remote")||error)}).always(function(){deferred.resolve(errors)})})}else deferred.resolve(errors);return deferred.promise()};Validator.prototype.validate=function(){var delay=this.options.delay;this.options.delay=0;this.$element.find(Validator.INPUT_SELECTOR).trigger("input.bs.validator");this.options.delay=delay;return this};Validator.prototype.showErrors=function($el){var method=this.options.html?"html":"text";var self=this;this.defer($el,function(){var $group=$el.closest(".form-group");var $block=$group.find(".help-block.with-errors");var $feedback=$group.find(".form-control-feedback");var errors=$el.data("bs.validator.errors");if(typeof errors==="undefined"){errors=[];self.clearErrors($el);self.toggleSubmit()}if(!errors.length)return;errors=$("<ul/>").addClass("list-unstyled").append($.map(errors,function(error){return $("<li/>")[method](error)}));$block.data("bs.validator.originalContent")===undefined&&$block.data("bs.validator.originalContent",$block.html());$block.empty().append(errors);$group.addClass("has-error");$feedback.length&&$feedback.removeClass(this.options.feedback.success)&&$feedback.addClass(this.options.feedback.error)&&$group.removeClass("has-success")})};Validator.prototype.clearErrors=function($el){var $group=$el.closest(".form-group");var $block=$group.find(".help-block.with-errors");var $feedback=$group.find(".form-control-feedback");$block.html($block.data("bs.validator.originalContent"));$group.removeClass("has-error");$feedback.length&&$feedback.removeClass(this.options.feedback.error)&&$feedback.addClass(this.options.feedback.success)&&$group.addClass("has-success")};Validator.prototype.hasErrors=function(){function fieldErrors(){return!!($(this).data("bs.validator.errors")||[]).length}return!!this.$element.find(Validator.INPUT_SELECTOR).filter(fieldErrors).length};Validator.prototype.isIncomplete=function(){function fieldIncomplete(){return this.type==="checkbox"?!this.checked:this.type==="radio"?!$('[name="'+this.name+'"]:checked').length:$.trim(this.value)===""}return!!this.$element.find(Validator.INPUT_SELECTOR).filter("[required]").filter(fieldIncomplete).length};Validator.prototype.onSubmit=function(e){this.validate();if(this.isIncomplete()||this.hasErrors())e.preventDefault()};Validator.prototype.toggleSubmit=function(){if(!this.options.disable)return;var $btn=$('button[type="submit"], input[type="submit"]').filter('[form="'+this.$element.attr("id")+'"]').add(this.$element.find('input[type="submit"], button[type="submit"]'));$btn.toggleClass("disabled",this.isIncomplete()||this.hasErrors())};Validator.prototype.defer=function($el,callback){callback=$.proxy(callback,this);if(!this.options.delay)return callback();window.clearTimeout($el.data("bs.validator.timeout"));$el.data("bs.validator.timeout",window.setTimeout(callback,this.options.delay))};Validator.prototype.destroy=function(){this.$element.removeAttr("novalidate").removeData("bs.validator").off(".bs.validator");this.$element.find(Validator.INPUT_SELECTOR).off(".bs.validator").removeData(["bs.validator.errors","bs.validator.deferred"]).each(function(){var $this=$(this);var timeout=$this.data("bs.validator.timeout");window.clearTimeout(timeout)&&$this.removeData("bs.validator.timeout")});this.$element.find(".help-block.with-errors").each(function(){var $this=$(this);var originalContent=$this.data("bs.validator.originalContent");$this.removeData("bs.validator.originalContent").html(originalContent)});this.$element.find('input[type="submit"], button[type="submit"]').removeClass("disabled");this.$element.find(".has-error").removeClass("has-error");return this};function Plugin(option){return this.each(function(){var $this=$(this);var options=$.extend({},Validator.DEFAULTS,$this.data(),typeof option=="object"&&option);var data=$this.data("bs.validator");if(!data&&option=="destroy")return;if(!data)$this.data("bs.validator",data=new Validator(this,options));if(typeof option=="string")data[option]()})}var old=$.fn.validator;$.fn.validator=Plugin;$.fn.validator.Constructor=Validator;$.fn.validator.noConflict=function(){$.fn.validator=old;return this};$(window).on("load",function(){$('form[data-toggle="validator"]').each(function(){var $form=$(this);Plugin.call($form,$form.data())})})}(jQuery);+function($){"use strict";var Validator=function(element,options){this.$element=$(element);this.options=options;options.errors=$.extend({},Validator.DEFAULTS.errors,options.errors);for(var custom in options.custom){if(!options.errors[custom])throw new Error("Missing default error message for custom validator: "+custom)}$.extend(Validator.VALIDATORS,options.custom);this.$element.attr("novalidate",true);this.toggleSubmit();this.$element.on("input.bs.validator change.bs.validator focusout.bs.validator",$.proxy(this.validateInput,this));this.$element.on("submit.bs.validator",$.proxy(this.onSubmit,this));this.$element.find("[data-match]").each(function(){var $this=$(this);var target=$this.data("match");$(target).on("input.bs.validator",function(e){$this.val()&&$this.trigger("input.bs.validator")})})};Validator.INPUT_SELECTOR=':input:not([type="submit"], button):enabled:visible';Validator.DEFAULTS={delay:500,html:false,disable:true,custom:{},errors:{match:"Does not match",minlength:"Not long enough"},feedback:{success:"glyphicon-ok",error:"glyphicon-remove"}};Validator.VALIDATORS={"native":function($el){var el=$el[0];return el.checkValidity?el.checkValidity():true},match:function($el){var target=$el.data("match");
return!$el.val()||$el.val()===$(target).val()},minlength:function($el){var minlength=$el.data("minlength");return!$el.val()||$el.val().length>=minlength}};Validator.prototype.validateInput=function(e){var $el=$(e.target);var prevErrors=$el.data("bs.validator.errors");var errors;if($el.is('[type="radio"]'))$el=this.$element.find('input[name="'+$el.attr("name")+'"]');this.$element.trigger(e=$.Event("validate.bs.validator",{relatedTarget:$el[0]}));if(e.isDefaultPrevented())return;var self=this;this.runValidators($el).done(function(errors){$el.data("bs.validator.errors",errors);errors.length?self.showErrors($el):self.clearErrors($el);if(!prevErrors||errors.toString()!==prevErrors.toString()){e=errors.length?$.Event("invalid.bs.validator",{relatedTarget:$el[0],detail:errors}):$.Event("valid.bs.validator",{relatedTarget:$el[0],detail:prevErrors});self.$element.trigger(e)}self.toggleSubmit();self.$element.trigger($.Event("validated.bs.validator",{relatedTarget:$el[0]}))})};Validator.prototype.runValidators=function($el){var errors=[];var deferred=$.Deferred();var options=this.options;$el.data("bs.validator.deferred")&&$el.data("bs.validator.deferred").reject();$el.data("bs.validator.deferred",deferred);function getErrorMessage(key){return $el.data(key+"-error")||$el.data("error")||key=="native"&&$el[0].validationMessage||options.errors[key]}$.each(Validator.VALIDATORS,$.proxy(function(key,validator){if(($el.data(key)||key=="native")&&!validator.call(this,$el)){var error=getErrorMessage(key);!~errors.indexOf(error)&&errors.push(error)}},this));if(!errors.length&&$el.val()&&$el.data("remote")){this.defer($el,function(){var data={};data[$el.attr("name")]=$el.val();$.get($el.data("remote"),data).fail(function(jqXHR,textStatus,error){errors.push(getErrorMessage("remote")||error)}).always(function(){deferred.resolve(errors)})})}else deferred.resolve(errors);return deferred.promise()};Validator.prototype.validate=function(){var delay=this.options.delay;this.options.delay=0;this.$element.find(Validator.INPUT_SELECTOR).trigger("input.bs.validator");this.options.delay=delay;return this};Validator.prototype.showErrors=function($el){var method=this.options.html?"html":"text";var self=this;this.defer($el,function(){var $group=$el.closest(".form-group");var $block=$group.find(".help-block.with-errors");var $feedback=$group.find(".form-control-feedback");var errors=$el.data("bs.validator.errors");if(typeof errors==="undefined"){errors=[];self.clearErrors($el);self.toggleSubmit()}if(!errors.length)return;errors=$("<ul/>").addClass("list-unstyled").append($.map(errors,function(error){return $("<li/>")[method](error)}));$block.data("bs.validator.originalContent")===undefined&&$block.data("bs.validator.originalContent",$block.html());$block.empty().append(errors);$group.addClass("has-error");$feedback.length&&$feedback.removeClass(this.options.feedback.success)&&$feedback.addClass(this.options.feedback.error)&&$group.removeClass("has-success")})};Validator.prototype.clearErrors=function($el){var $group=$el.closest(".form-group");var $block=$group.find(".help-block.with-errors");var $feedback=$group.find(".form-control-feedback");$block.html($block.data("bs.validator.originalContent"));$group.removeClass("has-error");$feedback.length&&$feedback.removeClass(this.options.feedback.error)&&$feedback.addClass(this.options.feedback.success)&&$group.addClass("has-success")};Validator.prototype.hasErrors=function(){function fieldErrors(){return!!($(this).data("bs.validator.errors")||[]).length}return!!this.$element.find(Validator.INPUT_SELECTOR).filter(fieldErrors).length};Validator.prototype.isIncomplete=function(){function fieldIncomplete(){return this.type==="checkbox"?!this.checked:this.type==="radio"?!$('[name="'+this.name+'"]:checked').length:$.trim(this.value)===""}return!!this.$element.find(Validator.INPUT_SELECTOR).filter("[required]").filter(fieldIncomplete).length};Validator.prototype.onSubmit=function(e){this.validate();if(this.isIncomplete()||this.hasErrors())e.preventDefault()};Validator.prototype.toggleSubmit=function(){if(!this.options.disable)return;var $btn=$('button[type="submit"], input[type="submit"]').filter('[form="'+this.$element.attr("id")+'"]').add(this.$element.find('input[type="submit"], button[type="submit"]'));$btn.toggleClass("disabled",this.isIncomplete()||this.hasErrors())};Validator.prototype.defer=function($el,callback){callback=$.proxy(callback,this);if(!this.options.delay)return callback();window.clearTimeout($el.data("bs.validator.timeout"));$el.data("bs.validator.timeout",window.setTimeout(callback,this.options.delay))};Validator.prototype.destroy=function(){this.$element.removeAttr("novalidate").removeData("bs.validator").off(".bs.validator");this.$element.find(Validator.INPUT_SELECTOR).off(".bs.validator").removeData(["bs.validator.errors","bs.validator.deferred"]).each(function(){var $this=$(this);var timeout=$this.data("bs.validator.timeout");window.clearTimeout(timeout)&&$this.removeData("bs.validator.timeout")});this.$element.find(".help-block.with-errors").each(function(){var $this=$(this);var originalContent=$this.data("bs.validator.originalContent");$this.removeData("bs.validator.originalContent").html(originalContent)});this.$element.find('input[type="submit"], button[type="submit"]').removeClass("disabled");this.$element.find(".has-error").removeClass("has-error");return this};function Plugin(option){return this.each(function(){var $this=$(this);var options=$.extend({},Validator.DEFAULTS,$this.data(),typeof option=="object"&&option);var data=$this.data("bs.validator");if(!data&&option=="destroy")return;if(!data)$this.data("bs.validator",data=new Validator(this,options));if(typeof option=="string")data[option]()})}var old=$.fn.validator;$.fn.validator=Plugin;$.fn.validator.Constructor=Validator;$.fn.validator.noConflict=function(){$.fn.validator=old;return this};$(window).on("load",function(){$('form[data-toggle="validator"]').each(function(){var $form=$(this);Plugin.call($form,$form.data())})})}(jQuery);(function(){function _dc(d3,crossfilter){"use strict";var dc={version:"2.1.8",constants:{CHART_CLASS:"dc-chart",DEBUG_GROUP_CLASS:"debug",STACK_CLASS:"stack",DESELECTED_CLASS:"deselected",SELECTED_CLASS:"selected",NODE_INDEX_NAME:"__index__",GROUP_INDEX_NAME:"__group_index__",DEFAULT_CHART_GROUP:"__default_chart_group__",EVENT_DELAY:40,NEGLIGIBLE_NUMBER:1e-10},_renderlet:null};dc.chartRegistry=function(){var _chartMap={};function initializeChartGroup(group){if(!group){group=dc.constants.DEFAULT_CHART_GROUP}if(!_chartMap[group]){_chartMap[group]=[]}return group}return{has:function(chart){for(var e in _chartMap){if(_chartMap[e].indexOf(chart)>=0){return true}}return false},register:function(chart,group){group=initializeChartGroup(group);_chartMap[group].push(chart)},deregister:function(chart,group){group=initializeChartGroup(group);for(var i=0;i<_chartMap[group].length;i++){if(_chartMap[group][i].anchorName()===chart.anchorName()){_chartMap[group].splice(i,1);break}}},clear:function(group){if(group){delete _chartMap[group]}else{_chartMap={}}},list:function(group){group=initializeChartGroup(group);return _chartMap[group]}}}();dc.registerChart=function(chart,group){dc.chartRegistry.register(chart,group)};dc.deregisterChart=function(chart,group){dc.chartRegistry.deregister(chart,group)};dc.hasChart=function(chart){return dc.chartRegistry.has(chart)};dc.deregisterAllCharts=function(group){dc.chartRegistry.clear(group)};dc.filterAll=function(group){var charts=dc.chartRegistry.list(group);for(var i=0;i<charts.length;++i){charts[i].filterAll()}};dc.refocusAll=function(group){var charts=dc.chartRegistry.list(group);for(var i=0;i<charts.length;++i){if(charts[i].focus){charts[i].focus()}}};dc.renderAll=function(group){var charts=dc.chartRegistry.list(group);for(var i=0;i<charts.length;++i){charts[i].render()}if(dc._renderlet!==null){dc._renderlet(group)}};dc.redrawAll=function(group){var charts=dc.chartRegistry.list(group);for(var i=0;i<charts.length;++i){charts[i].redraw()}if(dc._renderlet!==null){dc._renderlet(group)}};dc.disableTransitions=false;dc.transition=function(selection,duration,delay,name){if(dc.disableTransitions||duration<=0){return selection}var s=selection.transition(name);if(duration>=0||duration!==undefined){s=s.duration(duration)}if(delay>=0||delay!==undefined){s=s.delay(delay)}return s};dc.optionalTransition=function(enable,duration,delay,name){if(enable){return function(selection){return dc.transition(selection,duration,delay,name)}}else{return function(selection){return selection}}};dc.afterTransition=function(transition,callback){if(transition.empty()||!transition.duration){callback.call(transition)}else{var n=0;transition.each(function(){++n}).each("end",function(){if(!--n){callback.call(transition)}})}};dc.units={};dc.units.integers=function(start,end){return Math.abs(end-start)};dc.units.ordinal=function(start,end,domain){return domain};dc.units.fp={};dc.units.fp.precision=function(precision){var _f=function(s,e){var d=Math.abs((e-s)/_f.resolution);if(dc.utils.isNegligible(d-Math.floor(d))){return Math.floor(d)}else{return Math.ceil(d)}};_f.resolution=precision;return _f};dc.round={};dc.round.floor=function(n){return Math.floor(n)};dc.round.ceil=function(n){return Math.ceil(n)};dc.round.round=function(n){return Math.round(n)};dc.override=function(obj,functionName,newFunction){var existingFunction=obj[functionName];obj["_"+functionName]=existingFunction;obj[functionName]=newFunction};dc.renderlet=function(_){if(!arguments.length){return dc._renderlet}dc._renderlet=_;return dc};dc.instanceOfChart=function(o){return o instanceof Object&&o.__dcFlag__&&true};dc.errors={};dc.errors.Exception=function(msg){var _msg=msg||"Unexpected internal error";this.message=_msg;this.toString=function(){return _msg};this.stack=(new Error).stack};dc.errors.Exception.prototype=Object.create(Error.prototype);dc.errors.Exception.prototype.constructor=dc.errors.Exception;dc.errors.InvalidStateException=function(){dc.errors.Exception.apply(this,arguments)};dc.errors.InvalidStateException.prototype=Object.create(dc.errors.Exception.prototype);dc.errors.InvalidStateException.prototype.constructor=dc.errors.InvalidStateException;dc.errors.BadArgumentException=function(){dc.errors.Exception.apply(this,arguments)};dc.errors.BadArgumentException.prototype=Object.create(dc.errors.Exception.prototype);dc.errors.BadArgumentException.prototype.constructor=dc.errors.BadArgumentException;dc.dateFormat=d3.time.format("%m/%d/%Y");dc.printers={};dc.printers.filters=function(filters){var s="";for(var i=0;i<filters.length;++i){if(i>0){s+=", "}s+=dc.printers.filter(filters[i])}return s};dc.printers.filter=function(filter){var s="";if(typeof filter!=="undefined"&&filter!==null){if(filter instanceof Array){if(filter.length>=2){s="["+dc.utils.printSingleValue(filter[0])+" -> "+dc.utils.printSingleValue(filter[1])+"]"}else if(filter.length>=1){s=dc.utils.printSingleValue(filter[0])}}else{s=dc.utils.printSingleValue(filter)}}return s};dc.pluck=function(n,f){if(!f){return function(d){return d[n]}}return function(d,i){return f.call(d,d[n],i)}};dc.utils={};dc.utils.printSingleValue=function(filter){var s=""+filter;if(filter instanceof Date){s=dc.dateFormat(filter)}else if(typeof filter==="string"){s=filter}else if(dc.utils.isFloat(filter)){s=dc.utils.printSingleValue.fformat(filter)}else if(dc.utils.isInteger(filter)){s=Math.round(filter)}return s};dc.utils.printSingleValue.fformat=d3.format(".2f");dc.utils.add=function(l,r,t){if(typeof r==="string"){r=r.replace("%","")}if(l instanceof Date){if(typeof r==="string"){r=+r}if(t==="millis"){return new Date(l.getTime()+r)}t=t||"day";return d3.time[t].offset(l,r)}else if(typeof r==="string"){var percentage=+r/100;return l>0?l*(1+percentage):l*(1-percentage)}else{return l+r}};dc.utils.subtract=function(l,r,t){if(typeof r==="string"){r=r.replace("%","")}if(l instanceof Date){if(typeof r==="string"){r=+r}if(t==="millis"){return new Date(l.getTime()-r)}t=t||"day";return d3.time[t].offset(l,-r)}else if(typeof r==="string"){var percentage=+r/100;return l<0?l*(1+percentage):l*(1-percentage)}else{return l-r}};dc.utils.isNumber=function(n){return n===+n};dc.utils.isFloat=function(n){return n===+n&&n!==(n|0)};dc.utils.isInteger=function(n){return n===+n&&n===(n|0)};dc.utils.isNegligible=function(n){return!dc.utils.isNumber(n)||n<dc.constants.NEGLIGIBLE_NUMBER&&n>-dc.constants.NEGLIGIBLE_NUMBER};dc.utils.clamp=function(val,min,max){return val<min?min:val>max?max:val};var _idCounter=0;dc.utils.uniqueId=function(){return++_idCounter};dc.utils.nameToId=function(name){return name.toLowerCase().replace(/[\s]/g,"_").replace(/[\.']/g,"")};dc.utils.appendOrSelect=function(parent,selector,tag){tag=tag||selector;var element=parent.select(selector);if(element.empty()){element=parent.append(tag)}return element};dc.utils.safeNumber=function(n){return dc.utils.isNumber(+n)?+n:0};dc.logger={};dc.logger.enableDebugLog=false;dc.logger.warn=function(msg){if(console){if(console.warn){console.warn(msg)}else if(console.log){console.log(msg)}}return dc.logger};dc.logger.debug=function(msg){if(dc.logger.enableDebugLog&&console){if(console.debug){console.debug(msg)}else if(console.log){console.log(msg)}}return dc.logger};dc.logger.deprecate=function(fn,msg){var warned=false;function deprecated(){if(!warned){dc.logger.warn(msg);warned=true}return fn.apply(this,arguments)}return deprecated};dc.events={current:null};dc.events.trigger=function(closure,delay){if(!delay){closure();return}dc.events.current=closure;setTimeout(function(){if(closure===dc.events.current){closure()}},delay)};dc.filters={};dc.filters.RangedFilter=function(low,high){var range=new Array(low,high);range.isFiltered=function(value){return value>=this[0]&&value<this[1]};range.filterType="RangedFilter";return range};dc.filters.TwoDimensionalFilter=function(filter){if(filter===null){return null}var f=filter;f.isFiltered=function(value){return value.length&&value.length===f.length&&value[0]===f[0]&&value[1]===f[1]};f.filterType="TwoDimensionalFilter";return f};dc.filters.RangedTwoDimensionalFilter=function(filter){if(filter===null){return null}var f=filter;var fromBottomLeft;if(f[0]instanceof Array){fromBottomLeft=[[Math.min(filter[0][0],filter[1][0]),Math.min(filter[0][1],filter[1][1])],[Math.max(filter[0][0],filter[1][0]),Math.max(filter[0][1],filter[1][1])]]}else{fromBottomLeft=[[filter[0],-Infinity],[filter[1],Infinity]]}f.isFiltered=function(value){var x,y;if(value instanceof Array){x=value[0];y=value[1]}else{x=value;y=fromBottomLeft[0][1]}return x>=fromBottomLeft[0][0]&&x<fromBottomLeft[1][0]&&y>=fromBottomLeft[0][1]&&y<fromBottomLeft[1][1]};f.filterType="RangedTwoDimensionalFilter";return f};dc.baseMixin=function(_chart){_chart.__dcFlag__=dc.utils.uniqueId();var _dimension;var _group;var _anchor;var _root;var _svg;var _isChild;var _minWidth=200;var _defaultWidthCalc=function(element){var width=element&&element.getBoundingClientRect&&element.getBoundingClientRect().width;return width&&width>_minWidth?width:_minWidth};var _widthCalc=_defaultWidthCalc;var _minHeight=200;var _defaultHeightCalc=function(element){var height=element&&element.getBoundingClientRect&&element.getBoundingClientRect().height;return height&&height>_minHeight?height:_minHeight};var _heightCalc=_defaultHeightCalc;var _width,_height;var _useViewBoxResizing=false;var _keyAccessor=dc.pluck("key");var _valueAccessor=dc.pluck("value");var _label=dc.pluck("key");var _ordering=dc.pluck("key");var _orderSort;var _renderLabel=false;var _title=function(d){return _chart.keyAccessor()(d)+": "+_chart.valueAccessor()(d)};var _renderTitle=true;var _controlsUseVisibility=false;var _transitionDuration=750;var _transitionDelay=0;var _filterPrinter=dc.printers.filters;var _mandatoryAttributes=["dimension","group"];var _chartGroup=dc.constants.DEFAULT_CHART_GROUP;var _listeners=d3.dispatch("preRender","postRender","preRedraw","postRedraw","filtered","zoomed","renderlet","pretransition");var _legend;var _commitHandler;var _filters=[];var _filterHandler=function(dimension,filters){if(filters.length===0){dimension.filter(null)}else if(filters.length===1&&!filters[0].isFiltered){dimension.filterExact(filters[0])}else if(filters.length===1&&filters[0].filterType==="RangedFilter"){dimension.filterRange(filters[0])}else{dimension.filterFunction(function(d){for(var i=0;i<filters.length;i++){var filter=filters[i];if(filter.isFiltered&&filter.isFiltered(d)){return true}else if(filter<=d&&filter>=d){return true}}return false})}return filters};var _data=function(group){return group.all()};_chart.height=function(height){if(!arguments.length){if(!dc.utils.isNumber(_height)){_height=_heightCalc(_root.node())}return _height}_heightCalc=d3.functor(height||_defaultHeightCalc);_height=undefined;return _chart};_chart.width=function(width){if(!arguments.length){if(!dc.utils.isNumber(_width)){_width=_widthCalc(_root.node())}return _width}_widthCalc=d3.functor(width||_defaultWidthCalc);_width=undefined;return _chart};_chart.minWidth=function(minWidth){if(!arguments.length){return _minWidth}_minWidth=minWidth;return _chart};_chart.minHeight=function(minHeight){if(!arguments.length){return _minHeight}_minHeight=minHeight;return _chart};_chart.useViewBoxResizing=function(useViewBoxResizing){if(!arguments.length){return _useViewBoxResizing}_useViewBoxResizing=useViewBoxResizing;return _chart};_chart.dimension=function(dimension){if(!arguments.length){return _dimension}_dimension=dimension;_chart.expireCache();return _chart};_chart.data=function(callback){if(!arguments.length){return _data.call(_chart,_group)}_data=d3.functor(callback);_chart.expireCache();return _chart};_chart.group=function(group,name){if(!arguments.length){return _group}_group=group;_chart._groupName=name;_chart.expireCache();return _chart};_chart.ordering=function(orderFunction){if(!arguments.length){return _ordering}_ordering=orderFunction;_orderSort=crossfilter.quicksort.by(_ordering);_chart.expireCache();return _chart};_chart._computeOrderedGroups=function(data){var dataCopy=data.slice(0);if(dataCopy.length<=1){return dataCopy}if(!_orderSort){_orderSort=crossfilter.quicksort.by(_ordering)}return _orderSort(dataCopy,0,dataCopy.length)};_chart.filterAll=function(){return _chart.filter(null)};_chart.select=function(s){return _root.select(s)};_chart.selectAll=function(s){return _root?_root.selectAll(s):null};_chart.anchor=function(parent,chartGroup){if(!arguments.length){return _anchor}if(dc.instanceOfChart(parent)){_anchor=parent.anchor();_root=parent.root();_isChild=true}else if(parent){if(parent.select&&parent.classed){_anchor=parent.node()}else{_anchor=parent}_root=d3.select(_anchor);_root.classed(dc.constants.CHART_CLASS,true);dc.registerChart(_chart,chartGroup);_isChild=false}else{throw new dc.errors.BadArgumentException("parent must be defined")}_chartGroup=chartGroup;return _chart};_chart.anchorName=function(){var a=_chart.anchor();if(a&&a.id){return a.id}if(a&&a.replace){return a.replace("#","")}return"dc-chart"+_chart.chartID()};_chart.root=function(rootElement){if(!arguments.length){return _root}_root=rootElement;return _chart};_chart.svg=function(svgElement){if(!arguments.length){return _svg}_svg=svgElement;return _chart};_chart.resetSvg=function(){_chart.select("svg").remove();return generateSvg()};function sizeSvg(){if(_svg){if(!_useViewBoxResizing){_svg.attr("width",_chart.width()).attr("height",_chart.height())}else if(!_svg.attr("viewBox")){_svg.attr("viewBox","0 0 "+_chart.width()+" "+_chart.height())}}}function generateSvg(){_svg=_chart.root().append("svg");sizeSvg();return _svg}_chart.filterPrinter=function(filterPrinterFunction){if(!arguments.length){return _filterPrinter}_filterPrinter=filterPrinterFunction;return _chart};_chart.controlsUseVisibility=function(useVisibility){if(!arguments.length){return _controlsUseVisibility}_controlsUseVisibility=useVisibility;return _chart};_chart.turnOnControls=function(){if(_root){var attribute=_chart.controlsUseVisibility()?"visibility":"display";_chart.selectAll(".reset").style(attribute,null);_chart.selectAll(".filter").text(_filterPrinter(_chart.filters())).style(attribute,null)}return _chart};_chart.turnOffControls=function(){if(_root){var attribute=_chart.controlsUseVisibility()?"visibility":"display";var value=_chart.controlsUseVisibility()?"hidden":"none";_chart.selectAll(".reset").style(attribute,value);_chart.selectAll(".filter").style(attribute,value).text(_chart.filter())}return _chart};_chart.transitionDuration=function(duration){if(!arguments.length){return _transitionDuration}_transitionDuration=duration;return _chart};_chart.transitionDelay=function(delay){if(!arguments.length){return _transitionDelay}_transitionDelay=delay;return _chart};_chart._mandatoryAttributes=function(_){if(!arguments.length){return _mandatoryAttributes}_mandatoryAttributes=_;return _chart};function checkForMandatoryAttributes(a){if(!_chart[a]||!_chart[a]()){throw new dc.errors.InvalidStateException("Mandatory attribute chart."+a+" is missing on chart[#"+_chart.anchorName()+"]")}}_chart.render=function(){_height=_width=undefined;_listeners.preRender(_chart);if(_mandatoryAttributes){_mandatoryAttributes.forEach(checkForMandatoryAttributes)}var result=_chart._doRender();if(_legend){_legend.render()}_chart._activateRenderlets("postRender");return result};_chart._activateRenderlets=function(event){_listeners.pretransition(_chart);if(_chart.transitionDuration()>0&&_svg){_svg.transition().duration(_chart.transitionDuration()).delay(_chart.transitionDelay()).each("end",function(){_listeners.renderlet(_chart);if(event){_listeners[event](_chart)}})}else{_listeners.renderlet(_chart);if(event){_listeners[event](_chart)}}};_chart.redraw=function(){sizeSvg();_listeners.preRedraw(_chart);var result=_chart._doRedraw();if(_legend){_legend.render()}_chart._activateRenderlets("postRedraw");return result};_chart.commitHandler=function(commitHandler){if(!arguments.length){return _commitHandler}_commitHandler=commitHandler;return _chart};_chart.redrawGroup=function(){if(_commitHandler){_commitHandler(false,function(error,result){if(error){console.log(error)}else{dc.redrawAll(_chart.chartGroup())}})}else{dc.redrawAll(_chart.chartGroup())}return _chart};_chart.renderGroup=function(){if(_commitHandler){_commitHandler(false,function(error,result){if(error){console.log(error)}else{dc.renderAll(_chart.chartGroup())}})}else{dc.renderAll(_chart.chartGroup())}return _chart};_chart._invokeFilteredListener=function(f){if(f!==undefined){_listeners.filtered(_chart,f)}};_chart._invokeZoomedListener=function(){_listeners.zoomed(_chart)};var _hasFilterHandler=function(filters,filter){if(filter===null||typeof filter==="undefined"){return filters.length>0}return filters.some(function(f){return filter<=f&&filter>=f})};_chart.hasFilterHandler=function(hasFilterHandler){if(!arguments.length){return _hasFilterHandler}_hasFilterHandler=hasFilterHandler;return _chart};_chart.hasFilter=function(filter){return _hasFilterHandler(_filters,filter)};var _removeFilterHandler=function(filters,filter){for(var i=0;i<filters.length;i++){if(filters[i]<=filter&&filters[i]>=filter){filters.splice(i,1);break}}return filters};_chart.removeFilterHandler=function(removeFilterHandler){if(!arguments.length){return _removeFilterHandler}_removeFilterHandler=removeFilterHandler;return _chart};var _addFilterHandler=function(filters,filter){filters.push(filter);return filters};_chart.addFilterHandler=function(addFilterHandler){if(!arguments.length){return _addFilterHandler}_addFilterHandler=addFilterHandler;return _chart};var _resetFilterHandler=function(filters){return[]};_chart.resetFilterHandler=function(resetFilterHandler){if(!arguments.length){return _resetFilterHandler}_resetFilterHandler=resetFilterHandler;return _chart};function applyFilters(filters){if(_chart.dimension()&&_chart.dimension().filter){var fs=_filterHandler(_chart.dimension(),filters);if(fs){filters=fs}}return filters}_chart.replaceFilter=function(filter){_filters=_resetFilterHandler(_filters);_chart.filter(filter);return _chart};_chart.filter=function(filter){if(!arguments.length){return _filters.length>0?_filters[0]:null}var filters=_filters;if(filter instanceof Array&&filter[0]instanceof Array&&!filter.isFiltered){filter[0].forEach(function(f){if(_hasFilterHandler(filters,f)){filters=_removeFilterHandler(filters,f)}else{filters=_addFilterHandler(filters,f)}})}else if(filter===null){filters=_resetFilterHandler(filters)}else{if(_hasFilterHandler(filters,filter)){filters=_removeFilterHandler(filters,filter)}else{filters=_addFilterHandler(filters,filter)}}_filters=applyFilters(filters);_chart._invokeFilteredListener(filter);if(_root!==null&&_chart.hasFilter()){_chart.turnOnControls()}else{_chart.turnOffControls()}return _chart};_chart.filters=function(){return _filters};_chart.highlightSelected=function(e){d3.select(e).classed(dc.constants.SELECTED_CLASS,true);d3.select(e).classed(dc.constants.DESELECTED_CLASS,false)};_chart.fadeDeselected=function(e){d3.select(e).classed(dc.constants.SELECTED_CLASS,false);d3.select(e).classed(dc.constants.DESELECTED_CLASS,true)};_chart.resetHighlight=function(e){d3.select(e).classed(dc.constants.SELECTED_CLASS,false);d3.select(e).classed(dc.constants.DESELECTED_CLASS,false)};_chart.onClick=function(datum){var filter=_chart.keyAccessor()(datum);dc.events.trigger(function(){_chart.filter(filter);_chart.redrawGroup()})};_chart.filterHandler=function(filterHandler){if(!arguments.length){return _filterHandler}_filterHandler=filterHandler;return _chart};_chart._doRender=function(){return _chart};_chart._doRedraw=function(){return _chart};_chart.legendables=function(){return[]};_chart.legendHighlight=function(){};_chart.legendReset=function(){};_chart.legendToggle=function(){};_chart.isLegendableHidden=function(){return false};_chart.keyAccessor=function(keyAccessor){if(!arguments.length){return _keyAccessor}_keyAccessor=keyAccessor;return _chart};_chart.valueAccessor=function(valueAccessor){if(!arguments.length){return _valueAccessor}_valueAccessor=valueAccessor;return _chart};_chart.label=function(labelFunction,enableLabels){if(!arguments.length){return _label}_label=labelFunction;if(enableLabels===undefined||enableLabels){_renderLabel=true}return _chart};_chart.renderLabel=function(renderLabel){if(!arguments.length){return _renderLabel}_renderLabel=renderLabel;return _chart};_chart.title=function(titleFunction){if(!arguments.length){return _title}_title=titleFunction;return _chart};_chart.renderTitle=function(renderTitle){if(!arguments.length){return _renderTitle}_renderTitle=renderTitle;return _chart};_chart.renderlet=dc.logger.deprecate(function(renderletFunction){_chart.on("renderlet."+dc.utils.uniqueId(),renderletFunction);return _chart},'chart.renderlet has been deprecated.  Please use chart.on("renderlet.<renderletKey>", renderletFunction)');_chart.chartGroup=function(chartGroup){if(!arguments.length){return _chartGroup}if(!_isChild){dc.deregisterChart(_chart,_chartGroup)}_chartGroup=chartGroup;if(!_isChild){dc.registerChart(_chart,_chartGroup)}return _chart};_chart.expireCache=function(){return _chart};_chart.legend=function(legend){if(!arguments.length){return _legend}_legend=legend;_legend.parent(_chart);return _chart};_chart.chartID=function(){return _chart.__dcFlag__};_chart.options=function(opts){var applyOptions=["anchor","group","xAxisLabel","yAxisLabel","stack","title","point","getColor","overlayGeoJson"];for(var o in opts){if(typeof _chart[o]==="function"){if(opts[o]instanceof Array&&applyOptions.indexOf(o)!==-1){_chart[o].apply(_chart,opts[o])}else{_chart[o].call(_chart,opts[o])}}else{dc.logger.debug("Not a valid option setter name: "+o)}}return _chart};_chart.on=function(event,listener){_listeners.on(event,listener);return _chart};return _chart};dc.marginMixin=function(_chart){var _margin={top:10,right:50,bottom:30,left:30};_chart.margins=function(margins){if(!arguments.length){return _margin}_margin=margins;return _chart};_chart.effectiveWidth=function(){return _chart.width()-_chart.margins().left-_chart.margins().right};_chart.effectiveHeight=function(){return _chart.height()-_chart.margins().top-_chart.margins().bottom};return _chart};dc.colorMixin=function(_chart){var _colors=d3.scale.category20c();var _defaultAccessor=true;var _colorAccessor=function(d){return _chart.keyAccessor()(d)};_chart.colors=function(colorScale){if(!arguments.length){return _colors}if(colorScale instanceof Array){_colors=d3.scale.quantize().range(colorScale)}else{_colors=d3.functor(colorScale)}return _chart};_chart.ordinalColors=function(r){return _chart.colors(d3.scale.ordinal().range(r))};_chart.linearColors=function(r){return _chart.colors(d3.scale.linear().range(r).interpolate(d3.interpolateHcl))};_chart.colorAccessor=function(colorAccessor){if(!arguments.length){return _colorAccessor}_colorAccessor=colorAccessor;_defaultAccessor=false;return _chart};_chart.defaultColorAccessor=function(){return _defaultAccessor};_chart.colorDomain=function(domain){if(!arguments.length){return _colors.domain()}_colors.domain(domain);return _chart};_chart.calculateColorDomain=function(){var newDomain=[d3.min(_chart.data(),_chart.colorAccessor()),d3.max(_chart.data(),_chart.colorAccessor())];_colors.domain(newDomain);return _chart};_chart.getColor=function(d,i){return _colors(_colorAccessor.call(this,d,i))};_chart.colorCalculator=dc.logger.deprecate(function(colorCalculator){if(!arguments.length){return _chart.getColor}_chart.getColor=colorCalculator;return _chart},"colorMixin.colorCalculator has been deprecated. Please colorMixin.colors and colorMixin.colorAccessor instead");return _chart};dc.coordinateGridMixin=function(_chart){var GRID_LINE_CLASS="grid-line";var HORIZONTAL_CLASS="horizontal";var VERTICAL_CLASS="vertical";var Y_AXIS_LABEL_CLASS="y-axis-label";var X_AXIS_LABEL_CLASS="x-axis-label";var DEFAULT_AXIS_LABEL_PADDING=12;_chart=dc.colorMixin(dc.marginMixin(dc.baseMixin(_chart)));_chart.colors(d3.scale.category10());_chart._mandatoryAttributes().push("x");var _parent;var _g;var _chartBodyG;var _x;var _xOriginalDomain;var _xAxis=d3.svg.axis().orient("bottom");var _xUnits=dc.units.integers;var _xAxisPadding=0;var _xAxisPaddingUnit="day";var _xElasticity=false;var _xAxisLabel;var _xAxisLabelPadding=0;var _lastXDomain;var _y;var _yAxis=d3.svg.axis().orient("left");var _yAxisPadding=0;var _yElasticity=false;var _yAxisLabel;var _yAxisLabelPadding=0;var _brush=d3.svg.brush();var _brushOn=true;var _round;var _renderHorizontalGridLine=false;var _renderVerticalGridLine=false;var _refocused=false,_resizing=false;var _unitCount;var _zoomScale=[1,Infinity];var _zoomOutRestrict=true;var _zoom=d3.behavior.zoom().on("zoom",zoomHandler);var _nullZoom=d3.behavior.zoom().on("zoom",null);var _hasBeenMouseZoomable=false;var _rangeChart;var _focusChart;var _mouseZoomable=false;var _clipPadding=0;var _outerRangeBandPadding=.5;var _rangeBandPadding=0;var _useRightYAxis=false;_chart.rescale=function(){_unitCount=undefined;_resizing=true;return _chart};_chart.resizing=function(){return _resizing};_chart.rangeChart=function(rangeChart){if(!arguments.length){return _rangeChart}_rangeChart=rangeChart;_rangeChart.focusChart(_chart);return _chart};_chart.zoomScale=function(extent){if(!arguments.length){return _zoomScale}_zoomScale=extent;return _chart};_chart.zoomOutRestrict=function(zoomOutRestrict){if(!arguments.length){return _zoomOutRestrict}_zoomScale[0]=zoomOutRestrict?1:0;_zoomOutRestrict=zoomOutRestrict;return _chart};_chart._generateG=function(parent){if(parent===undefined){_parent=_chart.svg()}else{_parent=parent}var href=window.location.href.split("#")[0];_g=_parent.append("g");_chartBodyG=_g.append("g").attr("class","chart-body").attr("transform","translate("+_chart.margins().left+", "+_chart.margins().top+")").attr("clip-path","url("+href+"#"+getClipPathId()+")");return _g};_chart.g=function(gElement){if(!arguments.length){return _g}_g=gElement;return _chart};_chart.mouseZoomable=function(mouseZoomable){if(!arguments.length){return _mouseZoomable
}_mouseZoomable=mouseZoomable;return _chart};_chart.chartBodyG=function(chartBodyG){if(!arguments.length){return _chartBodyG}_chartBodyG=chartBodyG;return _chart};_chart.x=function(xScale){if(!arguments.length){return _x}_x=xScale;_xOriginalDomain=_x.domain();_chart.rescale();return _chart};_chart.xOriginalDomain=function(){return _xOriginalDomain};_chart.xUnits=function(xUnits){if(!arguments.length){return _xUnits}_xUnits=xUnits;return _chart};_chart.xAxis=function(xAxis){if(!arguments.length){return _xAxis}_xAxis=xAxis;return _chart};_chart.elasticX=function(elasticX){if(!arguments.length){return _xElasticity}_xElasticity=elasticX;return _chart};_chart.xAxisPadding=function(padding){if(!arguments.length){return _xAxisPadding}_xAxisPadding=padding;return _chart};_chart.xAxisPaddingUnit=function(unit){if(!arguments.length){return _xAxisPaddingUnit}_xAxisPaddingUnit=unit;return _chart};_chart.xUnitCount=function(){if(_unitCount===undefined){var units=_chart.xUnits()(_chart.x().domain()[0],_chart.x().domain()[1],_chart.x().domain());if(units instanceof Array){_unitCount=units.length}else{_unitCount=units}}return _unitCount};_chart.useRightYAxis=function(useRightYAxis){if(!arguments.length){return _useRightYAxis}_useRightYAxis=useRightYAxis;return _chart};_chart.isOrdinal=function(){return _chart.xUnits()===dc.units.ordinal};_chart._useOuterPadding=function(){return true};_chart._ordinalXDomain=function(){var groups=_chart._computeOrderedGroups(_chart.data());return groups.map(_chart.keyAccessor())};function compareDomains(d1,d2){return!d1||!d2||d1.length!==d2.length||d1.some(function(elem,i){return elem&&d2[i]?elem.toString()!==d2[i].toString():elem===d2[i]})}function prepareXAxis(g,render){if(!_chart.isOrdinal()){if(_chart.elasticX()){_x.domain([_chart.xAxisMin(),_chart.xAxisMax()])}}else{if(_chart.elasticX()||_x.domain().length===0){_x.domain(_chart._ordinalXDomain())}}var xdom=_x.domain();if(render||compareDomains(_lastXDomain,xdom)){_chart.rescale()}_lastXDomain=xdom;if(_chart.isOrdinal()){_x.rangeBands([0,_chart.xAxisLength()],_rangeBandPadding,_chart._useOuterPadding()?_outerRangeBandPadding:0)}else{_x.range([0,_chart.xAxisLength()])}_xAxis=_xAxis.scale(_chart.x());renderVerticalGridLines(g)}_chart.renderXAxis=function(g){var axisXG=g.select("g.x");if(axisXG.empty()){axisXG=g.append("g").attr("class","axis x").attr("transform","translate("+_chart.margins().left+","+_chart._xAxisY()+")")}var axisXLab=g.select("text."+X_AXIS_LABEL_CLASS);if(axisXLab.empty()&&_chart.xAxisLabel()){axisXLab=g.append("text").attr("class",X_AXIS_LABEL_CLASS).attr("transform","translate("+(_chart.margins().left+_chart.xAxisLength()/2)+","+(_chart.height()-_xAxisLabelPadding)+")").attr("text-anchor","middle")}if(_chart.xAxisLabel()&&axisXLab.text()!==_chart.xAxisLabel()){axisXLab.text(_chart.xAxisLabel())}dc.transition(axisXG,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform","translate("+_chart.margins().left+","+_chart._xAxisY()+")").call(_xAxis);dc.transition(axisXLab,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform","translate("+(_chart.margins().left+_chart.xAxisLength()/2)+","+(_chart.height()-_xAxisLabelPadding)+")")};function renderVerticalGridLines(g){var gridLineG=g.select("g."+VERTICAL_CLASS);if(_renderVerticalGridLine){if(gridLineG.empty()){gridLineG=g.insert("g",":first-child").attr("class",GRID_LINE_CLASS+" "+VERTICAL_CLASS).attr("transform","translate("+_chart.margins().left+","+_chart.margins().top+")")}var ticks=_xAxis.tickValues()?_xAxis.tickValues():typeof _x.ticks==="function"?_x.ticks(_xAxis.ticks()[0]):_x.domain();var lines=gridLineG.selectAll("line").data(ticks);var linesGEnter=lines.enter().append("line").attr("x1",function(d){return _x(d)}).attr("y1",_chart._xAxisY()-_chart.margins().top).attr("x2",function(d){return _x(d)}).attr("y2",0).attr("opacity",0);dc.transition(linesGEnter,_chart.transitionDuration(),_chart.transitionDelay()).attr("opacity",1);dc.transition(lines,_chart.transitionDuration(),_chart.transitionDelay()).attr("x1",function(d){return _x(d)}).attr("y1",_chart._xAxisY()-_chart.margins().top).attr("x2",function(d){return _x(d)}).attr("y2",0);lines.exit().remove()}else{gridLineG.selectAll("line").remove()}}_chart._xAxisY=function(){return _chart.height()-_chart.margins().bottom};_chart.xAxisLength=function(){return _chart.effectiveWidth()};_chart.xAxisLabel=function(labelText,padding){if(!arguments.length){return _xAxisLabel}_xAxisLabel=labelText;_chart.margins().bottom-=_xAxisLabelPadding;_xAxisLabelPadding=padding===undefined?DEFAULT_AXIS_LABEL_PADDING:padding;_chart.margins().bottom+=_xAxisLabelPadding;return _chart};_chart._prepareYAxis=function(g){if(_y===undefined||_chart.elasticY()){if(_y===undefined){_y=d3.scale.linear()}var min=_chart.yAxisMin()||0,max=_chart.yAxisMax()||0;_y.domain([min,max]).rangeRound([_chart.yAxisHeight(),0])}_y.range([_chart.yAxisHeight(),0]);_yAxis=_yAxis.scale(_y);if(_useRightYAxis){_yAxis.orient("right")}_chart._renderHorizontalGridLinesForAxis(g,_y,_yAxis)};_chart.renderYAxisLabel=function(axisClass,text,rotation,labelXPosition){labelXPosition=labelXPosition||_yAxisLabelPadding;var axisYLab=_chart.g().select("text."+Y_AXIS_LABEL_CLASS+"."+axisClass+"-label");var labelYPosition=_chart.margins().top+_chart.yAxisHeight()/2;if(axisYLab.empty()&&text){axisYLab=_chart.g().append("text").attr("transform","translate("+labelXPosition+","+labelYPosition+"),rotate("+rotation+")").attr("class",Y_AXIS_LABEL_CLASS+" "+axisClass+"-label").attr("text-anchor","middle").text(text)}if(text&&axisYLab.text()!==text){axisYLab.text(text)}dc.transition(axisYLab,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform","translate("+labelXPosition+","+labelYPosition+"),rotate("+rotation+")")};_chart.renderYAxisAt=function(axisClass,axis,position){var axisYG=_chart.g().select("g."+axisClass);if(axisYG.empty()){axisYG=_chart.g().append("g").attr("class","axis "+axisClass).attr("transform","translate("+position+","+_chart.margins().top+")")}dc.transition(axisYG,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform","translate("+position+","+_chart.margins().top+")").call(axis)};_chart.renderYAxis=function(){var axisPosition=_useRightYAxis?_chart.width()-_chart.margins().right:_chart._yAxisX();_chart.renderYAxisAt("y",_yAxis,axisPosition);var labelPosition=_useRightYAxis?_chart.width()-_yAxisLabelPadding:_yAxisLabelPadding;var rotation=_useRightYAxis?90:-90;_chart.renderYAxisLabel("y",_chart.yAxisLabel(),rotation,labelPosition)};_chart._renderHorizontalGridLinesForAxis=function(g,scale,axis){var gridLineG=g.select("g."+HORIZONTAL_CLASS);if(_renderHorizontalGridLine){var ticks=axis.tickValues()?axis.tickValues():scale.ticks(axis.ticks()[0]);if(gridLineG.empty()){gridLineG=g.insert("g",":first-child").attr("class",GRID_LINE_CLASS+" "+HORIZONTAL_CLASS).attr("transform","translate("+_chart.margins().left+","+_chart.margins().top+")")}var lines=gridLineG.selectAll("line").data(ticks);var linesGEnter=lines.enter().append("line").attr("x1",1).attr("y1",function(d){return scale(d)}).attr("x2",_chart.xAxisLength()).attr("y2",function(d){return scale(d)}).attr("opacity",0);dc.transition(linesGEnter,_chart.transitionDuration(),_chart.transitionDelay()).attr("opacity",1);dc.transition(lines,_chart.transitionDuration(),_chart.transitionDelay()).attr("x1",1).attr("y1",function(d){return scale(d)}).attr("x2",_chart.xAxisLength()).attr("y2",function(d){return scale(d)});lines.exit().remove()}else{gridLineG.selectAll("line").remove()}};_chart._yAxisX=function(){return _chart.useRightYAxis()?_chart.width()-_chart.margins().right:_chart.margins().left};_chart.yAxisLabel=function(labelText,padding){if(!arguments.length){return _yAxisLabel}_yAxisLabel=labelText;_chart.margins().left-=_yAxisLabelPadding;_yAxisLabelPadding=padding===undefined?DEFAULT_AXIS_LABEL_PADDING:padding;_chart.margins().left+=_yAxisLabelPadding;return _chart};_chart.y=function(yScale){if(!arguments.length){return _y}_y=yScale;_chart.rescale();return _chart};_chart.yAxis=function(yAxis){if(!arguments.length){return _yAxis}_yAxis=yAxis;return _chart};_chart.elasticY=function(elasticY){if(!arguments.length){return _yElasticity}_yElasticity=elasticY;return _chart};_chart.renderHorizontalGridLines=function(renderHorizontalGridLines){if(!arguments.length){return _renderHorizontalGridLine}_renderHorizontalGridLine=renderHorizontalGridLines;return _chart};_chart.renderVerticalGridLines=function(renderVerticalGridLines){if(!arguments.length){return _renderVerticalGridLine}_renderVerticalGridLine=renderVerticalGridLines;return _chart};_chart.xAxisMin=function(){var min=d3.min(_chart.data(),function(e){return _chart.keyAccessor()(e)});return dc.utils.subtract(min,_xAxisPadding,_xAxisPaddingUnit)};_chart.xAxisMax=function(){var max=d3.max(_chart.data(),function(e){return _chart.keyAccessor()(e)});return dc.utils.add(max,_xAxisPadding,_xAxisPaddingUnit)};_chart.yAxisMin=function(){var min=d3.min(_chart.data(),function(e){return _chart.valueAccessor()(e)});return dc.utils.subtract(min,_yAxisPadding)};_chart.yAxisMax=function(){var max=d3.max(_chart.data(),function(e){return _chart.valueAccessor()(e)});return dc.utils.add(max,_yAxisPadding)};_chart.yAxisPadding=function(padding){if(!arguments.length){return _yAxisPadding}_yAxisPadding=padding;return _chart};_chart.yAxisHeight=function(){return _chart.effectiveHeight()};_chart.round=function(round){if(!arguments.length){return _round}_round=round;return _chart};_chart._rangeBandPadding=function(_){if(!arguments.length){return _rangeBandPadding}_rangeBandPadding=_;return _chart};_chart._outerRangeBandPadding=function(_){if(!arguments.length){return _outerRangeBandPadding}_outerRangeBandPadding=_;return _chart};dc.override(_chart,"filter",function(_){if(!arguments.length){return _chart._filter()}_chart._filter(_);if(_){_chart.brush().extent(_)}else{_chart.brush().clear()}return _chart});_chart.brush=function(_){if(!arguments.length){return _brush}_brush=_;return _chart};function brushHeight(){return _chart._xAxisY()-_chart.margins().top}_chart.renderBrush=function(g){if(_brushOn){_brush.on("brush",_chart._brushing);_brush.on("brushstart",_chart._disableMouseZoom);_brush.on("brushend",configureMouseZoom);var gBrush=g.append("g").attr("class","brush").attr("transform","translate("+_chart.margins().left+","+_chart.margins().top+")").call(_brush.x(_chart.x()));_chart.setBrushY(gBrush,false);_chart.setHandlePaths(gBrush);if(_chart.hasFilter()){_chart.redrawBrush(g,false)}}};_chart.setHandlePaths=function(gBrush){gBrush.selectAll(".resize").append("path").attr("d",_chart.resizeHandlePath)};_chart.setBrushY=function(gBrush){gBrush.selectAll("rect").attr("height",brushHeight());gBrush.selectAll(".resize path").attr("d",_chart.resizeHandlePath)};_chart.extendBrush=function(){var extent=_brush.extent();if(_chart.round()){extent[0]=extent.map(_chart.round())[0];extent[1]=extent.map(_chart.round())[1];_g.select(".brush").call(_brush.extent(extent))}return extent};_chart.brushIsEmpty=function(extent){return _brush.empty()||!extent||extent[1]<=extent[0]};_chart._brushing=function(){var extent=_chart.extendBrush();_chart.redrawBrush(_g,false);if(_chart.brushIsEmpty(extent)){dc.events.trigger(function(){_chart.filter(null);_chart.redrawGroup()},dc.constants.EVENT_DELAY)}else{var rangedFilter=dc.filters.RangedFilter(extent[0],extent[1]);dc.events.trigger(function(){_chart.replaceFilter(rangedFilter);_chart.redrawGroup()},dc.constants.EVENT_DELAY)}};_chart.redrawBrush=function(g,doTransition){if(_brushOn){if(_chart.filter()&&_chart.brush().empty()){_chart.brush().extent(_chart.filter())}var gBrush=dc.optionalTransition(doTransition,_chart.transitionDuration(),_chart.transitionDelay())(g.select("g.brush"));_chart.setBrushY(gBrush);gBrush.call(_chart.brush().x(_chart.x()).extent(_chart.brush().extent()))}_chart.fadeDeselectedArea()};_chart.fadeDeselectedArea=function(){};_chart.resizeHandlePath=function(d){var e=+(d==="e"),x=e?1:-1,y=brushHeight()/3;return"M"+.5*x+","+y+"A6,6 0 0 "+e+" "+6.5*x+","+(y+6)+"V"+(2*y-6)+"A6,6 0 0 "+e+" "+.5*x+","+2*y+"Z"+"M"+2.5*x+","+(y+8)+"V"+(2*y-8)+"M"+4.5*x+","+(y+8)+"V"+(2*y-8)};function getClipPathId(){return _chart.anchorName().replace(/[ .#=\[\]"]/g,"-")+"-clip"}_chart.clipPadding=function(padding){if(!arguments.length){return _clipPadding}_clipPadding=padding;return _chart};function generateClipPath(){var defs=dc.utils.appendOrSelect(_parent,"defs");var id=getClipPathId();var chartBodyClip=dc.utils.appendOrSelect(defs,"#"+id,"clipPath").attr("id",id);var padding=_clipPadding*2;dc.utils.appendOrSelect(chartBodyClip,"rect").attr("width",_chart.xAxisLength()+padding).attr("height",_chart.yAxisHeight()+padding).attr("transform","translate(-"+_clipPadding+", -"+_clipPadding+")")}_chart._preprocessData=function(){};_chart._doRender=function(){_chart.resetSvg();_chart._preprocessData();_chart._generateG();generateClipPath();drawChart(true);configureMouseZoom();return _chart};_chart._doRedraw=function(){_chart._preprocessData();drawChart(false);generateClipPath();return _chart};function drawChart(render){if(_chart.isOrdinal()){_brushOn=false}prepareXAxis(_chart.g(),render);_chart._prepareYAxis(_chart.g());_chart.plotData();if(_chart.elasticX()||_resizing||render){_chart.renderXAxis(_chart.g())}if(_chart.elasticY()||_resizing||render){_chart.renderYAxis(_chart.g())}if(render){_chart.renderBrush(_chart.g(),false)}else{_chart.redrawBrush(_chart.g(),_resizing)}_chart.fadeDeselectedArea();_resizing=false}function configureMouseZoom(){if(_mouseZoomable){_chart._enableMouseZoom()}else if(_hasBeenMouseZoomable){_chart._disableMouseZoom()}}_chart._enableMouseZoom=function(){_hasBeenMouseZoomable=true;_zoom.x(_chart.x()).scaleExtent(_zoomScale).size([_chart.width(),_chart.height()]).duration(_chart.transitionDuration());_chart.root().call(_zoom)};_chart._disableMouseZoom=function(){_chart.root().call(_nullZoom)};function zoomHandler(){_refocused=true;if(_zoomOutRestrict){var constraint=_xOriginalDomain;if(_rangeChart){constraint=intersectExtents(constraint,_rangeChart.x().domain())}var constrained=constrainExtent(_chart.x().domain(),constraint);if(constrained){_chart.x().domain(constrained)}}var domain=_chart.x().domain();var domFilter=dc.filters.RangedFilter(domain[0],domain[1]);_chart.replaceFilter(domFilter);_chart.rescale();_chart.redraw();if(_rangeChart&&!rangesEqual(_chart.filter(),_rangeChart.filter())){dc.events.trigger(function(){_rangeChart.replaceFilter(domFilter);_rangeChart.redraw()})}_chart._invokeZoomedListener();dc.events.trigger(function(){_chart.redrawGroup()},dc.constants.EVENT_DELAY);_refocused=!rangesEqual(domain,_xOriginalDomain)}function intersectExtents(ext1,ext2){if(ext1[0]>ext2[1]||ext1[1]<ext2[0]){console.warn("could not intersect extents")}return[Math.max(ext1[0],ext2[0]),Math.min(ext1[1],ext2[1])]}function constrainExtent(extent,constraint){var size=extent[1]-extent[0];if(extent[0]<constraint[0]){return[constraint[0],Math.min(constraint[1],dc.utils.add(constraint[0],size,"millis"))]}else if(extent[1]>constraint[1]){return[Math.max(constraint[0],dc.utils.subtract(constraint[1],size,"millis")),constraint[1]]}else{return null}}_chart.focus=function(range){if(hasRangeSelected(range)){_chart.x().domain(range)}else{_chart.x().domain(_xOriginalDomain)}_zoom.x(_chart.x());zoomHandler()};_chart.refocused=function(){return _refocused};_chart.focusChart=function(c){if(!arguments.length){return _focusChart}_focusChart=c;_chart.on("filtered",function(chart){if(!chart.filter()){dc.events.trigger(function(){_focusChart.x().domain(_focusChart.xOriginalDomain())})}else if(!rangesEqual(chart.filter(),_focusChart.filter())){dc.events.trigger(function(){_focusChart.focus(chart.filter())})}});return _chart};function rangesEqual(range1,range2){if(!range1&&!range2){return true}else if(!range1||!range2){return false}else if(range1.length===0&&range2.length===0){return true}else if(range1[0].valueOf()===range2[0].valueOf()&&range1[1].valueOf()===range2[1].valueOf()){return true}return false}_chart.brushOn=function(brushOn){if(!arguments.length){return _brushOn}_brushOn=brushOn;return _chart};function hasRangeSelected(range){return range instanceof Array&&range.length>1}return _chart};dc.stackMixin=function(_chart){function prepareValues(layer,layerIdx){var valAccessor=layer.accessor||_chart.valueAccessor();layer.name=String(layer.name||layerIdx);layer.values=layer.group.all().map(function(d,i){return{x:_chart.keyAccessor()(d,i),y:layer.hidden?null:valAccessor(d,i),data:d,layer:layer.name,hidden:layer.hidden}});layer.values=layer.values.filter(domainFilter());return layer.values}var _stackLayout=d3.layout.stack().values(prepareValues);var _stack=[];var _titles={};var _hidableStacks=false;var _evadeDomainFilter=false;function domainFilter(){if(!_chart.x()||_evadeDomainFilter){return d3.functor(true)}var xDomain=_chart.x().domain();if(_chart.isOrdinal()){return function(){return true}}if(_chart.elasticX()){return function(){return true}}return function(p){return p.x>=xDomain[0]&&p.x<=xDomain[xDomain.length-1]}}_chart.stack=function(group,name,accessor){if(!arguments.length){return _stack}if(arguments.length<=2){accessor=name}var layer={group:group};if(typeof name==="string"){layer.name=name}if(typeof accessor==="function"){layer.accessor=accessor}_stack.push(layer);return _chart};dc.override(_chart,"group",function(g,n,f){if(!arguments.length){return _chart._group()}_stack=[];_titles={};_chart.stack(g,n);if(f){_chart.valueAccessor(f)}return _chart._group(g,n)});_chart.hidableStacks=function(hidableStacks){if(!arguments.length){return _hidableStacks}_hidableStacks=hidableStacks;return _chart};function findLayerByName(n){var i=_stack.map(dc.pluck("name")).indexOf(n);return _stack[i]}_chart.hideStack=function(stackName){var layer=findLayerByName(stackName);if(layer){layer.hidden=true}return _chart};_chart.showStack=function(stackName){var layer=findLayerByName(stackName);if(layer){layer.hidden=false}return _chart};_chart.getValueAccessorByIndex=function(index){return _stack[index].accessor||_chart.valueAccessor()};_chart.yAxisMin=function(){var min=d3.min(flattenStack(),function(p){return p.y<0?p.y+p.y0:p.y0});return dc.utils.subtract(min,_chart.yAxisPadding())};_chart.yAxisMax=function(){var max=d3.max(flattenStack(),function(p){return p.y>0?p.y+p.y0:p.y0});return dc.utils.add(max,_chart.yAxisPadding())};function flattenStack(){var valueses=_chart.data().map(function(layer){return layer.values});return Array.prototype.concat.apply([],valueses)}_chart.xAxisMin=function(){var min=d3.min(flattenStack(),dc.pluck("x"));return dc.utils.subtract(min,_chart.xAxisPadding(),_chart.xAxisPaddingUnit())};_chart.xAxisMax=function(){var max=d3.max(flattenStack(),dc.pluck("x"));return dc.utils.add(max,_chart.xAxisPadding(),_chart.xAxisPaddingUnit())};dc.override(_chart,"title",function(stackName,titleAccessor){if(!stackName){return _chart._title()}if(typeof stackName==="function"){return _chart._title(stackName)}if(stackName===_chart._groupName&&typeof titleAccessor==="function"){return _chart._title(titleAccessor)}if(typeof titleAccessor!=="function"){return _titles[stackName]||_chart._title()}_titles[stackName]=titleAccessor;return _chart});_chart.stackLayout=function(stack){if(!arguments.length){return _stackLayout}_stackLayout=stack;if(_stackLayout.values()===d3.layout.stack().values()){_stackLayout.values(prepareValues)}return _chart};_chart.evadeDomainFilter=function(evadeDomainFilter){if(!arguments.length){return _evadeDomainFilter}_evadeDomainFilter=evadeDomainFilter;return _chart};function visability(l){return!l.hidden}_chart.data(function(){var layers=_stack.filter(visability);return layers.length?_chart.stackLayout()(layers):[]});_chart._ordinalXDomain=function(){var flat=flattenStack().map(dc.pluck("data"));var ordered=_chart._computeOrderedGroups(flat);return ordered.map(_chart.keyAccessor())};_chart.colorAccessor(function(d){var layer=this.layer||this.name||d.name||d.layer;return layer});_chart.legendables=function(){return _stack.map(function(layer,i){return{chart:_chart,name:layer.name,hidden:layer.hidden||false,color:_chart.getColor.call(layer,layer.values,i)}})};_chart.isLegendableHidden=function(d){var layer=findLayerByName(d.name);return layer?layer.hidden:false};_chart.legendToggle=function(d){if(_hidableStacks){if(_chart.isLegendableHidden(d)){_chart.showStack(d.name)}else{_chart.hideStack(d.name)}_chart.renderGroup()}};return _chart};dc.capMixin=function(_chart){var _cap=Infinity,_takeFront=true;var _othersLabel="Others";_chart.ordering(function(kv){return-kv.value});var _othersGrouper=function(topItems,restItems){var restItemsSum=d3.sum(restItems,_chart.valueAccessor()),restKeys=restItems.map(_chart.keyAccessor());if(restItemsSum>0){return topItems.concat([{others:restKeys,key:_chart.othersLabel(),value:restItemsSum}])}return topItems};_chart.cappedKeyAccessor=function(d,i){if(d.others){return d.key}return _chart.keyAccessor()(d,i)};_chart.cappedValueAccessor=function(d,i){if(d.others){return d.value}return _chart.valueAccessor()(d,i)};_chart.data(function(group){if(_cap===Infinity){return _chart._computeOrderedGroups(group.all())}else{var items=group.all(),rest;items=_chart._computeOrderedGroups(items);if(_cap){if(_takeFront){rest=items.slice(_cap);items=items.slice(0,_cap)}else{var start=Math.max(0,items.length-_cap);rest=items.slice(0,start);items=items.slice(start)}}if(_othersGrouper){return _othersGrouper(items,rest)}return items}});_chart.cap=function(count){if(!arguments.length){return _cap}_cap=count;return _chart};_chart.takeFront=function(takeFront){if(!arguments.length){return _takeFront}_takeFront=takeFront;return _chart};_chart.othersLabel=function(label){if(!arguments.length){return _othersLabel}_othersLabel=label;return _chart};_chart.othersGrouper=function(grouperFunction){if(!arguments.length){return _othersGrouper}_othersGrouper=grouperFunction;return _chart};dc.override(_chart,"onClick",function(d){if(d.others){_chart.filter([d.others])}_chart._onClick(d)});return _chart};dc.bubbleMixin=function(_chart){var _maxBubbleRelativeSize=.3;var _minRadiusWithLabel=10;var _sortBubbleSize=false;var _elasticRadius=false;_chart.BUBBLE_NODE_CLASS="node";_chart.BUBBLE_CLASS="bubble";_chart.MIN_RADIUS=10;_chart=dc.colorMixin(_chart);_chart.renderLabel(true);_chart.data(function(group){var data=group.all();if(_sortBubbleSize){var radiusAccessor=_chart.radiusValueAccessor();data.sort(function(a,b){return d3.descending(radiusAccessor(a),radiusAccessor(b))})}return data});var _r=d3.scale.linear().domain([0,100]);var _rValueAccessor=function(d){return d.r};_chart.r=function(bubbleRadiusScale){if(!arguments.length){return _r}_r=bubbleRadiusScale;return _chart};_chart.elasticRadius=function(elasticRadius){if(!arguments.length){return _elasticRadius}_elasticRadius=elasticRadius;return _chart};_chart.calculateRadiusDomain=function(){if(_elasticRadius){_chart.r().domain([_chart.rMin(),_chart.rMax()])}};_chart.radiusValueAccessor=function(radiusValueAccessor){if(!arguments.length){return _rValueAccessor}_rValueAccessor=radiusValueAccessor;return _chart};_chart.rMin=function(){var min=d3.min(_chart.data(),function(e){return _chart.radiusValueAccessor()(e)});return min};_chart.rMax=function(){var max=d3.max(_chart.data(),function(e){return _chart.radiusValueAccessor()(e)});return max};_chart.bubbleR=function(d){var value=_chart.radiusValueAccessor()(d);var r=_chart.r()(value);if(isNaN(r)||value<=0){r=0}return r};var labelFunction=function(d){return _chart.label()(d)};var shouldLabel=function(d){return _chart.bubbleR(d)>_minRadiusWithLabel};var labelOpacity=function(d){return shouldLabel(d)?1:0};var labelPointerEvent=function(d){return shouldLabel(d)?"all":"none"};_chart._doRenderLabel=function(bubbleGEnter){if(_chart.renderLabel()){var label=bubbleGEnter.select("text");if(label.empty()){label=bubbleGEnter.append("text").attr("text-anchor","middle").attr("dy",".3em").on("click",_chart.onClick)}label.attr("opacity",0).attr("pointer-events",labelPointerEvent).text(labelFunction);dc.transition(label,_chart.transitionDuration(),_chart.transitionDelay()).attr("opacity",labelOpacity)}};_chart.doUpdateLabels=function(bubbleGEnter){if(_chart.renderLabel()){var labels=bubbleGEnter.select("text").attr("pointer-events",labelPointerEvent).text(labelFunction);dc.transition(labels,_chart.transitionDuration(),_chart.transitionDelay()).attr("opacity",labelOpacity)}};var titleFunction=function(d){return _chart.title()(d)};_chart._doRenderTitles=function(g){if(_chart.renderTitle()){var title=g.select("title");if(title.empty()){g.append("title").text(titleFunction)}}};_chart.doUpdateTitles=function(g){if(_chart.renderTitle()){g.select("title").text(titleFunction)}};_chart.sortBubbleSize=function(sortBubbleSize){if(!arguments.length){return _sortBubbleSize}_sortBubbleSize=sortBubbleSize;return _chart};_chart.minRadius=function(radius){if(!arguments.length){return _chart.MIN_RADIUS}_chart.MIN_RADIUS=radius;return _chart};_chart.minRadiusWithLabel=function(radius){if(!arguments.length){return _minRadiusWithLabel}_minRadiusWithLabel=radius;return _chart};_chart.maxBubbleRelativeSize=function(relativeSize){if(!arguments.length){return _maxBubbleRelativeSize}_maxBubbleRelativeSize=relativeSize;return _chart};_chart.fadeDeselectedArea=function(){if(_chart.hasFilter()){_chart.selectAll("g."+_chart.BUBBLE_NODE_CLASS).each(function(d){if(_chart.isSelectedNode(d)){_chart.highlightSelected(this)}else{_chart.fadeDeselected(this)}})}else{_chart.selectAll("g."+_chart.BUBBLE_NODE_CLASS).each(function(){_chart.resetHighlight(this)})}};_chart.isSelectedNode=function(d){return _chart.hasFilter(d.key)};_chart.onClick=function(d){var filter=d.key;dc.events.trigger(function(){_chart.filter(filter);_chart.redrawGroup()})};return _chart};dc.pieChart=function(parent,chartGroup){var DEFAULT_MIN_ANGLE_FOR_LABEL=.5;var _sliceCssClass="pie-slice";var _labelCssClass="pie-label";var _sliceGroupCssClass="pie-slice-group";var _labelGroupCssClass="pie-label-group";var _emptyCssClass="empty-chart";var _emptyTitle="empty";var _radius,_givenRadius,_innerRadius=0,_externalRadiusPadding=0;var _g;var _cx;var _cy;var _minAngleForLabel=DEFAULT_MIN_ANGLE_FOR_LABEL;var _externalLabelRadius;var _drawPaths=false;var _chart=dc.capMixin(dc.colorMixin(dc.baseMixin({})));_chart.colorAccessor(_chart.cappedKeyAccessor);_chart.title(function(d){return _chart.cappedKeyAccessor(d)+": "+_chart.cappedValueAccessor(d)});_chart.slicesCap=_chart.cap;_chart.label(_chart.cappedKeyAccessor);_chart.renderLabel(true);_chart.transitionDuration(350);_chart.transitionDelay(0);_chart._doRender=function(){_chart.resetSvg();_g=_chart.svg().append("g").attr("transform","translate("+_chart.cx()+","+_chart.cy()+")");_g.append("g").attr("class",_sliceGroupCssClass);_g.append("g").attr("class",_labelGroupCssClass);drawChart();return _chart};function drawChart(){var maxRadius=d3.min([_chart.width(),_chart.height()])/2;_radius=_givenRadius&&_givenRadius<maxRadius?_givenRadius:maxRadius;var arc=buildArcs();var pie=pieLayout();var pieData;if(d3.sum(_chart.data(),_chart.valueAccessor())){pieData=pie(_chart.data());_g.classed(_emptyCssClass,false)}else{pieData=pie([{key:_emptyTitle,value:1,others:[_emptyTitle]}]);_g.classed(_emptyCssClass,true)}if(_g){var slices=_g.select("g."+_sliceGroupCssClass).selectAll("g."+_sliceCssClass).data(pieData);var labels=_g.select("g."+_labelGroupCssClass).selectAll("text."+_labelCssClass).data(pieData);createElements(slices,labels,arc,pieData);updateElements(pieData,arc);removeElements(slices,labels);highlightFilter();dc.transition(_g,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform","translate("+_chart.cx()+","+_chart.cy()+")")}}function createElements(slices,labels,arc,pieData){var slicesEnter=createSliceNodes(slices);createSlicePath(slicesEnter,arc);createTitles(slicesEnter);createLabels(labels,pieData,arc)}function createSliceNodes(slices){var slicesEnter=slices.enter().append("g").attr("class",function(d,i){return _sliceCssClass+" _"+i});return slicesEnter}function createSlicePath(slicesEnter,arc){var slicePath=slicesEnter.append("path").attr("fill",fill).on("click",onClick).attr("d",function(d,i){return safeArc(d,i,arc)});var transition=dc.transition(slicePath,_chart.transitionDuration(),_chart.transitionDelay());if(transition.attrTween){transition.attrTween("d",tweenPie)}}function createTitles(slicesEnter){if(_chart.renderTitle()){slicesEnter.append("title").text(function(d){return _chart.title()(d.data)})}}_chart._applyLabelText=function(labels){labels.text(function(d){var data=d.data;if((sliceHasNoData(data)||sliceTooSmall(d))&&!isSelectedSlice(d)){return""}return _chart.label()(d.data)})};function positionLabels(labels,arc){_chart._applyLabelText(labels);dc.transition(labels,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform",function(d){return labelPosition(d,arc)}).attr("text-anchor","middle")}function highlightSlice(i,whether){_chart.select("g.pie-slice._"+i).classed("highlight",whether)}function createLabels(labels,pieData,arc){if(_chart.renderLabel()){var labelsEnter=labels.enter().append("text").attr("class",function(d,i){var classes=_sliceCssClass+" "+_labelCssClass+" _"+i;if(_externalLabelRadius){classes+=" external"}return classes}).on("click",onClick).on("mouseover",function(d,i){highlightSlice(i,true)}).on("mouseout",function(d,i){highlightSlice(i,false)});positionLabels(labelsEnter,arc);if(_externalLabelRadius&&_drawPaths){updateLabelPaths(pieData,arc)}}}function updateLabelPaths(pieData,arc){var polyline=_g.selectAll("polyline."+_sliceCssClass).data(pieData);polyline.enter().append("polyline").attr("class",function(d,i){return"pie-path _"+i+" "+_sliceCssClass}).on("click",onClick).on("mouseover",function(d,i){highlightSlice(i,true)}).on("mouseout",function(d,i){highlightSlice(i,false)});polyline.exit().remove();var arc2=d3.svg.arc().outerRadius(_radius-_externalRadiusPadding+_externalLabelRadius).innerRadius(_radius-_externalRadiusPadding);var transition=dc.transition(polyline,_chart.transitionDuration(),_chart.transitionDelay());if(transition.attrTween){transition.attrTween("points",function(d){var current=this._current||d;current={startAngle:current.startAngle,endAngle:current.endAngle};var interpolate=d3.interpolate(current,d);this._current=interpolate(0);return function(t){var d2=interpolate(t);return[arc.centroid(d2),arc2.centroid(d2)]}})}else{transition.attr("points",function(d){return[arc.centroid(d),arc2.centroid(d)]})}transition.style("visibility",function(d){return d.endAngle-d.startAngle<1e-4?"hidden":"visible"})}function updateElements(pieData,arc){updateSlicePaths(pieData,arc);updateLabels(pieData,arc);updateTitles(pieData)}function updateSlicePaths(pieData,arc){var slicePaths=_g.selectAll("g."+_sliceCssClass).data(pieData).select("path").attr("d",function(d,i){return safeArc(d,i,arc)});var transition=dc.transition(slicePaths,_chart.transitionDuration(),_chart.transitionDelay());if(transition.attrTween){transition.attrTween("d",tweenPie)}transition.attr("fill",fill)}function updateLabels(pieData,arc){if(_chart.renderLabel()){var labels=_g.selectAll("text."+_labelCssClass).data(pieData);positionLabels(labels,arc);if(_externalLabelRadius&&_drawPaths){updateLabelPaths(pieData,arc)}}}function updateTitles(pieData){if(_chart.renderTitle()){_g.selectAll("g."+_sliceCssClass).data(pieData).select("title").text(function(d){return _chart.title()(d.data)})}}function removeElements(slices,labels){slices.exit().remove();labels.exit().remove()}function highlightFilter(){if(_chart.hasFilter()){_chart.selectAll("g."+_sliceCssClass).each(function(d){if(isSelectedSlice(d)){_chart.highlightSelected(this)}else{_chart.fadeDeselected(this)}})}else{_chart.selectAll("g."+_sliceCssClass).each(function(){_chart.resetHighlight(this)})}}_chart.externalRadiusPadding=function(externalRadiusPadding){if(!arguments.length){return _externalRadiusPadding
}_externalRadiusPadding=externalRadiusPadding;return _chart};_chart.innerRadius=function(innerRadius){if(!arguments.length){return _innerRadius}_innerRadius=innerRadius;return _chart};_chart.radius=function(radius){if(!arguments.length){return _givenRadius}_givenRadius=radius;return _chart};_chart.cx=function(cx){if(!arguments.length){return _cx||_chart.width()/2}_cx=cx;return _chart};_chart.cy=function(cy){if(!arguments.length){return _cy||_chart.height()/2}_cy=cy;return _chart};function buildArcs(){return d3.svg.arc().outerRadius(_radius-_externalRadiusPadding).innerRadius(_innerRadius)}function isSelectedSlice(d){return _chart.hasFilter(_chart.cappedKeyAccessor(d.data))}_chart._doRedraw=function(){drawChart();return _chart};_chart.minAngleForLabel=function(minAngleForLabel){if(!arguments.length){return _minAngleForLabel}_minAngleForLabel=minAngleForLabel;return _chart};function pieLayout(){return d3.layout.pie().sort(null).value(_chart.cappedValueAccessor)}function sliceTooSmall(d){var angle=d.endAngle-d.startAngle;return isNaN(angle)||angle<_minAngleForLabel}function sliceHasNoData(d){return _chart.cappedValueAccessor(d)===0}function tweenPie(b){b.innerRadius=_innerRadius;var current=this._current;if(isOffCanvas(current)){current={startAngle:0,endAngle:0}}else{current={startAngle:current.startAngle,endAngle:current.endAngle}}var i=d3.interpolate(current,b);this._current=i(0);return function(t){return safeArc(i(t),0,buildArcs())}}function isOffCanvas(current){return!current||isNaN(current.startAngle)||isNaN(current.endAngle)}function fill(d,i){return _chart.getColor(d.data,i)}function onClick(d,i){if(_g.attr("class")!==_emptyCssClass){_chart.onClick(d.data,i)}}function safeArc(d,i,arc){var path=arc(d,i);if(path.indexOf("NaN")>=0){path="M0,0"}return path}_chart.emptyTitle=function(title){if(arguments.length===0){return _emptyTitle}_emptyTitle=title;return _chart};_chart.externalLabels=function(externalLabelRadius){if(arguments.length===0){return _externalLabelRadius}else if(externalLabelRadius){_externalLabelRadius=externalLabelRadius}else{_externalLabelRadius=undefined}return _chart};_chart.drawPaths=function(drawPaths){if(arguments.length===0){return _drawPaths}_drawPaths=drawPaths;return _chart};function labelPosition(d,arc){var centroid;if(_externalLabelRadius){centroid=d3.svg.arc().outerRadius(_radius-_externalRadiusPadding+_externalLabelRadius).innerRadius(_radius-_externalRadiusPadding+_externalLabelRadius).centroid(d)}else{centroid=arc.centroid(d)}if(isNaN(centroid[0])||isNaN(centroid[1])){return"translate(0,0)"}else{return"translate("+centroid+")"}}_chart.legendables=function(){return _chart.data().map(function(d,i){var legendable={name:d.key,data:d.value,others:d.others,chart:_chart};legendable.color=_chart.getColor(d,i);return legendable})};_chart.legendHighlight=function(d){highlightSliceFromLegendable(d,true)};_chart.legendReset=function(d){highlightSliceFromLegendable(d,false)};_chart.legendToggle=function(d){_chart.onClick({key:d.name,others:d.others})};function highlightSliceFromLegendable(legendable,highlighted){_chart.selectAll("g.pie-slice").each(function(d){if(legendable.name===d.data.key){d3.select(this).classed("highlight",highlighted)}})}return _chart.anchor(parent,chartGroup)};dc.barChart=function(parent,chartGroup){var MIN_BAR_WIDTH=1;var DEFAULT_GAP_BETWEEN_BARS=2;var LABEL_PADDING=3;var _chart=dc.stackMixin(dc.coordinateGridMixin({}));var _gap=DEFAULT_GAP_BETWEEN_BARS;var _centerBar=false;var _alwaysUseRounding=false;var _barWidth;dc.override(_chart,"rescale",function(){_chart._rescale();_barWidth=undefined;return _chart});dc.override(_chart,"render",function(){if(_chart.round()&&_centerBar&&!_alwaysUseRounding){dc.logger.warn("By default, brush rounding is disabled if bars are centered. "+"See dc.js bar chart API documentation for details.")}return _chart._render()});_chart.label(function(d){return dc.utils.printSingleValue(d.y0+d.y)},false);_chart.plotData=function(){var layers=_chart.chartBodyG().selectAll("g.stack").data(_chart.data());calculateBarWidth();layers.enter().append("g").attr("class",function(d,i){return"stack "+"_"+i});var last=layers.size()-1;layers.each(function(d,i){var layer=d3.select(this);renderBars(layer,i,d);if(_chart.renderLabel()&&last===i){renderLabels(layer,i,d)}})};function barHeight(d){return dc.utils.safeNumber(Math.abs(_chart.y()(d.y+d.y0)-_chart.y()(d.y0)))}function renderLabels(layer,layerIndex,d){var labels=layer.selectAll("text.barLabel").data(d.values,dc.pluck("x"));labels.enter().append("text").attr("class","barLabel").attr("text-anchor","middle");if(_chart.isOrdinal()){labels.on("click",_chart.onClick);labels.attr("cursor","pointer")}dc.transition(labels,_chart.transitionDuration(),_chart.transitionDelay()).attr("x",function(d){var x=_chart.x()(d.x);if(!_centerBar){x+=_barWidth/2}return dc.utils.safeNumber(x)}).attr("y",function(d){var y=_chart.y()(d.y+d.y0);if(d.y<0){y-=barHeight(d)}return dc.utils.safeNumber(y-LABEL_PADDING)}).text(function(d){return _chart.label()(d)});dc.transition(labels.exit(),_chart.transitionDuration(),_chart.transitionDelay()).attr("height",0).remove()}function renderBars(layer,layerIndex,d){var bars=layer.selectAll("rect.bar").data(d.values,dc.pluck("x"));var enter=bars.enter().append("rect").attr("class","bar").attr("fill",dc.pluck("data",_chart.getColor)).attr("y",_chart.yAxisHeight()).attr("height",0);if(_chart.renderTitle()){enter.append("title").text(dc.pluck("data",_chart.title(d.name)))}if(_chart.isOrdinal()){bars.on("click",_chart.onClick)}dc.transition(bars,_chart.transitionDuration(),_chart.transitionDelay()).attr("x",function(d){var x=_chart.x()(d.x);if(_centerBar){x-=_barWidth/2}if(_chart.isOrdinal()&&_gap!==undefined){x+=_gap/2}return dc.utils.safeNumber(x)}).attr("y",function(d){var y=_chart.y()(d.y+d.y0);if(d.y<0){y-=barHeight(d)}return dc.utils.safeNumber(y)}).attr("width",_barWidth).attr("height",function(d){return barHeight(d)}).attr("fill",dc.pluck("data",_chart.getColor)).select("title").text(dc.pluck("data",_chart.title(d.name)));dc.transition(bars.exit(),_chart.transitionDuration(),_chart.transitionDelay()).attr("x",function(d){return _chart.x()(d.x)}).attr("width",_barWidth*.9).remove()}function calculateBarWidth(){if(_barWidth===undefined){var numberOfBars=_chart.xUnitCount();if(_chart.isOrdinal()&&_gap===undefined){_barWidth=Math.floor(_chart.x().rangeBand())}else if(_gap){_barWidth=Math.floor((_chart.xAxisLength()-(numberOfBars-1)*_gap)/numberOfBars)}else{_barWidth=Math.floor(_chart.xAxisLength()/(1+_chart.barPadding())/numberOfBars)}if(_barWidth===Infinity||isNaN(_barWidth)||_barWidth<MIN_BAR_WIDTH){_barWidth=MIN_BAR_WIDTH}}}_chart.fadeDeselectedArea=function(){var bars=_chart.chartBodyG().selectAll("rect.bar");var extent=_chart.brush().extent();if(_chart.isOrdinal()){if(_chart.hasFilter()){bars.classed(dc.constants.SELECTED_CLASS,function(d){return _chart.hasFilter(d.x)});bars.classed(dc.constants.DESELECTED_CLASS,function(d){return!_chart.hasFilter(d.x)})}else{bars.classed(dc.constants.SELECTED_CLASS,false);bars.classed(dc.constants.DESELECTED_CLASS,false)}}else{if(!_chart.brushIsEmpty(extent)){var start=extent[0];var end=extent[1];bars.classed(dc.constants.DESELECTED_CLASS,function(d){return d.x<start||d.x>=end})}else{bars.classed(dc.constants.DESELECTED_CLASS,false)}}};_chart.centerBar=function(centerBar){if(!arguments.length){return _centerBar}_centerBar=centerBar;return _chart};dc.override(_chart,"onClick",function(d){_chart._onClick(d.data)});_chart.barPadding=function(barPadding){if(!arguments.length){return _chart._rangeBandPadding()}_chart._rangeBandPadding(barPadding);_gap=undefined;return _chart};_chart._useOuterPadding=function(){return _gap===undefined};_chart.outerPadding=_chart._outerRangeBandPadding;_chart.gap=function(gap){if(!arguments.length){return _gap}_gap=gap;return _chart};_chart.extendBrush=function(){var extent=_chart.brush().extent();if(_chart.round()&&(!_centerBar||_alwaysUseRounding)){extent[0]=extent.map(_chart.round())[0];extent[1]=extent.map(_chart.round())[1];_chart.chartBodyG().select(".brush").call(_chart.brush().extent(extent))}return extent};_chart.alwaysUseRounding=function(alwaysUseRounding){if(!arguments.length){return _alwaysUseRounding}_alwaysUseRounding=alwaysUseRounding;return _chart};function colorFilter(color,inv){return function(){var item=d3.select(this);var match=item.attr("fill")===color;return inv?!match:match}}_chart.legendHighlight=function(d){if(!_chart.isLegendableHidden(d)){_chart.g().selectAll("rect.bar").classed("highlight",colorFilter(d.color)).classed("fadeout",colorFilter(d.color,true))}};_chart.legendReset=function(){_chart.g().selectAll("rect.bar").classed("highlight",false).classed("fadeout",false)};dc.override(_chart,"xAxisMax",function(){var max=this._xAxisMax();if("resolution"in _chart.xUnits()){var res=_chart.xUnits().resolution;max+=res}return max});return _chart.anchor(parent,chartGroup)};dc.lineChart=function(parent,chartGroup){var DEFAULT_DOT_RADIUS=5;var TOOLTIP_G_CLASS="dc-tooltip";var DOT_CIRCLE_CLASS="dot";var Y_AXIS_REF_LINE_CLASS="yRef";var X_AXIS_REF_LINE_CLASS="xRef";var DEFAULT_DOT_OPACITY=1e-6;var LABEL_PADDING=3;var _chart=dc.stackMixin(dc.coordinateGridMixin({}));var _renderArea=false;var _dotRadius=DEFAULT_DOT_RADIUS;var _dataPointRadius=null;var _dataPointFillOpacity=DEFAULT_DOT_OPACITY;var _dataPointStrokeOpacity=DEFAULT_DOT_OPACITY;var _interpolate="linear";var _tension=.7;var _defined;var _dashStyle;var _xyTipsOn=true;_chart.transitionDuration(500);_chart.transitionDelay(0);_chart._rangeBandPadding(1);_chart.plotData=function(){var chartBody=_chart.chartBodyG();var layersList=chartBody.select("g.stack-list");if(layersList.empty()){layersList=chartBody.append("g").attr("class","stack-list")}var layers=layersList.selectAll("g.stack").data(_chart.data());var layersEnter=layers.enter().append("g").attr("class",function(d,i){return"stack "+"_"+i});drawLine(layersEnter,layers);drawArea(layersEnter,layers);drawDots(chartBody,layers);if(_chart.renderLabel()){drawLabels(layers)}};_chart.interpolate=function(interpolate){if(!arguments.length){return _interpolate}_interpolate=interpolate;return _chart};_chart.tension=function(tension){if(!arguments.length){return _tension}_tension=tension;return _chart};_chart.defined=function(defined){if(!arguments.length){return _defined}_defined=defined;return _chart};_chart.dashStyle=function(dashStyle){if(!arguments.length){return _dashStyle}_dashStyle=dashStyle;return _chart};_chart.renderArea=function(renderArea){if(!arguments.length){return _renderArea}_renderArea=renderArea;return _chart};function colors(d,i){return _chart.getColor.call(d,d.values,i)}function drawLine(layersEnter,layers){var line=d3.svg.line().x(function(d){return _chart.x()(d.x)}).y(function(d){return _chart.y()(d.y+d.y0)}).interpolate(_interpolate).tension(_tension);if(_defined){line.defined(_defined)}var path=layersEnter.append("path").attr("class","line").attr("stroke",colors);if(_dashStyle){path.attr("stroke-dasharray",_dashStyle)}dc.transition(layers.select("path.line"),_chart.transitionDuration(),_chart.transitionDelay()).attr("stroke",colors).attr("d",function(d){return safeD(line(d.values))})}function drawArea(layersEnter,layers){if(_renderArea){var area=d3.svg.area().x(function(d){return _chart.x()(d.x)}).y(function(d){return _chart.y()(d.y+d.y0)}).y0(function(d){return _chart.y()(d.y0)}).interpolate(_interpolate).tension(_tension);if(_defined){area.defined(_defined)}layersEnter.append("path").attr("class","area").attr("fill",colors).attr("d",function(d){return safeD(area(d.values))});dc.transition(layers.select("path.area"),_chart.transitionDuration(),_chart.transitionDelay()).attr("fill",colors).attr("d",function(d){return safeD(area(d.values))})}}function safeD(d){return!d||d.indexOf("NaN")>=0?"M0,0":d}function drawDots(chartBody,layers){if(_chart.xyTipsOn()==="always"||!_chart.brushOn()&&_chart.xyTipsOn()){var tooltipListClass=TOOLTIP_G_CLASS+"-list";var tooltips=chartBody.select("g."+tooltipListClass);if(tooltips.empty()){tooltips=chartBody.append("g").attr("class",tooltipListClass)}layers.each(function(d,layerIndex){var points=d.values;if(_defined){points=points.filter(_defined)}var g=tooltips.select("g."+TOOLTIP_G_CLASS+"._"+layerIndex);if(g.empty()){g=tooltips.append("g").attr("class",TOOLTIP_G_CLASS+" _"+layerIndex)}createRefLines(g);var dots=g.selectAll("circle."+DOT_CIRCLE_CLASS).data(points,dc.pluck("x"));dots.enter().append("circle").attr("class",DOT_CIRCLE_CLASS).attr("r",getDotRadius()).style("fill-opacity",_dataPointFillOpacity).style("stroke-opacity",_dataPointStrokeOpacity).attr("fill",_chart.getColor).on("mousemove",function(){var dot=d3.select(this);showDot(dot);showRefLines(dot,g)}).on("mouseout",function(){var dot=d3.select(this);hideDot(dot);hideRefLines(g)});dots.call(renderTitle,d);dc.transition(dots,_chart.transitionDuration()).attr("cx",function(d){return dc.utils.safeNumber(_chart.x()(d.x))}).attr("cy",function(d){return dc.utils.safeNumber(_chart.y()(d.y+d.y0))}).attr("fill",_chart.getColor);dots.exit().remove()})}}_chart.label(function(d){return dc.utils.printSingleValue(d.y0+d.y)},false);function drawLabels(layers){layers.each(function(d,layerIndex){var layer=d3.select(this);var labels=layer.selectAll("text.lineLabel").data(d.values,dc.pluck("x"));labels.enter().append("text").attr("class","lineLabel").attr("text-anchor","middle");dc.transition(labels,_chart.transitionDuration()).attr("x",function(d){return dc.utils.safeNumber(_chart.x()(d.x))}).attr("y",function(d){var y=_chart.y()(d.y+d.y0)-LABEL_PADDING;return dc.utils.safeNumber(y)}).text(function(d){return _chart.label()(d)});dc.transition(labels.exit(),_chart.transitionDuration()).attr("height",0).remove()})}function createRefLines(g){var yRefLine=g.select("path."+Y_AXIS_REF_LINE_CLASS).empty()?g.append("path").attr("class",Y_AXIS_REF_LINE_CLASS):g.select("path."+Y_AXIS_REF_LINE_CLASS);yRefLine.style("display","none").attr("stroke-dasharray","5,5");var xRefLine=g.select("path."+X_AXIS_REF_LINE_CLASS).empty()?g.append("path").attr("class",X_AXIS_REF_LINE_CLASS):g.select("path."+X_AXIS_REF_LINE_CLASS);xRefLine.style("display","none").attr("stroke-dasharray","5,5")}function showDot(dot){dot.style("fill-opacity",.8);dot.style("stroke-opacity",.8);dot.attr("r",_dotRadius);return dot}function showRefLines(dot,g){var x=dot.attr("cx");var y=dot.attr("cy");var yAxisX=_chart._yAxisX()-_chart.margins().left;var yAxisRefPathD="M"+yAxisX+" "+y+"L"+x+" "+y;var xAxisRefPathD="M"+x+" "+_chart.yAxisHeight()+"L"+x+" "+y;g.select("path."+Y_AXIS_REF_LINE_CLASS).style("display","").attr("d",yAxisRefPathD);g.select("path."+X_AXIS_REF_LINE_CLASS).style("display","").attr("d",xAxisRefPathD)}function getDotRadius(){return _dataPointRadius||_dotRadius}function hideDot(dot){dot.style("fill-opacity",_dataPointFillOpacity).style("stroke-opacity",_dataPointStrokeOpacity).attr("r",getDotRadius())}function hideRefLines(g){g.select("path."+Y_AXIS_REF_LINE_CLASS).style("display","none");g.select("path."+X_AXIS_REF_LINE_CLASS).style("display","none")}function renderTitle(dot,d){if(_chart.renderTitle()){dot.select("title").remove();dot.append("title").text(dc.pluck("data",_chart.title(d.name)))}}_chart.xyTipsOn=function(xyTipsOn){if(!arguments.length){return _xyTipsOn}_xyTipsOn=xyTipsOn;return _chart};_chart.dotRadius=function(dotRadius){if(!arguments.length){return _dotRadius}_dotRadius=dotRadius;return _chart};_chart.renderDataPoints=function(options){if(!arguments.length){return{fillOpacity:_dataPointFillOpacity,strokeOpacity:_dataPointStrokeOpacity,radius:_dataPointRadius}}else if(!options){_dataPointFillOpacity=DEFAULT_DOT_OPACITY;_dataPointStrokeOpacity=DEFAULT_DOT_OPACITY;_dataPointRadius=null}else{_dataPointFillOpacity=options.fillOpacity||.8;_dataPointStrokeOpacity=options.strokeOpacity||.8;_dataPointRadius=options.radius||2}return _chart};function colorFilter(color,dashstyle,inv){return function(){var item=d3.select(this);var match=item.attr("stroke")===color&&item.attr("stroke-dasharray")===(dashstyle instanceof Array?dashstyle.join(","):null)||item.attr("fill")===color;return inv?!match:match}}_chart.legendHighlight=function(d){if(!_chart.isLegendableHidden(d)){_chart.g().selectAll("path.line, path.area").classed("highlight",colorFilter(d.color,d.dashstyle)).classed("fadeout",colorFilter(d.color,d.dashstyle,true))}};_chart.legendReset=function(){_chart.g().selectAll("path.line, path.area").classed("highlight",false).classed("fadeout",false)};dc.override(_chart,"legendables",function(){var legendables=_chart._legendables();if(!_dashStyle){return legendables}return legendables.map(function(l){l.dashstyle=_dashStyle;return l})});return _chart.anchor(parent,chartGroup)};dc.dataCount=function(parent,chartGroup){var _formatNumber=d3.format(",d");var _chart=dc.baseMixin({});var _html={some:"",all:""};_chart.html=function(options){if(!arguments.length){return _html}if(options.all){_html.all=options.all}if(options.some){_html.some=options.some}return _chart};_chart.formatNumber=function(formatter){if(!arguments.length){return _formatNumber}_formatNumber=formatter;return _chart};_chart._doRender=function(){var tot=_chart.dimension().size(),val=_chart.group().value();var all=_formatNumber(tot);var selected=_formatNumber(val);if(tot===val&&_html.all!==""){_chart.root().html(_html.all.replace("%total-count",all).replace("%filter-count",selected))}else if(_html.some!==""){_chart.root().html(_html.some.replace("%total-count",all).replace("%filter-count",selected))}else{_chart.selectAll(".total-count").text(all);_chart.selectAll(".filter-count").text(selected)}return _chart};_chart._doRedraw=function(){return _chart._doRender()};return _chart.anchor(parent,chartGroup)};dc.dataTable=function(parent,chartGroup){var LABEL_CSS_CLASS="dc-table-label";var ROW_CSS_CLASS="dc-table-row";var COLUMN_CSS_CLASS="dc-table-column";var GROUP_CSS_CLASS="dc-table-group";var HEAD_CSS_CLASS="dc-table-head";var _chart=dc.baseMixin({});var _size=25;var _columns=[];var _sortBy=function(d){return d};var _order=d3.ascending;var _beginSlice=0;var _endSlice;var _showGroups=true;_chart._doRender=function(){_chart.selectAll("tbody").remove();renderRows(renderGroups());return _chart};_chart._doColumnValueFormat=function(v,d){return typeof v==="function"?v(d):typeof v==="string"?d[v]:v.format(d)};_chart._doColumnHeaderFormat=function(d){return typeof d==="function"?_chart._doColumnHeaderFnToString(d):typeof d==="string"?_chart._doColumnHeaderCapitalize(d):String(d.label)};_chart._doColumnHeaderCapitalize=function(s){return s.charAt(0).toUpperCase()+s.slice(1)};_chart._doColumnHeaderFnToString=function(f){var s=String(f);var i1=s.indexOf("return ");if(i1>=0){var i2=s.lastIndexOf(";");if(i2>=0){s=s.substring(i1+7,i2);var i3=s.indexOf("numberFormat");if(i3>=0){s=s.replace("numberFormat","")}}}return s};function renderGroups(){var bAllFunctions=true;_columns.forEach(function(f){bAllFunctions=bAllFunctions&typeof f==="function"});if(!bAllFunctions){var thead=_chart.selectAll("thead").data([0]);thead.enter().append("thead");thead.exit().remove();var headrow=thead.selectAll("tr").data([0]);headrow.enter().append("tr");headrow.exit().remove();var headcols=headrow.selectAll("th").data(_columns);headcols.enter().append("th");headcols.exit().remove();headcols.attr("class",HEAD_CSS_CLASS).html(function(d){return _chart._doColumnHeaderFormat(d)})}var groups=_chart.root().selectAll("tbody").data(nestEntries(),function(d){return _chart.keyAccessor()(d)});var rowGroup=groups.enter().append("tbody");if(_showGroups===true){rowGroup.append("tr").attr("class",GROUP_CSS_CLASS).append("td").attr("class",LABEL_CSS_CLASS).attr("colspan",_columns.length).html(function(d){return _chart.keyAccessor()(d)})}groups.exit().remove();return rowGroup}function nestEntries(){var entries;if(_order===d3.ascending){entries=_chart.dimension().bottom(_size)}else{entries=_chart.dimension().top(_size)}return d3.nest().key(_chart.group()).sortKeys(_order).entries(entries.sort(function(a,b){return _order(_sortBy(a),_sortBy(b))}).slice(_beginSlice,_endSlice))}function renderRows(groups){var rows=groups.order().selectAll("tr."+ROW_CSS_CLASS).data(function(d){return d.values});var rowEnter=rows.enter().append("tr").attr("class",ROW_CSS_CLASS);_columns.forEach(function(v,i){rowEnter.append("td").attr("class",COLUMN_CSS_CLASS+" _"+i).html(function(d){return _chart._doColumnValueFormat(v,d)})});rows.exit().remove();return rows}_chart._doRedraw=function(){return _chart._doRender()};_chart.size=function(size){if(!arguments.length){return _size}_size=size;return _chart};_chart.beginSlice=function(beginSlice){if(!arguments.length){return _beginSlice}_beginSlice=beginSlice;return _chart};_chart.endSlice=function(endSlice){if(!arguments.length){return _endSlice}_endSlice=endSlice;return _chart};_chart.columns=function(columns){if(!arguments.length){return _columns}_columns=columns;return _chart};_chart.sortBy=function(sortBy){if(!arguments.length){return _sortBy}_sortBy=sortBy;return _chart};_chart.order=function(order){if(!arguments.length){return _order}_order=order;return _chart};_chart.showGroups=function(showGroups){if(!arguments.length){return _showGroups}_showGroups=showGroups;return _chart};return _chart.anchor(parent,chartGroup)};dc.dataGrid=function(parent,chartGroup){var LABEL_CSS_CLASS="dc-grid-label";var ITEM_CSS_CLASS="dc-grid-item";var GROUP_CSS_CLASS="dc-grid-group";var GRID_CSS_CLASS="dc-grid-top";var _chart=dc.baseMixin({});var _size=999;var _html=function(d){return"you need to provide an html() handling param:  "+JSON.stringify(d)};var _sortBy=function(d){return d};var _order=d3.ascending;var _beginSlice=0,_endSlice;var _htmlGroup=function(d){return"<div class='"+GROUP_CSS_CLASS+"'><h1 class='"+LABEL_CSS_CLASS+"'>"+_chart.keyAccessor()(d)+"</h1></div>"};_chart._doRender=function(){_chart.selectAll("div."+GRID_CSS_CLASS).remove();renderItems(renderGroups());return _chart};function renderGroups(){var groups=_chart.root().selectAll("div."+GRID_CSS_CLASS).data(nestEntries(),function(d){return _chart.keyAccessor()(d)});var itemGroup=groups.enter().append("div").attr("class",GRID_CSS_CLASS);if(_htmlGroup){itemGroup.html(function(d){return _htmlGroup(d)})}groups.exit().remove();return itemGroup}function nestEntries(){var entries=_chart.dimension().top(_size);return d3.nest().key(_chart.group()).sortKeys(_order).entries(entries.sort(function(a,b){return _order(_sortBy(a),_sortBy(b))}).slice(_beginSlice,_endSlice))}function renderItems(groups){var items=groups.order().selectAll("div."+ITEM_CSS_CLASS).data(function(d){return d.values});items.enter().append("div").attr("class",ITEM_CSS_CLASS).html(function(d){return _html(d)});items.exit().remove();return items}_chart._doRedraw=function(){return _chart._doRender()};_chart.beginSlice=function(beginSlice){if(!arguments.length){return _beginSlice}_beginSlice=beginSlice;return _chart};_chart.endSlice=function(endSlice){if(!arguments.length){return _endSlice}_endSlice=endSlice;return _chart};_chart.size=function(size){if(!arguments.length){return _size}_size=size;return _chart};_chart.html=function(html){if(!arguments.length){return _html}_html=html;return _chart};_chart.htmlGroup=function(htmlGroup){if(!arguments.length){return _htmlGroup}_htmlGroup=htmlGroup;return _chart};_chart.sortBy=function(sortByFunction){if(!arguments.length){return _sortBy}_sortBy=sortByFunction;return _chart};_chart.order=function(order){if(!arguments.length){return _order}_order=order;return _chart};return _chart.anchor(parent,chartGroup)};dc.bubbleChart=function(parent,chartGroup){var _chart=dc.bubbleMixin(dc.coordinateGridMixin({}));_chart.transitionDuration(750);_chart.transitionDelay(0);var bubbleLocator=function(d){return"translate("+bubbleX(d)+","+bubbleY(d)+")"};_chart.plotData=function(){_chart.calculateRadiusDomain();_chart.r().range([_chart.MIN_RADIUS,_chart.xAxisLength()*_chart.maxBubbleRelativeSize()]);var data=_chart.data();var bubbleG=_chart.chartBodyG().selectAll("g."+_chart.BUBBLE_NODE_CLASS).data(data,function(d){return d.key});if(_chart.sortBubbleSize()){bubbleG.order()}renderNodes(bubbleG);updateNodes(bubbleG);removeNodes(bubbleG);_chart.fadeDeselectedArea()};function renderNodes(bubbleG){var bubbleGEnter=bubbleG.enter().append("g");bubbleGEnter.attr("class",_chart.BUBBLE_NODE_CLASS).attr("transform",bubbleLocator).append("circle").attr("class",function(d,i){return _chart.BUBBLE_CLASS+" _"+i}).on("click",_chart.onClick).attr("fill",_chart.getColor).attr("r",0);dc.transition(bubbleG,_chart.transitionDuration(),_chart.transitionDelay()).select("circle."+_chart.BUBBLE_CLASS).attr("r",function(d){return _chart.bubbleR(d)}).attr("opacity",function(d){return _chart.bubbleR(d)>0?1:0});_chart._doRenderLabel(bubbleGEnter);_chart._doRenderTitles(bubbleGEnter)}function updateNodes(bubbleG){dc.transition(bubbleG,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform",bubbleLocator).select("circle."+_chart.BUBBLE_CLASS).attr("fill",_chart.getColor).attr("r",function(d){return _chart.bubbleR(d)}).attr("opacity",function(d){return _chart.bubbleR(d)>0?1:0});_chart.doUpdateLabels(bubbleG);_chart.doUpdateTitles(bubbleG)}function removeNodes(bubbleG){bubbleG.exit().remove()}function bubbleX(d){var x=_chart.x()(_chart.keyAccessor()(d));if(isNaN(x)){x=0}return x}function bubbleY(d){var y=_chart.y()(_chart.valueAccessor()(d));if(isNaN(y)){y=0}return y}_chart.renderBrush=function(){};_chart.redrawBrush=function(){_chart.fadeDeselectedArea()};return _chart.anchor(parent,chartGroup)};dc.compositeChart=function(parent,chartGroup){var SUB_CHART_CLASS="sub";var DEFAULT_RIGHT_Y_AXIS_LABEL_PADDING=12;var _chart=dc.coordinateGridMixin({});var _children=[];var _childOptions={};var _shareColors=false,_shareTitle=true,_alignYAxes=false;var _rightYAxis=d3.svg.axis(),_rightYAxisLabel=0,_rightYAxisLabelPadding=DEFAULT_RIGHT_Y_AXIS_LABEL_PADDING,_rightY,_rightAxisGridLines=false;_chart._mandatoryAttributes([]);_chart.transitionDuration(500);_chart.transitionDelay(0);dc.override(_chart,"_generateG",function(){var g=this.__generateG();for(var i=0;i<_children.length;++i){var child=_children[i];generateChildG(child,i);if(!child.dimension()){child.dimension(_chart.dimension())}if(!child.group()){child.group(_chart.group())}child.chartGroup(_chart.chartGroup());child.svg(_chart.svg());child.xUnits(_chart.xUnits());child.transitionDuration(_chart.transitionDuration(),_chart.transitionDelay());child.brushOn(_chart.brushOn());child.renderTitle(_chart.renderTitle());child.elasticX(_chart.elasticX())}return g});_chart._brushing=function(){var extent=_chart.extendBrush();var brushIsEmpty=_chart.brushIsEmpty(extent);for(var i=0;i<_children.length;++i){_children[i].replaceFilter(brushIsEmpty?null:extent)}};_chart._prepareYAxis=function(){var left=leftYAxisChildren().length!==0;var right=rightYAxisChildren().length!==0;var ranges=calculateYAxisRanges(left,right);if(left){prepareLeftYAxis(ranges)}if(right){prepareRightYAxis(ranges)}if(leftYAxisChildren().length>0&&!_rightAxisGridLines){_chart._renderHorizontalGridLinesForAxis(_chart.g(),_chart.y(),_chart.yAxis())}else if(rightYAxisChildren().length>0){_chart._renderHorizontalGridLinesForAxis(_chart.g(),_rightY,_rightYAxis)}};_chart.renderYAxis=function(){if(leftYAxisChildren().length!==0){_chart.renderYAxisAt("y",_chart.yAxis(),_chart.margins().left);_chart.renderYAxisLabel("y",_chart.yAxisLabel(),-90)}if(rightYAxisChildren().length!==0){_chart.renderYAxisAt("yr",_chart.rightYAxis(),_chart.width()-_chart.margins().right);_chart.renderYAxisLabel("yr",_chart.rightYAxisLabel(),90,_chart.width()-_rightYAxisLabelPadding)}};function calculateYAxisRanges(left,right){var lyAxisMin,lyAxisMax,ryAxisMin,ryAxisMax;var ranges;if(left){lyAxisMin=yAxisMin();lyAxisMax=yAxisMax()}if(right){ryAxisMin=rightYAxisMin();ryAxisMax=rightYAxisMax()}if(_chart.alignYAxes()&&left&&right){ranges=alignYAxisRanges(lyAxisMin,lyAxisMax,ryAxisMin,ryAxisMax)}return ranges||{lyAxisMin:lyAxisMin,lyAxisMax:lyAxisMax,ryAxisMin:ryAxisMin,ryAxisMax:ryAxisMax}}function alignYAxisRanges(lyAxisMin,lyAxisMax,ryAxisMin,ryAxisMax){var extentRatio=(ryAxisMax-ryAxisMin)/(lyAxisMax-lyAxisMin);return{lyAxisMin:Math.min(lyAxisMin,ryAxisMin/extentRatio),lyAxisMax:Math.max(lyAxisMax,ryAxisMax/extentRatio),ryAxisMin:Math.min(ryAxisMin,lyAxisMin*extentRatio),ryAxisMax:Math.max(ryAxisMax,lyAxisMax*extentRatio)}}function prepareRightYAxis(ranges){var needDomain=_chart.rightY()===undefined||_chart.elasticY(),needRange=needDomain||_chart.resizing();if(_chart.rightY()===undefined){_chart.rightY(d3.scale.linear())}if(needDomain){_chart.rightY().domain([ranges.ryAxisMin,ranges.ryAxisMax])}if(needRange){_chart.rightY().rangeRound([_chart.yAxisHeight(),0])}_chart.rightY().range([_chart.yAxisHeight(),0]);_chart.rightYAxis(_chart.rightYAxis().scale(_chart.rightY()));_chart.rightYAxis().orient("right")}function prepareLeftYAxis(ranges){var needDomain=_chart.y()===undefined||_chart.elasticY(),needRange=needDomain||_chart.resizing();if(_chart.y()===undefined){_chart.y(d3.scale.linear())}if(needDomain){_chart.y().domain([ranges.lyAxisMin,ranges.lyAxisMax])}if(needRange){_chart.y().rangeRound([_chart.yAxisHeight(),0])}_chart.y().range([_chart.yAxisHeight(),0]);_chart.yAxis(_chart.yAxis().scale(_chart.y()));_chart.yAxis().orient("left")}function generateChildG(child,i){child._generateG(_chart.g());child.g().attr("class",SUB_CHART_CLASS+" _"+i)}_chart.plotData=function(){for(var i=0;i<_children.length;++i){var child=_children[i];if(!child.g()){generateChildG(child,i)}if(_shareColors){child.colors(_chart.colors())}child.x(_chart.x());child.xAxis(_chart.xAxis());if(child.useRightYAxis()){child.y(_chart.rightY());child.yAxis(_chart.rightYAxis())}else{child.y(_chart.y());child.yAxis(_chart.yAxis())}child.plotData();child._activateRenderlets()}};_chart.useRightAxisGridLines=function(useRightAxisGridLines){if(!arguments){return _rightAxisGridLines}_rightAxisGridLines=useRightAxisGridLines;return _chart};_chart.childOptions=function(childOptions){if(!arguments.length){return _childOptions}_childOptions=childOptions;_children.forEach(function(child){child.options(_childOptions)});return _chart};_chart.fadeDeselectedArea=function(){for(var i=0;i<_children.length;++i){var child=_children[i];child.brush(_chart.brush());child.fadeDeselectedArea()}};_chart.rightYAxisLabel=function(rightYAxisLabel,padding){if(!arguments.length){return _rightYAxisLabel}_rightYAxisLabel=rightYAxisLabel;_chart.margins().right-=_rightYAxisLabelPadding;_rightYAxisLabelPadding=padding===undefined?DEFAULT_RIGHT_Y_AXIS_LABEL_PADDING:padding;_chart.margins().right+=_rightYAxisLabelPadding;return _chart};_chart.compose=function(subChartArray){_children=subChartArray;_children.forEach(function(child){child.height(_chart.height());child.width(_chart.width());child.margins(_chart.margins());if(_shareTitle){child.title(_chart.title())}child.options(_childOptions)});return _chart};_chart.children=function(){return _children};_chart.shareColors=function(shareColors){if(!arguments.length){return _shareColors}_shareColors=shareColors;return _chart};_chart.shareTitle=function(shareTitle){if(!arguments.length){return _shareTitle}_shareTitle=shareTitle;return _chart};_chart.rightY=function(yScale){if(!arguments.length){return _rightY}_rightY=yScale;_chart.rescale();return _chart};_chart.alignYAxes=function(alignYAxes){if(!arguments.length){return _alignYAxes}_alignYAxes=alignYAxes;_chart.rescale();return _chart};function leftYAxisChildren(){return _children.filter(function(child){return!child.useRightYAxis()})}function rightYAxisChildren(){return _children.filter(function(child){return child.useRightYAxis()})}function getYAxisMin(charts){return charts.map(function(c){return c.yAxisMin()})}delete _chart.yAxisMin;function yAxisMin(){return d3.min(getYAxisMin(leftYAxisChildren()))}function rightYAxisMin(){return d3.min(getYAxisMin(rightYAxisChildren()))}function getYAxisMax(charts){return charts.map(function(c){return c.yAxisMax()
})}delete _chart.yAxisMax;function yAxisMax(){return dc.utils.add(d3.max(getYAxisMax(leftYAxisChildren())),_chart.yAxisPadding())}function rightYAxisMax(){return dc.utils.add(d3.max(getYAxisMax(rightYAxisChildren())),_chart.yAxisPadding())}function getAllXAxisMinFromChildCharts(){return _children.map(function(c){return c.xAxisMin()})}dc.override(_chart,"xAxisMin",function(){return dc.utils.subtract(d3.min(getAllXAxisMinFromChildCharts()),_chart.xAxisPadding())});function getAllXAxisMaxFromChildCharts(){return _children.map(function(c){return c.xAxisMax()})}dc.override(_chart,"xAxisMax",function(){return dc.utils.add(d3.max(getAllXAxisMaxFromChildCharts()),_chart.xAxisPadding())});_chart.legendables=function(){return _children.reduce(function(items,child){if(_shareColors){child.colors(_chart.colors())}items.push.apply(items,child.legendables());return items},[])};_chart.legendHighlight=function(d){for(var j=0;j<_children.length;++j){var child=_children[j];child.legendHighlight(d)}};_chart.legendReset=function(d){for(var j=0;j<_children.length;++j){var child=_children[j];child.legendReset(d)}};_chart.legendToggle=function(){console.log("composite should not be getting legendToggle itself")};_chart.rightYAxis=function(rightYAxis){if(!arguments.length){return _rightYAxis}_rightYAxis=rightYAxis;return _chart};return _chart.anchor(parent,chartGroup)};dc.seriesChart=function(parent,chartGroup){var _chart=dc.compositeChart(parent,chartGroup);function keySort(a,b){return d3.ascending(_chart.keyAccessor()(a),_chart.keyAccessor()(b))}var _charts={};var _chartFunction=dc.lineChart;var _seriesAccessor;var _seriesSort=d3.ascending;var _valueSort=keySort;_chart._mandatoryAttributes().push("seriesAccessor","chart");_chart.shareColors(true);_chart._preprocessData=function(){var keep=[];var childrenChanged;var nester=d3.nest().key(_seriesAccessor);if(_seriesSort){nester.sortKeys(_seriesSort)}if(_valueSort){nester.sortValues(_valueSort)}var nesting=nester.entries(_chart.data());var children=nesting.map(function(sub,i){var subChart=_charts[sub.key]||_chartFunction.call(_chart,_chart,chartGroup,sub.key,i);if(!_charts[sub.key]){childrenChanged=true}_charts[sub.key]=subChart;keep.push(sub.key);return subChart.dimension(_chart.dimension()).group({all:d3.functor(sub.values)},sub.key).keyAccessor(_chart.keyAccessor()).valueAccessor(_chart.valueAccessor()).brushOn(_chart.brushOn())});Object.keys(_charts).filter(function(c){return keep.indexOf(c)===-1}).forEach(function(c){clearChart(c);childrenChanged=true});_chart._compose(children);if(childrenChanged&&_chart.legend()){_chart.legend().render()}};function clearChart(c){if(_charts[c].g()){_charts[c].g().remove()}delete _charts[c]}function resetChildren(){Object.keys(_charts).map(clearChart);_charts={}}_chart.chart=function(chartFunction){if(!arguments.length){return _chartFunction}_chartFunction=chartFunction;resetChildren();return _chart};_chart.seriesAccessor=function(accessor){if(!arguments.length){return _seriesAccessor}_seriesAccessor=accessor;resetChildren();return _chart};_chart.seriesSort=function(sortFunction){if(!arguments.length){return _seriesSort}_seriesSort=sortFunction;resetChildren();return _chart};_chart.valueSort=function(sortFunction){if(!arguments.length){return _valueSort}_valueSort=sortFunction;resetChildren();return _chart};_chart._compose=_chart.compose;delete _chart.compose;return _chart};dc.geoChoroplethChart=function(parent,chartGroup){var _chart=dc.colorMixin(dc.baseMixin({}));_chart.colorAccessor(function(d){return d||0});var _geoPath=d3.geo.path();var _projectionFlag;var _geoJsons=[];_chart._doRender=function(){_chart.resetSvg();for(var layerIndex=0;layerIndex<_geoJsons.length;++layerIndex){var states=_chart.svg().append("g").attr("class","layer"+layerIndex);var regionG=states.selectAll("g."+geoJson(layerIndex).name).data(geoJson(layerIndex).data).enter().append("g").attr("class",geoJson(layerIndex).name);regionG.append("path").attr("fill","white").attr("d",_geoPath);regionG.append("title");plotData(layerIndex)}_projectionFlag=false};function plotData(layerIndex){var data=generateLayeredData();if(isDataLayer(layerIndex)){var regionG=renderRegionG(layerIndex);renderPaths(regionG,layerIndex,data);renderTitle(regionG,layerIndex,data)}}function generateLayeredData(){var data={};var groupAll=_chart.data();for(var i=0;i<groupAll.length;++i){data[_chart.keyAccessor()(groupAll[i])]=_chart.valueAccessor()(groupAll[i])}return data}function isDataLayer(layerIndex){return geoJson(layerIndex).keyAccessor}function renderRegionG(layerIndex){var regionG=_chart.svg().selectAll(layerSelector(layerIndex)).classed("selected",function(d){return isSelected(layerIndex,d)}).classed("deselected",function(d){return isDeselected(layerIndex,d)}).attr("class",function(d){var layerNameClass=geoJson(layerIndex).name;var regionClass=dc.utils.nameToId(geoJson(layerIndex).keyAccessor(d));var baseClasses=layerNameClass+" "+regionClass;if(isSelected(layerIndex,d)){baseClasses+=" selected"}if(isDeselected(layerIndex,d)){baseClasses+=" deselected"}return baseClasses});return regionG}function layerSelector(layerIndex){return"g.layer"+layerIndex+" g."+geoJson(layerIndex).name}function isSelected(layerIndex,d){return _chart.hasFilter()&&_chart.hasFilter(getKey(layerIndex,d))}function isDeselected(layerIndex,d){return _chart.hasFilter()&&!_chart.hasFilter(getKey(layerIndex,d))}function getKey(layerIndex,d){return geoJson(layerIndex).keyAccessor(d)}function geoJson(index){return _geoJsons[index]}function renderPaths(regionG,layerIndex,data){var paths=regionG.select("path").attr("fill",function(){var currentFill=d3.select(this).attr("fill");if(currentFill){return currentFill}return"none"}).on("click",function(d){return _chart.onClick(d,layerIndex)});dc.transition(paths,_chart.transitionDuration(),_chart.transitionDelay()).attr("fill",function(d,i){return _chart.getColor(data[geoJson(layerIndex).keyAccessor(d)],i)})}_chart.onClick=function(d,layerIndex){var selectedRegion=geoJson(layerIndex).keyAccessor(d);dc.events.trigger(function(){_chart.filter(selectedRegion);_chart.redrawGroup()})};function renderTitle(regionG,layerIndex,data){if(_chart.renderTitle()){regionG.selectAll("title").text(function(d){var key=getKey(layerIndex,d);var value=data[key];return _chart.title()({key:key,value:value})})}}_chart._doRedraw=function(){for(var layerIndex=0;layerIndex<_geoJsons.length;++layerIndex){plotData(layerIndex);if(_projectionFlag){_chart.svg().selectAll("g."+geoJson(layerIndex).name+" path").attr("d",_geoPath)}}_projectionFlag=false};_chart.overlayGeoJson=function(json,name,keyAccessor){for(var i=0;i<_geoJsons.length;++i){if(_geoJsons[i].name===name){_geoJsons[i].data=json;_geoJsons[i].keyAccessor=keyAccessor;return _chart}}_geoJsons.push({name:name,data:json,keyAccessor:keyAccessor});return _chart};_chart.projection=function(projection){_geoPath.projection(projection);_projectionFlag=true;return _chart};_chart.geoJsons=function(){return _geoJsons};_chart.geoPath=function(){return _geoPath};_chart.removeGeoJson=function(name){var geoJsons=[];for(var i=0;i<_geoJsons.length;++i){var layer=_geoJsons[i];if(layer.name!==name){geoJsons.push(layer)}}_geoJsons=geoJsons;return _chart};return _chart.anchor(parent,chartGroup)};dc.bubbleOverlay=function(parent,chartGroup){var BUBBLE_OVERLAY_CLASS="bubble-overlay";var BUBBLE_NODE_CLASS="node";var BUBBLE_CLASS="bubble";var _chart=dc.bubbleMixin(dc.baseMixin({}));var _g;var _points=[];_chart.transitionDuration(750);_chart.transitionDelay(0);_chart.radiusValueAccessor(function(d){return d.value});_chart.point=function(name,x,y){_points.push({name:name,x:x,y:y});return _chart};_chart._doRender=function(){_g=initOverlayG();_chart.r().range([_chart.MIN_RADIUS,_chart.width()*_chart.maxBubbleRelativeSize()]);initializeBubbles();_chart.fadeDeselectedArea();return _chart};function initOverlayG(){_g=_chart.select("g."+BUBBLE_OVERLAY_CLASS);if(_g.empty()){_g=_chart.svg().append("g").attr("class",BUBBLE_OVERLAY_CLASS)}return _g}function initializeBubbles(){var data=mapData();_chart.calculateRadiusDomain();_points.forEach(function(point){var nodeG=getNodeG(point,data);var circle=nodeG.select("circle."+BUBBLE_CLASS);if(circle.empty()){circle=nodeG.append("circle").attr("class",BUBBLE_CLASS).attr("r",0).attr("fill",_chart.getColor).on("click",_chart.onClick)}dc.transition(circle,_chart.transitionDuration(),_chart.transitionDelay()).attr("r",function(d){return _chart.bubbleR(d)});_chart._doRenderLabel(nodeG);_chart._doRenderTitles(nodeG)})}function mapData(){var data={};_chart.data().forEach(function(datum){data[_chart.keyAccessor()(datum)]=datum});return data}function getNodeG(point,data){var bubbleNodeClass=BUBBLE_NODE_CLASS+" "+dc.utils.nameToId(point.name);var nodeG=_g.select("g."+dc.utils.nameToId(point.name));if(nodeG.empty()){nodeG=_g.append("g").attr("class",bubbleNodeClass).attr("transform","translate("+point.x+","+point.y+")")}nodeG.datum(data[point.name]);return nodeG}_chart._doRedraw=function(){updateBubbles();_chart.fadeDeselectedArea();return _chart};function updateBubbles(){var data=mapData();_chart.calculateRadiusDomain();_points.forEach(function(point){var nodeG=getNodeG(point,data);var circle=nodeG.select("circle."+BUBBLE_CLASS);dc.transition(circle,_chart.transitionDuration(),_chart.transitionDelay()).attr("r",function(d){return _chart.bubbleR(d)}).attr("fill",_chart.getColor);_chart.doUpdateLabels(nodeG);_chart.doUpdateTitles(nodeG)})}_chart.debug=function(flag){if(flag){var debugG=_chart.select("g."+dc.constants.DEBUG_GROUP_CLASS);if(debugG.empty()){debugG=_chart.svg().append("g").attr("class",dc.constants.DEBUG_GROUP_CLASS)}var debugText=debugG.append("text").attr("x",10).attr("y",20);debugG.append("rect").attr("width",_chart.width()).attr("height",_chart.height()).on("mousemove",function(){var position=d3.mouse(debugG.node());var msg=position[0]+", "+position[1];debugText.text(msg)})}else{_chart.selectAll(".debug").remove()}return _chart};_chart.anchor(parent,chartGroup);return _chart};dc.rowChart=function(parent,chartGroup){var _g;var _labelOffsetX=10;var _labelOffsetY=15;var _hasLabelOffsetY=false;var _dyOffset="0.35em";var _titleLabelOffsetX=2;var _gap=5;var _fixedBarHeight=false;var _rowCssClass="row";var _titleRowCssClass="titlerow";var _renderTitleLabel=false;var _chart=dc.capMixin(dc.marginMixin(dc.colorMixin(dc.baseMixin({}))));var _x;var _elasticX;var _xAxis=d3.svg.axis().orient("bottom");var _rowData;_chart.rowsCap=_chart.cap;function calculateAxisScale(){if(!_x||_elasticX){var extent=d3.extent(_rowData,_chart.cappedValueAccessor);if(extent[0]>0){extent[0]=0}if(extent[1]<0){extent[1]=0}_x=d3.scale.linear().domain(extent).range([0,_chart.effectiveWidth()])}_xAxis.scale(_x)}function drawAxis(){var axisG=_g.select("g.axis");calculateAxisScale();if(axisG.empty()){axisG=_g.append("g").attr("class","axis")}axisG.attr("transform","translate(0, "+_chart.effectiveHeight()+")");dc.transition(axisG,_chart.transitionDuration(),_chart.transitionDelay()).call(_xAxis)}_chart._doRender=function(){_chart.resetSvg();_g=_chart.svg().append("g").attr("transform","translate("+_chart.margins().left+","+_chart.margins().top+")");drawChart();return _chart};_chart.title(function(d){return _chart.cappedKeyAccessor(d)+": "+_chart.cappedValueAccessor(d)});_chart.label(_chart.cappedKeyAccessor);_chart.x=function(scale){if(!arguments.length){return _x}_x=scale;return _chart};function drawGridLines(){_g.selectAll("g.tick").select("line.grid-line").remove();_g.selectAll("g.tick").append("line").attr("class","grid-line").attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",function(){return-_chart.effectiveHeight()})}function drawChart(){_rowData=_chart.data();drawAxis();drawGridLines();var rows=_g.selectAll("g."+_rowCssClass).data(_rowData);createElements(rows);removeElements(rows);updateElements(rows)}function createElements(rows){var rowEnter=rows.enter().append("g").attr("class",function(d,i){return _rowCssClass+" _"+i});rowEnter.append("rect").attr("width",0);createLabels(rowEnter)}function removeElements(rows){rows.exit().remove()}function rootValue(){var root=_x(0);return root===-Infinity||root!==root?_x(1):root}function updateElements(rows){var n=_rowData.length;var height;if(!_fixedBarHeight){height=(_chart.effectiveHeight()-(n+1)*_gap)/n}else{height=_fixedBarHeight}if(!_hasLabelOffsetY){_labelOffsetY=height/2}var rect=rows.attr("transform",function(d,i){return"translate(0,"+((i+1)*_gap+i*height)+")"}).select("rect").attr("height",height).attr("fill",_chart.getColor).on("click",onClick).classed("deselected",function(d){return _chart.hasFilter()?!isSelectedRow(d):false}).classed("selected",function(d){return _chart.hasFilter()?isSelectedRow(d):false});dc.transition(rect,_chart.transitionDuration(),_chart.transitionDelay()).attr("width",function(d){return Math.abs(rootValue()-_x(_chart.valueAccessor()(d)))}).attr("transform",translateX);createTitles(rows);updateLabels(rows)}function createTitles(rows){if(_chart.renderTitle()){rows.select("title").remove();rows.append("title").text(_chart.title())}}function createLabels(rowEnter){if(_chart.renderLabel()){rowEnter.append("text").on("click",onClick)}if(_chart.renderTitleLabel()){rowEnter.append("text").attr("class",_titleRowCssClass).on("click",onClick)}}function updateLabels(rows){if(_chart.renderLabel()){var lab=rows.select("text").attr("x",_labelOffsetX).attr("y",_labelOffsetY).attr("dy",_dyOffset).on("click",onClick).attr("class",function(d,i){return _rowCssClass+" _"+i}).text(function(d){return _chart.label()(d)});dc.transition(lab,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform",translateX)}if(_chart.renderTitleLabel()){var titlelab=rows.select("."+_titleRowCssClass).attr("x",_chart.effectiveWidth()-_titleLabelOffsetX).attr("y",_labelOffsetY).attr("dy",_dyOffset).attr("text-anchor","end").on("click",onClick).attr("class",function(d,i){return _titleRowCssClass+" _"+i}).text(function(d){return _chart.title()(d)});dc.transition(titlelab,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform",translateX)}}_chart.renderTitleLabel=function(renderTitleLabel){if(!arguments.length){return _renderTitleLabel}_renderTitleLabel=renderTitleLabel;return _chart};function onClick(d){_chart.onClick(d)}function translateX(d){var x=_x(_chart.cappedValueAccessor(d)),x0=rootValue(),s=x>x0?x0:x;return"translate("+s+",0)"}_chart._doRedraw=function(){drawChart();return _chart};_chart.xAxis=function(){return _xAxis};_chart.fixedBarHeight=function(fixedBarHeight){if(!arguments.length){return _fixedBarHeight}_fixedBarHeight=fixedBarHeight;return _chart};_chart.gap=function(gap){if(!arguments.length){return _gap}_gap=gap;return _chart};_chart.elasticX=function(elasticX){if(!arguments.length){return _elasticX}_elasticX=elasticX;return _chart};_chart.labelOffsetX=function(labelOffsetX){if(!arguments.length){return _labelOffsetX}_labelOffsetX=labelOffsetX;return _chart};_chart.labelOffsetY=function(labelOffsety){if(!arguments.length){return _labelOffsetY}_labelOffsetY=labelOffsety;_hasLabelOffsetY=true;return _chart};_chart.titleLabelOffsetX=function(titleLabelOffsetX){if(!arguments.length){return _titleLabelOffsetX}_titleLabelOffsetX=titleLabelOffsetX;return _chart};function isSelectedRow(d){return _chart.hasFilter(_chart.cappedKeyAccessor(d))}return _chart.anchor(parent,chartGroup)};dc.legend=function(){var LABEL_GAP=2;var _legend={},_parent,_x=0,_y=0,_itemHeight=12,_gap=5,_horizontal=false,_legendWidth=560,_itemWidth=70,_autoItemWidth=false,_legendText=dc.pluck("name"),_maxItems;var _g;_legend.parent=function(p){if(!arguments.length){return _parent}_parent=p;return _legend};_legend.render=function(){_parent.svg().select("g.dc-legend").remove();_g=_parent.svg().append("g").attr("class","dc-legend").attr("transform","translate("+_x+","+_y+")");var legendables=_parent.legendables();if(_maxItems!==undefined){legendables=legendables.slice(0,_maxItems)}var itemEnter=_g.selectAll("g.dc-legend-item").data(legendables).enter().append("g").attr("class","dc-legend-item").on("mouseover",function(d){_parent.legendHighlight(d)}).on("mouseout",function(d){_parent.legendReset(d)}).on("click",function(d){d.chart.legendToggle(d)});_g.selectAll("g.dc-legend-item").classed("fadeout",function(d){return d.chart.isLegendableHidden(d)});if(legendables.some(dc.pluck("dashstyle"))){itemEnter.append("line").attr("x1",0).attr("y1",_itemHeight/2).attr("x2",_itemHeight).attr("y2",_itemHeight/2).attr("stroke-width",2).attr("stroke-dasharray",dc.pluck("dashstyle")).attr("stroke",dc.pluck("color"))}else{itemEnter.append("rect").attr("width",_itemHeight).attr("height",_itemHeight).attr("fill",function(d){return d?d.color:"blue"})}itemEnter.append("text").text(_legendText).attr("x",_itemHeight+LABEL_GAP).attr("y",function(){return _itemHeight/2+(this.clientHeight?this.clientHeight:13)/2-2});var _cumulativeLegendTextWidth=0;var row=0;itemEnter.attr("transform",function(d,i){if(_horizontal){var itemWidth=_autoItemWidth===true?this.getBBox().width+_gap:_itemWidth;if(_cumulativeLegendTextWidth+itemWidth>_legendWidth&&_cumulativeLegendTextWidth>0){++row;_cumulativeLegendTextWidth=0}var translateBy="translate("+_cumulativeLegendTextWidth+","+row*legendItemHeight()+")";_cumulativeLegendTextWidth+=itemWidth;return translateBy}else{return"translate(0,"+i*legendItemHeight()+")"}})};function legendItemHeight(){return _gap+_itemHeight}_legend.x=function(x){if(!arguments.length){return _x}_x=x;return _legend};_legend.y=function(y){if(!arguments.length){return _y}_y=y;return _legend};_legend.gap=function(gap){if(!arguments.length){return _gap}_gap=gap;return _legend};_legend.itemHeight=function(itemHeight){if(!arguments.length){return _itemHeight}_itemHeight=itemHeight;return _legend};_legend.horizontal=function(horizontal){if(!arguments.length){return _horizontal}_horizontal=horizontal;return _legend};_legend.legendWidth=function(legendWidth){if(!arguments.length){return _legendWidth}_legendWidth=legendWidth;return _legend};_legend.itemWidth=function(itemWidth){if(!arguments.length){return _itemWidth}_itemWidth=itemWidth;return _legend};_legend.autoItemWidth=function(autoItemWidth){if(!arguments.length){return _autoItemWidth}_autoItemWidth=autoItemWidth;return _legend};_legend.legendText=function(legendText){if(!arguments.length){return _legendText}_legendText=legendText;return _legend};_legend.maxItems=function(maxItems){if(!arguments.length){return _maxItems}_maxItems=dc.utils.isNumber(maxItems)?maxItems:undefined;return _legend};return _legend};dc.scatterPlot=function(parent,chartGroup){var _chart=dc.coordinateGridMixin({});var _symbol=d3.svg.symbol();var _existenceAccessor=function(d){return d.value};var originalKeyAccessor=_chart.keyAccessor();_chart.keyAccessor(function(d){return originalKeyAccessor(d)[0]});_chart.valueAccessor(function(d){return originalKeyAccessor(d)[1]});_chart.colorAccessor(function(){return _chart._groupName});_chart.title(function(d){return _chart.keyAccessor()(d)+","+_chart.valueAccessor()(d)+": "+_chart.existenceAccessor()(d)});var _locator=function(d){return"translate("+_chart.x()(_chart.keyAccessor()(d))+","+_chart.y()(_chart.valueAccessor()(d))+")"};var _highlightedSize=7;var _symbolSize=5;var _excludedSize=3;var _excludedColor=null;var _excludedOpacity=1;var _emptySize=0;var _emptyOpacity=0;var _nonemptyOpacity=1;var _emptyColor=null;var _filtered=[];function elementSize(d,i){if(!_existenceAccessor(d)){return Math.pow(_emptySize,2)}else if(_filtered[i]){return Math.pow(_symbolSize,2)}else{return Math.pow(_excludedSize,2)}}_symbol.size(elementSize);dc.override(_chart,"_filter",function(filter){if(!arguments.length){return _chart.__filter()}return _chart.__filter(dc.filters.RangedTwoDimensionalFilter(filter))});_chart.plotData=function(){var symbols=_chart.chartBodyG().selectAll("path.symbol").data(_chart.data());symbols.enter().append("path").attr("class","symbol").attr("opacity",0).attr("fill",_chart.getColor).attr("transform",_locator);symbols.call(renderTitles,_chart.data());symbols.each(function(d,i){_filtered[i]=!_chart.filter()||_chart.filter().isFiltered([d.key[0],d.key[1]])});dc.transition(symbols,_chart.transitionDuration(),_chart.transitionDelay()).attr("opacity",function(d,i){if(!_existenceAccessor(d)){return _emptyOpacity}else if(_filtered[i]){return _nonemptyOpacity}else{return _chart.excludedOpacity()}}).attr("fill",function(d,i){if(_emptyColor&&!_existenceAccessor(d)){return _emptyColor}else if(_chart.excludedColor()&&!_filtered[i]){return _chart.excludedColor()}else{return _chart.getColor(d)}}).attr("transform",_locator).attr("d",_symbol);dc.transition(symbols.exit(),_chart.transitionDuration(),_chart.transitionDelay()).attr("opacity",0).remove()};function renderTitles(symbol,d){if(_chart.renderTitle()){symbol.selectAll("title").remove();symbol.append("title").text(function(d){return _chart.title()(d)})}}_chart.existenceAccessor=function(accessor){if(!arguments.length){return _existenceAccessor}_existenceAccessor=accessor;return this};_chart.symbol=function(type){if(!arguments.length){return _symbol.type()}_symbol.type(type);return _chart};_chart.customSymbol=function(customSymbol){if(!arguments.length){return _symbol}_symbol=customSymbol;_symbol.size(elementSize);return _chart};_chart.symbolSize=function(symbolSize){if(!arguments.length){return _symbolSize}_symbolSize=symbolSize;return _chart};_chart.highlightedSize=function(highlightedSize){if(!arguments.length){return _highlightedSize}_highlightedSize=highlightedSize;return _chart};_chart.excludedSize=function(excludedSize){if(!arguments.length){return _excludedSize}_excludedSize=excludedSize;return _chart};_chart.excludedColor=function(excludedColor){if(!arguments.length){return _excludedColor}_excludedColor=excludedColor;return _chart};_chart.excludedOpacity=function(excludedOpacity){if(!arguments.length){return _excludedOpacity}_excludedOpacity=excludedOpacity;return _chart};_chart.hiddenSize=_chart.emptySize=function(emptySize){if(!arguments.length){return _emptySize}_emptySize=emptySize;return _chart};_chart.emptyColor=function(emptyColor){if(!arguments.length){return _emptyColor}_emptyColor=emptyColor;return _chart};_chart.emptyOpacity=function(emptyOpacity){if(!arguments.length){return _emptyOpacity}_emptyOpacity=emptyOpacity;return _chart};_chart.nonemptyOpacity=function(nonemptyOpacity){if(!arguments.length){return _emptyOpacity}_nonemptyOpacity=nonemptyOpacity;return _chart};_chart.legendables=function(){return[{chart:_chart,name:_chart._groupName,color:_chart.getColor()}]};_chart.legendHighlight=function(d){resizeSymbolsWhere(function(symbol){return symbol.attr("fill")===d.color},_highlightedSize);_chart.chartBodyG().selectAll(".chart-body path.symbol").filter(function(){return d3.select(this).attr("fill")!==d.color}).classed("fadeout",true)};_chart.legendReset=function(d){resizeSymbolsWhere(function(symbol){return symbol.attr("fill")===d.color},_symbolSize);_chart.chartBodyG().selectAll(".chart-body path.symbol").filter(function(){return d3.select(this).attr("fill")!==d.color}).classed("fadeout",false)};function resizeSymbolsWhere(condition,size){var symbols=_chart.chartBodyG().selectAll(".chart-body path.symbol").filter(function(){return condition(d3.select(this))});var oldSize=_symbol.size();_symbol.size(Math.pow(size,2));dc.transition(symbols,_chart.transitionDuration(),_chart.transitionDelay()).attr("d",_symbol);_symbol.size(oldSize)}_chart.setHandlePaths=function(){};_chart.extendBrush=function(){var extent=_chart.brush().extent();if(_chart.round()){extent[0]=extent[0].map(_chart.round());extent[1]=extent[1].map(_chart.round());_chart.g().select(".brush").call(_chart.brush().extent(extent))}return extent};_chart.brushIsEmpty=function(extent){return _chart.brush().empty()||!extent||extent[0][0]>=extent[1][0]||extent[0][1]>=extent[1][1]};_chart._brushing=function(){var extent=_chart.extendBrush();_chart.redrawBrush(_chart.g());if(_chart.brushIsEmpty(extent)){dc.events.trigger(function(){_chart.filter(null);_chart.redrawGroup()})}else{var ranged2DFilter=dc.filters.RangedTwoDimensionalFilter(extent);dc.events.trigger(function(){_chart.filter(null);_chart.filter(ranged2DFilter);_chart.redrawGroup()},dc.constants.EVENT_DELAY)}};_chart.setBrushY=function(gBrush){gBrush.call(_chart.brush().y(_chart.y()))};return _chart.anchor(parent,chartGroup)};dc.numberDisplay=function(parent,chartGroup){var SPAN_CLASS="number-display";var _formatNumber=d3.format(".2s");var _chart=dc.baseMixin({});var _html={one:"",some:"",none:""};var _lastValue;_chart._mandatoryAttributes(["group"]);_chart.ordering(function(kv){return kv.value});_chart.html=function(html){if(!arguments.length){return _html}if(html.none){_html.none=html.none}else if(html.one){_html.none=html.one}else if(html.some){_html.none=html.some}if(html.one){_html.one=html.one}else if(html.some){_html.one=html.some}if(html.some){_html.some=html.some}else if(html.one){_html.some=html.one}return _chart};_chart.value=function(){return _chart.data()};function maxBin(all){if(!all.length){return null}var sorted=_chart._computeOrderedGroups(all);return sorted[sorted.length-1]}_chart.data(function(group){var valObj=group.value?group.value():maxBin(group.all());return _chart.valueAccessor()(valObj)});_chart.transitionDuration(250);_chart.transitionDelay(0);_chart._doRender=function(){var newValue=_chart.value(),span=_chart.selectAll("."+SPAN_CLASS);if(span.empty()){span=span.data([0]).enter().append("span").attr("class",SPAN_CLASS)}span.transition().duration(_chart.transitionDuration()).delay(_chart.transitionDelay()).ease("quad-out-in").tween("text",function(){var interpStart=isFinite(_lastValue)?_lastValue:0;var interp=d3.interpolateNumber(interpStart||0,newValue);_lastValue=newValue;return function(t){var html=null,num=_chart.formatNumber()(interp(t));if(newValue===0&&_html.none!==""){html=_html.none}else if(newValue===1&&_html.one!==""){html=_html.one}else if(_html.some!==""){html=_html.some}this.innerHTML=html?html.replace("%number",num):num}})};_chart._doRedraw=function(){return _chart._doRender()};_chart.formatNumber=function(formatter){if(!arguments.length){return _formatNumber}_formatNumber=formatter;return _chart};return _chart.anchor(parent,chartGroup)};dc.heatMap=function(parent,chartGroup){var DEFAULT_BORDER_RADIUS=6.75;var _chartBody;var _cols;var _rows;var _colOrdering=d3.ascending;var _rowOrdering=d3.ascending;var _colScale=d3.scale.ordinal();var _rowScale=d3.scale.ordinal();var _xBorderRadius=DEFAULT_BORDER_RADIUS;var _yBorderRadius=DEFAULT_BORDER_RADIUS;var _chart=dc.colorMixin(dc.marginMixin(dc.baseMixin({})));_chart._mandatoryAttributes(["group"]);_chart.title(_chart.colorAccessor());var _colsLabel=function(d){return d};var _rowsLabel=function(d){return d};_chart.colsLabel=function(labelFunction){if(!arguments.length){return _colsLabel}_colsLabel=labelFunction;return _chart};_chart.rowsLabel=function(labelFunction){if(!arguments.length){return _rowsLabel}_rowsLabel=labelFunction;return _chart};var _xAxisOnClick=function(d){filterAxis(0,d)};var _yAxisOnClick=function(d){filterAxis(1,d)};var _boxOnClick=function(d){var filter=d.key;dc.events.trigger(function(){_chart.filter(filter);_chart.redrawGroup()})};function filterAxis(axis,value){var cellsOnAxis=_chart.selectAll(".box-group").filter(function(d){return d.key[axis]===value});var unfilteredCellsOnAxis=cellsOnAxis.filter(function(d){return!_chart.hasFilter(d.key)});dc.events.trigger(function(){var selection=unfilteredCellsOnAxis.empty()?cellsOnAxis:unfilteredCellsOnAxis;var filters=selection.data().map(function(kv){return dc.filters.TwoDimensionalFilter(kv.key)});_chart._filter([filters]);_chart.redrawGroup()})}dc.override(_chart,"filter",function(filter){if(!arguments.length){return _chart._filter()}return _chart._filter(dc.filters.TwoDimensionalFilter(filter))});_chart.rows=function(rows){if(!arguments.length){return _rows}_rows=rows;return _chart};_chart.rowOrdering=function(_){if(!arguments.length){return _rowOrdering}_rowOrdering=_;return _chart};_chart.cols=function(cols){if(!arguments.length){return _cols}_cols=cols;return _chart};_chart.colOrdering=function(_){if(!arguments.length){return _colOrdering}_colOrdering=_;return _chart};_chart._doRender=function(){_chart.resetSvg();_chartBody=_chart.svg().append("g").attr("class","heatmap").attr("transform","translate("+_chart.margins().left+","+_chart.margins().top+")");return _chart._doRedraw()};_chart._doRedraw=function(){var data=_chart.data(),rows=_chart.rows()||data.map(_chart.valueAccessor()),cols=_chart.cols()||data.map(_chart.keyAccessor());if(_rowOrdering){rows=rows.sort(_rowOrdering)}if(_colOrdering){cols=cols.sort(_colOrdering)}rows=_rowScale.domain(rows);cols=_colScale.domain(cols);var rowCount=rows.domain().length,colCount=cols.domain().length,boxWidth=Math.floor(_chart.effectiveWidth()/colCount),boxHeight=Math.floor(_chart.effectiveHeight()/rowCount);cols.rangeRoundBands([0,_chart.effectiveWidth()]);rows.rangeRoundBands([_chart.effectiveHeight(),0]);var boxes=_chartBody.selectAll("g.box-group").data(_chart.data(),function(d,i){return _chart.keyAccessor()(d,i)+"\x00"+_chart.valueAccessor()(d,i)});var gEnter=boxes.enter().append("g").attr("class","box-group");gEnter.append("rect").attr("class","heat-box").attr("fill","white").on("click",_chart.boxOnClick());if(_chart.renderTitle()){gEnter.append("title");boxes.select("title").text(_chart.title())}dc.transition(boxes.select("rect"),_chart.transitionDuration(),_chart.transitionDelay()).attr("x",function(d,i){return cols(_chart.keyAccessor()(d,i))}).attr("y",function(d,i){return rows(_chart.valueAccessor()(d,i))}).attr("rx",_xBorderRadius).attr("ry",_yBorderRadius).attr("fill",_chart.getColor).attr("width",boxWidth).attr("height",boxHeight);boxes.exit().remove();var gCols=_chartBody.select("g.cols");if(gCols.empty()){gCols=_chartBody.append("g").attr("class","cols axis")}var gColsText=gCols.selectAll("text").data(cols.domain());gColsText.enter().append("text").attr("x",function(d){return cols(d)+boxWidth/2}).style("text-anchor","middle").attr("y",_chart.effectiveHeight()).attr("dy",12).on("click",_chart.xAxisOnClick()).text(_chart.colsLabel());dc.transition(gColsText,_chart.transitionDuration(),_chart.transitionDelay()).text(_chart.colsLabel()).attr("x",function(d){return cols(d)+boxWidth/2}).attr("y",_chart.effectiveHeight());gColsText.exit().remove();var gRows=_chartBody.select("g.rows");if(gRows.empty()){gRows=_chartBody.append("g").attr("class","rows axis")}var gRowsText=gRows.selectAll("text").data(rows.domain());gRowsText.enter().append("text").attr("dy",6).style("text-anchor","end").attr("x",0).attr("dx",-2).on("click",_chart.yAxisOnClick()).text(_chart.rowsLabel());dc.transition(gRowsText,_chart.transitionDuration(),_chart.transitionDelay()).text(_chart.rowsLabel()).attr("y",function(d){return rows(d)+boxHeight/2});gRowsText.exit().remove();if(_chart.hasFilter()){_chart.selectAll("g.box-group").each(function(d){if(_chart.isSelectedNode(d)){_chart.highlightSelected(this)}else{_chart.fadeDeselected(this)}})}else{_chart.selectAll("g.box-group").each(function(){_chart.resetHighlight(this)})}return _chart};_chart.boxOnClick=function(handler){if(!arguments.length){return _boxOnClick}_boxOnClick=handler;return _chart};_chart.xAxisOnClick=function(handler){if(!arguments.length){return _xAxisOnClick}_xAxisOnClick=handler;return _chart};_chart.yAxisOnClick=function(handler){if(!arguments.length){return _yAxisOnClick}_yAxisOnClick=handler;return _chart};_chart.xBorderRadius=function(xBorderRadius){if(!arguments.length){return _xBorderRadius}_xBorderRadius=xBorderRadius;return _chart};_chart.yBorderRadius=function(yBorderRadius){if(!arguments.length){return _yBorderRadius}_yBorderRadius=yBorderRadius;return _chart};_chart.isSelectedNode=function(d){return _chart.hasFilter(d.key)};return _chart.anchor(parent,chartGroup)};(function(){d3.box=function(){var width=1,height=1,duration=0,delay=0,domain=null,value=Number,whiskers=boxWhiskers,quartiles=boxQuartiles,tickFormat=null;
function box(g){g.each(function(d,i){d=d.map(value).sort(d3.ascending);var g=d3.select(this),n=d.length,min=d[0],max=d[n-1];var quartileData=d.quartiles=quartiles(d);var whiskerIndices=whiskers&&whiskers.call(this,d,i),whiskerData=whiskerIndices&&whiskerIndices.map(function(i){return d[i]});var outlierIndices=whiskerIndices?d3.range(0,whiskerIndices[0]).concat(d3.range(whiskerIndices[1]+1,n)):d3.range(n);var x1=d3.scale.linear().domain(domain&&domain.call(this,d,i)||[min,max]).range([height,0]);var x0=this.__chart__||d3.scale.linear().domain([0,Infinity]).range(x1.range());this.__chart__=x1;var center=g.selectAll("line.center").data(whiskerData?[whiskerData]:[]);center.enter().insert("line","rect").attr("class","center").attr("x1",width/2).attr("y1",function(d){return x0(d[0])}).attr("x2",width/2).attr("y2",function(d){return x0(d[1])}).style("opacity",1e-6).transition().duration(duration).delay(delay).style("opacity",1).attr("y1",function(d){return x1(d[0])}).attr("y2",function(d){return x1(d[1])});center.transition().duration(duration).delay(delay).style("opacity",1).attr("x1",width/2).attr("x2",width/2).attr("y1",function(d){return x1(d[0])}).attr("y2",function(d){return x1(d[1])});center.exit().transition().duration(duration).delay(delay).style("opacity",1e-6).attr("y1",function(d){return x1(d[0])}).attr("y2",function(d){return x1(d[1])}).remove();var box=g.selectAll("rect.box").data([quartileData]);box.enter().append("rect").attr("class","box").attr("x",0).attr("y",function(d){return x0(d[2])}).attr("width",width).attr("height",function(d){return x0(d[0])-x0(d[2])}).transition().duration(duration).delay(delay).attr("y",function(d){return x1(d[2])}).attr("height",function(d){return x1(d[0])-x1(d[2])});box.transition().duration(duration).delay(delay).attr("width",width).attr("y",function(d){return x1(d[2])}).attr("height",function(d){return x1(d[0])-x1(d[2])});var medianLine=g.selectAll("line.median").data([quartileData[1]]);medianLine.enter().append("line").attr("class","median").attr("x1",0).attr("y1",x0).attr("x2",width).attr("y2",x0).transition().duration(duration).delay(delay).attr("y1",x1).attr("y2",x1);medianLine.transition().duration(duration).delay(delay).attr("x1",0).attr("x2",width).attr("y1",x1).attr("y2",x1);var whisker=g.selectAll("line.whisker").data(whiskerData||[]);whisker.enter().insert("line","circle, text").attr("class","whisker").attr("x1",0).attr("y1",x0).attr("x2",width).attr("y2",x0).style("opacity",1e-6).transition().duration(duration).delay(delay).attr("y1",x1).attr("y2",x1).style("opacity",1);whisker.transition().duration(duration).delay(delay).attr("x1",0).attr("x2",width).attr("y1",x1).attr("y2",x1).style("opacity",1);whisker.exit().transition().duration(duration).delay(delay).attr("y1",x1).attr("y2",x1).style("opacity",1e-6).remove();var outlier=g.selectAll("circle.outlier").data(outlierIndices,Number);outlier.enter().insert("circle","text").attr("class","outlier").attr("r",5).attr("cx",width/2).attr("cy",function(i){return x0(d[i])}).style("opacity",1e-6).transition().duration(duration).delay(delay).attr("cy",function(i){return x1(d[i])}).style("opacity",1);outlier.transition().duration(duration).delay(delay).attr("cx",width/2).attr("cy",function(i){return x1(d[i])}).style("opacity",1);outlier.exit().transition().duration(duration).delay(delay).attr("cy",function(i){return x1(d[i])}).style("opacity",1e-6).remove();var format=tickFormat||x1.tickFormat(8);var boxTick=g.selectAll("text.box").data(quartileData);boxTick.enter().append("text").attr("class","box").attr("dy",".3em").attr("dx",function(d,i){return i&1?6:-6}).attr("x",function(d,i){return i&1?width:0}).attr("y",x0).attr("text-anchor",function(d,i){return i&1?"start":"end"}).text(format).transition().duration(duration).delay(delay).attr("y",x1);boxTick.transition().duration(duration).delay(delay).text(format).attr("x",function(d,i){return i&1?width:0}).attr("y",x1);var whiskerTick=g.selectAll("text.whisker").data(whiskerData||[]);whiskerTick.enter().append("text").attr("class","whisker").attr("dy",".3em").attr("dx",6).attr("x",width).attr("y",x0).text(format).style("opacity",1e-6).transition().duration(duration).delay(delay).attr("y",x1).style("opacity",1);whiskerTick.transition().duration(duration).delay(delay).text(format).attr("x",width).attr("y",x1).style("opacity",1);whiskerTick.exit().transition().duration(duration).delay(delay).attr("y",x1).style("opacity",1e-6).remove()});d3.timer.flush()}box.width=function(x){if(!arguments.length){return width}width=x;return box};box.height=function(x){if(!arguments.length){return height}height=x;return box};box.tickFormat=function(x){if(!arguments.length){return tickFormat}tickFormat=x;return box};box.duration=function(x){if(!arguments.length){return duration}duration=x;return box};box.domain=function(x){if(!arguments.length){return domain}domain=x===null?x:d3.functor(x);return box};box.value=function(x){if(!arguments.length){return value}value=x;return box};box.whiskers=function(x){if(!arguments.length){return whiskers}whiskers=x;return box};box.quartiles=function(x){if(!arguments.length){return quartiles}quartiles=x;return box};return box};function boxWhiskers(d){return[0,d.length-1]}function boxQuartiles(d){return[d3.quantile(d,.25),d3.quantile(d,.5),d3.quantile(d,.75)]}})();dc.boxPlot=function(parent,chartGroup){var _chart=dc.coordinateGridMixin({});function DEFAULT_WHISKERS_IQR(k){return function(d){var q1=d.quartiles[0],q3=d.quartiles[2],iqr=(q3-q1)*k,i=-1,j=d.length;do{++i}while(d[i]<q1-iqr);do{--j}while(d[j]>q3+iqr);return[i,j]}}var _whiskerIqrFactor=1.5;var _whiskersIqr=DEFAULT_WHISKERS_IQR;var _whiskers=_whiskersIqr(_whiskerIqrFactor);var _box=d3.box();var _tickFormat=null;var _boxWidth=function(innerChartWidth,xUnits){if(_chart.isOrdinal()){return _chart.x().rangeBand()}else{return innerChartWidth/(1+_chart.boxPadding())/xUnits}};_chart.yAxisPadding(12);_chart.x(d3.scale.ordinal());_chart.xUnits(dc.units.ordinal);_chart.data(function(group){return group.all().map(function(d){d.map=function(accessor){return accessor.call(d,d)};return d}).filter(function(d){var values=_chart.valueAccessor()(d);return values.length!==0})});_chart.boxPadding=_chart._rangeBandPadding;_chart.boxPadding(.8);_chart.outerPadding=_chart._outerRangeBandPadding;_chart.outerPadding(.5);_chart.boxWidth=function(boxWidth){if(!arguments.length){return _boxWidth}_boxWidth=d3.functor(boxWidth);return _chart};var boxTransform=function(d,i){var xOffset=_chart.x()(_chart.keyAccessor()(d,i));return"translate("+xOffset+", 0)"};_chart._preprocessData=function(){if(_chart.elasticX()){_chart.x().domain([])}};_chart.plotData=function(){var _calculatedBoxWidth=_boxWidth(_chart.effectiveWidth(),_chart.xUnitCount());_box.whiskers(_whiskers).width(_calculatedBoxWidth).height(_chart.effectiveHeight()).value(_chart.valueAccessor()).domain(_chart.y().domain()).duration(_chart.transitionDuration()).tickFormat(_tickFormat);var boxesG=_chart.chartBodyG().selectAll("g.box").data(_chart.data(),_chart.keyAccessor());renderBoxes(boxesG);updateBoxes(boxesG);removeBoxes(boxesG);_chart.fadeDeselectedArea()};function renderBoxes(boxesG){var boxesGEnter=boxesG.enter().append("g");boxesGEnter.attr("class","box").attr("transform",boxTransform).call(_box).on("click",function(d){_chart.filter(_chart.keyAccessor()(d));_chart.redrawGroup()})}function updateBoxes(boxesG){dc.transition(boxesG,_chart.transitionDuration(),_chart.transitionDelay()).attr("transform",boxTransform).call(_box).each(function(){d3.select(this).select("rect.box").attr("fill",_chart.getColor)})}function removeBoxes(boxesG){boxesG.exit().remove().call(_box)}_chart.fadeDeselectedArea=function(){if(_chart.hasFilter()){if(_chart.isOrdinal()){_chart.g().selectAll("g.box").each(function(d){if(_chart.isSelectedNode(d)){_chart.highlightSelected(this)}else{_chart.fadeDeselected(this)}})}else{var extent=_chart.brush().extent();var start=extent[0];var end=extent[1];var keyAccessor=_chart.keyAccessor();_chart.g().selectAll("g.box").each(function(d){var key=keyAccessor(d);if(key<start||key>=end){_chart.fadeDeselected(this)}else{_chart.highlightSelected(this)}})}}else{_chart.g().selectAll("g.box").each(function(){_chart.resetHighlight(this)})}};_chart.isSelectedNode=function(d){return _chart.hasFilter(_chart.keyAccessor()(d))};_chart.yAxisMin=function(){var min=d3.min(_chart.data(),function(e){return d3.min(_chart.valueAccessor()(e))});return dc.utils.subtract(min,_chart.yAxisPadding())};_chart.yAxisMax=function(){var max=d3.max(_chart.data(),function(e){return d3.max(_chart.valueAccessor()(e))});return dc.utils.add(max,_chart.yAxisPadding())};_chart.tickFormat=function(tickFormat){if(!arguments.length){return _tickFormat}_tickFormat=tickFormat;return _chart};return _chart.anchor(parent,chartGroup)};dc.selectMenu=function(parent,chartGroup){var SELECT_CSS_CLASS="dc-select-menu";var OPTION_CSS_CLASS="dc-select-option";var _chart=dc.baseMixin({});var _select;var _promptText="Select all";var _multiple=false;var _promptValue=null;var _numberVisible=null;var _order=function(a,b){return _chart.keyAccessor()(a)>_chart.keyAccessor()(b)?1:_chart.keyAccessor()(b)>_chart.keyAccessor()(a)?-1:0};var _filterDisplayed=function(d){return _chart.valueAccessor()(d)>0};_chart.data(function(group){return group.all().filter(_filterDisplayed)});_chart._doRender=function(){_chart.select("select").remove();_select=_chart.root().append("select").classed(SELECT_CSS_CLASS,true);_select.append("option").text(_promptText).attr("value","");_chart._doRedraw();return _chart};_chart._doRedraw=function(){setAttributes();renderOptions();if(_chart.hasFilter()&&_multiple){_select.selectAll("option").property("selected",function(d){return d&&_chart.filters().indexOf(String(_chart.keyAccessor()(d)))>=0})}else if(_chart.hasFilter()){_select.property("value",_chart.filter())}else{_select.property("value","")}return _chart};function renderOptions(){var options=_select.selectAll("option."+OPTION_CSS_CLASS).data(_chart.data(),function(d){return _chart.keyAccessor()(d)});options.enter().append("option").classed(OPTION_CSS_CLASS,true).attr("value",function(d){return _chart.keyAccessor()(d)});options.text(_chart.title());options.exit().remove();_select.selectAll("option."+OPTION_CSS_CLASS).sort(_order);_select.on("change",onChange);return options}function onChange(d,i){var values;var target=d3.event.target;if(target.selectedOptions){var selectedOptions=Array.prototype.slice.call(target.selectedOptions);values=selectedOptions.map(function(d){return d.value})}else{var options=[].slice.call(d3.event.target.options);values=options.filter(function(option){return option.selected}).map(function(option){return option.value})}if(values.length===1&&values[0]===""){values=_promptValue||null}else if(!_multiple&&values.length===1){values=values[0]}_chart.onChange(values)}_chart.onChange=function(val){if(val&&_multiple){_chart.replaceFilter([val])}else if(val){_chart.replaceFilter(val)}else{_chart.filterAll()}dc.events.trigger(function(){_chart.redrawGroup()})};function setAttributes(){if(_multiple){_select.attr("multiple",true)}else{_select.attr("multiple",null)}if(_numberVisible!==null){_select.attr("size",_numberVisible)}else{_select.attr("size",null)}}_chart.order=function(order){if(!arguments.length){return _order}_order=order;return _chart};_chart.promptText=function(_){if(!arguments.length){return _promptText}_promptText=_;return _chart};_chart.filterDisplayed=function(filterDisplayed){if(!arguments.length){return _filterDisplayed}_filterDisplayed=filterDisplayed;return _chart};_chart.multiple=function(multiple){if(!arguments.length){return _multiple}_multiple=multiple;return _chart};_chart.promptValue=function(promptValue){if(!arguments.length){return _promptValue}_promptValue=promptValue;return _chart};_chart.numberVisible=function(numberVisible){if(!arguments.length){return _numberVisible}_numberVisible=numberVisible;return _chart};_chart.size=dc.logger.deprecate(_chart.numberVisible,"selectMenu.size is ambiguous - use numberVisible instead");return _chart.anchor(parent,chartGroup)};dc.abstractBubbleChart=dc.bubbleMixin;dc.baseChart=dc.baseMixin;dc.capped=dc.capMixin;dc.colorChart=dc.colorMixin;dc.coordinateGridChart=dc.coordinateGridMixin;dc.marginable=dc.marginMixin;dc.stackableChart=dc.stackMixin;dc.d3=d3;dc.crossfilter=crossfilter;return dc}if(typeof define==="function"&&define.amd){define(["d3","crossfilter2"],_dc)}else if(typeof module==="object"&&module.exports){var _d3=require("d3");var _crossfilter=require("crossfilter2");if(typeof _crossfilter!=="function"){_crossfilter=_crossfilter.crossfilter}module.exports=_dc(_d3,_crossfilter)}else{this.dc=_dc(d3,crossfilter)}})();var CalHeatMap=function(){"use strict";var self=this;this.allowedDataType=["json","csv","tsv","txt"];this.options={itemSelector:"#cal-heatmap",paintOnLoad:true,range:12,cellSize:10,cellPadding:2,cellRadius:0,domainGutter:2,domainMargin:[0,0,0,0],domain:"hour",subDomain:"min",colLimit:null,rowLimit:null,weekStartOnMonday:true,start:new Date,minDate:null,maxDate:null,data:"",dataType:this.allowedDataType[0],considerMissingDataAsZero:false,loadOnInit:true,verticalOrientation:false,domainDynamicDimension:true,label:{position:"bottom",align:"center",offset:{x:0,y:0},rotate:null,width:100,height:null},legend:[10,20,30,40],displayLegend:true,legendCellSize:10,legendCellPadding:2,legendMargin:[0,0,0,0],legendVerticalPosition:"bottom",legendHorizontalPosition:"left",legendOrientation:"horizontal",legendColors:null,highlight:[],itemName:["item","items"],domainLabelFormat:null,subDomainTitleFormat:{empty:"{date}",filled:"{count} {name} {connector} {date}"},subDomainDateFormat:null,subDomainTextFormat:null,legendTitleFormat:{lower:"less than {min} {name}",inner:"between {down} and {up} {name}",upper:"more than {max} {name}"},animationDuration:500,nextSelector:false,previousSelector:false,itemNamespace:"cal-heatmap",tooltip:false,onClick:null,afterLoad:null,afterLoadNextDomain:null,afterLoadPreviousDomain:null,onComplete:null,afterLoadData:function(data){return data},onMaxDomainReached:null,onMinDomainReached:null};this._domainType={min:{name:"minute",level:10,maxItemNumber:60,defaultRowNumber:10,defaultColumnNumber:6,row:function(d){return self.getSubDomainRowNumber(d)},column:function(d){return self.getSubDomainColumnNumber(d)},position:{x:function(d){return Math.floor(d.getMinutes()/self._domainType.min.row(d))},y:function(d){return d.getMinutes()%self._domainType.min.row(d)}},format:{date:"%H:%M, %A %B %-e, %Y",legend:"",connector:"at"},extractUnit:function(d){return new Date(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours(),d.getMinutes()).getTime()}},hour:{name:"hour",level:20,maxItemNumber:function(d){switch(self.options.domain){case"day":return 24;case"week":return 24*7;case"month":return 24*(self.options.domainDynamicDimension?self.getDayCountInMonth(d):31)}},defaultRowNumber:6,defaultColumnNumber:function(d){switch(self.options.domain){case"day":return 4;case"week":return 28;case"month":return self.options.domainDynamicDimension?self.getDayCountInMonth(d):31}},row:function(d){return self.getSubDomainRowNumber(d)},column:function(d){return self.getSubDomainColumnNumber(d)},position:{x:function(d){if(self.options.domain==="month"){if(self.options.colLimit>0||self.options.rowLimit>0){return Math.floor((d.getHours()+(d.getDate()-1)*24)/self._domainType.hour.row(d))}return Math.floor(d.getHours()/self._domainType.hour.row(d))+(d.getDate()-1)*4}else if(self.options.domain==="week"){if(self.options.colLimit>0||self.options.rowLimit>0){return Math.floor((d.getHours()+self.getWeekDay(d)*24)/self._domainType.hour.row(d))}return Math.floor(d.getHours()/self._domainType.hour.row(d))+self.getWeekDay(d)*4}return Math.floor(d.getHours()/self._domainType.hour.row(d))},y:function(d){var p=d.getHours();if(self.options.colLimit>0||self.options.rowLimit>0){switch(self.options.domain){case"month":p+=(d.getDate()-1)*24;break;case"week":p+=self.getWeekDay(d)*24;break}}return Math.floor(p%self._domainType.hour.row(d))}},format:{date:"%Hh, %A %B %-e, %Y",legend:"%H:00",connector:"at"},extractUnit:function(d){return new Date(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours()).getTime()}},day:{name:"day",level:30,maxItemNumber:function(d){switch(self.options.domain){case"week":return 7;case"month":return self.options.domainDynamicDimension?self.getDayCountInMonth(d):31;case"year":return self.options.domainDynamicDimension?self.getDayCountInYear(d):366}},defaultColumnNumber:function(d){d=new Date(d);switch(self.options.domain){case"week":return 1;case"month":return self.options.domainDynamicDimension&&!self.options.verticalOrientation?self.getWeekNumber(new Date(d.getFullYear(),d.getMonth()+1,0))-self.getWeekNumber(d)+1:6;case"year":return self.options.domainDynamicDimension?self.getWeekNumber(new Date(d.getFullYear(),11,31))-self.getWeekNumber(new Date(d.getFullYear(),0))+1:54}},defaultRowNumber:7,row:function(d){return self.getSubDomainRowNumber(d)},column:function(d){return self.getSubDomainColumnNumber(d)},position:{x:function(d){switch(self.options.domain){case"week":return Math.floor(self.getWeekDay(d)/self._domainType.day.row(d));case"month":if(self.options.colLimit>0||self.options.rowLimit>0){return Math.floor((d.getDate()-1)/self._domainType.day.row(d))}return self.getWeekNumber(d)-self.getWeekNumber(new Date(d.getFullYear(),d.getMonth()));case"year":if(self.options.colLimit>0||self.options.rowLimit>0){return Math.floor((self.getDayOfYear(d)-1)/self._domainType.day.row(d))}return self.getWeekNumber(d)}},y:function(d){var p=self.getWeekDay(d);if(self.options.colLimit>0||self.options.rowLimit>0){switch(self.options.domain){case"year":p=self.getDayOfYear(d)-1;break;case"week":p=self.getWeekDay(d);break;case"month":p=d.getDate()-1;break}}return Math.floor(p%self._domainType.day.row(d))}},format:{date:"%A %B %-e, %Y",legend:"%e %b",connector:"on"},extractUnit:function(d){return new Date(d.getFullYear(),d.getMonth(),d.getDate()).getTime()}},week:{name:"week",level:40,maxItemNumber:54,defaultColumnNumber:function(d){d=new Date(d);switch(self.options.domain){case"year":return self._domainType.week.maxItemNumber;case"month":return self.getWeekNumber(new Date(d.getFullYear(),d.getMonth()+1,0))-self.getWeekNumber(d)}},defaultRowNumber:1,row:function(d){return self.getSubDomainRowNumber(d)},column:function(d){return self.getSubDomainColumnNumber(d)},position:{x:function(d){switch(self.options.domain){case"year":return Math.floor(self.getWeekNumber(d)/self._domainType.week.row(d));case"month":return Math.floor(self.getMonthWeekNumber(d)/self._domainType.week.row(d))}},y:function(d){return self.getWeekNumber(d)%self._domainType.week.row(d)}},format:{date:"%B Week #%W",legend:"%B Week #%W",connector:"on"},extractUnit:function(d){var dt=new Date(d.getFullYear(),d.getMonth(),d.getDate());var weekDay=dt.getDay()-1;if(weekDay<0){weekDay=6}dt.setDate(dt.getDate()-weekDay);return dt.getTime()}},month:{name:"month",level:50,maxItemNumber:12,defaultColumnNumber:12,defaultRowNumber:1,row:function(){return self.getSubDomainRowNumber()},column:function(){return self.getSubDomainColumnNumber()},position:{x:function(d){return Math.floor(d.getMonth()/self._domainType.month.row(d))},y:function(d){return d.getMonth()%self._domainType.month.row(d)}},format:{date:"%B %Y",legend:"%B",connector:"on"},extractUnit:function(d){return new Date(d.getFullYear(),d.getMonth()).getTime()}},year:{name:"year",level:60,row:function(){return self.options.rowLimit||1},column:function(){return self.options.colLimit||1},position:{x:function(){return 1},y:function(){return 1}},format:{date:"%Y",legend:"%Y",connector:"on"},extractUnit:function(d){return new Date(d.getFullYear()).getTime()}}};for(var type in this._domainType){if(this._domainType.hasOwnProperty(type)){var d=this._domainType[type];this._domainType["x_"+type]={name:"x_"+type,level:d.type,maxItemNumber:d.maxItemNumber,defaultRowNumber:d.defaultRowNumber,defaultColumnNumber:d.defaultColumnNumber,row:d.column,column:d.row,position:{x:d.position.y,y:d.position.x},format:d.format,extractUnit:d.extractUnit}}}this.lastInsertedSvg=null;this._completed=false;this._domains=d3.map();this.graphDim={width:0,height:0};this.legendDim={width:0,height:0};this.NAVIGATE_LEFT=1;this.NAVIGATE_RIGHT=2;this.RESET_ALL_ON_UPDATE=0;this.RESET_SINGLE_ON_UPDATE=1;this.APPEND_ON_UPDATE=2;this.DEFAULT_LEGEND_MARGIN=10;this.root=null;this.tooltip=null;this._maxDomainReached=false;this._minDomainReached=false;this.domainPosition=new DomainPosition;this.Legend=null;this.legendScale=null;this.DSTDomain=[];this._init=function(){self.getDomain(self.options.start).map(function(d){return d.getTime()}).map(function(d){self._domains.set(d,self.getSubDomain(d).map(function(d){return{t:self._domainType[self.options.subDomain].extractUnit(d),v:null}}))});self.root=d3.select(self.options.itemSelector).append("svg").attr("class","cal-heatmap-container");self.tooltip=d3.select(self.options.itemSelector).attr("style",function(){var current=d3.select(self.options.itemSelector).attr("style");return(current!==null?current:"")+"position:relative;"}).append("div").attr("class","ch-tooltip");self.root.attr("x",0).attr("y",0).append("svg").attr("class","graph");self.Legend=new Legend(self);if(self.options.paintOnLoad){_initCalendar()}return true};function _initCalendar(){self.verticalDomainLabel=self.options.label.position==="top"||self.options.label.position==="bottom";self.domainVerticalLabelHeight=self.options.label.height===null?Math.max(25,self.options.cellSize*2):self.options.label.height;self.domainHorizontalLabelWidth=0;if(self.options.domainLabelFormat===""&&self.options.label.height===null){self.domainVerticalLabelHeight=0}if(!self.verticalDomainLabel){self.domainVerticalLabelHeight=0;self.domainHorizontalLabelWidth=self.options.label.width}self.paint();if(self.options.nextSelector!==false){d3.select(self.options.nextSelector).on("click."+self.options.itemNamespace,function(){d3.event.preventDefault();return self.loadNextDomain(1)})}if(self.options.previousSelector!==false){d3.select(self.options.previousSelector).on("click."+self.options.itemNamespace,function(){d3.event.preventDefault();return self.loadPreviousDomain(1)})}self.Legend.redraw(self.graphDim.width-self.options.domainGutter-self.options.cellPadding);self.afterLoad();var domains=self.getDomainKeys();if(self.options.loadOnInit){self.getDatas(self.options.data,new Date(domains[0]),self.getSubDomain(domains[domains.length-1]).pop(),function(){self.fill();self.onComplete()})}else{self.onComplete()}self.checkIfMinDomainIsReached(domains[0]);self.checkIfMaxDomainIsReached(self.getNextDomain().getTime())}function w(d,outer){var width=self.options.cellSize*self._domainType[self.options.subDomain].column(d)+self.options.cellPadding*self._domainType[self.options.subDomain].column(d);if(arguments.length===2&&outer===true){return width+=self.domainHorizontalLabelWidth+self.options.domainGutter+self.options.domainMargin[1]+self.options.domainMargin[3]}return width}function h(d,outer){var height=self.options.cellSize*self._domainType[self.options.subDomain].row(d)+self.options.cellPadding*self._domainType[self.options.subDomain].row(d);if(arguments.length===2&&outer===true){height+=self.options.domainGutter+self.domainVerticalLabelHeight+self.options.domainMargin[0]+self.options.domainMargin[2]}return height}this.paint=function(navigationDir){var options=self.options;if(arguments.length===0){navigationDir=false}var domainSvg=self.root.select(".graph").selectAll(".graph-domain").data(function(){var data=self.getDomainKeys();return navigationDir===self.NAVIGATE_LEFT?data.reverse():data},function(d){return d});var enteringDomainDim=0;var exitingDomainDim=0;var svg=domainSvg.enter().append("svg").attr("width",function(d){return w(d,true)}).attr("height",function(d){return h(d,true)}).attr("x",function(d){if(options.verticalOrientation){self.graphDim.width=Math.max(self.graphDim.width,w(d,true));return 0}else{return getDomainPosition(d,self.graphDim,"width",w(d,true))}}).attr("y",function(d){if(options.verticalOrientation){return getDomainPosition(d,self.graphDim,"height",h(d,true))}else{self.graphDim.height=Math.max(self.graphDim.height,h(d,true));return 0}}).attr("class",function(d){var classname="graph-domain";var date=new Date(d);switch(options.domain){case"hour":classname+=" h_"+date.getHours();case"day":classname+=" d_"+date.getDate()+" dy_"+date.getDay();case"week":classname+=" w_"+self.getWeekNumber(date);case"month":classname+=" m_"+(date.getMonth()+1);case"year":classname+=" y_"+date.getFullYear()}return classname});self.lastInsertedSvg=svg;function getDomainPosition(domainIndex,graphDim,axis,domainDim){var tmp=0;switch(navigationDir){case false:tmp=graphDim[axis];graphDim[axis]+=domainDim;self.domainPosition.setPosition(domainIndex,tmp);return tmp;case self.NAVIGATE_RIGHT:self.domainPosition.setPosition(domainIndex,graphDim[axis]);enteringDomainDim=domainDim;exitingDomainDim=self.domainPosition.getPositionFromIndex(1);self.domainPosition.shiftRightBy(exitingDomainDim);return graphDim[axis];case self.NAVIGATE_LEFT:tmp=-domainDim;enteringDomainDim=-tmp;exitingDomainDim=graphDim[axis]-self.domainPosition.getLast();self.domainPosition.setPosition(domainIndex,tmp);self.domainPosition.shiftLeftBy(enteringDomainDim);return tmp}}svg.append("rect").attr("width",function(d){return w(d,true)-options.domainGutter-options.cellPadding}).attr("height",function(d){return h(d,true)-options.domainGutter-options.cellPadding}).attr("class","domain-background");var subDomainSvgGroup=svg.append("svg").attr("x",function(){if(options.label.position==="left"){return self.domainHorizontalLabelWidth+options.domainMargin[3]}else{return options.domainMargin[3]}}).attr("y",function(){if(options.label.position==="top"){return self.domainVerticalLabelHeight+options.domainMargin[0]}else{return options.domainMargin[0]}}).attr("class","graph-subdomain-group");var rect=subDomainSvgGroup.selectAll("g").data(function(d){return self._domains.get(d)}).enter().append("g");rect.append("rect").attr("class",function(d){return"graph-rect"+self.getHighlightClassName(d.t)+(options.onClick!==null?" hover_cursor":"")}).attr("width",options.cellSize).attr("height",options.cellSize).attr("x",function(d){return self.positionSubDomainX(d.t)}).attr("y",function(d){return self.positionSubDomainY(d.t)}).on("click",function(d){if(options.onClick!==null){return self.onClick(new Date(d.t),d.v)}}).call(function(selection){if(options.cellRadius>0){selection.attr("rx",options.cellRadius).attr("ry",options.cellRadius)}if(self.legendScale!==null&&options.legendColors!==null&&options.legendColors.hasOwnProperty("base")){selection.attr("fill",options.legendColors.base)}if(options.tooltip){selection.on("mouseover",function(d){var domainNode=this.parentNode.parentNode.parentNode;self.tooltip.html(self.getSubDomainTitle(d)).attr("style","display: block;");self.tooltip.attr("style","display: block; "+"left: "+(self.positionSubDomainX(d.t)-self.tooltip[0][0].offsetWidth/2+options.cellSize/2+parseInt(domainNode.getAttribute("x"),10))+"px; "+"top: "+(self.positionSubDomainY(d.t)-self.tooltip[0][0].offsetHeight-options.cellSize/2+parseInt(domainNode.getAttribute("y"),10))+"px;")});selection.on("mouseout",function(){self.tooltip.attr("style","display:none").html("")})}});if(!options.tooltip){rect.append("title").text(function(d){return self.formatDate(new Date(d.t),options.subDomainDateFormat)})}if(options.domainLabelFormat!==""){svg.append("text").attr("class","graph-label").attr("y",function(d){var y=options.domainMargin[0];switch(options.label.position){case"top":y+=self.domainVerticalLabelHeight/2;break;case"bottom":y+=h(d)+self.domainVerticalLabelHeight/2}return y+options.label.offset.y*(options.label.rotate==="right"&&options.label.position==="right"||options.label.rotate==="left"&&options.label.position==="left"?-1:1)}).attr("x",function(d){var x=options.domainMargin[3];switch(options.label.position){case"right":x+=w(d);break;case"bottom":case"top":x+=w(d)/2}if(options.label.align==="right"){return x+self.domainHorizontalLabelWidth-options.label.offset.x*(options.label.rotate==="right"?-1:1)}return x+options.label.offset.x}).attr("text-anchor",function(){switch(options.label.align){case"start":case"left":return"start";case"end":case"right":return"end";default:return"middle"}}).attr("dominant-baseline",function(){return self.verticalDomainLabel?"middle":"top"}).text(function(d){return self.formatDate(new Date(d),options.domainLabelFormat)}).call(domainRotate)}function domainRotate(selection){switch(options.label.rotate){case"right":selection.attr("transform",function(d){var s="rotate(90), ";switch(options.label.position){case"right":s+="translate(-"+w(d)+" , -"+w(d)+")";break;case"left":s+="translate(0, -"+self.domainHorizontalLabelWidth+")";break}return s});break;case"left":selection.attr("transform",function(d){var s="rotate(270), ";switch(options.label.position){case"right":s+="translate(-"+(w(d)+self.domainHorizontalLabelWidth)+" , "+w(d)+")";break;case"left":s+="translate(-"+self.domainHorizontalLabelWidth+" , "+self.domainHorizontalLabelWidth+")";break}return s});break}}if(options.subDomainTextFormat!==null){rect.append("text").attr("class",function(d){return"subdomain-text"+self.getHighlightClassName(d.t)}).attr("x",function(d){return self.positionSubDomainX(d.t)+options.cellSize/2}).attr("y",function(d){return self.positionSubDomainY(d.t)+options.cellSize/2}).attr("text-anchor","middle").attr("dominant-baseline","central").text(function(d){return self.formatDate(new Date(d.t),options.subDomainTextFormat)})}if(navigationDir!==false){domainSvg.transition().duration(options.animationDuration).attr("x",function(d){return options.verticalOrientation?0:self.domainPosition.getPosition(d)}).attr("y",function(d){return options.verticalOrientation?self.domainPosition.getPosition(d):0})}var tempWidth=self.graphDim.width;var tempHeight=self.graphDim.height;if(options.verticalOrientation){self.graphDim.height+=enteringDomainDim-exitingDomainDim}else{self.graphDim.width+=enteringDomainDim-exitingDomainDim}domainSvg.exit().transition().duration(options.animationDuration).attr("x",function(d){if(options.verticalOrientation){return 0}else{switch(navigationDir){case self.NAVIGATE_LEFT:return Math.min(self.graphDim.width,tempWidth);case self.NAVIGATE_RIGHT:return-w(d,true)}}}).attr("y",function(d){if(options.verticalOrientation){switch(navigationDir){case self.NAVIGATE_LEFT:return Math.min(self.graphDim.height,tempHeight);case self.NAVIGATE_RIGHT:return-h(d,true)}}else{return 0}}).remove();self.resize()}};CalHeatMap.prototype={init:function(settings){"use strict";var parent=this;var options=parent.options=mergeRecursive(parent.options,settings);validateDomainType();validateSelector(options.itemSelector,false,"itemSelector");if(parent.allowedDataType.indexOf(options.dataType)===-1){throw new Error("The data type '"+options.dataType+"' is not valid data type")}if(d3.select(options.itemSelector)[0][0]===null){throw new Error("The node '"+options.itemSelector+"' specified in itemSelector does not exists")}try{validateSelector(options.nextSelector,true,"nextSelector");validateSelector(options.previousSelector,true,"previousSelector")}catch(error){console.log(error.message);return false}if(!settings.hasOwnProperty("subDomain")){this.options.subDomain=getOptimalSubDomain(settings.domain)}if(typeof options.itemNamespace!=="string"||options.itemNamespace===""){console.log("itemNamespace can not be empty, falling back to cal-heatmap");options.itemNamespace="cal-heatmap"}var s=["data","onComplete","onClick","afterLoad","afterLoadData","afterLoadPreviousDomain","afterLoadNextDomain"];for(var k in s){if(settings.hasOwnProperty(s[k])){options[s[k]]=settings[s[k]]}}options.subDomainDateFormat=typeof options.subDomainDateFormat==="string"||typeof options.subDomainDateFormat==="function"?options.subDomainDateFormat:this._domainType[options.subDomain].format.date;
options.domainLabelFormat=typeof options.domainLabelFormat==="string"||typeof options.domainLabelFormat==="function"?options.domainLabelFormat:this._domainType[options.domain].format.legend;options.subDomainTextFormat=typeof options.subDomainTextFormat==="string"&&options.subDomainTextFormat!==""||typeof options.subDomainTextFormat==="function"?options.subDomainTextFormat:null;options.domainMargin=expandMarginSetting(options.domainMargin);options.legendMargin=expandMarginSetting(options.legendMargin);options.highlight=parent.expandDateSetting(options.highlight);options.itemName=expandItemName(options.itemName);options.colLimit=parseColLimit(options.colLimit);options.rowLimit=parseRowLimit(options.rowLimit);if(!settings.hasOwnProperty("legendMargin")){autoAddLegendMargin()}autoAlignLabel();function validateSelector(selector,canBeFalse,name){if((canBeFalse&&selector===false||selector instanceof Element||typeof selector==="string")&&selector!==""){return true}throw new Error("The "+name+" is not valid")}function getOptimalSubDomain(domain){switch(domain){case"year":return"month";case"month":return"day";case"week":return"day";case"day":return"hour";default:return"min"}}function validateDomainType(){if(!parent._domainType.hasOwnProperty(options.domain)||options.domain==="min"||options.domain.substring(0,2)==="x_"){throw new Error("The domain '"+options.domain+"' is not valid")}if(!parent._domainType.hasOwnProperty(options.subDomain)||options.subDomain==="year"){throw new Error("The subDomain '"+options.subDomain+"' is not valid")}if(parent._domainType[options.domain].level<=parent._domainType[options.subDomain].level){throw new Error("'"+options.subDomain+"' is not a valid subDomain to '"+options.domain+"'")}return true}function autoAlignLabel(){if(!settings.hasOwnProperty("label")||settings.hasOwnProperty("label")&&!settings.label.hasOwnProperty("align")){switch(options.label.position){case"left":options.label.align="right";break;case"right":options.label.align="left";break;default:options.label.align="center"}if(options.label.rotate==="left"){options.label.align="right"}else if(options.label.rotate==="right"){options.label.align="left"}}if(!settings.hasOwnProperty("label")||settings.hasOwnProperty("label")&&!settings.label.hasOwnProperty("offset")){if(options.label.position==="left"||options.label.position==="right"){options.label.offset={x:10,y:15}}}}function autoAddLegendMargin(){switch(options.legendVerticalPosition){case"top":options.legendMargin[2]=parent.DEFAULT_LEGEND_MARGIN;break;case"bottom":options.legendMargin[0]=parent.DEFAULT_LEGEND_MARGIN;break;case"middle":case"center":options.legendMargin[options.legendHorizontalPosition==="right"?3:1]=parent.DEFAULT_LEGEND_MARGIN}}function expandMarginSetting(value){if(typeof value==="number"){value=[value]}if(!Array.isArray(value)){console.log("Margin only takes an integer or an array of integers");value=[0]}switch(value.length){case 1:return[value[0],value[0],value[0],value[0]];case 2:return[value[0],value[1],value[0],value[1]];case 3:return[value[0],value[1],value[2],value[1]];case 4:return value;default:return value.slice(0,4)}}function expandItemName(value){if(typeof value==="string"){return[value,value+(value!==""?"s":"")]}if(Array.isArray(value)){if(value.length===1){return[value[0],value[0]+"s"]}else if(value.length>2){return value.slice(0,2)}return value}return["item","items"]}function parseColLimit(value){return value>0?value:null}function parseRowLimit(value){if(value>0&&options.colLimit>0){console.log("colLimit and rowLimit are mutually exclusive, rowLimit will be ignored");return null}return value>0?value:null}return this._init()},expandDateSetting:function(value){"use strict";if(!Array.isArray(value)){value=[value]}return value.map(function(data){if(data==="now"){return new Date}if(data instanceof Date){return data}return false}).filter(function(d){return d!==false})},fill:function(svg){"use strict";var parent=this;var options=parent.options;if(arguments.length===0){svg=parent.root.selectAll(".graph-domain")}var rect=svg.selectAll("svg").selectAll("g").data(function(d){return parent._domains.get(d)});function addStyle(element){if(parent.legendScale===null){return false}element.attr("fill",function(d){if(d.v===0&&options.legendColors!==null&&options.legendColors.hasOwnProperty("empty")){return options.legendColors.empty}if(d.v<0&&options.legend[0]>0&&options.legendColors!==null&&options.legendColors.hasOwnProperty("overflow")){return options.legendColors.overflow}return parent.legendScale(Math.min(d.v,options.legend[options.legend.length-1]))})}rect.transition().duration(options.animationDuration).select("rect").attr("class",function(d){var htmlClass=parent.getHighlightClassName(d.t);if(parent.legendScale===null){htmlClass+=" graph-rect"}if(d.v!==null){htmlClass+=" "+parent.Legend.getClass(d.v,parent.legendScale===null)}else if(options.considerMissingDataAsZero&&parent.dateIsLessThan(d.t,new Date)){htmlClass+=" "+parent.Legend.getClass(0,parent.legendScale===null)}if(options.onClick!==null){htmlClass+=" hover_cursor"}return htmlClass}).call(addStyle);rect.transition().duration(options.animationDuration).select("title").text(function(d){return parent.getSubDomainTitle(d)})},triggerEvent:function(eventName,successArgs,skip){"use strict";if(arguments.length===3&&skip||this.options[eventName]===null){return true}if(typeof this.options[eventName]==="function"){if(typeof successArgs==="function"){successArgs=successArgs()}return this.options[eventName].apply(this,successArgs)}else{console.log("Provided callback for "+eventName+" is not a function.");return false}},onClick:function(d,itemNb){"use strict";return this.triggerEvent("onClick",[d,itemNb])},afterLoad:function(){"use strict";return this.triggerEvent("afterLoad")},onComplete:function(){"use strict";var response=this.triggerEvent("onComplete",[],this._completed);this._completed=true;return response},afterLoadPreviousDomain:function(start){"use strict";var parent=this;return this.triggerEvent("afterLoadPreviousDomain",function(){var subDomain=parent.getSubDomain(start);return[subDomain.shift(),subDomain.pop()]})},afterLoadNextDomain:function(start){"use strict";var parent=this;return this.triggerEvent("afterLoadNextDomain",function(){var subDomain=parent.getSubDomain(start);return[subDomain.shift(),subDomain.pop()]})},onMinDomainReached:function(reached){"use strict";this._minDomainReached=reached;return this.triggerEvent("onMinDomainReached",[reached])},onMaxDomainReached:function(reached){"use strict";this._maxDomainReached=reached;return this.triggerEvent("onMaxDomainReached",[reached])},checkIfMinDomainIsReached:function(date,upperBound){"use strict";if(this.minDomainIsReached(date)){this.onMinDomainReached(true)}if(arguments.length===2){if(this._maxDomainReached&&!this.maxDomainIsReached(upperBound)){this.onMaxDomainReached(false)}}},checkIfMaxDomainIsReached:function(date,lowerBound){"use strict";if(this.maxDomainIsReached(date)){this.onMaxDomainReached(true)}if(arguments.length===2){if(this._minDomainReached&&!this.minDomainIsReached(lowerBound)){this.onMinDomainReached(false)}}},formatNumber:d3.format(",g"),formatDate:function(d,format){"use strict";if(arguments.length<2){format="title"}if(typeof format==="function"){return format(d)}else{var f=d3.time.format(format);return f(d)}},getSubDomainTitle:function(d){"use strict";if(d.v===null&&!this.options.considerMissingDataAsZero){return this.options.subDomainTitleFormat.empty.format({date:this.formatDate(new Date(d.t),this.options.subDomainDateFormat)})}else{var value=d.v;if(value===null&&this.options.considerMissingDataAsZero){value=0}return this.options.subDomainTitleFormat.filled.format({count:this.formatNumber(value),name:this.options.itemName[value!==1?1:0],connector:this._domainType[this.options.subDomain].format.connector,date:this.formatDate(new Date(d.t),this.options.subDomainDateFormat)})}},loadNextDomain:function(n){"use strict";if(this._maxDomainReached||n===0){return false}var bound=this.loadNewDomains(this.NAVIGATE_RIGHT,this.getDomain(this.getNextDomain(),n));this.afterLoadNextDomain(bound.end);this.checkIfMaxDomainIsReached(this.getNextDomain().getTime(),bound.start);return true},loadPreviousDomain:function(n){"use strict";if(this._minDomainReached||n===0){return false}var bound=this.loadNewDomains(this.NAVIGATE_LEFT,this.getDomain(this.getDomainKeys()[0],-n).reverse());this.afterLoadPreviousDomain(bound.start);this.checkIfMinDomainIsReached(bound.start,bound.end);return true},loadNewDomains:function(direction,newDomains){"use strict";var parent=this;var backward=direction===this.NAVIGATE_LEFT;var i=-1;var total=newDomains.length;var domains=this.getDomainKeys();function buildSubDomain(d){return{t:parent._domainType[parent.options.subDomain].extractUnit(d),v:null}}while(++i<total){if(backward&&this.minDomainIsReached(newDomains[i])){newDomains=newDomains.slice(0,i+1);break}if(!backward&&this.maxDomainIsReached(newDomains[i])){newDomains=newDomains.slice(0,i);break}}newDomains=newDomains.slice(-this.options.range);for(i=0,total=newDomains.length;i<total;i++){this._domains.set(newDomains[i].getTime(),this.getSubDomain(newDomains[i]).map(buildSubDomain));this._domains.remove(backward?domains.pop():domains.shift())}domains=this.getDomainKeys();if(backward){newDomains=newDomains.reverse()}this.paint(direction);this.getDatas(this.options.data,newDomains[0],this.getSubDomain(newDomains[newDomains.length-1]).pop(),function(){parent.fill(parent.lastInsertedSvg)});return{start:newDomains[backward?0:1],end:domains[domains.length-1]}},maxDomainIsReached:function(datetimestamp){"use strict";return this.options.maxDate!==null&&this.options.maxDate.getTime()<datetimestamp},minDomainIsReached:function(datetimestamp){"use strict";return this.options.minDate!==null&&this.options.minDate.getTime()>=datetimestamp},getDomainKeys:function(){"use strict";return this._domains.keys().map(function(d){return parseInt(d,10)}).sort(function(a,b){return a-b})},positionSubDomainX:function(d){"use strict";var index=this._domainType[this.options.subDomain].position.x(new Date(d));return index*this.options.cellSize+index*this.options.cellPadding},positionSubDomainY:function(d){"use strict";var index=this._domainType[this.options.subDomain].position.y(new Date(d));return index*this.options.cellSize+index*this.options.cellPadding},getSubDomainColumnNumber:function(d){"use strict";if(this.options.rowLimit>0){var i=this._domainType[this.options.subDomain].maxItemNumber;if(typeof i==="function"){i=i(d)}return Math.ceil(i/this.options.rowLimit)}var j=this._domainType[this.options.subDomain].defaultColumnNumber;if(typeof j==="function"){j=j(d)}return this.options.colLimit||j},getSubDomainRowNumber:function(d){"use strict";if(this.options.colLimit>0){var i=this._domainType[this.options.subDomain].maxItemNumber;if(typeof i==="function"){i=i(d)}return Math.ceil(i/this.options.colLimit)}var j=this._domainType[this.options.subDomain].defaultRowNumber;if(typeof j==="function"){j=j(d)}return this.options.rowLimit||j},getHighlightClassName:function(d){"use strict";d=new Date(d);if(this.options.highlight.length>0){for(var i in this.options.highlight){if(this.options.highlight[i]instanceof Date&&this.dateIsEqual(this.options.highlight[i],d)){return" highlight"+(this.isNow(this.options.highlight[i])?" now":"")}}}return""},isNow:function(d){"use strict";return this.dateIsEqual(d,new Date)},dateIsEqual:function(dateA,dateB){"use strict";switch(this.options.subDomain){case"x_min":case"min":return dateA.getFullYear()===dateB.getFullYear()&&dateA.getMonth()===dateB.getMonth()&&dateA.getDate()===dateB.getDate()&&dateA.getHours()===dateB.getHours()&&dateA.getMinutes()===dateB.getMinutes();case"x_hour":case"hour":return dateA.getFullYear()===dateB.getFullYear()&&dateA.getMonth()===dateB.getMonth()&&dateA.getDate()===dateB.getDate()&&dateA.getHours()===dateB.getHours();case"x_day":case"day":return dateA.getFullYear()===dateB.getFullYear()&&dateA.getMonth()===dateB.getMonth()&&dateA.getDate()===dateB.getDate();case"x_week":case"week":case"x_month":case"month":return dateA.getFullYear()===dateB.getFullYear()&&dateA.getMonth()===dateB.getMonth();default:return false}},dateIsLessThan:function(dateA,dateB){"use strict";if(!(dateA instanceof Date)){dateA=new Date(dateA)}if(!(dateB instanceof Date)){dateB=new Date(dateB)}function normalizedMillis(date,subdomain){switch(subdomain){case"x_min":case"min":return new Date(date.getFullYear(),date.getMonth(),date.getDate(),date.getHours(),date.getMinutes()).getTime();case"x_hour":case"hour":return new Date(date.getFullYear(),date.getMonth(),date.getDate(),date.getHours()).getTime();case"x_day":case"day":return new Date(date.getFullYear(),date.getMonth(),date.getDate()).getTime();case"x_week":case"week":case"x_month":case"month":return new Date(date.getFullYear(),date.getMonth()).getTime();default:return date.getTime()}}return normalizedMillis(dateA,this.options.subDomain)<normalizedMillis(dateB,this.options.subDomain)},getDayOfYear:d3.time.format("%j"),getWeekNumber:function(d){"use strict";var f=this.options.weekStartOnMonday===true?d3.time.format("%W"):d3.time.format("%U");return f(d)},getMonthWeekNumber:function(d){"use strict";if(typeof d==="number"){d=new Date(d)}var monthFirstWeekNumber=this.getWeekNumber(new Date(d.getFullYear(),d.getMonth()));return this.getWeekNumber(d)-monthFirstWeekNumber-1},getWeekNumberInYear:function(d){"use strict";if(typeof d==="number"){d=new Date(d)}},getDayCountInMonth:function(d){"use strict";return this.getEndOfMonth(d).getDate()},getDayCountInYear:function(d){"use strict";if(typeof d==="number"){d=new Date(d)}return new Date(d.getFullYear(),1,29).getMonth()===1?366:365},getWeekDay:function(d){"use strict";if(this.options.weekStartOnMonday===false){return d.getDay()}return d.getDay()===0?6:d.getDay()-1},getEndOfMonth:function(d){"use strict";if(typeof d==="number"){d=new Date(d)}return new Date(d.getFullYear(),d.getMonth()+1,0)},jumpDate:function(date,count,step){"use strict";var d=new Date(date);switch(step){case"hour":d.setHours(d.getHours()+count);break;case"day":d.setHours(d.getHours()+count*24);break;case"week":d.setHours(d.getHours()+count*24*7);break;case"month":d.setMonth(d.getMonth()+count);break;case"year":d.setFullYear(d.getFullYear()+count)}return new Date(d)},getMinuteDomain:function(d,range){"use strict";var start=new Date(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours());var stop=null;if(range instanceof Date){stop=new Date(range.getFullYear(),range.getMonth(),range.getDate(),range.getHours())}else{stop=new Date(+start+range*1e3*60)}return d3.time.minutes(Math.min(start,stop),Math.max(start,stop))},getHourDomain:function(d,range){"use strict";var start=new Date(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours());var stop=null;if(range instanceof Date){stop=new Date(range.getFullYear(),range.getMonth(),range.getDate(),range.getHours())}else{stop=new Date(start);stop.setHours(stop.getHours()+range)}var domains=d3.time.hours(Math.min(start,stop),Math.max(start,stop));var i=0;var total=domains.length;for(i=0;i<total;i++){if(i>0&&domains[i].getHours()===domains[i-1].getHours()){this.DSTDomain.push(domains[i].getTime());domains.splice(i,1);break}}if(typeof range==="number"&&domains.length>Math.abs(range)){domains.splice(domains.length-1,1)}return domains},getDayDomain:function(d,range){"use strict";var start=new Date(d.getFullYear(),d.getMonth(),d.getDate());var stop=null;if(range instanceof Date){stop=new Date(range.getFullYear(),range.getMonth(),range.getDate())}else{stop=new Date(start);stop=new Date(stop.setDate(stop.getDate()+parseInt(range,10)))}return d3.time.days(Math.min(start,stop),Math.max(start,stop))},getWeekDomain:function(d,range){"use strict";var weekStart;if(this.options.weekStartOnMonday===false){weekStart=new Date(d.getFullYear(),d.getMonth(),d.getDate()-d.getDay())}else{if(d.getDay()===1){weekStart=new Date(d.getFullYear(),d.getMonth(),d.getDate())}else if(d.getDay()===0){weekStart=new Date(d.getFullYear(),d.getMonth(),d.getDate());weekStart.setDate(weekStart.getDate()-6)}else{weekStart=new Date(d.getFullYear(),d.getMonth(),d.getDate()-d.getDay()+1)}}var endDate=new Date(weekStart);var stop=range;if(typeof range!=="object"){stop=new Date(endDate.setDate(endDate.getDate()+range*7))}return this.options.weekStartOnMonday===true?d3.time.mondays(Math.min(weekStart,stop),Math.max(weekStart,stop)):d3.time.sundays(Math.min(weekStart,stop),Math.max(weekStart,stop))},getMonthDomain:function(d,range){"use strict";var start=new Date(d.getFullYear(),d.getMonth());var stop=null;if(range instanceof Date){stop=new Date(range.getFullYear(),range.getMonth())}else{stop=new Date(start);stop=stop.setMonth(stop.getMonth()+range)}return d3.time.months(Math.min(start,stop),Math.max(start,stop))},getYearDomain:function(d,range){"use strict";var start=new Date(d.getFullYear(),0);var stop=null;if(range instanceof Date){stop=new Date(range.getFullYear(),0)}else{stop=new Date(d.getFullYear()+range,0)}return d3.time.years(Math.min(start,stop),Math.max(start,stop))},getDomain:function(date,range){"use strict";if(typeof date==="number"){date=new Date(date)}if(arguments.length<2){range=this.options.range}switch(this.options.domain){case"hour":var domains=this.getHourDomain(date,range);if(typeof range==="number"&&domains.length<range){if(range>0){domains.push(this.getHourDomain(domains[domains.length-1],2)[1])}else{domains.shift(this.getHourDomain(domains[0],-2)[0])}}return domains;case"day":return this.getDayDomain(date,range);case"week":return this.getWeekDomain(date,range);case"month":return this.getMonthDomain(date,range);case"year":return this.getYearDomain(date,range)}},getSubDomain:function(date){"use strict";if(typeof date==="number"){date=new Date(date)}var parent=this;var computeDaySubDomainSize=function(date,domain){switch(domain){case"year":return parent.getDayCountInYear(date);case"month":return parent.getDayCountInMonth(date);case"week":return 7}};var computeMinSubDomainSize=function(date,domain){switch(domain){case"hour":return 60;case"day":return 60*24;case"week":return 60*24*7}};var computeHourSubDomainSize=function(date,domain){switch(domain){case"day":return 24;case"week":return 168;case"month":return parent.getDayCountInMonth(date)*24}};var computeWeekSubDomainSize=function(date,domain){if(domain==="month"){var endOfMonth=new Date(date.getFullYear(),date.getMonth()+1,0);var endWeekNb=parent.getWeekNumber(endOfMonth);var startWeekNb=parent.getWeekNumber(new Date(date.getFullYear(),date.getMonth()));if(startWeekNb>endWeekNb){startWeekNb=0;endWeekNb++}return endWeekNb-startWeekNb+1}else if(domain==="year"){return parent.getWeekNumber(new Date(date.getFullYear(),11,31))}};switch(this.options.subDomain){case"x_min":case"min":return this.getMinuteDomain(date,computeMinSubDomainSize(date,this.options.domain));case"x_hour":case"hour":return this.getHourDomain(date,computeHourSubDomainSize(date,this.options.domain));case"x_day":case"day":return this.getDayDomain(date,computeDaySubDomainSize(date,this.options.domain));case"x_week":case"week":return this.getWeekDomain(date,computeWeekSubDomainSize(date,this.options.domain));case"x_month":case"month":return this.getMonthDomain(date,12)}},getNextDomain:function(n){"use strict";if(arguments.length===0){n=1}return this.getDomain(this.jumpDate(this.getDomainKeys().pop(),n,this.options.domain),1)[0]},getPreviousDomain:function(n){"use strict";if(arguments.length===0){n=1}return this.getDomain(this.jumpDate(this.getDomainKeys().shift(),-n,this.options.domain),1)[0]},getDatas:function(source,startDate,endDate,callback,afterLoad,updateMode){"use strict";var self=this;if(arguments.length<5){afterLoad=true}if(arguments.length<6){updateMode=this.APPEND_ON_UPDATE}var _callback=function(data){if(afterLoad!==false){if(typeof afterLoad==="function"){data=afterLoad(data)}else if(typeof self.options.afterLoadData==="function"){data=self.options.afterLoadData(data)}else{console.log("Provided callback for afterLoadData is not a function.")}}else if(self.options.dataType==="csv"||self.options.dataType==="tsv"){data=this.interpretCSV(data)}self.parseDatas(data,updateMode,startDate,endDate);if(typeof callback==="function"){callback()}};switch(typeof source){case"string":if(source===""){_callback({});return true}else{switch(this.options.dataType){case"json":d3.json(this.parseURI(source,startDate,endDate),_callback);break;case"csv":d3.csv(this.parseURI(source,startDate,endDate),_callback);break;case"tsv":d3.tsv(this.parseURI(source,startDate,endDate),_callback);break;case"txt":d3.text(this.parseURI(source,startDate,endDate),"text/plain",_callback);break}}return false;case"object":if(source===Object(source)){_callback(source);return false}default:_callback({});return true}},parseDatas:function(data,updateMode,startDate,endDate){"use strict";if(updateMode===this.RESET_ALL_ON_UPDATE){this._domains.forEach(function(key,value){value.forEach(function(element,index,array){array[index].v=null})})}var temp={};var extractTime=function(d){return d.t};for(var d in data){var date=new Date(d*1e3);var domainUnit=this.getDomain(date)[0].getTime();if(this.DSTDomain.indexOf(domainUnit)>=0){if(this._domains.has(domainUnit-3600*1e3)){domainUnit-=3600*1e3}}if(isNaN(d)||!data.hasOwnProperty(d)||!this._domains.has(domainUnit)||!(domainUnit>=+startDate&&domainUnit<+endDate)){continue}var subDomainsData=this._domains.get(domainUnit);if(!temp.hasOwnProperty(domainUnit)){temp[domainUnit]=subDomainsData.map(extractTime)}var index=temp[domainUnit].indexOf(this._domainType[this.options.subDomain].extractUnit(date));if(updateMode===this.RESET_SINGLE_ON_UPDATE){subDomainsData[index].v=data[d]}else{if(!isNaN(subDomainsData[index].v)){subDomainsData[index].v+=data[d]}else{subDomainsData[index].v=data[d]}}}},parseURI:function(str,startDate,endDate){"use strict";str=str.replace(/\{\{t:start\}\}/g,startDate.getTime()/1e3);str=str.replace(/\{\{t:end\}\}/g,endDate.getTime()/1e3);str=str.replace(/\{\{d:start\}\}/g,startDate.toISOString());str=str.replace(/\{\{d:end\}\}/g,endDate.toISOString());return str},interpretCSV:function(data){"use strict";var d={};var keys=Object.keys(data[0]);var i,total;for(i=0,total=data.length;i<total;i++){d[data[i][keys[0]]]=+data[i][keys[1]]}return d},resize:function(){"use strict";var parent=this;var options=parent.options;var legendWidth=options.displayLegend?parent.Legend.getDim("width")+options.legendMargin[1]+options.legendMargin[3]:0;var legendHeight=options.displayLegend?parent.Legend.getDim("height")+options.legendMargin[0]+options.legendMargin[2]:0;var graphWidth=parent.graphDim.width-options.domainGutter-options.cellPadding;var graphHeight=parent.graphDim.height-options.domainGutter-options.cellPadding;this.root.transition().duration(options.animationDuration).attr("width",function(){if(options.legendVerticalPosition==="middle"||options.legendVerticalPosition==="center"){return graphWidth+legendWidth}return Math.max(graphWidth,legendWidth)}).attr("height",function(){if(options.legendVerticalPosition==="middle"||options.legendVerticalPosition==="center"){return Math.max(graphHeight,legendHeight)}return graphHeight+legendHeight});this.root.select(".graph").transition().duration(options.animationDuration).attr("y",function(){if(options.legendVerticalPosition==="top"){return legendHeight}return 0}).attr("x",function(){if((options.legendVerticalPosition==="middle"||options.legendVerticalPosition==="center")&&options.legendHorizontalPosition==="left"){return legendWidth}return 0})},next:function(n){"use strict";if(arguments.length===0){n=1}return this.loadNextDomain(n)},previous:function(n){"use strict";if(arguments.length===0){n=1}return this.loadPreviousDomain(n)},jumpTo:function(date,reset){"use strict";if(arguments.length<2){reset=false}var domains=this.getDomainKeys();var firstDomain=domains[0];var lastDomain=domains[domains.length-1];if(date<firstDomain){return this.loadPreviousDomain(this.getDomain(firstDomain,date).length)}else{if(reset){return this.loadNextDomain(this.getDomain(firstDomain,date).length)}if(date>lastDomain){return this.loadNextDomain(this.getDomain(lastDomain,date).length)}}return false},rewind:function(){"use strict";this.jumpTo(this.options.start,true)},update:function(dataSource,afterLoad,updateMode){"use strict";if(arguments.length<2){afterLoad=true}if(arguments.length<3){updateMode=this.RESET_ALL_ON_UPDATE}var domains=this.getDomainKeys();var self=this;this.getDatas(dataSource,new Date(domains[0]),this.getSubDomain(domains[domains.length-1]).pop(),function(){self.fill()},afterLoad,updateMode)},setLegend:function(){"use strict";var oldLegend=this.options.legend.slice(0);if(arguments.length>=1&&Array.isArray(arguments[0])){this.options.legend=arguments[0]}if(arguments.length>=2){if(Array.isArray(arguments[1])&&arguments[1].length>=2){this.options.legendColors=[arguments[1][0],arguments[1][1]]}else{this.options.legendColors=arguments[1]}}if(arguments.length>0&&!arrayEquals(oldLegend,this.options.legend)||arguments.length>=2){this.Legend.buildColors();this.fill()}this.Legend.redraw(this.graphDim.width-this.options.domainGutter-this.options.cellPadding)},removeLegend:function(){"use strict";if(!this.options.displayLegend){return false}this.options.displayLegend=false;this.Legend.remove();return true},showLegend:function(){"use strict";if(this.options.displayLegend){return false}this.options.displayLegend=true;this.Legend.redraw(this.graphDim.width-this.options.domainGutter-this.options.cellPadding);return true},highlight:function(args){"use strict";if((this.options.highlight=this.expandDateSetting(args)).length>0){this.fill();return true}return false},destroy:function(callback){"use strict";this.root.transition().duration(this.options.animationDuration).attr("width",0).attr("height",0).remove().each("end",function(){if(typeof callback==="function"){callback()}else if(arguments.length>0){console.log("Provided callback for destroy() is not a function.")}});return null},getSVG:function(){"use strict";var styles={".cal-heatmap-container":{},".graph":{},".graph-rect":{},"rect.highlight":{},"rect.now":{},"text.highlight":{},"text.now":{},".domain-background":{},".graph-label":{},".subdomain-text":{},".q0":{},".qi":{}};for(var j=1,total=this.options.legend.length+1;j<=total;j++){styles[".q"+j]={}}var root=this.root;var whitelistStyles=["stroke","stroke-width","stroke-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-miterlimit","fill","fill-opacity","fill-rule","marker","marker-start","marker-mid","marker-end","alignement-baseline","baseline-shift","dominant-baseline","glyph-orientation-horizontal","glyph-orientation-vertical","kerning","text-anchor","shape-rendering","text-transform","font-family","font","font-size","font-weight"];var filterStyles=function(attribute,property,value){if(whitelistStyles.indexOf(property)!==-1){styles[attribute][property]=value}};var getElement=function(e){return root.select(e)[0][0]};for(var element in styles){if(!styles.hasOwnProperty(element)){continue}var dom=getElement(element);if(dom===null){continue}if("getComputedStyle"in window){var cs=getComputedStyle(dom,null);if(cs.length!==0){for(var i=0;i<cs.length;i++){filterStyles(element,cs.item(i),cs.getPropertyValue(cs.item(i)))}}else{for(var k in cs){if(cs.hasOwnProperty(k)){filterStyles(element,k,cs[k])}}}}else if("currentStyle"in dom){var css=dom.currentStyle;for(var p in css){filterStyles(element,p,css[p])}}}var string='<svg xmlns="http://www.w3.org/2000/svg" '+'xmlns:xlink="http://www.w3.org/1999/xlink"><style type="text/css"><![CDATA[ ';for(var style in styles){string+=style+" {\n";for(var l in styles[style]){string+="	"+l+":"+styles[style][l]+";\n"}string+="}\n"}string+="]]></style>";string+=(new XMLSerializer).serializeToString(this.root[0][0]);string+="</svg>";return string}};var DomainPosition=function(){"use strict";this.positions=d3.map()};DomainPosition.prototype.getPosition=function(d){"use strict";return this.positions.get(d)};DomainPosition.prototype.getPositionFromIndex=function(i){"use strict";var domains=this.getKeys();return this.positions.get(domains[i])};DomainPosition.prototype.getLast=function(){"use strict";var domains=this.getKeys();return this.positions.get(domains[domains.length-1])};DomainPosition.prototype.setPosition=function(d,dim){"use strict";this.positions.set(d,dim)};DomainPosition.prototype.shiftRightBy=function(exitingDomainDim){"use strict";this.positions.forEach(function(key,value){this.set(key,value-exitingDomainDim)});var domains=this.getKeys();this.positions.remove(domains[0])};DomainPosition.prototype.shiftLeftBy=function(enteringDomainDim){"use strict";this.positions.forEach(function(key,value){this.set(key,value+enteringDomainDim)});var domains=this.getKeys();this.positions.remove(domains[domains.length-1])};DomainPosition.prototype.getKeys=function(){"use strict";return this.positions.keys().sort(function(a,b){return parseInt(a,10)-parseInt(b,10)})};var Legend=function(calendar){"use strict";this.calendar=calendar;this.computeDim();if(calendar.options.legendColors!==null){this.buildColors()}};Legend.prototype.computeDim=function(){"use strict";var options=this.calendar.options;this.dim={width:options.legendCellSize*(options.legend.length+1)+options.legendCellPadding*options.legend.length,height:options.legendCellSize}};Legend.prototype.remove=function(){"use strict";this.calendar.root.select(".graph-legend").remove();this.calendar.resize()};Legend.prototype.redraw=function(width){"use strict";if(!this.calendar.options.displayLegend){return false}var parent=this;var calendar=this.calendar;var legend=calendar.root;var legendItem;var options=calendar.options;this.computeDim();var _legend=options.legend.slice(0);_legend.push(_legend[_legend.length-1]+1);var legendElement=calendar.root.select(".graph-legend");if(legendElement[0][0]!==null){legend=legendElement;legendItem=legend.select("g").selectAll("rect").data(_legend)}else{legend=options.legendVerticalPosition==="top"?legend.insert("svg",".graph"):legend.append("svg");legend.attr("x",getLegendXPosition()).attr("y",getLegendYPosition());legendItem=legend.attr("class","graph-legend").attr("height",parent.getDim("height")).attr("width",parent.getDim("width")).append("g").selectAll().data(_legend)}legendItem.enter().append("rect").call(legendCellLayout).attr("class",function(d){return calendar.Legend.getClass(d,calendar.legendScale===null)}).attr("fill-opacity",0).call(function(selection){if(calendar.legendScale!==null&&options.legendColors!==null&&options.legendColors.hasOwnProperty("base")){selection.attr("fill",options.legendColors.base)}}).append("title");legendItem.exit().transition().duration(options.animationDuration).attr("fill-opacity",0).remove();legendItem.transition().delay(function(d,i){return options.animationDuration*i/10}).call(legendCellLayout).attr("fill-opacity",1).call(function(element){element.attr("fill",function(d,i){if(calendar.legendScale===null){return""}if(i===0){return calendar.legendScale(d-1)}return calendar.legendScale(options.legend[i-1])});element.attr("class",function(d){return calendar.Legend.getClass(d,calendar.legendScale===null)})});function legendCellLayout(selection){selection.attr("width",options.legendCellSize).attr("height",options.legendCellSize).attr("x",function(d,i){return i*(options.legendCellSize+options.legendCellPadding)})}legendItem.select("title").text(function(d,i){if(i===0){return options.legendTitleFormat.lower.format({min:options.legend[i],name:options.itemName[1]})}else if(i===_legend.length-1){return options.legendTitleFormat.upper.format({max:options.legend[i-1],name:options.itemName[1]})}else{return options.legendTitleFormat.inner.format({down:options.legend[i-1],up:options.legend[i],name:options.itemName[1]})}});legend.transition().duration(options.animationDuration).attr("x",getLegendXPosition()).attr("y",getLegendYPosition()).attr("width",parent.getDim("width")).attr("height",parent.getDim("height"));
legend.select("g").transition().duration(options.animationDuration).attr("transform",function(){if(options.legendOrientation==="vertical"){return"rotate(90 "+options.legendCellSize/2+" "+options.legendCellSize/2+")"}return""});function getLegendXPosition(){switch(options.legendHorizontalPosition){case"right":if(options.legendVerticalPosition==="center"||options.legendVerticalPosition==="middle"){return width+options.legendMargin[3]}return width-parent.getDim("width")-options.legendMargin[1];case"middle":case"center":return Math.round(width/2-parent.getDim("width")/2);default:return options.legendMargin[3]}}function getLegendYPosition(){if(options.legendVerticalPosition==="bottom"){return calendar.graphDim.height+options.legendMargin[0]-options.domainGutter-options.cellPadding}return options.legendMargin[0]}calendar.resize()};Legend.prototype.getDim=function(axis){"use strict";var isHorizontal=this.calendar.options.legendOrientation==="horizontal";switch(axis){case"width":return this.dim[isHorizontal?"width":"height"];case"height":return this.dim[isHorizontal?"height":"width"]}};Legend.prototype.buildColors=function(){"use strict";var options=this.calendar.options;if(options.legendColors===null){this.calendar.legendScale=null;return false}var _colorRange=[];if(Array.isArray(options.legendColors)){_colorRange=options.legendColors}else if(options.legendColors.hasOwnProperty("min")&&options.legendColors.hasOwnProperty("max")){_colorRange=[options.legendColors.min,options.legendColors.max]}else{options.legendColors=null;return false}var _legend=options.legend.slice(0);if(_legend[0]>0){_legend.unshift(0)}else if(_legend[0]<0){_legend.unshift(_legend[0]-(_legend[_legend.length-1]-_legend[0])/_legend.length)}var colorScale=d3.scale.linear().range(_colorRange).interpolate(d3.interpolateHcl).domain([d3.min(_legend),d3.max(_legend)]);var legendColors=_legend.map(function(element){return colorScale(element)});this.calendar.legendScale=d3.scale.threshold().domain(options.legend).range(legendColors);return true};Legend.prototype.getClass=function(n,withCssClass){"use strict";if(n===null||isNaN(n)){return""}var index=[this.calendar.options.legend.length+1];for(var i=0,total=this.calendar.options.legend.length-1;i<=total;i++){if(this.calendar.options.legend[0]>0&&n<0){index=["1","i"];break}if(n<=this.calendar.options.legend[i]){index=[i+1];break}}if(n===0){index.push(0)}index.unshift("");return(index.join(" r")+(withCssClass?index.join(" q"):"")).trim()};String.prototype.format=function(){"use strict";var formatted=this;for(var prop in arguments[0]){if(arguments[0].hasOwnProperty(prop)){var regexp=new RegExp("\\{"+prop+"\\}","gi");formatted=formatted.replace(regexp,arguments[0][prop])}}return formatted};function mergeRecursive(obj1,obj2){"use strict";for(var p in obj2){try{if(obj2[p].constructor===Object){obj1[p]=mergeRecursive(obj1[p],obj2[p])}else{obj1[p]=obj2[p]}}catch(e){obj1[p]=obj2[p]}}return obj1}function arrayEquals(arrayA,arrayB){"use strict";if(!arrayB||!arrayA){return false}if(arrayA.length!==arrayB.length){return false}for(var i=0;i<arrayA.length;i++){if(arrayA[i]instanceof Array&&arrayB[i]instanceof Array){if(!arrayEquals(arrayA[i],arrayB[i])){return false}}else if(arrayA[i]!==arrayB[i]){return false}}return true}if(typeof define==="function"&&define.amd){define(["d3"],function(){"use strict";return CalHeatMap})}(function(){var nv={};nv.dev=false;nv.tooltip=nv.tooltip||{};nv.utils=nv.utils||{};nv.models=nv.models||{};nv.charts={};nv.logs={};nv.dom={};if(typeof module!=="undefined"&&typeof exports!=="undefined"&&typeof d3=="undefined"){d3=require("d3")}nv.dispatch=d3.dispatch("render_start","render_end");if(!Function.prototype.bind){Function.prototype.bind=function(oThis){if(typeof this!=="function"){throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable")}var aArgs=Array.prototype.slice.call(arguments,1),fToBind=this,fNOP=function(){},fBound=function(){return fToBind.apply(this instanceof fNOP&&oThis?this:oThis,aArgs.concat(Array.prototype.slice.call(arguments)))};fNOP.prototype=this.prototype;fBound.prototype=new fNOP;return fBound}}if(nv.dev){nv.dispatch.on("render_start",function(e){nv.logs.startTime=+new Date});nv.dispatch.on("render_end",function(e){nv.logs.endTime=+new Date;nv.logs.totalTime=nv.logs.endTime-nv.logs.startTime;nv.log("total",nv.logs.totalTime)})}nv.log=function(){if(nv.dev&&window.console&&console.log&&console.log.apply)console.log.apply(console,arguments);else if(nv.dev&&window.console&&typeof console.log=="function"&&Function.prototype.bind){var log=Function.prototype.bind.call(console.log,console);log.apply(console,arguments)}return arguments[arguments.length-1]};nv.deprecated=function(name,info){if(console&&console.warn){console.warn("nvd3 warning: `"+name+"` has been deprecated. ",info||"")}};nv.render=function render(step){step=step||1;nv.render.active=true;nv.dispatch.render_start();var renderLoop=function(){var chart,graph;for(var i=0;i<step&&(graph=nv.render.queue[i]);i++){chart=graph.generate();if(typeof graph.callback==typeof Function)graph.callback(chart)}nv.render.queue.splice(0,i);if(nv.render.queue.length){setTimeout(renderLoop)}else{nv.dispatch.render_end();nv.render.active=false}};setTimeout(renderLoop)};nv.render.active=false;nv.render.queue=[];nv.addGraph=function(obj){if(typeof arguments[0]===typeof Function){obj={generate:arguments[0],callback:arguments[1]}}nv.render.queue.push(obj);if(!nv.render.active){nv.render()}};if(typeof module!=="undefined"&&typeof exports!=="undefined"){module.exports=nv}if(typeof window!=="undefined"){window.nv=nv}nv.dom.write=function(callback){if(window.fastdom!==undefined){return fastdom.mutate(callback)}return callback()};nv.dom.read=function(callback){if(window.fastdom!==undefined){return fastdom.measure(callback)}return callback()};nv.interactiveGuideline=function(){"use strict";var margin={left:0,top:0},width=null,height=null,xScale=d3.scale.linear(),dispatch=d3.dispatch("elementMousemove","elementMouseout","elementClick","elementDblclick","elementMouseDown","elementMouseUp"),showGuideLine=true,svgContainer=null,tooltip=nv.models.tooltip(),isMSIE=window.ActiveXObject;tooltip.duration(0).hideDelay(0).hidden(false);function layer(selection){selection.each(function(data){var container=d3.select(this);var availableWidth=width||960,availableHeight=height||400;var wrap=container.selectAll("g.nv-wrap.nv-interactiveLineLayer").data([data]);var wrapEnter=wrap.enter().append("g").attr("class"," nv-wrap nv-interactiveLineLayer");wrapEnter.append("g").attr("class","nv-interactiveGuideLine");if(!svgContainer){return}function mouseHandler(){var mouseX=d3.event.clientX-this.getBoundingClientRect().left;var mouseY=d3.event.clientY-this.getBoundingClientRect().top;var subtractMargin=true;var mouseOutAnyReason=false;if(isMSIE){mouseX=d3.event.offsetX;mouseY=d3.event.offsetY;if(d3.event.target.tagName!=="svg"){subtractMargin=false}if(d3.event.target.className.baseVal.match("nv-legend")){mouseOutAnyReason=true}}if(subtractMargin){mouseX-=margin.left;mouseY-=margin.top}if(d3.event.type==="mouseout"||mouseX<0||mouseY<0||mouseX>availableWidth||mouseY>availableHeight||d3.event.relatedTarget&&d3.event.relatedTarget.ownerSVGElement===undefined||mouseOutAnyReason){if(isMSIE){if(d3.event.relatedTarget&&d3.event.relatedTarget.ownerSVGElement===undefined&&(d3.event.relatedTarget.className===undefined||d3.event.relatedTarget.className.match(tooltip.nvPointerEventsClass))){return}}dispatch.elementMouseout({mouseX:mouseX,mouseY:mouseY});layer.renderGuideLine(null);tooltip.hidden(true);return}else{tooltip.hidden(false)}var scaleIsOrdinal=typeof xScale.rangeBands==="function";var pointXValue=undefined;if(scaleIsOrdinal){var elementIndex=d3.bisect(xScale.range(),mouseX)-1;if(xScale.range()[elementIndex]+xScale.rangeBand()>=mouseX){pointXValue=xScale.domain()[d3.bisect(xScale.range(),mouseX)-1]}else{dispatch.elementMouseout({mouseX:mouseX,mouseY:mouseY});layer.renderGuideLine(null);tooltip.hidden(true);return}}else{pointXValue=xScale.invert(mouseX)}dispatch.elementMousemove({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue});if(d3.event.type==="dblclick"){dispatch.elementDblclick({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue})}if(d3.event.type==="click"){dispatch.elementClick({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue})}if(d3.event.type==="mousedown"){dispatch.elementMouseDown({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue})}if(d3.event.type==="mouseup"){dispatch.elementMouseUp({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue})}}svgContainer.on("touchmove",mouseHandler).on("mousemove",mouseHandler,true).on("mouseout",mouseHandler,true).on("mousedown",mouseHandler,true).on("mouseup",mouseHandler,true).on("dblclick",mouseHandler).on("click",mouseHandler);layer.guideLine=null;layer.renderGuideLine=function(x){if(!showGuideLine)return;if(layer.guideLine&&layer.guideLine.attr("x1")===x)return;nv.dom.write(function(){var line=wrap.select(".nv-interactiveGuideLine").selectAll("line").data(x!=null?[nv.utils.NaNtoZero(x)]:[],String);line.enter().append("line").attr("class","nv-guideline").attr("x1",function(d){return d}).attr("x2",function(d){return d}).attr("y1",availableHeight).attr("y2",0);line.exit().remove()})}})}layer.dispatch=dispatch;layer.tooltip=tooltip;layer.margin=function(_){if(!arguments.length)return margin;margin.top=typeof _.top!="undefined"?_.top:margin.top;margin.left=typeof _.left!="undefined"?_.left:margin.left;return layer};layer.width=function(_){if(!arguments.length)return width;width=_;return layer};layer.height=function(_){if(!arguments.length)return height;height=_;return layer};layer.xScale=function(_){if(!arguments.length)return xScale;xScale=_;return layer};layer.showGuideLine=function(_){if(!arguments.length)return showGuideLine;showGuideLine=_;return layer};layer.svgContainer=function(_){if(!arguments.length)return svgContainer;svgContainer=_;return layer};return layer};nv.interactiveBisect=function(values,searchVal,xAccessor){"use strict";if(!(values instanceof Array)){return null}var _xAccessor;if(typeof xAccessor!=="function"){_xAccessor=function(d){return d.x}}else{_xAccessor=xAccessor}var _cmp=function(d,v){return _xAccessor(d)-v};var bisect=d3.bisector(_cmp).left;var index=d3.max([0,bisect(values,searchVal)-1]);var currentValue=_xAccessor(values[index]);if(typeof currentValue==="undefined"){currentValue=index}if(currentValue===searchVal){return index}var nextIndex=d3.min([index+1,values.length-1]);var nextValue=_xAccessor(values[nextIndex]);if(typeof nextValue==="undefined"){nextValue=nextIndex}if(Math.abs(nextValue-searchVal)>=Math.abs(currentValue-searchVal)){return index}else{return nextIndex}};nv.nearestValueIndex=function(values,searchVal,threshold){"use strict";var yDistMax=Infinity,indexToHighlight=null;values.forEach(function(d,i){var delta=Math.abs(searchVal-d);if(d!=null&&delta<=yDistMax&&delta<threshold){yDistMax=delta;indexToHighlight=i}});return indexToHighlight};nv.models.tooltip=function(){"use strict";var id="nvtooltip-"+Math.floor(Math.random()*1e5),data=null,gravity="w",distance=25,snapDistance=0,classes=null,hidden=true,hideDelay=200,tooltip=null,lastPosition={left:null,top:null},enabled=true,duration=100,headerEnabled=true,nvPointerEventsClass="nv-pointer-events-none";var valueFormatter=function(d,i,p){return d};var headerFormatter=function(d){return d};var keyFormatter=function(d,i){return d};var contentGenerator=function(d,elem){if(d===null){return""}var table=d3.select(document.createElement("table"));if(headerEnabled){var theadEnter=table.selectAll("thead").data([d]).enter().append("thead");theadEnter.append("tr").append("td").attr("colspan",3).append("strong").classed("x-value",true).html(headerFormatter(d.value))}var tbodyEnter=table.selectAll("tbody").data([d]).enter().append("tbody");var trowEnter=tbodyEnter.selectAll("tr").data(function(p){return p.series}).enter().append("tr").classed("highlight",function(p){return p.highlight});trowEnter.append("td").classed("legend-color-guide",true).append("div").style("background-color",function(p){return p.color});trowEnter.append("td").classed("key",true).classed("total",function(p){return!!p.total}).html(function(p,i){return keyFormatter(p.key,i)});trowEnter.append("td").classed("value",true).html(function(p,i){return valueFormatter(p.value,i,p)});trowEnter.filter(function(p,i){return p.percent!==undefined}).append("td").classed("percent",true).html(function(p,i){return"("+d3.format("%")(p.percent)+")"});trowEnter.selectAll("td").each(function(p){if(p.highlight){var opacityScale=d3.scale.linear().domain([0,1]).range(["#fff",p.color]);var opacity=.6;d3.select(this).style("border-bottom-color",opacityScale(opacity)).style("border-top-color",opacityScale(opacity))}});var html=table.node().outerHTML;if(d.footer!==undefined)html+="<div class='footer'>"+d.footer+"</div>";return html};var position=function(){var pos={left:d3.event!==null?d3.event.clientX:0,top:d3.event!==null?d3.event.clientY:0};if(getComputedStyle(document.body).transform!="none"){var client=document.body.getBoundingClientRect();pos.left-=client.left;pos.top-=client.top}return pos};var dataSeriesExists=function(d){if(d&&d.series){if(nv.utils.isArray(d.series)){return true}if(nv.utils.isObject(d.series)){d.series=[d.series];return true}}return false};var calcGravityOffset=function(pos){var height=tooltip.node().offsetHeight,width=tooltip.node().offsetWidth,clientWidth=document.documentElement.clientWidth,clientHeight=document.documentElement.clientHeight,left,top,tmp;switch(gravity){case"e":left=-width-distance;top=-(height/2);if(pos.left+left<0)left=distance;if((tmp=pos.top+top)<0)top-=tmp;if((tmp=pos.top+top+height)>clientHeight)top-=tmp-clientHeight;break;case"w":left=distance;top=-(height/2);if(pos.left+left+width>clientWidth)left=-width-distance;if((tmp=pos.top+top)<0)top-=tmp;if((tmp=pos.top+top+height)>clientHeight)top-=tmp-clientHeight;break;case"n":left=-(width/2)-5;top=distance;if(pos.top+top+height>clientHeight)top=-height-distance;if((tmp=pos.left+left)<0)left-=tmp;if((tmp=pos.left+left+width)>clientWidth)left-=tmp-clientWidth;break;case"s":left=-(width/2);top=-height-distance;if(pos.top+top<0)top=distance;if((tmp=pos.left+left)<0)left-=tmp;if((tmp=pos.left+left+width)>clientWidth)left-=tmp-clientWidth;break;case"center":left=-(width/2);top=-(height/2);break;default:left=0;top=0;break}return{left:left,top:top}};var positionTooltip=function(){nv.dom.read(function(){var pos=position(),gravityOffset=calcGravityOffset(pos),left=pos.left+gravityOffset.left,top=pos.top+gravityOffset.top;if(hidden){tooltip.interrupt().transition().delay(hideDelay).duration(0).style("opacity",0)}else{var old_translate="translate("+lastPosition.left+"px, "+lastPosition.top+"px)";var new_translate="translate("+Math.round(left)+"px, "+Math.round(top)+"px)";var translateInterpolator=d3.interpolateString(old_translate,new_translate);var is_hidden=tooltip.style("opacity")<.1;tooltip.interrupt().transition().duration(is_hidden?0:duration).styleTween("transform",function(d){return translateInterpolator},"important").styleTween("-webkit-transform",function(d){return translateInterpolator}).style("-ms-transform",new_translate).style("opacity",1)}lastPosition.left=left;lastPosition.top=top})};function initTooltip(){if(!tooltip||!tooltip.node()){var data=[1];tooltip=d3.select(document.body).select("#"+id).data(data);tooltip.enter().append("div").attr("class","nvtooltip "+(classes?classes:"xy-tooltip")).attr("id",id).style("top",0).style("left",0).style("opacity",0).style("position","fixed").selectAll("div, table, td, tr").classed(nvPointerEventsClass,true).classed(nvPointerEventsClass,true);tooltip.exit().remove()}}function nvtooltip(){if(!enabled)return;if(!dataSeriesExists(data))return;nv.dom.write(function(){initTooltip();var newContent=contentGenerator(data,tooltip.node());if(newContent){tooltip.node().innerHTML=newContent}positionTooltip()});return nvtooltip}nvtooltip.nvPointerEventsClass=nvPointerEventsClass;nvtooltip.options=nv.utils.optionsFunc.bind(nvtooltip);nvtooltip._options=Object.create({},{duration:{get:function(){return duration},set:function(_){duration=_}},gravity:{get:function(){return gravity},set:function(_){gravity=_}},distance:{get:function(){return distance},set:function(_){distance=_}},snapDistance:{get:function(){return snapDistance},set:function(_){snapDistance=_}},classes:{get:function(){return classes},set:function(_){classes=_}},enabled:{get:function(){return enabled},set:function(_){enabled=_}},hideDelay:{get:function(){return hideDelay},set:function(_){hideDelay=_}},contentGenerator:{get:function(){return contentGenerator},set:function(_){contentGenerator=_}},valueFormatter:{get:function(){return valueFormatter},set:function(_){valueFormatter=_}},headerFormatter:{get:function(){return headerFormatter},set:function(_){headerFormatter=_}},keyFormatter:{get:function(){return keyFormatter},set:function(_){keyFormatter=_}},headerEnabled:{get:function(){return headerEnabled},set:function(_){headerEnabled=_}},position:{get:function(){return position},set:function(_){position=_}},chartContainer:{get:function(){return document.body},set:function(_){nv.deprecated("chartContainer","feature removed after 1.8.3")}},fixedTop:{get:function(){return null},set:function(_){nv.deprecated("fixedTop","feature removed after 1.8.1")}},offset:{get:function(){return{left:0,top:0}},set:function(_){nv.deprecated("offset","use chart.tooltip.distance() instead")}},hidden:{get:function(){return hidden},set:function(_){if(hidden!=_){hidden=!!_;nvtooltip()}}},data:{get:function(){return data},set:function(_){if(_.point){_.value=_.point.x;_.series=_.series||{};_.series.value=_.point.y;_.series.color=_.point.color||_.series.color}data=_}},node:{get:function(){return tooltip.node()},set:function(_){}},id:{get:function(){return id},set:function(_){}}});nv.utils.initOptions(nvtooltip);return nvtooltip};nv.utils.windowSize=function(){var size={width:640,height:480};if(window.innerWidth&&window.innerHeight){size.width=window.innerWidth;size.height=window.innerHeight;return size}if(document.compatMode=="CSS1Compat"&&document.documentElement&&document.documentElement.offsetWidth){size.width=document.documentElement.offsetWidth;size.height=document.documentElement.offsetHeight;return size}if(document.body&&document.body.offsetWidth){size.width=document.body.offsetWidth;size.height=document.body.offsetHeight;return size}return size};nv.utils.isArray=Array.isArray;nv.utils.isObject=function(a){return a!==null&&typeof a==="object"};nv.utils.isFunction=function(a){return typeof a==="function"};nv.utils.isDate=function(a){return toString.call(a)==="[object Date]"};nv.utils.isNumber=function(a){return!isNaN(a)&&typeof a==="number"};nv.utils.windowResize=function(handler){if(window.addEventListener){window.addEventListener("resize",handler)}else{nv.log("ERROR: Failed to bind to window.resize with: ",handler)}return{callback:handler,clear:function(){window.removeEventListener("resize",handler)}}};nv.utils.getColor=function(color){if(color===undefined){return nv.utils.defaultColor()}else if(nv.utils.isArray(color)){var color_scale=d3.scale.ordinal().range(color);return function(d,i){var key=i===undefined?d:i;return d.color||color_scale(key)}}else{return color}};nv.utils.defaultColor=function(){return nv.utils.getColor(d3.scale.category20().range())};nv.utils.customTheme=function(dictionary,getKey,defaultColors){getKey=getKey||function(series){return series.key};defaultColors=defaultColors||d3.scale.category20().range();var defIndex=defaultColors.length;return function(series,index){var key=getKey(series);if(nv.utils.isFunction(dictionary[key])){return dictionary[key]()}else if(dictionary[key]!==undefined){return dictionary[key]}else{if(!defIndex){defIndex=defaultColors.length}defIndex=defIndex-1;return defaultColors[defIndex]}}};nv.utils.pjax=function(links,content){var load=function(href){d3.html(href,function(fragment){var target=d3.select(content).node();target.parentNode.replaceChild(d3.select(fragment).select(content).node(),target);nv.utils.pjax(links,content)})};d3.selectAll(links).on("click",function(){history.pushState(this.href,this.textContent,this.href);load(this.href);d3.event.preventDefault()});d3.select(window).on("popstate",function(){if(d3.event.state){load(d3.event.state)}})};nv.utils.calcApproxTextWidth=function(svgTextElem){if(nv.utils.isFunction(svgTextElem.style)&&nv.utils.isFunction(svgTextElem.text)){var fontSize=parseInt(svgTextElem.style("font-size").replace("px",""),10);var textLength=svgTextElem.text().length;return nv.utils.NaNtoZero(textLength*fontSize*.5)}return 0};nv.utils.NaNtoZero=function(n){if(!nv.utils.isNumber(n)||isNaN(n)||n===null||n===Infinity||n===-Infinity){return 0}return n};d3.selection.prototype.watchTransition=function(renderWatch){var args=[this].concat([].slice.call(arguments,1));return renderWatch.transition.apply(renderWatch,args)};nv.utils.renderWatch=function(dispatch,duration){if(!(this instanceof nv.utils.renderWatch)){return new nv.utils.renderWatch(dispatch,duration)}var _duration=duration!==undefined?duration:250;var renderStack=[];var self=this;this.models=function(models){models=[].slice.call(arguments,0);models.forEach(function(model){model.__rendered=false;(function(m){m.dispatch.on("renderEnd",function(arg){m.__rendered=true;self.renderEnd("model")})})(model);if(renderStack.indexOf(model)<0){renderStack.push(model)}});return this};this.reset=function(duration){if(duration!==undefined){_duration=duration}renderStack=[]};this.transition=function(selection,args,duration){args=arguments.length>1?[].slice.call(arguments,1):[];if(args.length>1){duration=args.pop()}else{duration=_duration!==undefined?_duration:250}selection.__rendered=false;if(renderStack.indexOf(selection)<0){renderStack.push(selection)}if(duration===0){selection.__rendered=true;selection.delay=function(){return this};selection.duration=function(){return this};return selection}else{if(selection.length===0){selection.__rendered=true}else if(selection.every(function(d){return!d.length})){selection.__rendered=true}else{selection.__rendered=false}var n=0;return selection.transition().duration(duration).each(function(){++n}).each("end",function(d,i){if(--n===0){selection.__rendered=true;self.renderEnd.apply(this,args)}})}};this.renderEnd=function(){if(renderStack.every(function(d){return d.__rendered})){renderStack.forEach(function(d){d.__rendered=false});dispatch.renderEnd.apply(this,arguments)}}};nv.utils.deepExtend=function(dst){var sources=arguments.length>1?[].slice.call(arguments,1):[];sources.forEach(function(source){for(var key in source){var isArray=nv.utils.isArray(dst[key]);var isObject=nv.utils.isObject(dst[key]);var srcObj=nv.utils.isObject(source[key]);if(isObject&&!isArray&&srcObj){nv.utils.deepExtend(dst[key],source[key])}else{dst[key]=source[key]}}})};nv.utils.state=function(){if(!(this instanceof nv.utils.state)){return new nv.utils.state}var state={};var _self=this;var _setState=function(){};var _getState=function(){return{}};var init=null;var changed=null;this.dispatch=d3.dispatch("change","set");this.dispatch.on("set",function(state){_setState(state,true)});this.getter=function(fn){_getState=fn;return this};this.setter=function(fn,callback){if(!callback){callback=function(){}}_setState=function(state,update){fn(state);if(update){callback()}};return this};this.init=function(state){init=init||{};nv.utils.deepExtend(init,state)};var _set=function(){var settings=_getState();if(JSON.stringify(settings)===JSON.stringify(state)){return false}for(var key in settings){if(state[key]===undefined){state[key]={}}state[key]=settings[key];changed=true}return true};this.update=function(){if(init){_setState(init,false);init=null}if(_set.call(this)){this.dispatch.change(state)}}};nv.utils.optionsFunc=function(args){if(args){d3.map(args).forEach(function(key,value){if(nv.utils.isFunction(this[key])){this[key](value)}}.bind(this))}return this};nv.utils.calcTicksX=function(numTicks,data){var numValues=1;var i=0;for(i;i<data.length;i+=1){var stream_len=data[i]&&data[i].values?data[i].values.length:0;numValues=stream_len>numValues?stream_len:numValues}nv.log("Requested number of ticks: ",numTicks);nv.log("Calculated max values to be: ",numValues);numTicks=numTicks>numValues?numTicks=numValues-1:numTicks;numTicks=numTicks<1?1:numTicks;numTicks=Math.floor(numTicks);nv.log("Calculating tick count as: ",numTicks);return numTicks};nv.utils.calcTicksY=function(numTicks,data){return nv.utils.calcTicksX(numTicks,data)};nv.utils.initOption=function(chart,name){if(chart._calls&&chart._calls[name]){chart[name]=chart._calls[name]}else{chart[name]=function(_){if(!arguments.length)return chart._options[name];chart._overrides[name]=true;chart._options[name]=_;return chart};chart["_"+name]=function(_){if(!arguments.length)return chart._options[name];if(!chart._overrides[name]){chart._options[name]=_}return chart}}};nv.utils.initOptions=function(chart){chart._overrides=chart._overrides||{};var ops=Object.getOwnPropertyNames(chart._options||{});var calls=Object.getOwnPropertyNames(chart._calls||{});ops=ops.concat(calls);for(var i in ops){nv.utils.initOption(chart,ops[i])}};nv.utils.inheritOptionsD3=function(target,d3_source,oplist){target._d3options=oplist.concat(target._d3options||[]);target._d3options=(target._d3options||[]).filter(function(item,i,ar){return ar.indexOf(item)===i});oplist.unshift(d3_source);oplist.unshift(target);d3.rebind.apply(this,oplist)};nv.utils.arrayUnique=function(a){return a.sort().filter(function(item,pos){return!pos||item!=a[pos-1]})};nv.utils.symbolMap=d3.map();nv.utils.symbol=function(){var type,size=64;function symbol(d,i){var t=type.call(this,d,i);var s=size.call(this,d,i);if(d3.svg.symbolTypes.indexOf(t)!==-1){return d3.svg.symbol().type(t).size(s)()}else{return nv.utils.symbolMap.get(t)(s)}}symbol.type=function(_){if(!arguments.length)return type;type=d3.functor(_);return symbol};symbol.size=function(_){if(!arguments.length)return size;size=d3.functor(_);return symbol};return symbol};nv.utils.inheritOptions=function(target,source){var ops=Object.getOwnPropertyNames(source._options||{});var calls=Object.getOwnPropertyNames(source._calls||{});var inherited=source._inherited||[];var d3ops=source._d3options||[];var args=ops.concat(calls).concat(inherited).concat(d3ops);args.unshift(source);args.unshift(target);d3.rebind.apply(this,args);target._inherited=nv.utils.arrayUnique(ops.concat(calls).concat(inherited).concat(ops).concat(target._inherited||[]));target._d3options=nv.utils.arrayUnique(d3ops.concat(target._d3options||[]))};nv.utils.initSVG=function(svg){svg.classed({"nvd3-svg":true})};nv.utils.sanitizeHeight=function(height,container){return height||parseInt(container.style("height"),10)||400};nv.utils.sanitizeWidth=function(width,container){return width||parseInt(container.style("width"),10)||960};nv.utils.availableHeight=function(height,container,margin){return Math.max(0,nv.utils.sanitizeHeight(height,container)-margin.top-margin.bottom)};nv.utils.availableWidth=function(width,container,margin){return Math.max(0,nv.utils.sanitizeWidth(width,container)-margin.left-margin.right)};nv.utils.noData=function(chart,container){var opt=chart.options(),margin=opt.margin(),noData=opt.noData(),data=noData==null?["No Data Available."]:[noData],height=nv.utils.availableHeight(null,container,margin),width=nv.utils.availableWidth(null,container,margin),x=margin.left+width/2,y=margin.top+height/2;container.selectAll("g").remove();var noDataText=container.selectAll(".nv-noData").data(data);noDataText.enter().append("text").attr("class","nvd3 nv-noData").attr("dy","-.7em").style("text-anchor","middle");noDataText.attr("x",x).attr("y",y).text(function(t){return t})};nv.utils.wrapTicks=function(text,width){text.each(function(){var text=d3.select(this),words=text.text().split(/\s+/).reverse(),word,line=[],lineNumber=0,lineHeight=1.1,y=text.attr("y"),dy=parseFloat(text.attr("dy")),tspan=text.text(null).append("tspan").attr("x",0).attr("y",y).attr("dy",dy+"em");while(word=words.pop()){line.push(word);tspan.text(line.join(" "));if(tspan.node().getComputedTextLength()>width){line.pop();tspan.text(line.join(" "));line=[word];tspan=text.append("tspan").attr("x",0).attr("y",y).attr("dy",++lineNumber*lineHeight+dy+"em").text(word)}}})};nv.utils.arrayEquals=function(array1,array2){if(array1===array2)return true;if(!array1||!array2)return false;if(array1.length!=array2.length)return false;for(var i=0,l=array1.length;i<l;i++){if(array1[i]instanceof Array&&array2[i]instanceof Array){if(!nv.arrayEquals(array1[i],array2[i]))return false}else if(array1[i]!=array2[i]){return false}}return true};nv.utils.pointIsInArc=function(pt,ptData,d3Arc){var r1=d3Arc.innerRadius()(ptData),r2=d3Arc.outerRadius()(ptData),theta1=d3Arc.startAngle()(ptData),theta2=d3Arc.endAngle()(ptData);var dist=pt.x*pt.x+pt.y*pt.y,angle=Math.atan2(pt.x,-pt.y);angle=angle<0?angle+Math.PI*2:angle;return r1*r1<=dist&&dist<=r2*r2&&theta1<=angle&&angle<=theta2};nv.models.axis=function(){"use strict";var axis=d3.svg.axis();var scale=d3.scale.linear();var margin={top:0,right:0,bottom:0,left:0},width=75,height=60,axisLabelText=null,showMaxMin=true,rotateLabels=0,rotateYLabel=true,staggerLabels=false,isOrdinal=false,ticks=null,axisLabelDistance=0,fontSize=undefined,duration=250,dispatch=d3.dispatch("renderEnd"),tickFormatMaxMin;axis.scale(scale).orient("bottom").tickFormat(function(d){return d});var scale0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var wrap=container.selectAll("g.nv-wrap.nv-axis").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-axis");var gEnter=wrapEnter.append("g");var g=wrap.select("g");if(ticks!==null)axis.ticks(ticks);else if(axis.orient()=="top"||axis.orient()=="bottom")axis.ticks(Math.abs(scale.range()[1]-scale.range()[0])/100);g.watchTransition(renderWatch,"axis").call(axis);scale0=scale0||axis.scale();var fmt=axis.tickFormat();if(fmt==null){fmt=scale0.tickFormat()}var axisLabel=g.selectAll("text.nv-axislabel").data([axisLabelText||null]);axisLabel.exit().remove();if(fontSize!==undefined){g.selectAll("g").select("text").style("font-size",fontSize)}var xLabelMargin;var axisMaxMin;var w;switch(axis.orient()){case"top":axisLabel.enter().append("text").attr("class","nv-axislabel");w=0;if(scale.range().length===1){w=isOrdinal?scale.range()[0]*2+scale.rangeBand():0}else if(scale.range().length===2){w=isOrdinal?scale.range()[0]+scale.range()[1]+scale.rangeBand():scale.range()[1]}else if(scale.range().length>2){w=scale.range()[scale.range().length-1]+(scale.range()[1]-scale.range()[0])};axisLabel.attr("text-anchor","middle").attr("y",0).attr("x",w/2);if(showMaxMin){axisMaxMin=wrap.selectAll("g.nv-axisMaxMin").data(scale.domain());axisMaxMin.enter().append("g").attr("class",function(d,i){return["nv-axisMaxMin","nv-axisMaxMin-x",i==0?"nv-axisMin-x":"nv-axisMax-x"].join(" ")}).append("text");axisMaxMin.exit().remove();axisMaxMin.attr("transform",function(d,i){return"translate("+nv.utils.NaNtoZero(scale(d))+",0)"}).select("text").attr("dy","-0.5em").attr("y",-axis.tickPadding()).attr("text-anchor","middle").text(function(d,i){var formatter=tickFormatMaxMin||fmt;var v=formatter(d);return(""+v).match("NaN")?"":v});axisMaxMin.watchTransition(renderWatch,"min-max top").attr("transform",function(d,i){return"translate("+nv.utils.NaNtoZero(scale.range()[i])+",0)"})}break;case"bottom":xLabelMargin=axisLabelDistance+36;var maxTextWidth=30;var textHeight=0;var xTicks=g.selectAll("g").select("text");var rotateLabelsRule="";if(rotateLabels%360){xTicks.attr("transform","");xTicks.each(function(d,i){var box=this.getBoundingClientRect();var width=box.width;textHeight=box.height;if(width>maxTextWidth)maxTextWidth=width});rotateLabelsRule="rotate("+rotateLabels+" 0,"+(textHeight/2+axis.tickPadding())+")";
var sin=Math.abs(Math.sin(rotateLabels*Math.PI/180));xLabelMargin=(sin?sin*maxTextWidth:maxTextWidth)+30;xTicks.attr("transform",rotateLabelsRule).style("text-anchor",rotateLabels%360>0?"start":"end")}else{if(staggerLabels){xTicks.attr("transform",function(d,i){return"translate(0,"+(i%2==0?"0":"12")+")"})}else{xTicks.attr("transform","translate(0,0)")}}axisLabel.enter().append("text").attr("class","nv-axislabel");w=0;if(scale.range().length===1){w=isOrdinal?scale.range()[0]*2+scale.rangeBand():0}else if(scale.range().length===2){w=isOrdinal?scale.range()[0]+scale.range()[1]+scale.rangeBand():scale.range()[1]}else if(scale.range().length>2){w=scale.range()[scale.range().length-1]+(scale.range()[1]-scale.range()[0])};axisLabel.attr("text-anchor","middle").attr("y",xLabelMargin).attr("x",w/2);if(showMaxMin){axisMaxMin=wrap.selectAll("g.nv-axisMaxMin").data([scale.domain()[0],scale.domain()[scale.domain().length-1]]);axisMaxMin.enter().append("g").attr("class",function(d,i){return["nv-axisMaxMin","nv-axisMaxMin-x",i==0?"nv-axisMin-x":"nv-axisMax-x"].join(" ")}).append("text");axisMaxMin.exit().remove();axisMaxMin.attr("transform",function(d,i){return"translate("+nv.utils.NaNtoZero(scale(d)+(isOrdinal?scale.rangeBand()/2:0))+",0)"}).select("text").attr("dy",".71em").attr("y",axis.tickPadding()).attr("transform",rotateLabelsRule).style("text-anchor",rotateLabels?rotateLabels%360>0?"start":"end":"middle").text(function(d,i){var formatter=tickFormatMaxMin||fmt;var v=formatter(d);return(""+v).match("NaN")?"":v});axisMaxMin.watchTransition(renderWatch,"min-max bottom").attr("transform",function(d,i){return"translate("+nv.utils.NaNtoZero(scale(d)+(isOrdinal?scale.rangeBand()/2:0))+",0)"})}break;case"right":axisLabel.enter().append("text").attr("class","nv-axislabel");axisLabel.style("text-anchor",rotateYLabel?"middle":"begin").attr("transform",rotateYLabel?"rotate(90)":"").attr("y",rotateYLabel?-Math.max(margin.right,width)+12-(axisLabelDistance||0):-10).attr("x",rotateYLabel?d3.max(scale.range())/2:axis.tickPadding());if(showMaxMin){axisMaxMin=wrap.selectAll("g.nv-axisMaxMin").data(scale.domain());axisMaxMin.enter().append("g").attr("class",function(d,i){return["nv-axisMaxMin","nv-axisMaxMin-y",i==0?"nv-axisMin-y":"nv-axisMax-y"].join(" ")}).append("text").style("opacity",0);axisMaxMin.exit().remove();axisMaxMin.attr("transform",function(d,i){return"translate(0,"+nv.utils.NaNtoZero(scale(d))+")"}).select("text").attr("dy",".32em").attr("y",0).attr("x",axis.tickPadding()).style("text-anchor","start").text(function(d,i){var formatter=tickFormatMaxMin||fmt;var v=formatter(d);return(""+v).match("NaN")?"":v});axisMaxMin.watchTransition(renderWatch,"min-max right").attr("transform",function(d,i){return"translate(0,"+nv.utils.NaNtoZero(scale.range()[i])+")"}).select("text").style("opacity",1)}break;case"left":axisLabel.enter().append("text").attr("class","nv-axislabel");axisLabel.style("text-anchor",rotateYLabel?"middle":"end").attr("transform",rotateYLabel?"rotate(-90)":"").attr("y",rotateYLabel?-Math.max(margin.left,width)+25-(axisLabelDistance||0):-10).attr("x",rotateYLabel?-d3.max(scale.range())/2:-axis.tickPadding());if(showMaxMin){axisMaxMin=wrap.selectAll("g.nv-axisMaxMin").data(scale.domain());axisMaxMin.enter().append("g").attr("class",function(d,i){return["nv-axisMaxMin","nv-axisMaxMin-y",i==0?"nv-axisMin-y":"nv-axisMax-y"].join(" ")}).append("text").style("opacity",0);axisMaxMin.exit().remove();axisMaxMin.attr("transform",function(d,i){return"translate(0,"+nv.utils.NaNtoZero(scale0(d))+")"}).select("text").attr("dy",".32em").attr("y",0).attr("x",-axis.tickPadding()).attr("text-anchor","end").text(function(d,i){var formatter=tickFormatMaxMin||fmt;var v=formatter(d);return(""+v).match("NaN")?"":v});axisMaxMin.watchTransition(renderWatch,"min-max right").attr("transform",function(d,i){return"translate(0,"+nv.utils.NaNtoZero(scale.range()[i])+")"}).select("text").style("opacity",1)}break}axisLabel.text(function(d){return d});if(showMaxMin&&(axis.orient()==="left"||axis.orient()==="right")){g.selectAll("g").each(function(d,i){d3.select(this).select("text").attr("opacity",1);if(scale(d)<scale.range()[1]+10||scale(d)>scale.range()[0]-10){if(d>1e-10||d<-1e-10)d3.select(this).attr("opacity",0);d3.select(this).select("text").attr("opacity",0)}});if(scale.domain()[0]==scale.domain()[1]&&scale.domain()[0]==0){wrap.selectAll("g.nv-axisMaxMin").style("opacity",function(d,i){return!i?1:0})}}if(showMaxMin&&(axis.orient()==="top"||axis.orient()==="bottom")){var maxMinRange=[];wrap.selectAll("g.nv-axisMaxMin").each(function(d,i){try{if(i)maxMinRange.push(scale(d)-this.getBoundingClientRect().width-4);else maxMinRange.push(scale(d)+this.getBoundingClientRect().width+4)}catch(err){if(i)maxMinRange.push(scale(d)-4);else maxMinRange.push(scale(d)+4)}});g.selectAll("g").each(function(d,i){if(scale(d)<maxMinRange[0]||scale(d)>maxMinRange[1]){if(d>1e-10||d<-1e-10)d3.select(this).remove();else d3.select(this).select("text").remove()}})}g.selectAll(".tick").filter(function(d){return!parseFloat(Math.round(d*1e5)/1e6)&&d!==undefined}).classed("zero",true);scale0=scale.copy()});renderWatch.renderEnd("axis immediate");return chart}chart.axis=axis;chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{axisLabelDistance:{get:function(){return axisLabelDistance},set:function(_){axisLabelDistance=_}},staggerLabels:{get:function(){return staggerLabels},set:function(_){staggerLabels=_}},rotateLabels:{get:function(){return rotateLabels},set:function(_){rotateLabels=_}},rotateYLabel:{get:function(){return rotateYLabel},set:function(_){rotateYLabel=_}},showMaxMin:{get:function(){return showMaxMin},set:function(_){showMaxMin=_}},axisLabel:{get:function(){return axisLabelText},set:function(_){axisLabelText=_}},height:{get:function(){return height},set:function(_){height=_}},ticks:{get:function(){return ticks},set:function(_){ticks=_}},width:{get:function(){return width},set:function(_){width=_}},fontSize:{get:function(){return fontSize},set:function(_){fontSize=_}},tickFormatMaxMin:{get:function(){return tickFormatMaxMin},set:function(_){tickFormatMaxMin=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}},scale:{get:function(){return scale},set:function(_){scale=_;axis.scale(scale);isOrdinal=typeof scale.rangeBands==="function";nv.utils.inheritOptionsD3(chart,scale,["domain","range","rangeBand","rangeBands"])}}});nv.utils.initOptions(chart);nv.utils.inheritOptionsD3(chart,axis,["orient","tickValues","tickSubdivide","tickSize","tickPadding","tickFormat"]);nv.utils.inheritOptionsD3(chart,scale,["domain","range","rangeBand","rangeBands"]);return chart};nv.models.boxPlot=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,id=Math.floor(Math.random()*1e4),xScale=d3.scale.ordinal(),yScale=d3.scale.linear(),getX=function(d){return d.label},getQ1=function(d){return d.values.Q1},getQ2=function(d){return d.values.Q2},getQ3=function(d){return d.values.Q3},getWl=function(d){return d.values.whisker_low},getWh=function(d){return d.values.whisker_high},getColor=function(d){return d.color},getOlItems=function(d){return d.values.outliers},getOlValue=function(d,i,j){return d},getOlLabel=function(d,i,j){return d},getOlColor=function(d,i,j){return undefined},color=nv.utils.defaultColor(),container=null,xDomain,xRange,yDomain,yRange,dispatch=d3.dispatch("elementMouseover","elementMouseout","elementMousemove","renderEnd"),duration=250,maxBoxWidth=null;var xScale0,yScale0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);xScale.domain(xDomain||data.map(function(d,i){return getX(d,i)})).rangeBands(xRange||[0,availableWidth],.1);var yData=[];if(!yDomain){var values=[],yMin,yMax;data.forEach(function(d,i){var q1=getQ1(d),q3=getQ3(d),wl=getWl(d),wh=getWh(d);var olItems=getOlItems(d);if(olItems){olItems.forEach(function(e,i){values.push(getOlValue(e,i,undefined))})}if(wl){values.push(wl)}if(q1){values.push(q1)}if(q3){values.push(q3)}if(wh){values.push(wh)}});yMin=d3.min(values);yMax=d3.max(values);yData=[yMin,yMax]}yScale.domain(yDomain||yData);yScale.range(yRange||[availableHeight,0]);xScale0=xScale0||xScale;yScale0=yScale0||yScale.copy().range([yScale(0),yScale(0)]);var wrap=container.selectAll("g.nv-wrap").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var boxplots=wrap.selectAll(".nv-boxplot").data(function(d){return d});var boxEnter=boxplots.enter().append("g").style("stroke-opacity",1e-6).style("fill-opacity",1e-6);boxplots.attr("class","nv-boxplot").attr("transform",function(d,i,j){return"translate("+(xScale(getX(d,i))+xScale.rangeBand()*.05)+", 0)"}).classed("hover",function(d){return d.hover});boxplots.watchTransition(renderWatch,"nv-boxplot: boxplots").style("stroke-opacity",1).style("fill-opacity",.75).delay(function(d,i){return i*duration/data.length}).attr("transform",function(d,i){return"translate("+(xScale(getX(d,i))+xScale.rangeBand()*.05)+", 0)"});boxplots.exit().remove();boxEnter.each(function(d,i){var box=d3.select(this);[getWl,getWh].forEach(function(f){if(f(d)!==undefined&&f(d)!==null){var key=f===getWl?"low":"high";box.append("line").style("stroke",getColor(d)||color(d,i)).attr("class","nv-boxplot-whisker nv-boxplot-"+key);box.append("line").style("stroke",getColor(d)||color(d,i)).attr("class","nv-boxplot-tick nv-boxplot-"+key)}})});var box_width=function(){return maxBoxWidth===null?xScale.rangeBand()*.9:Math.min(75,xScale.rangeBand()*.9)};var box_left=function(){return xScale.rangeBand()*.45-box_width()/2};var box_right=function(){return xScale.rangeBand()*.45+box_width()/2};[getWl,getWh].forEach(function(f){var key=f===getWl?"low":"high";var endpoint=f===getWl?getQ1:getQ3;boxplots.select("line.nv-boxplot-whisker.nv-boxplot-"+key).watchTransition(renderWatch,"nv-boxplot: boxplots").attr("x1",xScale.rangeBand()*.45).attr("y1",function(d,i){return yScale(f(d))}).attr("x2",xScale.rangeBand()*.45).attr("y2",function(d,i){return yScale(endpoint(d))});boxplots.select("line.nv-boxplot-tick.nv-boxplot-"+key).watchTransition(renderWatch,"nv-boxplot: boxplots").attr("x1",box_left).attr("y1",function(d,i){return yScale(f(d))}).attr("x2",box_right).attr("y2",function(d,i){return yScale(f(d))})});[getWl,getWh].forEach(function(f){var key=f===getWl?"low":"high";boxEnter.selectAll(".nv-boxplot-"+key).on("mouseover",function(d,i,j){d3.select(this).classed("hover",true);dispatch.elementMouseover({series:{key:f(d),color:getColor(d)||color(d,j)},e:d3.event})}).on("mouseout",function(d,i,j){d3.select(this).classed("hover",false);dispatch.elementMouseout({series:{key:f(d),color:getColor(d)||color(d,j)},e:d3.event})}).on("mousemove",function(d,i){dispatch.elementMousemove({e:d3.event})})});boxEnter.append("rect").attr("class","nv-boxplot-box").on("mouseover",function(d,i){d3.select(this).classed("hover",true);dispatch.elementMouseover({key:getX(d),value:getX(d),series:[{key:"Q3",value:getQ3(d),color:getColor(d)||color(d,i)},{key:"Q2",value:getQ2(d),color:getColor(d)||color(d,i)},{key:"Q1",value:getQ1(d),color:getColor(d)||color(d,i)}],data:d,index:i,e:d3.event})}).on("mouseout",function(d,i){d3.select(this).classed("hover",false);dispatch.elementMouseout({key:getX(d),value:getX(d),series:[{key:"Q3",value:getQ3(d),color:getColor(d)||color(d,i)},{key:"Q2",value:getQ2(d),color:getColor(d)||color(d,i)},{key:"Q1",value:getQ1(d),color:getColor(d)||color(d,i)}],data:d,index:i,e:d3.event})}).on("mousemove",function(d,i){dispatch.elementMousemove({e:d3.event})});boxplots.select("rect.nv-boxplot-box").watchTransition(renderWatch,"nv-boxplot: boxes").attr("y",function(d,i){return yScale(getQ3(d))}).attr("width",box_width).attr("x",box_left).attr("height",function(d,i){return Math.abs(yScale(getQ3(d))-yScale(getQ1(d)))||1}).style("fill",function(d,i){return getColor(d)||color(d,i)}).style("stroke",function(d,i){return getColor(d)||color(d,i)});boxEnter.append("line").attr("class","nv-boxplot-median");boxplots.select("line.nv-boxplot-median").watchTransition(renderWatch,"nv-boxplot: boxplots line").attr("x1",box_left).attr("y1",function(d,i){return yScale(getQ2(d))}).attr("x2",box_right).attr("y2",function(d,i){return yScale(getQ2(d))});var outliers=boxplots.selectAll(".nv-boxplot-outlier").data(function(d){return getOlItems(d)||[]});outliers.enter().append("circle").style("fill",function(d,i,j){return getOlColor(d,i,j)||color(d,j)}).style("stroke",function(d,i,j){return getOlColor(d,i,j)||color(d,j)}).style("z-index",9e3).on("mouseover",function(d,i,j){d3.select(this).classed("hover",true);dispatch.elementMouseover({series:{key:getOlLabel(d,i,j),color:getOlColor(d,i,j)||color(d,j)},e:d3.event})}).on("mouseout",function(d,i,j){d3.select(this).classed("hover",false);dispatch.elementMouseout({series:{key:getOlLabel(d,i,j),color:getOlColor(d,i,j)||color(d,j)},e:d3.event})}).on("mousemove",function(d,i){dispatch.elementMousemove({e:d3.event})});outliers.attr("class","nv-boxplot-outlier");outliers.watchTransition(renderWatch,"nv-boxplot: nv-boxplot-outlier").attr("cx",xScale.rangeBand()*.45).attr("cy",function(d,i,j){return yScale(getOlValue(d,i,j))}).attr("r","3");outliers.exit().remove();xScale0=xScale.copy();yScale0=yScale.copy()});renderWatch.renderEnd("nv-boxplot immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},maxBoxWidth:{get:function(){return maxBoxWidth},set:function(_){maxBoxWidth=_}},x:{get:function(){return getX},set:function(_){getX=_}},q1:{get:function(){return getQ1},set:function(_){getQ1=_}},q2:{get:function(){return getQ2},set:function(_){getQ2=_}},q3:{get:function(){return getQ3},set:function(_){getQ3=_}},wl:{get:function(){return getWl},set:function(_){getWl=_}},wh:{get:function(){return getWh},set:function(_){getWh=_}},itemColor:{get:function(){return getColor},set:function(_){getColor=_}},outliers:{get:function(){return getOlItems},set:function(_){getOlItems=_}},outlierValue:{get:function(){return getOlValue},set:function(_){getOlValue=_}},outlierLabel:{get:function(){return getOlLabel},set:function(_){getOlLabel=_}},outlierColor:{get:function(){return getOlColor},set:function(_){getOlColor=_}},xScale:{get:function(){return xScale},set:function(_){xScale=_}},yScale:{get:function(){return yScale},set:function(_){yScale=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},id:{get:function(){return id},set:function(_){id=_}},y:{get:function(){console.warn("BoxPlot 'y' chart option is deprecated. Please use model overrides instead.");return{}},set:function(_){console.warn("BoxPlot 'y' chart option is deprecated. Please use model overrides instead.")}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}}});nv.utils.initOptions(chart);return chart};nv.models.boxPlotChart=function(){"use strict";var boxplot=nv.models.boxPlot(),xAxis=nv.models.axis(),yAxis=nv.models.axis();var margin={top:15,right:10,bottom:50,left:60},width=null,height=null,color=nv.utils.getColor(),showXAxis=true,showYAxis=true,rightAlignYAxis=false,staggerLabels=false,tooltip=nv.models.tooltip(),x,y,noData="No Data Available.",dispatch=d3.dispatch("beforeUpdate","renderEnd"),duration=250;xAxis.orient("bottom").showMaxMin(false).tickFormat(function(d){return d});yAxis.orient(rightAlignYAxis?"right":"left").tickFormat(d3.format(",.1f"));tooltip.duration(0);var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(boxplot);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=(width||parseInt(container.style("width"))||960)-margin.left-margin.right;var availableHeight=(height||parseInt(container.style("height"))||400)-margin.top-margin.bottom;chart.update=function(){dispatch.beforeUpdate();container.transition().duration(duration).call(chart)};chart.container=this;if(!data||!data.length){var noDataText=container.selectAll(".nv-noData").data([noData]);noDataText.enter().append("text").attr("class","nvd3 nv-noData").attr("dy","-.7em").style("text-anchor","middle");noDataText.attr("x",margin.left+availableWidth/2).attr("y",margin.top+availableHeight/2).text(function(d){return d});return chart}else{container.selectAll(".nv-noData").remove()}x=boxplot.xScale();y=boxplot.yScale().clamp(true);var wrap=container.selectAll("g.nv-wrap.nv-boxPlotWithAxes").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-boxPlotWithAxes").append("g");var defsEnter=gEnter.append("defs");var g=wrap.select("g");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis").append("g").attr("class","nv-zeroLine").append("line");gEnter.append("g").attr("class","nv-barsWrap");g.attr("transform","translate("+margin.left+","+margin.top+")");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}boxplot.width(availableWidth).height(availableHeight);var barsWrap=g.select(".nv-barsWrap").datum(data.filter(function(d){return!d.disabled}));barsWrap.transition().call(boxplot);defsEnter.append("clipPath").attr("id","nv-x-label-clip-"+boxplot.id()).append("rect");g.select("#nv-x-label-clip-"+boxplot.id()+" rect").attr("width",x.rangeBand()*(staggerLabels?2:1)).attr("height",16).attr("x",-x.rangeBand()/(staggerLabels?1:2));if(showXAxis){xAxis.scale(x).ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")");g.select(".nv-x.nv-axis").call(xAxis);var xTicks=g.select(".nv-x.nv-axis").selectAll("g");if(staggerLabels){xTicks.selectAll("text").attr("transform",function(d,i,j){return"translate(0,"+(j%2===0?"5":"17")+")"})}}if(showYAxis){yAxis.scale(y).ticks(Math.floor(availableHeight/36)).tickSize(-availableWidth,0);g.select(".nv-y.nv-axis").call(yAxis)}g.select(".nv-zeroLine line").attr("x1",0).attr("x2",availableWidth).attr("y1",y(0)).attr("y2",y(0))});renderWatch.renderEnd("nv-boxplot chart immediate");return chart}boxplot.dispatch.on("elementMouseover.tooltip",function(evt){tooltip.data(evt).hidden(false)});boxplot.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.data(evt).hidden(true)});boxplot.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.dispatch=dispatch;chart.boxplot=boxplot;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},staggerLabels:{get:function(){return staggerLabels},set:function(_){staggerLabels=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},tooltipContent:{get:function(){return tooltip},set:function(_){tooltip=_}},noData:{get:function(){return noData},set:function(_){noData=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);boxplot.duration(duration);xAxis.duration(duration);yAxis.duration(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);boxplot.color(color)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(_?"right":"left")}}});nv.utils.inheritOptions(chart,boxplot);nv.utils.initOptions(chart);return chart};nv.models.bullet=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},orient="left",reverse=false,ranges=function(d){return d.ranges},markers=function(d){return d.markers?d.markers:[]},markerLines=function(d){return d.markerLines?d.markerLines:[0]},measures=function(d){return d.measures},rangeLabels=function(d){return d.rangeLabels?d.rangeLabels:[]},markerLabels=function(d){return d.markerLabels?d.markerLabels:[]},markerLineLabels=function(d){return d.markerLineLabels?d.markerLineLabels:[]},measureLabels=function(d){return d.measureLabels?d.measureLabels:[]},forceX=[0],width=380,height=30,container=null,tickFormat=null,color=nv.utils.getColor(["#1f77b4"]),dispatch=d3.dispatch("elementMouseover","elementMouseout","elementMousemove"),defaultRangeLabels=["Maximum","Mean","Minimum"],legacyRangeClassNames=["Max","Avg","Min"],duration=1e3;function sortLabels(labels,values){var lz=labels.slice();labels.sort(function(a,b){var iA=lz.indexOf(a);var iB=lz.indexOf(b);return d3.descending(values[iA],values[iB])})}function chart(selection){selection.each(function(d,i){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);var rangez=ranges.call(this,d,i).slice(),markerz=markers.call(this,d,i).slice(),markerLinez=markerLines.call(this,d,i).slice(),measurez=measures.call(this,d,i).slice(),rangeLabelz=rangeLabels.call(this,d,i).slice(),markerLabelz=markerLabels.call(this,d,i).slice(),markerLineLabelz=markerLineLabels.call(this,d,i).slice(),measureLabelz=measureLabels.call(this,d,i).slice();sortLabels(rangeLabelz,rangez);sortLabels(markerLabelz,markerz);sortLabels(markerLineLabelz,markerLinez);sortLabels(measureLabelz,measurez);rangez.sort(d3.descending);markerz.sort(d3.descending);markerLinez.sort(d3.descending);measurez.sort(d3.descending);var x1=d3.scale.linear().domain(d3.extent(d3.merge([forceX,rangez]))).range(reverse?[availableWidth,0]:[0,availableWidth]);var x0=this.__chart__||d3.scale.linear().domain([0,Infinity]).range(x1.range());this.__chart__=x1;var rangeMin=d3.min(rangez),rangeMax=d3.max(rangez),rangeAvg=rangez[1];var wrap=container.selectAll("g.nv-wrap.nv-bullet").data([d]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-bullet");var gEnter=wrapEnter.append("g");var g=wrap.select("g");for(var i=0,il=rangez.length;i<il;i++){var rangeClassNames="nv-range nv-range"+i;if(i<=2){rangeClassNames=rangeClassNames+" nv-range"+legacyRangeClassNames[i]}gEnter.append("rect").attr("class",rangeClassNames)}gEnter.append("rect").attr("class","nv-measure");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var w0=function(d){return Math.abs(x0(d)-x0(0))},w1=function(d){return Math.abs(x1(d)-x1(0))};var xp0=function(d){return d<0?x0(d):x0(0)},xp1=function(d){return d<0?x1(d):x1(0)};for(var i=0,il=rangez.length;i<il;i++){var range=rangez[i];g.select("rect.nv-range"+i).datum(range).attr("height",availableHeight).transition().duration(duration).attr("width",w1(range)).attr("x",xp1(range))}g.select("rect.nv-measure").style("fill",color).attr("height",availableHeight/3).attr("y",availableHeight/3).on("mouseover",function(){dispatch.elementMouseover({value:measurez[0],label:measureLabelz[0]||"Current",color:d3.select(this).style("fill")})}).on("mousemove",function(){dispatch.elementMousemove({value:measurez[0],label:measureLabelz[0]||"Current",color:d3.select(this).style("fill")})}).on("mouseout",function(){dispatch.elementMouseout({value:measurez[0],label:measureLabelz[0]||"Current",color:d3.select(this).style("fill")})}).transition().duration(duration).attr("width",measurez<0?x1(0)-x1(measurez[0]):x1(measurez[0])-x1(0)).attr("x",xp1(measurez));var h3=availableHeight/6;var markerData=markerz.map(function(marker,index){return{value:marker,label:markerLabelz[index]}});gEnter.selectAll("path.nv-markerTriangle").data(markerData).enter().append("path").attr("class","nv-markerTriangle").attr("d","M0,"+h3+"L"+h3+","+-h3+" "+-h3+","+-h3+"Z").on("mouseover",function(d){dispatch.elementMouseover({value:d.value,label:d.label||"Previous",color:d3.select(this).style("fill"),pos:[x1(d.value),availableHeight/2]})}).on("mousemove",function(d){dispatch.elementMousemove({value:d.value,label:d.label||"Previous",color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){dispatch.elementMouseout({value:d.value,label:d.label||"Previous",color:d3.select(this).style("fill")})});g.selectAll("path.nv-markerTriangle").data(markerData).transition().duration(duration).attr("transform",function(d){return"translate("+x1(d.value)+","+availableHeight/2+")"});var markerLinesData=markerLinez.map(function(marker,index){return{value:marker,label:markerLineLabelz[index]}});gEnter.selectAll("line.nv-markerLine").data(markerLinesData).enter().append("line").attr("cursor","").attr("class","nv-markerLine").attr("x1",function(d){return x1(d.value)}).attr("y1","2").attr("x2",function(d){return x1(d.value)}).attr("y2",availableHeight-2).on("mouseover",function(d){dispatch.elementMouseover({value:d.value,label:d.label||"Previous",color:d3.select(this).style("fill"),pos:[x1(d.value),availableHeight/2]})}).on("mousemove",function(d){dispatch.elementMousemove({value:d.value,label:d.label||"Previous",color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){dispatch.elementMouseout({value:d.value,label:d.label||"Previous",color:d3.select(this).style("fill")})});g.selectAll("line.nv-markerLine").data(markerLinesData).transition().duration(duration).attr("x1",function(d){return x1(d.value)}).attr("x2",function(d){return x1(d.value)});wrap.selectAll(".nv-range").on("mouseover",function(d,i){var label=rangeLabelz[i]||defaultRangeLabels[i];dispatch.elementMouseover({value:d,label:label,color:d3.select(this).style("fill")})}).on("mousemove",function(){dispatch.elementMousemove({value:measurez[0],label:measureLabelz[0]||"Previous",color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){var label=rangeLabelz[i]||defaultRangeLabels[i];dispatch.elementMouseout({value:d,label:label,color:d3.select(this).style("fill")})})});return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{ranges:{get:function(){return ranges},set:function(_){ranges=_}},markers:{get:function(){return markers},set:function(_){markers=_}},measures:{get:function(){return measures},set:function(_){measures=_}},forceX:{get:function(){return forceX},set:function(_){forceX=_}},width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},tickFormat:{get:function(){return tickFormat},set:function(_){tickFormat=_}},duration:{get:function(){return duration},set:function(_){duration=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},orient:{get:function(){return orient},set:function(_){orient=_;reverse=orient=="right"||orient=="bottom"}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.bulletChart=function(){"use strict";var bullet=nv.models.bullet();var tooltip=nv.models.tooltip();var orient="left",reverse=false,margin={top:5,right:40,bottom:20,left:120},ranges=function(d){return d.ranges},markers=function(d){return d.markers?d.markers:[]},measures=function(d){return d.measures},width=null,height=55,tickFormat=null,ticks=null,noData=null,dispatch=d3.dispatch();tooltip.duration(0).headerEnabled(false);function chart(selection){selection.each(function(d,i){var container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=height-margin.top-margin.bottom,that=this;chart.update=function(){chart(selection)};chart.container=this;if(!d||!ranges.call(this,d,i)){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}var rangez=ranges.call(this,d,i).slice().sort(d3.descending),markerz=markers.call(this,d,i).slice().sort(d3.descending),measurez=measures.call(this,d,i).slice().sort(d3.descending);var wrap=container.selectAll("g.nv-wrap.nv-bulletChart").data([d]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-bulletChart");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-bulletWrap");gEnter.append("g").attr("class","nv-titles");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var x1=d3.scale.linear().domain([0,Math.max(rangez[0],markerz[0]||0,measurez[0])]).range(reverse?[availableWidth,0]:[0,availableWidth]);var x0=this.__chart__||d3.scale.linear().domain([0,Infinity]).range(x1.range());this.__chart__=x1;var w0=function(d){return Math.abs(x0(d)-x0(0))},w1=function(d){return Math.abs(x1(d)-x1(0))};var title=gEnter.select(".nv-titles").append("g").attr("text-anchor","end").attr("transform","translate(-6,"+(height-margin.top-margin.bottom)/2+")");title.append("text").attr("class","nv-title").text(function(d){return d.title});title.append("text").attr("class","nv-subtitle").attr("dy","1em").text(function(d){return d.subtitle});bullet.width(availableWidth).height(availableHeight);var bulletWrap=g.select(".nv-bulletWrap");d3.transition(bulletWrap).call(bullet);var format=tickFormat||x1.tickFormat(availableWidth/100);var tick=g.selectAll("g.nv-tick").data(x1.ticks(ticks?ticks:availableWidth/50),function(d){return this.textContent||format(d)});var tickEnter=tick.enter().append("g").attr("class","nv-tick").attr("transform",function(d){return"translate("+x0(d)+",0)"}).style("opacity",1e-6);tickEnter.append("line").attr("y1",availableHeight).attr("y2",availableHeight*7/6);tickEnter.append("text").attr("text-anchor","middle").attr("dy","1em").attr("y",availableHeight*7/6).text(format);var tickUpdate=d3.transition(tick).transition().duration(bullet.duration()).attr("transform",function(d){return"translate("+x1(d)+",0)"}).style("opacity",1);tickUpdate.select("line").attr("y1",availableHeight).attr("y2",availableHeight*7/6);tickUpdate.select("text").attr("y",availableHeight*7/6);d3.transition(tick.exit()).transition().duration(bullet.duration()).attr("transform",function(d){return"translate("+x1(d)+",0)"}).style("opacity",1e-6).remove()});d3.timer.flush();return chart}bullet.dispatch.on("elementMouseover.tooltip",function(evt){evt["series"]={key:evt.label,value:evt.value,color:evt.color};tooltip.data(evt).hidden(false)});bullet.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bullet.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.bullet=bullet;chart.dispatch=dispatch;
chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{ranges:{get:function(){return ranges},set:function(_){ranges=_}},markers:{get:function(){return markers},set:function(_){markers=_}},measures:{get:function(){return measures},set:function(_){measures=_}},width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},tickFormat:{get:function(){return tickFormat},set:function(_){tickFormat=_}},ticks:{get:function(){return ticks},set:function(_){ticks=_}},noData:{get:function(){return noData},set:function(_){noData=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},orient:{get:function(){return orient},set:function(_){orient=_;reverse=orient=="right"||orient=="bottom"}}});nv.utils.inheritOptions(chart,bullet);nv.utils.initOptions(chart);return chart};nv.models.candlestickBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=null,height=null,id=Math.floor(Math.random()*1e4),container,x=d3.scale.linear(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},getOpen=function(d){return d.open},getClose=function(d){return d.close},getHigh=function(d){return d.high},getLow=function(d){return d.low},forceX=[],forceY=[],padData=false,clipEdge=true,color=nv.utils.defaultColor(),interactive=false,xDomain,yDomain,xRange,yRange,dispatch=d3.dispatch("stateChange","changeState","renderEnd","chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove");function chart(selection){selection.each(function(data){container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);var barWidth=availableWidth/data[0].values.length*.45;x.domain(xDomain||d3.extent(data[0].values.map(getX).concat(forceX)));if(padData)x.range(xRange||[availableWidth*.5/data[0].values.length,availableWidth*(data[0].values.length-.5)/data[0].values.length]);else x.range(xRange||[5+barWidth/2,availableWidth-barWidth/2-5]);y.domain(yDomain||[d3.min(data[0].values.map(getLow).concat(forceY)),d3.max(data[0].values.map(getHigh).concat(forceY))]).range(yRange||[availableHeight,0]);if(x.domain()[0]===x.domain()[1])x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*.01,x.domain()[1]+x.domain()[1]*.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])y.domain()[0]?y.domain([y.domain()[0]+y.domain()[0]*.01,y.domain()[1]-y.domain()[1]*.01]):y.domain([-1,1]);var wrap=d3.select(this).selectAll("g.nv-wrap.nv-candlestickBar").data([data[0].values]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-candlestickBar");var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-ticks");wrap.attr("transform","translate("+margin.left+","+margin.top+")");container.on("click",function(d,i){dispatch.chartClick({data:d,index:i,pos:d3.event,id:id})});defsEnter.append("clipPath").attr("id","nv-chart-clip-path-"+id).append("rect");wrap.select("#nv-chart-clip-path-"+id+" rect").attr("width",availableWidth).attr("height",availableHeight);g.attr("clip-path",clipEdge?"url(#nv-chart-clip-path-"+id+")":"");var ticks=wrap.select(".nv-ticks").selectAll(".nv-tick").data(function(d){return d});ticks.exit().remove();var tickGroups=ticks.enter().append("g");ticks.attr("class",function(d,i,j){return(getOpen(d,i)>getClose(d,i)?"nv-tick negative":"nv-tick positive")+" nv-tick-"+j+"-"+i});var lines=tickGroups.append("line").attr("class","nv-candlestick-lines").attr("transform",function(d,i){return"translate("+x(getX(d,i))+",0)"}).attr("x1",0).attr("y1",function(d,i){return y(getHigh(d,i))}).attr("x2",0).attr("y2",function(d,i){return y(getLow(d,i))});var rects=tickGroups.append("rect").attr("class","nv-candlestick-rects nv-bars").attr("transform",function(d,i){return"translate("+(x(getX(d,i))-barWidth/2)+","+(y(getY(d,i))-(getOpen(d,i)>getClose(d,i)?y(getClose(d,i))-y(getOpen(d,i)):0))+")"}).attr("x",0).attr("y",0).attr("width",barWidth).attr("height",function(d,i){var open=getOpen(d,i);var close=getClose(d,i);return open>close?y(close)-y(open):y(open)-y(close)});ticks.select(".nv-candlestick-lines").transition().attr("transform",function(d,i){return"translate("+x(getX(d,i))+",0)"}).attr("x1",0).attr("y1",function(d,i){return y(getHigh(d,i))}).attr("x2",0).attr("y2",function(d,i){return y(getLow(d,i))});ticks.select(".nv-candlestick-rects").transition().attr("transform",function(d,i){return"translate("+(x(getX(d,i))-barWidth/2)+","+(y(getY(d,i))-(getOpen(d,i)>getClose(d,i)?y(getClose(d,i))-y(getOpen(d,i)):0))+")"}).attr("x",0).attr("y",0).attr("width",barWidth).attr("height",function(d,i){var open=getOpen(d,i);var close=getClose(d,i);return open>close?y(close)-y(open):y(open)-y(close)})});return chart}chart.highlightPoint=function(pointIndex,isHoverOver){chart.clearHighlights();container.select(".nv-candlestickBar .nv-tick-0-"+pointIndex).classed("hover",isHoverOver)};chart.clearHighlights=function(){container.select(".nv-candlestickBar .nv-tick.hover").classed("hover",false)};chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},forceX:{get:function(){return forceX},set:function(_){forceX=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},padData:{get:function(){return padData},set:function(_){padData=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},id:{get:function(){return id},set:function(_){id=_}},interactive:{get:function(){return interactive},set:function(_){interactive=_}},x:{get:function(){return getX},set:function(_){getX=_}},y:{get:function(){return getY},set:function(_){getY=_}},open:{get:function(){return getOpen()},set:function(_){getOpen=_}},close:{get:function(){return getClose()},set:function(_){getClose=_}},high:{get:function(){return getHigh},set:function(_){getHigh=_}},low:{get:function(){return getLow},set:function(_){getLow=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!=undefined?_.top:margin.top;margin.right=_.right!=undefined?_.right:margin.right;margin.bottom=_.bottom!=undefined?_.bottom:margin.bottom;margin.left=_.left!=undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.cumulativeLineChart=function(){"use strict";var lines=nv.models.line(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),controls=nv.models.legend(),interactiveLayer=nv.interactiveGuideline(),tooltip=nv.models.tooltip();var margin={top:30,right:30,bottom:50,left:60},marginTop=null,color=nv.utils.defaultColor(),width=null,height=null,showLegend=true,showXAxis=true,showYAxis=true,rightAlignYAxis=false,showControls=true,useInteractiveGuideline=false,rescaleY=true,x,y,id=lines.id(),state=nv.utils.state(),defaultState=null,noData=null,average=function(d){return d.average},dispatch=d3.dispatch("stateChange","changeState","renderEnd"),transitionDuration=250,duration=250,noErrorCheck=false;state.index=0;state.rescaleY=rescaleY;xAxis.orient("bottom").tickPadding(7);yAxis.orient(rightAlignYAxis?"right":"left");tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});controls.updateState(false);var dx=d3.scale.linear(),index={i:0,x:0},renderWatch=nv.utils.renderWatch(dispatch,duration),currentYDomain;var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled}),index:index.i,rescaleY:rescaleY}}};var stateSetter=function(data){return function(state){if(state.index!==undefined)index.i=state.index;if(state.rescaleY!==undefined)rescaleY=state.rescaleY;if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};function chart(selection){renderWatch.reset();renderWatch.models(lines);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);container.classed("nv-chart-"+id,true);var that=this;var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){if(duration===0)container.call(chart);else container.transition().duration(duration).call(chart)};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}var indexDrag=d3.behavior.drag().on("dragstart",dragStart).on("drag",dragMove).on("dragend",dragEnd);function dragStart(d,i){d3.select(chart.container).style("cursor","ew-resize")}function dragMove(d,i){index.x=d3.event.x;index.i=Math.round(dx.invert(index.x));updateZero()}function dragEnd(d,i){d3.select(chart.container).style("cursor","auto");state.index=index.i;dispatch.stateChange(state)}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}x=lines.xScale();y=lines.yScale();dx.domain([0,data[0].values.length-1]).range([0,availableWidth]).clamp(true);var data=indexify(index.i,data);if(typeof currentYDomain==="undefined"){currentYDomain=getCurrentYDomain(data)}if(!rescaleY){lines.yDomain(currentYDomain);lines.clipEdge(true)}else{lines.yDomain(null)}var interactivePointerEvents=useInteractiveGuideline?"none":"all";var wrap=container.selectAll("g.nv-wrap.nv-cumulativeLine").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-cumulativeLine").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-interactive");gEnter.append("g").attr("class","nv-x nv-axis").style("pointer-events","none");gEnter.append("g").attr("class","nv-y nv-axis");gEnter.append("g").attr("class","nv-background");gEnter.append("g").attr("class","nv-linesWrap").style("pointer-events",interactivePointerEvents);gEnter.append("g").attr("class","nv-avgLinesWrap").style("pointer-events","none");gEnter.append("g").attr("class","nv-legendWrap");gEnter.append("g").attr("class","nv-controlsWrap");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{legend.width(availableWidth);g.select(".nv-legendWrap").datum(data).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}g.select(".nv-legendWrap").attr("transform","translate(0,"+-margin.top+")")}if(!showControls){g.select(".nv-controlsWrap").selectAll("*").remove()}else{var controlsData=[{key:"Re-scale y-axis",disabled:!rescaleY}];controls.width(140).color(["#444","#444","#444"]).rightAlign(false).margin({top:5,right:0,bottom:5,left:20});g.select(".nv-controlsWrap").datum(controlsData).attr("transform","translate(0,"+-margin.top+")").call(controls)}wrap.attr("transform","translate("+margin.left+","+margin.top+")");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}var tempDisabled=data.filter(function(d){return d.tempDisabled});wrap.select(".tempDisabled").remove();if(tempDisabled.length){wrap.append("text").attr("class","tempDisabled").attr("x",availableWidth/2).attr("y","-.71em").style("text-anchor","end").text(tempDisabled.map(function(d){return d.key}).join(", ")+" values cannot be calculated for this time period.")}if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer)}gEnter.select(".nv-background").append("rect");g.select(".nv-background rect").attr("width",availableWidth).attr("height",availableHeight);lines.y(function(d){return d.display.y}).width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled&&!data[i].tempDisabled}));var linesWrap=g.select(".nv-linesWrap").datum(data.filter(function(d){return!d.disabled&&!d.tempDisabled}));linesWrap.call(lines);data.forEach(function(d,i){d.seriesIndex=i});var avgLineData=data.filter(function(d){return!d.disabled&&!!average(d)});var avgLines=g.select(".nv-avgLinesWrap").selectAll("line").data(avgLineData,function(d){return d.key});var getAvgLineY=function(d){var yVal=y(average(d));if(yVal<0)return 0;if(yVal>availableHeight)return availableHeight;return yVal};avgLines.enter().append("line").style("stroke-width",2).style("stroke-dasharray","10,10").style("stroke",function(d,i){return lines.color()(d,d.seriesIndex)}).attr("x1",0).attr("x2",availableWidth).attr("y1",getAvgLineY).attr("y2",getAvgLineY);avgLines.style("stroke-opacity",function(d){var yVal=y(average(d));if(yVal<0||yVal>availableHeight)return 0;return 1}).attr("x1",0).attr("x2",availableWidth).attr("y1",getAvgLineY).attr("y2",getAvgLineY);avgLines.exit().remove();var indexLine=linesWrap.selectAll(".nv-indexLine").data([index]);indexLine.enter().append("rect").attr("class","nv-indexLine").attr("width",3).attr("x",-2).attr("fill","red").attr("fill-opacity",.5).style("pointer-events","all").call(indexDrag);indexLine.attr("transform",function(d){return"translate("+dx(d.i)+",0)"}).attr("height",availableHeight);if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/70,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")");g.select(".nv-x.nv-axis").call(xAxis)}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select(".nv-y.nv-axis").call(yAxis)}function updateZero(){indexLine.data([index]);var oldDuration=chart.duration();chart.duration(0);chart.update();chart.duration(oldDuration)}g.select(".nv-background rect").on("click",function(){index.x=d3.mouse(this)[0];index.i=Math.round(dx.invert(index.x));state.index=index.i;dispatch.stateChange(state);updateZero()});lines.dispatch.on("elementClick",function(e){index.i=e.pointIndex;index.x=dx(index.i);state.index=index.i;dispatch.stateChange(state);updateZero()});controls.dispatch.on("legendClick",function(d,i){d.disabled=!d.disabled;rescaleY=!d.disabled;state.rescaleY=rescaleY;if(!rescaleY){currentYDomain=getCurrentYDomain(data)}dispatch.stateChange(state);chart.update()});legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});interactiveLayer.dispatch.on("elementMousemove",function(e){lines.clearHighlights();var singlePoint,pointIndex,pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!(series.disabled||series.tempDisabled)}).forEach(function(series,i){pointIndex=nv.interactiveBisect(series.values,e.pointXValue,chart.x());lines.highlightPoint(i,pointIndex,true);var point=series.values[pointIndex];if(typeof point==="undefined")return;if(typeof singlePoint==="undefined")singlePoint=point;if(typeof pointXLocation==="undefined")pointXLocation=chart.xScale()(chart.x()(point,pointIndex));allData.push({key:series.key,value:chart.y()(point,pointIndex),color:color(series,series.seriesIndex)})});if(allData.length>2){var yValue=chart.yScale().invert(e.mouseY);var domainExtent=Math.abs(chart.yScale().domain()[0]-chart.yScale().domain()[1]);var threshold=.03*domainExtent;var indexToHighlight=nv.nearestValueIndex(allData.map(function(d){return d.value}),yValue,threshold);if(indexToHighlight!==null)allData[indexToHighlight].highlight=true}var xValue=xAxis.tickFormat()(chart.x()(singlePoint,pointIndex),pointIndex);interactiveLayer.tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d)}).data({value:xValue,series:allData})();interactiveLayer.renderGuideLine(pointXLocation)});interactiveLayer.dispatch.on("elementMouseout",function(e){lines.clearHighlights()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}if(typeof e.index!=="undefined"){index.i=e.index;index.x=dx(index.i);state.index=e.index;indexLine.data([index])}if(typeof e.rescaleY!=="undefined"){rescaleY=e.rescaleY}chart.update()})});renderWatch.renderEnd("cumulativeLineChart immediate");return chart}lines.dispatch.on("elementMouseover.tooltip",function(evt){var point={x:chart.x()(evt.point),y:chart.y()(evt.point),color:evt.point.color};evt.point=point;tooltip.data(evt).hidden(false)});lines.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});var indexifyYGetter=null;function indexify(idx,data){if(!indexifyYGetter)indexifyYGetter=lines.y();return data.map(function(line,i){if(!line.values){return line}var indexValue=line.values[idx];if(indexValue==null){return line}var v=indexifyYGetter(indexValue,idx);if(Math.abs(v)<1e-5&&!noErrorCheck){line.tempDisabled=true;return line}line.tempDisabled=false;line.values=line.values.map(function(point,pointIndex){point.display={y:(indexifyYGetter(point,pointIndex)-v)/v};return point});return line})}function getCurrentYDomain(data){var seriesDomains=data.filter(function(series){return!(series.disabled||series.tempDisabled)}).map(function(series,i){return d3.extent(series.values,function(d){return d.display.y})});return[d3.min(seriesDomains,function(d){return d[0]}),d3.max(seriesDomains,function(d){return d[1]})]}chart.dispatch=dispatch;chart.lines=lines;chart.legend=legend;chart.controls=controls;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.interactiveLayer=interactiveLayer;chart.state=state;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showControls:{get:function(){return showControls},set:function(_){showControls=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},average:{get:function(){return average},set:function(_){average=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},noErrorCheck:{get:function(){return noErrorCheck},set:function(_){noErrorCheck=_}},rescaleY:{get:function(){return rescaleY},set:function(_){rescaleY=_;chart.state.rescaleY=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color)}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline},set:function(_){useInteractiveGuideline=_;if(_===true){chart.interactive(false);chart.useVoronoi(false)}}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(_?"right":"left")}},duration:{get:function(){return duration},set:function(_){duration=_;lines.duration(duration);xAxis.duration(duration);yAxis.duration(duration);renderWatch.reset(duration)}}});nv.utils.inheritOptions(chart,lines);nv.utils.initOptions(chart);return chart};nv.models.discreteBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,id=Math.floor(Math.random()*1e4),container,x=d3.scale.ordinal(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},forceY=[0],color=nv.utils.defaultColor(),showValues=false,valueFormat=d3.format(",.2f"),xDomain,yDomain,xRange,yRange,dispatch=d3.dispatch("chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove","renderEnd"),rectClass="discreteBar",duration=250;var x0,y0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);data.forEach(function(series,i){series.values.forEach(function(point){point.series=i})});var seriesData=xDomain&&yDomain?[]:data.map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),y0:d.y0}})});x.domain(xDomain||d3.merge(seriesData).map(function(d){return d.x})).rangeBands(xRange||[0,availableWidth],.1);y.domain(yDomain||d3.extent(d3.merge(seriesData).map(function(d){return d.y}).concat(forceY)));if(showValues)y.range(yRange||[availableHeight-(y.domain()[0]<0?12:0),y.domain()[1]>0?12:0]);else y.range(yRange||[availableHeight,0]);x0=x0||x;y0=y0||y.copy().range([y(0),y(0)]);var wrap=container.selectAll("g.nv-wrap.nv-discretebar").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-discretebar");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-groups");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var groups=wrap.select(".nv-groups").selectAll(".nv-group").data(function(d){return d},function(d){return d.key});groups.enter().append("g").style("stroke-opacity",1e-6).style("fill-opacity",1e-6);groups.exit().watchTransition(renderWatch,"discreteBar: exit groups").style("stroke-opacity",1e-6).style("fill-opacity",1e-6).remove();groups.attr("class",function(d,i){return"nv-group nv-series-"+i}).classed("hover",function(d){return d.hover});groups.watchTransition(renderWatch,"discreteBar: groups").style("stroke-opacity",1).style("fill-opacity",.75);var bars=groups.selectAll("g.nv-bar").data(function(d){return d.values});bars.exit().remove();var barsEnter=bars.enter().append("g").attr("transform",function(d,i,j){return"translate("+(x(getX(d,i))+x.rangeBand()*.05)+", "+y(0)+")"}).on("mouseover",function(d,i){d3.select(this).classed("hover",true);dispatch.elementMouseover({data:d,index:i,color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){d3.select(this).classed("hover",false);dispatch.elementMouseout({data:d,index:i,color:d3.select(this).style("fill")})}).on("mousemove",function(d,i){dispatch.elementMousemove({data:d,index:i,color:d3.select(this).style("fill")})}).on("click",function(d,i){var element=this;dispatch.elementClick({data:d,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element});d3.event.stopPropagation()}).on("dblclick",function(d,i){dispatch.elementDblClick({data:d,index:i,color:d3.select(this).style("fill")});d3.event.stopPropagation()});barsEnter.append("rect").attr("height",0).attr("width",x.rangeBand()*.9/data.length);if(showValues){barsEnter.append("text").attr("text-anchor","middle");bars.select("text").text(function(d,i){return valueFormat(getY(d,i))}).watchTransition(renderWatch,"discreteBar: bars text").attr("x",x.rangeBand()*.9/2).attr("y",function(d,i){return getY(d,i)<0?y(getY(d,i))-y(0)+12:-4})}else{bars.selectAll("text").remove()}bars.attr("class",function(d,i){return getY(d,i)<0?"nv-bar negative":"nv-bar positive"}).style("fill",function(d,i){return d.color||color(d,i)}).style("stroke",function(d,i){return d.color||color(d,i)}).select("rect").attr("class",rectClass).watchTransition(renderWatch,"discreteBar: bars rect").attr("width",x.rangeBand()*.9/data.length);bars.watchTransition(renderWatch,"discreteBar: bars").attr("transform",function(d,i){var left=x(getX(d,i))+x.rangeBand()*.05,top=getY(d,i)<0?y(0):y(0)-y(getY(d,i))<1?y(0)-1:y(getY(d,i));return"translate("+left+", "+top+")"}).select("rect").attr("height",function(d,i){return Math.max(Math.abs(y(getY(d,i))-y(0)),1)});x0=x.copy();y0=y.copy()});renderWatch.renderEnd("discreteBar immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},showValues:{get:function(){return showValues},set:function(_){showValues=_}},x:{get:function(){return getX},set:function(_){getX=_}},y:{get:function(){return getY},set:function(_){getY=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},valueFormat:{get:function(){return valueFormat},set:function(_){valueFormat=_}},id:{get:function(){return id},set:function(_){id=_}},rectClass:{get:function(){return rectClass},set:function(_){rectClass=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}}});nv.utils.initOptions(chart);return chart};nv.models.discreteBarChart=function(){"use strict";var discretebar=nv.models.discreteBar(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),tooltip=nv.models.tooltip();var margin={top:15,right:10,bottom:50,left:60},marginTop=null,width=null,height=null,color=nv.utils.getColor(),showLegend=false,showXAxis=true,showYAxis=true,rightAlignYAxis=false,staggerLabels=false,wrapLabels=false,rotateLabels=0,x,y,noData=null,dispatch=d3.dispatch("beforeUpdate","renderEnd"),duration=250;xAxis.orient("bottom").showMaxMin(false).tickFormat(function(d){return d});yAxis.orient(rightAlignYAxis?"right":"left").tickFormat(d3.format(",.1f"));tooltip.duration(0).headerEnabled(false).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).keyFormatter(function(d,i){return xAxis.tickFormat()(d,i)});var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(discretebar);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){dispatch.beforeUpdate();container.transition().duration(duration).call(chart)};chart.container=this;if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}x=discretebar.xScale();y=discretebar.yScale().clamp(true);var wrap=container.selectAll("g.nv-wrap.nv-discreteBarWithAxes").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-discreteBarWithAxes").append("g");var defsEnter=gEnter.append("defs");var g=wrap.select("g");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis").append("g").attr("class","nv-zeroLine").append("line");gEnter.append("g").attr("class","nv-barsWrap");gEnter.append("g").attr("class","nv-legendWrap");g.attr("transform","translate("+margin.left+","+margin.top+")");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{legend.width(availableWidth);g.select(".nv-legendWrap").datum(data).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}wrap.select(".nv-legendWrap").attr("transform","translate(0,"+-margin.top+")")}if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}discretebar.width(availableWidth).height(availableHeight);var barsWrap=g.select(".nv-barsWrap").datum(data.filter(function(d){return!d.disabled}));barsWrap.transition().call(discretebar);defsEnter.append("clipPath").attr("id","nv-x-label-clip-"+discretebar.id()).append("rect");g.select("#nv-x-label-clip-"+discretebar.id()+" rect").attr("width",x.rangeBand()*(staggerLabels?2:1)).attr("height",16).attr("x",-x.rangeBand()/(staggerLabels?1:2));if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+(y.range()[0]+(discretebar.showValues()&&y.domain()[0]<0?16:0))+")");g.select(".nv-x.nv-axis").call(xAxis);var xTicks=g.select(".nv-x.nv-axis").selectAll("g");if(staggerLabels){xTicks.selectAll("text").attr("transform",function(d,i,j){return"translate(0,"+(j%2==0?"5":"17")+")"})}if(rotateLabels){xTicks.selectAll(".tick text").attr("transform","rotate("+rotateLabels+" 0,0)").style("text-anchor",rotateLabels>0?"start":"end")}if(wrapLabels){g.selectAll(".tick text").call(nv.utils.wrapTicks,chart.xAxis.rangeBand())}}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select(".nv-y.nv-axis").call(yAxis)}g.select(".nv-zeroLine line").attr("x1",0).attr("x2",rightAlignYAxis?-availableWidth:availableWidth).attr("y1",y(0)).attr("y2",y(0))});renderWatch.renderEnd("discreteBar chart immediate");return chart}discretebar.dispatch.on("elementMouseover.tooltip",function(evt){evt["series"]={key:chart.x()(evt.data),value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false)});discretebar.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});discretebar.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.dispatch=dispatch;chart.discretebar=discretebar;chart.legend=legend;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},staggerLabels:{get:function(){return staggerLabels},set:function(_){staggerLabels=_}},rotateLabels:{get:function(){return rotateLabels},set:function(_){rotateLabels=_}},wrapLabels:{get:function(){return wrapLabels},set:function(_){wrapLabels=!!_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},noData:{get:function(){return noData},set:function(_){noData=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;
margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);discretebar.duration(duration);xAxis.duration(duration);yAxis.duration(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);discretebar.color(color);legend.color(color)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(_?"right":"left")}}});nv.utils.inheritOptions(chart,discretebar);nv.utils.initOptions(chart);return chart};nv.models.distribution=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=400,size=8,axis="x",getData=function(d){return d[axis]},color=nv.utils.defaultColor(),scale=d3.scale.linear(),domain,duration=250,dispatch=d3.dispatch("renderEnd");var scale0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var availableLength=width-(axis==="x"?margin.left+margin.right:margin.top+margin.bottom),naxis=axis=="x"?"y":"x",container=d3.select(this);nv.utils.initSVG(container);scale0=scale0||scale;var wrap=container.selectAll("g.nv-distribution").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-distribution");var gEnter=wrapEnter.append("g");var g=wrap.select("g");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var distWrap=g.selectAll("g.nv-dist").data(function(d){return d},function(d){return d.key});distWrap.enter().append("g");distWrap.attr("class",function(d,i){return"nv-dist nv-series-"+i}).style("stroke",function(d,i){return color(d,i)});var dist=distWrap.selectAll("line.nv-dist"+axis).data(function(d){return d.values});dist.enter().append("line").attr(axis+"1",function(d,i){return scale0(getData(d,i))}).attr(axis+"2",function(d,i){return scale0(getData(d,i))});renderWatch.transition(distWrap.exit().selectAll("line.nv-dist"+axis),"dist exit").attr(axis+"1",function(d,i){return scale(getData(d,i))}).attr(axis+"2",function(d,i){return scale(getData(d,i))}).style("stroke-opacity",0).remove();dist.attr("class",function(d,i){return"nv-dist"+axis+" nv-dist"+axis+"-"+i}).attr(naxis+"1",0).attr(naxis+"2",size);renderWatch.transition(dist,"dist").attr(axis+"1",function(d,i){return scale(getData(d,i))}).attr(axis+"2",function(d,i){return scale(getData(d,i))});scale0=scale.copy()});renderWatch.renderEnd("distribution immediate");return chart}chart.options=nv.utils.optionsFunc.bind(chart);chart.dispatch=dispatch;chart.margin=function(_){if(!arguments.length)return margin;margin.top=typeof _.top!="undefined"?_.top:margin.top;margin.right=typeof _.right!="undefined"?_.right:margin.right;margin.bottom=typeof _.bottom!="undefined"?_.bottom:margin.bottom;margin.left=typeof _.left!="undefined"?_.left:margin.left;return chart};chart.width=function(_){if(!arguments.length)return width;width=_;return chart};chart.axis=function(_){if(!arguments.length)return axis;axis=_;return chart};chart.size=function(_){if(!arguments.length)return size;size=_;return chart};chart.getData=function(_){if(!arguments.length)return getData;getData=d3.functor(_);return chart};chart.scale=function(_){if(!arguments.length)return scale;scale=_;return chart};chart.color=function(_){if(!arguments.length)return color;color=nv.utils.getColor(_);return chart};chart.duration=function(_){if(!arguments.length)return duration;duration=_;renderWatch.reset(duration);return chart};return chart};nv.models.focus=function(content){"use strict";var content=content||nv.models.line(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),brush=d3.svg.brush();var margin={top:10,right:0,bottom:30,left:0},color=nv.utils.defaultColor(),width=null,height=70,showXAxis=true,showYAxis=false,rightAlignYAxis=false,ticks=null,x,y,brushExtent=null,duration=250,dispatch=d3.dispatch("brush","onBrush","renderEnd"),syncBrushing=true;content.interactive(false);content.pointActive(function(d){return false});var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(content);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=height-margin.top-margin.bottom;chart.update=function(){if(duration===0){container.call(chart)}else{container.transition().duration(duration).call(chart)}};chart.container=this;x=content.xScale();y=content.yScale();var wrap=container.selectAll("g.nv-focus").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-focus").append("g");var g=wrap.select("g");wrap.attr("transform","translate("+margin.left+","+margin.top+")");gEnter.append("g").attr("class","nv-background").append("rect");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis");gEnter.append("g").attr("class","nv-contentWrap");gEnter.append("g").attr("class","nv-brushBackground");gEnter.append("g").attr("class","nv-x nv-brush");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}g.select(".nv-background rect").attr("width",availableWidth).attr("height",availableHeight);content.width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));var contentWrap=g.select(".nv-contentWrap").datum(data.filter(function(d){return!d.disabled}));d3.transition(contentWrap).call(content);brush.x(x).on("brush",function(){onBrush(syncBrushing)});brush.on("brushend",function(){if(!syncBrushing){dispatch.onBrush(brush.empty()?x.domain():brush.extent())}});if(brushExtent)brush.extent(brushExtent);var brushBG=g.select(".nv-brushBackground").selectAll("g").data([brushExtent||brush.extent()]);var brushBGenter=brushBG.enter().append("g");brushBGenter.append("rect").attr("class","left").attr("x",0).attr("y",0).attr("height",availableHeight);brushBGenter.append("rect").attr("class","right").attr("x",0).attr("y",0).attr("height",availableHeight);var gBrush=g.select(".nv-x.nv-brush").call(brush);gBrush.selectAll("rect").attr("height",availableHeight);gBrush.selectAll(".resize").append("path").attr("d",resizePath);onBrush(true);g.select(".nv-background rect").attr("width",availableWidth).attr("height",availableHeight);if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")");d3.transition(g.select(".nv-x.nv-axis")).call(xAxis)}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);d3.transition(g.select(".nv-y.nv-axis")).call(yAxis)}g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")");function resizePath(d){var e=+(d=="e"),x=e?1:-1,y=availableHeight/3;return"M"+.5*x+","+y+"A6,6 0 0 "+e+" "+6.5*x+","+(y+6)+"V"+(2*y-6)+"A6,6 0 0 "+e+" "+.5*x+","+2*y+"Z"+"M"+2.5*x+","+(y+8)+"V"+(2*y-8)+"M"+4.5*x+","+(y+8)+"V"+(2*y-8)}function updateBrushBG(){if(!brush.empty())brush.extent(brushExtent);brushBG.data([brush.empty()?x.domain():brushExtent]).each(function(d,i){var leftWidth=x(d[0])-x.range()[0],rightWidth=availableWidth-x(d[1]);d3.select(this).select(".left").attr("width",leftWidth<0?0:leftWidth);d3.select(this).select(".right").attr("x",x(d[1])).attr("width",rightWidth<0?0:rightWidth)})}function onBrush(shouldDispatch){brushExtent=brush.empty()?null:brush.extent();var extent=brush.empty()?x.domain():brush.extent();dispatch.brush({extent:extent,brush:brush});updateBrushBG();if(shouldDispatch){dispatch.onBrush(extent)}}});renderWatch.renderEnd("focus immediate");return chart}chart.dispatch=dispatch;chart.content=content;chart.brush=brush;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},brushExtent:{get:function(){return brushExtent},set:function(_){brushExtent=_}},syncBrushing:{get:function(){return syncBrushing},set:function(_){syncBrushing=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);content.duration(duration);xAxis.duration(duration);yAxis.duration(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);content.color(color)}},interpolate:{get:function(){return content.interpolate()},set:function(_){content.interpolate(_)}},xTickFormat:{get:function(){return xAxis.tickFormat()},set:function(_){xAxis.tickFormat(_)}},yTickFormat:{get:function(){return yAxis.tickFormat()},set:function(_){yAxis.tickFormat(_)}},x:{get:function(){return content.x()},set:function(_){content.x(_)}},y:{get:function(){return content.y()},set:function(_){content.y(_)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(rightAlignYAxis?"right":"left")}}});nv.utils.inheritOptions(chart,content);nv.utils.initOptions(chart);return chart};nv.models.forceDirectedGraph=function(){"use strict";var margin={top:2,right:0,bottom:2,left:0},width=400,height=32,container=null,dispatch=d3.dispatch("renderEnd"),color=nv.utils.getColor(["#000"]),tooltip=nv.models.tooltip(),noData=null,linkStrength=.1,friction=.9,linkDist=30,charge=-120,gravity=.1,theta=.8,alpha=.1,radius=5,nodeExtras=function(nodes){},linkExtras=function(links){},getX=d3.functor(0),getY=d3.functor(0);var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();selection.each(function(data){container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);container.attr("width",availableWidth).attr("height",availableHeight);if(!data||!data.links||!data.nodes){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}container.selectAll("*").remove();var nodeFieldSet=new Set;data.nodes.forEach(function(node){var keys=Object.keys(node);keys.forEach(function(key){nodeFieldSet.add(key)})});var force=d3.layout.force().nodes(data.nodes).links(data.links).size([availableWidth,availableHeight]).linkStrength(linkStrength).friction(friction).linkDistance(linkDist).charge(charge).gravity(gravity).theta(theta).alpha(alpha).start();var link=container.selectAll(".link").data(data.links).enter().append("line").attr("class","nv-force-link").style("stroke-width",function(d){return Math.sqrt(d.value)});var node=container.selectAll(".node").data(data.nodes).enter().append("g").attr("class","nv-force-node").call(force.drag);node.append("circle").attr("r",radius).style("fill",function(d){return color(d)}).on("mouseover",function(evt){container.select(".nv-series-"+evt.seriesIndex+" .nv-distx-"+evt.pointIndex).attr("y1",evt.py);container.select(".nv-series-"+evt.seriesIndex+" .nv-disty-"+evt.pointIndex).attr("x2",evt.px);var nodeColor=color(evt);evt.series=[];nodeFieldSet.forEach(function(field){evt.series.push({color:nodeColor,key:field,value:evt[field]})});tooltip.data(evt).hidden(false)}).on("mouseout",function(d){tooltip.hidden(true)});tooltip.headerFormatter(function(d){return"Node"});linkExtras(link);nodeExtras(node);force.on("tick",function(){link.attr("x1",function(d){return d.source.x}).attr("y1",function(d){return d.source.y}).attr("x2",function(d){return d.target.x}).attr("y2",function(d){return d.target.y});node.attr("transform",function(d){return"translate("+d.x+", "+d.y+")"})})});return chart}chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},linkStrength:{get:function(){return linkStrength},set:function(_){linkStrength=_}},friction:{get:function(){return friction},set:function(_){friction=_}},linkDist:{get:function(){return linkDist},set:function(_){linkDist=_}},charge:{get:function(){return charge},set:function(_){charge=_}},gravity:{get:function(){return gravity},set:function(_){gravity=_}},theta:{get:function(){return theta},set:function(_){theta=_}},alpha:{get:function(){return alpha},set:function(_){alpha=_}},radius:{get:function(){return radius},set:function(_){radius=_}},x:{get:function(){return getX},set:function(_){getX=d3.functor(_)}},y:{get:function(){return getY},set:function(_){getY=d3.functor(_)}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},noData:{get:function(){return noData},set:function(_){noData=_}},nodeExtras:{get:function(){return nodeExtras},set:function(_){nodeExtras=_}},linkExtras:{get:function(){return linkExtras},set:function(_){linkExtras=_}}});chart.dispatch=dispatch;chart.tooltip=tooltip;nv.utils.initOptions(chart);return chart};nv.models.furiousLegend=function(){"use strict";var margin={top:5,right:0,bottom:5,left:0},width=400,height=20,getKey=function(d){return d.key},keyFormatter=function(d){return d},color=nv.utils.getColor(),maxKeyLength=20,align=true,padding=28,rightAlign=true,updateState=true,radioButtonMode=false,expanded=false,dispatch=d3.dispatch("legendClick","legendDblclick","legendMouseover","legendMouseout","stateChange"),vers="classic";function chart(selection){selection.each(function(data){var availableWidth=width-margin.left-margin.right,container=d3.select(this);nv.utils.initSVG(container);var wrap=container.selectAll("g.nv-legend").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-legend").append("g");var g=wrap.select("g");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var series=g.selectAll(".nv-series").data(function(d){if(vers!="furious")return d;return d.filter(function(n){return expanded?true:!n.disengaged})});var seriesEnter=series.enter().append("g").attr("class","nv-series");var seriesShape;if(vers=="classic"){seriesEnter.append("circle").style("stroke-width",2).attr("class","nv-legend-symbol").attr("r",5);seriesShape=series.select("circle")}else if(vers=="furious"){seriesEnter.append("rect").style("stroke-width",2).attr("class","nv-legend-symbol").attr("rx",3).attr("ry",3);seriesShape=series.select("rect");seriesEnter.append("g").attr("class","nv-check-box").property("innerHTML",'<path d="M0.5,5 L22.5,5 L22.5,26.5 L0.5,26.5 L0.5,5 Z" class="nv-box"></path><path d="M5.5,12.8618467 L11.9185089,19.2803556 L31,0.198864511" class="nv-check"></path>').attr("transform","translate(-10,-8)scale(0.5)");var seriesCheckbox=series.select(".nv-check-box");seriesCheckbox.each(function(d,i){d3.select(this).selectAll("path").attr("stroke",setTextColor(d,i))})}seriesEnter.append("text").attr("text-anchor","start").attr("class","nv-legend-text").attr("dy",".32em").attr("dx","8");var seriesText=series.select("text.nv-legend-text");series.on("mouseover",function(d,i){dispatch.legendMouseover(d,i)}).on("mouseout",function(d,i){dispatch.legendMouseout(d,i)}).on("click",function(d,i){dispatch.legendClick(d,i);var data=series.data();if(updateState){if(vers=="classic"){if(radioButtonMode){data.forEach(function(series){series.disabled=true});d.disabled=false}else{d.disabled=!d.disabled;if(data.every(function(series){return series.disabled})){data.forEach(function(series){series.disabled=false})}}}else if(vers=="furious"){if(expanded){d.disengaged=!d.disengaged;d.userDisabled=d.userDisabled==undefined?!!d.disabled:d.userDisabled;d.disabled=d.disengaged||d.userDisabled}else if(!expanded){d.disabled=!d.disabled;d.userDisabled=d.disabled;var engaged=data.filter(function(d){return!d.disengaged});if(engaged.every(function(series){return series.userDisabled})){data.forEach(function(series){series.disabled=series.userDisabled=false})}}}dispatch.stateChange({disabled:data.map(function(d){return!!d.disabled}),disengaged:data.map(function(d){return!!d.disengaged})})}}).on("dblclick",function(d,i){if(vers=="furious"&&expanded)return;dispatch.legendDblclick(d,i);if(updateState){var data=series.data();data.forEach(function(series){series.disabled=true;if(vers=="furious")series.userDisabled=series.disabled});d.disabled=false;if(vers=="furious")d.userDisabled=d.disabled;dispatch.stateChange({disabled:data.map(function(d){return!!d.disabled})})}});series.classed("nv-disabled",function(d){return d.userDisabled});series.exit().remove();seriesText.attr("fill",setTextColor).text(function(d){return keyFormatter(getKey(d))});var versPadding;switch(vers){case"furious":versPadding=23;break;case"classic":versPadding=20}if(align){var seriesWidths=[];series.each(function(d,i){var legendText;if(keyFormatter(getKey(d))&&keyFormatter(getKey(d)).length>maxKeyLength){var trimmedKey=keyFormatter(getKey(d)).substring(0,maxKeyLength);legendText=d3.select(this).select("text").text(trimmedKey+"...");d3.select(this).append("svg:title").text(keyFormatter(getKey(d)))}else{legendText=d3.select(this).select("text")}var nodeTextLength;try{nodeTextLength=legendText.node().getComputedTextLength();if(nodeTextLength<=0)throw Error()}catch(e){nodeTextLength=nv.utils.calcApproxTextWidth(legendText)}seriesWidths.push(nodeTextLength+padding)});var seriesPerRow=0;var legendWidth=0;var columnWidths=[];while(legendWidth<availableWidth&&seriesPerRow<seriesWidths.length){columnWidths[seriesPerRow]=seriesWidths[seriesPerRow];legendWidth+=seriesWidths[seriesPerRow++]}if(seriesPerRow===0)seriesPerRow=1;while(legendWidth>availableWidth&&seriesPerRow>1){columnWidths=[];seriesPerRow--;for(var k=0;k<seriesWidths.length;k++){if(seriesWidths[k]>(columnWidths[k%seriesPerRow]||0))columnWidths[k%seriesPerRow]=seriesWidths[k]}legendWidth=columnWidths.reduce(function(prev,cur,index,array){return prev+cur})}var xPositions=[];for(var i=0,curX=0;i<seriesPerRow;i++){xPositions[i]=curX;curX+=columnWidths[i]}series.attr("transform",function(d,i){return"translate("+xPositions[i%seriesPerRow]+","+(5+Math.floor(i/seriesPerRow)*versPadding)+")"});if(rightAlign){g.attr("transform","translate("+(width-margin.right-legendWidth)+","+margin.top+")")}else{g.attr("transform","translate(0"+","+margin.top+")")}height=margin.top+margin.bottom+Math.ceil(seriesWidths.length/seriesPerRow)*versPadding}else{var ypos=5,newxpos=5,maxwidth=0,xpos;series.attr("transform",function(d,i){var length=d3.select(this).select("text").node().getComputedTextLength()+padding;xpos=newxpos;if(width<margin.left+margin.right+xpos+length){newxpos=xpos=5;ypos+=versPadding}newxpos+=length;if(newxpos>maxwidth)maxwidth=newxpos;return"translate("+xpos+","+ypos+")"});g.attr("transform","translate("+(width-margin.right-maxwidth)+","+margin.top+")");height=margin.top+margin.bottom+ypos+15}if(vers=="furious"){seriesShape.attr("width",function(d,i){return seriesText[0][i].getComputedTextLength()+27}).attr("height",18).attr("y",-9).attr("x",-15)}seriesShape.style("fill",setBGColor).style("stroke",function(d,i){return d.color||color(d,i)})});function setTextColor(d,i){if(vers!="furious")return"#000";if(expanded){return d.disengaged?color(d,i):"#fff"}else if(!expanded){return!!d.disabled?color(d,i):"#fff"}}function setBGColor(d,i){if(expanded&&vers=="furious"){return d.disengaged?"#fff":color(d,i)}else{return!!d.disabled?"#fff":color(d,i)}}return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},key:{get:function(){return getKey},set:function(_){getKey=_}},keyFormatter:{get:function(){return keyFormatter},set:function(_){keyFormatter=_}},align:{get:function(){return align},set:function(_){align=_}},rightAlign:{get:function(){return rightAlign},set:function(_){rightAlign=_}},maxKeyLength:{get:function(){return maxKeyLength},set:function(_){maxKeyLength=_}},padding:{get:function(){return padding},set:function(_){padding=_}},updateState:{get:function(){return updateState},set:function(_){updateState=_}},radioButtonMode:{get:function(){return radioButtonMode},set:function(_){radioButtonMode=_}},expanded:{get:function(){return expanded},set:function(_){expanded=_}},vers:{get:function(){return vers},set:function(_){vers=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.historicalBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=null,height=null,id=Math.floor(Math.random()*1e4),container=null,x=d3.scale.linear(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},forceX=[],forceY=[0],padData=false,clipEdge=true,color=nv.utils.defaultColor(),xDomain,yDomain,xRange,yRange,dispatch=d3.dispatch("chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove","renderEnd"),interactive=true;var renderWatch=nv.utils.renderWatch(dispatch,0);function chart(selection){selection.each(function(data){renderWatch.reset();container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);x.domain(xDomain||d3.extent(data[0].values.map(getX).concat(forceX)));if(padData)x.range(xRange||[availableWidth*.5/data[0].values.length,availableWidth*(data[0].values.length-.5)/data[0].values.length]);else x.range(xRange||[0,availableWidth]);y.domain(yDomain||d3.extent(data[0].values.map(getY).concat(forceY))).range(yRange||[availableHeight,0]);if(x.domain()[0]===x.domain()[1])x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*.01,x.domain()[1]+x.domain()[1]*.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])y.domain()[0]?y.domain([y.domain()[0]+y.domain()[0]*.01,y.domain()[1]-y.domain()[1]*.01]):y.domain([-1,1]);var wrap=container.selectAll("g.nv-wrap.nv-historicalBar-"+id).data([data[0].values]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-historicalBar-"+id);var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-bars");wrap.attr("transform","translate("+margin.left+","+margin.top+")");container.on("click",function(d,i){dispatch.chartClick({data:d,index:i,pos:d3.event,id:id})});defsEnter.append("clipPath").attr("id","nv-chart-clip-path-"+id).append("rect");wrap.select("#nv-chart-clip-path-"+id+" rect").attr("width",availableWidth).attr("height",availableHeight);g.attr("clip-path",clipEdge?"url(#nv-chart-clip-path-"+id+")":"");var bars=wrap.select(".nv-bars").selectAll(".nv-bar").data(function(d){return d},function(d,i){return getX(d,i)});bars.exit().remove();bars.enter().append("rect").attr("x",0).attr("y",function(d,i){return nv.utils.NaNtoZero(y(Math.max(0,getY(d,i))))}).attr("height",function(d,i){return nv.utils.NaNtoZero(Math.abs(y(getY(d,i))-y(0)))}).attr("transform",function(d,i){return"translate("+(x(getX(d,i))-availableWidth/data[0].values.length*.45)+",0)"}).on("mouseover",function(d,i){if(!interactive)return;d3.select(this).classed("hover",true);dispatch.elementMouseover({data:d,index:i,color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){if(!interactive)return;d3.select(this).classed("hover",false);dispatch.elementMouseout({data:d,index:i,color:d3.select(this).style("fill")})}).on("mousemove",function(d,i){if(!interactive)return;dispatch.elementMousemove({data:d,index:i,color:d3.select(this).style("fill")})}).on("click",function(d,i){if(!interactive)return;var element=this;dispatch.elementClick({data:d,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element});d3.event.stopPropagation()}).on("dblclick",function(d,i){if(!interactive)return;dispatch.elementDblClick({data:d,index:i,color:d3.select(this).style("fill")});d3.event.stopPropagation()});bars.attr("fill",function(d,i){return color(d,i)}).attr("class",function(d,i,j){return(getY(d,i)<0?"nv-bar negative":"nv-bar positive")+" nv-bar-"+j+"-"+i}).watchTransition(renderWatch,"bars").attr("transform",function(d,i){return"translate("+(x(getX(d,i))-availableWidth/data[0].values.length*.45)+",0)"}).attr("width",availableWidth/data[0].values.length*.9);bars.watchTransition(renderWatch,"bars").attr("y",function(d,i){var rval=getY(d,i)<0?y(0):y(0)-y(getY(d,i))<1?y(0)-1:y(getY(d,i));return nv.utils.NaNtoZero(rval)}).attr("height",function(d,i){return nv.utils.NaNtoZero(Math.max(Math.abs(y(getY(d,i))-y(0)),1))})});renderWatch.renderEnd("historicalBar immediate");return chart}chart.highlightPoint=function(pointIndex,isHoverOver){container.select(".nv-bars .nv-bar-0-"+pointIndex).classed("hover",isHoverOver)};chart.clearHighlights=function(){container.select(".nv-bars .nv-bar.hover").classed("hover",false)};chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},forceX:{get:function(){return forceX},set:function(_){forceX=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},padData:{get:function(){return padData},set:function(_){padData=_}},x:{get:function(){return getX},set:function(_){getX=_}},y:{get:function(){return getY},set:function(_){getY=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},id:{get:function(){return id},set:function(_){id=_}},interactive:{get:function(){return interactive},set:function(_){interactive=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.historicalBarChart=function(bar_model){"use strict";var bars=bar_model||nv.models.historicalBar(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),interactiveLayer=nv.interactiveGuideline(),tooltip=nv.models.tooltip();var margin={top:30,right:90,bottom:50,left:90},marginTop=null,color=nv.utils.defaultColor(),width=null,height=null,showLegend=false,showXAxis=true,showYAxis=true,rightAlignYAxis=false,useInteractiveGuideline=false,x,y,state={},defaultState=null,noData=null,dispatch=d3.dispatch("tooltipHide","stateChange","changeState","renderEnd"),transitionDuration=250;xAxis.orient("bottom").tickPadding(7);yAxis.orient(rightAlignYAxis?"right":"left");tooltip.duration(0).headerEnabled(false).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});var renderWatch=nv.utils.renderWatch(dispatch,0);function chart(selection){selection.each(function(data){renderWatch.reset();renderWatch.models(bars);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){container.transition().duration(transitionDuration).call(chart)};chart.container=this;state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}x=bars.xScale();y=bars.yScale();var wrap=container.selectAll("g.nv-wrap.nv-historicalBarChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-historicalBarChart").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis");gEnter.append("g").attr("class","nv-barsWrap");gEnter.append("g").attr("class","nv-legendWrap");gEnter.append("g").attr("class","nv-interactive");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{legend.width(availableWidth);g.select(".nv-legendWrap").datum(data).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}wrap.select(".nv-legendWrap").attr("transform","translate(0,"+-margin.top+")")}wrap.attr("transform","translate("+margin.left+","+margin.top+")");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer)}bars.width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));var barsWrap=g.select(".nv-barsWrap").datum(data.filter(function(d){return!d.disabled}));barsWrap.transition().call(bars);if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")");g.select(".nv-x.nv-axis").transition().call(xAxis)}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select(".nv-y.nv-axis").transition().call(yAxis)}interactiveLayer.dispatch.on("elementMousemove",function(e){bars.clearHighlights();var singlePoint,pointIndex,pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled}).forEach(function(series,i){pointIndex=nv.interactiveBisect(series.values,e.pointXValue,chart.x());bars.highlightPoint(pointIndex,true);var point=series.values[pointIndex];if(point===undefined)return;if(singlePoint===undefined)singlePoint=point;if(pointXLocation===undefined)pointXLocation=chart.xScale()(chart.x()(point,pointIndex));allData.push({key:series.key,value:chart.y()(point,pointIndex),color:color(series,series.seriesIndex),data:series.values[pointIndex]})});var xValue=xAxis.tickFormat()(chart.x()(singlePoint,pointIndex));interactiveLayer.tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d)}).data({value:xValue,index:pointIndex,series:allData})();interactiveLayer.renderGuideLine(pointXLocation)});interactiveLayer.dispatch.on("elementMouseout",function(e){dispatch.tooltipHide();
bars.clearHighlights()});legend.dispatch.on("legendClick",function(d,i){d.disabled=!d.disabled;if(!data.filter(function(d){return!d.disabled}).length){data.map(function(d){d.disabled=false;wrap.selectAll(".nv-series").classed("disabled",false);return d})}state.disabled=data.map(function(d){return!!d.disabled});dispatch.stateChange(state);selection.transition().call(chart)});legend.dispatch.on("legendDblclick",function(d){data.forEach(function(d){d.disabled=true});d.disabled=false;state.disabled=data.map(function(d){return!!d.disabled});dispatch.stateChange(state);chart.update()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}chart.update()})});renderWatch.renderEnd("historicalBarChart immediate");return chart}bars.dispatch.on("elementMouseover.tooltip",function(evt){evt["series"]={key:chart.x()(evt.data),value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false)});bars.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bars.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.dispatch=dispatch;chart.bars=bars;chart.legend=legend;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.interactiveLayer=interactiveLayer;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color);bars.color(color)}},duration:{get:function(){return transitionDuration},set:function(_){transitionDuration=_;renderWatch.reset(transitionDuration);yAxis.duration(transitionDuration);xAxis.duration(transitionDuration)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(_?"right":"left")}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline},set:function(_){useInteractiveGuideline=_;if(_===true){chart.interactive(false)}}}});nv.utils.inheritOptions(chart,bars);nv.utils.initOptions(chart);return chart};nv.models.ohlcBarChart=function(){var chart=nv.models.historicalBarChart(nv.models.ohlcBar());chart.useInteractiveGuideline(true);chart.interactiveLayer.tooltip.contentGenerator(function(data){var d=data.series[0].data;var color=d.open<d.close?"2ca02c":"d62728";return""+'<h3 style="color: #'+color+'">'+data.value+"</h3>"+"<table>"+"<tr><td>open:</td><td>"+chart.yAxis.tickFormat()(d.open)+"</td></tr>"+"<tr><td>close:</td><td>"+chart.yAxis.tickFormat()(d.close)+"</td></tr>"+"<tr><td>high</td><td>"+chart.yAxis.tickFormat()(d.high)+"</td></tr>"+"<tr><td>low:</td><td>"+chart.yAxis.tickFormat()(d.low)+"</td></tr>"+"</table>"});return chart};nv.models.candlestickBarChart=function(){var chart=nv.models.historicalBarChart(nv.models.candlestickBar());chart.useInteractiveGuideline(true);chart.interactiveLayer.tooltip.contentGenerator(function(data){var d=data.series[0].data;var color=d.open<d.close?"2ca02c":"d62728";return""+'<h3 style="color: #'+color+'">'+data.value+"</h3>"+"<table>"+"<tr><td>open:</td><td>"+chart.yAxis.tickFormat()(d.open)+"</td></tr>"+"<tr><td>close:</td><td>"+chart.yAxis.tickFormat()(d.close)+"</td></tr>"+"<tr><td>high</td><td>"+chart.yAxis.tickFormat()(d.high)+"</td></tr>"+"<tr><td>low:</td><td>"+chart.yAxis.tickFormat()(d.low)+"</td></tr>"+"</table>"});return chart};nv.models.legend=function(){"use strict";var margin={top:5,right:0,bottom:5,left:0},width=400,height=20,getKey=function(d){return d.key},keyFormatter=function(d){return d},color=nv.utils.getColor(),maxKeyLength=20,align=true,padding=32,rightAlign=true,updateState=true,enableDoubleClick=true,radioButtonMode=false,expanded=false,dispatch=d3.dispatch("legendClick","legendDblclick","legendMouseover","legendMouseout","stateChange"),vers="classic";function chart(selection){selection.each(function(data){var availableWidth=width-margin.left-margin.right,container=d3.select(this);nv.utils.initSVG(container);var wrap=container.selectAll("g.nv-legend").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-legend").append("g");var g=wrap.select("g");if(rightAlign)wrap.attr("transform","translate("+-margin.right+","+margin.top+")");else wrap.attr("transform","translate("+margin.left+","+margin.top+")");var series=g.selectAll(".nv-series").data(function(d){if(vers!="furious")return d;return d.filter(function(n){return expanded?true:!n.disengaged})});var seriesEnter=series.enter().append("g").attr("class","nv-series");var seriesShape;var versPadding;switch(vers){case"furious":versPadding=23;break;case"classic":versPadding=20}if(vers=="classic"){seriesEnter.append("circle").style("stroke-width",2).attr("class","nv-legend-symbol").attr("r",5);seriesShape=series.select(".nv-legend-symbol")}else if(vers=="furious"){seriesEnter.append("rect").style("stroke-width",2).attr("class","nv-legend-symbol").attr("rx",3).attr("ry",3);seriesShape=series.select(".nv-legend-symbol");seriesEnter.append("g").attr("class","nv-check-box").property("innerHTML",'<path d="M0.5,5 L22.5,5 L22.5,26.5 L0.5,26.5 L0.5,5 Z" class="nv-box"></path><path d="M5.5,12.8618467 L11.9185089,19.2803556 L31,0.198864511" class="nv-check"></path>').attr("transform","translate(-10,-8)scale(0.5)");var seriesCheckbox=series.select(".nv-check-box");seriesCheckbox.each(function(d,i){d3.select(this).selectAll("path").attr("stroke",setTextColor(d,i))})}seriesEnter.append("text").attr("text-anchor","start").attr("class","nv-legend-text").attr("dy",".32em").attr("dx","8");var seriesText=series.select("text.nv-legend-text");series.on("mouseover",function(d,i){dispatch.legendMouseover(d,i)}).on("mouseout",function(d,i){dispatch.legendMouseout(d,i)}).on("click",function(d,i){dispatch.legendClick(d,i);var data=series.data();if(updateState){if(vers=="classic"){if(radioButtonMode){data.forEach(function(series){series.disabled=true});d.disabled=false}else{d.disabled=!d.disabled;if(data.every(function(series){return series.disabled})){data.forEach(function(series){series.disabled=false})}}}else if(vers=="furious"){if(expanded){d.disengaged=!d.disengaged;d.userDisabled=d.userDisabled==undefined?!!d.disabled:d.userDisabled;d.disabled=d.disengaged||d.userDisabled}else if(!expanded){d.disabled=!d.disabled;d.userDisabled=d.disabled;var engaged=data.filter(function(d){return!d.disengaged});if(engaged.every(function(series){return series.userDisabled})){data.forEach(function(series){series.disabled=series.userDisabled=false})}}}dispatch.stateChange({disabled:data.map(function(d){return!!d.disabled}),disengaged:data.map(function(d){return!!d.disengaged})})}}).on("dblclick",function(d,i){if(enableDoubleClick){if(vers=="furious"&&expanded)return;dispatch.legendDblclick(d,i);if(updateState){var data=series.data();data.forEach(function(series){series.disabled=true;if(vers=="furious")series.userDisabled=series.disabled});d.disabled=false;if(vers=="furious")d.userDisabled=d.disabled;dispatch.stateChange({disabled:data.map(function(d){return!!d.disabled})})}}});series.classed("nv-disabled",function(d){return d.userDisabled});series.exit().remove();seriesText.attr("fill",setTextColor).text(function(d){return keyFormatter(getKey(d))});var legendWidth=0;if(align){var seriesWidths=[];series.each(function(d,i){var legendText;if(keyFormatter(getKey(d))&&keyFormatter(getKey(d)).length>maxKeyLength){var trimmedKey=keyFormatter(getKey(d)).substring(0,maxKeyLength);legendText=d3.select(this).select("text").text(trimmedKey+"...");d3.select(this).append("svg:title").text(keyFormatter(getKey(d)))}else{legendText=d3.select(this).select("text")}var nodeTextLength;try{nodeTextLength=legendText.node().getComputedTextLength();if(nodeTextLength<=0)throw Error()}catch(e){nodeTextLength=nv.utils.calcApproxTextWidth(legendText)}seriesWidths.push(nodeTextLength+padding)});var seriesPerRow=0;var columnWidths=[];legendWidth=0;while(legendWidth<availableWidth&&seriesPerRow<seriesWidths.length){columnWidths[seriesPerRow]=seriesWidths[seriesPerRow];legendWidth+=seriesWidths[seriesPerRow++]}if(seriesPerRow===0)seriesPerRow=1;while(legendWidth>availableWidth&&seriesPerRow>1){columnWidths=[];seriesPerRow--;for(var k=0;k<seriesWidths.length;k++){if(seriesWidths[k]>(columnWidths[k%seriesPerRow]||0))columnWidths[k%seriesPerRow]=seriesWidths[k]}legendWidth=columnWidths.reduce(function(prev,cur,index,array){return prev+cur})}var xPositions=[];for(var i=0,curX=0;i<seriesPerRow;i++){xPositions[i]=curX;curX+=columnWidths[i]}series.attr("transform",function(d,i){return"translate("+xPositions[i%seriesPerRow]+","+(5+Math.floor(i/seriesPerRow)*versPadding)+")"});if(rightAlign){g.attr("transform","translate("+(width-margin.right-legendWidth)+","+margin.top+")")}else{g.attr("transform","translate(0"+","+margin.top+")")}height=margin.top+margin.bottom+Math.ceil(seriesWidths.length/seriesPerRow)*versPadding}else{var ypos=5,newxpos=5,maxwidth=0,xpos;series.attr("transform",function(d,i){var length=d3.select(this).select("text").node().getComputedTextLength()+padding;xpos=newxpos;if(width<margin.left+margin.right+xpos+length){newxpos=xpos=5;ypos+=versPadding}newxpos+=length;if(newxpos>maxwidth)maxwidth=newxpos;if(legendWidth<xpos+maxwidth){legendWidth=xpos+maxwidth}return"translate("+xpos+","+ypos+")"});g.attr("transform","translate("+(width-margin.right-maxwidth)+","+margin.top+")");height=margin.top+margin.bottom+ypos+15}if(vers=="furious"){seriesShape.attr("width",function(d,i){return seriesText[0][i].getComputedTextLength()+27}).attr("height",18).attr("y",-9).attr("x",-15);gEnter.insert("rect",":first-child").attr("class","nv-legend-bg").attr("fill","#eee").attr("opacity",0);var seriesBG=g.select(".nv-legend-bg");seriesBG.transition().duration(300).attr("x",-versPadding).attr("width",legendWidth+versPadding-12).attr("height",height+10).attr("y",-margin.top-10).attr("opacity",expanded?1:0)}seriesShape.style("fill",setBGColor).style("fill-opacity",setBGOpacity).style("stroke",setBGColor)});function setTextColor(d,i){if(vers!="furious")return"#000";if(expanded){return d.disengaged?"#000":"#fff"}else if(!expanded){if(!d.color)d.color=color(d,i);return!!d.disabled?d.color:"#fff"}}function setBGColor(d,i){if(expanded&&vers=="furious"){return d.disengaged?"#eee":d.color||color(d,i)}else{return d.color||color(d,i)}}function setBGOpacity(d,i){if(expanded&&vers=="furious"){return 1}else{return!!d.disabled?0:1}}return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},key:{get:function(){return getKey},set:function(_){getKey=_}},keyFormatter:{get:function(){return keyFormatter},set:function(_){keyFormatter=_}},align:{get:function(){return align},set:function(_){align=_}},maxKeyLength:{get:function(){return maxKeyLength},set:function(_){maxKeyLength=_}},rightAlign:{get:function(){return rightAlign},set:function(_){rightAlign=_}},padding:{get:function(){return padding},set:function(_){padding=_}},updateState:{get:function(){return updateState},set:function(_){updateState=_}},enableDoubleClick:{get:function(){return enableDoubleClick},set:function(_){enableDoubleClick=_}},radioButtonMode:{get:function(){return radioButtonMode},set:function(_){radioButtonMode=_}},expanded:{get:function(){return expanded},set:function(_){expanded=_}},vers:{get:function(){return vers},set:function(_){vers=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.line=function(){"use strict";var scatter=nv.models.scatter();var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,container=null,strokeWidth=1.5,color=nv.utils.defaultColor(),getX=function(d){return d.x},getY=function(d){return d.y},defined=function(d,i){return!isNaN(getY(d,i))&&getY(d,i)!==null},isArea=function(d){return d.area},clipEdge=false,x,y,interpolate="linear",duration=250,dispatch=d3.dispatch("elementClick","elementMouseover","elementMouseout","renderEnd");scatter.pointSize(16).pointDomain([16,256]);var x0,y0,renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(scatter);selection.each(function(data){container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);x=scatter.xScale();y=scatter.yScale();x0=x0||x;y0=y0||y;var wrap=container.selectAll("g.nv-wrap.nv-line").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-line");var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-groups");gEnter.append("g").attr("class","nv-scatterWrap");wrap.attr("transform","translate("+margin.left+","+margin.top+")");scatter.width(availableWidth).height(availableHeight);var scatterWrap=wrap.select(".nv-scatterWrap");scatterWrap.call(scatter);defsEnter.append("clipPath").attr("id","nv-edge-clip-"+scatter.id()).append("rect");wrap.select("#nv-edge-clip-"+scatter.id()+" rect").attr("width",availableWidth).attr("height",availableHeight>0?availableHeight:0);g.attr("clip-path",clipEdge?"url(#nv-edge-clip-"+scatter.id()+")":"");scatterWrap.attr("clip-path",clipEdge?"url(#nv-edge-clip-"+scatter.id()+")":"");var groups=wrap.select(".nv-groups").selectAll(".nv-group").data(function(d){return d},function(d){return d.key});groups.enter().append("g").style("stroke-opacity",1e-6).style("stroke-width",function(d){return d.strokeWidth||strokeWidth}).style("fill-opacity",1e-6);groups.exit().remove();groups.attr("class",function(d,i){return(d.classed||"")+" nv-group nv-series-"+i}).classed("hover",function(d){return d.hover}).style("fill",function(d,i){return color(d,i)}).style("stroke",function(d,i){return color(d,i)});groups.watchTransition(renderWatch,"line: groups").style("stroke-opacity",1).style("fill-opacity",function(d){return d.fillOpacity||.5});var areaPaths=groups.selectAll("path.nv-area").data(function(d){return isArea(d)?[d]:[]});areaPaths.enter().append("path").attr("class","nv-area").attr("d",function(d){return d3.svg.area().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x0(getX(d,i)))}).y0(function(d,i){return nv.utils.NaNtoZero(y0(getY(d,i)))}).y1(function(d,i){return y0(y.domain()[0]<=0?y.domain()[1]>=0?0:y.domain()[1]:y.domain()[0])}).apply(this,[d.values])});groups.exit().selectAll("path.nv-area").remove();areaPaths.watchTransition(renderWatch,"line: areaPaths").attr("d",function(d){return d3.svg.area().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x(getX(d,i)))}).y0(function(d,i){return nv.utils.NaNtoZero(y(getY(d,i)))}).y1(function(d,i){return y(y.domain()[0]<=0?y.domain()[1]>=0?0:y.domain()[1]:y.domain()[0])}).apply(this,[d.values])});var linePaths=groups.selectAll("path.nv-line").data(function(d){return[d.values]});linePaths.enter().append("path").attr("class","nv-line").attr("d",d3.svg.line().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x0(getX(d,i)))}).y(function(d,i){return nv.utils.NaNtoZero(y0(getY(d,i)))}));linePaths.watchTransition(renderWatch,"line: linePaths").attr("d",d3.svg.line().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x(getX(d,i)))}).y(function(d,i){return nv.utils.NaNtoZero(y(getY(d,i)))}));x0=x.copy();y0=y.copy()});renderWatch.renderEnd("line immediate");return chart}chart.dispatch=dispatch;chart.scatter=scatter;scatter.dispatch.on("elementClick",function(){dispatch.elementClick.apply(this,arguments)});scatter.dispatch.on("elementMouseover",function(){dispatch.elementMouseover.apply(this,arguments)});scatter.dispatch.on("elementMouseout",function(){dispatch.elementMouseout.apply(this,arguments)});chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},defined:{get:function(){return defined},set:function(_){defined=_}},interpolate:{get:function(){return interpolate},set:function(_){interpolate=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);scatter.duration(duration)}},isArea:{get:function(){return isArea},set:function(_){isArea=d3.functor(_)}},x:{get:function(){return getX},set:function(_){getX=_;scatter.x(_)}},y:{get:function(){return getY},set:function(_){getY=_;scatter.y(_)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);scatter.color(color)}}});nv.utils.inheritOptions(chart,scatter);nv.utils.initOptions(chart);return chart};nv.models.lineChart=function(){"use strict";var lines=nv.models.line(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),interactiveLayer=nv.interactiveGuideline(),tooltip=nv.models.tooltip(),focus=nv.models.focus(nv.models.line());var margin={top:30,right:20,bottom:50,left:60},marginTop=null,color=nv.utils.defaultColor(),width=null,height=null,showLegend=true,legendPosition="top",showXAxis=true,showYAxis=true,rightAlignYAxis=false,useInteractiveGuideline=false,x,y,focusEnable=false,state=nv.utils.state(),defaultState=null,noData=null,dispatch=d3.dispatch("stateChange","changeState","renderEnd"),duration=250;xAxis.orient("bottom").tickPadding(7);yAxis.orient(rightAlignYAxis?"right":"left");lines.clipEdge(true).duration(0);tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});interactiveLayer.tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});var renderWatch=nv.utils.renderWatch(dispatch,duration);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled})}}};var stateSetter=function(data){return function(state){if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};function chart(selection){renderWatch.reset();renderWatch.models(lines);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin)-(focusEnable?focus.height():0);chart.update=function(){if(duration===0){container.call(chart)}else{container.transition().duration(duration).call(chart)}};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}focus.dispatch.on("onBrush",function(extent){onBrush(extent)});x=lines.xScale();y=lines.yScale();var wrap=container.selectAll("g.nv-wrap.nv-lineChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-lineChart").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-legendWrap");var focusEnter=gEnter.append("g").attr("class","nv-focus");focusEnter.append("g").attr("class","nv-background").append("rect");focusEnter.append("g").attr("class","nv-x nv-axis");focusEnter.append("g").attr("class","nv-y nv-axis");focusEnter.append("g").attr("class","nv-linesWrap");focusEnter.append("g").attr("class","nv-interactive");var contextEnter=gEnter.append("g").attr("class","nv-focusWrap");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{legend.width(availableWidth);g.select(".nv-legendWrap").datum(data).call(legend);if(legendPosition==="bottom"){margin.bottom=xAxis.height()+legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);g.select(".nv-legendWrap").attr("transform","translate(0,"+(availableHeight+xAxis.height())+")")}else if(legendPosition==="top"){if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)-(focusEnable?focus.height():0)}wrap.select(".nv-legendWrap").attr("transform","translate(0,"+-margin.top+")")}}wrap.attr("transform","translate("+margin.left+","+margin.top+")");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer)}g.select(".nv-focus .nv-background rect").attr("width",availableWidth).attr("height",availableHeight);lines.width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));var linesWrap=g.select(".nv-linesWrap").datum(data.filter(function(d){return!d.disabled}));if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0)}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0)}function updateXAxis(){if(showXAxis){g.select(".nv-focus .nv-x.nv-axis").transition().duration(duration).call(xAxis)}}function updateYAxis(){if(showYAxis){g.select(".nv-focus .nv-y.nv-axis").transition().duration(duration).call(yAxis)}}g.select(".nv-focus .nv-x.nv-axis").attr("transform","translate(0,"+availableHeight+")");if(!focusEnable&&focus.brush.extent()===null){linesWrap.call(lines);updateXAxis();updateYAxis()}else{focus.width(availableWidth);g.select(".nv-focusWrap").style("display",focusEnable?"initial":"none").attr("transform","translate(0,"+(availableHeight+margin.bottom+focus.margin().top)+")").call(focus);var extent=focus.brush.empty()?focus.xDomain():focus.brush.extent();if(extent!==null){onBrush(extent)}}legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});interactiveLayer.dispatch.on("elementMousemove",function(e){lines.clearHighlights();var singlePoint,pointIndex,pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled&&!series.disableTooltip}).forEach(function(series,i){var extent=focus.brush.extent()!==null?focus.brush.empty()?focus.xScale().domain():focus.brush.extent():x.domain();var currentValues=series.values.filter(function(d,i){if(extent[0]<=extent[1]){return lines.x()(d,i)>=extent[0]&&lines.x()(d,i)<=extent[1]}else{return lines.x()(d,i)>=extent[1]&&lines.x()(d,i)<=extent[0]}});pointIndex=nv.interactiveBisect(currentValues,e.pointXValue,lines.x());var point=currentValues[pointIndex];var pointYValue=chart.y()(point,pointIndex);if(pointYValue!==null){lines.highlightPoint(i,pointIndex,true)}if(point===undefined)return;if(singlePoint===undefined)singlePoint=point;if(pointXLocation===undefined)pointXLocation=chart.xScale()(chart.x()(point,pointIndex));allData.push({key:series.key,value:pointYValue,color:color(series,series.seriesIndex),data:point})});if(allData.length>2){var yValue=chart.yScale().invert(e.mouseY);var domainExtent=Math.abs(chart.yScale().domain()[0]-chart.yScale().domain()[1]);var threshold=.03*domainExtent;var indexToHighlight=nv.nearestValueIndex(allData.map(function(d){return d.value}),yValue,threshold);if(indexToHighlight!==null)allData[indexToHighlight].highlight=true}var defaultValueFormatter=function(d,i){return d==null?"N/A":yAxis.tickFormat()(d)};interactiveLayer.tooltip.valueFormatter(interactiveLayer.tooltip.valueFormatter()||defaultValueFormatter).data({value:chart.x()(singlePoint,pointIndex),index:pointIndex,series:allData})();interactiveLayer.renderGuideLine(pointXLocation)});interactiveLayer.dispatch.on("elementClick",function(e){var pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled}).forEach(function(series){var pointIndex=nv.interactiveBisect(series.values,e.pointXValue,chart.x());var point=series.values[pointIndex];if(typeof point==="undefined")return;if(typeof pointXLocation==="undefined")pointXLocation=chart.xScale()(chart.x()(point,pointIndex));var yPos=chart.yScale()(chart.y()(point,pointIndex));allData.push({point:point,pointIndex:pointIndex,pos:[pointXLocation,yPos],seriesIndex:series.seriesIndex,series:series})});lines.dispatch.elementClick(allData)});interactiveLayer.dispatch.on("elementMouseout",function(e){lines.clearHighlights()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"&&data.length===e.disabled.length){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}chart.update()});function resizePath(d){var e=+(d=="e"),x=e?1:-1,y=availableHeight/3;return"M"+.5*x+","+y+"A6,6 0 0 "+e+" "+6.5*x+","+(y+6)+"V"+(2*y-6)+"A6,6 0 0 "+e+" "+.5*x+","+2*y+"Z"+"M"+2.5*x+","+(y+8)+"V"+(2*y-8)+"M"+4.5*x+","+(y+8)+"V"+(2*y-8)}function onBrush(extent){var focusLinesWrap=g.select(".nv-focus .nv-linesWrap").datum(data.filter(function(d){return!d.disabled}).map(function(d,i){return{key:d.key,area:d.area,classed:d.classed,values:d.values.filter(function(d,i){return lines.x()(d,i)>=extent[0]&&lines.x()(d,i)<=extent[1]}),disableTooltip:d.disableTooltip}}));focusLinesWrap.transition().duration(duration).call(lines);updateXAxis();updateYAxis()}});renderWatch.renderEnd("lineChart immediate");return chart}lines.dispatch.on("elementMouseover.tooltip",function(evt){if(!evt.series.disableTooltip){tooltip.data(evt).hidden(false)}});lines.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});chart.dispatch=dispatch;chart.lines=lines;chart.legend=legend;chart.focus=focus;chart.xAxis=xAxis;chart.x2Axis=focus.xAxis;chart.yAxis=yAxis;chart.y2Axis=focus.yAxis;chart.interactiveLayer=interactiveLayer;chart.tooltip=tooltip;chart.state=state;chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},legendPosition:{get:function(){return legendPosition},set:function(_){legendPosition=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},focusEnable:{get:function(){return focusEnable},set:function(_){focusEnable=_}},focusHeight:{get:function(){return focus.height()},set:function(_){focus.height(_)}},focusShowAxisX:{get:function(){return focus.showXAxis()},set:function(_){focus.showXAxis(_)}},focusShowAxisY:{get:function(){return focus.showYAxis()},set:function(_){focus.showYAxis(_)}},brushExtent:{get:function(){return focus.brushExtent()},set:function(_){focus.brushExtent(_)}},focusMargin:{get:function(){return focus.margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}focus.margin.right=_.right!==undefined?_.right:focus.margin.right;focus.margin.bottom=_.bottom!==undefined?_.bottom:focus.margin.bottom;focus.margin.left=_.left!==undefined?_.left:focus.margin.left}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);lines.duration(duration);focus.duration(duration);xAxis.duration(duration);yAxis.duration(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color);lines.color(color);focus.color(color)}},interpolate:{get:function(){return lines.interpolate()},set:function(_){lines.interpolate(_);focus.interpolate(_)}},xTickFormat:{get:function(){return xAxis.tickFormat()},set:function(_){xAxis.tickFormat(_);focus.xTickFormat(_)}},yTickFormat:{get:function(){return yAxis.tickFormat()},set:function(_){yAxis.tickFormat(_);focus.yTickFormat(_)}},x:{get:function(){return lines.x()},set:function(_){lines.x(_);focus.x(_)}},y:{get:function(){return lines.y()},set:function(_){lines.y(_);focus.y(_)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(rightAlignYAxis?"right":"left")}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline},set:function(_){useInteractiveGuideline=_;if(useInteractiveGuideline){lines.interactive(false);lines.useVoronoi(false)}}}});nv.utils.inheritOptions(chart,lines);nv.utils.initOptions(chart);return chart};nv.models.lineWithFocusChart=function(){return nv.models.lineChart().margin({bottom:30}).focusEnable(true)};nv.models.linePlusBarChart=function(){"use strict";var lines=nv.models.line(),lines2=nv.models.line(),bars=nv.models.historicalBar(),bars2=nv.models.historicalBar(),xAxis=nv.models.axis(),x2Axis=nv.models.axis(),y1Axis=nv.models.axis(),y2Axis=nv.models.axis(),y3Axis=nv.models.axis(),y4Axis=nv.models.axis(),legend=nv.models.legend(),brush=d3.svg.brush(),tooltip=nv.models.tooltip();var margin={top:30,right:30,bottom:30,left:60},marginTop=null,margin2={top:0,right:30,bottom:20,left:60},width=null,height=null,getX=function(d){return d.x},getY=function(d){return d.y},color=nv.utils.defaultColor(),showLegend=true,focusEnable=true,focusShowAxisY=false,focusShowAxisX=true,focusHeight=50,extent,brushExtent=null,x,x2,y1,y2,y3,y4,noData=null,dispatch=d3.dispatch("brush","stateChange","changeState"),transitionDuration=0,state=nv.utils.state(),defaultState=null,legendLeftAxisHint=" (left axis)",legendRightAxisHint=" (right axis)",switchYAxisOrder=false;lines.clipEdge(true);lines2.interactive(false);lines2.pointActive(function(d){return false});xAxis.orient("bottom").tickPadding(5);y1Axis.orient("left");y2Axis.orient("right");x2Axis.orient("bottom").tickPadding(5);y3Axis.orient("left");y4Axis.orient("right");tooltip.headerEnabled(true).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)
});var getBarsAxis=function(){return switchYAxisOrder?{main:y2Axis,focus:y4Axis}:{main:y1Axis,focus:y3Axis}};var getLinesAxis=function(){return switchYAxisOrder?{main:y1Axis,focus:y3Axis}:{main:y2Axis,focus:y4Axis}};var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled})}}};var stateSetter=function(data){return function(state){if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};var allDisabled=function(data){return data.every(function(series){return series.disabled})};function chart(selection){selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight1=nv.utils.availableHeight(height,container,margin)-(focusEnable?focusHeight:0),availableHeight2=focusHeight-margin2.top-margin2.bottom;chart.update=function(){container.transition().duration(transitionDuration).call(chart)};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}var dataBars=data.filter(function(d){return!d.disabled&&d.bar});var dataLines=data.filter(function(d){return!d.bar});if(dataBars.length&&!switchYAxisOrder){x=bars.xScale()}else{x=lines.xScale()}x2=x2Axis.scale();y1=switchYAxisOrder?lines.yScale():bars.yScale();y2=switchYAxisOrder?bars.yScale():lines.yScale();y3=switchYAxisOrder?lines2.yScale():bars2.yScale();y4=switchYAxisOrder?bars2.yScale():lines2.yScale();var series1=data.filter(function(d){return!d.disabled&&(switchYAxisOrder?!d.bar:d.bar)}).map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i)}})});var series2=data.filter(function(d){return!d.disabled&&(switchYAxisOrder?d.bar:!d.bar)}).map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i)}})});x.range([0,availableWidth]);x2.domain(d3.extent(d3.merge(series1.concat(series2)),function(d){return d.x})).range([0,availableWidth]);var wrap=container.selectAll("g.nv-wrap.nv-linePlusBar").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-linePlusBar").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-legendWrap");var focusEnter=gEnter.append("g").attr("class","nv-focus");focusEnter.append("g").attr("class","nv-x nv-axis");focusEnter.append("g").attr("class","nv-y1 nv-axis");focusEnter.append("g").attr("class","nv-y2 nv-axis");focusEnter.append("g").attr("class","nv-barsWrap");focusEnter.append("g").attr("class","nv-linesWrap");var contextEnter=gEnter.append("g").attr("class","nv-context");contextEnter.append("g").attr("class","nv-x nv-axis");contextEnter.append("g").attr("class","nv-y1 nv-axis");contextEnter.append("g").attr("class","nv-y2 nv-axis");contextEnter.append("g").attr("class","nv-barsWrap");contextEnter.append("g").attr("class","nv-linesWrap");contextEnter.append("g").attr("class","nv-brushBackground");contextEnter.append("g").attr("class","nv-x nv-brush");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{var legendWidth=legend.align()?availableWidth/2:availableWidth;var legendXPosition=legend.align()?legendWidth:0;legend.width(legendWidth);g.select(".nv-legendWrap").datum(data.map(function(series){series.originalKey=series.originalKey===undefined?series.key:series.originalKey;if(switchYAxisOrder){series.key=series.originalKey+(series.bar?legendRightAxisHint:legendLeftAxisHint)}else{series.key=series.originalKey+(series.bar?legendLeftAxisHint:legendRightAxisHint)}return series})).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight1=nv.utils.availableHeight(height,container,margin)-focusHeight}g.select(".nv-legendWrap").attr("transform","translate("+legendXPosition+","+-margin.top+")")}wrap.attr("transform","translate("+margin.left+","+margin.top+")");g.select(".nv-context").style("display",focusEnable?"initial":"none");bars2.width(availableWidth).height(availableHeight2).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled&&data[i].bar}));lines2.width(availableWidth).height(availableHeight2).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled&&!data[i].bar}));var bars2Wrap=g.select(".nv-context .nv-barsWrap").datum(dataBars.length?dataBars:[{values:[]}]);var lines2Wrap=g.select(".nv-context .nv-linesWrap").datum(allDisabled(dataLines)?[{values:[]}]:dataLines.filter(function(dataLine){return!dataLine.disabled}));g.select(".nv-context").attr("transform","translate(0,"+(availableHeight1+margin.bottom+margin2.top)+")");bars2Wrap.transition().call(bars2);lines2Wrap.transition().call(lines2);if(focusShowAxisX){x2Axis._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight2,0);g.select(".nv-context .nv-x.nv-axis").attr("transform","translate(0,"+y3.range()[0]+")");g.select(".nv-context .nv-x.nv-axis").transition().call(x2Axis)}if(focusShowAxisY){y3Axis.scale(y3)._ticks(availableHeight2/36).tickSize(-availableWidth,0);y4Axis.scale(y4)._ticks(availableHeight2/36).tickSize(dataBars.length?0:-availableWidth,0);g.select(".nv-context .nv-y3.nv-axis").style("opacity",dataBars.length?1:0).attr("transform","translate(0,"+x2.range()[0]+")");g.select(".nv-context .nv-y2.nv-axis").style("opacity",dataLines.length?1:0).attr("transform","translate("+x2.range()[1]+",0)");g.select(".nv-context .nv-y1.nv-axis").transition().call(y3Axis);g.select(".nv-context .nv-y2.nv-axis").transition().call(y4Axis)}brush.x(x2).on("brush",onBrush);if(brushExtent)brush.extent(brushExtent);var brushBG=g.select(".nv-brushBackground").selectAll("g").data([brushExtent||brush.extent()]);var brushBGenter=brushBG.enter().append("g");brushBGenter.append("rect").attr("class","left").attr("x",0).attr("y",0).attr("height",availableHeight2);brushBGenter.append("rect").attr("class","right").attr("x",0).attr("y",0).attr("height",availableHeight2);var gBrush=g.select(".nv-x.nv-brush").call(brush);gBrush.selectAll("rect").attr("height",availableHeight2);gBrush.selectAll(".resize").append("path").attr("d",resizePath);legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}chart.update()});function resizePath(d){var e=+(d=="e"),x=e?1:-1,y=availableHeight2/3;return"M"+.5*x+","+y+"A6,6 0 0 "+e+" "+6.5*x+","+(y+6)+"V"+(2*y-6)+"A6,6 0 0 "+e+" "+.5*x+","+2*y+"Z"+"M"+2.5*x+","+(y+8)+"V"+(2*y-8)+"M"+4.5*x+","+(y+8)+"V"+(2*y-8)}function updateBrushBG(){if(!brush.empty())brush.extent(brushExtent);brushBG.data([brush.empty()?x2.domain():brushExtent]).each(function(d,i){var leftWidth=x2(d[0])-x2.range()[0],rightWidth=x2.range()[1]-x2(d[1]);d3.select(this).select(".left").attr("width",leftWidth<0?0:leftWidth);d3.select(this).select(".right").attr("x",x2(d[1])).attr("width",rightWidth<0?0:rightWidth)})}function onBrush(){brushExtent=brush.empty()?null:brush.extent();extent=brush.empty()?x2.domain():brush.extent();dispatch.brush({extent:extent,brush:brush});updateBrushBG();bars.width(availableWidth).height(availableHeight1).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled&&data[i].bar}));lines.width(availableWidth).height(availableHeight1).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled&&!data[i].bar}));var focusBarsWrap=g.select(".nv-focus .nv-barsWrap").datum(!dataBars.length?[{values:[]}]:dataBars.map(function(d,i){return{key:d.key,values:d.values.filter(function(d,i){return bars.x()(d,i)>=extent[0]&&bars.x()(d,i)<=extent[1]})}}));var focusLinesWrap=g.select(".nv-focus .nv-linesWrap").datum(allDisabled(dataLines)?[{values:[]}]:dataLines.filter(function(dataLine){return!dataLine.disabled}).map(function(d,i){return{area:d.area,fillOpacity:d.fillOpacity,strokeWidth:d.strokeWidth,key:d.key,values:d.values.filter(function(d,i){return lines.x()(d,i)>=extent[0]&&lines.x()(d,i)<=extent[1]})}}));if(dataBars.length&&!switchYAxisOrder){x=bars.xScale()}else{x=lines.xScale()}xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight1,0);xAxis.domain([Math.ceil(extent[0]),Math.floor(extent[1])]);g.select(".nv-x.nv-axis").transition().duration(transitionDuration).call(xAxis);focusBarsWrap.transition().duration(transitionDuration).call(bars);focusLinesWrap.transition().duration(transitionDuration).call(lines);g.select(".nv-focus .nv-x.nv-axis").attr("transform","translate(0,"+y1.range()[0]+")");y1Axis.scale(y1)._ticks(nv.utils.calcTicksY(availableHeight1/36,data)).tickSize(-availableWidth,0);y2Axis.scale(y2)._ticks(nv.utils.calcTicksY(availableHeight1/36,data));if(!switchYAxisOrder){y2Axis.tickSize(dataBars.length?0:-availableWidth,0)}else{y2Axis.tickSize(dataLines.length?0:-availableWidth,0)}var barsOpacity=dataBars.length?1:0;var linesOpacity=dataLines.length&&!allDisabled(dataLines)?1:0;var y1Opacity=switchYAxisOrder?linesOpacity:barsOpacity;var y2Opacity=switchYAxisOrder?barsOpacity:linesOpacity;g.select(".nv-focus .nv-y1.nv-axis").style("opacity",y1Opacity);g.select(".nv-focus .nv-y2.nv-axis").style("opacity",y2Opacity).attr("transform","translate("+x.range()[1]+",0)");g.select(".nv-focus .nv-y1.nv-axis").transition().duration(transitionDuration).call(y1Axis);g.select(".nv-focus .nv-y2.nv-axis").transition().duration(transitionDuration).call(y2Axis)}onBrush()});return chart}lines.dispatch.on("elementMouseover.tooltip",function(evt){tooltip.duration(100).valueFormatter(function(d,i){return getLinesAxis().main.tickFormat()(d,i)}).data(evt).hidden(false)});lines.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bars.dispatch.on("elementMouseover.tooltip",function(evt){evt.value=chart.x()(evt.data);evt["series"]={value:chart.y()(evt.data),color:evt.color};tooltip.duration(0).valueFormatter(function(d,i){return getBarsAxis().main.tickFormat()(d,i)}).data(evt).hidden(false)});bars.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bars.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.dispatch=dispatch;chart.legend=legend;chart.lines=lines;chart.lines2=lines2;chart.bars=bars;chart.bars2=bars2;chart.xAxis=xAxis;chart.x2Axis=x2Axis;chart.y1Axis=y1Axis;chart.y2Axis=y2Axis;chart.y3Axis=y3Axis;chart.y4Axis=y4Axis;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},brushExtent:{get:function(){return brushExtent},set:function(_){brushExtent=_}},noData:{get:function(){return noData},set:function(_){noData=_}},focusEnable:{get:function(){return focusEnable},set:function(_){focusEnable=_}},focusHeight:{get:function(){return focusHeight},set:function(_){focusHeight=_}},focusShowAxisX:{get:function(){return focusShowAxisX},set:function(_){focusShowAxisX=_}},focusShowAxisY:{get:function(){return focusShowAxisY},set:function(_){focusShowAxisY=_}},legendLeftAxisHint:{get:function(){return legendLeftAxisHint},set:function(_){legendLeftAxisHint=_}},legendRightAxisHint:{get:function(){return legendRightAxisHint},set:function(_){legendRightAxisHint=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},focusMargin:{get:function(){return margin2},set:function(_){margin2.top=_.top!==undefined?_.top:margin2.top;margin2.right=_.right!==undefined?_.right:margin2.right;margin2.bottom=_.bottom!==undefined?_.bottom:margin2.bottom;margin2.left=_.left!==undefined?_.left:margin2.left}},duration:{get:function(){return transitionDuration},set:function(_){transitionDuration=_}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color)}},x:{get:function(){return getX},set:function(_){getX=_;lines.x(_);lines2.x(_);bars.x(_);bars2.x(_)}},y:{get:function(){return getY},set:function(_){getY=_;lines.y(_);lines2.y(_);bars.y(_);bars2.y(_)}},switchYAxisOrder:{get:function(){return switchYAxisOrder},set:function(_){if(switchYAxisOrder!==_){var y1=y1Axis;y1Axis=y2Axis;y2Axis=y1;var y3=y3Axis;y3Axis=y4Axis;y4Axis=y3}switchYAxisOrder=_;y1Axis.orient("left");y2Axis.orient("right");y3Axis.orient("left");y4Axis.orient("right")}}});nv.utils.inheritOptions(chart,lines);nv.utils.initOptions(chart);return chart};nv.models.multiBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,x=d3.scale.ordinal(),y=d3.scale.linear(),id=Math.floor(Math.random()*1e4),container=null,getX=function(d){return d.x},getY=function(d){return d.y},forceY=[0],clipEdge=true,stacked=false,stackOffset="zero",color=nv.utils.defaultColor(),hideable=false,barColor=null,disabled,duration=500,xDomain,yDomain,xRange,yRange,groupSpacing=.1,fillOpacity=.75,dispatch=d3.dispatch("chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove","renderEnd");var x0,y0,renderWatch=nv.utils.renderWatch(dispatch,duration);var last_datalength=0;function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);var nonStackableCount=0;var endFn=function(d,i){if(d.series===data.length-1&&i===data[0].values.length-1)return true;return false};if(hideable&&data.length)hideable=[{values:data[0].values.map(function(d){return{x:d.x,y:0,series:d.series,size:.01}})}];if(stacked){var parsed=d3.layout.stack().offset(stackOffset).values(function(d){return d.values}).y(getY)(!data.length&&hideable?hideable:data);parsed.forEach(function(series,i){if(series.nonStackable){data[i].nonStackableSeries=nonStackableCount++;parsed[i]=data[i]}else{if(i>0&&parsed[i-1].nonStackable){parsed[i].values.map(function(d,j){d.y0-=parsed[i-1].values[j].y;d.y1=d.y0+d.y})}}});data=parsed}data.forEach(function(series,i){series.values.forEach(function(point){point.series=i;point.key=series.key})});if(stacked&&data.length>0){data[0].values.map(function(d,i){var posBase=0,negBase=0;data.map(function(d,idx){if(!data[idx].nonStackable){var f=d.values[i];f.size=Math.abs(f.y);if(f.y<0){f.y1=negBase;negBase=negBase-f.size}else{f.y1=f.size+posBase;posBase=posBase+f.size}}})})}var seriesData=xDomain&&yDomain?[]:data.map(function(d,idx){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),y0:d.y0,y1:d.y1,idx:idx}})});x.domain(xDomain||d3.merge(seriesData).map(function(d){return d.x})).rangeBands(xRange||[0,availableWidth],groupSpacing);y.domain(yDomain||d3.extent(d3.merge(seriesData).map(function(d){var domain=d.y;if(stacked&&!data[d.idx].nonStackable){if(d.y>0){domain=d.y1}else{domain=d.y1+d.y}}return domain}).concat(forceY))).range(yRange||[availableHeight,0]);if(x.domain()[0]===x.domain()[1])x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*.01,x.domain()[1]+x.domain()[1]*.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])y.domain()[0]?y.domain([y.domain()[0]+y.domain()[0]*.01,y.domain()[1]-y.domain()[1]*.01]):y.domain([-1,1]);x0=x0||x;y0=y0||y;var wrap=container.selectAll("g.nv-wrap.nv-multibar").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-multibar");var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-groups");wrap.attr("transform","translate("+margin.left+","+margin.top+")");defsEnter.append("clipPath").attr("id","nv-edge-clip-"+id).append("rect");wrap.select("#nv-edge-clip-"+id+" rect").attr("width",availableWidth).attr("height",availableHeight);g.attr("clip-path",clipEdge?"url(#nv-edge-clip-"+id+")":"");var groups=wrap.select(".nv-groups").selectAll(".nv-group").data(function(d){return d},function(d,i){return i});groups.enter().append("g").style("stroke-opacity",1e-6).style("fill-opacity",1e-6);var exitTransition=renderWatch.transition(groups.exit().selectAll("rect.nv-bar"),"multibarExit",Math.min(100,duration)).attr("y",function(d,i,j){var yVal=y0(0)||0;if(stacked){if(data[d.series]&&!data[d.series].nonStackable){yVal=y0(d.y0)}}return yVal}).attr("height",0).remove();if(exitTransition.delay)exitTransition.delay(function(d,i){var delay=i*(duration/(last_datalength+1))-i;return delay});groups.attr("class",function(d,i){return"nv-group nv-series-"+i}).classed("hover",function(d){return d.hover}).style("fill",function(d,i){return color(d,i)}).style("stroke",function(d,i){return color(d,i)});groups.style("stroke-opacity",1).style("fill-opacity",fillOpacity);var bars=groups.selectAll("rect.nv-bar").data(function(d){return hideable&&!data.length?hideable.values:d.values});bars.exit().remove();var barsEnter=bars.enter().append("rect").attr("class",function(d,i){return getY(d,i)<0?"nv-bar negative":"nv-bar positive"}).attr("x",function(d,i,j){return stacked&&!data[j].nonStackable?0:j*x.rangeBand()/data.length}).attr("y",function(d,i,j){return y0(stacked&&!data[j].nonStackable?d.y0:0)||0}).attr("height",0).attr("width",function(d,i,j){return x.rangeBand()/(stacked&&!data[j].nonStackable?1:data.length)}).attr("transform",function(d,i){return"translate("+x(getX(d,i))+",0)"});bars.style("fill",function(d,i,j){return color(d,j,i)}).style("stroke",function(d,i,j){return color(d,j,i)}).on("mouseover",function(d,i,j){d3.select(this).classed("hover",true);dispatch.elementMouseover({data:d,index:i,series:data[j],color:d3.select(this).style("fill")})}).on("mouseout",function(d,i,j){d3.select(this).classed("hover",false);dispatch.elementMouseout({data:d,index:i,series:data[j],color:d3.select(this).style("fill")})}).on("mousemove",function(d,i,j){dispatch.elementMousemove({data:d,index:i,series:data[j],color:d3.select(this).style("fill")})}).on("click",function(d,i,j){var element=this;dispatch.elementClick({data:d,index:i,series:data[j],color:d3.select(this).style("fill"),event:d3.event,element:element});d3.event.stopPropagation()}).on("dblclick",function(d,i,j){dispatch.elementDblClick({data:d,index:i,series:data[j],color:d3.select(this).style("fill")});d3.event.stopPropagation()});bars.attr("class",function(d,i){return getY(d,i)<0?"nv-bar negative":"nv-bar positive"}).attr("transform",function(d,i){return"translate("+x(getX(d,i))+",0)"});if(barColor){if(!disabled)disabled=data.map(function(){return true});bars.style("fill",function(d,i,j){return d3.rgb(barColor(d,i)).darker(disabled.map(function(d,i){return i}).filter(function(d,i){return!disabled[i]})[j]).toString()}).style("stroke",function(d,i,j){return d3.rgb(barColor(d,i)).darker(disabled.map(function(d,i){return i}).filter(function(d,i){return!disabled[i]})[j]).toString()})}var barSelection=bars.watchTransition(renderWatch,"multibar",Math.min(250,duration)).delay(function(d,i){return i*duration/data[0].values.length});if(stacked){barSelection.attr("y",function(d,i,j){var yVal=0;if(!data[j].nonStackable){yVal=y(d.y1)}else{if(getY(d,i)<0){yVal=y(0)}else{if(y(0)-y(getY(d,i))<-1){yVal=y(0)-1}else{yVal=y(getY(d,i))||0}}}return yVal}).attr("height",function(d,i,j){if(!data[j].nonStackable){return Math.max(Math.abs(y(d.y+d.y0)-y(d.y0)),0)}else{return Math.max(Math.abs(y(getY(d,i))-y(0)),0)||0}}).attr("x",function(d,i,j){var width=0;if(data[j].nonStackable){width=d.series*x.rangeBand()/data.length;if(data.length!==nonStackableCount){width=data[j].nonStackableSeries*x.rangeBand()/(nonStackableCount*2)}}return width}).attr("width",function(d,i,j){if(!data[j].nonStackable){return x.rangeBand()}else{var width=x.rangeBand()/nonStackableCount;if(data.length!==nonStackableCount){width=x.rangeBand()/(nonStackableCount*2)}return width}})}else{barSelection.attr("x",function(d,i){return d.series*x.rangeBand()/data.length}).attr("width",x.rangeBand()/data.length).attr("y",function(d,i){return getY(d,i)<0?y(0):y(0)-y(getY(d,i))<1?y(0)-1:y(getY(d,i))||0}).attr("height",function(d,i){return Math.max(Math.abs(y(getY(d,i))-y(0)),1)||0})}x0=x.copy();y0=y.copy();if(data[0]&&data[0].values){last_datalength=data[0].values.length}});renderWatch.renderEnd("multibar immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},x:{get:function(){return getX},set:function(_){getX=_}},y:{get:function(){return getY},set:function(_){getY=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},stacked:{get:function(){return stacked},set:function(_){stacked=_}},stackOffset:{get:function(){return stackOffset},set:function(_){stackOffset=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},disabled:{get:function(){return disabled},set:function(_){disabled=_}},id:{get:function(){return id},set:function(_){id=_}},hideable:{get:function(){return hideable},set:function(_){hideable=_}},groupSpacing:{get:function(){return groupSpacing},set:function(_){groupSpacing=_}},fillOpacity:{get:function(){return fillOpacity},set:function(_){fillOpacity=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},barColor:{get:function(){return barColor},set:function(_){barColor=_?nv.utils.getColor(_):null}}});nv.utils.initOptions(chart);return chart};nv.models.multiBarChart=function(){"use strict";var multibar=nv.models.multiBar(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),interactiveLayer=nv.interactiveGuideline(),legend=nv.models.legend(),controls=nv.models.legend(),tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:50,left:60},marginTop=null,width=null,height=null,color=nv.utils.defaultColor(),showControls=true,controlLabels={},showLegend=true,legendPosition=null,showXAxis=true,showYAxis=true,rightAlignYAxis=false,reduceXTicks=true,staggerLabels=false,wrapLabels=false,rotateLabels=0,x,y,state=nv.utils.state(),defaultState=null,noData=null,dispatch=d3.dispatch("stateChange","changeState","renderEnd"),controlWidth=function(){return showControls?180:0},duration=250,useInteractiveGuideline=false;state.stacked=false;multibar.stacked(false);xAxis.orient("bottom").tickPadding(7).showMaxMin(false).tickFormat(function(d){return d});yAxis.orient(rightAlignYAxis?"right":"left").tickFormat(d3.format(",.1f"));tooltip.duration(0).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});interactiveLayer.tooltip.valueFormatter(function(d,i){return d==null?"N/A":yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});interactiveLayer.tooltip.valueFormatter(function(d,i){return d==null?"N/A":yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});interactiveLayer.tooltip.duration(0).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});controls.updateState(false);var renderWatch=nv.utils.renderWatch(dispatch);var stacked=false;var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled}),stacked:stacked}}};var stateSetter=function(data){return function(state){if(state.stacked!==undefined)stacked=state.stacked;if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};function chart(selection){renderWatch.reset();renderWatch.models(multibar);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){if(duration===0)container.call(chart);else container.transition().duration(duration).call(chart)};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}x=multibar.xScale();y=multibar.yScale();var wrap=container.selectAll("g.nv-wrap.nv-multiBarWithLegend").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-multiBarWithLegend").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis");gEnter.append("g").attr("class","nv-barsWrap");gEnter.append("g").attr("class","nv-legendWrap");gEnter.append("g").attr("class","nv-controlsWrap");gEnter.append("g").attr("class","nv-interactive");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{if(legendPosition==="bottom"){legend.width(availableWidth-margin.right);g.select(".nv-legendWrap").datum(data).call(legend);margin.bottom=xAxis.height()+legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);g.select(".nv-legendWrap").attr("transform","translate(0,"+(availableHeight+xAxis.height())+")")}else{legend.width(availableWidth-controlWidth());g.select(".nv-legendWrap").datum(data).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}g.select(".nv-legendWrap").attr("transform","translate("+controlWidth()+","+-margin.top+")")}}if(!showControls){g.select(".nv-controlsWrap").selectAll("*").remove()}else{var controlsData=[{key:controlLabels.grouped||"Grouped",disabled:multibar.stacked()},{key:controlLabels.stacked||"Stacked",disabled:!multibar.stacked()}];controls.width(controlWidth()).color(["#444","#444","#444"]);g.select(".nv-controlsWrap").datum(controlsData).attr("transform","translate(0,"+-margin.top+")").call(controls)}wrap.attr("transform","translate("+margin.left+","+margin.top+")");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}multibar.disabled(data.map(function(series){return series.disabled})).width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));var barsWrap=g.select(".nv-barsWrap").datum(data.filter(function(d){return!d.disabled}));barsWrap.call(multibar);if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")");g.select(".nv-x.nv-axis").call(xAxis);var xTicks=g.select(".nv-x.nv-axis > g").selectAll("g");xTicks.selectAll("line, text").style("opacity",1);if(staggerLabels){var getTranslate=function(x,y){return"translate("+x+","+y+")"};var staggerUp=5,staggerDown=17;xTicks.selectAll("text").attr("transform",function(d,i,j){return getTranslate(0,j%2==0?staggerUp:staggerDown)});var totalInBetweenTicks=d3.selectAll(".nv-x.nv-axis .nv-wrap g g text")[0].length;g.selectAll(".nv-x.nv-axis .nv-axisMaxMin text").attr("transform",function(d,i){return getTranslate(0,i===0||totalInBetweenTicks%2!==0?staggerDown:staggerUp)})}if(wrapLabels){g.selectAll(".tick text").call(nv.utils.wrapTicks,chart.xAxis.rangeBand())}if(reduceXTicks)xTicks.filter(function(d,i){return i%Math.ceil(data[0].values.length/(availableWidth/100))!==0}).selectAll("text, line").style("opacity",0);if(rotateLabels)xTicks.selectAll(".tick text").attr("transform","rotate("+rotateLabels+" 0,0)").style("text-anchor",rotateLabels>0?"start":"end");g.select(".nv-x.nv-axis").selectAll("g.nv-axisMaxMin text").style("opacity",1)}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select(".nv-y.nv-axis").call(yAxis)}if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer)}legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});controls.dispatch.on("legendClick",function(d,i){if(!d.disabled)return;controlsData=controlsData.map(function(s){s.disabled=true;return s});d.disabled=false;switch(d.key){case"Grouped":case controlLabels.grouped:multibar.stacked(false);break;case"Stacked":case controlLabels.stacked:multibar.stacked(true);break}state.stacked=multibar.stacked();dispatch.stateChange(state);chart.update()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}if(typeof e.stacked!=="undefined"){multibar.stacked(e.stacked);state.stacked=e.stacked;stacked=e.stacked}chart.update()});if(useInteractiveGuideline){interactiveLayer.dispatch.on("elementMousemove",function(e){if(e.pointXValue==undefined)return;var singlePoint,pointIndex,pointXLocation,xValue,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled}).forEach(function(series,i){pointIndex=x.domain().indexOf(e.pointXValue);var point=series.values[pointIndex];if(point===undefined)return;xValue=point.x;if(singlePoint===undefined)singlePoint=point;if(pointXLocation===undefined)pointXLocation=e.mouseX;allData.push({key:series.key,value:chart.y()(point,pointIndex),color:color(series,series.seriesIndex),data:series.values[pointIndex]})});interactiveLayer.tooltip.data({value:xValue,index:pointIndex,series:allData})();interactiveLayer.renderGuideLine(pointXLocation)});interactiveLayer.dispatch.on("elementMouseout",function(e){interactiveLayer.tooltip.hidden(true)})}else{multibar.dispatch.on("elementMouseover.tooltip",function(evt){evt.value=chart.x()(evt.data);evt["series"]={key:evt.data.key,value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false)});multibar.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});multibar.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()})}});renderWatch.renderEnd("multibarchart immediate");return chart}chart.dispatch=dispatch;chart.multibar=multibar;chart.legend=legend;chart.controls=controls;chart.xAxis=xAxis;
chart.yAxis=yAxis;chart.state=state;chart.tooltip=tooltip;chart.interactiveLayer=interactiveLayer;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},legendPosition:{get:function(){return legendPosition},set:function(_){legendPosition=_}},showControls:{get:function(){return showControls},set:function(_){showControls=_}},controlLabels:{get:function(){return controlLabels},set:function(_){controlLabels=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},reduceXTicks:{get:function(){return reduceXTicks},set:function(_){reduceXTicks=_}},rotateLabels:{get:function(){return rotateLabels},set:function(_){rotateLabels=_}},staggerLabels:{get:function(){return staggerLabels},set:function(_){staggerLabels=_}},wrapLabels:{get:function(){return wrapLabels},set:function(_){wrapLabels=!!_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;multibar.duration(duration);xAxis.duration(duration);yAxis.duration(duration);renderWatch.reset(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(rightAlignYAxis?"right":"left")}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline},set:function(_){useInteractiveGuideline=_}},barColor:{get:function(){return multibar.barColor},set:function(_){multibar.barColor(_);legend.color(function(d,i){return d3.rgb("#ccc").darker(i*1.5).toString()})}}});nv.utils.inheritOptions(chart,multibar);nv.utils.initOptions(chart);return chart};nv.models.multiBarHorizontal=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,id=Math.floor(Math.random()*1e4),container=null,x=d3.scale.ordinal(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},getYerr=function(d){return d.yErr},forceY=[0],color=nv.utils.defaultColor(),barColor=null,disabled,stacked=false,showValues=false,showBarLabels=false,valuePadding=60,groupSpacing=.1,fillOpacity=.75,valueFormat=d3.format(",.2f"),delay=1200,xDomain,yDomain,xRange,yRange,duration=250,dispatch=d3.dispatch("chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove","renderEnd");var x0,y0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);if(stacked)data=d3.layout.stack().offset("zero").values(function(d){return d.values}).y(getY)(data);data.forEach(function(series,i){series.values.forEach(function(point){point.series=i;point.key=series.key})});if(stacked)data[0].values.map(function(d,i){var posBase=0,negBase=0;data.map(function(d){var f=d.values[i];f.size=Math.abs(f.y);if(f.y<0){f.y1=negBase-f.size;negBase=negBase-f.size}else{f.y1=posBase;posBase=posBase+f.size}})});var seriesData=xDomain&&yDomain?[]:data.map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),y0:d.y0,y1:d.y1}})});x.domain(xDomain||d3.merge(seriesData).map(function(d){return d.x})).rangeBands(xRange||[0,availableHeight],groupSpacing);y.domain(yDomain||d3.extent(d3.merge(seriesData).map(function(d){return stacked?d.y>0?d.y1+d.y:d.y1:d.y}).concat(forceY)));if(showValues&&!stacked)y.range(yRange||[y.domain()[0]<0?valuePadding:0,availableWidth-(y.domain()[1]>0?valuePadding:0)]);else y.range(yRange||[0,availableWidth]);x0=x0||x;y0=y0||d3.scale.linear().domain(y.domain()).range([y(0),y(0)]);var wrap=d3.select(this).selectAll("g.nv-wrap.nv-multibarHorizontal").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-multibarHorizontal");var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-groups");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var groups=wrap.select(".nv-groups").selectAll(".nv-group").data(function(d){return d},function(d,i){return i});groups.enter().append("g").style("stroke-opacity",1e-6).style("fill-opacity",1e-6);groups.exit().watchTransition(renderWatch,"multibarhorizontal: exit groups").style("stroke-opacity",1e-6).style("fill-opacity",1e-6).remove();groups.attr("class",function(d,i){return"nv-group nv-series-"+i}).classed("hover",function(d){return d.hover}).style("fill",function(d,i){return color(d,i)}).style("stroke",function(d,i){return color(d,i)});groups.watchTransition(renderWatch,"multibarhorizontal: groups").style("stroke-opacity",1).style("fill-opacity",fillOpacity);var bars=groups.selectAll("g.nv-bar").data(function(d){return d.values});bars.exit().remove();var barsEnter=bars.enter().append("g").attr("transform",function(d,i,j){return"translate("+y0(stacked?d.y0:0)+","+(stacked?0:j*x.rangeBand()/data.length+x(getX(d,i)))+")"});barsEnter.append("rect").attr("width",0).attr("height",x.rangeBand()/(stacked?1:data.length));bars.on("mouseover",function(d,i){d3.select(this).classed("hover",true);dispatch.elementMouseover({data:d,index:i,color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){d3.select(this).classed("hover",false);dispatch.elementMouseout({data:d,index:i,color:d3.select(this).style("fill")})}).on("mouseout",function(d,i){dispatch.elementMouseout({data:d,index:i,color:d3.select(this).style("fill")})}).on("mousemove",function(d,i){dispatch.elementMousemove({data:d,index:i,color:d3.select(this).style("fill")})}).on("click",function(d,i){var element=this;dispatch.elementClick({data:d,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element});d3.event.stopPropagation()}).on("dblclick",function(d,i){dispatch.elementDblClick({data:d,index:i,color:d3.select(this).style("fill")});d3.event.stopPropagation()});if(getYerr(data[0],0)){barsEnter.append("polyline");bars.select("polyline").attr("fill","none").attr("points",function(d,i){var xerr=getYerr(d,i),mid=.8*x.rangeBand()/((stacked?1:data.length)*2);xerr=xerr.length?xerr:[-Math.abs(xerr),Math.abs(xerr)];xerr=xerr.map(function(e){return y(e+(getY(d,i)<0?0:getY(d,i)))-y(0)});var a=[[xerr[0],-mid],[xerr[0],mid],[xerr[0],0],[xerr[1],0],[xerr[1],-mid],[xerr[1],mid]];return a.map(function(path){return path.join(",")}).join(" ")}).attr("transform",function(d,i){var mid=x.rangeBand()/((stacked?1:data.length)*2);return"translate(0, "+mid+")"})}barsEnter.append("text");if(showValues&&!stacked){bars.select("text").attr("text-anchor",function(d,i){return getY(d,i)<0?"end":"start"}).attr("y",x.rangeBand()/(data.length*2)).attr("dy",".32em").text(function(d,i){var t=valueFormat(getY(d,i)),yerr=getYerr(d,i);if(yerr===undefined)return t;if(!yerr.length)return t+"±"+valueFormat(Math.abs(yerr));return t+"+"+valueFormat(Math.abs(yerr[1]))+"-"+valueFormat(Math.abs(yerr[0]))});bars.watchTransition(renderWatch,"multibarhorizontal: bars").select("text").attr("x",function(d,i){return getY(d,i)<0?-4:y(getY(d,i))-y(0)+4})}else{bars.selectAll("text").text("")}if(showBarLabels&&!stacked){barsEnter.append("text").classed("nv-bar-label",true);bars.select("text.nv-bar-label").attr("text-anchor",function(d,i){return getY(d,i)<0?"start":"end"}).attr("y",x.rangeBand()/(data.length*2)).attr("dy",".32em").text(function(d,i){return getX(d,i)});bars.watchTransition(renderWatch,"multibarhorizontal: bars").select("text.nv-bar-label").attr("x",function(d,i){return getY(d,i)<0?y(0)-y(getY(d,i))+4:-4})}else{bars.selectAll("text.nv-bar-label").text("")}bars.attr("class",function(d,i){return getY(d,i)<0?"nv-bar negative":"nv-bar positive"});if(barColor){if(!disabled)disabled=data.map(function(){return true});bars.style("fill",function(d,i,j){return d3.rgb(barColor(d,i)).darker(disabled.map(function(d,i){return i}).filter(function(d,i){return!disabled[i]})[j]).toString()}).style("stroke",function(d,i,j){return d3.rgb(barColor(d,i)).darker(disabled.map(function(d,i){return i}).filter(function(d,i){return!disabled[i]})[j]).toString()})}if(stacked)bars.watchTransition(renderWatch,"multibarhorizontal: bars").attr("transform",function(d,i){return"translate("+y(d.y1)+","+x(getX(d,i))+")"}).select("rect").attr("width",function(d,i){return Math.abs(y(getY(d,i)+d.y0)-y(d.y0))||0}).attr("height",x.rangeBand());else bars.watchTransition(renderWatch,"multibarhorizontal: bars").attr("transform",function(d,i){return"translate("+(getY(d,i)<0?y(getY(d,i)):y(0))+","+(d.series*x.rangeBand()/data.length+x(getX(d,i)))+")"}).select("rect").attr("height",x.rangeBand()/data.length).attr("width",function(d,i){return Math.max(Math.abs(y(getY(d,i))-y(0)),1)||0});x0=x.copy();y0=y.copy()});renderWatch.renderEnd("multibarHorizontal immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},x:{get:function(){return getX},set:function(_){getX=_}},y:{get:function(){return getY},set:function(_){getY=_}},yErr:{get:function(){return getYerr},set:function(_){getYerr=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},stacked:{get:function(){return stacked},set:function(_){stacked=_}},showValues:{get:function(){return showValues},set:function(_){showValues=_}},disabled:{get:function(){return disabled},set:function(_){disabled=_}},id:{get:function(){return id},set:function(_){id=_}},valueFormat:{get:function(){return valueFormat},set:function(_){valueFormat=_}},valuePadding:{get:function(){return valuePadding},set:function(_){valuePadding=_}},groupSpacing:{get:function(){return groupSpacing},set:function(_){groupSpacing=_}},fillOpacity:{get:function(){return fillOpacity},set:function(_){fillOpacity=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},barColor:{get:function(){return barColor},set:function(_){barColor=_?nv.utils.getColor(_):null}}});nv.utils.initOptions(chart);return chart};nv.models.multiBarHorizontalChart=function(){"use strict";var multibar=nv.models.multiBarHorizontal(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend().height(30),controls=nv.models.legend().height(30),tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:50,left:60},marginTop=null,width=null,height=null,color=nv.utils.defaultColor(),showControls=true,controlsPosition="top",controlLabels={},showLegend=true,legendPosition="top",showXAxis=true,showYAxis=true,stacked=false,x,y,state=nv.utils.state(),defaultState=null,noData=null,dispatch=d3.dispatch("stateChange","changeState","renderEnd"),controlWidth=function(){return showControls?180:0},duration=250;state.stacked=false;multibar.stacked(stacked);xAxis.orient("left").tickPadding(5).showMaxMin(false).tickFormat(function(d){return d});yAxis.orient("bottom").tickFormat(d3.format(",.1f"));tooltip.duration(0).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)});controls.updateState(false);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled}),stacked:stacked}}};var stateSetter=function(data){return function(state){if(state.stacked!==undefined)stacked=state.stacked;if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(multibar);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){container.transition().duration(duration).call(chart)};chart.container=this;stacked=multibar.stacked();state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}x=multibar.xScale();y=multibar.yScale().clamp(true);var wrap=container.selectAll("g.nv-wrap.nv-multiBarHorizontalChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-multiBarHorizontalChart").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis").append("g").attr("class","nv-zeroLine").append("line");gEnter.append("g").attr("class","nv-barsWrap");gEnter.append("g").attr("class","nv-legendWrap");gEnter.append("g").attr("class","nv-controlsWrap");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{legend.width(availableWidth-controlWidth());g.select(".nv-legendWrap").datum(data).call(legend);if(legendPosition==="bottom"){margin.bottom=xAxis.height()+legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);g.select(".nv-legendWrap").attr("transform","translate("+controlWidth()+","+(availableHeight+xAxis.height())+")")}else if(legendPosition==="top"){if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}g.select(".nv-legendWrap").attr("transform","translate("+controlWidth()+","+-margin.top+")")}}if(!showControls){g.select(".nv-controlsWrap").selectAll("*").remove()}else{var controlsData=[{key:controlLabels.grouped||"Grouped",disabled:multibar.stacked()},{key:controlLabels.stacked||"Stacked",disabled:!multibar.stacked()}];controls.width(controlWidth()).color(["#444","#444","#444"]);if(controlsPosition==="bottom"){margin.bottom=xAxis.height()+legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);g.select(".nv-controlsWrap").datum(controlsData).attr("transform","translate(0,"+(availableHeight+xAxis.height())+")").call(controls)}else if(controlsPosition==="top"){g.select(".nv-controlsWrap").datum(controlsData).attr("transform","translate(0,"+-margin.top+")").call(controls)}}wrap.attr("transform","translate("+margin.left+","+margin.top+")");multibar.disabled(data.map(function(series){return series.disabled})).width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));var barsWrap=g.select(".nv-barsWrap").datum(data.filter(function(d){return!d.disabled}));barsWrap.transition().call(multibar);if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksY(availableHeight/24,data)).tickSize(-availableWidth,0);g.select(".nv-x.nv-axis").call(xAxis);var xTicks=g.select(".nv-x.nv-axis").selectAll("g");xTicks.selectAll("line, text")}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-y.nv-axis").attr("transform","translate(0,"+availableHeight+")");g.select(".nv-y.nv-axis").call(yAxis)}g.select(".nv-zeroLine line").attr("x1",y(0)).attr("x2",y(0)).attr("y1",0).attr("y2",-availableHeight);legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});controls.dispatch.on("legendClick",function(d,i){if(!d.disabled)return;controlsData=controlsData.map(function(s){s.disabled=true;return s});d.disabled=false;switch(d.key){case"Grouped":case controlLabels.grouped:multibar.stacked(false);break;case"Stacked":case controlLabels.stacked:multibar.stacked(true);break}state.stacked=multibar.stacked();dispatch.stateChange(state);stacked=multibar.stacked();chart.update()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}if(typeof e.stacked!=="undefined"){multibar.stacked(e.stacked);state.stacked=e.stacked;stacked=e.stacked}chart.update()})});renderWatch.renderEnd("multibar horizontal chart immediate");return chart}multibar.dispatch.on("elementMouseover.tooltip",function(evt){evt.value=chart.x()(evt.data);evt["series"]={key:evt.data.key,value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false)});multibar.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});multibar.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.dispatch=dispatch;chart.multibar=multibar;chart.legend=legend;chart.controls=controls;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.state=state;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},legendPosition:{get:function(){return legendPosition},set:function(_){legendPosition=_}},controlsPosition:{get:function(){return controlsPosition},set:function(_){controlsPosition=_}},showControls:{get:function(){return showControls},set:function(_){showControls=_}},controlLabels:{get:function(){return controlLabels},set:function(_){controlLabels=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);multibar.duration(duration);xAxis.duration(duration);yAxis.duration(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color)}},barColor:{get:function(){return multibar.barColor},set:function(_){multibar.barColor(_);legend.color(function(d,i){return d3.rgb("#ccc").darker(i*1.5).toString()})}}});nv.utils.inheritOptions(chart,multibar);nv.utils.initOptions(chart);return chart};nv.models.multiChart=function(){"use strict";var margin={top:30,right:20,bottom:50,left:60},marginTop=null,color=nv.utils.defaultColor(),width=null,height=null,showLegend=true,noData=null,yDomain1,yDomain2,getX=function(d){return d.x},getY=function(d){return d.y},interpolate="linear",useVoronoi=true,interactiveLayer=nv.interactiveGuideline(),useInteractiveGuideline=false,legendRightAxisHint=" (right axis)",duration=250;var x=d3.scale.linear(),yScale1=d3.scale.linear(),yScale2=d3.scale.linear(),lines1=nv.models.line().yScale(yScale1).duration(duration),lines2=nv.models.line().yScale(yScale2).duration(duration),scatters1=nv.models.scatter().yScale(yScale1).duration(duration),scatters2=nv.models.scatter().yScale(yScale2).duration(duration),bars1=nv.models.multiBar().stacked(false).yScale(yScale1).duration(duration),bars2=nv.models.multiBar().stacked(false).yScale(yScale2).duration(duration),stack1=nv.models.stackedArea().yScale(yScale1).duration(duration),stack2=nv.models.stackedArea().yScale(yScale2).duration(duration),xAxis=nv.models.axis().scale(x).orient("bottom").tickPadding(5).duration(duration),yAxis1=nv.models.axis().scale(yScale1).orient("left").duration(duration),yAxis2=nv.models.axis().scale(yScale2).orient("right").duration(duration),legend=nv.models.legend().height(30),tooltip=nv.models.tooltip(),dispatch=d3.dispatch();var charts=[lines1,lines2,scatters1,scatters2,bars1,bars2,stack1,stack2];function chart(selection){selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);chart.update=function(){container.transition().call(chart)};chart.container=this;var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);var dataLines1=data.filter(function(d){return d.type=="line"&&d.yAxis==1});var dataLines2=data.filter(function(d){return d.type=="line"&&d.yAxis==2});var dataScatters1=data.filter(function(d){return d.type=="scatter"&&d.yAxis==1});var dataScatters2=data.filter(function(d){return d.type=="scatter"&&d.yAxis==2});var dataBars1=data.filter(function(d){return d.type=="bar"&&d.yAxis==1});var dataBars2=data.filter(function(d){return d.type=="bar"&&d.yAxis==2});var dataStack1=data.filter(function(d){return d.type=="area"&&d.yAxis==1});var dataStack2=data.filter(function(d){return d.type=="area"&&d.yAxis==2});if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}var series1=data.filter(function(d){return!d.disabled&&d.yAxis==1}).map(function(d){return d.values.map(function(d,i){return{x:getX(d),y:getY(d)}})});var series2=data.filter(function(d){return!d.disabled&&d.yAxis==2}).map(function(d){return d.values.map(function(d,i){return{x:getX(d),y:getY(d)}})});x.domain(d3.extent(d3.merge(series1.concat(series2)),function(d){return d.x})).range([0,availableWidth]);var wrap=container.selectAll("g.wrap.multiChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","wrap nvd3 multiChart").append("g");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y1 nv-axis");gEnter.append("g").attr("class","nv-y2 nv-axis");gEnter.append("g").attr("class","stack1Wrap");gEnter.append("g").attr("class","stack2Wrap");gEnter.append("g").attr("class","bars1Wrap");gEnter.append("g").attr("class","bars2Wrap");gEnter.append("g").attr("class","scatters1Wrap");gEnter.append("g").attr("class","scatters2Wrap");gEnter.append("g").attr("class","lines1Wrap");gEnter.append("g").attr("class","lines2Wrap");gEnter.append("g").attr("class","legendWrap");gEnter.append("g").attr("class","nv-interactive");var g=wrap.select("g");var color_array=data.map(function(d,i){return data[i].color||color(d,i)});if(!showLegend){g.select(".legendWrap").selectAll("*").remove()}else{var legendWidth=legend.align()?availableWidth/2:availableWidth;var legendXPosition=legend.align()?legendWidth:0;legend.width(legendWidth);legend.color(color_array);g.select(".legendWrap").datum(data.map(function(series){series.originalKey=series.originalKey===undefined?series.key:series.originalKey;series.key=series.originalKey+(series.yAxis==1?"":legendRightAxisHint);return series})).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}g.select(".legendWrap").attr("transform","translate("+legendXPosition+","+-margin.top+")")}lines1.width(availableWidth).height(availableHeight).interpolate(interpolate).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==1&&data[i].type=="line"}));lines2.width(availableWidth).height(availableHeight).interpolate(interpolate).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==2&&data[i].type=="line"}));scatters1.width(availableWidth).height(availableHeight).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==1&&data[i].type=="scatter"}));scatters2.width(availableWidth).height(availableHeight).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==2&&data[i].type=="scatter"}));bars1.width(availableWidth).height(availableHeight).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==1&&data[i].type=="bar"}));bars2.width(availableWidth).height(availableHeight).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==2&&data[i].type=="bar"}));stack1.width(availableWidth).height(availableHeight).interpolate(interpolate).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==1&&data[i].type=="area"}));stack2.width(availableWidth).height(availableHeight).interpolate(interpolate).color(color_array.filter(function(d,i){return!data[i].disabled&&data[i].yAxis==2&&data[i].type=="area"}));g.attr("transform","translate("+margin.left+","+margin.top+")");var lines1Wrap=g.select(".lines1Wrap").datum(dataLines1.filter(function(d){return!d.disabled}));var scatters1Wrap=g.select(".scatters1Wrap").datum(dataScatters1.filter(function(d){return!d.disabled}));var bars1Wrap=g.select(".bars1Wrap").datum(dataBars1.filter(function(d){return!d.disabled}));var stack1Wrap=g.select(".stack1Wrap").datum(dataStack1.filter(function(d){return!d.disabled}));var lines2Wrap=g.select(".lines2Wrap").datum(dataLines2.filter(function(d){return!d.disabled}));var scatters2Wrap=g.select(".scatters2Wrap").datum(dataScatters2.filter(function(d){return!d.disabled}));var bars2Wrap=g.select(".bars2Wrap").datum(dataBars2.filter(function(d){return!d.disabled}));var stack2Wrap=g.select(".stack2Wrap").datum(dataStack2.filter(function(d){return!d.disabled}));var extraValue1BarStacked=[];if(bars1.stacked()&&dataBars1.length){var extraValue1BarStacked=dataBars1.filter(function(d){return!d.disabled}).map(function(a){return a.values});if(extraValue1BarStacked.length>0)extraValue1BarStacked=extraValue1BarStacked.reduce(function(a,b){return a.map(function(aVal,i){return{x:aVal.x,y:aVal.y+b[i].y}})})}if(dataBars1.length){extraValue1BarStacked.push({x:0,y:0})}var extraValue2BarStacked=[];if(bars2.stacked()&&dataBars2.length){var extraValue2BarStacked=dataBars2.filter(function(d){return!d.disabled}).map(function(a){return a.values});if(extraValue2BarStacked.length>0)extraValue2BarStacked=extraValue2BarStacked.reduce(function(a,b){return a.map(function(aVal,i){return{x:aVal.x,y:aVal.y+b[i].y}})})}if(dataBars2.length){extraValue2BarStacked.push({x:0,y:0})}yScale1.domain(yDomain1||d3.extent(d3.merge(series1).concat(extraValue1BarStacked),function(d){return d.y})).range([0,availableHeight]);yScale2.domain(yDomain2||d3.extent(d3.merge(series2).concat(extraValue2BarStacked),function(d){return d.y})).range([0,availableHeight]);lines1.yDomain(yScale1.domain());scatters1.yDomain(yScale1.domain());bars1.yDomain(yScale1.domain());stack1.yDomain(yScale1.domain());lines2.yDomain(yScale2.domain());scatters2.yDomain(yScale2.domain());bars2.yDomain(yScale2.domain());stack2.yDomain(yScale2.domain());if(dataStack1.length){d3.transition(stack1Wrap).call(stack1)}if(dataStack2.length){d3.transition(stack2Wrap).call(stack2)}if(dataBars1.length){d3.transition(bars1Wrap).call(bars1)}if(dataBars2.length){d3.transition(bars2Wrap).call(bars2)}if(dataLines1.length){d3.transition(lines1Wrap).call(lines1)}if(dataLines2.length){d3.transition(lines2Wrap).call(lines2)}if(dataScatters1.length){d3.transition(scatters1Wrap).call(scatters1)}if(dataScatters2.length){d3.transition(scatters2Wrap).call(scatters2)}xAxis._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+availableHeight+")");d3.transition(g.select(".nv-x.nv-axis")).call(xAxis);yAxis1._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);d3.transition(g.select(".nv-y1.nv-axis")).call(yAxis1);yAxis2._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);d3.transition(g.select(".nv-y2.nv-axis")).call(yAxis2);g.select(".nv-y1.nv-axis").classed("nv-disabled",series1.length?false:true).attr("transform","translate("+x.range()[0]+",0)");g.select(".nv-y2.nv-axis").classed("nv-disabled",series2.length?false:true).attr("transform","translate("+x.range()[1]+",0)");legend.dispatch.on("stateChange",function(newState){chart.update()});if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer)}function mouseover_line(evt){var yaxis=evt.series.yAxis===2?yAxis2:yAxis1;evt.value=evt.point.x;evt.series={value:evt.point.y,color:evt.point.color,key:evt.series.key};tooltip.duration(0).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return yaxis.tickFormat()(d,i)}).data(evt).hidden(false)}function mouseover_scatter(evt){var yaxis=evt.series.yAxis===2?yAxis2:yAxis1;evt.value=evt.point.x;evt.series={value:evt.point.y,color:evt.point.color,key:evt.series.key};tooltip.duration(100).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return yaxis.tickFormat()(d,i)}).data(evt).hidden(false)}function mouseover_stack(evt){var yaxis=evt.series.yAxis===2?yAxis2:yAxis1;evt.point["x"]=stack1.x()(evt.point);evt.point["y"]=stack1.y()(evt.point);tooltip.duration(0).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return yaxis.tickFormat()(d,i)}).data(evt).hidden(false)}function mouseover_bar(evt){var yaxis=evt.series.yAxis===2?yAxis2:yAxis1;evt.value=bars1.x()(evt.data);evt["series"]={value:bars1.y()(evt.data),color:evt.color,key:evt.data.key};tooltip.duration(0).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return yaxis.tickFormat()(d,i)}).data(evt).hidden(false)}function clearHighlights(){for(var i=0,il=charts.length;i<il;i++){var chart=charts[i];try{chart.clearHighlights()}catch(e){}}}function highlightPoint(serieIndex,pointIndex,b){for(var i=0,il=charts.length;i<il;i++){var chart=charts[i];try{chart.highlightPoint(serieIndex,pointIndex,b)}catch(e){}}}if(useInteractiveGuideline){interactiveLayer.dispatch.on("elementMousemove",function(e){clearHighlights();var singlePoint,pointIndex,pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled}).forEach(function(series,i){var extent=x.domain();var currentValues=series.values.filter(function(d,i){return chart.x()(d,i)>=extent[0]&&chart.x()(d,i)<=extent[1]});pointIndex=nv.interactiveBisect(currentValues,e.pointXValue,chart.x());var point=currentValues[pointIndex];var pointYValue=chart.y()(point,pointIndex);if(pointYValue!==null){highlightPoint(i,pointIndex,true)}if(point===undefined)return;if(singlePoint===undefined)singlePoint=point;if(pointXLocation===undefined)pointXLocation=x(chart.x()(point,pointIndex));
allData.push({key:series.key,value:pointYValue,color:color(series,series.seriesIndex),data:point,yAxis:series.yAxis==2?yAxis2:yAxis1})});var defaultValueFormatter=function(d,i){var yAxis=allData[i].yAxis;return d==null?"N/A":yAxis.tickFormat()(d)};interactiveLayer.tooltip.headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(interactiveLayer.tooltip.valueFormatter()||defaultValueFormatter).data({value:chart.x()(singlePoint,pointIndex),index:pointIndex,series:allData})();interactiveLayer.renderGuideLine(pointXLocation)});interactiveLayer.dispatch.on("elementMouseout",function(e){clearHighlights()})}else{lines1.dispatch.on("elementMouseover.tooltip",mouseover_line);lines2.dispatch.on("elementMouseover.tooltip",mouseover_line);lines1.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});lines2.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});scatters1.dispatch.on("elementMouseover.tooltip",mouseover_scatter);scatters2.dispatch.on("elementMouseover.tooltip",mouseover_scatter);scatters1.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});scatters2.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});stack1.dispatch.on("elementMouseover.tooltip",mouseover_stack);stack2.dispatch.on("elementMouseover.tooltip",mouseover_stack);stack1.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});stack2.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bars1.dispatch.on("elementMouseover.tooltip",mouseover_bar);bars2.dispatch.on("elementMouseover.tooltip",mouseover_bar);bars1.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bars2.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});bars1.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});bars2.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()})}});return chart}chart.dispatch=dispatch;chart.legend=legend;chart.lines1=lines1;chart.lines2=lines2;chart.scatters1=scatters1;chart.scatters2=scatters2;chart.bars1=bars1;chart.bars2=bars2;chart.stack1=stack1;chart.stack2=stack2;chart.xAxis=xAxis;chart.yAxis1=yAxis1;chart.yAxis2=yAxis2;chart.tooltip=tooltip;chart.interactiveLayer=interactiveLayer;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},yDomain1:{get:function(){return yDomain1},set:function(_){yDomain1=_}},yDomain2:{get:function(){return yDomain2},set:function(_){yDomain2=_}},noData:{get:function(){return noData},set:function(_){noData=_}},interpolate:{get:function(){return interpolate},set:function(_){interpolate=_}},legendRightAxisHint:{get:function(){return legendRightAxisHint},set:function(_){legendRightAxisHint=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},x:{get:function(){return getX},set:function(_){getX=_;lines1.x(_);lines2.x(_);scatters1.x(_);scatters2.x(_);bars1.x(_);bars2.x(_);stack1.x(_);stack2.x(_)}},y:{get:function(){return getY},set:function(_){getY=_;lines1.y(_);lines2.y(_);scatters1.y(_);scatters2.y(_);stack1.y(_);stack2.y(_);bars1.y(_);bars2.y(_)}},useVoronoi:{get:function(){return useVoronoi},set:function(_){useVoronoi=_;lines1.useVoronoi(_);lines2.useVoronoi(_);stack1.useVoronoi(_);stack2.useVoronoi(_)}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline},set:function(_){useInteractiveGuideline=_;if(useInteractiveGuideline){lines1.interactive(false);lines1.useVoronoi(false);lines2.interactive(false);lines2.useVoronoi(false);stack1.interactive(false);stack1.useVoronoi(false);stack2.interactive(false);stack2.useVoronoi(false);scatters1.interactive(false);scatters2.interactive(false)}}},duration:{get:function(){return duration},set:function(_){duration=_;[lines1,lines2,stack1,stack2,scatters1,scatters2,xAxis,yAxis1,yAxis2].forEach(function(model){model.duration(duration)})}}});nv.utils.initOptions(chart);return chart};nv.models.ohlcBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=null,height=null,id=Math.floor(Math.random()*1e4),container=null,x=d3.scale.linear(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},getOpen=function(d){return d.open},getClose=function(d){return d.close},getHigh=function(d){return d.high},getLow=function(d){return d.low},forceX=[],forceY=[],padData=false,clipEdge=true,color=nv.utils.defaultColor(),interactive=false,xDomain,yDomain,xRange,yRange,dispatch=d3.dispatch("stateChange","changeState","renderEnd","chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove");function chart(selection){selection.each(function(data){container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);var w=availableWidth/data[0].values.length*.9;x.domain(xDomain||d3.extent(data[0].values.map(getX).concat(forceX)));if(padData)x.range(xRange||[availableWidth*.5/data[0].values.length,availableWidth*(data[0].values.length-.5)/data[0].values.length]);else x.range(xRange||[5+w/2,availableWidth-w/2-5]);y.domain(yDomain||[d3.min(data[0].values.map(getLow).concat(forceY)),d3.max(data[0].values.map(getHigh).concat(forceY))]).range(yRange||[availableHeight,0]);if(x.domain()[0]===x.domain()[1])x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*.01,x.domain()[1]+x.domain()[1]*.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])y.domain()[0]?y.domain([y.domain()[0]+y.domain()[0]*.01,y.domain()[1]-y.domain()[1]*.01]):y.domain([-1,1]);var wrap=d3.select(this).selectAll("g.nv-wrap.nv-ohlcBar").data([data[0].values]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-ohlcBar");var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-ticks");wrap.attr("transform","translate("+margin.left+","+margin.top+")");container.on("click",function(d,i){dispatch.chartClick({data:d,index:i,pos:d3.event,id:id})});defsEnter.append("clipPath").attr("id","nv-chart-clip-path-"+id).append("rect");wrap.select("#nv-chart-clip-path-"+id+" rect").attr("width",availableWidth).attr("height",availableHeight);g.attr("clip-path",clipEdge?"url(#nv-chart-clip-path-"+id+")":"");var ticks=wrap.select(".nv-ticks").selectAll(".nv-tick").data(function(d){return d});ticks.exit().remove();ticks.enter().append("path").attr("class",function(d,i,j){return(getOpen(d,i)>getClose(d,i)?"nv-tick negative":"nv-tick positive")+" nv-tick-"+j+"-"+i}).attr("d",function(d,i){return"m0,0l0,"+(y(getOpen(d,i))-y(getHigh(d,i)))+"l"+-w/2+",0l"+w/2+",0l0,"+(y(getLow(d,i))-y(getOpen(d,i)))+"l0,"+(y(getClose(d,i))-y(getLow(d,i)))+"l"+w/2+",0l"+-w/2+",0z"}).attr("transform",function(d,i){return"translate("+x(getX(d,i))+","+y(getHigh(d,i))+")"}).attr("fill",function(d,i){return color[0]}).attr("stroke",function(d,i){return color[0]}).attr("x",0).attr("y",function(d,i){return y(Math.max(0,getY(d,i)))}).attr("height",function(d,i){return Math.abs(y(getY(d,i))-y(0))});ticks.attr("class",function(d,i,j){return(getOpen(d,i)>getClose(d,i)?"nv-tick negative":"nv-tick positive")+" nv-tick-"+j+"-"+i});d3.transition(ticks).attr("transform",function(d,i){return"translate("+x(getX(d,i))+","+y(getHigh(d,i))+")"}).attr("d",function(d,i){var w=availableWidth/data[0].values.length*.9;return"m0,0l0,"+(y(getOpen(d,i))-y(getHigh(d,i)))+"l"+-w/2+",0l"+w/2+",0l0,"+(y(getLow(d,i))-y(getOpen(d,i)))+"l0,"+(y(getClose(d,i))-y(getLow(d,i)))+"l"+w/2+",0l"+-w/2+",0z"})});return chart}chart.highlightPoint=function(pointIndex,isHoverOver){chart.clearHighlights();container.select(".nv-ohlcBar .nv-tick-0-"+pointIndex).classed("hover",isHoverOver)};chart.clearHighlights=function(){container.select(".nv-ohlcBar .nv-tick.hover").classed("hover",false)};chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},forceX:{get:function(){return forceX},set:function(_){forceX=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},padData:{get:function(){return padData},set:function(_){padData=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},id:{get:function(){return id},set:function(_){id=_}},interactive:{get:function(){return interactive},set:function(_){interactive=_}},x:{get:function(){return getX},set:function(_){getX=_}},y:{get:function(){return getY},set:function(_){getY=_}},open:{get:function(){return getOpen()},set:function(_){getOpen=_}},close:{get:function(){return getClose()},set:function(_){getClose=_}},high:{get:function(){return getHigh},set:function(_){getHigh=_}},low:{get:function(){return getLow},set:function(_){getLow=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!=undefined?_.top:margin.top;margin.right=_.right!=undefined?_.right:margin.right;margin.bottom=_.bottom!=undefined?_.bottom:margin.bottom;margin.left=_.left!=undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.parallelCoordinates=function(){"use strict";var margin={top:30,right:0,bottom:10,left:0},width=null,height=null,availableWidth=null,availableHeight=null,x=d3.scale.ordinal(),y={},undefinedValuesLabel="undefined values",dimensionData=[],enabledDimensions=[],dimensionNames=[],displayBrush=true,color=nv.utils.defaultColor(),filters=[],active=[],dragging=[],axisWithUndefinedValues=[],lineTension=1,foreground,background,dimensions,line=d3.svg.line(),axis=d3.svg.axis(),dispatch=d3.dispatch("brushstart","brush","brushEnd","dimensionsOrder","stateChange","elementClick","elementMouseover","elementMouseout","elementMousemove","renderEnd","activeChanged");var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();selection.each(function(data){var container=d3.select(this);availableWidth=nv.utils.availableWidth(width,container,margin);availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);if(data[0].values===undefined){var newData=[];data.forEach(function(d){var val={};var key=Object.keys(d);key.forEach(function(k){if(k!=="name")val[k]=d[k]});newData.push({key:d.name,values:val})});data=newData}var dataValues=data.map(function(d){return d.values});if(active.length===0){active=data}dimensionNames=dimensionData.sort(function(a,b){return a.currentPosition-b.currentPosition}).map(function(d){return d.key});enabledDimensions=dimensionData.filter(function(d){return!d.disabled});x.rangePoints([0,availableWidth],1).domain(enabledDimensions.map(function(d){return d.key}));var oldDomainMaxValue={};var displayMissingValuesline=false;var currentTicks=[];dimensionNames.forEach(function(d){var extent=d3.extent(dataValues,function(p){return+p[d]});var min=extent[0];var max=extent[1];var onlyUndefinedValues=false;if(isNaN(min)||isNaN(max)){onlyUndefinedValues=true;min=0;max=0}if(min===max){min=min-1;max=max+1}var f=filters.filter(function(k){return k.dimension==d});if(f.length!==0){if(onlyUndefinedValues){min=y[d].domain()[0];max=y[d].domain()[1]}else if(!f[0].hasOnlyNaN&&displayBrush){min=min>f[0].extent[0]?f[0].extent[0]:min;max=max<f[0].extent[1]?f[0].extent[1]:max}else if(f[0].hasNaN){max=max<f[0].extent[1]?f[0].extent[1]:max;oldDomainMaxValue[d]=y[d].domain()[1];displayMissingValuesline=true}}y[d]=d3.scale.linear().domain([min,max]).range([(availableHeight-12)*.9,0]);axisWithUndefinedValues=[];y[d].brush=d3.svg.brush().y(y[d]).on("brushstart",brushstart).on("brush",brush).on("brushend",brushend)});var wrap=container.selectAll("g.nv-wrap.nv-parallelCoordinates").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-parallelCoordinates");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-parallelCoordinates background");gEnter.append("g").attr("class","nv-parallelCoordinates foreground");gEnter.append("g").attr("class","nv-parallelCoordinates missingValuesline");wrap.attr("transform","translate("+margin.left+","+margin.top+")");line.interpolate("cardinal").tension(lineTension);axis.orient("left");var axisDrag=d3.behavior.drag().on("dragstart",dragStart).on("drag",dragMove).on("dragend",dragEnd);var missingValuesline,missingValueslineText;var step=x.range()[1]-x.range()[0];step=isNaN(step)?x.range()[0]:step;if(!isNaN(step)){var lineData=[0+step/2,availableHeight-12,availableWidth-step/2,availableHeight-12];missingValuesline=wrap.select(".missingValuesline").selectAll("line").data([lineData]);missingValuesline.enter().append("line");missingValuesline.exit().remove();missingValuesline.attr("x1",function(d){return d[0]}).attr("y1",function(d){return d[1]}).attr("x2",function(d){return d[2]}).attr("y2",function(d){return d[3]});missingValueslineText=wrap.select(".missingValuesline").selectAll("text").data([undefinedValuesLabel]);missingValueslineText.append("text").data([undefinedValuesLabel]);missingValueslineText.enter().append("text");missingValueslineText.exit().remove();missingValueslineText.attr("y",availableHeight).attr("x",availableWidth-92-step/2).text(function(d){return d})}background=wrap.select(".background").selectAll("path").data(data);background.enter().append("path");background.exit().remove();background.attr("d",path);foreground=wrap.select(".foreground").selectAll("path").data(data);foreground.enter().append("path");foreground.exit().remove();foreground.attr("d",path).style("stroke-width",function(d,i){if(isNaN(d.strokeWidth)){d.strokeWidth=1}return d.strokeWidth}).attr("stroke",function(d,i){return d.color||color(d,i)});foreground.on("mouseover",function(d,i){d3.select(this).classed("hover",true).style("stroke-width",d.strokeWidth+2+"px").style("stroke-opacity",1);dispatch.elementMouseover({label:d.name,color:d.color||color(d,i),values:d.values,dimensions:enabledDimensions})});foreground.on("mouseout",function(d,i){d3.select(this).classed("hover",false).style("stroke-width",d.strokeWidth+"px").style("stroke-opacity",.7);dispatch.elementMouseout({label:d.name,index:i})});foreground.on("mousemove",function(d,i){dispatch.elementMousemove()});foreground.on("click",function(d){dispatch.elementClick({id:d.id})});dimensions=g.selectAll(".dimension").data(enabledDimensions);var dimensionsEnter=dimensions.enter().append("g").attr("class","nv-parallelCoordinates dimension");dimensions.attr("transform",function(d){return"translate("+x(d.key)+",0)"});dimensionsEnter.append("g").attr("class","nv-axis");dimensionsEnter.append("text").attr("class","nv-label").style("cursor","move").attr("dy","-1em").attr("text-anchor","middle").on("mouseover",function(d,i){dispatch.elementMouseover({label:d.tooltip||d.key,color:d.color})}).on("mouseout",function(d,i){dispatch.elementMouseout({label:d.tooltip})}).on("mousemove",function(d,i){dispatch.elementMousemove()}).call(axisDrag);dimensionsEnter.append("g").attr("class","nv-brushBackground");dimensions.exit().remove();dimensions.select(".nv-label").text(function(d){return d.key});restoreBrush(displayBrush);var actives=dimensionNames.filter(function(p){return!y[p].brush.empty()}),extents=actives.map(function(p){return y[p].brush.extent()});var formerActive=active.slice(0);active=[];foreground.style("display",function(d){var isActive=actives.every(function(p,i){if((isNaN(d.values[p])||isNaN(parseFloat(d.values[p])))&&extents[i][0]==y[p].brush.y().domain()[0]){return true}return extents[i][0]<=d.values[p]&&d.values[p]<=extents[i][1]&&!isNaN(parseFloat(d.values[p]))});if(isActive)active.push(d);return!isActive?"none":null});if(filters.length>0||!nv.utils.arrayEquals(active,formerActive)){dispatch.activeChanged(active)}function path(d){return line(enabledDimensions.map(function(p){if(isNaN(d.values[p.key])||isNaN(parseFloat(d.values[p.key]))||displayMissingValuesline){var domain=y[p.key].domain();var range=y[p.key].range();var min=domain[0]-(domain[1]-domain[0])/9;if(axisWithUndefinedValues.indexOf(p.key)<0){var newscale=d3.scale.linear().domain([min,domain[1]]).range([availableHeight-12,range[1]]);y[p.key].brush.y(newscale);axisWithUndefinedValues.push(p.key)}if(isNaN(d.values[p.key])||isNaN(parseFloat(d.values[p.key]))){return[x(p.key),y[p.key](min)]}}if(missingValuesline!==undefined){if(axisWithUndefinedValues.length>0||displayMissingValuesline){missingValuesline.style("display","inline");missingValueslineText.style("display","inline")}else{missingValuesline.style("display","none");missingValueslineText.style("display","none")}}return[x(p.key),y[p.key](d.values[p.key])]}))}function restoreBrush(visible){filters.forEach(function(f){var brushDomain=y[f.dimension].brush.y().domain();if(f.hasOnlyNaN){f.extent[1]=(y[f.dimension].domain()[1]-brushDomain[0])*(f.extent[1]-f.extent[0])/(oldDomainMaxValue[f.dimension]-f.extent[0])+brushDomain[0]}if(f.hasNaN){f.extent[0]=brushDomain[0]}if(visible)y[f.dimension].brush.extent(f.extent)});dimensions.select(".nv-brushBackground").each(function(d){d3.select(this).call(y[d.key].brush)}).selectAll("rect").attr("x",-8).attr("width",16);updateTicks()}function brushstart(){if(displayBrush===false){displayBrush=true;restoreBrush(true)}}function brush(){actives=dimensionNames.filter(function(p){return!y[p].brush.empty()});extents=actives.map(function(p){return y[p].brush.extent()});filters=[];actives.forEach(function(d,i){filters[i]={dimension:d,extent:extents[i],hasNaN:false,hasOnlyNaN:false}});active=[];foreground.style("display",function(d){var isActive=actives.every(function(p,i){if((isNaN(d.values[p])||isNaN(parseFloat(d.values[p])))&&extents[i][0]==y[p].brush.y().domain()[0])return true;return extents[i][0]<=d.values[p]&&d.values[p]<=extents[i][1]&&!isNaN(parseFloat(d.values[p]))});if(isActive)active.push(d);return isActive?null:"none"});updateTicks();dispatch.brush({filters:filters,active:active})}function brushend(){var hasActiveBrush=actives.length>0?true:false;filters.forEach(function(f){if(f.extent[0]===y[f.dimension].brush.y().domain()[0]&&axisWithUndefinedValues.indexOf(f.dimension)>=0)f.hasNaN=true;if(f.extent[1]<y[f.dimension].domain()[0])f.hasOnlyNaN=true});dispatch.brushEnd(active,hasActiveBrush)}function updateTicks(){dimensions.select(".nv-axis").each(function(d,i){var f=filters.filter(function(k){return k.dimension==d.key});currentTicks[d.key]=y[d.key].domain();if(f.length!=0&&displayBrush){currentTicks[d.key]=[];if(f[0].extent[1]>y[d.key].domain()[0])currentTicks[d.key]=[f[0].extent[1]];if(f[0].extent[0]>=y[d.key].domain()[0])currentTicks[d.key].push(f[0].extent[0])}d3.select(this).call(axis.scale(y[d.key]).tickFormat(d.format).tickValues(currentTicks[d.key]))})}function dragStart(d){dragging[d.key]=this.parentNode.__origin__=x(d.key);background.attr("visibility","hidden")}function dragMove(d){dragging[d.key]=Math.min(availableWidth,Math.max(0,this.parentNode.__origin__+=d3.event.x));foreground.attr("d",path);enabledDimensions.sort(function(a,b){return dimensionPosition(a.key)-dimensionPosition(b.key)});enabledDimensions.forEach(function(d,i){return d.currentPosition=i});x.domain(enabledDimensions.map(function(d){return d.key}));dimensions.attr("transform",function(d){return"translate("+dimensionPosition(d.key)+")"})}function dragEnd(d,i){delete this.parentNode.__origin__;delete dragging[d.key];d3.select(this.parentNode).attr("transform","translate("+x(d.key)+")");foreground.attr("d",path);background.attr("d",path).attr("visibility",null);dispatch.dimensionsOrder(enabledDimensions)}function dimensionPosition(d){var v=dragging[d];return v==null?x(d):v}});return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},dimensionData:{get:function(){return dimensionData},set:function(_){dimensionData=_}},displayBrush:{get:function(){return displayBrush},set:function(_){displayBrush=_}},filters:{get:function(){return filters},set:function(_){filters=_}},active:{get:function(){return active},set:function(_){active=_}},lineTension:{get:function(){return lineTension},set:function(_){lineTension=_}},undefinedValuesLabel:{get:function(){return undefinedValuesLabel},set:function(_){undefinedValuesLabel=_}},dimensions:{get:function(){return dimensionData.map(function(d){return d.key})},set:function(_){nv.deprecated("dimensions","use dimensionData instead");if(dimensionData.length===0){_.forEach(function(k){dimensionData.push({key:k})})}else{_.forEach(function(k,i){dimensionData[i].key=k})}}},dimensionNames:{get:function(){return dimensionData.map(function(d){return d.key})},set:function(_){nv.deprecated("dimensionNames","use dimensionData instead");dimensionNames=[];if(dimensionData.length===0){_.forEach(function(k){dimensionData.push({key:k})})}else{_.forEach(function(k,i){dimensionData[i].key=k})}}},dimensionFormats:{get:function(){return dimensionData.map(function(d){return d.format})},set:function(_){nv.deprecated("dimensionFormats","use dimensionData instead");if(dimensionData.length===0){_.forEach(function(f){dimensionData.push({format:f})})}else{_.forEach(function(f,i){dimensionData[i].format=f})}}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.parallelCoordinatesChart=function(){"use strict";var parallelCoordinates=nv.models.parallelCoordinates();var legend=nv.models.legend();var tooltip=nv.models.tooltip();var dimensionTooltip=nv.models.tooltip();var margin={top:0,right:0,bottom:0,left:0},marginTop=null,width=null,height=null,showLegend=true,color=nv.utils.defaultColor(),state=nv.utils.state(),dimensionData=[],displayBrush=true,defaultState=null,noData=null,nanValue="undefined",dispatch=d3.dispatch("dimensionsOrder","brushEnd","stateChange","changeState","renderEnd"),controlWidth=function(){return showControls?180:0};var renderWatch=nv.utils.renderWatch(dispatch);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled})}}};var stateSetter=function(data){return function(state){if(state.active!==undefined){data.forEach(function(series,i){series.disabled=!state.active[i]})}}};tooltip.contentGenerator(function(data){var str='<table><thead><tr><td class="legend-color-guide"><div style="background-color:'+data.color+'"></div></td><td><strong>'+data.key+"</strong></td></tr></thead>";if(data.series.length!==0){str=str+'<tbody><tr><td height ="10px"></td></tr>';data.series.forEach(function(d){str=str+'<tr><td class="legend-color-guide"><div style="background-color:'+d.color+'"></div></td><td class="key">'+d.key+'</td><td class="value">'+d.value+"</td></tr>"});str=str+"</tbody>"}str=str+"</table>";return str});function chart(selection){renderWatch.reset();renderWatch.models(parallelCoordinates);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var that=this;var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){container.call(chart)};chart.container=this;state.setter(stateSetter(dimensionData),chart.update).getter(stateGetter(dimensionData)).update();state.disabled=dimensionData.map(function(d){return!!d.disabled});dimensionData=dimensionData.map(function(d){d.disabled=!!d.disabled;return d});dimensionData.forEach(function(d,i){d.originalPosition=isNaN(d.originalPosition)?i:d.originalPosition;d.currentPosition=isNaN(d.currentPosition)?i:d.currentPosition});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}var wrap=container.selectAll("g.nv-wrap.nv-parallelCoordinatesChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-parallelCoordinatesChart").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-parallelCoordinatesWrap");gEnter.append("g").attr("class","nv-legendWrap");g.select("rect").attr("width",availableWidth).attr("height",availableHeight>0?availableHeight:0);if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{legend.width(availableWidth).color(function(d){return"rgb(188,190,192)"});g.select(".nv-legendWrap").datum(dimensionData.sort(function(a,b){return a.originalPosition-b.originalPosition})).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}wrap.select(".nv-legendWrap").attr("transform","translate( 0 ,"+-margin.top+")")}wrap.attr("transform","translate("+margin.left+","+margin.top+")");parallelCoordinates.width(availableWidth).height(availableHeight).dimensionData(dimensionData).displayBrush(displayBrush);var parallelCoordinatesWrap=g.select(".nv-parallelCoordinatesWrap ").datum(data);parallelCoordinatesWrap.transition().call(parallelCoordinates);parallelCoordinates.dispatch.on("brushEnd",function(active,hasActiveBrush){if(hasActiveBrush){displayBrush=true;dispatch.brushEnd(active)}else{displayBrush=false}});legend.dispatch.on("stateChange",function(newState){for(var key in newState){state[key]=newState[key]}dispatch.stateChange(state);chart.update()});parallelCoordinates.dispatch.on("dimensionsOrder",function(e){dimensionData.sort(function(a,b){return a.currentPosition-b.currentPosition});var isSorted=false;dimensionData.forEach(function(d,i){d.currentPosition=i;if(d.currentPosition!==d.originalPosition)isSorted=true});dispatch.dimensionsOrder(dimensionData,isSorted)});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){dimensionData.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}chart.update()})});renderWatch.renderEnd("parraleleCoordinateChart immediate");return chart}parallelCoordinates.dispatch.on("elementMouseover.tooltip",function(evt){var tp={key:evt.label,color:evt.color,series:[]};if(evt.values){Object.keys(evt.values).forEach(function(d){var dim=evt.dimensions.filter(function(dd){return dd.key===d})[0];if(dim){var v;if(isNaN(evt.values[d])||isNaN(parseFloat(evt.values[d]))){v=nanValue}else{v=dim.format(evt.values[d])}tp.series.push({idx:dim.currentPosition,key:d,value:v,color:dim.color})}});tp.series.sort(function(a,b){return a.idx-b.idx})}tooltip.data(tp).hidden(false)});parallelCoordinates.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});parallelCoordinates.dispatch.on("elementMousemove.tooltip",function(){tooltip()});chart.dispatch=dispatch;chart.parallelCoordinates=parallelCoordinates;chart.legend=legend;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},dimensionData:{get:function(){return dimensionData},set:function(_){dimensionData=_}},displayBrush:{get:function(){return displayBrush},set:function(_){displayBrush=_}},noData:{get:function(){return noData},set:function(_){noData=_}},nanValue:{get:function(){return nanValue},set:function(_){nanValue=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color);parallelCoordinates.color(color)}}});nv.utils.inheritOptions(chart,parallelCoordinates);nv.utils.initOptions(chart);return chart};nv.models.pie=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=500,height=500,getX=function(d){return d.x},getY=function(d){return d.y},id=Math.floor(Math.random()*1e4),container=null,color=nv.utils.defaultColor(),valueFormat=d3.format(",.2f"),showLabels=true,labelsOutside=false,labelType="key",labelThreshold=.02,hideOverlapLabels=false,donut=false,title=false,growOnHover=true,titleOffset=0,labelSunbeamLayout=false,startAngle=false,padAngle=false,endAngle=false,cornerRadius=0,donutRatio=.5,duration=250,arcsRadius=[],dispatch=d3.dispatch("chartClick","elementClick","elementDblClick","elementMouseover","elementMouseout","elementMousemove","renderEnd");var arcs=[];var arcsOver=[];var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom,radius=Math.min(availableWidth,availableHeight)/2,arcsRadiusOuter=[],arcsRadiusInner=[];container=d3.select(this);if(arcsRadius.length===0){var outer=radius-radius/10;var inner=donutRatio*radius;for(var i=0;i<data[0].length;i++){arcsRadiusOuter.push(outer);arcsRadiusInner.push(inner)}}else{if(growOnHover){arcsRadiusOuter=arcsRadius.map(function(d){return(d.outer-d.outer/10)*radius});arcsRadiusInner=arcsRadius.map(function(d){return(d.inner-d.inner/10)*radius});donutRatio=d3.min(arcsRadius.map(function(d){return d.inner-d.inner/10}))}else{arcsRadiusOuter=arcsRadius.map(function(d){return d.outer*radius});arcsRadiusInner=arcsRadius.map(function(d){return d.inner*radius});donutRatio=d3.min(arcsRadius.map(function(d){return d.inner}))}}nv.utils.initSVG(container);var wrap=container.selectAll(".nv-wrap.nv-pie").data(data);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-pie nv-chart-"+id);var gEnter=wrapEnter.append("g");var g=wrap.select("g");var g_pie=gEnter.append("g").attr("class","nv-pie");gEnter.append("g").attr("class","nv-pieLabels");wrap.attr("transform","translate("+margin.left+","+margin.top+")");g.select(".nv-pie").attr("transform","translate("+availableWidth/2+","+availableHeight/2+")");g.select(".nv-pieLabels").attr("transform","translate("+availableWidth/2+","+availableHeight/2+")");container.on("click",function(d,i){dispatch.chartClick({data:d,index:i,pos:d3.event,id:id})});arcs=[];arcsOver=[];for(var i=0;i<data[0].length;i++){var arc=d3.svg.arc().outerRadius(arcsRadiusOuter[i]);var arcOver=d3.svg.arc().outerRadius(arcsRadiusOuter[i]+5);if(startAngle!==false){arc.startAngle(startAngle);arcOver.startAngle(startAngle)}if(endAngle!==false){arc.endAngle(endAngle);arcOver.endAngle(endAngle)}if(donut){arc.innerRadius(arcsRadiusInner[i]);arcOver.innerRadius(arcsRadiusInner[i])
}if(arc.cornerRadius&&cornerRadius){arc.cornerRadius(cornerRadius);arcOver.cornerRadius(cornerRadius)}arcs.push(arc);arcsOver.push(arcOver)}var pie=d3.layout.pie().sort(null).value(function(d){return d.disabled?0:getY(d)});if(pie.padAngle&&padAngle){pie.padAngle(padAngle)}if(donut&&title){g_pie.append("text").attr("class","nv-pie-title");wrap.select(".nv-pie-title").style("text-anchor","middle").text(function(d){return title}).style("font-size",Math.min(availableWidth,availableHeight)*donutRatio*2/(title.length+2)+"px").attr("dy","0.35em").attr("transform",function(d,i){return"translate(0, "+titleOffset+")"})}var slices=wrap.select(".nv-pie").selectAll(".nv-slice").data(pie);var pieLabels=wrap.select(".nv-pieLabels").selectAll(".nv-label").data(pie);slices.exit().remove();pieLabels.exit().remove();var ae=slices.enter().append("g");ae.attr("class","nv-slice");ae.on("mouseover",function(d,i){d3.select(this).classed("hover",true);if(growOnHover){d3.select(this).select("path").transition().duration(70).attr("d",arcsOver[i])}dispatch.elementMouseover({data:d.data,index:i,color:d3.select(this).style("fill"),percent:(d.endAngle-d.startAngle)/(2*Math.PI)})});ae.on("mouseout",function(d,i){d3.select(this).classed("hover",false);if(growOnHover){d3.select(this).select("path").transition().duration(50).attr("d",arcs[i])}dispatch.elementMouseout({data:d.data,index:i})});ae.on("mousemove",function(d,i){dispatch.elementMousemove({data:d.data,index:i})});ae.on("click",function(d,i){var element=this;dispatch.elementClick({data:d.data,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element})});ae.on("dblclick",function(d,i){dispatch.elementDblClick({data:d.data,index:i,color:d3.select(this).style("fill")})});slices.attr("fill",function(d,i){return color(d.data,i)});slices.attr("stroke",function(d,i){return color(d.data,i)});var paths=ae.append("path").each(function(d){this._current=d});slices.select("path").transition().duration(duration).attr("d",function(d,i){return arcs[i](d)}).attrTween("d",arcTween);if(showLabels){var labelsArc=[];for(var i=0;i<data[0].length;i++){labelsArc.push(arcs[i]);if(labelsOutside){if(donut){labelsArc[i]=d3.svg.arc().outerRadius(arcs[i].outerRadius());if(startAngle!==false)labelsArc[i].startAngle(startAngle);if(endAngle!==false)labelsArc[i].endAngle(endAngle)}}else if(!donut){labelsArc[i].innerRadius(0)}}pieLabels.enter().append("g").classed("nv-label",true).each(function(d,i){var group=d3.select(this);group.attr("transform",function(d,i){if(labelSunbeamLayout){d.outerRadius=arcsRadiusOuter[i]+10;d.innerRadius=arcsRadiusOuter[i]+15;var rotateAngle=(d.startAngle+d.endAngle)/2*(180/Math.PI);if((d.startAngle+d.endAngle)/2<Math.PI){rotateAngle-=90}else{rotateAngle+=90}return"translate("+labelsArc[i].centroid(d)+") rotate("+rotateAngle+")"}else{d.outerRadius=radius+10;d.innerRadius=radius+15;return"translate("+labelsArc[i].centroid(d)+")"}});group.append("rect").style("stroke","#fff").style("fill","#fff").attr("rx",3).attr("ry",3);group.append("text").style("text-anchor",labelSunbeamLayout?(d.startAngle+d.endAngle)/2<Math.PI?"start":"end":"middle").style("fill","#000")});var labelLocationHash={};var avgHeight=14;var avgWidth=140;var createHashKey=function(coordinates){return Math.floor(coordinates[0]/avgWidth)*avgWidth+","+Math.floor(coordinates[1]/avgHeight)*avgHeight};var getSlicePercentage=function(d){return(d.endAngle-d.startAngle)/(2*Math.PI)};pieLabels.watchTransition(renderWatch,"pie labels").attr("transform",function(d,i){if(labelSunbeamLayout){d.outerRadius=arcsRadiusOuter[i]+10;d.innerRadius=arcsRadiusOuter[i]+15;var rotateAngle=(d.startAngle+d.endAngle)/2*(180/Math.PI);if((d.startAngle+d.endAngle)/2<Math.PI){rotateAngle-=90}else{rotateAngle+=90}return"translate("+labelsArc[i].centroid(d)+") rotate("+rotateAngle+")"}else{d.outerRadius=radius+10;d.innerRadius=radius+15;var center=labelsArc[i].centroid(d);var percent=getSlicePercentage(d);if(d.value&&percent>=labelThreshold){var hashKey=createHashKey(center);if(labelLocationHash[hashKey]){center[1]-=avgHeight}labelLocationHash[createHashKey(center)]=true}return"translate("+center+")"}});pieLabels.select(".nv-label text").style("text-anchor",function(d,i){return labelSunbeamLayout?(d.startAngle+d.endAngle)/2<Math.PI?"start":"end":"middle"}).text(function(d,i){var percent=getSlicePercentage(d);var label="";if(!d.value||percent<labelThreshold)return"";if(typeof labelType==="function"){label=labelType(d,i,{key:getX(d.data),value:getY(d.data),percent:valueFormat(percent)})}else{switch(labelType){case"key":label=getX(d.data);break;case"value":label=valueFormat(getY(d.data));break;case"percent":label=d3.format("%")(percent);break}}return label});if(hideOverlapLabels){pieLabels.each(function(d,i){if(!this.getBBox)return;var bb=this.getBBox(),center=labelsArc[i].centroid(d);var topLeft={x:center[0]+bb.x,y:center[1]+bb.y};var topRight={x:topLeft.x+bb.width,y:topLeft.y};var bottomLeft={x:topLeft.x,y:topLeft.y+bb.height};var bottomRight={x:topLeft.x+bb.width,y:topLeft.y+bb.height};d.visible=nv.utils.pointIsInArc(topLeft,d,arc)&&nv.utils.pointIsInArc(topRight,d,arc)&&nv.utils.pointIsInArc(bottomLeft,d,arc)&&nv.utils.pointIsInArc(bottomRight,d,arc)}).style("display",function(d){return d.visible?null:"none"})}}function angle(d){var a=(d.startAngle+d.endAngle)*90/Math.PI-90;return a>90?a-180:a}function arcTween(a,idx){a.endAngle=isNaN(a.endAngle)?0:a.endAngle;a.startAngle=isNaN(a.startAngle)?0:a.startAngle;if(!donut)a.innerRadius=0;var i=d3.interpolate(this._current,a);this._current=i(0);return function(t){return arcs[idx](i(t))}}});renderWatch.renderEnd("pie immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{arcsRadius:{get:function(){return arcsRadius},set:function(_){arcsRadius=_}},width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLabels:{get:function(){return showLabels},set:function(_){showLabels=_}},title:{get:function(){return title},set:function(_){title=_}},titleOffset:{get:function(){return titleOffset},set:function(_){titleOffset=_}},labelThreshold:{get:function(){return labelThreshold},set:function(_){labelThreshold=_}},hideOverlapLabels:{get:function(){return hideOverlapLabels},set:function(_){hideOverlapLabels=_}},valueFormat:{get:function(){return valueFormat},set:function(_){valueFormat=_}},x:{get:function(){return getX},set:function(_){getX=_}},id:{get:function(){return id},set:function(_){id=_}},endAngle:{get:function(){return endAngle},set:function(_){endAngle=_}},startAngle:{get:function(){return startAngle},set:function(_){startAngle=_}},padAngle:{get:function(){return padAngle},set:function(_){padAngle=_}},cornerRadius:{get:function(){return cornerRadius},set:function(_){cornerRadius=_}},donutRatio:{get:function(){return donutRatio},set:function(_){donutRatio=_}},labelsOutside:{get:function(){return labelsOutside},set:function(_){labelsOutside=_}},labelSunbeamLayout:{get:function(){return labelSunbeamLayout},set:function(_){labelSunbeamLayout=_}},donut:{get:function(){return donut},set:function(_){donut=_}},growOnHover:{get:function(){return growOnHover},set:function(_){growOnHover=_}},pieLabelsOutside:{get:function(){return labelsOutside},set:function(_){labelsOutside=_;nv.deprecated("pieLabelsOutside","use labelsOutside instead")}},donutLabelsOutside:{get:function(){return labelsOutside},set:function(_){labelsOutside=_;nv.deprecated("donutLabelsOutside","use labelsOutside instead")}},labelFormat:{get:function(){return valueFormat},set:function(_){valueFormat=_;nv.deprecated("labelFormat","use valueFormat instead")}},margin:{get:function(){return margin},set:function(_){margin.top=typeof _.top!="undefined"?_.top:margin.top;margin.right=typeof _.right!="undefined"?_.right:margin.right;margin.bottom=typeof _.bottom!="undefined"?_.bottom:margin.bottom;margin.left=typeof _.left!="undefined"?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}},y:{get:function(){return getY},set:function(_){getY=d3.functor(_)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},labelType:{get:function(){return labelType},set:function(_){labelType=_||"key"}}});nv.utils.initOptions(chart);return chart};nv.models.pieChart=function(){"use strict";var pie=nv.models.pie();var legend=nv.models.legend();var tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:20,left:20},marginTop=null,width=null,height=null,showTooltipPercent=false,showLegend=true,legendPosition="top",color=nv.utils.defaultColor(),state=nv.utils.state(),defaultState=null,noData=null,duration=250,dispatch=d3.dispatch("stateChange","changeState","renderEnd");tooltip.duration(0).headerEnabled(false).valueFormatter(function(d,i){return pie.valueFormat()(d,i)});var renderWatch=nv.utils.renderWatch(dispatch);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled})}}};var stateSetter=function(data){return function(state){if(state.active!==undefined){data.forEach(function(series,i){series.disabled=!state.active[i]})}}};function chart(selection){renderWatch.reset();renderWatch.models(pie);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var that=this;var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){container.transition().call(chart)};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}var wrap=container.selectAll("g.nv-wrap.nv-pieChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-pieChart").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-pieWrap");gEnter.append("g").attr("class","nv-legendWrap");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{if(legendPosition==="top"){legend.width(availableWidth).key(pie.x());wrap.select(".nv-legendWrap").datum(data).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}wrap.select(".nv-legendWrap").attr("transform","translate(0,"+-margin.top+")")}else if(legendPosition==="right"){var legendWidth=nv.models.legend().width();if(availableWidth/2<legendWidth){legendWidth=availableWidth/2}legend.height(availableHeight).key(pie.x());legend.width(legendWidth);availableWidth-=legend.width();wrap.select(".nv-legendWrap").datum(data).call(legend).attr("transform","translate("+availableWidth+",0)")}else if(legendPosition==="bottom"){legend.width(availableWidth).key(pie.x());wrap.select(".nv-legendWrap").datum(data).call(legend);margin.bottom=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);wrap.select(".nv-legendWrap").attr("transform","translate(0,"+availableHeight+")")}}wrap.attr("transform","translate("+margin.left+","+margin.top+")");pie.width(availableWidth).height(availableHeight);var pieWrap=g.select(".nv-pieWrap").datum([data]);d3.transition(pieWrap).call(pie);legend.dispatch.on("stateChange",function(newState){for(var key in newState){state[key]=newState[key]}dispatch.stateChange(state);chart.update()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}chart.update()})});renderWatch.renderEnd("pieChart immediate");return chart}pie.dispatch.on("elementMouseover.tooltip",function(evt){evt["series"]={key:chart.x()(evt.data),value:chart.y()(evt.data),color:evt.color,percent:evt.percent};if(!showTooltipPercent){delete evt.percent;delete evt.series.percent}tooltip.data(evt).hidden(false)});pie.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});pie.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.legend=legend;chart.dispatch=dispatch;chart.pie=pie;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},noData:{get:function(){return noData},set:function(_){noData=_}},showTooltipPercent:{get:function(){return showTooltipPercent},set:function(_){showTooltipPercent=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},legendPosition:{get:function(){return legendPosition},set:function(_){legendPosition=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},color:{get:function(){return color},set:function(_){color=_;legend.color(color);pie.color(color)}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);pie.duration(duration)}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}}});nv.utils.inheritOptions(chart,pie);nv.utils.initOptions(chart);return chart};nv.models.sankey=function(){"use strict";var sankey={},nodeWidth=24,nodePadding=8,size=[1,1],nodes=[],links=[],sinksRight=true;var layout=function(iterations){computeNodeLinks();computeNodeValues();computeNodeBreadths();computeNodeDepths(iterations)};var relayout=function(){computeLinkDepths()};var link=function(){var curvature=.5;function link(d){var x0=d.source.x+d.source.dx,x1=d.target.x,xi=d3.interpolateNumber(x0,x1),x2=xi(curvature),x3=xi(1-curvature),y0=d.source.y+d.sy+d.dy/2,y1=d.target.y+d.ty+d.dy/2;var linkPath="M"+x0+","+y0+"C"+x2+","+y0+" "+x3+","+y1+" "+x1+","+y1;return linkPath}link.curvature=function(_){if(!arguments.length)return curvature;curvature=+_;return link};return link};var center=function(node){return node.y+node.dy/2};function computeNodeLinks(){nodes.forEach(function(node){node.sourceLinks=[];node.targetLinks=[]});links.forEach(function(link){var source=link.source,target=link.target;if(typeof source==="number")source=link.source=nodes[link.source];if(typeof target==="number")target=link.target=nodes[link.target];source.sourceLinks.push(link);target.targetLinks.push(link)})}function computeNodeValues(){nodes.forEach(function(node){node.value=Math.max(d3.sum(node.sourceLinks,value),d3.sum(node.targetLinks,value))})}function computeNodeBreadths(){var remainingNodes=nodes,nextNodes,x=0;while(remainingNodes.length&&x<nodes.length){nextNodes=[];remainingNodes.forEach(function(node){node.x=x;node.dx=nodeWidth;node.sourceLinks.forEach(function(link){if(nextNodes.indexOf(link.target)<0){nextNodes.push(link.target)}})});remainingNodes=nextNodes;++x}if(sinksRight){moveSinksRight(x)}scaleNodeBreadths((size[0]-nodeWidth)/(x-1))}function moveSourcesRight(){nodes.forEach(function(node){if(!node.targetLinks.length){node.x=d3.min(node.sourceLinks,function(d){return d.target.x})-1}})}function moveSinksRight(x){nodes.forEach(function(node){if(!node.sourceLinks.length){node.x=x-1}})}function scaleNodeBreadths(kx){nodes.forEach(function(node){node.x*=kx})}function computeNodeDepths(iterations){var nodesByBreadth=d3.nest().key(function(d){return d.x}).sortKeys(d3.ascending).entries(nodes).map(function(d){return d.values});initializeNodeDepth();resolveCollisions();computeLinkDepths();for(var alpha=1;iterations>0;--iterations){relaxRightToLeft(alpha*=.99);resolveCollisions();computeLinkDepths();relaxLeftToRight(alpha);resolveCollisions();computeLinkDepths()}function initializeNodeDepth(){var ky=d3.min(nodesByBreadth,function(nodes){return(size[1]-(nodes.length-1)*nodePadding)/d3.sum(nodes,value)});nodesByBreadth.forEach(function(nodes){nodes.forEach(function(node,i){node.y=i;node.dy=node.value*ky})});links.forEach(function(link){link.dy=link.value*ky})}function relaxLeftToRight(alpha){nodesByBreadth.forEach(function(nodes,breadth){nodes.forEach(function(node){if(node.targetLinks.length){var y=d3.sum(node.targetLinks,weightedSource)/d3.sum(node.targetLinks,value);node.y+=(y-center(node))*alpha}})});function weightedSource(link){return(link.source.y+link.sy+link.dy/2)*link.value}}function relaxRightToLeft(alpha){nodesByBreadth.slice().reverse().forEach(function(nodes){nodes.forEach(function(node){if(node.sourceLinks.length){var y=d3.sum(node.sourceLinks,weightedTarget)/d3.sum(node.sourceLinks,value);node.y+=(y-center(node))*alpha}})});function weightedTarget(link){return(link.target.y+link.ty+link.dy/2)*link.value}}function resolveCollisions(){nodesByBreadth.forEach(function(nodes){var node,dy,y0=0,n=nodes.length,i;nodes.sort(ascendingDepth);for(i=0;i<n;++i){node=nodes[i];dy=y0-node.y;if(dy>0)node.y+=dy;y0=node.y+node.dy+nodePadding}dy=y0-nodePadding-size[1];if(dy>0){y0=node.y-=dy;for(i=n-2;i>=0;--i){node=nodes[i];dy=node.y+node.dy+nodePadding-y0;if(dy>0)node.y-=dy;y0=node.y}}})}function ascendingDepth(a,b){return a.y-b.y}}function computeLinkDepths(){nodes.forEach(function(node){node.sourceLinks.sort(ascendingTargetDepth);node.targetLinks.sort(ascendingSourceDepth)});nodes.forEach(function(node){var sy=0,ty=0;node.sourceLinks.forEach(function(link){link.sy=sy;sy+=link.dy});node.targetLinks.forEach(function(link){link.ty=ty;ty+=link.dy})});function ascendingSourceDepth(a,b){return a.source.y-b.source.y}function ascendingTargetDepth(a,b){return a.target.y-b.target.y}}function value(x){return x.value}sankey.options=nv.utils.optionsFunc.bind(sankey);sankey._options=Object.create({},{nodeWidth:{get:function(){return nodeWidth},set:function(_){nodeWidth=+_}},nodePadding:{get:function(){return nodePadding},set:function(_){nodePadding=_}},nodes:{get:function(){return nodes},set:function(_){nodes=_}},links:{get:function(){return links},set:function(_){links=_}},size:{get:function(){return size},set:function(_){size=_}},sinksRight:{get:function(){return sinksRight},set:function(_){sinksRight=_}},layout:{get:function(){layout(32)},set:function(_){layout(_)}},relayout:{get:function(){relayout()},set:function(_){}},center:{get:function(){return center()},set:function(_){if(typeof _==="function"){center=_}}},link:{get:function(){return link()},set:function(_){if(typeof _==="function"){link=_}return link()}}});nv.utils.initOptions(sankey);return sankey};nv.models.sankeyChart=function(){"use strict";var margin={top:5,right:0,bottom:5,left:0},sankey=nv.models.sankey(),width=600,height=400,nodeWidth=36,nodePadding=40,units="units",center=undefined;var formatNumber=d3.format(",.0f");var format=function(d){return formatNumber(d)+" "+units};var color=d3.scale.category20();var linkTitle=function(d){return d.source.name+" → "+d.target.name+"\n"+format(d.value)};var nodeFillColor=function(d){return d.color=color(d.name.replace(/ .*/,""))};var nodeStrokeColor=function(d){return d3.rgb(d.color).darker(2)};var nodeTitle=function(d){return d.name+"\n"+format(d.value)};var showError=function(element,message){element.append("text").attr("x",0).attr("y",0).attr("class","nvd3-sankey-chart-error").attr("text-anchor","middle").text(message)};function chart(selection){selection.each(function(data){var testData={nodes:[{node:1,name:"Test 1"},{node:2,name:"Test 2"},{node:3,name:"Test 3"},{node:4,name:"Test 4"},{node:5,name:"Test 5"},{node:6,name:"Test 6"}],links:[{source:0,target:1,value:2295},{source:0,target:5,value:1199},{source:1,target:2,value:1119},{source:1,target:5,value:1176},{source:2,target:3,value:487},{source:2,target:5,value:632},{source:3,target:4,value:301},{source:3,target:5,value:186}]};var isDataValid=false;var dataAvailable=false;if((typeof data["nodes"]==="object"&&data["nodes"].length)>=0&&(typeof data["links"]==="object"&&data["links"].length)>=0){isDataValid=true}if(data["nodes"]&&data["nodes"].length>0&&data["links"]&&data["links"].length>0){dataAvailable=true}if(!isDataValid){console.error("NVD3 Sankey chart error:","invalid data format for",data);console.info("Valid data format is: ",testData,JSON.stringify(testData));showError(selection,"Error loading chart, data is invalid");return false}if(!dataAvailable){showError(selection,"No data available");return false}var svg=selection.append("svg").attr("width",width).attr("height",height).append("g").attr("class","nvd3 nv-wrap nv-sankeyChart");sankey.nodeWidth(nodeWidth).nodePadding(nodePadding).size([width,height]);var path=sankey.link();sankey.nodes(data.nodes).links(data.links).layout(32).center(center);var link=svg.append("g").selectAll(".link").data(data.links).enter().append("path").attr("class","link").attr("d",path).style("stroke-width",function(d){return Math.max(1,d.dy)}).sort(function(a,b){return b.dy-a.dy});link.append("title").text(linkTitle);var node=svg.append("g").selectAll(".node").data(data.nodes).enter().append("g").attr("class","node").attr("transform",function(d){return"translate("+d.x+","+d.y+")"}).call(d3.behavior.drag().origin(function(d){return d}).on("dragstart",function(){this.parentNode.appendChild(this)}).on("drag",dragmove));node.append("rect").attr("height",function(d){return d.dy}).attr("width",sankey.nodeWidth()).style("fill",nodeFillColor).style("stroke",nodeStrokeColor).append("title").text(nodeTitle);node.append("text").attr("x",-6).attr("y",function(d){return d.dy/2}).attr("dy",".35em").attr("text-anchor","end").attr("transform",null).text(function(d){return d.name}).filter(function(d){return d.x<width/2}).attr("x",6+sankey.nodeWidth()).attr("text-anchor","start");function dragmove(d){d3.select(this).attr("transform","translate("+d.x+","+(d.y=Math.max(0,Math.min(height-d.dy,d3.event.y)))+")");sankey.relayout();link.attr("d",path)}});return chart}chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{units:{get:function(){return units},set:function(_){units=_}},width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},format:{get:function(){return format},set:function(_){format=_}},linkTitle:{get:function(){return linkTitle},set:function(_){linkTitle=_}},nodeWidth:{get:function(){return nodeWidth},set:function(_){nodeWidth=_}},nodePadding:{get:function(){return nodePadding},set:function(_){nodePadding=_}},center:{get:function(){return center},set:function(_){center=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},nodeStyle:{get:function(){return{}},set:function(_){nodeFillColor=_.fillColor!==undefined?_.fillColor:nodeFillColor;nodeStrokeColor=_.strokeColor!==undefined?_.strokeColor:nodeStrokeColor;nodeTitle=_.title!==undefined?_.title:nodeTitle}}});nv.utils.initOptions(chart);return chart};nv.models.scatter=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=null,height=null,color=nv.utils.defaultColor(),pointBorderColor=null,id=Math.floor(Math.random()*1e5),container=null,x=d3.scale.linear(),y=d3.scale.linear(),z=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},getSize=function(d){return d.size||1},getShape=function(d){return d.shape||"circle"},forceX=[],forceY=[],forceSize=[],interactive=true,pointActive=function(d){return!d.notActive},padData=false,padDataOuter=.1,clipEdge=false,clipVoronoi=true,showVoronoi=false,clipRadius=function(){return 25},xDomain=null,yDomain=null,xRange=null,yRange=null,sizeDomain=null,sizeRange=null,singlePoint=false,dispatch=d3.dispatch("elementClick","elementDblClick","elementMouseover","elementMouseout","renderEnd"),useVoronoi=true,duration=250,interactiveUpdateDelay=300,showLabels=false;var x0,y0,z0,xDom,yDom,width0,height0,timeoutID,needsUpdate=false,renderWatch=nv.utils.renderWatch(dispatch,duration),_sizeRange_def=[16,256],_cache={};function getCache(d){var key,val;key=d[0].series+":"+d[1];val=_cache[key]=_cache[key]||{};return val}function delCache(d){var key,val;key=d[0].series+":"+d[1];delete _cache[key]}function getDiffs(d){var i,key,val,cache=getCache(d),diffs=false;for(i=1;i<arguments.length;i+=2){key=arguments[i];val=arguments[i+1](d[0],d[1]);if(cache[key]!==val||!cache.hasOwnProperty(key)){cache[key]=val;diffs=true}}return diffs}function chart(selection){renderWatch.reset();selection.each(function(data){container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);data.forEach(function(series,i){series.values.forEach(function(point){point.series=i})});var logScale=typeof chart.yScale().base==="function";var seriesData=xDomain&&yDomain&&sizeDomain?[]:d3.merge(data.map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),size:getSize(d,i)}})}));x.domain(xDomain||d3.extent(seriesData.map(function(d){return d.x}).concat(forceX)));if(padData&&data[0])x.range(xRange||[(availableWidth*padDataOuter+availableWidth)/(2*data[0].values.length),availableWidth-availableWidth*(1+padDataOuter)/(2*data[0].values.length)]);else x.range(xRange||[0,availableWidth]);if(logScale){var min=d3.min(seriesData.map(function(d){if(d.y!==0)return d.y}));y.clamp(true).domain(yDomain||d3.extent(seriesData.map(function(d){if(d.y!==0)return d.y;else return min*.1}).concat(forceY))).range(yRange||[availableHeight,0])}else{y.domain(yDomain||d3.extent(seriesData.map(function(d){return d.y}).concat(forceY))).range(yRange||[availableHeight,0])}z.domain(sizeDomain||d3.extent(seriesData.map(function(d){return d.size}).concat(forceSize))).range(sizeRange||_sizeRange_def);singlePoint=x.domain()[0]===x.domain()[1]||y.domain()[0]===y.domain()[1];if(x.domain()[0]===x.domain()[1])x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*.01,x.domain()[1]+x.domain()[1]*.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])y.domain()[0]?y.domain([y.domain()[0]-y.domain()[0]*.01,y.domain()[1]+y.domain()[1]*.01]):y.domain([-1,1]);if(isNaN(x.domain()[0])){x.domain([-1,1])}if(isNaN(y.domain()[0])){y.domain([-1,1])}x0=x0||x;y0=y0||y;z0=z0||z;var scaleDiff=x(1)!==x0(1)||y(1)!==y0(1)||z(1)!==z0(1);width0=width0||width;height0=height0||height;var sizeDiff=width0!==width||height0!==height;xDom=xDom||[];var domainDiff=xDom[0]!==x.domain()[0]||xDom[1]!==x.domain()[1];xDom=x.domain();yDom=yDom||[];domainDiff=domainDiff||yDom[0]!==y.domain()[0]||yDom[1]!==y.domain()[1];yDom=y.domain();var wrap=container.selectAll("g.nv-wrap.nv-scatter").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-scatter nv-chart-"+id);var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");wrap.classed("nv-single-point",singlePoint);gEnter.append("g").attr("class","nv-groups");gEnter.append("g").attr("class","nv-point-paths");wrapEnter.append("g").attr("class","nv-point-clips");wrap.attr("transform","translate("+margin.left+","+margin.top+")");defsEnter.append("clipPath").attr("id","nv-edge-clip-"+id).append("rect").attr("transform","translate( -10, -10)");wrap.select("#nv-edge-clip-"+id+" rect").attr("width",availableWidth+20).attr("height",availableHeight>0?availableHeight+20:0);g.attr("clip-path",clipEdge?"url(#nv-edge-clip-"+id+")":"");function updateInteractiveLayer(){needsUpdate=false;if(!interactive)return false;if(useVoronoi===true){wrap.select(".nv-point-paths").selectAll("path").remove();var vertices=d3.merge(data.map(function(group,groupIndex){return group.values.map(function(point,pointIndex){var pX=getX(point,pointIndex);var pY=getY(point,pointIndex);return[nv.utils.NaNtoZero(x(pX))+Math.random()*1e-4,nv.utils.NaNtoZero(y(pY))+Math.random()*1e-4,groupIndex,pointIndex,point]}).filter(function(pointArray,pointIndex){return pointActive(pointArray[4],pointIndex)})}));if(vertices.length==0)return false;if(vertices.length<3){vertices.push([x.range()[0]-20,y.range()[0]-20,null,null]);vertices.push([x.range()[1]+20,y.range()[1]+20,null,null]);vertices.push([x.range()[0]-20,y.range()[0]+20,null,null]);vertices.push([x.range()[1]+20,y.range()[1]-20,null,null])}var bounds=d3.geom.polygon([[-10,-10],[-10,height+10],[width+10,height+10],[width+10,-10]]);var epsilon=1e-4;vertices=vertices.sort(function(a,b){return a[0]-b[0]||a[1]-b[1]});for(var i=0;i<vertices.length-1;){if(Math.abs(vertices[i][0]-vertices[i+1][0])<epsilon&&Math.abs(vertices[i][1]-vertices[i+1][1])<epsilon){vertices.splice(i+1,1)}else{i++}}var voronoi=d3.geom.voronoi(vertices).map(function(d,i){return{data:bounds.clip(d),series:vertices[i][2],point:vertices[i][3]}});var pointPaths=wrap.select(".nv-point-paths").selectAll("path").data(voronoi);var vPointPaths=pointPaths.enter().append("svg:path").attr("d",function(d){if(!d||!d.data||d.data.length===0)return"M 0 0";else return"M"+d.data.join(",")+"Z"}).attr("id",function(d,i){return"nv-path-"+i}).attr("clip-path",function(d,i){return"url(#nv-clip-"+id+"-"+i+")"});if(showVoronoi){vPointPaths.style("fill",d3.rgb(230,230,230)).style("fill-opacity",.4).style("stroke-opacity",1).style("stroke",d3.rgb(200,200,200))}if(clipVoronoi){wrap.select(".nv-point-clips").selectAll("*").remove();var pointClips=wrap.select(".nv-point-clips").selectAll("clipPath").data(vertices);var vPointClips=pointClips.enter().append("svg:clipPath").attr("id",function(d,i){return"nv-clip-"+id+"-"+i}).append("svg:circle").attr("cx",function(d){return d[0]}).attr("cy",function(d){return d[1]}).attr("r",clipRadius)}var mouseEventCallback=function(el,d,mDispatch){if(needsUpdate)return 0;var series=data[d.series];if(series===undefined)return;var point=series.values[d.point];point["color"]=color(series,d.series);point["x"]=getX(point);point["y"]=getY(point);var box=container.node().getBoundingClientRect();var scrollTop=window.pageYOffset||document.documentElement.scrollTop;var scrollLeft=window.pageXOffset||document.documentElement.scrollLeft;var pos={left:x(getX(point,d.point))+box.left+scrollLeft+margin.left+10,top:y(getY(point,d.point))+box.top+scrollTop+margin.top+10};mDispatch({point:point,series:series,pos:pos,relativePos:[x(getX(point,d.point))+margin.left,y(getY(point,d.point))+margin.top],seriesIndex:d.series,pointIndex:d.point,event:d3.event,element:el})};pointPaths.on("click",function(d){mouseEventCallback(this,d,dispatch.elementClick)}).on("dblclick",function(d){mouseEventCallback(this,d,dispatch.elementDblClick)}).on("mouseover",function(d){mouseEventCallback(this,d,dispatch.elementMouseover)}).on("mouseout",function(d,i){mouseEventCallback(this,d,dispatch.elementMouseout)})}else{wrap.select(".nv-groups").selectAll(".nv-group").selectAll(".nv-point").on("click",function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];var element=this;dispatch.elementClick({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i,event:d3.event,element:element})}).on("dblclick",function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementDblClick({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i})}).on("mouseover",function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementMouseover({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i,color:color(d,i)})
}).on("mouseout",function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementMouseout({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i,color:color(d,i)})})}}needsUpdate=true;var groups=wrap.select(".nv-groups").selectAll(".nv-group").data(function(d){return d},function(d){return d.key});groups.enter().append("g").style("stroke-opacity",1e-6).style("fill-opacity",1e-6);groups.exit().remove();groups.attr("class",function(d,i){return(d.classed||"")+" nv-group nv-series-"+i}).classed("nv-noninteractive",!interactive).classed("hover",function(d){return d.hover});groups.watchTransition(renderWatch,"scatter: groups").style("fill",function(d,i){return color(d,i)}).style("stroke",function(d,i){return d.pointBorderColor||pointBorderColor||color(d,i)}).style("stroke-opacity",1).style("fill-opacity",.5);var points=groups.selectAll("path.nv-point").data(function(d){return d.values.map(function(point,pointIndex){return[point,pointIndex]}).filter(function(pointArray,pointIndex){return pointActive(pointArray[0],pointIndex)})});points.enter().append("path").attr("class",function(d){return"nv-point nv-point-"+d[1]}).style("fill",function(d){return d.color}).style("stroke",function(d){return d.color}).attr("transform",function(d){return"translate("+nv.utils.NaNtoZero(x0(getX(d[0],d[1])))+","+nv.utils.NaNtoZero(y0(getY(d[0],d[1])))+")"}).attr("d",nv.utils.symbol().type(function(d){return getShape(d[0])}).size(function(d){return z(getSize(d[0],d[1]))}));points.exit().each(delCache).remove();groups.exit().selectAll("path.nv-point").watchTransition(renderWatch,"scatter exit").attr("transform",function(d){return"translate("+nv.utils.NaNtoZero(x(getX(d[0],d[1])))+","+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+")"}).remove();points.filter(function(d){return getDiffs(d,"x",getX,"y",getY)||scaleDiff||sizeDiff||domainDiff}).watchTransition(renderWatch,"scatter points").attr("transform",function(d){return"translate("+nv.utils.NaNtoZero(x(getX(d[0],d[1])))+","+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+")"});points.filter(function(d){return getDiffs(d,"shape",getShape,"size",getSize)||scaleDiff||sizeDiff||domainDiff}).watchTransition(renderWatch,"scatter points").attr("d",nv.utils.symbol().type(function(d){return getShape(d[0])}).size(function(d){return z(getSize(d[0],d[1]))}));if(showLabels){var titles=groups.selectAll(".nv-label").data(function(d){return d.values.map(function(point,pointIndex){return[point,pointIndex]}).filter(function(pointArray,pointIndex){return pointActive(pointArray[0],pointIndex)})});titles.enter().append("text").style("fill",function(d,i){return d.color}).style("stroke-opacity",0).style("fill-opacity",1).attr("transform",function(d){var dx=nv.utils.NaNtoZero(x0(getX(d[0],d[1])))+Math.sqrt(z(getSize(d[0],d[1]))/Math.PI)+2;return"translate("+dx+","+nv.utils.NaNtoZero(y0(getY(d[0],d[1])))+")"}).text(function(d,i){return d[0].label});titles.exit().remove();groups.exit().selectAll("path.nv-label").watchTransition(renderWatch,"scatter exit").attr("transform",function(d){var dx=nv.utils.NaNtoZero(x(getX(d[0],d[1])))+Math.sqrt(z(getSize(d[0],d[1]))/Math.PI)+2;return"translate("+dx+","+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+")"}).remove();titles.each(function(d){d3.select(this).classed("nv-label",true).classed("nv-label-"+d[1],false).classed("hover",false)});titles.watchTransition(renderWatch,"scatter labels").attr("transform",function(d){var dx=nv.utils.NaNtoZero(x(getX(d[0],d[1])))+Math.sqrt(z(getSize(d[0],d[1]))/Math.PI)+2;return"translate("+dx+","+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+")"})}if(interactiveUpdateDelay){clearTimeout(timeoutID);timeoutID=setTimeout(updateInteractiveLayer,interactiveUpdateDelay)}else{updateInteractiveLayer()}x0=x.copy();y0=y.copy();z0=z.copy();width0=width;height0=height});renderWatch.renderEnd("scatter immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._calls=new function(){this.clearHighlights=function(){nv.dom.write(function(){container.selectAll(".nv-point.hover").classed("hover",false)});return null};this.highlightPoint=function(seriesIndex,pointIndex,isHoverOver){nv.dom.write(function(){container.select(".nv-groups").selectAll(".nv-series-"+seriesIndex).selectAll(".nv-point-"+pointIndex).classed("hover",isHoverOver)})}};dispatch.on("elementMouseover.point",function(d){if(interactive)chart._calls.highlightPoint(d.seriesIndex,d.pointIndex,true)});dispatch.on("elementMouseout.point",function(d){if(interactive)chart._calls.highlightPoint(d.seriesIndex,d.pointIndex,false)});chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},pointScale:{get:function(){return z},set:function(_){z=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},pointDomain:{get:function(){return sizeDomain},set:function(_){sizeDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},pointRange:{get:function(){return sizeRange},set:function(_){sizeRange=_}},forceX:{get:function(){return forceX},set:function(_){forceX=_}},forceY:{get:function(){return forceY},set:function(_){forceY=_}},forcePoint:{get:function(){return forceSize},set:function(_){forceSize=_}},interactive:{get:function(){return interactive},set:function(_){interactive=_}},pointActive:{get:function(){return pointActive},set:function(_){pointActive=_}},padDataOuter:{get:function(){return padDataOuter},set:function(_){padDataOuter=_}},padData:{get:function(){return padData},set:function(_){padData=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},clipVoronoi:{get:function(){return clipVoronoi},set:function(_){clipVoronoi=_}},clipRadius:{get:function(){return clipRadius},set:function(_){clipRadius=_}},showVoronoi:{get:function(){return showVoronoi},set:function(_){showVoronoi=_}},id:{get:function(){return id},set:function(_){id=_}},interactiveUpdateDelay:{get:function(){return interactiveUpdateDelay},set:function(_){interactiveUpdateDelay=_}},showLabels:{get:function(){return showLabels},set:function(_){showLabels=_}},pointBorderColor:{get:function(){return pointBorderColor},set:function(_){pointBorderColor=_}},x:{get:function(){return getX},set:function(_){getX=d3.functor(_)}},y:{get:function(){return getY},set:function(_){getY=d3.functor(_)}},pointSize:{get:function(){return getSize},set:function(_){getSize=d3.functor(_)}},pointShape:{get:function(){return getShape},set:function(_){getShape=d3.functor(_)}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},useVoronoi:{get:function(){return useVoronoi},set:function(_){useVoronoi=_;if(useVoronoi===false){clipVoronoi=false}}}});nv.utils.initOptions(chart);return chart};nv.models.scatterChart=function(){"use strict";var scatter=nv.models.scatter(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),distX=nv.models.distribution(),distY=nv.models.distribution(),tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:50,left:75},marginTop=null,width=null,height=null,container=null,color=nv.utils.defaultColor(),x=scatter.xScale(),y=scatter.yScale(),showDistX=false,showDistY=false,showLegend=true,showXAxis=true,showYAxis=true,rightAlignYAxis=false,state=nv.utils.state(),defaultState=null,dispatch=d3.dispatch("stateChange","changeState","renderEnd"),noData=null,duration=250,showLabels=false;scatter.xScale(x).yScale(y);xAxis.orient("bottom").tickPadding(10);yAxis.orient(rightAlignYAxis?"right":"left").tickPadding(10);distX.axis("x");distY.axis("y");tooltip.headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)});var x0,y0,renderWatch=nv.utils.renderWatch(dispatch,duration);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled})}}};var stateSetter=function(data){return function(state){if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};function chart(selection){renderWatch.reset();renderWatch.models(scatter);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);if(showDistX)renderWatch.models(distX);if(showDistY)renderWatch.models(distY);selection.each(function(data){var that=this;container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){if(duration===0)container.call(chart);else container.transition().duration(duration).call(chart)};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);renderWatch.renderEnd("scatter immediate");return chart}else{container.selectAll(".nv-noData").remove()}x=scatter.xScale();y=scatter.yScale();var wrap=container.selectAll("g.nv-wrap.nv-scatterChart").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-scatterChart nv-chart-"+scatter.id());var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("rect").attr("class","nvd3 nv-background").style("pointer-events","none");gEnter.append("g").attr("class","nv-x nv-axis");gEnter.append("g").attr("class","nv-y nv-axis");gEnter.append("g").attr("class","nv-scatterWrap");gEnter.append("g").attr("class","nv-regressionLinesWrap");gEnter.append("g").attr("class","nv-distWrap");gEnter.append("g").attr("class","nv-legendWrap");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{var legendWidth=availableWidth;legend.width(legendWidth);wrap.select(".nv-legendWrap").datum(data).call(legend);if(!marginTop&&legend.height()!==margin.top){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)}wrap.select(".nv-legendWrap").attr("transform","translate(0"+","+-margin.top+")")}wrap.attr("transform","translate("+margin.left+","+margin.top+")");scatter.width(availableWidth).height(availableHeight).color(data.map(function(d,i){d.color=d.color||color(d,i);return d.color}).filter(function(d,i){return!data[i].disabled})).showLabels(showLabels);wrap.select(".nv-scatterWrap").datum(data.filter(function(d){return!d.disabled})).call(scatter);wrap.select(".nv-regressionLinesWrap").attr("clip-path","url(#nv-edge-clip-"+scatter.id()+")");var regWrap=wrap.select(".nv-regressionLinesWrap").selectAll(".nv-regLines").data(function(d){return d});regWrap.enter().append("g").attr("class","nv-regLines");var regLine=regWrap.selectAll(".nv-regLine").data(function(d){return[d]});regLine.enter().append("line").attr("class","nv-regLine").style("stroke-opacity",0);regLine.filter(function(d){return d.intercept&&d.slope}).watchTransition(renderWatch,"scatterPlusLineChart: regline").attr("x1",x.range()[0]).attr("x2",x.range()[1]).attr("y1",function(d,i){return y(x.domain()[0]*d.slope+d.intercept)}).attr("y2",function(d,i){return y(x.domain()[1]*d.slope+d.intercept)}).style("stroke",function(d,i,j){return color(d,j)}).style("stroke-opacity",function(d,i){return d.disabled||typeof d.slope==="undefined"||typeof d.intercept==="undefined"?0:1});if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select(".nv-x.nv-axis").attr("transform","translate(0,"+y.range()[0]+")").call(xAxis)}if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select(".nv-y.nv-axis").call(yAxis)}if(showDistX){distX.getData(scatter.x()).scale(x).width(availableWidth).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));gEnter.select(".nv-distWrap").append("g").attr("class","nv-distributionX");g.select(".nv-distributionX").attr("transform","translate(0,"+y.range()[0]+")").datum(data.filter(function(d){return!d.disabled})).call(distX)}if(showDistY){distY.getData(scatter.y()).scale(y).width(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));gEnter.select(".nv-distWrap").append("g").attr("class","nv-distributionY");g.select(".nv-distributionY").attr("transform","translate("+(rightAlignYAxis?availableWidth:-distY.size())+",0)").datum(data.filter(function(d){return!d.disabled})).call(distY)}legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}chart.update()});scatter.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true);container.select(".nv-chart-"+scatter.id()+" .nv-series-"+evt.seriesIndex+" .nv-distx-"+evt.pointIndex).attr("y1",0);container.select(".nv-chart-"+scatter.id()+" .nv-series-"+evt.seriesIndex+" .nv-disty-"+evt.pointIndex).attr("x2",distY.size())});scatter.dispatch.on("elementMouseover.tooltip",function(evt){container.select(".nv-series-"+evt.seriesIndex+" .nv-distx-"+evt.pointIndex).attr("y1",evt.relativePos[1]-availableHeight);container.select(".nv-series-"+evt.seriesIndex+" .nv-disty-"+evt.pointIndex).attr("x2",evt.relativePos[0]+distX.size());tooltip.data(evt).hidden(false)});x0=x.copy();y0=y.copy()});renderWatch.renderEnd("scatter with line immediate");return chart}chart.dispatch=dispatch;chart.scatter=scatter;chart.legend=legend;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.distX=distX;chart.distY=distY;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},container:{get:function(){return container},set:function(_){container=_}},showDistX:{get:function(){return showDistX},set:function(_){showDistX=_}},showDistY:{get:function(){return showDistY},set:function(_){showDistY=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},duration:{get:function(){return duration},set:function(_){duration=_}},showLabels:{get:function(){return showLabels},set:function(_){showLabels=_}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(_?"right":"left")}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color);distX.color(color);distY.color(color)}}});nv.utils.inheritOptions(chart,scatter);nv.utils.initOptions(chart);return chart};nv.models.sparkline=function(){"use strict";var margin={top:2,right:0,bottom:2,left:0},width=400,height=32,container=null,animate=true,x=d3.scale.linear(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},color=nv.utils.getColor(["#000"]),xDomain,yDomain,xRange,yRange,showMinMaxPoints=true,showCurrentPoint=true,dispatch=d3.dispatch("renderEnd");var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);x.domain(xDomain||d3.extent(data,getX)).range(xRange||[0,availableWidth]);y.domain(yDomain||d3.extent(data,getY)).range(yRange||[availableHeight,0]);var wrap=container.selectAll("g.nv-wrap.nv-sparkline").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-sparkline");var gEnter=wrapEnter.append("g");var g=wrap.select("g");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var paths=wrap.selectAll("path").data(function(d){return[d]});paths.enter().append("path");paths.exit().remove();paths.style("stroke",function(d,i){return d.color||color(d,i)}).attr("d",d3.svg.line().x(function(d,i){return x(getX(d,i))}).y(function(d,i){return y(getY(d,i))}));var points=wrap.selectAll("circle.nv-point").data(function(data){var yValues=data.map(function(d,i){return getY(d,i)});function pointIndex(index){if(index!=-1){var result=data[index];result.pointIndex=index;return result}else{return null}}var maxPoint=pointIndex(yValues.lastIndexOf(y.domain()[1])),minPoint=pointIndex(yValues.indexOf(y.domain()[0])),currentPoint=pointIndex(yValues.length-1);return[showMinMaxPoints?minPoint:null,showMinMaxPoints?maxPoint:null,showCurrentPoint?currentPoint:null].filter(function(d){return d!=null})});points.enter().append("circle");points.exit().remove();points.attr("cx",function(d,i){return x(getX(d,d.pointIndex))}).attr("cy",function(d,i){return y(getY(d,d.pointIndex))}).attr("r",2).attr("class",function(d,i){return getX(d,d.pointIndex)==x.domain()[1]?"nv-point nv-currentValue":getY(d,d.pointIndex)==y.domain()[0]?"nv-point nv-minValue":"nv-point nv-maxValue"})});renderWatch.renderEnd("sparkline immediate");return chart}chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},xDomain:{get:function(){return xDomain},set:function(_){xDomain=_}},yDomain:{get:function(){return yDomain},set:function(_){yDomain=_}},xRange:{get:function(){return xRange},set:function(_){xRange=_}},yRange:{get:function(){return yRange},set:function(_){yRange=_}},xScale:{get:function(){return x},set:function(_){x=_}},yScale:{get:function(){return y},set:function(_){y=_}},animate:{get:function(){return animate},set:function(_){animate=_}},showMinMaxPoints:{get:function(){return showMinMaxPoints},set:function(_){showMinMaxPoints=_}},showCurrentPoint:{get:function(){return showCurrentPoint},set:function(_){showCurrentPoint=_}},x:{get:function(){return getX},set:function(_){getX=d3.functor(_)}},y:{get:function(){return getY},set:function(_){getY=d3.functor(_)}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});chart.dispatch=dispatch;nv.utils.initOptions(chart);return chart};nv.models.sparklinePlus=function(){"use strict";var sparkline=nv.models.sparkline();var margin={top:15,right:100,bottom:10,left:50},width=null,height=null,x,y,index=[],paused=false,xTickFormat=d3.format(",r"),yTickFormat=d3.format(",.2f"),showLastValue=true,alignValue=true,rightAlignValue=false,noData=null,dispatch=d3.dispatch("renderEnd");var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();renderWatch.models(sparkline);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){container.call(chart)};chart.container=this;if(!data||!data.length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}var currentValue=sparkline.y()(data[data.length-1],data.length-1);x=sparkline.xScale();y=sparkline.yScale();var wrap=container.selectAll("g.nv-wrap.nv-sparklineplus").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-sparklineplus");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-sparklineWrap");gEnter.append("g").attr("class","nv-valueWrap");gEnter.append("g").attr("class","nv-hoverArea");wrap.attr("transform","translate("+margin.left+","+margin.top+")");var sparklineWrap=g.select(".nv-sparklineWrap");sparkline.width(availableWidth).height(availableHeight);sparklineWrap.call(sparkline);if(showLastValue){var valueWrap=g.select(".nv-valueWrap");var value=valueWrap.selectAll(".nv-currentValue").data([currentValue]);value.enter().append("text").attr("class","nv-currentValue").attr("dx",rightAlignValue?-8:8).attr("dy",".9em").style("text-anchor",rightAlignValue?"end":"start");value.attr("x",availableWidth+(rightAlignValue?margin.right:0)).attr("y",alignValue?function(d){return y(d)}:0).style("fill",sparkline.color()(data[data.length-1],data.length-1)).text(yTickFormat(currentValue))}gEnter.select(".nv-hoverArea").append("rect").on("mousemove",sparklineHover).on("click",function(){paused=!paused}).on("mouseout",function(){index=[];updateValueLine()});g.select(".nv-hoverArea rect").attr("transform",function(d){return"translate("+-margin.left+","+-margin.top+")"}).attr("width",availableWidth+margin.left+margin.right).attr("height",availableHeight+margin.top);function updateValueLine(){if(paused)return;var hoverValue=g.selectAll(".nv-hoverValue").data(index);var hoverEnter=hoverValue.enter().append("g").attr("class","nv-hoverValue").style("stroke-opacity",0).style("fill-opacity",0);hoverValue.exit().transition().duration(250).style("stroke-opacity",0).style("fill-opacity",0).remove();hoverValue.attr("transform",function(d){return"translate("+x(sparkline.x()(data[d],d))+",0)"}).transition().duration(250).style("stroke-opacity",1).style("fill-opacity",1);if(!index.length)return;hoverEnter.append("line").attr("x1",0).attr("y1",-margin.top).attr("x2",0).attr("y2",availableHeight);hoverEnter.append("text").attr("class","nv-xValue").attr("x",-6).attr("y",-margin.top).attr("text-anchor","end").attr("dy",".9em");g.select(".nv-hoverValue .nv-xValue").text(xTickFormat(sparkline.x()(data[index[0]],index[0])));hoverEnter.append("text").attr("class","nv-yValue").attr("x",6).attr("y",-margin.top).attr("text-anchor","start").attr("dy",".9em");g.select(".nv-hoverValue .nv-yValue").text(yTickFormat(sparkline.y()(data[index[0]],index[0])))}function sparklineHover(){if(paused)return;var pos=d3.mouse(this)[0]-margin.left;function getClosestIndex(data,x){var distance=Math.abs(sparkline.x()(data[0],0)-x);var closestIndex=0;for(var i=0;i<data.length;i++){if(Math.abs(sparkline.x()(data[i],i)-x)<distance){distance=Math.abs(sparkline.x()(data[i],i)-x);closestIndex=i}}return closestIndex}index=[getClosestIndex(data,Math.round(x.invert(pos)))];updateValueLine()}});renderWatch.renderEnd("sparklinePlus immediate");return chart}chart.dispatch=dispatch;chart.sparkline=sparkline;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},xTickFormat:{get:function(){return xTickFormat},set:function(_){xTickFormat=_}},yTickFormat:{get:function(){return yTickFormat},set:function(_){yTickFormat=_}},showLastValue:{get:function(){return showLastValue},set:function(_){showLastValue=_}},alignValue:{get:function(){return alignValue},set:function(_){alignValue=_}},rightAlignValue:{get:function(){return rightAlignValue},set:function(_){rightAlignValue=_}},noData:{get:function(){return noData},set:function(_){noData=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}}});nv.utils.inheritOptions(chart,sparkline);nv.utils.initOptions(chart);return chart};nv.models.stackedArea=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,color=nv.utils.defaultColor(),id=Math.floor(Math.random()*1e5),container=null,getX=function(d){return d.x},getY=function(d){return d.y},defined=function(d,i){return!isNaN(getY(d,i))&&getY(d,i)!==null},style="stack",offset="zero",order="default",interpolate="linear",clipEdge=false,x,y,scatter=nv.models.scatter(),duration=250,dispatch=d3.dispatch("areaClick","areaMouseover","areaMouseout","renderEnd","elementClick","elementMouseover","elementMouseout");scatter.pointSize(2.2).pointDomain([2.2,2.2]);var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(scatter);selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);x=scatter.xScale();y=scatter.yScale();var dataRaw=data;data.forEach(function(aseries,i){aseries.seriesIndex=i;aseries.values=aseries.values.map(function(d,j){d.index=j;d.seriesIndex=i;return d})});var dataFiltered=data.filter(function(series){return!series.disabled});data=d3.layout.stack().order(order).offset(offset).values(function(d){return d.values}).x(getX).y(getY).out(function(d,y0,y){d.display={y:y,y0:y0}})(dataFiltered);var wrap=container.selectAll("g.nv-wrap.nv-stackedarea").data([data]);var wrapEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-stackedarea");var defsEnter=wrapEnter.append("defs");var gEnter=wrapEnter.append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-areaWrap");gEnter.append("g").attr("class","nv-scatterWrap");wrap.attr("transform","translate("+margin.left+","+margin.top+")");if(scatter.forceY().length==0){scatter.forceY().push(0)}scatter.width(availableWidth).height(availableHeight).x(getX).y(function(d){if(d.display!==undefined){return d.display.y+d.display.y0}}).color(data.map(function(d,i){d.color=d.color||color(d,d.seriesIndex);return d.color}));var scatterWrap=g.select(".nv-scatterWrap").datum(data);scatterWrap.call(scatter);defsEnter.append("clipPath").attr("id","nv-edge-clip-"+id).append("rect");wrap.select("#nv-edge-clip-"+id+" rect").attr("width",availableWidth).attr("height",availableHeight);g.attr("clip-path",clipEdge?"url(#nv-edge-clip-"+id+")":"");var area=d3.svg.area().defined(defined).x(function(d,i){return x(getX(d,i))}).y0(function(d){return y(d.display.y0)}).y1(function(d){return y(d.display.y+d.display.y0)}).interpolate(interpolate);var zeroArea=d3.svg.area().defined(defined).x(function(d,i){return x(getX(d,i))}).y0(function(d){return y(d.display.y0)}).y1(function(d){return y(d.display.y0)});var path=g.select(".nv-areaWrap").selectAll("path.nv-area").data(function(d){return d});path.enter().append("path").attr("class",function(d,i){return"nv-area nv-area-"+i}).attr("d",function(d,i){return zeroArea(d.values,d.seriesIndex)}).on("mouseover",function(d,i){d3.select(this).classed("hover",true);dispatch.areaMouseover({point:d,series:d.key,pos:[d3.event.pageX,d3.event.pageY],seriesIndex:d.seriesIndex})}).on("mouseout",function(d,i){d3.select(this).classed("hover",false);dispatch.areaMouseout({point:d,series:d.key,pos:[d3.event.pageX,d3.event.pageY],seriesIndex:d.seriesIndex})}).on("click",function(d,i){d3.select(this).classed("hover",false);dispatch.areaClick({point:d,series:d.key,pos:[d3.event.pageX,d3.event.pageY],seriesIndex:d.seriesIndex})});path.exit().remove();path.style("fill",function(d,i){return d.color||color(d,d.seriesIndex)}).style("stroke",function(d,i){return d.color||color(d,d.seriesIndex)});path.watchTransition(renderWatch,"stackedArea path").attr("d",function(d,i){return area(d.values,i)});scatter.dispatch.on("elementMouseover.area",function(e){g.select(".nv-chart-"+id+" .nv-area-"+e.seriesIndex).classed("hover",true)});scatter.dispatch.on("elementMouseout.area",function(e){g.select(".nv-chart-"+id+" .nv-area-"+e.seriesIndex).classed("hover",false)});chart.d3_stackedOffset_stackPercent=function(stackData){var n=stackData.length,m=stackData[0].length,i,j,o,y0=[];for(j=0;j<m;++j){for(i=0,o=0;i<dataRaw.length;i++){o+=getY(dataRaw[i].values[j])}if(o)for(i=0;i<n;i++){stackData[i][j][1]/=o}else{for(i=0;i<n;i++){stackData[i][j][1]=0}}}for(j=0;j<m;++j)y0[j]=0;return y0}});renderWatch.renderEnd("stackedArea immediate");return chart}chart.dispatch=dispatch;chart.scatter=scatter;scatter.dispatch.on("elementClick",function(){dispatch.elementClick.apply(this,arguments)});scatter.dispatch.on("elementMouseover",function(){dispatch.elementMouseover.apply(this,arguments)});scatter.dispatch.on("elementMouseout",function(){dispatch.elementMouseout.apply(this,arguments)});chart.interpolate=function(_){if(!arguments.length)return interpolate;interpolate=_;return chart};chart.duration=function(_){if(!arguments.length)return duration;duration=_;renderWatch.reset(duration);scatter.duration(duration);return chart};chart.dispatch=dispatch;chart.scatter=scatter;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},defined:{get:function(){return defined},set:function(_){defined=_}},clipEdge:{get:function(){return clipEdge},set:function(_){clipEdge=_}},offset:{get:function(){return offset},set:function(_){offset=_}},order:{get:function(){return order},set:function(_){order=_}},interpolate:{get:function(){return interpolate},set:function(_){interpolate=_}},x:{get:function(){return getX},set:function(_){getX=d3.functor(_)}},y:{get:function(){return getY},set:function(_){getY=d3.functor(_)}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}},style:{get:function(){return style},set:function(_){style=_;switch(style){case"stack":chart.offset("zero");chart.order("default");break;case"stream":chart.offset("wiggle");chart.order("inside-out");break;case"stream-center":chart.offset("silhouette");chart.order("inside-out");break;case"expand":chart.offset("expand");chart.order("default");break;case"stack_percent":chart.offset(chart.d3_stackedOffset_stackPercent);chart.order("default");break}}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);scatter.duration(duration)}}});nv.utils.inheritOptions(chart,scatter);nv.utils.initOptions(chart);return chart};nv.models.stackedAreaChart=function(){"use strict";var stacked=nv.models.stackedArea(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),controls=nv.models.legend(),interactiveLayer=nv.interactiveGuideline(),tooltip=nv.models.tooltip(),focus=nv.models.focus(nv.models.stackedArea());
var margin={top:10,right:25,bottom:50,left:60},marginTop=null,width=null,height=null,color=nv.utils.defaultColor(),showControls=true,showLegend=true,legendPosition="top",showXAxis=true,showYAxis=true,rightAlignYAxis=false,focusEnable=false,useInteractiveGuideline=false,showTotalInTooltip=true,totalLabel="TOTAL",x,y,state=nv.utils.state(),defaultState=null,noData=null,dispatch=d3.dispatch("stateChange","changeState","renderEnd"),controlWidth=250,controlOptions=["Stacked","Stream","Expanded"],controlLabels={},duration=250;state.style=stacked.style();xAxis.orient("bottom").tickPadding(7);yAxis.orient(rightAlignYAxis?"right":"left");tooltip.headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i)});interactiveLayer.tooltip.headerFormatter(function(d,i){return xAxis.tickFormat()(d,i)}).valueFormatter(function(d,i){return d==null?"N/A":yAxis.tickFormat()(d,i)});var oldYTickFormat=null,oldValueFormatter=null;controls.updateState(false);var renderWatch=nv.utils.renderWatch(dispatch);var style=stacked.style();var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled}),style:stacked.style()}}};var stateSetter=function(data){return function(state){if(state.style!==undefined)style=state.style;if(state.active!==undefined)data.forEach(function(series,i){series.disabled=!state.active[i]})}};var percentFormatter=d3.format("%");function chart(selection){renderWatch.reset();renderWatch.models(stacked);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin)-(focusEnable?focus.height():0);chart.update=function(){container.transition().duration(duration).call(chart)};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)defaultState[key]=state[key].slice(0);else defaultState[key]=state[key]}}if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}x=stacked.xScale();y=stacked.yScale();var wrap=container.selectAll("g.nv-wrap.nv-stackedAreaChart").data([data]);var gEnter=wrap.enter().append("g").attr("class","nvd3 nv-wrap nv-stackedAreaChart").append("g");var g=wrap.select("g");gEnter.append("g").attr("class","nv-legendWrap");gEnter.append("g").attr("class","nv-controlsWrap");var focusEnter=gEnter.append("g").attr("class","nv-focus");focusEnter.append("g").attr("class","nv-background").append("rect");focusEnter.append("g").attr("class","nv-x nv-axis");focusEnter.append("g").attr("class","nv-y nv-axis");focusEnter.append("g").attr("class","nv-stackedWrap");focusEnter.append("g").attr("class","nv-interactive");var contextEnter=gEnter.append("g").attr("class","nv-focusWrap");if(!showLegend){g.select(".nv-legendWrap").selectAll("*").remove()}else{var legendWidth=showControls&&legendPosition==="top"?availableWidth-controlWidth:availableWidth;legend.width(legendWidth);g.select(".nv-legendWrap").datum(data).call(legend);if(legendPosition==="bottom"){var xAxisHeight=(showXAxis?12:0)+10;margin.bottom=Math.max(legend.height()+xAxisHeight,margin.bottom);availableHeight=nv.utils.availableHeight(height,container,margin)-(focusEnable?focus.height():0);var legendTop=availableHeight+xAxisHeight;g.select(".nv-legendWrap").attr("transform","translate(0,"+legendTop+")")}else if(legendPosition==="top"){if(!marginTop&&margin.top!=legend.height()){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin)-(focusEnable?focus.height():0)}g.select(".nv-legendWrap").attr("transform","translate("+(availableWidth-legendWidth)+","+-margin.top+")")}}if(!showControls){g.select(".nv-controlsWrap").selectAll("*").remove()}else{var controlsData=[{key:controlLabels.stacked||"Stacked",metaKey:"Stacked",disabled:stacked.style()!="stack",style:"stack"},{key:controlLabels.stream||"Stream",metaKey:"Stream",disabled:stacked.style()!="stream",style:"stream"},{key:controlLabels.expanded||"Expanded",metaKey:"Expanded",disabled:stacked.style()!="expand",style:"expand"},{key:controlLabels.stack_percent||"Stack %",metaKey:"Stack_Percent",disabled:stacked.style()!="stack_percent",style:"stack_percent"}];controlWidth=controlOptions.length/3*260;controlsData=controlsData.filter(function(d){return controlOptions.indexOf(d.metaKey)!==-1});controls.width(controlWidth).color(["#444","#444","#444"]);g.select(".nv-controlsWrap").datum(controlsData).call(controls);var requiredTop=Math.max(controls.height(),showLegend&&legendPosition==="top"?legend.height():0);if(margin.top!=requiredTop){margin.top=requiredTop;availableHeight=nv.utils.availableHeight(height,container,margin)-(focusEnable?focus.height():0)}g.select(".nv-controlsWrap").attr("transform","translate(0,"+-margin.top+")")}wrap.attr("transform","translate("+margin.left+","+margin.top+")");if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)")}if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer)}g.select(".nv-focus .nv-background rect").attr("width",availableWidth).attr("height",availableHeight);stacked.width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i)}).filter(function(d,i){return!data[i].disabled}));var stackedWrap=g.select(".nv-focus .nv-stackedWrap").datum(data.filter(function(d){return!d.disabled}));if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0)}if(showYAxis){var ticks;if(stacked.offset()==="wiggle"){ticks=0}else{ticks=nv.utils.calcTicksY(availableHeight/36,data)}yAxis.scale(y)._ticks(ticks).tickSize(-availableWidth,0)}function updateXAxis(){if(showXAxis){g.select(".nv-focus .nv-x.nv-axis").attr("transform","translate(0,"+availableHeight+")").transition().duration(duration).call(xAxis)}}function updateYAxis(){if(showYAxis){if(stacked.style()==="expand"||stacked.style()==="stack_percent"){var currentFormat=yAxis.tickFormat();if(!oldYTickFormat||currentFormat!==percentFormatter)oldYTickFormat=currentFormat;yAxis.tickFormat(percentFormatter)}else{if(oldYTickFormat){yAxis.tickFormat(oldYTickFormat);oldYTickFormat=null}}g.select(".nv-focus .nv-y.nv-axis").transition().duration(0).call(yAxis)}}if(!focusEnable){stackedWrap.transition().call(stacked);updateXAxis();updateYAxis()}else{focus.width(availableWidth);g.select(".nv-focusWrap").attr("transform","translate(0,"+(availableHeight+margin.bottom+focus.margin().top)+")").datum(data.filter(function(d){return!d.disabled})).call(focus);var extent=focus.brush.empty()?focus.xDomain():focus.brush.extent();if(extent!==null){onBrush(extent)}}stacked.dispatch.on("areaClick.toggle",function(e){if(data.filter(function(d){return!d.disabled}).length===1)data.forEach(function(d){d.disabled=false});else data.forEach(function(d,i){d.disabled=i!=e.seriesIndex});state.disabled=data.map(function(d){return!!d.disabled});dispatch.stateChange(state);chart.update()});legend.dispatch.on("stateChange",function(newState){for(var key in newState)state[key]=newState[key];dispatch.stateChange(state);chart.update()});controls.dispatch.on("legendClick",function(d,i){if(!d.disabled)return;controlsData=controlsData.map(function(s){s.disabled=true;return s});d.disabled=false;stacked.style(d.style);state.style=stacked.style();dispatch.stateChange(state);chart.update()});interactiveLayer.dispatch.on("elementMousemove",function(e){stacked.clearHighlights();var singlePoint,pointIndex,pointXLocation,allData=[],valueSum=0,allNullValues=true,atleastOnePoint=false;data.filter(function(series,i){series.seriesIndex=i;return!series.disabled}).forEach(function(series,i){pointIndex=nv.interactiveBisect(series.values,e.pointXValue,chart.x());var point=series.values[pointIndex];var pointYValue=chart.y()(point,pointIndex);if(pointYValue!=null&&pointYValue>0){stacked.highlightPoint(i,pointIndex,true);atleastOnePoint=true}if(i===data.length-1&&!atleastOnePoint){stacked.highlightPoint(i,pointIndex,true)}if(typeof point==="undefined")return;if(typeof singlePoint==="undefined")singlePoint=point;if(typeof pointXLocation==="undefined")pointXLocation=chart.xScale()(chart.x()(point,pointIndex));var tooltipValue=stacked.style()=="expand"?point.display.y:chart.y()(point,pointIndex);allData.push({key:series.key,value:tooltipValue,color:color(series,series.seriesIndex),point:point});if(showTotalInTooltip&&stacked.style()!="expand"&&tooltipValue!=null){valueSum+=tooltipValue;allNullValues=false}});allData.reverse();if(allData.length>2){var yValue=chart.yScale().invert(e.mouseY);var yDistMax=Infinity,indexToHighlight=null;allData.forEach(function(series,i){yValue=Math.abs(yValue);var stackedY0=Math.abs(series.point.display.y0);var stackedY=Math.abs(series.point.display.y);if(yValue>=stackedY0&&yValue<=stackedY+stackedY0){indexToHighlight=i;return}});if(indexToHighlight!=null)allData[indexToHighlight].highlight=true}if(showTotalInTooltip&&stacked.style()!="expand"&&allData.length>=2&&!allNullValues){allData.push({key:totalLabel,value:valueSum,total:true})}var xValue=chart.x()(singlePoint,pointIndex);var valueFormatter=interactiveLayer.tooltip.valueFormatter();if(stacked.style()==="expand"||stacked.style()==="stack_percent"){if(!oldValueFormatter){oldValueFormatter=valueFormatter}valueFormatter=d3.format(".1%")}else{if(oldValueFormatter){valueFormatter=oldValueFormatter;oldValueFormatter=null}}interactiveLayer.tooltip.valueFormatter(valueFormatter).data({value:xValue,series:allData})();interactiveLayer.renderGuideLine(pointXLocation)});interactiveLayer.dispatch.on("elementMouseout",function(e){stacked.clearHighlights()});focus.dispatch.on("onBrush",function(extent){onBrush(extent)});dispatch.on("changeState",function(e){if(typeof e.disabled!=="undefined"&&data.length===e.disabled.length){data.forEach(function(series,i){series.disabled=e.disabled[i]});state.disabled=e.disabled}if(typeof e.style!=="undefined"){stacked.style(e.style);style=e.style}chart.update()});function onBrush(extent){var stackedWrap=g.select(".nv-focus .nv-stackedWrap").datum(data.filter(function(d){return!d.disabled}).map(function(d,i){return{key:d.key,area:d.area,classed:d.classed,values:d.values.filter(function(d,i){return stacked.x()(d,i)>=extent[0]&&stacked.x()(d,i)<=extent[1]}),disableTooltip:d.disableTooltip}}));stackedWrap.transition().duration(duration).call(stacked);updateXAxis();updateYAxis()}});renderWatch.renderEnd("stacked Area chart immediate");return chart}stacked.dispatch.on("elementMouseover.tooltip",function(evt){evt.point["x"]=stacked.x()(evt.point);evt.point["y"]=stacked.y()(evt.point);tooltip.data(evt).hidden(false)});stacked.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});chart.dispatch=dispatch;chart.stacked=stacked;chart.legend=legend;chart.controls=controls;chart.xAxis=xAxis;chart.x2Axis=focus.xAxis;chart.yAxis=yAxis;chart.y2Axis=focus.yAxis;chart.interactiveLayer=interactiveLayer;chart.tooltip=tooltip;chart.focus=focus;chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},showLegend:{get:function(){return showLegend},set:function(_){showLegend=_}},legendPosition:{get:function(){return legendPosition},set:function(_){legendPosition=_}},showXAxis:{get:function(){return showXAxis},set:function(_){showXAxis=_}},showYAxis:{get:function(){return showYAxis},set:function(_){showYAxis=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},noData:{get:function(){return noData},set:function(_){noData=_}},showControls:{get:function(){return showControls},set:function(_){showControls=_}},controlLabels:{get:function(){return controlLabels},set:function(_){controlLabels=_}},controlOptions:{get:function(){return controlOptions},set:function(_){controlOptions=_}},showTotalInTooltip:{get:function(){return showTotalInTooltip},set:function(_){showTotalInTooltip=_}},totalLabel:{get:function(){return totalLabel},set:function(_){totalLabel=_}},focusEnable:{get:function(){return focusEnable},set:function(_){focusEnable=_}},focusHeight:{get:function(){return focus.height()},set:function(_){focus.height(_)}},brushExtent:{get:function(){return focus.brushExtent()},set:function(_){focus.brushExtent(_)}},margin:{get:function(){return margin},set:function(_){if(_.top!==undefined){margin.top=_.top;marginTop=_.top}margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left}},focusMargin:{get:function(){return focus.margin},set:function(_){focus.margin.top=_.top!==undefined?_.top:focus.margin.top;focus.margin.right=_.right!==undefined?_.right:focus.margin.right;focus.margin.bottom=_.bottom!==undefined?_.bottom:focus.margin.bottom;focus.margin.left=_.left!==undefined?_.left:focus.margin.left}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);stacked.duration(duration);xAxis.duration(duration);yAxis.duration(duration)}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_);legend.color(color);stacked.color(color);focus.color(color)}},x:{get:function(){return stacked.x()},set:function(_){stacked.x(_);focus.x(_)}},y:{get:function(){return stacked.y()},set:function(_){stacked.y(_);focus.y(_)}},rightAlignYAxis:{get:function(){return rightAlignYAxis},set:function(_){rightAlignYAxis=_;yAxis.orient(rightAlignYAxis?"right":"left")}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline},set:function(_){useInteractiveGuideline=!!_;chart.interactive(!_);chart.useVoronoi(!_);stacked.scatter.interactive(!_)}}});nv.utils.inheritOptions(chart,stacked);nv.utils.initOptions(chart);return chart};nv.models.stackedAreaWithFocusChart=function(){return nv.models.stackedAreaChart().margin({bottom:30}).focusEnable(true)};nv.models.sunburst=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=600,height=600,mode="count",modes={count:function(d){return 1},value:function(d){return d.value||d.size},size:function(d){return d.value||d.size}},id=Math.floor(Math.random()*1e4),container=null,color=nv.utils.defaultColor(),showLabels=false,labelFormat=function(d){if(mode==="count"){return d.name+" #"+d.value}else{return d.name+" "+(d.value||d.size)}},labelThreshold=.02,sort=function(d1,d2){return d1.name>d2.name},key=function(d,i){if(d.parent!==undefined){return d.name+"-"+d.parent.name+"-"+i}else{return d.name}},groupColorByParent=true,duration=500,dispatch=d3.dispatch("chartClick","elementClick","elementDblClick","elementMousemove","elementMouseover","elementMouseout","renderEnd");var x=d3.scale.linear().range([0,2*Math.PI]);var y=d3.scale.sqrt();var partition=d3.layout.partition().sort(sort);var node,availableWidth,availableHeight,radius;var prevPositions={};var arc=d3.svg.arc().startAngle(function(d){return Math.max(0,Math.min(2*Math.PI,x(d.x)))}).endAngle(function(d){return Math.max(0,Math.min(2*Math.PI,x(d.x+d.dx)))}).innerRadius(function(d){return Math.max(0,y(d.y))}).outerRadius(function(d){return Math.max(0,y(d.y+d.dy))});function rotationToAvoidUpsideDown(d){var centerAngle=computeCenterAngle(d);if(centerAngle>90){return 180}else{return 0}}function computeCenterAngle(d){var startAngle=Math.max(0,Math.min(2*Math.PI,x(d.x)));var endAngle=Math.max(0,Math.min(2*Math.PI,x(d.x+d.dx)));var centerAngle=(startAngle+endAngle)/2*(180/Math.PI)-90;return centerAngle}function computeNodePercentage(d){var startAngle=Math.max(0,Math.min(2*Math.PI,x(d.x)));var endAngle=Math.max(0,Math.min(2*Math.PI,x(d.x+d.dx)));return(endAngle-startAngle)/(2*Math.PI)}function labelThresholdMatched(d){var startAngle=Math.max(0,Math.min(2*Math.PI,x(d.x)));var endAngle=Math.max(0,Math.min(2*Math.PI,x(d.x+d.dx)));var size=endAngle-startAngle;return size>labelThreshold}function arcTweenZoom(e,i){var xd=d3.interpolate(x.domain(),[node.x,node.x+node.dx]),yd=d3.interpolate(y.domain(),[node.y,1]),yr=d3.interpolate(y.range(),[node.y?20:0,radius]);if(i===0){return function(){return arc(e)}}else{return function(t){x.domain(xd(t));y.domain(yd(t)).range(yr(t));return arc(e)}}}function arcTweenUpdate(d){var ipo=d3.interpolate({x:d.x0,dx:d.dx0,y:d.y0,dy:d.dy0},d);return function(t){var b=ipo(t);d.x0=b.x;d.dx0=b.dx;d.y0=b.y;d.dy0=b.dy;return arc(b)}}function updatePrevPosition(node){var k=key(node);if(!prevPositions[k])prevPositions[k]={};var pP=prevPositions[k];pP.dx=node.dx;pP.x=node.x;pP.dy=node.dy;pP.y=node.y}function storeRetrievePrevPositions(nodes){nodes.forEach(function(n){var k=key(n);var pP=prevPositions[k];if(pP){n.dx0=pP.dx;n.x0=pP.x;n.dy0=pP.dy;n.y0=pP.y}else{n.dx0=n.dx;n.x0=n.x;n.dy0=n.dy;n.y0=n.y}updatePrevPosition(n)})}function zoomClick(d){var labels=container.selectAll("text");var path=container.selectAll("path");labels.transition().attr("opacity",0);node=d;path.transition().duration(duration).attrTween("d",arcTweenZoom).each("end",function(e){if(e.x>=d.x&&e.x<d.x+d.dx){if(e.depth>=d.depth){var parentNode=d3.select(this.parentNode);var arcText=parentNode.select("text");arcText.transition().duration(duration).text(function(e){return labelFormat(e)}).attr("opacity",function(d){if(labelThresholdMatched(d)){return 1}else{return 0}}).attr("transform",function(){var width=this.getBBox().width;if(e.depth===0)return"translate("+width/2*-1+",0)";else if(e.depth===d.depth){return"translate("+(y(e.y)+5)+",0)"}else{var centerAngle=computeCenterAngle(e);var rotation=rotationToAvoidUpsideDown(e);if(rotation===0){return"rotate("+centerAngle+")translate("+(y(e.y)+5)+",0)"}else{return"rotate("+centerAngle+")translate("+(y(e.y)+width+5)+",0)rotate("+rotation+")"}}})}}})}var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();selection.each(function(data){container=d3.select(this);availableWidth=nv.utils.availableWidth(width,container,margin);availableHeight=nv.utils.availableHeight(height,container,margin);radius=Math.min(availableWidth,availableHeight)/2;y.range([0,radius]);var wrap=container.select("g.nvd3.nv-wrap.nv-sunburst");if(!wrap[0][0]){wrap=container.append("g").attr("class","nvd3 nv-wrap nv-sunburst nv-chart-"+id).attr("transform","translate("+(availableWidth/2+margin.left+margin.right)+","+(availableHeight/2+margin.top+margin.bottom)+")")}else{wrap.attr("transform","translate("+(availableWidth/2+margin.left+margin.right)+","+(availableHeight/2+margin.top+margin.bottom)+")")}container.on("click",function(d,i){dispatch.chartClick({data:d,index:i,pos:d3.event,id:id})});partition.value(modes[mode]||modes["count"]);var nodes=partition.nodes(data[0]).reverse();storeRetrievePrevPositions(nodes);var cG=wrap.selectAll(".arc-container").data(nodes,key);var cGE=cG.enter().append("g").attr("class","arc-container");cGE.append("path").attr("d",arc).style("fill",function(d){if(d.color){return d.color}else if(groupColorByParent){return color((d.children?d:d.parent).name)}else{return color(d.name)}}).style("stroke","#FFF").on("click",function(d,i){zoomClick(d);dispatch.elementClick({data:d,index:i})}).on("mouseover",function(d,i){d3.select(this).classed("hover",true).style("opacity",.8);dispatch.elementMouseover({data:d,color:d3.select(this).style("fill"),percent:computeNodePercentage(d)})}).on("mouseout",function(d,i){d3.select(this).classed("hover",false).style("opacity",1);dispatch.elementMouseout({data:d})}).on("mousemove",function(d,i){dispatch.elementMousemove({data:d})});cG.each(function(d){d3.select(this).select("path").transition().duration(duration).attrTween("d",arcTweenUpdate)});if(showLabels){cG.selectAll("text").remove();cG.append("text").text(function(e){return labelFormat(e)}).transition().duration(duration).attr("opacity",function(d){if(labelThresholdMatched(d)){return 1}else{return 0}}).attr("transform",function(d){var width=this.getBBox().width;if(d.depth===0){return"rotate(0)translate("+width/2*-1+",0)"}else{var centerAngle=computeCenterAngle(d);var rotation=rotationToAvoidUpsideDown(d);if(rotation===0){return"rotate("+centerAngle+")translate("+(y(d.y)+5)+",0)"}else{return"rotate("+centerAngle+")translate("+(y(d.y)+width+5)+",0)rotate("+rotation+")"}}})}zoomClick(nodes[nodes.length-1]);cG.exit().transition().duration(duration).attr("opacity",0).each("end",function(d){var k=key(d);prevPositions[k]=undefined}).remove()});renderWatch.renderEnd("sunburst immediate");return chart}chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width},set:function(_){width=_}},height:{get:function(){return height},set:function(_){height=_}},mode:{get:function(){return mode},set:function(_){mode=_}},id:{get:function(){return id},set:function(_){id=_}},duration:{get:function(){return duration},set:function(_){duration=_}},groupColorByParent:{get:function(){return groupColorByParent},set:function(_){groupColorByParent=!!_}},showLabels:{get:function(){return showLabels},set:function(_){showLabels=!!_}},labelFormat:{get:function(){return labelFormat},set:function(_){labelFormat=_}},labelThreshold:{get:function(){return labelThreshold},set:function(_){labelThreshold=_}},sort:{get:function(){return sort},set:function(_){sort=_}},key:{get:function(){return key},set:function(_){key=_}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!=undefined?_.top:margin.top;margin.right=_.right!=undefined?_.right:margin.right;margin.bottom=_.bottom!=undefined?_.bottom:margin.bottom;margin.left=_.left!=undefined?_.left:margin.left}},color:{get:function(){return color},set:function(_){color=nv.utils.getColor(_)}}});nv.utils.initOptions(chart);return chart};nv.models.sunburstChart=function(){"use strict";var sunburst=nv.models.sunburst();var tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:20,left:20},width=null,height=null,color=nv.utils.defaultColor(),showTooltipPercent=false,id=Math.round(Math.random()*1e5),defaultState=null,noData=null,duration=250,dispatch=d3.dispatch("stateChange","changeState","renderEnd");var renderWatch=nv.utils.renderWatch(dispatch);tooltip.duration(0).headerEnabled(false).valueFormatter(function(d){return d});function chart(selection){renderWatch.reset();renderWatch.models(sunburst);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin);var availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){if(duration===0){container.call(chart)}else{container.transition().duration(duration).call(chart)}};chart.container=container;if(!data||!data.length){nv.utils.noData(chart,container);return chart}else{container.selectAll(".nv-noData").remove()}sunburst.width(availableWidth).height(availableHeight).margin(margin);container.call(sunburst)});renderWatch.renderEnd("sunburstChart immediate");return chart}sunburst.dispatch.on("elementMouseover.tooltip",function(evt){evt.series={key:evt.data.name,value:evt.data.value||evt.data.size,color:evt.color,percent:evt.percent};if(!showTooltipPercent){delete evt.percent;delete evt.series.percent}tooltip.data(evt).hidden(false)});sunburst.dispatch.on("elementMouseout.tooltip",function(evt){tooltip.hidden(true)});sunburst.dispatch.on("elementMousemove.tooltip",function(evt){tooltip()});chart.dispatch=dispatch;chart.sunburst=sunburst;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{noData:{get:function(){return noData},set:function(_){noData=_}},defaultState:{get:function(){return defaultState},set:function(_){defaultState=_}},showTooltipPercent:{get:function(){return showTooltipPercent},set:function(_){showTooltipPercent=_}},color:{get:function(){return color},set:function(_){color=_;sunburst.color(color)}},duration:{get:function(){return duration},set:function(_){duration=_;renderWatch.reset(duration);sunburst.duration(duration)}},margin:{get:function(){return margin},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;sunburst.margin(margin)}}});nv.utils.inheritOptions(chart,sunburst);nv.utils.initOptions(chart);return chart};nv.version="1.8.6-dev"})();(function($,window,document,undefined){var pluginName="bootstrapDualListbox",defaults={bootstrap2Compatible:false,filterTextClear:"show all",filterPlaceHolder:"Filter",moveSelectedLabel:"Move selected",moveAllLabel:"Move all",removeSelectedLabel:"Remove selected",removeAllLabel:"Remove all",moveOnSelect:true,preserveSelectionOnMove:false,selectedListLabel:false,nonSelectedListLabel:false,helperSelectNamePostfix:"_helper",selectorMinimalHeight:100,showFilterInputs:true,nonSelectedFilter:"",selectedFilter:"",infoText:"Showing all {0}",infoTextFiltered:'<span class="label label-warning">Filtered</span> {0} from {1}',infoTextEmpty:"Empty list",filterOnValues:false},isBuggyAndroid=/android/i.test(navigator.userAgent.toLowerCase());function BootstrapDualListbox(element,options){this.element=$(element);this.settings=$.extend({},defaults,options);this._defaults=defaults;this._name=pluginName;this.init()}function triggerChangeEvent(dualListbox){dualListbox.element.trigger("change")}function updateSelectionStates(dualListbox){dualListbox.element.find("option").each(function(index,item){var $item=$(item);if(typeof $item.data("original-index")==="undefined"){$item.data("original-index",dualListbox.elementCount++)}if(typeof $item.data("_selected")==="undefined"){$item.data("_selected",false)}})}function changeSelectionState(dualListbox,original_index,selected){dualListbox.element.find("option").each(function(index,item){var $item=$(item);if($item.data("original-index")===original_index){$item.prop("selected",selected)}})}function formatString(s,args){return s.replace(/\{(\d+)\}/g,function(match,number){return typeof args[number]!=="undefined"?args[number]:match})}function refreshInfo(dualListbox){if(!dualListbox.settings.infoText){return}var visible1=dualListbox.elements.select1.find("option").length,visible2=dualListbox.elements.select2.find("option").length,all1=dualListbox.element.find("option").length-dualListbox.selectedElements,all2=dualListbox.selectedElements,content="";if(all1===0){content=dualListbox.settings.infoTextEmpty}else if(visible1===all1){content=formatString(dualListbox.settings.infoText,[visible1,all1])}else{content=formatString(dualListbox.settings.infoTextFiltered,[visible1,all1])}dualListbox.elements.info1.html(content);dualListbox.elements.box1.toggleClass("filtered",!(visible1===all1||all1===0));if(all2===0){content=dualListbox.settings.infoTextEmpty}else if(visible2===all2){content=formatString(dualListbox.settings.infoText,[visible2,all2])}else{content=formatString(dualListbox.settings.infoTextFiltered,[visible2,all2])}dualListbox.elements.info2.html(content);dualListbox.elements.box2.toggleClass("filtered",!(visible2===all2||all2===0))}function refreshSelects(dualListbox){dualListbox.selectedElements=0;dualListbox.elements.select1.empty();dualListbox.elements.select2.empty();dualListbox.element.find("option").each(function(index,item){var $item=$(item);if($item.prop("selected")){dualListbox.selectedElements++;dualListbox.elements.select2.append($item.clone(true).prop("selected",$item.data("_selected")))}else{dualListbox.elements.select1.append($item.clone(true).prop("selected",$item.data("_selected")))}});if(dualListbox.settings.showFilterInputs){filter(dualListbox,1);filter(dualListbox,2)}refreshInfo(dualListbox)}function filter(dualListbox,selectIndex){if(!dualListbox.settings.showFilterInputs){return}saveSelections(dualListbox,selectIndex);dualListbox.elements["select"+selectIndex].empty().scrollTop(0);var regex=new RegExp($.trim(dualListbox.elements["filterInput"+selectIndex].val()),"gi"),options=dualListbox.element;if(selectIndex===1){options=options.find("option").not(":selected")}else{options=options.find("option:selected")}options.each(function(index,item){var $item=$(item),isFiltered=true;if(item.text.match(regex)||dualListbox.settings.filterOnValues&&$item.attr("value").match(regex)){isFiltered=false;dualListbox.elements["select"+selectIndex].append($item.clone(true).prop("selected",$item.data("_selected")))}dualListbox.element.find("option").eq($item.data("original-index")).data("filtered"+selectIndex,isFiltered)});refreshInfo(dualListbox)}function saveSelections(dualListbox,selectIndex){dualListbox.elements["select"+selectIndex].find("option").each(function(index,item){var $item=$(item);dualListbox.element.find("option").eq($item.data("original-index")).data("_selected",$item.prop("selected"))})}function sortOptions(select){select.find("option").sort(function(a,b){return $(a).data("original-index")>$(b).data("original-index")?1:-1}).appendTo(select)}function clearSelections(dualListbox){dualListbox.elements.select1.find("option").each(function(){dualListbox.element.find("option").data("_selected",false)})}function move(dualListbox){if(dualListbox.settings.preserveSelectionOnMove==="all"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,1);saveSelections(dualListbox,2)}else if(dualListbox.settings.preserveSelectionOnMove==="moved"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,1)}dualListbox.elements.select1.find("option:selected").each(function(index,item){var $item=$(item);if(!$item.data("filtered1")){changeSelectionState(dualListbox,$item.data("original-index"),true)}});refreshSelects(dualListbox);triggerChangeEvent(dualListbox);sortOptions(dualListbox.elements.select2)}function remove(dualListbox){if(dualListbox.settings.preserveSelectionOnMove==="all"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,1);saveSelections(dualListbox,2)}else if(dualListbox.settings.preserveSelectionOnMove==="moved"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,2)}dualListbox.elements.select2.find("option:selected").each(function(index,item){var $item=$(item);if(!$item.data("filtered2")){changeSelectionState(dualListbox,$item.data("original-index"),false)}});refreshSelects(dualListbox);triggerChangeEvent(dualListbox);sortOptions(dualListbox.elements.select1)}function moveAll(dualListbox){if(dualListbox.settings.preserveSelectionOnMove==="all"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,1);saveSelections(dualListbox,2)}else if(dualListbox.settings.preserveSelectionOnMove==="moved"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,1)}dualListbox.element.find("option").each(function(index,item){var $item=$(item);if(!$item.data("filtered1")){$item.prop("selected",true)}});refreshSelects(dualListbox);triggerChangeEvent(dualListbox)}function removeAll(dualListbox){if(dualListbox.settings.preserveSelectionOnMove==="all"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,1);saveSelections(dualListbox,2)}else if(dualListbox.settings.preserveSelectionOnMove==="moved"&&!dualListbox.settings.moveOnSelect){saveSelections(dualListbox,2)}dualListbox.element.find("option").each(function(index,item){var $item=$(item);if(!$item.data("filtered2")){$item.prop("selected",false)}});refreshSelects(dualListbox);triggerChangeEvent(dualListbox)}function bindEvents(dualListbox){dualListbox.elements.form.submit(function(e){if(dualListbox.elements.filterInput1.is(":focus")){e.preventDefault();
dualListbox.elements.filterInput1.focusout()}else if(dualListbox.elements.filterInput2.is(":focus")){e.preventDefault();dualListbox.elements.filterInput2.focusout()}});dualListbox.element.on("bootstrapDualListbox.refresh",function(e,mustClearSelections){dualListbox.refresh(mustClearSelections)});dualListbox.elements.filterClear1.on("click",function(){dualListbox.setNonSelectedFilter("",true)});dualListbox.elements.filterClear2.on("click",function(){dualListbox.setSelectedFilter("",true)});dualListbox.elements.moveButton.on("click",function(){move(dualListbox)});dualListbox.elements.moveAllButton.on("click",function(){moveAll(dualListbox)});dualListbox.elements.removeButton.on("click",function(){remove(dualListbox)});dualListbox.elements.removeAllButton.on("click",function(){removeAll(dualListbox)});dualListbox.elements.filterInput1.on("change keyup",function(){filter(dualListbox,1)});dualListbox.elements.filterInput2.on("change keyup",function(){filter(dualListbox,2)})}BootstrapDualListbox.prototype={init:function(){this.container=$(""+'<div class="bootstrap-duallistbox-container">'+' <div class="box1">'+"   <label></label>"+'   <span class="info-container">'+'     <span class="info"></span>'+'     <button type="button" class="btn clear1 pull-right"></button>'+"   </span>"+'   <input class="filter" type="text">'+'   <div class="btn-group buttons">'+'     <button type="button" class="btn moveall">'+"       <i></i>"+"       <i></i>"+"     </button>"+'     <button type="button" class="btn move">'+"       <i></i>"+"     </button>"+"   </div>"+'   <select multiple="multiple"></select>'+" </div>"+' <div class="box2">'+"   <label></label>"+'   <span class="info-container">'+'     <span class="info"></span>'+'     <button type="button" class="btn clear2 pull-right"></button>'+"   </span>"+'   <input class="filter" type="text">'+'   <div class="btn-group buttons">'+'     <button type="button" class="btn remove">'+"       <i></i>"+"     </button>"+'     <button type="button" class="btn removeall">'+"       <i></i>"+"       <i></i>"+"     </button>"+"   </div>"+'   <select multiple="multiple"></select>'+" </div>"+"</div>").insertBefore(this.element);this.elements={originalSelect:this.element,box1:$(".box1",this.container),box2:$(".box2",this.container),filterInput1:$(".box1 .filter",this.container),filterInput2:$(".box2 .filter",this.container),filterClear1:$(".box1 .clear1",this.container),filterClear2:$(".box2 .clear2",this.container),label1:$(".box1 > label",this.container),label2:$(".box2 > label",this.container),info1:$(".box1 .info",this.container),info2:$(".box2 .info",this.container),select1:$(".box1 select",this.container),select2:$(".box2 select",this.container),moveButton:$(".box1 .move",this.container),removeButton:$(".box2 .remove",this.container),moveAllButton:$(".box1 .moveall",this.container),removeAllButton:$(".box2 .removeall",this.container),form:$($(".box1 .filter",this.container)[0].form)};this.originalSelectName=this.element.attr("name")||"";var select1Id="bootstrap-duallistbox-nonselected-list_"+this.originalSelectName,select2Id="bootstrap-duallistbox-selected-list_"+this.originalSelectName;this.elements.select1.attr("id",select1Id);this.elements.select2.attr("id",select2Id);this.elements.label1.attr("for",select1Id);this.elements.label2.attr("for",select2Id);this.selectedElements=0;this.elementCount=0;this.setBootstrap2Compatible(this.settings.bootstrap2Compatible);this.setFilterTextClear(this.settings.filterTextClear);this.setFilterPlaceHolder(this.settings.filterPlaceHolder);this.setMoveSelectedLabel(this.settings.moveSelectedLabel);this.setMoveAllLabel(this.settings.moveAllLabel);this.setRemoveSelectedLabel(this.settings.removeSelectedLabel);this.setRemoveAllLabel(this.settings.removeAllLabel);this.setMoveOnSelect(this.settings.moveOnSelect);this.setPreserveSelectionOnMove(this.settings.preserveSelectionOnMove);this.setSelectedListLabel(this.settings.selectedListLabel);this.setNonSelectedListLabel(this.settings.nonSelectedListLabel);this.setHelperSelectNamePostfix(this.settings.helperSelectNamePostfix);this.setSelectOrMinimalHeight(this.settings.selectorMinimalHeight);updateSelectionStates(this);this.setShowFilterInputs(this.settings.showFilterInputs);this.setNonSelectedFilter(this.settings.nonSelectedFilter);this.setSelectedFilter(this.settings.selectedFilter);this.setInfoText(this.settings.infoText);this.setInfoTextFiltered(this.settings.infoTextFiltered);this.setInfoTextEmpty(this.settings.infoTextEmpty);this.setFilterOnValues(this.settings.filterOnValues);this.element.hide();bindEvents(this);refreshSelects(this);return this.element},setBootstrap2Compatible:function(value,refresh){this.settings.bootstrap2Compatible=value;if(value){this.container.removeClass("row").addClass("row-fluid bs2compatible");this.container.find(".box1, .box2").removeClass("col-md-6").addClass("span6");this.container.find(".clear1, .clear2").removeClass("btn-default btn-xs").addClass("btn-mini");this.container.find("input, select").removeClass("form-control");this.container.find(".btn").removeClass("btn-default");this.container.find(".moveall > i, .move > i").removeClass("glyphicon glyphicon-arrow-right").addClass("icon-arrow-right");this.container.find(".removeall > i, .remove > i").removeClass("glyphicon glyphicon-arrow-left").addClass("icon-arrow-left")}else{this.container.removeClass("row-fluid bs2compatible").addClass("row");this.container.find(".box1, .box2").removeClass("span6").addClass("col-md-6");this.container.find(".clear1, .clear2").removeClass("btn-mini").addClass("btn-default btn-xs");this.container.find("input, select").addClass("form-control");this.container.find(".btn").addClass("btn-default");this.container.find(".moveall > i, .move > i").removeClass("icon-arrow-right").addClass("glyphicon glyphicon-arrow-right");this.container.find(".removeall > i, .remove > i").removeClass("icon-arrow-left").addClass("glyphicon glyphicon-arrow-left")}if(refresh){refreshSelects(this)}return this.element},setFilterTextClear:function(value,refresh){this.settings.filterTextClear=value;this.elements.filterClear1.html(value);this.elements.filterClear2.html(value);if(refresh){refreshSelects(this)}return this.element},setFilterPlaceHolder:function(value,refresh){this.settings.filterPlaceHolder=value;this.elements.filterInput1.attr("placeholder",value);this.elements.filterInput2.attr("placeholder",value);if(refresh){refreshSelects(this)}return this.element},setMoveSelectedLabel:function(value,refresh){this.settings.moveSelectedLabel=value;this.elements.moveButton.attr("title",value);if(refresh){refreshSelects(this)}return this.element},setMoveAllLabel:function(value,refresh){this.settings.moveAllLabel=value;this.elements.moveAllButton.attr("title",value);if(refresh){refreshSelects(this)}return this.element},setRemoveSelectedLabel:function(value,refresh){this.settings.removeSelectedLabel=value;this.elements.removeButton.attr("title",value);if(refresh){refreshSelects(this)}return this.element},setRemoveAllLabel:function(value,refresh){this.settings.removeAllLabel=value;this.elements.removeAllButton.attr("title",value);if(refresh){refreshSelects(this)}return this.element},setMoveOnSelect:function(value,refresh){if(isBuggyAndroid){value=true}this.settings.moveOnSelect=value;if(this.settings.moveOnSelect){this.container.addClass("moveonselect");var self=this;this.elements.select1.on("change",function(){move(self)});this.elements.select2.on("change",function(){remove(self)})}else{this.container.removeClass("moveonselect");this.elements.select1.off("change");this.elements.select2.off("change")}if(refresh){refreshSelects(this)}return this.element},setPreserveSelectionOnMove:function(value,refresh){if(isBuggyAndroid){value=false}this.settings.preserveSelectionOnMove=value;if(refresh){refreshSelects(this)}return this.element},setSelectedListLabel:function(value,refresh){this.settings.selectedListLabel=value;if(value){this.elements.label2.show().html(value)}else{this.elements.label2.hide().html(value)}if(refresh){refreshSelects(this)}return this.element},setNonSelectedListLabel:function(value,refresh){this.settings.nonSelectedListLabel=value;if(value){this.elements.label1.show().html(value)}else{this.elements.label1.hide().html(value)}if(refresh){refreshSelects(this)}return this.element},setHelperSelectNamePostfix:function(value,refresh){this.settings.helperSelectNamePostfix=value;if(value){this.elements.select1.attr("name",this.originalSelectName+value+"1");this.elements.select2.attr("name",this.originalSelectName+value+"2")}else{this.elements.select1.removeAttr("name");this.elements.select2.removeAttr("name")}if(refresh){refreshSelects(this)}return this.element},setSelectOrMinimalHeight:function(value,refresh){this.settings.selectorMinimalHeight=value;var height=this.element.height();if(this.element.height()<value){height=value}this.elements.select1.height(height);this.elements.select2.height(height);if(refresh){refreshSelects(this)}return this.element},setShowFilterInputs:function(value,refresh){if(!value){this.setNonSelectedFilter("");this.setSelectedFilter("");refreshSelects(this);this.elements.filterInput1.hide();this.elements.filterInput2.hide()}else{this.elements.filterInput1.show();this.elements.filterInput2.show()}this.settings.showFilterInputs=value;if(refresh){refreshSelects(this)}return this.element},setNonSelectedFilter:function(value,refresh){if(this.settings.showFilterInputs){this.settings.nonSelectedFilter=value;this.elements.filterInput1.val(value);if(refresh){refreshSelects(this)}return this.element}},setSelectedFilter:function(value,refresh){if(this.settings.showFilterInputs){this.settings.selectedFilter=value;this.elements.filterInput2.val(value);if(refresh){refreshSelects(this)}return this.element}},setInfoText:function(value,refresh){this.settings.infoText=value;if(refresh){refreshSelects(this)}return this.element},setInfoTextFiltered:function(value,refresh){this.settings.infoTextFiltered=value;if(refresh){refreshSelects(this)}return this.element},setInfoTextEmpty:function(value,refresh){this.settings.infoTextEmpty=value;if(refresh){refreshSelects(this)}return this.element},setFilterOnValues:function(value,refresh){this.settings.filterOnValues=value;if(refresh){refreshSelects(this)}return this.element},getContainer:function(){return this.container},refresh:function(mustClearSelections){updateSelectionStates(this);if(!mustClearSelections){saveSelections(this,1);saveSelections(this,2)}else{clearSelections(this)}refreshSelects(this)},destroy:function(){this.container.remove();this.element.show();$.data(this,"plugin_"+pluginName,null);return this.element}};$.fn[pluginName]=function(options){var args=arguments;if(options===undefined||typeof options==="object"){return this.each(function(){if(!$(this).is("select")){$(this).find("select").each(function(index,item){$(item).bootstrapDualListbox(options)})}else if(!$.data(this,"plugin_"+pluginName)){$.data(this,"plugin_"+pluginName,new BootstrapDualListbox(this,options))}})}else if(typeof options==="string"&&options[0]!=="_"&&options!=="init"){var returns;this.each(function(){var instance=$.data(this,"plugin_"+pluginName);if(instance instanceof BootstrapDualListbox&&typeof instance[options]==="function"){returns=instance[options].apply(instance,Array.prototype.slice.call(args,1))}});return returns!==undefined?returns:this}}})(jQuery,window,document);(function($){$.fn.areYouSure=function(options){var settings=$.extend({message:"You have unsaved changes!",dirtyClass:"dirty",change:null,silent:false,addRemoveFieldsMarksDirty:false,fieldEvents:"change keyup propertychange input",fieldSelector:":input:not(input[type=submit]):not(input[type=button])"},options);var getValue=function($field){if($field.hasClass("ays-ignore")||$field.hasClass("aysIgnore")||$field.attr("data-ays-ignore")||$field.attr("name")===undefined){return null}if($field.is(":disabled")){return"ays-disabled"}var val;var type=$field.attr("type");if($field.is("select")){type="select"}switch(type){case"checkbox":case"radio":val=$field.is(":checked");break;case"select":val="";$field.find("option").each(function(o){var $option=$(this);if($option.is(":selected")){val+=$option.val()}});break;default:val=$field.val()}return val};var storeOrigValue=function($field){$field.data("ays-orig",getValue($field))};var checkForm=function(evt){var isFieldDirty=function($field){var origValue=$field.data("ays-orig");if(undefined===origValue){return false}return getValue($field)!=origValue};var $form=$(this).is("form")?$(this):$(this).parents("form");if(isFieldDirty($(evt.target))){setDirtyStatus($form,true);return}$fields=$form.find(settings.fieldSelector);if(settings.addRemoveFieldsMarksDirty){var origCount=$form.data("ays-orig-field-count");if(origCount!=$fields.length){setDirtyStatus($form,true);return}}var isDirty=false;$fields.each(function(){$field=$(this);if(isFieldDirty($field)){isDirty=true;return false}});setDirtyStatus($form,isDirty)};var initForm=function($form){var fields=$form.find(settings.fieldSelector);$(fields).each(function(){storeOrigValue($(this))});$(fields).unbind(settings.fieldEvents,checkForm);$(fields).bind(settings.fieldEvents,checkForm);$form.data("ays-orig-field-count",$(fields).length);setDirtyStatus($form,false)};var setDirtyStatus=function($form,isDirty){var changed=isDirty!=$form.hasClass(settings.dirtyClass);$form.toggleClass(settings.dirtyClass,isDirty);if(changed){if(settings.change)settings.change.call($form,$form);if(isDirty)$form.trigger("dirty.areYouSure",[$form]);if(!isDirty)$form.trigger("clean.areYouSure",[$form]);$form.trigger("change.areYouSure",[$form])}};var rescan=function(){var $form=$(this);var fields=$form.find(settings.fieldSelector);$(fields).each(function(){var $field=$(this);if(!$field.data("ays-orig")){storeOrigValue($field);$field.bind(settings.fieldEvents,checkForm)}});$form.trigger("checkform.areYouSure")};var reinitialize=function(){initForm($(this))};if(!settings.silent&&!window.aysUnloadSet){window.aysUnloadSet=true;$(window).bind("beforeunload",function(){$dirtyForms=$("form").filter("."+settings.dirtyClass);if($dirtyForms.length==0){return}if(navigator.userAgent.toLowerCase().match(/msie|chrome/)){if(window.aysHasPrompted){return}window.aysHasPrompted=true;window.setTimeout(function(){window.aysHasPrompted=false},900)}return settings.message})}return this.each(function(elem){if(!$(this).is("form")){return}var $form=$(this);$form.submit(function(){$form.removeClass(settings.dirtyClass)});$form.bind("reset",function(){setDirtyStatus($form,false)});$form.bind("rescan.areYouSure",rescan);$form.bind("reinitialize.areYouSure",reinitialize);$form.bind("checkform.areYouSure",checkForm);initForm($form)})}})(jQuery);(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):global.moment=factory()})(this,function(){"use strict";var hookCallback;function hooks(){return hookCallback.apply(null,arguments)}function setHookCallback(callback){hookCallback=callback}function isArray(input){return input instanceof Array||Object.prototype.toString.call(input)==="[object Array]"}function isObject(input){return input!=null&&Object.prototype.toString.call(input)==="[object Object]"}function isObjectEmpty(obj){var k;for(k in obj){return false}return true}function isUndefined(input){return input===void 0}function isNumber(input){return typeof input==="number"||Object.prototype.toString.call(input)==="[object Number]"}function isDate(input){return input instanceof Date||Object.prototype.toString.call(input)==="[object Date]"}function map(arr,fn){var res=[],i;for(i=0;i<arr.length;++i){res.push(fn(arr[i],i))}return res}function hasOwnProp(a,b){return Object.prototype.hasOwnProperty.call(a,b)}function extend(a,b){for(var i in b){if(hasOwnProp(b,i)){a[i]=b[i]}}if(hasOwnProp(b,"toString")){a.toString=b.toString}if(hasOwnProp(b,"valueOf")){a.valueOf=b.valueOf}return a}function createUTC(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,true).utc()}function defaultParsingFlags(){return{empty:false,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:false,invalidMonth:null,invalidFormat:false,userInvalidated:false,iso:false,parsedDateParts:[],meridiem:null,rfc2822:false,weekdayMismatch:false}}function getParsingFlags(m){if(m._pf==null){m._pf=defaultParsingFlags()}return m._pf}var some;if(Array.prototype.some){some=Array.prototype.some}else{some=function(fun){var t=Object(this);var len=t.length>>>0;for(var i=0;i<len;i++){if(i in t&&fun.call(this,t[i],i,t)){return true}}return false}}var some$1=some;function isValid(m){if(m._isValid==null){var flags=getParsingFlags(m);var parsedParts=some$1.call(flags.parsedDateParts,function(i){return i!=null});var isNowValid=!isNaN(m._d.getTime())&&flags.overflow<0&&!flags.empty&&!flags.invalidMonth&&!flags.invalidWeekday&&!flags.nullInput&&!flags.invalidFormat&&!flags.userInvalidated&&(!flags.meridiem||flags.meridiem&&parsedParts);if(m._strict){isNowValid=isNowValid&&flags.charsLeftOver===0&&flags.unusedTokens.length===0&&flags.bigHour===undefined}if(Object.isFrozen==null||!Object.isFrozen(m)){m._isValid=isNowValid}else{return isNowValid}}return m._isValid}function createInvalid(flags){var m=createUTC(NaN);if(flags!=null){extend(getParsingFlags(m),flags)}else{getParsingFlags(m).userInvalidated=true}return m}var momentProperties=hooks.momentProperties=[];function copyConfig(to,from){var i,prop,val;if(!isUndefined(from._isAMomentObject)){to._isAMomentObject=from._isAMomentObject}if(!isUndefined(from._i)){to._i=from._i}if(!isUndefined(from._f)){to._f=from._f}if(!isUndefined(from._l)){to._l=from._l}if(!isUndefined(from._strict)){to._strict=from._strict}if(!isUndefined(from._tzm)){to._tzm=from._tzm}if(!isUndefined(from._isUTC)){to._isUTC=from._isUTC}if(!isUndefined(from._offset)){to._offset=from._offset}if(!isUndefined(from._pf)){to._pf=getParsingFlags(from)}if(!isUndefined(from._locale)){to._locale=from._locale}if(momentProperties.length>0){for(i=0;i<momentProperties.length;i++){prop=momentProperties[i];val=from[prop];if(!isUndefined(val)){to[prop]=val}}}return to}var updateInProgress=false;function Moment(config){copyConfig(this,config);this._d=new Date(config._d!=null?config._d.getTime():NaN);if(!this.isValid()){this._d=new Date(NaN)}if(updateInProgress===false){updateInProgress=true;hooks.updateOffset(this);updateInProgress=false}}function isMoment(obj){return obj instanceof Moment||obj!=null&&obj._isAMomentObject!=null}function absFloor(number){if(number<0){return Math.ceil(number)||0}else{return Math.floor(number)}}function toInt(argumentForCoercion){var coercedNumber=+argumentForCoercion,value=0;if(coercedNumber!==0&&isFinite(coercedNumber)){value=absFloor(coercedNumber)}return value}function compareArrays(array1,array2,dontConvert){var len=Math.min(array1.length,array2.length),lengthDiff=Math.abs(array1.length-array2.length),diffs=0,i;for(i=0;i<len;i++){if(dontConvert&&array1[i]!==array2[i]||!dontConvert&&toInt(array1[i])!==toInt(array2[i])){diffs++}}return diffs+lengthDiff}function warn(msg){if(hooks.suppressDeprecationWarnings===false&&typeof console!=="undefined"&&console.warn){console.warn("Deprecation warning: "+msg)}}function deprecate(msg,fn){var firstTime=true;return extend(function(){if(hooks.deprecationHandler!=null){hooks.deprecationHandler(null,msg)}if(firstTime){var args=[];var arg;for(var i=0;i<arguments.length;i++){arg="";if(typeof arguments[i]==="object"){arg+="\n["+i+"] ";for(var key in arguments[0]){arg+=key+": "+arguments[0][key]+", "}arg=arg.slice(0,-2)}else{arg=arguments[i]}args.push(arg)}warn(msg+"\nArguments: "+Array.prototype.slice.call(args).join("")+"\n"+(new Error).stack);firstTime=false}return fn.apply(this,arguments)},fn)}var deprecations={};function deprecateSimple(name,msg){if(hooks.deprecationHandler!=null){hooks.deprecationHandler(name,msg)}if(!deprecations[name]){warn(msg);deprecations[name]=true}}hooks.suppressDeprecationWarnings=false;hooks.deprecationHandler=null;function isFunction(input){return input instanceof Function||Object.prototype.toString.call(input)==="[object Function]"}function set(config){var prop,i;for(i in config){prop=config[i];if(isFunction(prop)){this[i]=prop}else{this["_"+i]=prop}}this._config=config;this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function mergeConfigs(parentConfig,childConfig){var res=extend({},parentConfig),prop;for(prop in childConfig){if(hasOwnProp(childConfig,prop)){if(isObject(parentConfig[prop])&&isObject(childConfig[prop])){res[prop]={};extend(res[prop],parentConfig[prop]);extend(res[prop],childConfig[prop])}else if(childConfig[prop]!=null){res[prop]=childConfig[prop]}else{delete res[prop]}}}for(prop in parentConfig){if(hasOwnProp(parentConfig,prop)&&!hasOwnProp(childConfig,prop)&&isObject(parentConfig[prop])){res[prop]=extend({},res[prop])}}return res}function Locale(config){if(config!=null){this.set(config)}}var keys;if(Object.keys){keys=Object.keys}else{keys=function(obj){var i,res=[];for(i in obj){if(hasOwnProp(obj,i)){res.push(i)}}return res}}var keys$1=keys;var defaultCalendar={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function calendar(key,mom,now){var output=this._calendar[key]||this._calendar["sameElse"];return isFunction(output)?output.call(mom,now):output}var defaultLongDateFormat={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function longDateFormat(key){var format=this._longDateFormat[key],formatUpper=this._longDateFormat[key.toUpperCase()];if(format||!formatUpper){return format}this._longDateFormat[key]=formatUpper.replace(/MMMM|MM|DD|dddd/g,function(val){return val.slice(1)});return this._longDateFormat[key]}var defaultInvalidDate="Invalid date";function invalidDate(){return this._invalidDate}var defaultOrdinal="%d";var defaultDayOfMonthOrdinalParse=/\d{1,2}/;function ordinal(number){return this._ordinal.replace("%d",number)}var defaultRelativeTime={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function relativeTime(number,withoutSuffix,string,isFuture){var output=this._relativeTime[string];return isFunction(output)?output(number,withoutSuffix,string,isFuture):output.replace(/%d/i,number)}function pastFuture(diff,output){var format=this._relativeTime[diff>0?"future":"past"];return isFunction(format)?format(output):format.replace(/%s/i,output)}var aliases={};function addUnitAlias(unit,shorthand){var lowerCase=unit.toLowerCase();aliases[lowerCase]=aliases[lowerCase+"s"]=aliases[shorthand]=unit}function normalizeUnits(units){return typeof units==="string"?aliases[units]||aliases[units.toLowerCase()]:undefined}function normalizeObjectUnits(inputObject){var normalizedInput={},normalizedProp,prop;for(prop in inputObject){if(hasOwnProp(inputObject,prop)){normalizedProp=normalizeUnits(prop);if(normalizedProp){normalizedInput[normalizedProp]=inputObject[prop]}}}return normalizedInput}var priorities={};function addUnitPriority(unit,priority){priorities[unit]=priority}function getPrioritizedUnits(unitsObj){var units=[];for(var u in unitsObj){units.push({unit:u,priority:priorities[u]})}units.sort(function(a,b){return a.priority-b.priority});return units}function makeGetSet(unit,keepTime){return function(value){if(value!=null){set$1(this,unit,value);hooks.updateOffset(this,keepTime);return this}else{return get(this,unit)}}}function get(mom,unit){return mom.isValid()?mom._d["get"+(mom._isUTC?"UTC":"")+unit]():NaN}function set$1(mom,unit,value){if(mom.isValid()){mom._d["set"+(mom._isUTC?"UTC":"")+unit](value)}}function stringGet(units){units=normalizeUnits(units);if(isFunction(this[units])){return this[units]()}return this}function stringSet(units,value){if(typeof units==="object"){units=normalizeObjectUnits(units);var prioritized=getPrioritizedUnits(units);for(var i=0;i<prioritized.length;i++){this[prioritized[i].unit](units[prioritized[i].unit])}}else{units=normalizeUnits(units);if(isFunction(this[units])){return this[units](value)}}return this}function zeroFill(number,targetLength,forceSign){var absNumber=""+Math.abs(number),zerosToFill=targetLength-absNumber.length,sign=number>=0;return(sign?forceSign?"+":"":"-")+Math.pow(10,Math.max(0,zerosToFill)).toString().substr(1)+absNumber}var formattingTokens=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;var localFormattingTokens=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;var formatFunctions={};var formatTokenFunctions={};function addFormatToken(token,padded,ordinal,callback){var func=callback;if(typeof callback==="string"){func=function(){return this[callback]()}}if(token){formatTokenFunctions[token]=func}if(padded){formatTokenFunctions[padded[0]]=function(){return zeroFill(func.apply(this,arguments),padded[1],padded[2])}}if(ordinal){formatTokenFunctions[ordinal]=function(){return this.localeData().ordinal(func.apply(this,arguments),token)}}}function removeFormattingTokens(input){if(input.match(/\[[\s\S]/)){return input.replace(/^\[|\]$/g,"")}return input.replace(/\\/g,"")}function makeFormatFunction(format){var array=format.match(formattingTokens),i,length;for(i=0,length=array.length;i<length;i++){if(formatTokenFunctions[array[i]]){array[i]=formatTokenFunctions[array[i]]}else{array[i]=removeFormattingTokens(array[i])}}return function(mom){var output="",i;for(i=0;i<length;i++){output+=isFunction(array[i])?array[i].call(mom,format):array[i]}return output}}function formatMoment(m,format){if(!m.isValid()){return m.localeData().invalidDate()}format=expandFormat(format,m.localeData());formatFunctions[format]=formatFunctions[format]||makeFormatFunction(format);return formatFunctions[format](m)}function expandFormat(format,locale){var i=5;function replaceLongDateFormatTokens(input){return locale.longDateFormat(input)||input}localFormattingTokens.lastIndex=0;while(i>=0&&localFormattingTokens.test(format)){format=format.replace(localFormattingTokens,replaceLongDateFormatTokens);localFormattingTokens.lastIndex=0;i-=1}return format}var match1=/\d/;var match2=/\d\d/;var match3=/\d{3}/;var match4=/\d{4}/;var match6=/[+-]?\d{6}/;var match1to2=/\d\d?/;var match3to4=/\d\d\d\d?/;var match5to6=/\d\d\d\d\d\d?/;var match1to3=/\d{1,3}/;var match1to4=/\d{1,4}/;var match1to6=/[+-]?\d{1,6}/;var matchUnsigned=/\d+/;var matchSigned=/[+-]?\d+/;var matchOffset=/Z|[+-]\d\d:?\d\d/gi;var matchShortOffset=/Z|[+-]\d\d(?::?\d\d)?/gi;var matchTimestamp=/[+-]?\d+(\.\d{1,3})?/;var matchWord=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i;var regexes={};function addRegexToken(token,regex,strictRegex){regexes[token]=isFunction(regex)?regex:function(isStrict,localeData){return isStrict&&strictRegex?strictRegex:regex}}function getParseRegexForToken(token,config){if(!hasOwnProp(regexes,token)){return new RegExp(unescapeFormat(token))}return regexes[token](config._strict,config._locale)}function unescapeFormat(s){return regexEscape(s.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(matched,p1,p2,p3,p4){return p1||p2||p3||p4}))}function regexEscape(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}var tokens={};function addParseToken(token,callback){var i,func=callback;if(typeof token==="string"){token=[token]}if(isNumber(callback)){func=function(input,array){array[callback]=toInt(input)}}for(i=0;i<token.length;i++){tokens[token[i]]=func}}function addWeekParseToken(token,callback){addParseToken(token,function(input,array,config,token){config._w=config._w||{};callback(input,config._w,config,token)})}function addTimeToArrayFromToken(token,input,config){if(input!=null&&hasOwnProp(tokens,token)){tokens[token](input,config._a,config,token)}}var YEAR=0;var MONTH=1;var DATE=2;var HOUR=3;var MINUTE=4;var SECOND=5;var MILLISECOND=6;var WEEK=7;var WEEKDAY=8;var indexOf;if(Array.prototype.indexOf){indexOf=Array.prototype.indexOf}else{indexOf=function(o){var i;for(i=0;i<this.length;++i){if(this[i]===o){return i}}return-1}}var indexOf$1=indexOf;function daysInMonth(year,month){return new Date(Date.UTC(year,month+1,0)).getUTCDate()}addFormatToken("M",["MM",2],"Mo",function(){return this.month()+1});addFormatToken("MMM",0,0,function(format){return this.localeData().monthsShort(this,format)});addFormatToken("MMMM",0,0,function(format){return this.localeData().months(this,format)});addUnitAlias("month","M");addUnitPriority("month",8);addRegexToken("M",match1to2);addRegexToken("MM",match1to2,match2);addRegexToken("MMM",function(isStrict,locale){return locale.monthsShortRegex(isStrict)});addRegexToken("MMMM",function(isStrict,locale){return locale.monthsRegex(isStrict)});addParseToken(["M","MM"],function(input,array){array[MONTH]=toInt(input)-1});addParseToken(["MMM","MMMM"],function(input,array,config,token){var month=config._locale.monthsParse(input,token,config._strict);if(month!=null){array[MONTH]=month}else{getParsingFlags(config).invalidMonth=input}});var MONTHS_IN_FORMAT=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;var defaultLocaleMonths="January_February_March_April_May_June_July_August_September_October_November_December".split("_");function localeMonths(m,format){if(!m){return isArray(this._months)?this._months:this._months["standalone"]}return isArray(this._months)?this._months[m.month()]:this._months[(this._months.isFormat||MONTHS_IN_FORMAT).test(format)?"format":"standalone"][m.month()]}var defaultLocaleMonthsShort="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_");function localeMonthsShort(m,format){if(!m){return isArray(this._monthsShort)?this._monthsShort:this._monthsShort["standalone"]}return isArray(this._monthsShort)?this._monthsShort[m.month()]:this._monthsShort[MONTHS_IN_FORMAT.test(format)?"format":"standalone"][m.month()]}function handleStrictParse(monthName,format,strict){var i,ii,mom,llc=monthName.toLocaleLowerCase();if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[];for(i=0;i<12;++i){mom=createUTC([2e3,i]);this._shortMonthsParse[i]=this.monthsShort(mom,"").toLocaleLowerCase();this._longMonthsParse[i]=this.months(mom,"").toLocaleLowerCase()}}if(strict){if(format==="MMM"){ii=indexOf$1.call(this._shortMonthsParse,llc);return ii!==-1?ii:null}else{ii=indexOf$1.call(this._longMonthsParse,llc);return ii!==-1?ii:null}}else{if(format==="MMM"){ii=indexOf$1.call(this._shortMonthsParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._longMonthsParse,llc);return ii!==-1?ii:null}else{ii=indexOf$1.call(this._longMonthsParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._shortMonthsParse,llc);return ii!==-1?ii:null}}}function localeMonthsParse(monthName,format,strict){var i,mom,regex;if(this._monthsParseExact){return handleStrictParse.call(this,monthName,format,strict)}if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[]}for(i=0;i<12;i++){mom=createUTC([2e3,i]);if(strict&&!this._longMonthsParse[i]){this._longMonthsParse[i]=new RegExp("^"+this.months(mom,"").replace(".","")+"$","i");this._shortMonthsParse[i]=new RegExp("^"+this.monthsShort(mom,"").replace(".","")+"$","i")}if(!strict&&!this._monthsParse[i]){regex="^"+this.months(mom,"")+"|^"+this.monthsShort(mom,"");this._monthsParse[i]=new RegExp(regex.replace(".",""),"i")}if(strict&&format==="MMMM"&&this._longMonthsParse[i].test(monthName)){return i}else if(strict&&format==="MMM"&&this._shortMonthsParse[i].test(monthName)){return i}else if(!strict&&this._monthsParse[i].test(monthName)){return i}}}function setMonth(mom,value){var dayOfMonth;
if(!mom.isValid()){return mom}if(typeof value==="string"){if(/^\d+$/.test(value)){value=toInt(value)}else{value=mom.localeData().monthsParse(value);if(!isNumber(value)){return mom}}}dayOfMonth=Math.min(mom.date(),daysInMonth(mom.year(),value));mom._d["set"+(mom._isUTC?"UTC":"")+"Month"](value,dayOfMonth);return mom}function getSetMonth(value){if(value!=null){setMonth(this,value);hooks.updateOffset(this,true);return this}else{return get(this,"Month")}}function getDaysInMonth(){return daysInMonth(this.year(),this.month())}var defaultMonthsShortRegex=matchWord;function monthsShortRegex(isStrict){if(this._monthsParseExact){if(!hasOwnProp(this,"_monthsRegex")){computeMonthsParse.call(this)}if(isStrict){return this._monthsShortStrictRegex}else{return this._monthsShortRegex}}else{if(!hasOwnProp(this,"_monthsShortRegex")){this._monthsShortRegex=defaultMonthsShortRegex}return this._monthsShortStrictRegex&&isStrict?this._monthsShortStrictRegex:this._monthsShortRegex}}var defaultMonthsRegex=matchWord;function monthsRegex(isStrict){if(this._monthsParseExact){if(!hasOwnProp(this,"_monthsRegex")){computeMonthsParse.call(this)}if(isStrict){return this._monthsStrictRegex}else{return this._monthsRegex}}else{if(!hasOwnProp(this,"_monthsRegex")){this._monthsRegex=defaultMonthsRegex}return this._monthsStrictRegex&&isStrict?this._monthsStrictRegex:this._monthsRegex}}function computeMonthsParse(){function cmpLenRev(a,b){return b.length-a.length}var shortPieces=[],longPieces=[],mixedPieces=[],i,mom;for(i=0;i<12;i++){mom=createUTC([2e3,i]);shortPieces.push(this.monthsShort(mom,""));longPieces.push(this.months(mom,""));mixedPieces.push(this.months(mom,""));mixedPieces.push(this.monthsShort(mom,""))}shortPieces.sort(cmpLenRev);longPieces.sort(cmpLenRev);mixedPieces.sort(cmpLenRev);for(i=0;i<12;i++){shortPieces[i]=regexEscape(shortPieces[i]);longPieces[i]=regexEscape(longPieces[i])}for(i=0;i<24;i++){mixedPieces[i]=regexEscape(mixedPieces[i])}this._monthsRegex=new RegExp("^("+mixedPieces.join("|")+")","i");this._monthsShortRegex=this._monthsRegex;this._monthsStrictRegex=new RegExp("^("+longPieces.join("|")+")","i");this._monthsShortStrictRegex=new RegExp("^("+shortPieces.join("|")+")","i")}addFormatToken("Y",0,0,function(){var y=this.year();return y<=9999?""+y:"+"+y});addFormatToken(0,["YY",2],0,function(){return this.year()%100});addFormatToken(0,["YYYY",4],0,"year");addFormatToken(0,["YYYYY",5],0,"year");addFormatToken(0,["YYYYYY",6,true],0,"year");addUnitAlias("year","y");addUnitPriority("year",1);addRegexToken("Y",matchSigned);addRegexToken("YY",match1to2,match2);addRegexToken("YYYY",match1to4,match4);addRegexToken("YYYYY",match1to6,match6);addRegexToken("YYYYYY",match1to6,match6);addParseToken(["YYYYY","YYYYYY"],YEAR);addParseToken("YYYY",function(input,array){array[YEAR]=input.length===2?hooks.parseTwoDigitYear(input):toInt(input)});addParseToken("YY",function(input,array){array[YEAR]=hooks.parseTwoDigitYear(input)});addParseToken("Y",function(input,array){array[YEAR]=parseInt(input,10)});function daysInYear(year){return isLeapYear(year)?366:365}function isLeapYear(year){return year%4===0&&year%100!==0||year%400===0}hooks.parseTwoDigitYear=function(input){return toInt(input)+(toInt(input)>68?1900:2e3)};var getSetYear=makeGetSet("FullYear",true);function getIsLeapYear(){return isLeapYear(this.year())}function createDate(y,m,d,h,M,s,ms){var date=new Date(y,m,d,h,M,s,ms);if(y<100&&y>=0&&isFinite(date.getFullYear())){date.setFullYear(y)}return date}function createUTCDate(y){var date=new Date(Date.UTC.apply(null,arguments));if(y<100&&y>=0&&isFinite(date.getUTCFullYear())){date.setUTCFullYear(y)}return date}function firstWeekOffset(year,dow,doy){var fwd=7+dow-doy,fwdlw=(7+createUTCDate(year,0,fwd).getUTCDay()-dow)%7;return-fwdlw+fwd-1}function dayOfYearFromWeeks(year,week,weekday,dow,doy){var localWeekday=(7+weekday-dow)%7,weekOffset=firstWeekOffset(year,dow,doy),dayOfYear=1+7*(week-1)+localWeekday+weekOffset,resYear,resDayOfYear;if(dayOfYear<=0){resYear=year-1;resDayOfYear=daysInYear(resYear)+dayOfYear}else if(dayOfYear>daysInYear(year)){resYear=year+1;resDayOfYear=dayOfYear-daysInYear(year)}else{resYear=year;resDayOfYear=dayOfYear}return{year:resYear,dayOfYear:resDayOfYear}}function weekOfYear(mom,dow,doy){var weekOffset=firstWeekOffset(mom.year(),dow,doy),week=Math.floor((mom.dayOfYear()-weekOffset-1)/7)+1,resWeek,resYear;if(week<1){resYear=mom.year()-1;resWeek=week+weeksInYear(resYear,dow,doy)}else if(week>weeksInYear(mom.year(),dow,doy)){resWeek=week-weeksInYear(mom.year(),dow,doy);resYear=mom.year()+1}else{resYear=mom.year();resWeek=week}return{week:resWeek,year:resYear}}function weeksInYear(year,dow,doy){var weekOffset=firstWeekOffset(year,dow,doy),weekOffsetNext=firstWeekOffset(year+1,dow,doy);return(daysInYear(year)-weekOffset+weekOffsetNext)/7}addFormatToken("w",["ww",2],"wo","week");addFormatToken("W",["WW",2],"Wo","isoWeek");addUnitAlias("week","w");addUnitAlias("isoWeek","W");addUnitPriority("week",5);addUnitPriority("isoWeek",5);addRegexToken("w",match1to2);addRegexToken("ww",match1to2,match2);addRegexToken("W",match1to2);addRegexToken("WW",match1to2,match2);addWeekParseToken(["w","ww","W","WW"],function(input,week,config,token){week[token.substr(0,1)]=toInt(input)});function localeWeek(mom){return weekOfYear(mom,this._week.dow,this._week.doy).week}var defaultLocaleWeek={dow:0,doy:6};function localeFirstDayOfWeek(){return this._week.dow}function localeFirstDayOfYear(){return this._week.doy}function getSetWeek(input){var week=this.localeData().week(this);return input==null?week:this.add((input-week)*7,"d")}function getSetISOWeek(input){var week=weekOfYear(this,1,4).week;return input==null?week:this.add((input-week)*7,"d")}addFormatToken("d",0,"do","day");addFormatToken("dd",0,0,function(format){return this.localeData().weekdaysMin(this,format)});addFormatToken("ddd",0,0,function(format){return this.localeData().weekdaysShort(this,format)});addFormatToken("dddd",0,0,function(format){return this.localeData().weekdays(this,format)});addFormatToken("e",0,0,"weekday");addFormatToken("E",0,0,"isoWeekday");addUnitAlias("day","d");addUnitAlias("weekday","e");addUnitAlias("isoWeekday","E");addUnitPriority("day",11);addUnitPriority("weekday",11);addUnitPriority("isoWeekday",11);addRegexToken("d",match1to2);addRegexToken("e",match1to2);addRegexToken("E",match1to2);addRegexToken("dd",function(isStrict,locale){return locale.weekdaysMinRegex(isStrict)});addRegexToken("ddd",function(isStrict,locale){return locale.weekdaysShortRegex(isStrict)});addRegexToken("dddd",function(isStrict,locale){return locale.weekdaysRegex(isStrict)});addWeekParseToken(["dd","ddd","dddd"],function(input,week,config,token){var weekday=config._locale.weekdaysParse(input,token,config._strict);if(weekday!=null){week.d=weekday}else{getParsingFlags(config).invalidWeekday=input}});addWeekParseToken(["d","e","E"],function(input,week,config,token){week[token]=toInt(input)});function parseWeekday(input,locale){if(typeof input!=="string"){return input}if(!isNaN(input)){return parseInt(input,10)}input=locale.weekdaysParse(input);if(typeof input==="number"){return input}return null}function parseIsoWeekday(input,locale){if(typeof input==="string"){return locale.weekdaysParse(input)%7||7}return isNaN(input)?null:input}var defaultLocaleWeekdays="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_");function localeWeekdays(m,format){if(!m){return isArray(this._weekdays)?this._weekdays:this._weekdays["standalone"]}return isArray(this._weekdays)?this._weekdays[m.day()]:this._weekdays[this._weekdays.isFormat.test(format)?"format":"standalone"][m.day()]}var defaultLocaleWeekdaysShort="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_");function localeWeekdaysShort(m){return m?this._weekdaysShort[m.day()]:this._weekdaysShort}var defaultLocaleWeekdaysMin="Su_Mo_Tu_We_Th_Fr_Sa".split("_");function localeWeekdaysMin(m){return m?this._weekdaysMin[m.day()]:this._weekdaysMin}function handleStrictParse$1(weekdayName,format,strict){var i,ii,mom,llc=weekdayName.toLocaleLowerCase();if(!this._weekdaysParse){this._weekdaysParse=[];this._shortWeekdaysParse=[];this._minWeekdaysParse=[];for(i=0;i<7;++i){mom=createUTC([2e3,1]).day(i);this._minWeekdaysParse[i]=this.weekdaysMin(mom,"").toLocaleLowerCase();this._shortWeekdaysParse[i]=this.weekdaysShort(mom,"").toLocaleLowerCase();this._weekdaysParse[i]=this.weekdays(mom,"").toLocaleLowerCase()}}if(strict){if(format==="dddd"){ii=indexOf$1.call(this._weekdaysParse,llc);return ii!==-1?ii:null}else if(format==="ddd"){ii=indexOf$1.call(this._shortWeekdaysParse,llc);return ii!==-1?ii:null}else{ii=indexOf$1.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null}}else{if(format==="dddd"){ii=indexOf$1.call(this._weekdaysParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._shortWeekdaysParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null}else if(format==="ddd"){ii=indexOf$1.call(this._shortWeekdaysParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._weekdaysParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null}else{ii=indexOf$1.call(this._minWeekdaysParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._weekdaysParse,llc);if(ii!==-1){return ii}ii=indexOf$1.call(this._shortWeekdaysParse,llc);return ii!==-1?ii:null}}}function localeWeekdaysParse(weekdayName,format,strict){var i,mom,regex;if(this._weekdaysParseExact){return handleStrictParse$1.call(this,weekdayName,format,strict)}if(!this._weekdaysParse){this._weekdaysParse=[];this._minWeekdaysParse=[];this._shortWeekdaysParse=[];this._fullWeekdaysParse=[]}for(i=0;i<7;i++){mom=createUTC([2e3,1]).day(i);if(strict&&!this._fullWeekdaysParse[i]){this._fullWeekdaysParse[i]=new RegExp("^"+this.weekdays(mom,"").replace(".",".?")+"$","i");this._shortWeekdaysParse[i]=new RegExp("^"+this.weekdaysShort(mom,"").replace(".",".?")+"$","i");this._minWeekdaysParse[i]=new RegExp("^"+this.weekdaysMin(mom,"").replace(".",".?")+"$","i")}if(!this._weekdaysParse[i]){regex="^"+this.weekdays(mom,"")+"|^"+this.weekdaysShort(mom,"")+"|^"+this.weekdaysMin(mom,"");this._weekdaysParse[i]=new RegExp(regex.replace(".",""),"i")}if(strict&&format==="dddd"&&this._fullWeekdaysParse[i].test(weekdayName)){return i}else if(strict&&format==="ddd"&&this._shortWeekdaysParse[i].test(weekdayName)){return i}else if(strict&&format==="dd"&&this._minWeekdaysParse[i].test(weekdayName)){return i}else if(!strict&&this._weekdaysParse[i].test(weekdayName)){return i}}}function getSetDayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN}var day=this._isUTC?this._d.getUTCDay():this._d.getDay();if(input!=null){input=parseWeekday(input,this.localeData());return this.add(input-day,"d")}else{return day}}function getSetLocaleDayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN}var weekday=(this.day()+7-this.localeData()._week.dow)%7;return input==null?weekday:this.add(input-weekday,"d")}function getSetISODayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN}if(input!=null){var weekday=parseIsoWeekday(input,this.localeData());return this.day(this.day()%7?weekday:weekday-7)}else{return this.day()||7}}var defaultWeekdaysRegex=matchWord;function weekdaysRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,"_weekdaysRegex")){computeWeekdaysParse.call(this)}if(isStrict){return this._weekdaysStrictRegex}else{return this._weekdaysRegex}}else{if(!hasOwnProp(this,"_weekdaysRegex")){this._weekdaysRegex=defaultWeekdaysRegex}return this._weekdaysStrictRegex&&isStrict?this._weekdaysStrictRegex:this._weekdaysRegex}}var defaultWeekdaysShortRegex=matchWord;function weekdaysShortRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,"_weekdaysRegex")){computeWeekdaysParse.call(this)}if(isStrict){return this._weekdaysShortStrictRegex}else{return this._weekdaysShortRegex}}else{if(!hasOwnProp(this,"_weekdaysShortRegex")){this._weekdaysShortRegex=defaultWeekdaysShortRegex}return this._weekdaysShortStrictRegex&&isStrict?this._weekdaysShortStrictRegex:this._weekdaysShortRegex}}var defaultWeekdaysMinRegex=matchWord;function weekdaysMinRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,"_weekdaysRegex")){computeWeekdaysParse.call(this)}if(isStrict){return this._weekdaysMinStrictRegex}else{return this._weekdaysMinRegex}}else{if(!hasOwnProp(this,"_weekdaysMinRegex")){this._weekdaysMinRegex=defaultWeekdaysMinRegex}return this._weekdaysMinStrictRegex&&isStrict?this._weekdaysMinStrictRegex:this._weekdaysMinRegex}}function computeWeekdaysParse(){function cmpLenRev(a,b){return b.length-a.length}var minPieces=[],shortPieces=[],longPieces=[],mixedPieces=[],i,mom,minp,shortp,longp;for(i=0;i<7;i++){mom=createUTC([2e3,1]).day(i);minp=this.weekdaysMin(mom,"");shortp=this.weekdaysShort(mom,"");longp=this.weekdays(mom,"");minPieces.push(minp);shortPieces.push(shortp);longPieces.push(longp);mixedPieces.push(minp);mixedPieces.push(shortp);mixedPieces.push(longp)}minPieces.sort(cmpLenRev);shortPieces.sort(cmpLenRev);longPieces.sort(cmpLenRev);mixedPieces.sort(cmpLenRev);for(i=0;i<7;i++){shortPieces[i]=regexEscape(shortPieces[i]);longPieces[i]=regexEscape(longPieces[i]);mixedPieces[i]=regexEscape(mixedPieces[i])}this._weekdaysRegex=new RegExp("^("+mixedPieces.join("|")+")","i");this._weekdaysShortRegex=this._weekdaysRegex;this._weekdaysMinRegex=this._weekdaysRegex;this._weekdaysStrictRegex=new RegExp("^("+longPieces.join("|")+")","i");this._weekdaysShortStrictRegex=new RegExp("^("+shortPieces.join("|")+")","i");this._weekdaysMinStrictRegex=new RegExp("^("+minPieces.join("|")+")","i")}function hFormat(){return this.hours()%12||12}function kFormat(){return this.hours()||24}addFormatToken("H",["HH",2],0,"hour");addFormatToken("h",["hh",2],0,hFormat);addFormatToken("k",["kk",2],0,kFormat);addFormatToken("hmm",0,0,function(){return""+hFormat.apply(this)+zeroFill(this.minutes(),2)});addFormatToken("hmmss",0,0,function(){return""+hFormat.apply(this)+zeroFill(this.minutes(),2)+zeroFill(this.seconds(),2)});addFormatToken("Hmm",0,0,function(){return""+this.hours()+zeroFill(this.minutes(),2)});addFormatToken("Hmmss",0,0,function(){return""+this.hours()+zeroFill(this.minutes(),2)+zeroFill(this.seconds(),2)});function meridiem(token,lowercase){addFormatToken(token,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),lowercase)})}meridiem("a",true);meridiem("A",false);addUnitAlias("hour","h");addUnitPriority("hour",13);function matchMeridiem(isStrict,locale){return locale._meridiemParse}addRegexToken("a",matchMeridiem);addRegexToken("A",matchMeridiem);addRegexToken("H",match1to2);addRegexToken("h",match1to2);addRegexToken("k",match1to2);addRegexToken("HH",match1to2,match2);addRegexToken("hh",match1to2,match2);addRegexToken("kk",match1to2,match2);addRegexToken("hmm",match3to4);addRegexToken("hmmss",match5to6);addRegexToken("Hmm",match3to4);addRegexToken("Hmmss",match5to6);addParseToken(["H","HH"],HOUR);addParseToken(["k","kk"],function(input,array,config){var kInput=toInt(input);array[HOUR]=kInput===24?0:kInput});addParseToken(["a","A"],function(input,array,config){config._isPm=config._locale.isPM(input);config._meridiem=input});addParseToken(["h","hh"],function(input,array,config){array[HOUR]=toInt(input);getParsingFlags(config).bigHour=true});addParseToken("hmm",function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos));array[MINUTE]=toInt(input.substr(pos));getParsingFlags(config).bigHour=true});addParseToken("hmmss",function(input,array,config){var pos1=input.length-4;var pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1));array[MINUTE]=toInt(input.substr(pos1,2));array[SECOND]=toInt(input.substr(pos2));getParsingFlags(config).bigHour=true});addParseToken("Hmm",function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos));array[MINUTE]=toInt(input.substr(pos))});addParseToken("Hmmss",function(input,array,config){var pos1=input.length-4;var pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1));array[MINUTE]=toInt(input.substr(pos1,2));array[SECOND]=toInt(input.substr(pos2))});function localeIsPM(input){return(input+"").toLowerCase().charAt(0)==="p"}var defaultLocaleMeridiemParse=/[ap]\.?m?\.?/i;function localeMeridiem(hours,minutes,isLower){if(hours>11){return isLower?"pm":"PM"}else{return isLower?"am":"AM"}}var getSetHour=makeGetSet("Hours",true);var baseConfig={calendar:defaultCalendar,longDateFormat:defaultLongDateFormat,invalidDate:defaultInvalidDate,ordinal:defaultOrdinal,dayOfMonthOrdinalParse:defaultDayOfMonthOrdinalParse,relativeTime:defaultRelativeTime,months:defaultLocaleMonths,monthsShort:defaultLocaleMonthsShort,week:defaultLocaleWeek,weekdays:defaultLocaleWeekdays,weekdaysMin:defaultLocaleWeekdaysMin,weekdaysShort:defaultLocaleWeekdaysShort,meridiemParse:defaultLocaleMeridiemParse};var locales={};var localeFamilies={};var globalLocale;function normalizeLocale(key){return key?key.toLowerCase().replace("_","-"):key}function chooseLocale(names){var i=0,j,next,locale,split;while(i<names.length){split=normalizeLocale(names[i]).split("-");j=split.length;next=normalizeLocale(names[i+1]);next=next?next.split("-"):null;while(j>0){locale=loadLocale(split.slice(0,j).join("-"));if(locale){return locale}if(next&&next.length>=j&&compareArrays(split,next,true)>=j-1){break}j--}i++}return null}function loadLocale(name){var oldLocale=null;if(!locales[name]&&typeof module!=="undefined"&&module&&module.exports){try{oldLocale=globalLocale._abbr;require("./locale/"+name);getSetGlobalLocale(oldLocale)}catch(e){}}return locales[name]}function getSetGlobalLocale(key,values){var data;if(key){if(isUndefined(values)){data=getLocale(key)}else{data=defineLocale(key,values)}if(data){globalLocale=data}}return globalLocale._abbr}function defineLocale(name,config){if(config!==null){var parentConfig=baseConfig;config.abbr=name;if(locales[name]!=null){deprecateSimple("defineLocaleOverride","use moment.updateLocale(localeName, config) to change "+"an existing locale. moment.defineLocale(localeName, "+"config) should only be used for creating a new locale "+"See http://momentjs.com/guides/#/warnings/define-locale/ for more info.");parentConfig=locales[name]._config}else if(config.parentLocale!=null){if(locales[config.parentLocale]!=null){parentConfig=locales[config.parentLocale]._config}else{if(!localeFamilies[config.parentLocale]){localeFamilies[config.parentLocale]=[]}localeFamilies[config.parentLocale].push({name:name,config:config});return null}}locales[name]=new Locale(mergeConfigs(parentConfig,config));if(localeFamilies[name]){localeFamilies[name].forEach(function(x){defineLocale(x.name,x.config)})}getSetGlobalLocale(name);return locales[name]}else{delete locales[name];return null}}function updateLocale(name,config){if(config!=null){var locale,parentConfig=baseConfig;if(locales[name]!=null){parentConfig=locales[name]._config}config=mergeConfigs(parentConfig,config);locale=new Locale(config);locale.parentLocale=locales[name];locales[name]=locale;getSetGlobalLocale(name)}else{if(locales[name]!=null){if(locales[name].parentLocale!=null){locales[name]=locales[name].parentLocale}else if(locales[name]!=null){delete locales[name]}}}return locales[name]}function getLocale(key){var locale;if(key&&key._locale&&key._locale._abbr){key=key._locale._abbr}if(!key){return globalLocale}if(!isArray(key)){locale=loadLocale(key);if(locale){return locale}key=[key]}return chooseLocale(key)}function listLocales(){return keys$1(locales)}function checkOverflow(m){var overflow;var a=m._a;if(a&&getParsingFlags(m).overflow===-2){overflow=a[MONTH]<0||a[MONTH]>11?MONTH:a[DATE]<1||a[DATE]>daysInMonth(a[YEAR],a[MONTH])?DATE:a[HOUR]<0||a[HOUR]>24||a[HOUR]===24&&(a[MINUTE]!==0||a[SECOND]!==0||a[MILLISECOND]!==0)?HOUR:a[MINUTE]<0||a[MINUTE]>59?MINUTE:a[SECOND]<0||a[SECOND]>59?SECOND:a[MILLISECOND]<0||a[MILLISECOND]>999?MILLISECOND:-1;if(getParsingFlags(m)._overflowDayOfYear&&(overflow<YEAR||overflow>DATE)){overflow=DATE}if(getParsingFlags(m)._overflowWeeks&&overflow===-1){overflow=WEEK}if(getParsingFlags(m)._overflowWeekday&&overflow===-1){overflow=WEEKDAY}getParsingFlags(m).overflow=overflow}return m}var extendedIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;var basicIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;var tzRegex=/Z|[+-]\d\d(?::?\d\d)?/;var isoDates=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,false],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,false],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,false],["YYYYDDD",/\d{7}/]];var isoTimes=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]];var aspNetJsonRegex=/^\/?Date\((\-?\d+)/i;function configFromISO(config){var i,l,string=config._i,match=extendedIsoRegex.exec(string)||basicIsoRegex.exec(string),allowTime,dateFormat,timeFormat,tzFormat;if(match){getParsingFlags(config).iso=true;for(i=0,l=isoDates.length;i<l;i++){if(isoDates[i][1].exec(match[1])){dateFormat=isoDates[i][0];allowTime=isoDates[i][2]!==false;break}}if(dateFormat==null){config._isValid=false;return}if(match[3]){for(i=0,l=isoTimes.length;i<l;i++){if(isoTimes[i][1].exec(match[3])){timeFormat=(match[2]||" ")+isoTimes[i][0];break}}if(timeFormat==null){config._isValid=false;return}}if(!allowTime&&timeFormat!=null){config._isValid=false;return}if(match[4]){if(tzRegex.exec(match[4])){tzFormat="Z"}else{config._isValid=false;return}}config._f=dateFormat+(timeFormat||"")+(tzFormat||"");configFromStringAndFormat(config)}else{config._isValid=false}}var basicRfcRegex=/^((?:Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d?\d\s(?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(?:\d\d)?\d\d\s)(\d\d:\d\d)(\:\d\d)?(\s(?:UT|GMT|[ECMP][SD]T|[A-IK-Za-ik-z]|[+-]\d{4}))$/;function configFromRFC2822(config){var string,match,dayFormat,dateFormat,timeFormat,tzFormat;var timezones={" GMT":" +0000"," EDT":" -0400"," EST":" -0500"," CDT":" -0500"," CST":" -0600"," MDT":" -0600"," MST":" -0700"," PDT":" -0700"," PST":" -0800"};var military="YXWVUTSRQPONZABCDEFGHIKLM";var timezone,timezoneIndex;string=config._i.replace(/\([^\)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s|\s$/g,"");match=basicRfcRegex.exec(string);if(match){dayFormat=match[1]?"ddd"+(match[1].length===5?", ":" "):"";dateFormat="D MMM "+(match[2].length>10?"YYYY ":"YY ");timeFormat="HH:mm"+(match[4]?":ss":"");if(match[1]){var momentDate=new Date(match[2]);var momentDay=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"][momentDate.getDay()];if(match[1].substr(0,3)!==momentDay){getParsingFlags(config).weekdayMismatch=true;config._isValid=false;return}}switch(match[5].length){case 2:if(timezoneIndex===0){timezone=" +0000"}else{timezoneIndex=military.indexOf(match[5][1].toUpperCase())-12;timezone=(timezoneIndex<0?" -":" +")+(""+timezoneIndex).replace(/^-?/,"0").match(/..$/)[0]+"00"}break;case 4:timezone=timezones[match[5]];break;default:timezone=timezones[" GMT"]}match[5]=timezone;config._i=match.splice(1).join("");tzFormat=" ZZ";config._f=dayFormat+dateFormat+timeFormat+tzFormat;configFromStringAndFormat(config);getParsingFlags(config).rfc2822=true}else{config._isValid=false}}function configFromString(config){var matched=aspNetJsonRegex.exec(config._i);if(matched!==null){config._d=new Date(+matched[1]);return}configFromISO(config);if(config._isValid===false){delete config._isValid}else{return}configFromRFC2822(config);if(config._isValid===false){delete config._isValid}else{return}hooks.createFromInputFallback(config)}hooks.createFromInputFallback=deprecate("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), "+"which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are "+"discouraged and will be removed in an upcoming major release. Please refer to "+"http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(config){config._d=new Date(config._i+(config._useUTC?" UTC":""))});function defaults(a,b,c){if(a!=null){return a}if(b!=null){return b}return c}function currentDateArray(config){var nowValue=new Date(hooks.now());if(config._useUTC){return[nowValue.getUTCFullYear(),nowValue.getUTCMonth(),nowValue.getUTCDate()]}return[nowValue.getFullYear(),nowValue.getMonth(),nowValue.getDate()]}function configFromArray(config){var i,date,input=[],currentDate,yearToUse;if(config._d){return}currentDate=currentDateArray(config);if(config._w&&config._a[DATE]==null&&config._a[MONTH]==null){dayOfYearFromWeekInfo(config)}if(config._dayOfYear!=null){yearToUse=defaults(config._a[YEAR],currentDate[YEAR]);if(config._dayOfYear>daysInYear(yearToUse)||config._dayOfYear===0){getParsingFlags(config)._overflowDayOfYear=true}date=createUTCDate(yearToUse,0,config._dayOfYear);config._a[MONTH]=date.getUTCMonth();config._a[DATE]=date.getUTCDate()}for(i=0;i<3&&config._a[i]==null;++i){config._a[i]=input[i]=currentDate[i]}for(;i<7;i++){config._a[i]=input[i]=config._a[i]==null?i===2?1:0:config._a[i]}if(config._a[HOUR]===24&&config._a[MINUTE]===0&&config._a[SECOND]===0&&config._a[MILLISECOND]===0){config._nextDay=true;config._a[HOUR]=0}config._d=(config._useUTC?createUTCDate:createDate).apply(null,input);if(config._tzm!=null){config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm)}if(config._nextDay){config._a[HOUR]=24}}function dayOfYearFromWeekInfo(config){var w,weekYear,week,weekday,dow,doy,temp,weekdayOverflow;w=config._w;if(w.GG!=null||w.W!=null||w.E!=null){dow=1;doy=4;weekYear=defaults(w.GG,config._a[YEAR],weekOfYear(createLocal(),1,4).year);week=defaults(w.W,1);weekday=defaults(w.E,1);if(weekday<1||weekday>7){weekdayOverflow=true}}else{dow=config._locale._week.dow;doy=config._locale._week.doy;var curWeek=weekOfYear(createLocal(),dow,doy);weekYear=defaults(w.gg,config._a[YEAR],curWeek.year);week=defaults(w.w,curWeek.week);if(w.d!=null){weekday=w.d;if(weekday<0||weekday>6){weekdayOverflow=true}}else if(w.e!=null){weekday=w.e+dow;if(w.e<0||w.e>6){weekdayOverflow=true}}else{weekday=dow}}if(week<1||week>weeksInYear(weekYear,dow,doy)){getParsingFlags(config)._overflowWeeks=true}else if(weekdayOverflow!=null){getParsingFlags(config)._overflowWeekday=true}else{temp=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy);config._a[YEAR]=temp.year;config._dayOfYear=temp.dayOfYear}}hooks.ISO_8601=function(){};hooks.RFC_2822=function(){};function configFromStringAndFormat(config){if(config._f===hooks.ISO_8601){configFromISO(config);return}if(config._f===hooks.RFC_2822){configFromRFC2822(config);return}config._a=[];getParsingFlags(config).empty=true;var string=""+config._i,i,parsedInput,tokens,token,skipped,stringLength=string.length,totalParsedInputLength=0;tokens=expandFormat(config._f,config._locale).match(formattingTokens)||[];for(i=0;i<tokens.length;i++){token=tokens[i];parsedInput=(string.match(getParseRegexForToken(token,config))||[])[0];if(parsedInput){skipped=string.substr(0,string.indexOf(parsedInput));if(skipped.length>0){getParsingFlags(config).unusedInput.push(skipped)}string=string.slice(string.indexOf(parsedInput)+parsedInput.length);totalParsedInputLength+=parsedInput.length}if(formatTokenFunctions[token]){if(parsedInput){getParsingFlags(config).empty=false}else{getParsingFlags(config).unusedTokens.push(token)}addTimeToArrayFromToken(token,parsedInput,config)}else if(config._strict&&!parsedInput){getParsingFlags(config).unusedTokens.push(token)}}getParsingFlags(config).charsLeftOver=stringLength-totalParsedInputLength;if(string.length>0){getParsingFlags(config).unusedInput.push(string)}if(config._a[HOUR]<=12&&getParsingFlags(config).bigHour===true&&config._a[HOUR]>0){getParsingFlags(config).bigHour=undefined}getParsingFlags(config).parsedDateParts=config._a.slice(0);getParsingFlags(config).meridiem=config._meridiem;config._a[HOUR]=meridiemFixWrap(config._locale,config._a[HOUR],config._meridiem);configFromArray(config);checkOverflow(config)}function meridiemFixWrap(locale,hour,meridiem){var isPm;if(meridiem==null){return hour}if(locale.meridiemHour!=null){return locale.meridiemHour(hour,meridiem)}else if(locale.isPM!=null){isPm=locale.isPM(meridiem);if(isPm&&hour<12){hour+=12}if(!isPm&&hour===12){hour=0}return hour}else{return hour}}function configFromStringAndArray(config){var tempConfig,bestMoment,scoreToBeat,i,currentScore;if(config._f.length===0){getParsingFlags(config).invalidFormat=true;config._d=new Date(NaN);return}for(i=0;i<config._f.length;i++){currentScore=0;tempConfig=copyConfig({},config);if(config._useUTC!=null){tempConfig._useUTC=config._useUTC}tempConfig._f=config._f[i];configFromStringAndFormat(tempConfig);if(!isValid(tempConfig)){continue}currentScore+=getParsingFlags(tempConfig).charsLeftOver;currentScore+=getParsingFlags(tempConfig).unusedTokens.length*10;getParsingFlags(tempConfig).score=currentScore;if(scoreToBeat==null||currentScore<scoreToBeat){scoreToBeat=currentScore;bestMoment=tempConfig}}extend(config,bestMoment||tempConfig)}function configFromObject(config){if(config._d){return}var i=normalizeObjectUnits(config._i);config._a=map([i.year,i.month,i.day||i.date,i.hour,i.minute,i.second,i.millisecond],function(obj){return obj&&parseInt(obj,10)});configFromArray(config)}function createFromConfig(config){var res=new Moment(checkOverflow(prepareConfig(config)));if(res._nextDay){res.add(1,"d");res._nextDay=undefined}return res}function prepareConfig(config){var input=config._i,format=config._f;config._locale=config._locale||getLocale(config._l);if(input===null||format===undefined&&input===""){return createInvalid({nullInput:true})}if(typeof input==="string"){config._i=input=config._locale.preparse(input)}if(isMoment(input)){return new Moment(checkOverflow(input))}else if(isDate(input)){config._d=input}else if(isArray(format)){configFromStringAndArray(config)}else if(format){configFromStringAndFormat(config)}else{configFromInput(config)}if(!isValid(config)){config._d=null}return config}function configFromInput(config){var input=config._i;if(isUndefined(input)){config._d=new Date(hooks.now())}else if(isDate(input)){config._d=new Date(input.valueOf())}else if(typeof input==="string"){configFromString(config)}else if(isArray(input)){config._a=map(input.slice(0),function(obj){return parseInt(obj,10)});configFromArray(config)}else if(isObject(input)){configFromObject(config)}else if(isNumber(input)){config._d=new Date(input)}else{hooks.createFromInputFallback(config)}}function createLocalOrUTC(input,format,locale,strict,isUTC){var c={};if(locale===true||locale===false){strict=locale;locale=undefined}if(isObject(input)&&isObjectEmpty(input)||isArray(input)&&input.length===0){input=undefined}c._isAMomentObject=true;c._useUTC=c._isUTC=isUTC;c._l=locale;c._i=input;c._f=format;c._strict=strict;return createFromConfig(c)}function createLocal(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,false)}var prototypeMin=deprecate("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var other=createLocal.apply(null,arguments);if(this.isValid()&&other.isValid()){return other<this?this:other}else{return createInvalid()}});var prototypeMax=deprecate("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var other=createLocal.apply(null,arguments);if(this.isValid()&&other.isValid()){return other>this?this:other}else{return createInvalid()}});function pickBy(fn,moments){var res,i;if(moments.length===1&&isArray(moments[0])){moments=moments[0]}if(!moments.length){return createLocal()
}res=moments[0];for(i=1;i<moments.length;++i){if(!moments[i].isValid()||moments[i][fn](res)){res=moments[i]}}return res}function min(){var args=[].slice.call(arguments,0);return pickBy("isBefore",args)}function max(){var args=[].slice.call(arguments,0);return pickBy("isAfter",args)}var now=function(){return Date.now?Date.now():+new Date};var ordering=["year","quarter","month","week","day","hour","minute","second","millisecond"];function isDurationValid(m){for(var key in m){if(!(ordering.indexOf(key)!==-1&&(m[key]==null||!isNaN(m[key])))){return false}}var unitHasDecimal=false;for(var i=0;i<ordering.length;++i){if(m[ordering[i]]){if(unitHasDecimal){return false}if(parseFloat(m[ordering[i]])!==toInt(m[ordering[i]])){unitHasDecimal=true}}}return true}function isValid$1(){return this._isValid}function createInvalid$1(){return createDuration(NaN)}function Duration(duration){var normalizedInput=normalizeObjectUnits(duration),years=normalizedInput.year||0,quarters=normalizedInput.quarter||0,months=normalizedInput.month||0,weeks=normalizedInput.week||0,days=normalizedInput.day||0,hours=normalizedInput.hour||0,minutes=normalizedInput.minute||0,seconds=normalizedInput.second||0,milliseconds=normalizedInput.millisecond||0;this._isValid=isDurationValid(normalizedInput);this._milliseconds=+milliseconds+seconds*1e3+minutes*6e4+hours*1e3*60*60;this._days=+days+weeks*7;this._months=+months+quarters*3+years*12;this._data={};this._locale=getLocale();this._bubble()}function isDuration(obj){return obj instanceof Duration}function absRound(number){if(number<0){return Math.round(-1*number)*-1}else{return Math.round(number)}}function offset(token,separator){addFormatToken(token,0,0,function(){var offset=this.utcOffset();var sign="+";if(offset<0){offset=-offset;sign="-"}return sign+zeroFill(~~(offset/60),2)+separator+zeroFill(~~offset%60,2)})}offset("Z",":");offset("ZZ","");addRegexToken("Z",matchShortOffset);addRegexToken("ZZ",matchShortOffset);addParseToken(["Z","ZZ"],function(input,array,config){config._useUTC=true;config._tzm=offsetFromString(matchShortOffset,input)});var chunkOffset=/([\+\-]|\d\d)/gi;function offsetFromString(matcher,string){var matches=(string||"").match(matcher);if(matches===null){return null}var chunk=matches[matches.length-1]||[];var parts=(chunk+"").match(chunkOffset)||["-",0,0];var minutes=+(parts[1]*60)+toInt(parts[2]);return minutes===0?0:parts[0]==="+"?minutes:-minutes}function cloneWithOffset(input,model){var res,diff;if(model._isUTC){res=model.clone();diff=(isMoment(input)||isDate(input)?input.valueOf():createLocal(input).valueOf())-res.valueOf();res._d.setTime(res._d.valueOf()+diff);hooks.updateOffset(res,false);return res}else{return createLocal(input).local()}}function getDateOffset(m){return-Math.round(m._d.getTimezoneOffset()/15)*15}hooks.updateOffset=function(){};function getSetOffset(input,keepLocalTime,keepMinutes){var offset=this._offset||0,localAdjust;if(!this.isValid()){return input!=null?this:NaN}if(input!=null){if(typeof input==="string"){input=offsetFromString(matchShortOffset,input);if(input===null){return this}}else if(Math.abs(input)<16&&!keepMinutes){input=input*60}if(!this._isUTC&&keepLocalTime){localAdjust=getDateOffset(this)}this._offset=input;this._isUTC=true;if(localAdjust!=null){this.add(localAdjust,"m")}if(offset!==input){if(!keepLocalTime||this._changeInProgress){addSubtract(this,createDuration(input-offset,"m"),1,false)}else if(!this._changeInProgress){this._changeInProgress=true;hooks.updateOffset(this,true);this._changeInProgress=null}}return this}else{return this._isUTC?offset:getDateOffset(this)}}function getSetZone(input,keepLocalTime){if(input!=null){if(typeof input!=="string"){input=-input}this.utcOffset(input,keepLocalTime);return this}else{return-this.utcOffset()}}function setOffsetToUTC(keepLocalTime){return this.utcOffset(0,keepLocalTime)}function setOffsetToLocal(keepLocalTime){if(this._isUTC){this.utcOffset(0,keepLocalTime);this._isUTC=false;if(keepLocalTime){this.subtract(getDateOffset(this),"m")}}return this}function setOffsetToParsedOffset(){if(this._tzm!=null){this.utcOffset(this._tzm,false,true)}else if(typeof this._i==="string"){var tZone=offsetFromString(matchOffset,this._i);if(tZone!=null){this.utcOffset(tZone)}else{this.utcOffset(0,true)}}return this}function hasAlignedHourOffset(input){if(!this.isValid()){return false}input=input?createLocal(input).utcOffset():0;return(this.utcOffset()-input)%60===0}function isDaylightSavingTime(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function isDaylightSavingTimeShifted(){if(!isUndefined(this._isDSTShifted)){return this._isDSTShifted}var c={};copyConfig(c,this);c=prepareConfig(c);if(c._a){var other=c._isUTC?createUTC(c._a):createLocal(c._a);this._isDSTShifted=this.isValid()&&compareArrays(c._a,other.toArray())>0}else{this._isDSTShifted=false}return this._isDSTShifted}function isLocal(){return this.isValid()?!this._isUTC:false}function isUtcOffset(){return this.isValid()?this._isUTC:false}function isUtc(){return this.isValid()?this._isUTC&&this._offset===0:false}var aspNetRegex=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;var isoRegex=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;function createDuration(input,key){var duration=input,match=null,sign,ret,diffRes;if(isDuration(input)){duration={ms:input._milliseconds,d:input._days,M:input._months}}else if(isNumber(input)){duration={};if(key){duration[key]=input}else{duration.milliseconds=input}}else if(!!(match=aspNetRegex.exec(input))){sign=match[1]==="-"?-1:1;duration={y:0,d:toInt(match[DATE])*sign,h:toInt(match[HOUR])*sign,m:toInt(match[MINUTE])*sign,s:toInt(match[SECOND])*sign,ms:toInt(absRound(match[MILLISECOND]*1e3))*sign}}else if(!!(match=isoRegex.exec(input))){sign=match[1]==="-"?-1:1;duration={y:parseIso(match[2],sign),M:parseIso(match[3],sign),w:parseIso(match[4],sign),d:parseIso(match[5],sign),h:parseIso(match[6],sign),m:parseIso(match[7],sign),s:parseIso(match[8],sign)}}else if(duration==null){duration={}}else if(typeof duration==="object"&&("from"in duration||"to"in duration)){diffRes=momentsDifference(createLocal(duration.from),createLocal(duration.to));duration={};duration.ms=diffRes.milliseconds;duration.M=diffRes.months}ret=new Duration(duration);if(isDuration(input)&&hasOwnProp(input,"_locale")){ret._locale=input._locale}return ret}createDuration.fn=Duration.prototype;createDuration.invalid=createInvalid$1;function parseIso(inp,sign){var res=inp&&parseFloat(inp.replace(",","."));return(isNaN(res)?0:res)*sign}function positiveMomentsDifference(base,other){var res={milliseconds:0,months:0};res.months=other.month()-base.month()+(other.year()-base.year())*12;if(base.clone().add(res.months,"M").isAfter(other)){--res.months}res.milliseconds=+other-+base.clone().add(res.months,"M");return res}function momentsDifference(base,other){var res;if(!(base.isValid()&&other.isValid())){return{milliseconds:0,months:0}}other=cloneWithOffset(other,base);if(base.isBefore(other)){res=positiveMomentsDifference(base,other)}else{res=positiveMomentsDifference(other,base);res.milliseconds=-res.milliseconds;res.months=-res.months}return res}function createAdder(direction,name){return function(val,period){var dur,tmp;if(period!==null&&!isNaN(+period)){deprecateSimple(name,"moment()."+name+"(period, number) is deprecated. Please use moment()."+name+"(number, period). "+"See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.");tmp=val;val=period;period=tmp}val=typeof val==="string"?+val:val;dur=createDuration(val,period);addSubtract(this,dur,direction);return this}}function addSubtract(mom,duration,isAdding,updateOffset){var milliseconds=duration._milliseconds,days=absRound(duration._days),months=absRound(duration._months);if(!mom.isValid()){return}updateOffset=updateOffset==null?true:updateOffset;if(milliseconds){mom._d.setTime(mom._d.valueOf()+milliseconds*isAdding)}if(days){set$1(mom,"Date",get(mom,"Date")+days*isAdding)}if(months){setMonth(mom,get(mom,"Month")+months*isAdding)}if(updateOffset){hooks.updateOffset(mom,days||months)}}var add=createAdder(1,"add");var subtract=createAdder(-1,"subtract");function getCalendarFormat(myMoment,now){var diff=myMoment.diff(now,"days",true);return diff<-6?"sameElse":diff<-1?"lastWeek":diff<0?"lastDay":diff<1?"sameDay":diff<2?"nextDay":diff<7?"nextWeek":"sameElse"}function calendar$1(time,formats){var now=time||createLocal(),sod=cloneWithOffset(now,this).startOf("day"),format=hooks.calendarFormat(this,sod)||"sameElse";var output=formats&&(isFunction(formats[format])?formats[format].call(this,now):formats[format]);return this.format(output||this.localeData().calendar(format,this,createLocal(now)))}function clone(){return new Moment(this)}function isAfter(input,units){var localInput=isMoment(input)?input:createLocal(input);if(!(this.isValid()&&localInput.isValid())){return false}units=normalizeUnits(!isUndefined(units)?units:"millisecond");if(units==="millisecond"){return this.valueOf()>localInput.valueOf()}else{return localInput.valueOf()<this.clone().startOf(units).valueOf()}}function isBefore(input,units){var localInput=isMoment(input)?input:createLocal(input);if(!(this.isValid()&&localInput.isValid())){return false}units=normalizeUnits(!isUndefined(units)?units:"millisecond");if(units==="millisecond"){return this.valueOf()<localInput.valueOf()}else{return this.clone().endOf(units).valueOf()<localInput.valueOf()}}function isBetween(from,to,units,inclusivity){inclusivity=inclusivity||"()";return(inclusivity[0]==="("?this.isAfter(from,units):!this.isBefore(from,units))&&(inclusivity[1]===")"?this.isBefore(to,units):!this.isAfter(to,units))}function isSame(input,units){var localInput=isMoment(input)?input:createLocal(input),inputMs;if(!(this.isValid()&&localInput.isValid())){return false}units=normalizeUnits(units||"millisecond");if(units==="millisecond"){return this.valueOf()===localInput.valueOf()}else{inputMs=localInput.valueOf();return this.clone().startOf(units).valueOf()<=inputMs&&inputMs<=this.clone().endOf(units).valueOf()}}function isSameOrAfter(input,units){return this.isSame(input,units)||this.isAfter(input,units)}function isSameOrBefore(input,units){return this.isSame(input,units)||this.isBefore(input,units)}function diff(input,units,asFloat){var that,zoneDelta,delta,output;if(!this.isValid()){return NaN}that=cloneWithOffset(input,this);if(!that.isValid()){return NaN}zoneDelta=(that.utcOffset()-this.utcOffset())*6e4;units=normalizeUnits(units);if(units==="year"||units==="month"||units==="quarter"){output=monthDiff(this,that);if(units==="quarter"){output=output/3}else if(units==="year"){output=output/12}}else{delta=this-that;output=units==="second"?delta/1e3:units==="minute"?delta/6e4:units==="hour"?delta/36e5:units==="day"?(delta-zoneDelta)/864e5:units==="week"?(delta-zoneDelta)/6048e5:delta}return asFloat?output:absFloor(output)}function monthDiff(a,b){var wholeMonthDiff=(b.year()-a.year())*12+(b.month()-a.month()),anchor=a.clone().add(wholeMonthDiff,"months"),anchor2,adjust;if(b-anchor<0){anchor2=a.clone().add(wholeMonthDiff-1,"months");adjust=(b-anchor)/(anchor-anchor2)}else{anchor2=a.clone().add(wholeMonthDiff+1,"months");adjust=(b-anchor)/(anchor2-anchor)}return-(wholeMonthDiff+adjust)||0}hooks.defaultFormat="YYYY-MM-DDTHH:mm:ssZ";hooks.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";function toString(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function toISOString(){if(!this.isValid()){return null}var m=this.clone().utc();if(m.year()<0||m.year()>9999){return formatMoment(m,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}if(isFunction(Date.prototype.toISOString)){return this.toDate().toISOString()}return formatMoment(m,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function inspect(){if(!this.isValid()){return"moment.invalid(/* "+this._i+" */)"}var func="moment";var zone="";if(!this.isLocal()){func=this.utcOffset()===0?"moment.utc":"moment.parseZone";zone="Z"}var prefix="["+func+'("]';var year=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY";var datetime="-MM-DD[T]HH:mm:ss.SSS";var suffix=zone+'[")]';return this.format(prefix+year+datetime+suffix)}function format(inputString){if(!inputString){inputString=this.isUtc()?hooks.defaultFormatUtc:hooks.defaultFormat}var output=formatMoment(this,inputString);return this.localeData().postformat(output)}function from(time,withoutSuffix){if(this.isValid()&&(isMoment(time)&&time.isValid()||createLocal(time).isValid())){return createDuration({to:this,from:time}).locale(this.locale()).humanize(!withoutSuffix)}else{return this.localeData().invalidDate()}}function fromNow(withoutSuffix){return this.from(createLocal(),withoutSuffix)}function to(time,withoutSuffix){if(this.isValid()&&(isMoment(time)&&time.isValid()||createLocal(time).isValid())){return createDuration({from:this,to:time}).locale(this.locale()).humanize(!withoutSuffix)}else{return this.localeData().invalidDate()}}function toNow(withoutSuffix){return this.to(createLocal(),withoutSuffix)}function locale(key){var newLocaleData;if(key===undefined){return this._locale._abbr}else{newLocaleData=getLocale(key);if(newLocaleData!=null){this._locale=newLocaleData}return this}}var lang=deprecate("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(key){if(key===undefined){return this.localeData()}else{return this.locale(key)}});function localeData(){return this._locale}function startOf(units){units=normalizeUnits(units);switch(units){case"year":this.month(0);case"quarter":case"month":this.date(1);case"week":case"isoWeek":case"day":case"date":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}if(units==="week"){this.weekday(0)}if(units==="isoWeek"){this.isoWeekday(1)}if(units==="quarter"){this.month(Math.floor(this.month()/3)*3)}return this}function endOf(units){units=normalizeUnits(units);if(units===undefined||units==="millisecond"){return this}if(units==="date"){units="day"}return this.startOf(units).add(1,units==="isoWeek"?"week":units).subtract(1,"ms")}function valueOf(){return this._d.valueOf()-(this._offset||0)*6e4}function unix(){return Math.floor(this.valueOf()/1e3)}function toDate(){return new Date(this.valueOf())}function toArray(){var m=this;return[m.year(),m.month(),m.date(),m.hour(),m.minute(),m.second(),m.millisecond()]}function toObject(){var m=this;return{years:m.year(),months:m.month(),date:m.date(),hours:m.hours(),minutes:m.minutes(),seconds:m.seconds(),milliseconds:m.milliseconds()}}function toJSON(){return this.isValid()?this.toISOString():null}function isValid$2(){return isValid(this)}function parsingFlags(){return extend({},getParsingFlags(this))}function invalidAt(){return getParsingFlags(this).overflow}function creationData(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}addFormatToken(0,["gg",2],0,function(){return this.weekYear()%100});addFormatToken(0,["GG",2],0,function(){return this.isoWeekYear()%100});function addWeekYearFormatToken(token,getter){addFormatToken(0,[token,token.length],0,getter)}addWeekYearFormatToken("gggg","weekYear");addWeekYearFormatToken("ggggg","weekYear");addWeekYearFormatToken("GGGG","isoWeekYear");addWeekYearFormatToken("GGGGG","isoWeekYear");addUnitAlias("weekYear","gg");addUnitAlias("isoWeekYear","GG");addUnitPriority("weekYear",1);addUnitPriority("isoWeekYear",1);addRegexToken("G",matchSigned);addRegexToken("g",matchSigned);addRegexToken("GG",match1to2,match2);addRegexToken("gg",match1to2,match2);addRegexToken("GGGG",match1to4,match4);addRegexToken("gggg",match1to4,match4);addRegexToken("GGGGG",match1to6,match6);addRegexToken("ggggg",match1to6,match6);addWeekParseToken(["gggg","ggggg","GGGG","GGGGG"],function(input,week,config,token){week[token.substr(0,2)]=toInt(input)});addWeekParseToken(["gg","GG"],function(input,week,config,token){week[token]=hooks.parseTwoDigitYear(input)});function getSetWeekYear(input){return getSetWeekYearHelper.call(this,input,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function getSetISOWeekYear(input){return getSetWeekYearHelper.call(this,input,this.isoWeek(),this.isoWeekday(),1,4)}function getISOWeeksInYear(){return weeksInYear(this.year(),1,4)}function getWeeksInYear(){var weekInfo=this.localeData()._week;return weeksInYear(this.year(),weekInfo.dow,weekInfo.doy)}function getSetWeekYearHelper(input,week,weekday,dow,doy){var weeksTarget;if(input==null){return weekOfYear(this,dow,doy).year}else{weeksTarget=weeksInYear(input,dow,doy);if(week>weeksTarget){week=weeksTarget}return setWeekAll.call(this,input,week,weekday,dow,doy)}}function setWeekAll(weekYear,week,weekday,dow,doy){var dayOfYearData=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy),date=createUTCDate(dayOfYearData.year,0,dayOfYearData.dayOfYear);this.year(date.getUTCFullYear());this.month(date.getUTCMonth());this.date(date.getUTCDate());return this}addFormatToken("Q",0,"Qo","quarter");addUnitAlias("quarter","Q");addUnitPriority("quarter",7);addRegexToken("Q",match1);addParseToken("Q",function(input,array){array[MONTH]=(toInt(input)-1)*3});function getSetQuarter(input){return input==null?Math.ceil((this.month()+1)/3):this.month((input-1)*3+this.month()%3)}addFormatToken("D",["DD",2],"Do","date");addUnitAlias("date","D");addUnitPriority("date",9);addRegexToken("D",match1to2);addRegexToken("DD",match1to2,match2);addRegexToken("Do",function(isStrict,locale){return isStrict?locale._dayOfMonthOrdinalParse||locale._ordinalParse:locale._dayOfMonthOrdinalParseLenient});addParseToken(["D","DD"],DATE);addParseToken("Do",function(input,array){array[DATE]=toInt(input.match(match1to2)[0],10)});var getSetDayOfMonth=makeGetSet("Date",true);addFormatToken("DDD",["DDDD",3],"DDDo","dayOfYear");addUnitAlias("dayOfYear","DDD");addUnitPriority("dayOfYear",4);addRegexToken("DDD",match1to3);addRegexToken("DDDD",match3);addParseToken(["DDD","DDDD"],function(input,array,config){config._dayOfYear=toInt(input)});function getSetDayOfYear(input){var dayOfYear=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return input==null?dayOfYear:this.add(input-dayOfYear,"d")}addFormatToken("m",["mm",2],0,"minute");addUnitAlias("minute","m");addUnitPriority("minute",14);addRegexToken("m",match1to2);addRegexToken("mm",match1to2,match2);addParseToken(["m","mm"],MINUTE);var getSetMinute=makeGetSet("Minutes",false);addFormatToken("s",["ss",2],0,"second");addUnitAlias("second","s");addUnitPriority("second",15);addRegexToken("s",match1to2);addRegexToken("ss",match1to2,match2);addParseToken(["s","ss"],SECOND);var getSetSecond=makeGetSet("Seconds",false);addFormatToken("S",0,0,function(){return~~(this.millisecond()/100)});addFormatToken(0,["SS",2],0,function(){return~~(this.millisecond()/10)});addFormatToken(0,["SSS",3],0,"millisecond");addFormatToken(0,["SSSS",4],0,function(){return this.millisecond()*10});addFormatToken(0,["SSSSS",5],0,function(){return this.millisecond()*100});addFormatToken(0,["SSSSSS",6],0,function(){return this.millisecond()*1e3});addFormatToken(0,["SSSSSSS",7],0,function(){return this.millisecond()*1e4});addFormatToken(0,["SSSSSSSS",8],0,function(){return this.millisecond()*1e5});addFormatToken(0,["SSSSSSSSS",9],0,function(){return this.millisecond()*1e6});addUnitAlias("millisecond","ms");addUnitPriority("millisecond",16);addRegexToken("S",match1to3,match1);addRegexToken("SS",match1to3,match2);addRegexToken("SSS",match1to3,match3);var token;for(token="SSSS";token.length<=9;token+="S"){addRegexToken(token,matchUnsigned)}function parseMs(input,array){array[MILLISECOND]=toInt(("0."+input)*1e3)}for(token="S";token.length<=9;token+="S"){addParseToken(token,parseMs)}var getSetMillisecond=makeGetSet("Milliseconds",false);addFormatToken("z",0,0,"zoneAbbr");addFormatToken("zz",0,0,"zoneName");function getZoneAbbr(){return this._isUTC?"UTC":""}function getZoneName(){return this._isUTC?"Coordinated Universal Time":""}var proto=Moment.prototype;proto.add=add;proto.calendar=calendar$1;proto.clone=clone;proto.diff=diff;proto.endOf=endOf;proto.format=format;proto.from=from;proto.fromNow=fromNow;proto.to=to;proto.toNow=toNow;proto.get=stringGet;proto.invalidAt=invalidAt;proto.isAfter=isAfter;proto.isBefore=isBefore;proto.isBetween=isBetween;proto.isSame=isSame;proto.isSameOrAfter=isSameOrAfter;proto.isSameOrBefore=isSameOrBefore;proto.isValid=isValid$2;proto.lang=lang;proto.locale=locale;proto.localeData=localeData;proto.max=prototypeMax;proto.min=prototypeMin;proto.parsingFlags=parsingFlags;proto.set=stringSet;proto.startOf=startOf;proto.subtract=subtract;proto.toArray=toArray;proto.toObject=toObject;proto.toDate=toDate;proto.toISOString=toISOString;proto.inspect=inspect;proto.toJSON=toJSON;proto.toString=toString;proto.unix=unix;proto.valueOf=valueOf;proto.creationData=creationData;proto.year=getSetYear;proto.isLeapYear=getIsLeapYear;proto.weekYear=getSetWeekYear;proto.isoWeekYear=getSetISOWeekYear;proto.quarter=proto.quarters=getSetQuarter;proto.month=getSetMonth;proto.daysInMonth=getDaysInMonth;proto.week=proto.weeks=getSetWeek;proto.isoWeek=proto.isoWeeks=getSetISOWeek;proto.weeksInYear=getWeeksInYear;proto.isoWeeksInYear=getISOWeeksInYear;proto.date=getSetDayOfMonth;proto.day=proto.days=getSetDayOfWeek;proto.weekday=getSetLocaleDayOfWeek;proto.isoWeekday=getSetISODayOfWeek;proto.dayOfYear=getSetDayOfYear;proto.hour=proto.hours=getSetHour;proto.minute=proto.minutes=getSetMinute;proto.second=proto.seconds=getSetSecond;proto.millisecond=proto.milliseconds=getSetMillisecond;proto.utcOffset=getSetOffset;proto.utc=setOffsetToUTC;proto.local=setOffsetToLocal;proto.parseZone=setOffsetToParsedOffset;proto.hasAlignedHourOffset=hasAlignedHourOffset;proto.isDST=isDaylightSavingTime;proto.isLocal=isLocal;proto.isUtcOffset=isUtcOffset;proto.isUtc=isUtc;proto.isUTC=isUtc;proto.zoneAbbr=getZoneAbbr;proto.zoneName=getZoneName;proto.dates=deprecate("dates accessor is deprecated. Use date instead.",getSetDayOfMonth);proto.months=deprecate("months accessor is deprecated. Use month instead",getSetMonth);proto.years=deprecate("years accessor is deprecated. Use year instead",getSetYear);proto.zone=deprecate("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",getSetZone);proto.isDSTShifted=deprecate("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",isDaylightSavingTimeShifted);function createUnix(input){return createLocal(input*1e3)}function createInZone(){return createLocal.apply(null,arguments).parseZone()}function preParsePostFormat(string){return string}var proto$1=Locale.prototype;proto$1.calendar=calendar;proto$1.longDateFormat=longDateFormat;proto$1.invalidDate=invalidDate;proto$1.ordinal=ordinal;proto$1.preparse=preParsePostFormat;proto$1.postformat=preParsePostFormat;proto$1.relativeTime=relativeTime;proto$1.pastFuture=pastFuture;proto$1.set=set;proto$1.months=localeMonths;proto$1.monthsShort=localeMonthsShort;proto$1.monthsParse=localeMonthsParse;proto$1.monthsRegex=monthsRegex;proto$1.monthsShortRegex=monthsShortRegex;proto$1.week=localeWeek;proto$1.firstDayOfYear=localeFirstDayOfYear;proto$1.firstDayOfWeek=localeFirstDayOfWeek;proto$1.weekdays=localeWeekdays;proto$1.weekdaysMin=localeWeekdaysMin;proto$1.weekdaysShort=localeWeekdaysShort;proto$1.weekdaysParse=localeWeekdaysParse;proto$1.weekdaysRegex=weekdaysRegex;proto$1.weekdaysShortRegex=weekdaysShortRegex;proto$1.weekdaysMinRegex=weekdaysMinRegex;proto$1.isPM=localeIsPM;proto$1.meridiem=localeMeridiem;function get$1(format,index,field,setter){var locale=getLocale();var utc=createUTC().set(setter,index);return locale[field](utc,format)}function listMonthsImpl(format,index,field){if(isNumber(format)){index=format;format=undefined}format=format||"";if(index!=null){return get$1(format,index,field,"month")}var i;var out=[];for(i=0;i<12;i++){out[i]=get$1(format,i,field,"month")}return out}function listWeekdaysImpl(localeSorted,format,index,field){if(typeof localeSorted==="boolean"){if(isNumber(format)){index=format;format=undefined}format=format||""}else{format=localeSorted;index=format;localeSorted=false;if(isNumber(format)){index=format;format=undefined}format=format||""}var locale=getLocale(),shift=localeSorted?locale._week.dow:0;if(index!=null){return get$1(format,(index+shift)%7,field,"day")}var i;var out=[];for(i=0;i<7;i++){out[i]=get$1(format,(i+shift)%7,field,"day")}return out}function listMonths(format,index){return listMonthsImpl(format,index,"months")}function listMonthsShort(format,index){return listMonthsImpl(format,index,"monthsShort")}function listWeekdays(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,"weekdays")}function listWeekdaysShort(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,"weekdaysShort")}function listWeekdaysMin(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,"weekdaysMin")}getSetGlobalLocale("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(number){var b=number%10,output=toInt(number%100/10)===1?"th":b===1?"st":b===2?"nd":b===3?"rd":"th";return number+output}});hooks.lang=deprecate("moment.lang is deprecated. Use moment.locale instead.",getSetGlobalLocale);hooks.langData=deprecate("moment.langData is deprecated. Use moment.localeData instead.",getLocale);var mathAbs=Math.abs;function abs(){var data=this._data;this._milliseconds=mathAbs(this._milliseconds);this._days=mathAbs(this._days);this._months=mathAbs(this._months);data.milliseconds=mathAbs(data.milliseconds);data.seconds=mathAbs(data.seconds);data.minutes=mathAbs(data.minutes);data.hours=mathAbs(data.hours);data.months=mathAbs(data.months);data.years=mathAbs(data.years);return this}function addSubtract$1(duration,input,value,direction){var other=createDuration(input,value);duration._milliseconds+=direction*other._milliseconds;duration._days+=direction*other._days;duration._months+=direction*other._months;return duration._bubble()}function add$1(input,value){return addSubtract$1(this,input,value,1)}function subtract$1(input,value){return addSubtract$1(this,input,value,-1)}function absCeil(number){if(number<0){return Math.floor(number)}else{return Math.ceil(number)}}function bubble(){var milliseconds=this._milliseconds;var days=this._days;var months=this._months;var data=this._data;var seconds,minutes,hours,years,monthsFromDays;if(!(milliseconds>=0&&days>=0&&months>=0||milliseconds<=0&&days<=0&&months<=0)){milliseconds+=absCeil(monthsToDays(months)+days)*864e5;days=0;months=0}data.milliseconds=milliseconds%1e3;seconds=absFloor(milliseconds/1e3);data.seconds=seconds%60;minutes=absFloor(seconds/60);data.minutes=minutes%60;hours=absFloor(minutes/60);data.hours=hours%24;days+=absFloor(hours/24);monthsFromDays=absFloor(daysToMonths(days));months+=monthsFromDays;days-=absCeil(monthsToDays(monthsFromDays));years=absFloor(months/12);months%=12;data.days=days;data.months=months;data.years=years;return this}function daysToMonths(days){return days*4800/146097}function monthsToDays(months){return months*146097/4800}function as(units){if(!this.isValid()){return NaN}var days;var months;var milliseconds=this._milliseconds;units=normalizeUnits(units);if(units==="month"||units==="year"){days=this._days+milliseconds/864e5;months=this._months+daysToMonths(days);return units==="month"?months:months/12}else{days=this._days+Math.round(monthsToDays(this._months));switch(units){case"week":return days/7+milliseconds/6048e5;case"day":return days+milliseconds/864e5;case"hour":return days*24+milliseconds/36e5;case"minute":return days*1440+milliseconds/6e4;case"second":return days*86400+milliseconds/1e3;case"millisecond":return Math.floor(days*864e5)+milliseconds;default:throw new Error("Unknown unit "+units)}}}function valueOf$1(){if(!this.isValid()){return NaN}return this._milliseconds+this._days*864e5+this._months%12*2592e6+toInt(this._months/12)*31536e6}function makeAs(alias){return function(){return this.as(alias)}}var asMilliseconds=makeAs("ms");var asSeconds=makeAs("s");var asMinutes=makeAs("m");var asHours=makeAs("h");var asDays=makeAs("d");var asWeeks=makeAs("w");var asMonths=makeAs("M");var asYears=makeAs("y");function get$2(units){units=normalizeUnits(units);return this.isValid()?this[units+"s"]():NaN}function makeGetter(name){return function(){return this.isValid()?this._data[name]:NaN}}var milliseconds=makeGetter("milliseconds");var seconds=makeGetter("seconds");var minutes=makeGetter("minutes");var hours=makeGetter("hours");var days=makeGetter("days");var months=makeGetter("months");var years=makeGetter("years");function weeks(){return absFloor(this.days()/7)}var round=Math.round;var thresholds={ss:44,s:45,m:45,h:22,d:26,M:11};function substituteTimeAgo(string,number,withoutSuffix,isFuture,locale){return locale.relativeTime(number||1,!!withoutSuffix,string,isFuture)}function relativeTime$1(posNegDuration,withoutSuffix,locale){var duration=createDuration(posNegDuration).abs();var seconds=round(duration.as("s"));var minutes=round(duration.as("m"));var hours=round(duration.as("h"));var days=round(duration.as("d"));var months=round(duration.as("M"));var years=round(duration.as("y"));var a=seconds<=thresholds.ss&&["s",seconds]||seconds<thresholds.s&&["ss",seconds]||minutes<=1&&["m"]||minutes<thresholds.m&&["mm",minutes]||hours<=1&&["h"]||hours<thresholds.h&&["hh",hours]||days<=1&&["d"]||days<thresholds.d&&["dd",days]||months<=1&&["M"]||months<thresholds.M&&["MM",months]||years<=1&&["y"]||["yy",years];a[2]=withoutSuffix;a[3]=+posNegDuration>0;a[4]=locale;return substituteTimeAgo.apply(null,a)}function getSetRelativeTimeRounding(roundingFunction){if(roundingFunction===undefined){return round}if(typeof roundingFunction==="function"){round=roundingFunction;return true}return false}function getSetRelativeTimeThreshold(threshold,limit){if(thresholds[threshold]===undefined){return false}if(limit===undefined){return thresholds[threshold]}thresholds[threshold]=limit;if(threshold==="s"){thresholds.ss=limit-1}return true}function humanize(withSuffix){if(!this.isValid()){return this.localeData().invalidDate()}var locale=this.localeData();var output=relativeTime$1(this,!withSuffix,locale);if(withSuffix){output=locale.pastFuture(+this,output)}return locale.postformat(output)}var abs$1=Math.abs;function toISOString$1(){if(!this.isValid()){return this.localeData().invalidDate()}var seconds=abs$1(this._milliseconds)/1e3;var days=abs$1(this._days);var months=abs$1(this._months);var minutes,hours,years;minutes=absFloor(seconds/60);hours=absFloor(minutes/60);seconds%=60;minutes%=60;years=absFloor(months/12);months%=12;var Y=years;var M=months;var D=days;var h=hours;var m=minutes;var s=seconds;var total=this.asSeconds();if(!total){return"P0D"}return(total<0?"-":"")+"P"+(Y?Y+"Y":"")+(M?M+"M":"")+(D?D+"D":"")+(h||m||s?"T":"")+(h?h+"H":"")+(m?m+"M":"")+(s?s+"S":"")}var proto$2=Duration.prototype;proto$2.isValid=isValid$1;proto$2.abs=abs;proto$2.add=add$1;proto$2.subtract=subtract$1;proto$2.as=as;proto$2.asMilliseconds=asMilliseconds;proto$2.asSeconds=asSeconds;proto$2.asMinutes=asMinutes;proto$2.asHours=asHours;proto$2.asDays=asDays;proto$2.asWeeks=asWeeks;proto$2.asMonths=asMonths;proto$2.asYears=asYears;proto$2.valueOf=valueOf$1;proto$2._bubble=bubble;proto$2.get=get$2;proto$2.milliseconds=milliseconds;proto$2.seconds=seconds;proto$2.minutes=minutes;proto$2.hours=hours;proto$2.days=days;proto$2.weeks=weeks;proto$2.months=months;proto$2.years=years;proto$2.humanize=humanize;proto$2.toISOString=toISOString$1;proto$2.toString=toISOString$1;proto$2.toJSON=toISOString$1;proto$2.locale=locale;proto$2.localeData=localeData;proto$2.toIsoString=deprecate("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",toISOString$1);
proto$2.lang=lang;addFormatToken("X",0,0,"unix");addFormatToken("x",0,0,"valueOf");addRegexToken("x",matchSigned);addRegexToken("X",matchTimestamp);addParseToken("X",function(input,array,config){config._d=new Date(parseFloat(input,10)*1e3)});addParseToken("x",function(input,array,config){config._d=new Date(toInt(input))});hooks.version="2.18.1";setHookCallback(createLocal);hooks.fn=proto;hooks.min=min;hooks.max=max;hooks.now=now;hooks.utc=createUTC;hooks.unix=createUnix;hooks.months=listMonths;hooks.isDate=isDate;hooks.locale=getSetGlobalLocale;hooks.invalid=createInvalid;hooks.duration=createDuration;hooks.isMoment=isMoment;hooks.weekdays=listWeekdays;hooks.parseZone=createInZone;hooks.localeData=getLocale;hooks.isDuration=isDuration;hooks.monthsShort=listMonthsShort;hooks.weekdaysMin=listWeekdaysMin;hooks.defineLocale=defineLocale;hooks.updateLocale=updateLocale;hooks.locales=listLocales;hooks.weekdaysShort=listWeekdaysShort;hooks.normalizeUnits=normalizeUnits;hooks.relativeTimeRounding=getSetRelativeTimeRounding;hooks.relativeTimeThreshold=getSetRelativeTimeThreshold;hooks.calendarFormat=getCalendarFormat;hooks.prototype=proto;return hooks});(function(factory){"use strict";if(typeof define==="function"&&define.amd){define(["jquery","moment"],factory)}else if(typeof exports==="object"){module.exports=factory(require("jquery"),require("moment"))}else{if(typeof jQuery==="undefined"){throw"bootstrap-datetimepicker requires jQuery to be loaded first"}if(typeof moment==="undefined"){throw"bootstrap-datetimepicker requires Moment.js to be loaded first"}factory(jQuery,moment)}})(function($,moment){"use strict";if(!moment){throw new Error("bootstrap-datetimepicker requires Moment.js to be loaded first")}var dateTimePicker=function(element,options){var picker={},date,viewDate,unset=true,input,component=false,widget=false,use24Hours,minViewModeNumber=0,actualFormat,parseFormats,currentViewMode,datePickerModes=[{clsName:"days",navFnc:"M",navStep:1},{clsName:"months",navFnc:"y",navStep:1},{clsName:"years",navFnc:"y",navStep:10},{clsName:"decades",navFnc:"y",navStep:100}],viewModes=["days","months","years","decades"],verticalModes=["top","bottom","auto"],horizontalModes=["left","right","auto"],toolbarPlacements=["default","top","bottom"],keyMap={up:38,38:"up",down:40,40:"down",left:37,37:"left",right:39,39:"right",tab:9,9:"tab",escape:27,27:"escape",enter:13,13:"enter",pageUp:33,33:"pageUp",pageDown:34,34:"pageDown",shift:16,16:"shift",control:17,17:"control",space:32,32:"space",t:84,84:"t","delete":46,46:"delete"},keyState={},hasTimeZone=function(){return moment.tz!==undefined&&options.timeZone!==undefined&&options.timeZone!==null&&options.timeZone!==""},getMoment=function(d){var returnMoment;if(d===undefined||d===null){returnMoment=moment()}else if(moment.isDate(d)||moment.isMoment(d)){returnMoment=moment(d)}else if(hasTimeZone()){returnMoment=moment.tz(d,parseFormats,options.useStrict,options.timeZone)}else{returnMoment=moment(d,parseFormats,options.useStrict)}if(hasTimeZone()){returnMoment.tz(options.timeZone)}return returnMoment},isEnabled=function(granularity){if(typeof granularity!=="string"||granularity.length>1){throw new TypeError("isEnabled expects a single character string parameter")}switch(granularity){case"y":return actualFormat.indexOf("Y")!==-1;case"M":return actualFormat.indexOf("M")!==-1;case"d":return actualFormat.toLowerCase().indexOf("d")!==-1;case"h":case"H":return actualFormat.toLowerCase().indexOf("h")!==-1;case"m":return actualFormat.indexOf("m")!==-1;case"s":return actualFormat.indexOf("s")!==-1;default:return false}},hasTime=function(){return isEnabled("h")||isEnabled("m")||isEnabled("s")},hasDate=function(){return isEnabled("y")||isEnabled("M")||isEnabled("d")},getDatePickerTemplate=function(){var headTemplate=$("<thead>").append($("<tr>").append($("<th>").addClass("prev").attr("data-action","previous").append($("<span>").addClass(options.icons.previous))).append($("<th>").addClass("picker-switch").attr("data-action","pickerSwitch").attr("colspan",options.calendarWeeks?"6":"5")).append($("<th>").addClass("next").attr("data-action","next").append($("<span>").addClass(options.icons.next)))),contTemplate=$("<tbody>").append($("<tr>").append($("<td>").attr("colspan",options.calendarWeeks?"8":"7")));return[$("<div>").addClass("datepicker-days").append($("<table>").addClass("table-condensed").append(headTemplate).append($("<tbody>"))),$("<div>").addClass("datepicker-months").append($("<table>").addClass("table-condensed").append(headTemplate.clone()).append(contTemplate.clone())),$("<div>").addClass("datepicker-years").append($("<table>").addClass("table-condensed").append(headTemplate.clone()).append(contTemplate.clone())),$("<div>").addClass("datepicker-decades").append($("<table>").addClass("table-condensed").append(headTemplate.clone()).append(contTemplate.clone()))]},getTimePickerMainTemplate=function(){var topRow=$("<tr>"),middleRow=$("<tr>"),bottomRow=$("<tr>");if(isEnabled("h")){topRow.append($("<td>").append($("<a>").attr({href:"#",tabindex:"-1",title:options.tooltips.incrementHour}).addClass("btn").attr("data-action","incrementHours").append($("<span>").addClass(options.icons.up))));middleRow.append($("<td>").append($("<span>").addClass("timepicker-hour").attr({"data-time-component":"hours",title:options.tooltips.pickHour}).attr("data-action","showHours")));bottomRow.append($("<td>").append($("<a>").attr({href:"#",tabindex:"-1",title:options.tooltips.decrementHour}).addClass("btn").attr("data-action","decrementHours").append($("<span>").addClass(options.icons.down))))}if(isEnabled("m")){if(isEnabled("h")){topRow.append($("<td>").addClass("separator"));middleRow.append($("<td>").addClass("separator").html(":"));bottomRow.append($("<td>").addClass("separator"))}topRow.append($("<td>").append($("<a>").attr({href:"#",tabindex:"-1",title:options.tooltips.incrementMinute}).addClass("btn").attr("data-action","incrementMinutes").append($("<span>").addClass(options.icons.up))));middleRow.append($("<td>").append($("<span>").addClass("timepicker-minute").attr({"data-time-component":"minutes",title:options.tooltips.pickMinute}).attr("data-action","showMinutes")));bottomRow.append($("<td>").append($("<a>").attr({href:"#",tabindex:"-1",title:options.tooltips.decrementMinute}).addClass("btn").attr("data-action","decrementMinutes").append($("<span>").addClass(options.icons.down))))}if(isEnabled("s")){if(isEnabled("m")){topRow.append($("<td>").addClass("separator"));middleRow.append($("<td>").addClass("separator").html(":"));bottomRow.append($("<td>").addClass("separator"))}topRow.append($("<td>").append($("<a>").attr({href:"#",tabindex:"-1",title:options.tooltips.incrementSecond}).addClass("btn").attr("data-action","incrementSeconds").append($("<span>").addClass(options.icons.up))));middleRow.append($("<td>").append($("<span>").addClass("timepicker-second").attr({"data-time-component":"seconds",title:options.tooltips.pickSecond}).attr("data-action","showSeconds")));bottomRow.append($("<td>").append($("<a>").attr({href:"#",tabindex:"-1",title:options.tooltips.decrementSecond}).addClass("btn").attr("data-action","decrementSeconds").append($("<span>").addClass(options.icons.down))))}if(!use24Hours){topRow.append($("<td>").addClass("separator"));middleRow.append($("<td>").append($("<button>").addClass("btn btn-primary").attr({"data-action":"togglePeriod",tabindex:"-1",title:options.tooltips.togglePeriod})));bottomRow.append($("<td>").addClass("separator"))}return $("<div>").addClass("timepicker-picker").append($("<table>").addClass("table-condensed").append([topRow,middleRow,bottomRow]))},getTimePickerTemplate=function(){var hoursView=$("<div>").addClass("timepicker-hours").append($("<table>").addClass("table-condensed")),minutesView=$("<div>").addClass("timepicker-minutes").append($("<table>").addClass("table-condensed")),secondsView=$("<div>").addClass("timepicker-seconds").append($("<table>").addClass("table-condensed")),ret=[getTimePickerMainTemplate()];if(isEnabled("h")){ret.push(hoursView)}if(isEnabled("m")){ret.push(minutesView)}if(isEnabled("s")){ret.push(secondsView)}return ret},getToolbar=function(){var row=[];if(options.showTodayButton){row.push($("<td>").append($("<a>").attr({"data-action":"today",title:options.tooltips.today}).append($("<span>").addClass(options.icons.today))))}if(!options.sideBySide&&hasDate()&&hasTime()){row.push($("<td>").append($("<a>").attr({"data-action":"togglePicker",title:options.tooltips.selectTime}).append($("<span>").addClass(options.icons.time))))}if(options.showClear){row.push($("<td>").append($("<a>").attr({"data-action":"clear",title:options.tooltips.clear}).append($("<span>").addClass(options.icons.clear))))}if(options.showClose){row.push($("<td>").append($("<a>").attr({"data-action":"close",title:options.tooltips.close}).append($("<span>").addClass(options.icons.close))))}return $("<table>").addClass("table-condensed").append($("<tbody>").append($("<tr>").append(row)))},getTemplate=function(){var template=$("<div>").addClass("bootstrap-datetimepicker-widget dropdown-menu"),dateView=$("<div>").addClass("datepicker").append(getDatePickerTemplate()),timeView=$("<div>").addClass("timepicker").append(getTimePickerTemplate()),content=$("<ul>").addClass("list-unstyled"),toolbar=$("<li>").addClass("picker-switch"+(options.collapse?" accordion-toggle":"")).append(getToolbar());if(options.inline){template.removeClass("dropdown-menu")}if(use24Hours){template.addClass("usetwentyfour")}if(isEnabled("s")&&!use24Hours){template.addClass("wider")}if(options.sideBySide&&hasDate()&&hasTime()){template.addClass("timepicker-sbs");if(options.toolbarPlacement==="top"){template.append(toolbar)}template.append($("<div>").addClass("row").append(dateView.addClass("col-md-6")).append(timeView.addClass("col-md-6")));if(options.toolbarPlacement==="bottom"){template.append(toolbar)}return template}if(options.toolbarPlacement==="top"){content.append(toolbar)}if(hasDate()){content.append($("<li>").addClass(options.collapse&&hasTime()?"collapse in":"").append(dateView))}if(options.toolbarPlacement==="default"){content.append(toolbar)}if(hasTime()){content.append($("<li>").addClass(options.collapse&&hasDate()?"collapse":"").append(timeView))}if(options.toolbarPlacement==="bottom"){content.append(toolbar)}return template.append(content)},dataToOptions=function(){var eData,dataOptions={};if(element.is("input")||options.inline){eData=element.data()}else{eData=element.find("input").data()}if(eData.dateOptions&&eData.dateOptions instanceof Object){dataOptions=$.extend(true,dataOptions,eData.dateOptions)}$.each(options,function(key){var attributeName="date"+key.charAt(0).toUpperCase()+key.slice(1);if(eData[attributeName]!==undefined){dataOptions[key]=eData[attributeName]}});return dataOptions},place=function(){var position=(component||element).position(),offset=(component||element).offset(),vertical=options.widgetPositioning.vertical,horizontal=options.widgetPositioning.horizontal,parent;if(options.widgetParent){parent=options.widgetParent.append(widget)}else if(element.is("input")){parent=element.after(widget).parent()}else if(options.inline){parent=element.append(widget);return}else{parent=element;element.children().first().after(widget)}if(vertical==="auto"){if(offset.top+widget.height()*1.5>=$(window).height()+$(window).scrollTop()&&widget.height()+element.outerHeight()<offset.top){vertical="top"}else{vertical="bottom"}}if(horizontal==="auto"){if(parent.width()<offset.left+widget.outerWidth()/2&&offset.left+widget.outerWidth()>$(window).width()){horizontal="right"}else{horizontal="left"}}if(vertical==="top"){widget.addClass("top").removeClass("bottom")}else{widget.addClass("bottom").removeClass("top")}if(horizontal==="right"){widget.addClass("pull-right")}else{widget.removeClass("pull-right")}if(parent.css("position")==="static"){parent=parent.parents().filter(function(){return $(this).css("position")!=="static"}).first()}if(parent.length===0){throw new Error("datetimepicker component should be placed within a non-static positioned container")}widget.css({top:vertical==="top"?"auto":position.top+element.outerHeight(),bottom:vertical==="top"?parent.outerHeight()-(parent===element?0:position.top):"auto",left:horizontal==="left"?parent===element?0:position.left:"auto",right:horizontal==="left"?"auto":parent.outerWidth()-element.outerWidth()-(parent===element?0:position.left)})},notifyEvent=function(e){if(e.type==="dp.change"&&(e.date&&e.date.isSame(e.oldDate)||!e.date&&!e.oldDate)){return}element.trigger(e)},viewUpdate=function(e){if(e==="y"){e="YYYY"}notifyEvent({type:"dp.update",change:e,viewDate:viewDate.clone()})},showMode=function(dir){if(!widget){return}if(dir){currentViewMode=Math.max(minViewModeNumber,Math.min(3,currentViewMode+dir))}widget.find(".datepicker > div").hide().filter(".datepicker-"+datePickerModes[currentViewMode].clsName).show()},fillDow=function(){var row=$("<tr>"),currentDate=viewDate.clone().startOf("w").startOf("d");if(options.calendarWeeks===true){row.append($("<th>").addClass("cw").text("#"))}while(currentDate.isBefore(viewDate.clone().endOf("w"))){row.append($("<th>").addClass("dow").text(currentDate.format("dd")));currentDate.add(1,"d")}widget.find(".datepicker-days thead").append(row)},isInDisabledDates=function(testDate){return options.disabledDates[testDate.format("YYYY-MM-DD")]===true},isInEnabledDates=function(testDate){return options.enabledDates[testDate.format("YYYY-MM-DD")]===true},isInDisabledHours=function(testDate){return options.disabledHours[testDate.format("H")]===true},isInEnabledHours=function(testDate){return options.enabledHours[testDate.format("H")]===true},isValid=function(targetMoment,granularity){if(!targetMoment.isValid()){return false}if(options.disabledDates&&granularity==="d"&&isInDisabledDates(targetMoment)){return false}if(options.enabledDates&&granularity==="d"&&!isInEnabledDates(targetMoment)){return false}if(options.minDate&&targetMoment.isBefore(options.minDate,granularity)){return false}if(options.maxDate&&targetMoment.isAfter(options.maxDate,granularity)){return false}if(options.daysOfWeekDisabled&&granularity==="d"&&options.daysOfWeekDisabled.indexOf(targetMoment.day())!==-1){return false}if(options.disabledHours&&(granularity==="h"||granularity==="m"||granularity==="s")&&isInDisabledHours(targetMoment)){return false}if(options.enabledHours&&(granularity==="h"||granularity==="m"||granularity==="s")&&!isInEnabledHours(targetMoment)){return false}if(options.disabledTimeIntervals&&(granularity==="h"||granularity==="m"||granularity==="s")){var found=false;$.each(options.disabledTimeIntervals,function(){if(targetMoment.isBetween(this[0],this[1])){found=true;return false}});if(found){return false}}return true},fillMonths=function(){var spans=[],monthsShort=viewDate.clone().startOf("y").startOf("d");while(monthsShort.isSame(viewDate,"y")){spans.push($("<span>").attr("data-action","selectMonth").addClass("month").text(monthsShort.format("MMM")));monthsShort.add(1,"M")}widget.find(".datepicker-months td").empty().append(spans)},updateMonths=function(){var monthsView=widget.find(".datepicker-months"),monthsViewHeader=monthsView.find("th"),months=monthsView.find("tbody").find("span");monthsViewHeader.eq(0).find("span").attr("title",options.tooltips.prevYear);monthsViewHeader.eq(1).attr("title",options.tooltips.selectYear);monthsViewHeader.eq(2).find("span").attr("title",options.tooltips.nextYear);monthsView.find(".disabled").removeClass("disabled");if(!isValid(viewDate.clone().subtract(1,"y"),"y")){monthsViewHeader.eq(0).addClass("disabled")}monthsViewHeader.eq(1).text(viewDate.year());if(!isValid(viewDate.clone().add(1,"y"),"y")){monthsViewHeader.eq(2).addClass("disabled")}months.removeClass("active");if(date.isSame(viewDate,"y")&&!unset){months.eq(date.month()).addClass("active")}months.each(function(index){if(!isValid(viewDate.clone().month(index),"M")){$(this).addClass("disabled")}})},updateYears=function(){var yearsView=widget.find(".datepicker-years"),yearsViewHeader=yearsView.find("th"),startYear=viewDate.clone().subtract(5,"y"),endYear=viewDate.clone().add(6,"y"),html="";yearsViewHeader.eq(0).find("span").attr("title",options.tooltips.prevDecade);yearsViewHeader.eq(1).attr("title",options.tooltips.selectDecade);yearsViewHeader.eq(2).find("span").attr("title",options.tooltips.nextDecade);yearsView.find(".disabled").removeClass("disabled");if(options.minDate&&options.minDate.isAfter(startYear,"y")){yearsViewHeader.eq(0).addClass("disabled")}yearsViewHeader.eq(1).text(startYear.year()+"-"+endYear.year());if(options.maxDate&&options.maxDate.isBefore(endYear,"y")){yearsViewHeader.eq(2).addClass("disabled")}while(!startYear.isAfter(endYear,"y")){html+='<span data-action="selectYear" class="year'+(startYear.isSame(date,"y")&&!unset?" active":"")+(!isValid(startYear,"y")?" disabled":"")+'">'+startYear.year()+"</span>";startYear.add(1,"y")}yearsView.find("td").html(html)},updateDecades=function(){var decadesView=widget.find(".datepicker-decades"),decadesViewHeader=decadesView.find("th"),startDecade=moment({y:viewDate.year()-viewDate.year()%100-1}),endDecade=startDecade.clone().add(100,"y"),startedAt=startDecade.clone(),minDateDecade=false,maxDateDecade=false,endDecadeYear,html="";decadesViewHeader.eq(0).find("span").attr("title",options.tooltips.prevCentury);decadesViewHeader.eq(2).find("span").attr("title",options.tooltips.nextCentury);decadesView.find(".disabled").removeClass("disabled");if(startDecade.isSame(moment({y:1900}))||options.minDate&&options.minDate.isAfter(startDecade,"y")){decadesViewHeader.eq(0).addClass("disabled")}decadesViewHeader.eq(1).text(startDecade.year()+"-"+endDecade.year());if(startDecade.isSame(moment({y:2e3}))||options.maxDate&&options.maxDate.isBefore(endDecade,"y")){decadesViewHeader.eq(2).addClass("disabled")}while(!startDecade.isAfter(endDecade,"y")){endDecadeYear=startDecade.year()+12;minDateDecade=options.minDate&&options.minDate.isAfter(startDecade,"y")&&options.minDate.year()<=endDecadeYear;maxDateDecade=options.maxDate&&options.maxDate.isAfter(startDecade,"y")&&options.maxDate.year()<=endDecadeYear;html+='<span data-action="selectDecade" class="decade'+(date.isAfter(startDecade)&&date.year()<=endDecadeYear?" active":"")+(!isValid(startDecade,"y")&&!minDateDecade&&!maxDateDecade?" disabled":"")+'" data-selection="'+(startDecade.year()+6)+'">'+(startDecade.year()+1)+" - "+(startDecade.year()+12)+"</span>";startDecade.add(12,"y")}html+="<span></span><span></span><span></span>";decadesView.find("td").html(html);decadesViewHeader.eq(1).text(startedAt.year()+1+"-"+startDecade.year())},fillDate=function(){var daysView=widget.find(".datepicker-days"),daysViewHeader=daysView.find("th"),currentDate,html=[],row,clsNames=[],i;if(!hasDate()){return}daysViewHeader.eq(0).find("span").attr("title",options.tooltips.prevMonth);daysViewHeader.eq(1).attr("title",options.tooltips.selectMonth);daysViewHeader.eq(2).find("span").attr("title",options.tooltips.nextMonth);daysView.find(".disabled").removeClass("disabled");daysViewHeader.eq(1).text(viewDate.format(options.dayViewHeaderFormat));if(!isValid(viewDate.clone().subtract(1,"M"),"M")){daysViewHeader.eq(0).addClass("disabled")}if(!isValid(viewDate.clone().add(1,"M"),"M")){daysViewHeader.eq(2).addClass("disabled")}currentDate=viewDate.clone().startOf("M").startOf("w").startOf("d");for(i=0;i<42;i++){if(currentDate.weekday()===0){row=$("<tr>");if(options.calendarWeeks){row.append('<td class="cw">'+currentDate.week()+"</td>")}html.push(row)}clsNames=["day"];if(currentDate.isBefore(viewDate,"M")){clsNames.push("old")}if(currentDate.isAfter(viewDate,"M")){clsNames.push("new")}if(currentDate.isSame(date,"d")&&!unset){clsNames.push("active")}if(!isValid(currentDate,"d")){clsNames.push("disabled")}if(currentDate.isSame(getMoment(),"d")){clsNames.push("today")}if(currentDate.day()===0||currentDate.day()===6){clsNames.push("weekend")}notifyEvent({type:"dp.classify",date:currentDate,classNames:clsNames});row.append('<td data-action="selectDay" data-day="'+currentDate.format("L")+'" class="'+clsNames.join(" ")+'">'+currentDate.date()+"</td>");currentDate.add(1,"d")}daysView.find("tbody").empty().append(html);updateMonths();updateYears();updateDecades()},fillHours=function(){var table=widget.find(".timepicker-hours table"),currentHour=viewDate.clone().startOf("d"),html=[],row=$("<tr>");if(viewDate.hour()>11&&!use24Hours){currentHour.hour(12)}while(currentHour.isSame(viewDate,"d")&&(use24Hours||viewDate.hour()<12&&currentHour.hour()<12||viewDate.hour()>11)){if(currentHour.hour()%4===0){row=$("<tr>");html.push(row)}row.append('<td data-action="selectHour" class="hour'+(!isValid(currentHour,"h")?" disabled":"")+'">'+currentHour.format(use24Hours?"HH":"hh")+"</td>");currentHour.add(1,"h")}table.empty().append(html)},fillMinutes=function(){var table=widget.find(".timepicker-minutes table"),currentMinute=viewDate.clone().startOf("h"),html=[],row=$("<tr>"),step=options.stepping===1?5:options.stepping;while(viewDate.isSame(currentMinute,"h")){if(currentMinute.minute()%(step*4)===0){row=$("<tr>");html.push(row)}row.append('<td data-action="selectMinute" class="minute'+(!isValid(currentMinute,"m")?" disabled":"")+'">'+currentMinute.format("mm")+"</td>");currentMinute.add(step,"m")}table.empty().append(html)},fillSeconds=function(){var table=widget.find(".timepicker-seconds table"),currentSecond=viewDate.clone().startOf("m"),html=[],row=$("<tr>");while(viewDate.isSame(currentSecond,"m")){if(currentSecond.second()%20===0){row=$("<tr>");html.push(row)}row.append('<td data-action="selectSecond" class="second'+(!isValid(currentSecond,"s")?" disabled":"")+'">'+currentSecond.format("ss")+"</td>");currentSecond.add(5,"s")}table.empty().append(html)},fillTime=function(){var toggle,newDate,timeComponents=widget.find(".timepicker span[data-time-component]");if(!use24Hours){toggle=widget.find(".timepicker [data-action=togglePeriod]");newDate=date.clone().add(date.hours()>=12?-12:12,"h");toggle.text(date.format("A"));if(isValid(newDate,"h")){toggle.removeClass("disabled")}else{toggle.addClass("disabled")}}timeComponents.filter("[data-time-component=hours]").text(date.format(use24Hours?"HH":"hh"));timeComponents.filter("[data-time-component=minutes]").text(date.format("mm"));timeComponents.filter("[data-time-component=seconds]").text(date.format("ss"));fillHours();fillMinutes();fillSeconds()},update=function(){if(!widget){return}fillDate();fillTime()},setValue=function(targetMoment){var oldDate=unset?null:date;if(!targetMoment){unset=true;input.val("");element.data("date","");notifyEvent({type:"dp.change",date:false,oldDate:oldDate});update();return}targetMoment=targetMoment.clone().locale(options.locale);if(hasTimeZone()){targetMoment.tz(options.timeZone)}if(options.stepping!==1){targetMoment.minutes(Math.round(targetMoment.minutes()/options.stepping)*options.stepping).seconds(0);while(options.minDate&&targetMoment.isBefore(options.minDate)){targetMoment.add(options.stepping,"minutes")}}if(isValid(targetMoment)){date=targetMoment;viewDate=date.clone();input.val(date.format(actualFormat));element.data("date",date.format(actualFormat));unset=false;update();notifyEvent({type:"dp.change",date:date.clone(),oldDate:oldDate})}else{if(!options.keepInvalid){input.val(unset?"":date.format(actualFormat))}else{notifyEvent({type:"dp.change",date:targetMoment,oldDate:oldDate})}notifyEvent({type:"dp.error",date:targetMoment,oldDate:oldDate})}},hide=function(){var transitioning=false;if(!widget){return picker}widget.find(".collapse").each(function(){var collapseData=$(this).data("collapse");if(collapseData&&collapseData.transitioning){transitioning=true;return false}return true});if(transitioning){return picker}if(component&&component.hasClass("btn")){component.toggleClass("active")}widget.hide();$(window).off("resize",place);widget.off("click","[data-action]");widget.off("mousedown",false);widget.remove();widget=false;notifyEvent({type:"dp.hide",date:date.clone()});input.blur();viewDate=date.clone();return picker},clear=function(){setValue(null)},parseInputDate=function(inputDate){if(options.parseInputDate===undefined){if(!moment.isMoment(inputDate)||inputDate instanceof Date){inputDate=getMoment(inputDate)}}else{inputDate=options.parseInputDate(inputDate)}return inputDate},actions={next:function(){var navFnc=datePickerModes[currentViewMode].navFnc;viewDate.add(datePickerModes[currentViewMode].navStep,navFnc);fillDate();viewUpdate(navFnc)},previous:function(){var navFnc=datePickerModes[currentViewMode].navFnc;viewDate.subtract(datePickerModes[currentViewMode].navStep,navFnc);fillDate();viewUpdate(navFnc)},pickerSwitch:function(){showMode(1)},selectMonth:function(e){var month=$(e.target).closest("tbody").find("span").index($(e.target));viewDate.month(month);if(currentViewMode===minViewModeNumber){setValue(date.clone().year(viewDate.year()).month(viewDate.month()));if(!options.inline){hide()}}else{showMode(-1);fillDate()}viewUpdate("M")},selectYear:function(e){var year=parseInt($(e.target).text(),10)||0;viewDate.year(year);if(currentViewMode===minViewModeNumber){setValue(date.clone().year(viewDate.year()));if(!options.inline){hide()}}else{showMode(-1);fillDate()}viewUpdate("YYYY")},selectDecade:function(e){var year=parseInt($(e.target).data("selection"),10)||0;viewDate.year(year);if(currentViewMode===minViewModeNumber){setValue(date.clone().year(viewDate.year()));if(!options.inline){hide()}}else{showMode(-1);fillDate()}viewUpdate("YYYY")},selectDay:function(e){var day=viewDate.clone();if($(e.target).is(".old")){day.subtract(1,"M")}if($(e.target).is(".new")){day.add(1,"M")}setValue(day.date(parseInt($(e.target).text(),10)));if(!hasTime()&&!options.keepOpen&&!options.inline){hide()}},incrementHours:function(){var newDate=date.clone().add(1,"h");if(isValid(newDate,"h")){setValue(newDate)}},incrementMinutes:function(){var newDate=date.clone().add(options.stepping,"m");if(isValid(newDate,"m")){setValue(newDate)}},incrementSeconds:function(){var newDate=date.clone().add(1,"s");if(isValid(newDate,"s")){setValue(newDate)}},decrementHours:function(){var newDate=date.clone().subtract(1,"h");if(isValid(newDate,"h")){setValue(newDate)}},decrementMinutes:function(){var newDate=date.clone().subtract(options.stepping,"m");if(isValid(newDate,"m")){setValue(newDate)}},decrementSeconds:function(){var newDate=date.clone().subtract(1,"s");if(isValid(newDate,"s")){setValue(newDate)}},togglePeriod:function(){setValue(date.clone().add(date.hours()>=12?-12:12,"h"))},togglePicker:function(e){var $this=$(e.target),$parent=$this.closest("ul"),expanded=$parent.find(".in"),closed=$parent.find(".collapse:not(.in)"),collapseData;if(expanded&&expanded.length){collapseData=expanded.data("collapse");if(collapseData&&collapseData.transitioning){return}if(expanded.collapse){expanded.collapse("hide");closed.collapse("show")}else{expanded.removeClass("in");closed.addClass("in")}if($this.is("span")){$this.toggleClass(options.icons.time+" "+options.icons.date)}else{$this.find("span").toggleClass(options.icons.time+" "+options.icons.date)}}},showPicker:function(){widget.find(".timepicker > div:not(.timepicker-picker)").hide();widget.find(".timepicker .timepicker-picker").show()},showHours:function(){widget.find(".timepicker .timepicker-picker").hide();widget.find(".timepicker .timepicker-hours").show()},showMinutes:function(){widget.find(".timepicker .timepicker-picker").hide();widget.find(".timepicker .timepicker-minutes").show()},showSeconds:function(){widget.find(".timepicker .timepicker-picker").hide();widget.find(".timepicker .timepicker-seconds").show()},selectHour:function(e){var hour=parseInt($(e.target).text(),10);if(!use24Hours){if(date.hours()>=12){if(hour!==12){hour+=12}}else{if(hour===12){hour=0}}}setValue(date.clone().hours(hour));actions.showPicker.call(picker)},selectMinute:function(e){setValue(date.clone().minutes(parseInt($(e.target).text(),10)));actions.showPicker.call(picker)},selectSecond:function(e){setValue(date.clone().seconds(parseInt($(e.target).text(),10)));actions.showPicker.call(picker)},clear:clear,today:function(){var todaysDate=getMoment();if(isValid(todaysDate,"d")){setValue(todaysDate)}},close:hide},doAction=function(e){if($(e.currentTarget).is(".disabled")){return false}actions[$(e.currentTarget).data("action")].apply(picker,arguments);return false},show=function(){var currentMoment,useCurrentGranularity={year:function(m){return m.month(0).date(1).hours(0).seconds(0).minutes(0)},month:function(m){return m.date(1).hours(0).seconds(0).minutes(0)},day:function(m){return m.hours(0).seconds(0).minutes(0)},hour:function(m){return m.seconds(0).minutes(0)},minute:function(m){return m.seconds(0)}};if(input.prop("disabled")||!options.ignoreReadonly&&input.prop("readonly")||widget){return picker}if(input.val()!==undefined&&input.val().trim().length!==0){setValue(parseInputDate(input.val().trim()))}else if(unset&&options.useCurrent&&(options.inline||input.is("input")&&input.val().trim().length===0)){currentMoment=getMoment();if(typeof options.useCurrent==="string"){currentMoment=useCurrentGranularity[options.useCurrent](currentMoment)}setValue(currentMoment)}widget=getTemplate();fillDow();fillMonths();widget.find(".timepicker-hours").hide();widget.find(".timepicker-minutes").hide();widget.find(".timepicker-seconds").hide();update();showMode();$(window).on("resize",place);widget.on("click","[data-action]",doAction);widget.on("mousedown",false);if(component&&component.hasClass("btn")){component.toggleClass("active")}place();widget.show();if(options.focusOnShow&&!input.is(":focus")){input.focus()}notifyEvent({type:"dp.show"});return picker},toggle=function(){return widget?hide():show()},keydown=function(e){var handler=null,index,index2,pressedKeys=[],pressedModifiers={},currentKey=e.which,keyBindKeys,allModifiersPressed,pressed="p";keyState[currentKey]=pressed;for(index in keyState){if(keyState.hasOwnProperty(index)&&keyState[index]===pressed){pressedKeys.push(index);if(parseInt(index,10)!==currentKey){pressedModifiers[index]=true}}}for(index in options.keyBinds){if(options.keyBinds.hasOwnProperty(index)&&typeof options.keyBinds[index]==="function"){keyBindKeys=index.split(" ");if(keyBindKeys.length===pressedKeys.length&&keyMap[currentKey]===keyBindKeys[keyBindKeys.length-1]){allModifiersPressed=true;for(index2=keyBindKeys.length-2;index2>=0;index2--){if(!(keyMap[keyBindKeys[index2]]in pressedModifiers)){allModifiersPressed=false;break}}if(allModifiersPressed){handler=options.keyBinds[index];break}}}}if(handler){handler.call(picker,widget);e.stopPropagation();e.preventDefault()}},keyup=function(e){keyState[e.which]="r";e.stopPropagation();e.preventDefault()},change=function(e){var val=$(e.target).val().trim(),parsedDate=val?parseInputDate(val):null;setValue(parsedDate);e.stopImmediatePropagation();return false},attachDatePickerElementEvents=function(){input.on({change:change,blur:options.debug?"":hide,keydown:keydown,keyup:keyup,focus:options.allowInputToggle?show:""});if(element.is("input")){input.on({focus:show})}else if(component){component.on("click",toggle);component.on("mousedown",false)}},detachDatePickerElementEvents=function(){input.off({change:change,blur:blur,keydown:keydown,keyup:keyup,focus:options.allowInputToggle?hide:""});if(element.is("input")){input.off({focus:show})}else if(component){component.off("click",toggle);component.off("mousedown",false)}},indexGivenDates=function(givenDatesArray){var givenDatesIndexed={};$.each(givenDatesArray,function(){var dDate=parseInputDate(this);if(dDate.isValid()){givenDatesIndexed[dDate.format("YYYY-MM-DD")]=true}});return Object.keys(givenDatesIndexed).length?givenDatesIndexed:false},indexGivenHours=function(givenHoursArray){var givenHoursIndexed={};$.each(givenHoursArray,function(){givenHoursIndexed[this]=true});return Object.keys(givenHoursIndexed).length?givenHoursIndexed:false},initFormatting=function(){var format=options.format||"L LT";actualFormat=format.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,function(formatInput){var newinput=date.localeData().longDateFormat(formatInput)||formatInput;
return newinput.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,function(formatInput2){return date.localeData().longDateFormat(formatInput2)||formatInput2})});parseFormats=options.extraFormats?options.extraFormats.slice():[];if(parseFormats.indexOf(format)<0&&parseFormats.indexOf(actualFormat)<0){parseFormats.push(actualFormat)}use24Hours=actualFormat.toLowerCase().indexOf("a")<1&&actualFormat.replace(/\[.*?\]/g,"").indexOf("h")<1;if(isEnabled("y")){minViewModeNumber=2}if(isEnabled("M")){minViewModeNumber=1}if(isEnabled("d")){minViewModeNumber=0}currentViewMode=Math.max(minViewModeNumber,currentViewMode);if(!unset){setValue(date)}};picker.destroy=function(){hide();detachDatePickerElementEvents();element.removeData("DateTimePicker");element.removeData("date")};picker.toggle=toggle;picker.show=show;picker.hide=hide;picker.disable=function(){hide();if(component&&component.hasClass("btn")){component.addClass("disabled")}input.prop("disabled",true);return picker};picker.enable=function(){if(component&&component.hasClass("btn")){component.removeClass("disabled")}input.prop("disabled",false);return picker};picker.ignoreReadonly=function(ignoreReadonly){if(arguments.length===0){return options.ignoreReadonly}if(typeof ignoreReadonly!=="boolean"){throw new TypeError("ignoreReadonly () expects a boolean parameter")}options.ignoreReadonly=ignoreReadonly;return picker};picker.options=function(newOptions){if(arguments.length===0){return $.extend(true,{},options)}if(!(newOptions instanceof Object)){throw new TypeError("options() options parameter should be an object")}$.extend(true,options,newOptions);$.each(options,function(key,value){if(picker[key]!==undefined){picker[key](value)}else{throw new TypeError("option "+key+" is not recognized!")}});return picker};picker.date=function(newDate){if(arguments.length===0){if(unset){return null}return date.clone()}if(newDate!==null&&typeof newDate!=="string"&&!moment.isMoment(newDate)&&!(newDate instanceof Date)){throw new TypeError("date() parameter must be one of [null, string, moment or Date]")}setValue(newDate===null?null:parseInputDate(newDate));return picker};picker.format=function(newFormat){if(arguments.length===0){return options.format}if(typeof newFormat!=="string"&&(typeof newFormat!=="boolean"||newFormat!==false)){throw new TypeError("format() expects a string or boolean:false parameter "+newFormat)}options.format=newFormat;if(actualFormat){initFormatting()}return picker};picker.timeZone=function(newZone){if(arguments.length===0){return options.timeZone}if(typeof newZone!=="string"){throw new TypeError("newZone() expects a string parameter")}options.timeZone=newZone;return picker};picker.dayViewHeaderFormat=function(newFormat){if(arguments.length===0){return options.dayViewHeaderFormat}if(typeof newFormat!=="string"){throw new TypeError("dayViewHeaderFormat() expects a string parameter")}options.dayViewHeaderFormat=newFormat;return picker};picker.extraFormats=function(formats){if(arguments.length===0){return options.extraFormats}if(formats!==false&&!(formats instanceof Array)){throw new TypeError("extraFormats() expects an array or false parameter")}options.extraFormats=formats;if(parseFormats){initFormatting()}return picker};picker.disabledDates=function(dates){if(arguments.length===0){return options.disabledDates?$.extend({},options.disabledDates):options.disabledDates}if(!dates){options.disabledDates=false;update();return picker}if(!(dates instanceof Array)){throw new TypeError("disabledDates() expects an array parameter")}options.disabledDates=indexGivenDates(dates);options.enabledDates=false;update();return picker};picker.enabledDates=function(dates){if(arguments.length===0){return options.enabledDates?$.extend({},options.enabledDates):options.enabledDates}if(!dates){options.enabledDates=false;update();return picker}if(!(dates instanceof Array)){throw new TypeError("enabledDates() expects an array parameter")}options.enabledDates=indexGivenDates(dates);options.disabledDates=false;update();return picker};picker.daysOfWeekDisabled=function(daysOfWeekDisabled){if(arguments.length===0){return options.daysOfWeekDisabled.splice(0)}if(typeof daysOfWeekDisabled==="boolean"&&!daysOfWeekDisabled){options.daysOfWeekDisabled=false;update();return picker}if(!(daysOfWeekDisabled instanceof Array)){throw new TypeError("daysOfWeekDisabled() expects an array parameter")}options.daysOfWeekDisabled=daysOfWeekDisabled.reduce(function(previousValue,currentValue){currentValue=parseInt(currentValue,10);if(currentValue>6||currentValue<0||isNaN(currentValue)){return previousValue}if(previousValue.indexOf(currentValue)===-1){previousValue.push(currentValue)}return previousValue},[]).sort();if(options.useCurrent&&!options.keepInvalid){var tries=0;while(!isValid(date,"d")){date.add(1,"d");if(tries===31){throw"Tried 31 times to find a valid date"}tries++}setValue(date)}update();return picker};picker.maxDate=function(maxDate){if(arguments.length===0){return options.maxDate?options.maxDate.clone():options.maxDate}if(typeof maxDate==="boolean"&&maxDate===false){options.maxDate=false;update();return picker}if(typeof maxDate==="string"){if(maxDate==="now"||maxDate==="moment"){maxDate=getMoment()}}var parsedDate=parseInputDate(maxDate);if(!parsedDate.isValid()){throw new TypeError("maxDate() Could not parse date parameter: "+maxDate)}if(options.minDate&&parsedDate.isBefore(options.minDate)){throw new TypeError("maxDate() date parameter is before options.minDate: "+parsedDate.format(actualFormat))}options.maxDate=parsedDate;if(options.useCurrent&&!options.keepInvalid&&date.isAfter(maxDate)){setValue(options.maxDate)}if(viewDate.isAfter(parsedDate)){viewDate=parsedDate.clone().subtract(options.stepping,"m")}update();return picker};picker.minDate=function(minDate){if(arguments.length===0){return options.minDate?options.minDate.clone():options.minDate}if(typeof minDate==="boolean"&&minDate===false){options.minDate=false;update();return picker}if(typeof minDate==="string"){if(minDate==="now"||minDate==="moment"){minDate=getMoment()}}var parsedDate=parseInputDate(minDate);if(!parsedDate.isValid()){throw new TypeError("minDate() Could not parse date parameter: "+minDate)}if(options.maxDate&&parsedDate.isAfter(options.maxDate)){throw new TypeError("minDate() date parameter is after options.maxDate: "+parsedDate.format(actualFormat))}options.minDate=parsedDate;if(options.useCurrent&&!options.keepInvalid&&date.isBefore(minDate)){setValue(options.minDate)}if(viewDate.isBefore(parsedDate)){viewDate=parsedDate.clone().add(options.stepping,"m")}update();return picker};picker.defaultDate=function(defaultDate){if(arguments.length===0){return options.defaultDate?options.defaultDate.clone():options.defaultDate}if(!defaultDate){options.defaultDate=false;return picker}if(typeof defaultDate==="string"){if(defaultDate==="now"||defaultDate==="moment"){defaultDate=getMoment()}else{defaultDate=getMoment(defaultDate)}}var parsedDate=parseInputDate(defaultDate);if(!parsedDate.isValid()){throw new TypeError("defaultDate() Could not parse date parameter: "+defaultDate)}if(!isValid(parsedDate)){throw new TypeError("defaultDate() date passed is invalid according to component setup validations")}options.defaultDate=parsedDate;if(options.defaultDate&&options.inline||input.val().trim()===""){setValue(options.defaultDate)}return picker};picker.locale=function(locale){if(arguments.length===0){return options.locale}if(!moment.localeData(locale)){throw new TypeError("locale() locale "+locale+" is not loaded from moment locales!")}options.locale=locale;date.locale(options.locale);viewDate.locale(options.locale);if(actualFormat){initFormatting()}if(widget){hide();show()}return picker};picker.stepping=function(stepping){if(arguments.length===0){return options.stepping}stepping=parseInt(stepping,10);if(isNaN(stepping)||stepping<1){stepping=1}options.stepping=stepping;return picker};picker.useCurrent=function(useCurrent){var useCurrentOptions=["year","month","day","hour","minute"];if(arguments.length===0){return options.useCurrent}if(typeof useCurrent!=="boolean"&&typeof useCurrent!=="string"){throw new TypeError("useCurrent() expects a boolean or string parameter")}if(typeof useCurrent==="string"&&useCurrentOptions.indexOf(useCurrent.toLowerCase())===-1){throw new TypeError("useCurrent() expects a string parameter of "+useCurrentOptions.join(", "))}options.useCurrent=useCurrent;return picker};picker.collapse=function(collapse){if(arguments.length===0){return options.collapse}if(typeof collapse!=="boolean"){throw new TypeError("collapse() expects a boolean parameter")}if(options.collapse===collapse){return picker}options.collapse=collapse;if(widget){hide();show()}return picker};picker.icons=function(icons){if(arguments.length===0){return $.extend({},options.icons)}if(!(icons instanceof Object)){throw new TypeError("icons() expects parameter to be an Object")}$.extend(options.icons,icons);if(widget){hide();show()}return picker};picker.tooltips=function(tooltips){if(arguments.length===0){return $.extend({},options.tooltips)}if(!(tooltips instanceof Object)){throw new TypeError("tooltips() expects parameter to be an Object")}$.extend(options.tooltips,tooltips);if(widget){hide();show()}return picker};picker.useStrict=function(useStrict){if(arguments.length===0){return options.useStrict}if(typeof useStrict!=="boolean"){throw new TypeError("useStrict() expects a boolean parameter")}options.useStrict=useStrict;return picker};picker.sideBySide=function(sideBySide){if(arguments.length===0){return options.sideBySide}if(typeof sideBySide!=="boolean"){throw new TypeError("sideBySide() expects a boolean parameter")}options.sideBySide=sideBySide;if(widget){hide();show()}return picker};picker.viewMode=function(viewMode){if(arguments.length===0){return options.viewMode}if(typeof viewMode!=="string"){throw new TypeError("viewMode() expects a string parameter")}if(viewModes.indexOf(viewMode)===-1){throw new TypeError("viewMode() parameter must be one of ("+viewModes.join(", ")+") value")}options.viewMode=viewMode;currentViewMode=Math.max(viewModes.indexOf(viewMode),minViewModeNumber);showMode();return picker};picker.toolbarPlacement=function(toolbarPlacement){if(arguments.length===0){return options.toolbarPlacement}if(typeof toolbarPlacement!=="string"){throw new TypeError("toolbarPlacement() expects a string parameter")}if(toolbarPlacements.indexOf(toolbarPlacement)===-1){throw new TypeError("toolbarPlacement() parameter must be one of ("+toolbarPlacements.join(", ")+") value")}options.toolbarPlacement=toolbarPlacement;if(widget){hide();show()}return picker};picker.widgetPositioning=function(widgetPositioning){if(arguments.length===0){return $.extend({},options.widgetPositioning)}if({}.toString.call(widgetPositioning)!=="[object Object]"){throw new TypeError("widgetPositioning() expects an object variable")}if(widgetPositioning.horizontal){if(typeof widgetPositioning.horizontal!=="string"){throw new TypeError("widgetPositioning() horizontal variable must be a string")}widgetPositioning.horizontal=widgetPositioning.horizontal.toLowerCase();if(horizontalModes.indexOf(widgetPositioning.horizontal)===-1){throw new TypeError("widgetPositioning() expects horizontal parameter to be one of ("+horizontalModes.join(", ")+")")}options.widgetPositioning.horizontal=widgetPositioning.horizontal}if(widgetPositioning.vertical){if(typeof widgetPositioning.vertical!=="string"){throw new TypeError("widgetPositioning() vertical variable must be a string")}widgetPositioning.vertical=widgetPositioning.vertical.toLowerCase();if(verticalModes.indexOf(widgetPositioning.vertical)===-1){throw new TypeError("widgetPositioning() expects vertical parameter to be one of ("+verticalModes.join(", ")+")")}options.widgetPositioning.vertical=widgetPositioning.vertical}update();return picker};picker.calendarWeeks=function(calendarWeeks){if(arguments.length===0){return options.calendarWeeks}if(typeof calendarWeeks!=="boolean"){throw new TypeError("calendarWeeks() expects parameter to be a boolean value")}options.calendarWeeks=calendarWeeks;update();return picker};picker.showTodayButton=function(showTodayButton){if(arguments.length===0){return options.showTodayButton}if(typeof showTodayButton!=="boolean"){throw new TypeError("showTodayButton() expects a boolean parameter")}options.showTodayButton=showTodayButton;if(widget){hide();show()}return picker};picker.showClear=function(showClear){if(arguments.length===0){return options.showClear}if(typeof showClear!=="boolean"){throw new TypeError("showClear() expects a boolean parameter")}options.showClear=showClear;if(widget){hide();show()}return picker};picker.widgetParent=function(widgetParent){if(arguments.length===0){return options.widgetParent}if(typeof widgetParent==="string"){widgetParent=$(widgetParent)}if(widgetParent!==null&&(typeof widgetParent!=="string"&&!(widgetParent instanceof $))){throw new TypeError("widgetParent() expects a string or a jQuery object parameter")}options.widgetParent=widgetParent;if(widget){hide();show()}return picker};picker.keepOpen=function(keepOpen){if(arguments.length===0){return options.keepOpen}if(typeof keepOpen!=="boolean"){throw new TypeError("keepOpen() expects a boolean parameter")}options.keepOpen=keepOpen;return picker};picker.focusOnShow=function(focusOnShow){if(arguments.length===0){return options.focusOnShow}if(typeof focusOnShow!=="boolean"){throw new TypeError("focusOnShow() expects a boolean parameter")}options.focusOnShow=focusOnShow;return picker};picker.inline=function(inline){if(arguments.length===0){return options.inline}if(typeof inline!=="boolean"){throw new TypeError("inline() expects a boolean parameter")}options.inline=inline;return picker};picker.clear=function(){clear();return picker};picker.keyBinds=function(keyBinds){if(arguments.length===0){return options.keyBinds}options.keyBinds=keyBinds;return picker};picker.getMoment=function(d){return getMoment(d)};picker.debug=function(debug){if(typeof debug!=="boolean"){throw new TypeError("debug() expects a boolean parameter")}options.debug=debug;return picker};picker.allowInputToggle=function(allowInputToggle){if(arguments.length===0){return options.allowInputToggle}if(typeof allowInputToggle!=="boolean"){throw new TypeError("allowInputToggle() expects a boolean parameter")}options.allowInputToggle=allowInputToggle;return picker};picker.showClose=function(showClose){if(arguments.length===0){return options.showClose}if(typeof showClose!=="boolean"){throw new TypeError("showClose() expects a boolean parameter")}options.showClose=showClose;return picker};picker.keepInvalid=function(keepInvalid){if(arguments.length===0){return options.keepInvalid}if(typeof keepInvalid!=="boolean"){throw new TypeError("keepInvalid() expects a boolean parameter")}options.keepInvalid=keepInvalid;return picker};picker.datepickerInput=function(datepickerInput){if(arguments.length===0){return options.datepickerInput}if(typeof datepickerInput!=="string"){throw new TypeError("datepickerInput() expects a string parameter")}options.datepickerInput=datepickerInput;return picker};picker.parseInputDate=function(parseInputDate){if(arguments.length===0){return options.parseInputDate}if(typeof parseInputDate!=="function"){throw new TypeError("parseInputDate() sholud be as function")}options.parseInputDate=parseInputDate;return picker};picker.disabledTimeIntervals=function(disabledTimeIntervals){if(arguments.length===0){return options.disabledTimeIntervals?$.extend({},options.disabledTimeIntervals):options.disabledTimeIntervals}if(!disabledTimeIntervals){options.disabledTimeIntervals=false;update();return picker}if(!(disabledTimeIntervals instanceof Array)){throw new TypeError("disabledTimeIntervals() expects an array parameter")}options.disabledTimeIntervals=disabledTimeIntervals;update();return picker};picker.disabledHours=function(hours){if(arguments.length===0){return options.disabledHours?$.extend({},options.disabledHours):options.disabledHours}if(!hours){options.disabledHours=false;update();return picker}if(!(hours instanceof Array)){throw new TypeError("disabledHours() expects an array parameter")}options.disabledHours=indexGivenHours(hours);options.enabledHours=false;if(options.useCurrent&&!options.keepInvalid){var tries=0;while(!isValid(date,"h")){date.add(1,"h");if(tries===24){throw"Tried 24 times to find a valid date"}tries++}setValue(date)}update();return picker};picker.enabledHours=function(hours){if(arguments.length===0){return options.enabledHours?$.extend({},options.enabledHours):options.enabledHours}if(!hours){options.enabledHours=false;update();return picker}if(!(hours instanceof Array)){throw new TypeError("enabledHours() expects an array parameter")}options.enabledHours=indexGivenHours(hours);options.disabledHours=false;if(options.useCurrent&&!options.keepInvalid){var tries=0;while(!isValid(date,"h")){date.add(1,"h");if(tries===24){throw"Tried 24 times to find a valid date"}tries++}setValue(date)}update();return picker};picker.viewDate=function(newDate){if(arguments.length===0){return viewDate.clone()}if(!newDate){viewDate=date.clone();return picker}if(typeof newDate!=="string"&&!moment.isMoment(newDate)&&!(newDate instanceof Date)){throw new TypeError("viewDate() parameter must be one of [string, moment or Date]")}viewDate=parseInputDate(newDate);viewUpdate();return picker};if(element.is("input")){input=element}else{input=element.find(options.datepickerInput);if(input.length===0){input=element.find("input")}else if(!input.is("input")){throw new Error('CSS class "'+options.datepickerInput+'" cannot be applied to non input element')}}if(element.hasClass("input-group")){if(element.find(".datepickerbutton").length===0){component=element.find(".input-group-addon")}else{component=element.find(".datepickerbutton")}}if(!options.inline&&!input.is("input")){throw new Error("Could not initialize DateTimePicker without an input element")}date=getMoment();viewDate=date.clone();$.extend(true,options,dataToOptions());picker.options(options);initFormatting();attachDatePickerElementEvents();if(input.prop("disabled")){picker.disable()}if(input.is("input")&&input.val().trim().length!==0){setValue(parseInputDate(input.val().trim()))}else if(options.defaultDate&&input.attr("placeholder")===undefined){setValue(options.defaultDate)}if(options.inline){show()}return picker};$.fn.datetimepicker=function(options){options=options||{};var args=Array.prototype.slice.call(arguments,1),isInstance=true,thisMethods=["destroy","hide","show","toggle"],returnValue;if(typeof options==="object"){return this.each(function(){var $this=$(this),_options;if(!$this.data("DateTimePicker")){_options=$.extend(true,{},$.fn.datetimepicker.defaults,options);$this.data("DateTimePicker",dateTimePicker($this,_options))}})}else if(typeof options==="string"){this.each(function(){var $this=$(this),instance=$this.data("DateTimePicker");if(!instance){throw new Error('bootstrap-datetimepicker("'+options+'") method was called on an element that is not using DateTimePicker')}returnValue=instance[options].apply(instance,args);isInstance=returnValue===instance});if(isInstance||$.inArray(options,thisMethods)>-1){return this}return returnValue}throw new TypeError("Invalid arguments for DateTimePicker: "+options)};$.fn.datetimepicker.defaults={timeZone:"",format:false,dayViewHeaderFormat:"MMMM YYYY",extraFormats:false,stepping:1,minDate:false,maxDate:false,useCurrent:true,collapse:true,locale:moment.locale(),defaultDate:false,disabledDates:false,enabledDates:false,icons:{time:"glyphicon glyphicon-time",date:"glyphicon glyphicon-calendar",up:"glyphicon glyphicon-chevron-up",down:"glyphicon glyphicon-chevron-down",previous:"glyphicon glyphicon-chevron-left",next:"glyphicon glyphicon-chevron-right",today:"glyphicon glyphicon-screenshot",clear:"glyphicon glyphicon-trash",close:"glyphicon glyphicon-remove"},tooltips:{today:"Go to today",clear:"Clear selection",close:"Close the picker",selectMonth:"Select Month",prevMonth:"Previous Month",nextMonth:"Next Month",selectYear:"Select Year",prevYear:"Previous Year",nextYear:"Next Year",selectDecade:"Select Decade",prevDecade:"Previous Decade",nextDecade:"Next Decade",prevCentury:"Previous Century",nextCentury:"Next Century",pickHour:"Pick Hour",incrementHour:"Increment Hour",decrementHour:"Decrement Hour",pickMinute:"Pick Minute",incrementMinute:"Increment Minute",decrementMinute:"Decrement Minute",pickSecond:"Pick Second",incrementSecond:"Increment Second",decrementSecond:"Decrement Second",togglePeriod:"Toggle Period",selectTime:"Select Time"},useStrict:false,sideBySide:false,daysOfWeekDisabled:false,calendarWeeks:false,viewMode:"days",toolbarPlacement:"default",showTodayButton:false,showClear:false,showClose:false,widgetPositioning:{horizontal:"auto",vertical:"auto"},widgetParent:null,ignoreReadonly:false,keepOpen:false,focusOnShow:true,inline:false,keepInvalid:false,datepickerInput:".datepickerinput",keyBinds:{up:function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().subtract(7,"d"))}else{this.date(d.clone().add(this.stepping(),"m"))}},down:function(widget){if(!widget){this.show();return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().add(7,"d"))}else{this.date(d.clone().subtract(this.stepping(),"m"))}},"control up":function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().subtract(1,"y"))}else{this.date(d.clone().add(1,"h"))}},"control down":function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().add(1,"y"))}else{this.date(d.clone().subtract(1,"h"))}},left:function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().subtract(1,"d"))}},right:function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().add(1,"d"))}},pageUp:function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().subtract(1,"M"))}},pageDown:function(widget){if(!widget){return}var d=this.date()||this.getMoment();if(widget.find(".datepicker").is(":visible")){this.date(d.clone().add(1,"M"))}},enter:function(){this.hide()},escape:function(){this.hide()},"control space":function(widget){if(!widget){return}if(widget.find(".timepicker").is(":visible")){widget.find('.btn[data-action="togglePeriod"]').click()}},t:function(){this.date(this.getMoment())},"delete":function(){this.clear()}},debug:false,allowInputToggle:false,disabledTimeIntervals:false,disabledHours:false,enabledHours:false,viewDate:false};return $.fn.datetimepicker});
//# sourceMappingURL=deps.min.js.map