# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class FindCellStrategy(Object):
    r"""
    FindCellStrategy - helper class to manage the
    PointSet::FindCell() METHOD
    
    Superclass: Object
    
    FindCellStrategy is a helper class to manage the use of locators
    for locating cells containing a query point x[3], the so-called
    find_cell() method. The use of DataSet::FindCell() is a common
    operation in applications such as streamline generation and probing.
    However, in some dataset types find_cell() can be implemented very
    simply (e.g., ImageData) while in other datasets it is a complex
    operation requiring supplemental objects like locators to perform
    efficiently. In particular, PointSet and its subclasses (like
    UnstructuredGrid) require complex strategies to efficiently
    implement the find_cell() operation. Subclasses of the abstract
    FindCellStrategy implement several of these strategies.
    
    The are two key methods to this class and subclasses. The
    Initialize() method negotiates with an input dataset to define the
    locator to use: either a locator associated with the input dataset,
    or possibly an alternative locator defined by the strategy
    (subclasses of FindCellStrategy do this). The second important
    method, find_cell() mimics DataSet::FindCell() and can be used in
    place of it.
    
    Note that FindCellStrategy is in general not thread-safe as the
    strategies contain state used to accelerate the search process. Hence
    if multiple threads are attempting to invoke find_cell(), each thread
    needs to have its own instance of the FindCellStrategy.
    
    @sa
    PointSet PolyData StructuredGrid UnstructuredGrid
    AbstractInterpolatedVelocityField ClosetPointStrategy
    CellLocatorStrategy ClosestNPointsStrategy
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFindCellStrategy, obj, update, **traits)
    
    def copy_parameters(self, *args):
        """
        copy_parameters(self, from_:FindCellStrategy) -> None
        C++: virtual void copy_parameters(FindCellStrategy *from)
        Copy essential parameters between instances of this class. This
        generally is used to copy from instance prototype to another, or
        to copy strategies between thread instances.  Sub-classes can
        contribute to the parameter copying process via chaining.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyParameters, *my_args)
        return ret

    def find_cell(self, *args):
        """
        find_cell(self, x:[float, float, float], cell:Cell,
            gencell:GenericCell, cellId:int, tol2:float, subId:int,
            pcoords:[float, float, float], weights:[float, ...]) -> int
        C++: virtual IdType find_cell(double x[3], Cell *cell,
            GenericCell *gencell, IdType cellId, double tol2,
            int &subId, double pcoords[3], double *weights)
        Virtual method for finding a cell. Subclasses must satisfy this
        API. This method is of the same signature as
        DataSet::FindCell(). This method is not thread safe: separate
        instances of FindCellStrategy should be created for each
        thread invoking find_cell(). This is done for performance reasons
        to reduce the number of objects created/destroyed on each
        find_cell() invocation.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FindCell, *my_args)
        return ret

    def find_closest_point_within_radius(self, *args):
        """
        find_closest_point_within_radius(self, x:[float, float, float],
            radius:float, closestPoint:[float, float, float],
            cell:GenericCell, cellId:int, subId:int, dist2:float,
            inside:int) -> int
        C++: virtual IdType find_closest_point_within_radius(double x[3],
            double radius, double closestPoint[3], GenericCell *cell,
            IdType &cellId, int &subId, double &dist2, int &inside)
        Return the closest point within a specified radius and the cell
        which is closest to the point x. The closest point is somewhere
        on a cell, it need not be one of the vertices of the cell. This
        method returns 1 if a point is found within the specified radius.
        If there are no cells within the specified radius, the method
        returns 0 and the values of closestPoint, cellId, subId, and
        dist2 are undefined. This version takes in a GenericCell to
        avoid allocating and deallocating the cell.  This is much faster
        than the version which does not take a *cell, especially when
        this function is called many times in a row such as by a for
        loop, where the allocation and dealloction can be done only once
        outside the for loop.  If a closest point is found, "cell"
        contains the points and ptIds for the cell "cellId" upon exit. 
        If a closest point is found, inside returns the return value of
        the evaluate_position call to the closest cell; inside(=1) or
        outside(=0).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FindClosestPointWithinRadius, *my_args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, ps:PointSet) -> int
        C++: virtual int initialize(PointSet *ps)
        All subclasses of this class must provide an initialize method. 
        This method performs handshaking and setup between the
        PointSet dataset and associated locator(s). A return value==0
        means the initialization process failed. The initialization is
        set up in such a way as to prevent multiple locators from being
        built.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def inside_cell_bounds(self, *args):
        """
        inside_cell_bounds(self, x:[float, float, float], cellId:int)
            -> bool
        C++: virtual bool inside_cell_bounds(double x[3], IdType cellId)
        Quickly test if a point is inside the bounds of a particular
        cell.
        """
        ret = self._wrap_call(self._vtk_obj.InsideCellBounds, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FindCellStrategy, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FindCellStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit FindCellStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FindCellStrategy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

