/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.*;
import java.beans.*;

import javax.swing.*;
import javax.swing.event.*;
import org.openide.util.NbBundle;

/**
 * Panel for selecting catalog providers showing customizer for selected one.
 *
 * @author  Petr Kuzel
 */
final class CatalogMounterPanel extends javax.swing.JPanel implements ChangeListener {

    /** Serial Version UID */
    private static final long serialVersionUID =-1208422697106159058L;

    private CatalogMounterModel model;

    /** Creates new form CatalogMounterPanel */
    public CatalogMounterPanel(CatalogMounterModel model) {
        this.model = model;
        initComponents();
        initAccessibility();
        this.catalogLabel.setDisplayedMnemonic(NbBundle.getMessage(
                CatalogMounterPanel.class,"CatalogMounterPanel.catalogLabel.mne").charAt(0)); // NOI18N                
        catalogComboBox.setModel(model.getCatalogComboBoxModel());
        updateCatalogPanel();
        
        model.addChangeListener(this);
    }

    /**
     * Compute preffered dimension for combo with
     * particulal number of columns
     */
    private Dimension comboSize(int columns) {
        JTextField template = new JTextField();
        template.setColumns(columns);
        return template.getPreferredSize();
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        catalogLabel = new javax.swing.JLabel();
        catalogComboBox = new javax.swing.JComboBox();
        parentPanel = new javax.swing.JPanel();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 4, 4, 4));
        setMinimumSize(new java.awt.Dimension(380, 100));
        setLayout(new java.awt.GridBagLayout());

        catalogLabel.setLabelFor(catalogComboBox);
        catalogLabel.setText(NbBundle.getMessage(CatalogMounterPanel.class, "CatalogMounterPanel.catalogLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(catalogLabel, gridBagConstraints);

        catalogComboBox.setPreferredSize(comboSize(40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(catalogComboBox, gridBagConstraints);

        parentPanel.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(parentPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void updateCatalogPanel() {
        Customizer cust = model.getCatalogCustomizer();
        cust.setObject(model.getCatalog());
        invalidate();
        parentPanel.removeAll();
        Component catalogPanel = (Component) cust;
        parentPanel.add(catalogPanel, BorderLayout.CENTER);
        validate();
    }
    
    public void stateChanged(ChangeEvent e) {
        updateCatalogPanel();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox catalogComboBox;
    private javax.swing.JLabel catalogLabel;
    private javax.swing.JPanel parentPanel;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility(){
        catalogComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogMounterPanel.class, "ACSD_catalogComboBox"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CatalogMounterPanel.class, "ACSN_CatalogMounterPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogMounterPanel.class, "ACSD_CatalogMounterPanel"));
        
    }
    
}
