; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=fiji -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GFX8 %s

define void @undef_lo_v2i16(i16 %arg0) {
; GFX9-LABEL: undef_lo_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = insertelement <2 x i16> undef, i16 %arg0, i32 1
  call void asm sideeffect "; use $0", "v"(<2 x i16> %undef.lo);
  ret void
}

define void @undef_lo_v2f16(half %arg0) {
; GFX9-LABEL: undef_lo_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = insertelement <2 x half> undef, half %arg0, i32 1
  call void asm sideeffect "; use $0", "v"(<2 x half> %undef.lo);
  ret void
}

define void @undef_lo_op_v2f16(half %arg0) {
; GFX9-LABEL: undef_lo_op_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_pk_add_f16 v0, v0, 1.0 op_sel_hi:[1,0]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo_op_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x3c00
; GFX8-NEXT:    v_add_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, 0x7e00, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = insertelement <2 x half> undef, half %arg0, i32 1
  %op = fadd <2 x half> %undef.lo, <half 1.0, half 1.0>
  call void asm sideeffect "; use $0", "v"(<2 x half> %op);
  ret void
}

define void @undef_lo_op_v2i16(i16 %arg0) {
; GFX9-LABEL: undef_lo_op_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_movk_i32 s6, 0x63
; GFX9-NEXT:    v_pk_add_u16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo_op_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x63
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = insertelement <2 x i16> undef, i16 %arg0, i32 1
  %op = add <2 x i16> %undef.lo, <i16 99, i16 99>
  call void asm sideeffect "; use $0", "v"(<2 x i16> %op);
  ret void
}

define void @undef_lo3_v4i16(i16 %arg0) {
; GFX9-LABEL: undef_lo3_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo3_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = insertelement <4 x i16> undef, i16 %arg0, i32 1
  call void asm sideeffect "; use $0", "v"(<4 x i16> %undef.lo);
  ret void
}

define void @undef_lo3_v4f16(half %arg0) {
; GFX9-LABEL: undef_lo3_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo3_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = insertelement <4 x half> undef, half %arg0, i32 1
  call void asm sideeffect "; use $0", "v"(<4 x half> %undef.lo);
  ret void
}

define void @undef_lo2_v4i16(<2 x i16> %arg0) {
; GFX9-LABEL: undef_lo2_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffff0000
; GFX9-NEXT:    v_and_or_b32 v0, v0, v2, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo2_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = shufflevector <2 x i16> %arg0, <2 x i16> undef, <4 x i32> <i32 1, i32 1, i32 2, i32 3>
  call void asm sideeffect "; use $0", "v"(<4 x i16> %undef.lo);
  ret void
}

define void @undef_lo2_v4f16(<2 x half> %arg0) {
; GFX9-LABEL: undef_lo2_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_lo2_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.lo = shufflevector <2 x half> %arg0, <2 x half> undef, <4 x i32> <i32 1, i32 1, i32 2, i32 3>
  call void asm sideeffect "; use $0", "v"(<4 x half> %undef.lo);
  ret void
}

define void @undef_hi_v2i16(i16 %arg0) {
; GFX9-LABEL: undef_hi_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = insertelement <2 x i16> undef, i16 %arg0, i32 0
  call void asm sideeffect "; use $0", "v"(<2 x i16> %undef.hi);
  ret void
}

define void @undef_hi_v2f16(half %arg0) {
; GFX9-LABEL: undef_hi_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = insertelement <2 x half> undef, half %arg0, i32 0
  call void asm sideeffect "; use $0", "v"(<2 x half> %undef.hi);
  ret void
}

define void @undef_hi_op_v2f16(half %arg0) {
; GFX9-LABEL: undef_hi_op_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_f16 v0, v0, 1.0 op_sel_hi:[1,0]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi_op_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX8-NEXT:    v_or_b32_e32 v0, 0x7e000000, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = insertelement <2 x half> undef, half %arg0, i32 0
  %op = fadd <2 x half> %undef.hi, <half 1.0, half 1.0>
  call void asm sideeffect "; use $0", "v"(<2 x half> %op);
  ret void
}

define void @undef_hi_op_v2i16(i16 %arg0) {
; GFX9-LABEL: undef_hi_op_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_movk_i32 s6, 0x63
; GFX9-NEXT:    v_pk_add_u16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi_op_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e32 v0, 0x63, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = insertelement <2 x i16> undef, i16 %arg0, i32 0
  %op = add <2 x i16> %undef.hi, <i16 99, i16 99>
  call void asm sideeffect "; use $0", "v"(<2 x i16> %op);
  ret void
}

define void @undef_hi3_v4i16(i16 %arg0) {
; GFX9-LABEL: undef_hi3_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi3_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = insertelement <4 x i16> undef, i16 %arg0, i32 0
  call void asm sideeffect "; use $0", "v"(<4 x i16> %undef.hi);
  ret void
}

define void @undef_hi3_v4f16(half %arg0) {
; GFX9-LABEL: undef_hi3_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi3_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = insertelement <4 x half> undef, half %arg0, i32 0
  call void asm sideeffect "; use $0", "v"(<4 x half> %undef.hi);
  ret void
}

define void @undef_hi2_v4i16(<2 x i16> %arg0) {
; GFX9-LABEL: undef_hi2_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi2_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = shufflevector <2 x i16> %arg0, <2 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  call void asm sideeffect "; use $0", "v"(<4 x i16> %undef.hi);
  ret void
}

define void @undef_hi2_v4f16(<2 x half> %arg0) {
; GFX9-LABEL: undef_hi2_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use v[0:1]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: undef_hi2_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v[0:1]
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
  %undef.hi = shufflevector <2 x half> %arg0, <2 x half> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  call void asm sideeffect "; use $0", "v"(<4 x half> %undef.hi);
  ret void
}

