/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef LISTINGMODEL_H
#define LISTINGMODEL_H

#include <QtCore/QAbstractTableModel>

#include "filtermodel.h"
#include "qldap.h"

class ListingModel : public QAbstractTableModel
{
  Q_OBJECT

  public:
    enum Roles
    {
      HasModifyActionRole = Qt::UserRole + 1,
      HasDeleteActionRole,
      ModifyActionLabelRole,
      DeleteActionLabelRole,
      ModifyActionIdRole,
      DeleteActionIdRole
    };

    ListingModel( QObject *parent = 0 );
    virtual ~ListingModel();

    virtual FilterModel* filterModel() { return 0; }

  public Q_SLOTS:
    void query( const QString &filter = QString() );

  protected:
    virtual void doQuery( const QString &filter ) = 0;

    QLdapResponse mData;
};

#endif
