#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DIR=jbossas-$2.orig

# clean up the upstream tarball
tar -x -z -f $3
mv jboss* $DIR

(cd $DIR;\
grep -ril -m 60 --include="*.java" "Generated.*Do not edit" . | xargs rm;\
grep -ril -m 60 --include="*.java" "Do not reproduce without permission in writing" .|xargs rm)

GZIP=--best tar -c -z -f $3 -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $3 $origDir
  echo "moved $3 to $origDir"
fi

