#ifndef __GM_APP_H__
#define __GM_APP_H__

//#define G_XML PACKAGE_DATA_DIR "/" PACKAGE "/ui/gm-main.glade"

#include <gtk/gtk.h>
#include "gm-world.h"
#include "gm-options.h"
#include "gm-color-table.h"
#include "gm-scripts.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_APP					(gm_app_get_type())
#define GM_APP(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_APP, GmApp))
#define GM_APP_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_APP, GmApp const))
#define GM_APP_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_APP, GmAppClass))
#define GM_IS_APP(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_APP))
#define GM_IS_APP_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_APP))
#define GM_APP_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_APP, GmAppClass))

/* Private structure type */
typedef struct _GmAppPrivate GmAppPrivate;

/*
 * Main object structure
 */
typedef struct _GmApp GmApp;
 
struct _GmApp {
	GObject object;
	
	/*< private > */
	GmAppPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmAppClass 	GmAppClass;

struct _GmAppClass {
	GObjectClass parent_class;

	/* Signals */
	void (* world_added) (GmApp *app, GmWorld *world);
	void (* world_removed) (GmApp *app, GmWorld *world);
};

GmApp *gm_app_instance();
GType gm_app_get_type(void) G_GNUC_CONST;
GmApp *gm_app_new(int argc, char *argv[]);

void gm_app_add_world(GmApp *app, GmWorld *world);
void gm_app_remove_world(GmApp *app, GmWorld *world);

const gchar *gm_app_worlds_path(GmApp *app);
const gchar *gm_app_path(GmApp *app);
GmOptions *gm_app_options(GmApp *app);
GList *gm_app_worlds(GmApp *app);
GmColorTable *gm_app_color_table(GmApp *app);
GmWorld *gm_app_world_by_name(GmApp *app, gchar *name);

#ifdef HAVE_RUBY
GmScripts *gm_app_scripts(GmApp *app);
#endif

G_END_DECLS

#endif /* __GM_APP_H__ */
