.\" @(#)$RCSfile: gfal_stat.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_STAT 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_stat \- get information about a file or directory
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_stat (const char *" filename ,
.BI "struct stat *" statbuf );
.br
.BI "int gfal_lstat (const char *" filename ,
.BI "struct stat *" statbuf );
.sp
Under Linux, for large files:
.br
.B #define _LARGEFILE64_SOURCE
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_stat64 (const char *" filename ,
.BI "struct stat64 *" statbuf );
.br
.BI "int gfal_stat64 (const char *" filename ,
.BI "struct stat64 *" statbuf );
.sp
For large files, under other systems:
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_stat64 (const char *" filename ,
.BI "struct stat64 *" statbuf );
.br
.BI "int gfal_lstat64 (const char *" filename ,
.BI "struct stat64 *" statbuf );
.SH DESCRIPTION
.B gfal_stat
gets information about a file or directory.
.B gfal_lstat
is identical to
.B gfal_stat
except for symbolic links. In this case, the link itself is statted and not
followed.
.TP
.I filename
specifies the file name: either a logical file name, a guid, an SURL or a TURL.
.LP
The 64 bits functions must be used for large files. They have the same syntax as
the normal stat functions except that they use a
.B stat64
structure.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
The named file/directory does not exist.
.TP
.B EACCES
Search permission is denied on a component of the
.I filename
prefix.
.TP
.B EFAULT
.I filename
is a NULL pointer.
.TP
.B ENOTDIR
A component of
.I filename
prefix is not a directory.
.TP
.B EINVAL
.I filename
has an invalid syntax.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
