'''OpenGL extension ARB.texture_buffer_range

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.texture_buffer_range to provide a more 
Python-friendly API

Overview (from the spec)
	
	ARB_texture_buffer_object (which was promoted to core in OpenGL 3.1)
	introduced the ability to attach the data store of a buffer object
	to a buffer texture and access it from shaders. The extension only allows
	the entire store of the buffer object to the texture. This extension
	expands on this and allows a sub-range of the buffer's data store to
	be attached to a texture. This can be used, for example, to allow multiple
	buffer textures to be backed by independent sub-ranges of the same buffer
	object, or for different sub-ranges of a single buffer object to be used
	for different purposes.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/texture_buffer_range.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.texture_buffer_range import *
from OpenGL.raw.GL.ARB.texture_buffer_range import _EXTENSION_NAME

def glInitTextureBufferRangeARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION