/* $Id: SymbolDeclaration.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/SymbolDeclaration.hpp"
#include <cassert>
#include "util/mangle_names.h"

namespace ast {

std::string 
SymbolDeclaration::getICName(void) const
{
	char buffer[2048];
	assert(this->pathName.size() > 2);

	// strip leading and tailing ':'
	std::string m = 
		this->pathName.substr(1, this->pathName.size() - 2);

	int ret = mangle_name(m.c_str(), buffer, sizeof(buffer));
	assert(static_cast<size_t>(ret) < sizeof(buffer));
	
	return std::string(buffer);
}

}; /* namespace ast */
