/* $Id: er_help.h,v 1.8 2013-01-03 16:32:56 cgarcia Exp $
 *
 *   This file is part of the ESO Common Pipeline Library
 *   Copyright (C) 2001-2004 European Southern Observatory
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-01-03 16:32:56 $
 * $Revision: 1.8 $
 * $Name: not supported by cvs2svn $
 */


#ifndef EP_HELP_H
#define EP_HELP_H

#include <cxstrutils.h> 

#include <cpl.h>

/*
 * Symbolic constant, used in allowing EsoRex to recognise the
 * version with which a given configuration file was created.
 * NOTE: Changing this symbolic constant will prevent earlier
 * versions from being detected. If this is done, then some
 * additional code for the old version will need to be added to
 * er_params.c
 */

#define ER_HELP_CFG_VER  "#       generated by the " PACKAGE " (v"


CPL_BEGIN_DECLS

void er_help_display
(
  const char *,
  cpl_parameterlist *
);

void
er_help_manpage
(
  cpl_recipe  *
);

void
er_help_free
(
  void
);

void
er_help_create_config
(
  int ,
  const char  *,
  const char  *,
  cpl_parameterlist *,
  cpl_parameterlist *
);

CPL_END_DECLS


#endif /* EP_HELP_H */


/* End of file */

