(add-to-list 'load-path ".")

(require 'cl)
(require 'pp)
(require 'chess)
(require 'chess-pgn)

(defun chess-generate-texinfo-file ()
  (require 'lispdoc)
  (require 'texinfo)
  (with-temp-buffer
    (insert-file-contents-literally "chess.texi")
    (texinfo-mode)
    (require 'chess-algebraic)
    (require 'chess-display)
    (require 'chess-engine)
    (require 'chess-epd)
    (require 'chess-fen)
    (require 'chess-game)
    (require 'chess-ics)
    (require 'chess-pgn)
    (require 'chess-ply)
    (require 'chess-pos)
    (require 'chess-random)
    (require 'chess-var)
    (require 'chess)
    (texinfo-insert-node-lines (point-min) (point-max) t)
    (texinfo-every-node-update)
    (texinfo-all-menus-update t)
    (texinfo-every-node-update)
    (texinfo-all-menus-update t)
    (update-lispdoc-tags)
    (write-file "chess-final.texi")))
