/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTCAPABILITIES_H_
#define OPENDRIM_ACCOUNTCAPABILITIES_H_

#include <Instance.h>

const static char* OpenDRIM_AccountCapabilities_classnames[] = {"OpenDRIM_AccountCapabilities"};
static string OpenDRIM_AccountCapabilities_NAMESPACE = _NAMESPACE;

class OpenDRIM_AccountCapabilities {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	unsigned short MaxElementNameLen;
	bool MaxElementNameLen_isNULL;
	
	vector<unsigned short> RequestedStatesSupported;
	bool RequestedStatesSupported_isNULL;
	
	string ElementNameMask;
	bool ElementNameMask_isNULL;
	
	vector<unsigned short> StateAwareness;
	bool StateAwareness_isNULL;
	
	unsigned short PasswordHistory;
	bool PasswordHistory_isNULL;
	
	string MaximumPasswordAge;
	bool MaximumPasswordAge_isNULL;
	
	vector<unsigned short> ComplexPasswordRulesSupported;
	bool ComplexPasswordRulesSupported_isNULL;
	
	bool DisableOnInactivity;
	bool DisableOnInactivity_isNULL;
	
	vector<unsigned short> RequestedStateSupported;
	bool RequestedStateSupported_isNULL;
	
	bool ElementNameEditSupported;
	bool ElementNameEditSupported_isNULL;
	
	string DisableTimeoutAfterPasswordExpiration;
	bool DisableTimeoutAfterPasswordExpiration_isNULL;
	
	OpenDRIM_AccountCapabilities() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		MaxElementNameLen_isNULL = true;
		RequestedStatesSupported_isNULL = true;
		ElementNameMask_isNULL = true;
		StateAwareness_isNULL = true;
		PasswordHistory_isNULL = true;
		MaximumPasswordAge_isNULL = true;
		ComplexPasswordRulesSupported_isNULL = true;
		DisableOnInactivity_isNULL = true;
		RequestedStateSupported_isNULL = true;
		ElementNameEditSupported_isNULL = true;
		DisableTimeoutAfterPasswordExpiration_isNULL = true;
	}
	
	~OpenDRIM_AccountCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getMaxElementNameLen(unsigned short& value) const {
		if (MaxElementNameLen_isNULL==true)
			return NOT_FOUND;
		value = MaxElementNameLen;
		return OK;
	}
	
	int setMaxElementNameLen(const unsigned short& newValue) {
		MaxElementNameLen = newValue;
		MaxElementNameLen_isNULL = false;
		return OK;
	}

	int getRequestedStatesSupported(vector<unsigned short>& value) const {
		if (RequestedStatesSupported_isNULL==true)
			return NOT_FOUND;
		value = RequestedStatesSupported;
		return OK;
	}
	
	int setRequestedStatesSupported(const vector<unsigned short>& newValue) {
		RequestedStatesSupported = newValue;
		RequestedStatesSupported_isNULL = false;
		return OK;
	}

	int getElementNameMask(string& value) const {
		if (ElementNameMask_isNULL==true)
			return NOT_FOUND;
		value = ElementNameMask;
		return OK;
	}
	
	int setElementNameMask(const string& newValue) {
		ElementNameMask = newValue;
		ElementNameMask_isNULL = false;
		return OK;
	}

	int getStateAwareness(vector<unsigned short>& value) const {
		if (StateAwareness_isNULL==true)
			return NOT_FOUND;
		value = StateAwareness;
		return OK;
	}
	
	int setStateAwareness(const vector<unsigned short>& newValue) {
		StateAwareness = newValue;
		StateAwareness_isNULL = false;
		return OK;
	}

	int getPasswordHistory(unsigned short& value) const {
		if (PasswordHistory_isNULL==true)
			return NOT_FOUND;
		value = PasswordHistory;
		return OK;
	}
	
	int setPasswordHistory(const unsigned short& newValue) {
		PasswordHistory = newValue;
		PasswordHistory_isNULL = false;
		return OK;
	}

	int getMaximumPasswordAge(string& value) const {
		if (MaximumPasswordAge_isNULL==true)
			return NOT_FOUND;
		value = MaximumPasswordAge;
		return OK;
	}
	
	int setMaximumPasswordAge(const string& newValue) {
		MaximumPasswordAge = newValue;
		MaximumPasswordAge_isNULL = false;
		return OK;
	}

	int getComplexPasswordRulesSupported(vector<unsigned short>& value) const {
		if (ComplexPasswordRulesSupported_isNULL==true)
			return NOT_FOUND;
		value = ComplexPasswordRulesSupported;
		return OK;
	}
	
	int setComplexPasswordRulesSupported(const vector<unsigned short>& newValue) {
		ComplexPasswordRulesSupported = newValue;
		ComplexPasswordRulesSupported_isNULL = false;
		return OK;
	}

	int getDisableOnInactivity(bool& value) const {
		if (DisableOnInactivity_isNULL==true)
			return NOT_FOUND;
		value = DisableOnInactivity;
		return OK;
	}
	
	int setDisableOnInactivity(const bool& newValue) {
		DisableOnInactivity = newValue;
		DisableOnInactivity_isNULL = false;
		return OK;
	}

	int getRequestedStateSupported(vector<unsigned short>& value) const {
		if (RequestedStateSupported_isNULL==true)
			return NOT_FOUND;
		value = RequestedStateSupported;
		return OK;
	}
	
	int setRequestedStateSupported(const vector<unsigned short>& newValue) {
		RequestedStateSupported = newValue;
		RequestedStateSupported_isNULL = false;
		return OK;
	}

	int getElementNameEditSupported(bool& value) const {
		if (ElementNameEditSupported_isNULL==true)
			return NOT_FOUND;
		value = ElementNameEditSupported;
		return OK;
	}
	
	int setElementNameEditSupported(const bool& newValue) {
		ElementNameEditSupported = newValue;
		ElementNameEditSupported_isNULL = false;
		return OK;
	}

	int getDisableTimeoutAfterPasswordExpiration(string& value) const {
		if (DisableTimeoutAfterPasswordExpiration_isNULL==true)
			return NOT_FOUND;
		value = DisableTimeoutAfterPasswordExpiration;
		return OK;
	}
	
	int setDisableTimeoutAfterPasswordExpiration(const string& newValue) {
		DisableTimeoutAfterPasswordExpiration = newValue;
		DisableTimeoutAfterPasswordExpiration_isNULL = false;
		return OK;
	}

};

class OpenDRIM_AccountCapabilities_CreateGoalSettings_In {

public:

	vector<string> TemplateGoalSettings;
	bool TemplateGoalSettings_isNULL;

	vector<string> SupportedGoalSettings;
	bool SupportedGoalSettings_isNULL;

	OpenDRIM_AccountCapabilities_CreateGoalSettings_In() {
		TemplateGoalSettings_isNULL = true;
		SupportedGoalSettings_isNULL = true;
	}

	~OpenDRIM_AccountCapabilities_CreateGoalSettings_In() {}

	int getTemplateGoalSettings(vector<string>& value) const {
		if (TemplateGoalSettings_isNULL == true)
			return NOT_FOUND;
		value = TemplateGoalSettings;
		return OK;
	}
	int setTemplateGoalSettings(const vector<string>&  newValue) {
		TemplateGoalSettings = newValue;
		TemplateGoalSettings_isNULL = false;
		return OK;
	}

	int getSupportedGoalSettings(vector<string>& value) const {
		if (SupportedGoalSettings_isNULL == true)
			return NOT_FOUND;
		value = SupportedGoalSettings;
		return OK;
	}
	int setSupportedGoalSettings(const vector<string>&  newValue) {
		SupportedGoalSettings = newValue;
		SupportedGoalSettings_isNULL = false;
		return OK;
	}

};

class OpenDRIM_AccountCapabilities_CreateGoalSettings_Out {

public:

	vector<string> SupportedGoalSettings;
	bool SupportedGoalSettings_isNULL;

	OpenDRIM_AccountCapabilities_CreateGoalSettings_Out() {
		SupportedGoalSettings_isNULL = true;
	}

	~OpenDRIM_AccountCapabilities_CreateGoalSettings_Out() {}

	int getSupportedGoalSettings(vector<string>& value) const {
		if (SupportedGoalSettings_isNULL == true)
			return NOT_FOUND;
		value = SupportedGoalSettings;
		return OK;
	}
	int setSupportedGoalSettings(const vector<string>&  newValue) {
		SupportedGoalSettings = newValue;
		SupportedGoalSettings_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_ACCOUNTCAPABILITIES_H_*/
