.\" Copyright 1988, 1994, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\"
.TH XCLIPBOARD 1 __xorgversion__
.SH NAME
xclipboard \- X clipboard client
.SH SYNOPSIS
\fBxclipboard\fP [ \fI\-toolkitoption\fP ... ] [ \fB\-w\fP ]
[ \fB\-nw\fP ]
.SH DESCRIPTION
The \fIxclipboard\fP program is used to collect and display text selections
that are sent to the CLIPBOARD by other clients.  It is typically used to
save CLIPBOARD selections for later use.  It stores each CLIPBOARD selection
as a separate string, each of which can be selected.  Each time CLIPBOARD
is asserted by another application, \fIxclipboard\fP transfers the contents
of that selection to a new buffer and displays it in the text window.
Buffers are never automatically deleted, so you'll want to use the delete
button to get rid of useless items.
.PP
Since \fIxclipboard\fP uses a Text Widget to display the contents of the
clipboard, text sent to the CLIPBOARD may be re-selected for use in other
applications.  \fIxclipboard\fP also responds to requests for the CLIPBOARD
selection from other clients by sending the entire contents of the currently
displayed buffer.
.PP
An \fIxclipboard\fP window has the following buttons across the top:
.TP 8
.I quit
When this button is pressed, \fIxclipboard\fP exits.
.TP 8
.I delete
When this button is pressed, the current buffer is deleted and the
next one displayed.
.TP 8
.I new
Creates a new buffer with no contents.  Useful in constructing a new
CLIPBOARD selection by hand.
.TP 8
.I save
Displays a File Save dialog box.
Pressing the Accept button saves the currently
displayed buffer to the file specified in the text field.
.TP 8
.I next
Displays the next buffer in the list.
.TP 8
.I previous
Displays the previous buffer.
.SH OPTIONS
The \fIxclipboard\fP program accepts all of the standard X Toolkit command
line options as well as the following:
.TP 8
.B \-w
This option indicates that lines of text that are too long to be displayed on
one line in the clipboard should wrap around to the following lines.
.TP 8
.B \-nw
This option indicates that long lines of text should not wrap around.  This
is the default behavior.
.SH WIDGETS
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIxclipboard\fR.  In the notation below,
indentation indicates hierarchical structure.  The widget class name
is given first, followed by the widget instance name.
.sp
.nf
.ft CW
XClipboard  xclipboard
        Form  form
                Command  Quit
                Command  delete
                Command  new
                Command  Save
                Command  next
                Command  prev
                Label  index
                Text  text
        TransientShell  fileDialogShell
                Dialog  fileDialog
                        Label  label
                        Command  accept
                        Command  cancel
                        Text value
        TransientShell  failDialogShell
                Dialog  failDialog
                        Label  label
                        Command  continue
.ft
.fi
.sp
.SH SENDING/RETRIEVING CLIPBOARD CONTENTS
Text is copied to the clipboard whenever a client asserts ownership of the
\fBCLIPBOARD\fP selection.  Text is copied from the clipboard whenever a
client requests the contents of the \fBCLIPBOARD\fP selection.  Examples of
event bindings that a user may wish to include in a resource configuration
file to use the clipboard are:
.sp
.nf
.ft CW
*VT100.Translations: #override \\
        <Btn3Up>:       select-end(CLIPBOARD) \\n\\
        <Btn2Up>:       insert-selection(PRIMARY,CLIPBOARD) \\n\\
        <Btn2Down>:     ignore ()

.ft
.fi
.sp
.SH "SEE ALSO"
X(__miscmansuffix__), xcutsel(__appmansuffix__), xterm(__appmansuffix__), individual client documentation for how to make a
selection and send it to the CLIPBOARD.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
.TP
.I __apploaddir__/XClipboard
specifies required resources
.SH AUTHOR
Ralph R. Swick, DEC/MIT Project Athena
.br
Chris D. Peterson, MIT X Consortium
.br
Keith Packard, MIT X Consortium
