/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CPropertyCollectionDoc.h"
#include "Doc/CafCoreTypesDoc/CPropertyDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/PropertyCollectionXml.h"
#include "Doc/DocXml/CafCoreTypesXml/PropertyXml.h"

using namespace Caf;

void PropertyCollectionXml::add(
	const SmartPtrCPropertyCollectionDoc propertyCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("PropertyCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(propertyCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCPropertyDoc> propertyVal =
			propertyCollectionDoc->getProperty();
		CAF_CM_VALIDATE_STL(propertyVal);

		if (! propertyVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCPropertyDoc> > propertyIter(propertyVal);
				propertyIter; propertyIter++) {
				const SmartPtrCXmlElement propertyXml =
					thisXml->createAndAddElement("property");
				PropertyXml::add(*propertyIter, propertyXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCPropertyCollectionDoc PropertyCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("PropertyCollectionXml", "parse");

	SmartPtrCPropertyCollectionDoc propertyCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection propertyChildrenXml =
			thisXml->findRequiredChildren("property");

		std::deque<SmartPtrCPropertyDoc> propertyVal;
		if (! propertyChildrenXml.IsNull() && ! propertyChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> propertyXmlIter(*propertyChildrenXml);
				propertyXmlIter; propertyXmlIter++) {
				const SmartPtrCXmlElement propertyXml = propertyXmlIter->second;
				const SmartPtrCPropertyDoc propertyDoc =
					PropertyXml::parse(propertyXml);
				propertyVal.push_back(propertyDoc);
			}
		}

		propertyCollectionDoc.CreateInstance();
		propertyCollectionDoc->initialize(
			propertyVal);
	}
	CAF_CM_EXIT;

	return propertyCollectionDoc;
}

