/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.util.Collections;
import java.util.List;

@GwtCompatible
public class ListAddAllAtIndexTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAllAtIndex_supportedAllPresent() {
        ListAddAllAtIndexTester.assertTrue((String)"addAll(n, allPresent) should return true", (boolean)this.getList().addAll(0, MinimalCollection.of(this.samples.e0)));
        this.expectAdded(0, this.samples.e0);
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAllAtIndex_unsupportedAllPresent() {
        try {
            this.getList().addAll(0, MinimalCollection.of(this.samples.e0));
            ListAddAllAtIndexTester.fail((String)"addAll(n, allPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAllAtIndex_supportedSomePresent() {
        ListAddAllAtIndexTester.assertTrue((String)"addAll(n, allPresent) should return true", (boolean)this.getList().addAll(0, MinimalCollection.of(this.samples.e0, this.samples.e3)));
        this.expectAdded(0, this.samples.e0, this.samples.e3);
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAllAtIndex_unsupportedSomePresent() {
        try {
            this.getList().addAll(0, MinimalCollection.of(this.samples.e0, this.samples.e3));
            ListAddAllAtIndexTester.fail((String)"addAll(n, allPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAllAtIndex_supportedNothing() {
        ListAddAllAtIndexTester.assertFalse((String)"addAll(n, nothing) should return false", (boolean)this.getList().addAll(0, this.emptyCollection()));
        this.expectUnchanged();
    }

    @ListFeature.Require(absent={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAllAtIndex_unsupportedNothing() {
        try {
            ListAddAllAtIndexTester.assertFalse((String)"addAll(n, nothing) should return false or throw", (boolean)this.getList().addAll(0, this.emptyCollection()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAllAtIndex_withDuplicates() {
        MinimalCollection<Object> elementsToAdd = MinimalCollection.of(this.samples.e0, this.samples.e1, this.samples.e0, this.samples.e1);
        ListAddAllAtIndexTester.assertTrue((String)"addAll(n, hasDuplicates) should return true", (boolean)this.getList().addAll(0, elementsToAdd));
        this.expectAdded(0, this.samples.e0, this.samples.e1, this.samples.e0, this.samples.e1);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAllAtIndex_nullSupported() {
        List<Object> containsNull = Collections.singletonList(null);
        ListAddAllAtIndexTester.assertTrue((String)"addAll(n, containsNull) should return true", (boolean)this.getList().addAll(0, containsNull));
        this.expectAdded(0, new Object[]{null});
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAddAllAtIndex_nullUnsupported() {
        List<Object> containsNull = Collections.singletonList(null);
        try {
            this.getList().addAll(0, containsNull);
            ListAddAllAtIndexTester.fail((String)"addAll(n, containsNull) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported addAll(n, containsNull)");
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testAddAllAtIndex_middle() {
        ListAddAllAtIndexTester.assertTrue((String)"addAll(middle, disjoint) should return true", (boolean)this.getList().addAll(this.getNumElements() / 2, this.createDisjointCollection()));
        this.expectAdded(this.getNumElements() / 2, this.createDisjointCollection());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAllAtIndex_end() {
        ListAddAllAtIndexTester.assertTrue((String)"addAll(end, disjoint) should return true", (boolean)this.getList().addAll(this.getNumElements(), this.createDisjointCollection()));
        this.expectAdded(this.getNumElements(), this.createDisjointCollection());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAllAtIndex_nullCollectionReference() {
        try {
            this.getList().addAll(0, null);
            ListAddAllAtIndexTester.fail((String)"addAll(n, null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAllAtIndex_negative() {
        try {
            this.getList().addAll(-1, MinimalCollection.of(this.samples.e3));
            ListAddAllAtIndexTester.fail((String)"addAll(-1, e) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_ADD_WITH_INDEX})
    public void testAddAllAtIndex_tooLarge() {
        try {
            this.getList().addAll(this.getNumElements() + 1, MinimalCollection.of(this.samples.e3));
            ListAddAllAtIndexTester.fail((String)"addAll(size + 1, e) should throw");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }
}

