# -*- coding: utf-8 -*-
# The 'similarities' rule disables warnings about likeness to user guide.
# The 'invalid-name' rule disables warnings about not using upper case style
# for global variables.
# pylint: disable=similarities,invalid-name

"""
Configuration file for the Sphinx documentation builder.

This file does only contain a selection of the most common options. For a
full list see the documentation:
http://www.sphinx-doc.org/en/master/config
"""

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import sys
# sys.path.insert(0, os.path.abspath('.'))

# to avoid "sphinx.errors.SphinxParallelError: RecursionError: maximum recursion depth exceeded
# while pickling an object"
import sys

sys.setrecursionlimit(5000)

# -- Project information -----------------------------------------------------

project = "Stork"
project_copyright = "2021-2023, Internet Systems Consortium"
author = "Internet Systems Consortium"

# get current stork version
version_file = "../../backend/version.go"
release = "UNRELEASED"
with open(version_file, encoding="utf-8") as f:
    for line in f.readlines():
        if line.startswith("const Version"):
            parts = line.split('"')
            release = parts[1]

version = release

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.todo",
    "sphinx.ext.extlinks",
]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

# The Developer's guide is built separately in its own dir.
exclude_patterns = ["user/*"]


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"
html_logo = "../static/stork-square-100px.png"

templates_path = ["_templates"]

html_context = {
    "sidebar_external_links_caption": "Links",
    "sidebar_external_links": [
        (
            '<i class="fa fa-gitlab fa-fw"></i> Source code',
            "https://gitlab.isc.org/isc-projects/stork",
        ),
        (
            '<i class="fa fa-cloud-download fa-fw"></i> Download',
            "https://cloudsmith.io/~isc/repos/stork/packages/",
        ),
        (
            '<i class="fa fa-book fa-fw"></i> Documentation for users',
            "https://stork.readthedocs.io",
        ),
        (
            '<i class="fa fa-bug fa-fw"></i> Issue tracker',
            "https://gitlab.isc.org/isc-projects/stork/-/issues/",
        ),
        (
            '<i class="fa fa-wikipedia-w fa-fw"></i> Wiki',
            "https://gitlab.isc.org/isc-projects/stork/-/wikis/home",
        ),
        (
            '<i class="fa fa-envelope fa-fw"></i> Mailing list (users)',
            "https://lists.isc.org/mailman/listinfo/stork-users",
        ),
        (
            '<i class="fa fa-envelope fa-fw"></i> Mailing list (developers)',
            "https://lists.isc.org/mailman/listinfo/stork-dev",
        ),
    ],
}


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["../static"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ("man/stork-agent.8", "stork-agent", "Stork Agent", author, 8),
    ("man/stork-server.8", "stork-server", "Stork Server", author, 8),
    ("man/stork-tool.8", "stork-tool", "Stork Tool", author, 8),
]

# -- Extension configuration -------------------------------------------------

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


def setup(app):
    """Custom setup hook"""
    if hasattr(app, "add_css_file"):
        app.add_css_file("stork.css")
    else:
        app.add_stylesheet("stork.css")


# External links.
# It allows to link the dev and user docs.
base_user_doc_url = f"https://stork.readthedocs.io/en/v{version}/%s"
extlinks = {"user": (base_user_doc_url, None)}
# Example usage:
# :ud:`Installation page <install.html>`
# Note there is no underscore (_) at the end.
