# Kea Migration Assistant

Kea migration assistant (keama) is an **experimental** tool that works as an
assistance tool that helps migration from ISC-DHCP (that now reached its
End-Of-Life) into Kea, which is a modern DHCP implementation. Keama is based on
ISC DHCP source code. It is able to read an isc-dhcp configuration and produce a
JSON configuration in Kea format. It should be used as a standalone
configuration conversion utility. We do not recommend running this code in a
production DHCP server.

## Limitations

This utility will translate most of your ISC DHCP configuration to the
appropriate format for Kea. Some elements of your ISC DHCP configuration can not
be automatically translated to Kea format. This is because some features of ISC
DHCP are either unsupported, or it work in a different way in Kea vs. ISC DHCP.
Where the utility is unable to translate the configuration, it will insert
messages highlighting what was not translated, with references to issues in the
Kea Gitlab that provide more detail. These sections of the configuration will
require manual review and adjustment.

This Kea migration assistant does not translate the current DHCP lease file.
This works on configuration files only. There is an experimental project to
translate lease files [here](https://gitlab.isc.org/isc-projects/keama-leases).

## Packaged version

ISC provides RPM/deb packages on Cloudsmith here: https://cloudsmith.io/~isc/repos/keama/packages/

## Building from source code

```bash
# First fetch the sources from git repository:
git clone https://gitlab.isc.org/isc-projects/keama.git

#  Configure the build.  If you want to install it somewhere specific use --prefix=<path> parameter
./configure

# Run make to build keama
make

# Install it (optional)
sudo make install
```

The `keama` binary will be available in the `keama` directory.

## Using the Kea migration assistant:

```bash
./keama  {-4|-6} -i <input ISC DHCP config file> -o <output file> -l <hook library path>
```

## Reporting issues

Please share your experiences with the migration. You can open bugs and feature
requests on the project page: https://gitlab.isc.org/isc-projects/keama/-/issues/new

## For developers

Tests are described [here](doc/system-tests.md).

## Web interface

See [doc/web.md](doc/web.md) file that explains how to set up and run basic web
interface for Keama.
