#!/bin/sh
# Copyright (C) 2014  Internet Systems Consortium, Inc. ("ISC")
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
# This script replaces /usr/local, ${prefix}/var and other automake/autoconf
# variables with their actual content.
#
# Invocation:
#
# ./path_replacer.sh input-file.in output-file
#
# This script is initially used to generate configuration files, but it is
# generic and can be used to generate any text files.
#

prefix=/usr/local
sysconfdir=${prefix}/etc
localstatedir=${prefix}/var

echo "Replacing \@prefix\@ with ${prefix}"
echo "Replacing \@sysconfdir\@ with ${sysconfdir}"
echo "Replacing \@localstatedir\@ with ${localstatedir}"

echo "Input file: $1"
echo "Output file: $2"

sed -e "s+\@localstatedir\@+${localstatedir}+g; s+\/usr/local+${prefix}+g; s+\${prefix}/etc+${sysconfdir}+g" $1 > $2
