/*  $Revision: 1.9 $
**
*/
#include <stdio.h>
#include <sys/types.h>
#include "configdata.h"
#include "paths.h"
#include "clibrary.h"
#include "libinn.h"
#include "macros.h"


char *
GetFileConfigValue(value)
    register char	*value;
{
    static char		buff[SMBUF];
    register FILE	*F;
    register int	i;
    register char	*p;
    register char	c;

    /* Read the config file. */
    if ((F = fopen(_PATH_CONFIG, "r")) != NULL) {
	c = *value;
	for (i = strlen(value); fgets(buff, sizeof buff, F) != NULL; ) {
	    if ((p = strchr(buff, '\n')) != NULL)
		*p = '\0';
	    if (buff[0] == '\0' || buff[0] == COMMENT_CHAR)
		continue;
	    if (buff[0] == c && buff[i] == ':' && EQn(buff, value, i)) {
		(void)fclose(F);
		for (p = &buff[i + 1]; ISWHITE(*p); p++)
		    continue;
		return p;
	    }
	}
	(void)fclose(F);
    }
    return NULL;
}


/*
**  Get a configuration parameter, usually from reading the file.
*/
char *
GetConfigValue(value)
    register char	*value;
{
    register char	*p;

    /* Some environment variables override the file. */
    if (EQ(value, _CONF_SERVER)
     && (p = getenv(_ENV_NNTPSERVER)) != NULL)
	return p;
    if (EQ(value, _CONF_ORGANIZATION)
     && (p = getenv(_ENV_ORGANIZATION)) != NULL)
	return p;
    if (EQ(value, _CONF_FROMHOST)
     && (p = getenv(_ENV_FROMHOST)) != NULL)
	return p;

    if ((p = GetFileConfigValue(value)) != NULL)
	return p;

    /* Some values have defaults if not in the file. */
    if (EQ(value, _CONF_FROMHOST) || EQ(value, _CONF_PATHHOST))
	return GetFQDN();
    return NULL;
}
