// Copyright (C) 2011  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

#include <log/message_dictionary.h>
#include <log/message_initializer.h>

namespace isc {
namespace log {

// Constructor.  Just retrieve the global dictionary and load the IDs and
// associated text into it.

MessageInitializer::MessageInitializer(const char* values[]) {
    MessageDictionary& global = MessageDictionary::globalDictionary();
    std::vector<std::string> repeats = global.load(values);

    // Append the IDs in the list just loaded (the "repeats") to the global list
    // of duplicate IDs.
    if (!repeats.empty()) {
        std::vector<std::string>& duplicates = getDuplicates();
        duplicates.insert(duplicates.end(), repeats.begin(), repeats.end());
    }
}

// Return reference to duplicate array

std::vector<std::string>& MessageInitializer::getDuplicates() {
    static std::vector<std::string> duplicates;
    return (duplicates);
}

} // namespace log
} // namespace isc
