// Copyright (C) 2010  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

// $Id: xfrout_client.h 1694 2010-04-08 02:12:21Z jinmei $

#ifndef _XFROUT_CLIENT_H
#define _XFROUT_CLIENT_H

#include <string>

#include <boost/asio.hpp>
#include <exceptions/exceptions.h>

namespace isc {
namespace xfr {

class XfroutError: public Exception {
public:
    XfroutError(const char *file, size_t line, const char *what):
        isc::Exception(file, line, what) {}
};

using boost::asio::local::stream_protocol;
class XfroutClient {
public:
    XfroutClient(const std::string& file):
        socket_(io_service_), file_path_(file) {}

    void connect();
    void disconnect();
    int sendXfroutRequestInfo(int tcp_sock, uint8_t* msg_data,
                              uint16_t msg_len);

private:
    boost::asio::io_service io_service_;
    // The socket used to communicate with the xfrout server.
    stream_protocol::socket socket_;
    const std::string file_path_;
};

} // End for namespace xfr
} // End for namespace isc

#endif

// Local Variables: 
// mode: c++
// End: 
