<!--
 - Copyright (C) Internet Systems Consortium, Inc. ("ISC")
 -
 - This Source Code Form is subject to the terms of the Mozilla Public
 - License, v. 2.0. If a copy of the MPL was not distributed with this
 - file, You can obtain one at http://mozilla.org/MPL/2.0/.
 -
 - See the COPYRIGHT file distributed with this work for additional
 - information regarding copyright ownership.
-->
## Supported platforms

In general, this version of BIND will build and run on any POSIX-compliant
system with a C11-compliant C compiler, BSD-style sockets with RFC-compliant
IPv6 support, POSIX-compliant threads, the `libuv` asynchronous I/O library,
and the OpenSSL cryptography library.  Atomic operations support from the
compiler is needed, either in the form of builtin operations, C11 atomics,
or the `Interlocked` family of functions on Windows.

BIND 9.15 requires fairly recent version of libuv library to run (>= 1.x).  For
some of the older systems listed below, you will have to install updated libuv
package from sources such as EPEL, PPA and other native sources for updated
packages.  The other option is to install libuv from sources.

ISC regularly tests BIND on many operating systems and architectures, but
lacks the resources to test all of them. Consequently, ISC is only able to
offer support on a "best effort" basis for some.

### Regularly tested platforms

As of Dec 2019, BIND 9.15 is fully supported and regularly tested on the
following systems:

* Debian 9, 10
* Ubuntu LTS 16.04, 18.04
* Fedora 30
* Red Hat Enterprise Linux / CentOS 7, 8
* FreeBSD 11.3, 12.0
* OpenBSD 6.5
* Alpine Linux

The amd64, i386, armhf and arm64 CPU architectures are all fully supported.

### Best effort

The following are platforms on which BIND is known to build and run.
ISC makes every effort to fix bugs on these platforms, but may be unable to
do so quickly due to lack of hardware, less familiarity on the part of
engineering staff, and other constraints. With the exception of Windows
Server 2012 R2, none of these are tested regularly by ISC.

* Windows Server 2012 R2, 2016 / x64
* Windows 10 / x64
* macOS 10.12+
* Solaris 11
* NetBSD
* Other Linux distributions still supported by their vendors, such as:
    * Ubuntu 19.04+
    * Gentoo
    * Arch Linux
* OpenWRT/LEDE 17.01+
* Other CPU architectures (mips, mipsel, sparc, ...)

### Community maintained

These systems may not all have easily available the required dependencies for
building BIND although it will be possible in many cases to compile those
directly from source. The community and interested parties may wish to help with
maintenance and we welcome patch contributions, although we cannot guarantee
that we will accept them.  All contributions will be assessed against the risk
of adverse effect on officially supported platforms.

* Platforms past or close to their respective EOL dates, such as:
    * Ubuntu 14.04, 18.10
    * CentOS 6
    * Debian Jessie
    * FreeBSD 10.x

## Unsupported platforms

These are platforms on which BIND 9.15 is known *not* to build or run:

* Platforms without at least OpenSSL 1.0.2
* Windows 10 / x86
* Windows Server 2012 and older
* Solaris 10 and older
* Platforms that don't support IPv6 Advanced Socket API (RFC 3542)
* Platforms that don't support atomic operations (via compiler or library)
* Linux without NPTL (Native POSIX Thread Library)
* Platforms where libuv cannot be compiled

## Platform quirks
