#!/usr/bin/perl -s

# $Id: pcpdump.pl 1039 2010-12-28 05:23:51Z fdupont $

use POSIX;
use Socket;

open(TUN, "db_dump tunnels.db|") or
    open(TUN, "< tunnels.dump") or
    die "can't get tunnels";

my $key;
my $data;
my $mode = 0;

while (<TUN>) {
    next if $_ !~ /^ /;
    # $key = IPv6:16
    # $data = IPv4:4 + start:4
    if ($mode == 0) {
	$key = pack("H*", substr($_, 1));
	$mode = 1;
    } else {
	$data = pack("H*", substr($_, 1));
	$mode = 0;
	my $addr = substr($data, 0, 4);
	my $start = unpack("l", substr($data, 4));
	my $host6 = Socket::inet_ntop(AF_INET6, $key);
	my $host4 = Socket::inet_ntop(AF_INET, $addr);
	my $date = asctime(gmtime($start));
	printf("tunnel %s %s # %s", $host6, $host4, $date);
    }
}
undef $mode;
close(TUN);

open(SNAT, "db_dump snats.db|") or
    open(SNAT, "< snats.dump") or
    die "can't get static nats";

my $mode = 0;

while (<SNAT>) {
    next if $_ !~ /^ /;
    # $key = IPv4:4 + nport:2 + proto:1
    # $data = IPv6:16 + IPv4/src:4 + sport:2 + expire:4 + down:1
    if ($mode == 0) {
	$key = pack("H*", substr($_, 1));
	$mode = 1;
    } else {
	$data = pack("H*", substr($_, 1));
	$mode = 0;
	my $addr = substr($key, 0, 4);
	my ($nport, $proto) = unpack("S C", substr($key, 4));
	my $src = substr($data, 16, 4);
	my ($sport, $expire, $down) = unpack("S l c", substr($data, 20));
	my $host6 = Socket::inet_ntop(AF_INET6, substr($data, 0, 16));
	my $nat4 = Socket::inet_ntop(AF_INET, $addr);
	my $src4 = Socket::inet_ntop(AF_INET, $src);
	my $s;
	if ($proto == Socket::IPPROTO_TCP) {
	    $s = sprintf("nat %s tcp %s %hu %s %hu",
			 $host6, $src4, $sport, $nat4, $sport);
	} elsif ($proto == Socket::IPPROTO_UDP) {
	    $s = sprintf("nat %s udp %s %d %s %d",
			 $host6, $src4, $sport, $nat4, $sport);
	} else {
	    $s = sprintf("nat %s proto%d %s %d %s %d",
			 $host6, $proto, $src4, $sport, $nat4, $sport);
	}
	if ($expire == 0) {
	    if ($down != 0) {
		printf("%s # (down)", $s);
	    } else {
		printf("%s", $s);
	    }
	} else {
	    my $date = asctime(gmtime($expire));
	    if ($down != 0) {
		printf("%s # (down) %s", $s, $date);
	    } else {
		printf("%s # %s", $s, $date);
	    }
	}
    }
}
undef $mode;
close(SNAT);
