//  $Id: proxyagg.cc 1.4 Wed, 10 Mar 1999 16:48:18 -0800 mehringe $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>

/*#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include "dbase.hh"
#include "Node.h"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "aut-num.hh"
#include "Route.hh"
#include "CIDRAdvisor.hh"
#include "radix.hh"

extern void append(addr **,addr *);
extern addr* component_match(addr **,Filter_Action **);

addr* allowed_proxy_aggregates(Pix,Pix,addr*);
addr* check_components(addr *);
void Originate(Route &r, Pix as);
void Announce(Route &r, Pix as);
void Import(Route &r, Pix as, Pix laddr, Pix ras, Pix raddr);

#define PREFIX_DEFAULT_NOT_ALLOWED 0  // default initial state of the addr prefix
#define PREFIX_ALLOWED 1         // addr prefix is allowed
#define PREFIX_NOT_ALLOWED 2


Pix agg_as;
Pix neighbour_as;
int allowed = PREFIX_DEFAULT_NOT_ALLOWED;

addr *allowed_proxy_aggregates(Pix aggregator, Pix neighbour, addr *aggregates) {
    addr *components = NULL;
    addr *proxy_aggs = NULL;

    agg_as = aggregator;
    neighbour_as = neighbour;
    
    if(!aggregates) return(NULL);

    while(aggregates) {

	allowed = PREFIX_DEFAULT_NOT_ALLOWED;
	if((aggregates->rt).origin.size() == 1) 
	  if(((aggregates->rt).origin.head())->pix == agg_as)
	    allowed = PREFIX_ALLOWED;
	  else
	    Originate(aggregates->rt,((aggregates->rt).origin.head())->pix);


	if(allowed == PREFIX_ALLOWED)
	    append(&proxy_aggs, aggregates);
	else {
	    components = NULL;
	    components = check_components(aggregates->components);
	    for(; components ; components = components->next)
		append(&proxy_aggs,components);
	}
	aggregates = aggregates->next;
    }

    return(proxy_aggs);
}





addr* check_components(addr *components) {
    addr *component_list = NULL;
    addr *tmp = NULL;
    radix_node *root = NULL;

    while(components) {

	allowed = PREFIX_DEFAULT_NOT_ALLOWED;
	if(((components->rt).origin.head())->pix == agg_as)
	  allowed = PREFIX_ALLOWED;
	else
	  Originate(components->rt,((components->rt).origin.head())->pix);

	if(allowed == PREFIX_ALLOWED)
	    append(&component_list,components);
	components = components->next;
    }
    
    if(component_list)
        root = radix_create_node(NULL,0,0,NULL,EMPTY);
    else
        return(NULL);

    for(; component_list ; component_list = component_list->next) {
	ListNodePix *p = (component_list->rt).origin.head();
        radix_insert(component_list->prefix,component_list->length,p->pix,root);
    }
    
    radix_aggregate(root);
    component_list = NULL;

    component_list = radix_get_aggs(root);
    tmp = radix_get_nonaggs(root);
    for(; tmp; tmp = tmp->next)
        append(&component_list,tmp);
    radix_delete_tree(root);
    return(component_list);
}



void Originate(Route &r, Pix as) {
   if (!AS_map.define(as))
      return;
   Announce(r, as);
}





void Announce(Route &r, Pix as) {
   ASPolicy *p;
   Filter_Action *fap;
   Filter_Action *ifap;
   InterASPolicy *ip;
   int interas_match;

    if (!AS_map.define(as))
      return;

   AutNum &autnum = *(AutNum *) AS_map.contents(as).definition;

   r.aspath.append((new ListNodePix(as))->l);

   // for each peer
   for (p = autnum.peers.head(); p; p = autnum.peers.next(p->peers)) {
      // for each as-out expression
      for (fap = p->out.head(); fap; fap = p->out.next(fap->falist)) {
         if (fap->filter->match(r)) {
            fap->action->Execute(r);
            interas_match = 0;

            // for each laddr raddr pair
            for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas))
               // for each interas-out expression
               for (ifap = ip->out.head(); 
                    ifap; 
                    ifap = ip->out.next(ifap->falist))
                  if (ifap->filter->match(r)) {
                     interas_match = 1;
                     ifap->action->Execute(r);
                     Import(r, p->peeras, ip->raddress, as, ip->laddress);
		     if(allowed == PREFIX_NOT_ALLOWED) { return; }
                  }

            // left over route
            if (!interas_match) { 
               Import(r, p->peeras, NULL, as, NULL);
	       if(allowed == PREFIX_NOT_ALLOWED) { return; }
            }
         }
      }
   }

   ListNodePix *lnp = r.aspath.tail();
   r.aspath.unlink(lnp->l);
   delete lnp;
}





inline int aspath_loop_check(Route &r, Pix as) {
   for (ListNodePix *p = r.aspath.head(); p; p = r.aspath.next(p->l))
      if (p->pix == as)
         return TRUE;

   return FALSE;
}





inline void check_source_if_not_announce(Route &r, Pix as) {
  int tmp_allowed = FALSE;
  if (as == neighbour_as) {
    for (ListNodePix *p = r.aspath.head(); p; p = r.aspath.next(p->l))
      if(p->pix == agg_as) tmp_allowed = TRUE;
    if(tmp_allowed)
      allowed = PREFIX_ALLOWED; 
     else 
      allowed = PREFIX_NOT_ALLOWED; 
  } else
    Announce(r, as);
}





void Import(Route &r, Pix as, Pix laddr, Pix ras, Pix raddr) {
   ASPolicy *p;
   Filter_Action *fap;
   Filter_Action *ifap;
   InterASPolicy *ip;

   if (!AS_map.define(as))
      return;

   AutNum &autnum = *(AutNum *) AS_map.contents(as).definition;
   int match;

   if (aspath_loop_check(r, as)) // route has a loop
      return;

   for (p = autnum.peers.head(); p; p = autnum.peers.next(p->peers))
      if (p->peeras == ras)
         break;

   if (!p) // this peer does not exist
      return;

   match = 0;
   for (fap = p->in.head(); fap; fap = p->in.next(fap->falist))
      if (fap->filter->match(r)) {
         match = 1;
         fap->action->Execute(r);
         for (ip = p->interas.head(); ip; ip = p->interas.next(ip->interas))
            for (ifap = ip->in.head(); ifap; ifap = ip->in.next(ifap->falist))
               if (ifap->filter->match(r)) {
                  ifap->action->Execute(r);
                  match = 2;
                  check_source_if_not_announce(r, as);
		  if(allowed == PREFIX_NOT_ALLOWED) { return; }
               }
         if (match != 2) { // left over route
            check_source_if_not_announce(r, as);
	    if(allowed == PREFIX_NOT_ALLOWED) { return; }
         }
      }

   if (!match) { // check to see if we default
      for (fap = p->dflt.head(); fap; fap = p->dflt.next(fap->falist))
         if (fap->filter->match(r)) {
            fap->action->Execute(r);
            check_source_if_not_announce(r, as);
	    if(allowed == PREFIX_NOT_ALLOWED) { return; }
         }
   }
}
*/
