/* $Id: cache.hh 1.1 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): eddy@isi.edu
*/

#ifndef __CACHE_HH__
#define __CACHE_HH__

#include <ctime>
#include <cstring>
#include "FixedSizeAllocator.hh"

extern "C" {
int strcasecmp (...);
}

class Cache;

struct CacheElement {
    char *key;
    char *blob;
    int  blob_size;
    int references;

    CacheElement *next;

  public:
    CacheElement (char *k, char *b, int s) {
	next = NULL;
	references = 0;

	key = k;
	blob = b;
	blob_size = s;
    }

    void set (char *k, char *b, int s) {
	next = NULL;
	references = 0;

	key = k;
	blob = b;
	blob_size = s;
    }

    ~CacheElement () {
	delete blob;
	delete key;
    }

    char *get_blob ()   { return blob; }
    int get_blobsize () { return blob_size; }

    void print () {
	printf ("Key: %s (%d)\n", key, blob_size);
	printf ("%s", blob);
    }
};

// just a dumb single linked list, will surely change.
class Cache {
  public:			// XXX
    CacheElement *head, *tail;
    int count;
   FixedSizeAllocator CacheAllocator;

  public:
    Cache () : CacheAllocator(sizeof(CacheElement), 1000) {
	head = tail = NULL;
	count = 0;
    }

    // this will replace an existing entry of the same key
    int add (char *key, char *blob, int size = 0) {
	if (find (key)) {
	    // nope ignore new entries
	    // remove (key);
	    return count;
	}

	CacheElement *elt = (CacheElement *) CacheAllocator.allocate();
	elt->set(key, blob, size);
	
	if (head == NULL) {
	    head = elt;
	    tail = elt;
	} else {
	    tail->next = elt;
	    tail = elt;
	}
	return count++;
    }

    int remove (char *key) {
	CacheElement *elt = find(key);
	if (!elt)
	    return count;
	if (elt == head)
	    head = elt->next;
	if (elt == tail) {
	    CacheElement *nelt;
	    for (nelt = head; nelt && nelt->next != tail; nelt = nelt->next);
	    tail = nelt;
	    if (tail)
		tail->next = NULL;
	}
	delete elt;
	return count--;
    }

    CacheElement *pop () {
	CacheElement *elt = head;
	head = head->next;
	count--;
	return elt;
    }

    CacheElement *find (char *key) {
	CacheElement *elt = head;
	while (elt && elt->key && key) {
	    if (strcasecmp (elt->key, key) == 0) {
		elt->references++;
		return elt;
	    }
	    elt = elt->next;
	}
	return NULL;
    }

    char *get_object (char *key) {
	CacheElement *elt = find(key);
	if (!elt)
	    return NULL;
	elt->references++;
	return elt->blob;
    }

    void print() {
	CacheElement *elt;
	int i;
	for (elt = head, i = 0; elt; elt = elt->next, i++) {
	    printf ("\nCache (%d)\n", count);
	    printf ("Element %d: ", i);
	    elt->print();
	}
    }
};

#endif __CACHE_HH__
