// $Id: Prefask.h 1.5.1.1 Wed, 15 Oct 1997 11:28:18 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef PREFASK_H
#define PREFASK_H

#include "config.hh"
#include <iostream.h>


class Prefask;

char* int2quad(char *buffer, unsigned int i);
unsigned int quad2int(char *quad);
unsigned int ones(unsigned char from, unsigned char to);
unsigned int get_mask(unsigned char length);
ostream& operator<<(ostream& stream, Prefask& p);

class Prefask {
  private:
   unsigned int prefix;
   unsigned char length;
   unsigned char n;
   unsigned char m;

  public:
   Prefask(void);
   Prefask(unsigned int prefix, unsigned char length, 
	   unsigned char n, unsigned char m);
   Prefask(char *name);
   void parse(char *name);
   void define(unsigned int prefix, unsigned char length, 
	       unsigned char n, unsigned char m);
   void print(void);
   int valid(void);
   Prefask& operator=(Prefask& other);
   int operator<(Prefask& other);
   int operator<=(Prefask& other);
   int operator==(Prefask& other);
   int compare(Prefask& other);
   char *get_address(char *buffer);
   unsigned int get_prefix() { return prefix; }
   unsigned char get_length() { return length; }
   unsigned char get_n() { return n; }
   unsigned char get_m() { return m; }
   unsigned int get_mask();
   friend ostream& operator<<(ostream& stream, Prefask& p);
};

#endif
