/* $Id: xx_lexer.y 1.3.1.3 Mon, 02 Feb 1998 18:26:49 -0800 cengiz $
 
  Copyright (c) 1994 by the University of Southern California
  and/or the International Business Machines Corporation.
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and
  its documentation in source and binary forms for lawful
  non-commercial purposes and without fee is hereby granted, provided
  that the above copyright notice appear in all copies and that both
  the copyright notice and this permission notice appear in supporting
  documentation, and that any documentation, advertising materials,
  and other materials related to such distribution and use acknowledge
  that the software was developed by the University of Southern
  California, Information Sciences Institute and/or the International
  Business Machines Corporation.  The name of the USC or IBM may not
  be used to endorse or promote products derived from this software
  without specific prior written permission.

  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
  NON-INFRINGEMENT.

  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
  THE USE OR PERFORMANCE OF THIS SOFTWARE.

  Questions concerning this software should be directed to 
  info-ra@isi.edu.

  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu) */


/* definitions */
%x USEFUL_LINE
%x USELESS_LINE

%{
#include "config.hh"
#include <iostream.h>
#include "RtConfig.hh"
#include "xx_parser.h"
#include "dbase.hh"

#define yylval xxlval
#define LEXER_RETURN(x)  return(x)

typedef struct _KeyWord {
   char *val;
   int num;
} KeyWord;

static KeyWord keywords[] = {
"import",                   KW_IMPORT,
"export",                   KW_EXPORT,
"default",                  KW_DEFAULT,
"networks",                 KW_NETWORKS,
"pkt_filter",               KW_PKT_FILTER,
"outbound_pkt_filter",      KW_OUTBOUND_PKT_FILTER,
"set",                      KW_SET,
"cisco_map_name",           KW_CISCO_MAP_NAME,
"cisco_map_increment_by",            KW_CISCO_MAP_INC,
"cisco_map_first_no",            KW_CISCO_MAP_START,
"cisco_access_list_no",     KW_CISCO_ACCESS_LIST_NO,
"cisco_max_preference",     KW_CISCO_MAX_PREFERENCE,
"sources",                  KW_SOURCE,
NULL,        -1
};

static int get_keyword_num(char *string) {
   int i;

   for (i = 0; keywords[i].val; i++)
      if (!strcmp(keywords[i].val, string))
	 break;

   return(keywords[i].num);
}

extern "C" {
int yywrap () {
   return 1;
}
}

%}

%%

%{
/* Rules */
%}

^@RtConfig {
   BEGIN(USEFUL_LINE);
}

\n {
   ECHO;
   /* simply skip this line, it is not interesting to us */
   LEXER_RETURN((int) *yytext);
}

. {
   ECHO;
   /* simply skip this line, it is not interesting to us */
   BEGIN(USELESS_LINE);
}

<USELESS_LINE>.* {
   ECHO;
   /* simply skip this line, it is not interesting to us */
}

<USELESS_LINE>\n {
   ECHO;
   /* simply skip this line, it is not interesting to us */
   BEGIN(INITIAL);
   LEXER_RETURN((int) *yytext);
}

<USEFUL_LINE>[A-Za-z_-]+ {
   LEXER_RETURN(get_keyword_num(yytext));
}

<USEFUL_LINE>AS[0-9]+ {
   yylval.pi = AS_map.add_entry(yytext);
   LEXER_RETURN(TKN_ASNUM);
}

<USEFUL_LINE>[0-9]+(\.[0-9]+){3,3}\/[0-9]+ {
   yylval.pi = Prefask_map.add_entry(yytext);
   LEXER_RETURN(TKN_PRFMSK);
}

<USEFUL_LINE>[0-9]+ {
   yylval.i = atoi(yytext);
   LEXER_RETURN(TKN_INT);
}

<USEFUL_LINE>\"([^\"]|\\\")*\" { 
   yylval.val = yytext + 1; 
   *(yytext + yyleng - 1) = 0;
   LEXER_RETURN(TKN_STR);
}

<USEFUL_LINE>[ \t,]+ { 
   /* Skip white space */
}

<USEFUL_LINE>\n {
   BEGIN(INITIAL);
   LEXER_RETURN((int) *yytext);
}

<USEFUL_LINE>= {
   LEXER_RETURN((int) *yytext);
}

<USEFUL_LINE>. {
   LEXER_RETURN(TKN_ERROR);
}

%%

/* User Code if any */

