#include <stdio.h>
#include <sys/types.h>
#include <netkey/key.h>
#include <netsec/ipsec.h>

caddr_t ah_shainit __P((struct key_secassoc *));
caddr_t ah_shaupdate __P((caddr_t, caddr_t, int));
caddr_t ah_shafinish __P((caddr_t, caddr_t));

/* Array of function ptrs for the AH authentication algorithms */
static struct auth_algorithm {
  caddr_t (*init)(struct key_secassoc *);       /* ptr to init fn for alg. */
  caddr_t (*update)(caddr_t, caddr_t, int);    /* ptr to update fn for alg */
  caddr_t (*finish)(caddr_t, caddr_t);         /* ptr to finish fn for alg */
  int datalen;                               /* Length (in u_int8_ts) of output 
					       data. MUST be a multiple of 4 */
} auth_algorithms[] = { 
{ ah_shainit, ah_shaupdate, ah_shafinish, 20 },
};

int in6_debug_level = IDL_EVENT;

main()
{
  struct key_secassoc secassoc;
  unsigned char key[]     = { 0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef };
  unsigned char iv[]      = { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 };
  unsigned char plain[]   = { 0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef, 
			      0xfe,0xe1,0xde,0xad,0x42,0x42,0x42,0x42 };
  caddr_t state;
  void *data;

  if (!(data = malloc(auth_algorithms[0].datalen))) {
    fprintf(stderr, "Can't allocate output buffer!\n");
    exit(1);
  }

  memset(&secassoc, 0, sizeof(secassoc));
  secassoc.key = (caddr_t)&key;
  secassoc.keylen = sizeof(key);
  secassoc.iv = (caddr_t)&iv;
  secassoc.ivlen = sizeof(iv);
  secassoc.state = K_INBOUND | K_OUTBOUND;

  if (!(state = auth_algorithms[0].init(&secassoc))) {
    printf("encrypt: init failed\n");
    exit(1);
  }
  state = auth_algorithms[0].update(state, (caddr_t)plain, sizeof(plain));
  auth_algorithms[0].finish(state, data);

  dump_buf(data, auth_algorithms[0].datalen);

  exit(0);
}
