/*----------------------------------------------------------------------
  Portions Copyright 1996 by Larry Bassham, All Rights Reserved.
  The NRL COPYRIGHT NOTICE and LICENSE governs distribution and use of
  this software.

  Portions Copyright 1995 by Bao Phan, Dan McDonald, & Randall Atkinson.
  All Rights Reserved. All Rights have been assigned to the US
  Naval Research Laboratory (NRL). The NRL COPYRIGHT NOTICE and
  LICENSE governs distribution and use of this software.
----------------------------------------------------------------------*/
/*----------------------------------------------------------------------
#	@(#)COPYRIGHT	1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

	This product includes software developed at the Information
	Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/
#include <sys/types.h>
#include <sys/param.h>
#include <sys/malloc.h>
#include <sys/systm.h>

#include <netkey/key.h>
#include <netsec/ipsec.h>

#include "sha.h"

struct SHAstate {
  SHA_CTX isb;               	    /* Internal state block for MD5 */
  struct key_secassoc *assoc;       /* Security association (keys!) */
};

static u_int8_t ipad[64]={0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36};

static u_int8_t epad[64]={0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c};

void static bytnxor __P((u_int8_t *, u_int8_t *, u_int8_t *, int));
int SHAInit __P((SHA_CTX *));
int SHAUpdate __P((SHA_CTX *, BYTE *, int));
int SHAFinal __P((SHA_CTX *));

caddr_t ah_hmacshainit __P((struct key_secassoc *));
caddr_t ah_hmacshaupdate __P((caddr_t, caddr_t, int));
caddr_t ah_hmacshafinish __P((caddr_t, caddr_t));

void
static bytnxor(dest, src1, src2, len)
     u_int8_t	*dest, *src1, *src2;
     int	len;
{
  while ( len-- > 0 ) *dest++ = *src1++ ^ *src2++;
}

/*----------------------------------------------------------------------
  hmacshainit():   Initialize SHA state and stash pertinent
               Security Association away in SHAstate.
----------------------------------------------------------------------*/
caddr_t ah_hmacshainit(assoc)
     struct key_secassoc *assoc;
{
  struct SHAstate *SHAstate = malloc(sizeof(struct SHAstate), M_TEMP, M_NOWAIT);
  int	keylen;
  
  if (SHAstate) {
    u_int8_t xorkey[64];

    keylen=assoc->keylen;
    if (keylen > SHABLOCKLEN) {  /* key needs to be hashed first  */
      SHAInit(&(SHAstate->isb));
      SHAUpdate(&(SHAstate->isb), (u_int8_t *)assoc->key, keylen);
      SHAFinal(&(SHAstate->isb));
      /*  K XOR ipad  */
      bytnxor(xorkey, (u_int8_t *)SHAstate->isb.buffer, ipad, SHAHASHLEN);
      bcopy(ipad+SHAHASHLEN, xorkey+SHAHASHLEN, SHABLOCKLEN-SHAHASHLEN);
    } else {
      /*  K XOR ipad  */
      bytnxor(xorkey, (void *)assoc->key, ipad, keylen);
      bcopy(ipad+keylen, xorkey+keylen, SHABLOCKLEN-keylen);
    }
    SHAInit(&(SHAstate->isb));
    SHAUpdate(&(SHAstate->isb), xorkey, SHABLOCKLEN);
    SHAstate->assoc = assoc;
  }

  return (caddr_t)SHAstate;
};


/*----------------------------------------------------------------------
  hmacshaupdate():  Continue the SHA calculation over some data in the packet.
----------------------------------------------------------------------*/
caddr_t ah_hmacshaupdate(state, data, len)
     caddr_t state;
     caddr_t data;
     int len;
{
  SHAUpdate(&(((struct SHAstate *)state)->isb), (unsigned char *)data, len);
  return state;
};


/*----------------------------------------------------------------------
  hmacshafinish():  Conclude the SHA calculation for AH and return AH data (?).
----------------------------------------------------------------------*/
caddr_t ah_hmacshafinish(state, data)
caddr_t state;
     caddr_t data;
{
  int	keylen;
  u_int8_t	result1[20];
  u_int8_t xorkey[64];
  struct SHAstate *SHAstate = (struct SHAstate *)state;

  SHAFinal(&(SHAstate->isb));
  bcopy(SHAstate->isb.buffer, result1, SHAHASHLEN);
  keylen=SHAstate->assoc->keylen;
  if (keylen > SHABLOCKLEN) {  /* key needs to be hashed first  */
    SHAInit(&(SHAstate->isb));
    SHAUpdate(&(SHAstate->isb), (u_int8_t *)SHAstate->assoc->key, keylen);
    SHAFinal(&(SHAstate->isb));
    /*  K XOR epad  */
    bytnxor(xorkey, (u_int8_t *)SHAstate->isb.buffer, epad, SHAHASHLEN);
    bcopy(epad+SHAHASHLEN, xorkey+SHAHASHLEN, SHABLOCKLEN-SHAHASHLEN);
  } else {
    /*  K XOR epad  */
    bytnxor(xorkey, (void *)SHAstate->assoc->key, epad, keylen);
    bcopy(epad+keylen, xorkey+keylen, SHABLOCKLEN-keylen);
  }
  SHAInit(&(SHAstate->isb));
  SHAUpdate(&(SHAstate->isb), xorkey, SHABLOCKLEN);
  SHAUpdate(&(SHAstate->isb), result1, SHAHASHLEN);
  SHAFinal(&(SHAstate->isb));
  bcopy(SHAstate->isb.buffer, data, SHAHASHLEN);

  free(state, M_TEMP);
  return data;
};
