/* This software is Copyright 1996 by Craig Metz, All Rights Reserved.
   The Inner Net Copyright Notice and License Agreement Version 2
   applies to this software.
*/

#ifndef _GETADDRINFO_H
#define _GETADDRINFO_H

#define AI_PASSIVE      1 /* socket address is intended for bind() */
#define AI_CANONNAME    2 /* request for canonical name */

#define EAI_BADFLAGS     -1 /* invalid value for ai_flags */
#define EAI_NONAME       -2 /* name or service is not known */
#define EAI_AGAIN        -3 /* temporary failure in name resolution */
#define EAI_FAIL         -4 /* non-recoverable failure in name resolution */
#define EAI_NODATA       -5 /* no address associated with name */
#define EAI_FAMILY       -6 /* ai_family not supported */
#define EAI_SOCKTYPE     -7 /* ai_socktype not supported */
#define EAI_SERVICE      -8 /* service not supported for ai_socktype */
#define EAI_ADDRFAMILY   -9 /* address family for name not supported */
#define EAI_MEMORY      -10 /* memory allocation failure */
#define EAI_SYSTEM      -11 /* system error (code indicated in errno) */

struct addrinfo {
  int ai_flags;             /* input flags */
  int ai_family;            /* protocol family for socket */
  int ai_socktype;          /* socket type */
  int ai_protocol;          /* protocol for socket */
  int ai_addrlen;           /* length of socket-address */
  struct sockaddr *ai_addr; /* socket-address for socket */
  char *ai_canonname;       /* canonical name for service location (iff req) */
  struct addrinfo *ai_next; /* pointer to next in list */
};

int getaddrinfo(const char *name, const char *service,
		const struct addrinfo *req, struct addrinfo **pai);

void freeaddrinfo(struct addrinfo *ai);
#endif /* _GETADDRINFO_H */
