% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_RLum.R
\docType{methods}
\name{get_RLum}
\alias{get_RLum}
\alias{get_RLum,list-method}
\alias{get_RLum,NULL-method}
\title{General accessor function for RLum S4 class objects}
\usage{
get_RLum(object, ...)

\S4method{get_RLum}{list}(object, null.rm = FALSE, ...)

\S4method{get_RLum}{`NULL`}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum} or an object of type \link{list} containing only objects
of type \linkS4class{RLum}}

\item{...}{further arguments that will be passed to the object specific methods. For
furter details on the supported arguments please see the class
documentation: \linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Spectrum},
\linkS4class{RLum.Data.Image}, \linkS4class{RLum.Analysis} and \linkS4class{RLum.Results}}

\item{null.rm}{\link{logical} (\emph{with default}): option to get rid of empty and NULL objects}
}
\value{
Return is the same as input objects as provided in the list.
}
\description{
Function calls object-specific get functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the corresponding get function will be selected.
Allowed arguments can be found in the documentations of the corresponding
\linkS4class{RLum} class.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{get_RLum}

\item \code{NULL}: Returns NULL
}}

\section{Function version}{
 0.3.2 (2018-01-21 17:22:38)
}

\examples{

##Example based using data and from the calc_CentralDose() function

##load example data
data(ExampleData.DeValues, envir = environment())

##apply the central dose model 1st time
temp1 <- calc_CentralDose(ExampleData.DeValues$CA1)

##get results and store them in a new object
temp.get <- get_RLum(object = temp1)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2018). get_RLum(): General accessor function for RLum S4 class objects. Function version 0.3.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.6. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
