/*2:*/
#line 70 "./qprint.w"

#include "config.h"                   

#define REVDATE "16th December 2014" \

#define TRUE 1
#define FALSE 0
#define LINELEN 72
#define MAXINLINE 256 \

#define ASCII_HORIZONTAL_TAB 9
#define ASCII_LINE_FEED 10
#define ASCII_CARRIAGE_RETURN 13
#define ASCII_SPACE 32
#define ASCII_0 48
#define ASCII_EQUAL_SIGN 61
#define ASCII_A 65
#define ASCII_LOWER_CASE_A 97 \
 \

#define Character_is_printable_ISO_8859(c) (((((c) >=0x20) &&((c) <=0x7E) ) ||((c) >=0xA1) ) )  \


#line 73 "./qprint.w"


/*4:*/
#line 100 "./qprint.w"

#include <stdio.h> 
#include <stdlib.h> 
#include <ctype.h> 
#ifdef HAVE_STRING_H
#include <string.h> 
#else
#ifdef HAVE_STRINGS_H
#include <strings.h> 
#endif
#endif
#ifdef HAVE_GETOPT
#ifdef HAVE_UNISTD_H
#include <unistd.h> 
#endif
#else
#include "getopt.h"     
#endif

/*:4*/
#line 75 "./qprint.w"

/*5:*/
#line 122 "./qprint.w"

#ifdef _WIN32
#define FORCE_BINARY_IO
#include <io.h> 
#include <fcntl.h> 
#endif

/*:5*/
#line 76 "./qprint.w"

/*6:*/
#line 134 "./qprint.w"

typedef unsigned char byte;

static FILE*fi;
static FILE*fo;

/*:6*//*13:*/
#line 240 "./qprint.w"

typedef enum{Rule_1,Rule_2,Rule_3,Rule_4,Rule_EBCDIC}
character_encoding_rule;
static character_encoding_rule character_class[256];

/*:13*//*22:*/
#line 409 "./qprint.w"

static int current_line_length= 0;

/*:22*//*23:*/
#line 425 "./qprint.w"

static int pending_white_space= 0;

/*:23*//*32:*/
#line 608 "./qprint.w"

#if (SIZEOF_UNSIGNED_LONG == 8) || (SIZEOF_UNSIGNED_LONG_LONG == 0)





typedef unsigned long file_address_type;
#define FILE_ADDRESS_FORMAT_LENGTH "l"
#else




typedef unsigned long long file_address_type;
#define FILE_ADDRESS_FORMAT_LENGTH "ll"
#endif

/*:32*//*33:*/
#line 637 "./qprint.w"

static file_address_type decode_input_stream_position= 0;
static long decode_errors= 0;

/*:33*//*44:*/
#line 813 "./qprint.w"

static int decoding= FALSE;
static int encoding= FALSE;
static int binary_input= FALSE;
static int errcheck= TRUE;
static int EBCDIC_out= FALSE;
static int paranoid= FALSE;

/*:44*/
#line 77 "./qprint.w"

/*34:*/
#line 645 "./qprint.w"

static int read_decode_character(void);

/*:34*//*36:*/
#line 667 "./qprint.w"

static int hex_to_nybble(int ch);

/*:36*/
#line 78 "./qprint.w"


/*:2*//*8:*/
#line 149 "./qprint.w"

static void output_line_break(void)
{
static char line_break[3]= {ASCII_CARRIAGE_RETURN,ASCII_LINE_FEED,0};

fputs(line_break,fo);
current_line_length= 0;
}

/*:8*//*9:*/
#line 170 "./qprint.w"

static void check_line_length(int chars_required)
{
if((current_line_length+chars_required)>=(LINELEN-1)){
putc(ASCII_EQUAL_SIGN,fo);
output_line_break();
}
current_line_length+= chars_required;
}

/*:9*//*10:*/
#line 183 "./qprint.w"

static void emit_literally(int ch)
{
check_line_length(1);
putc(ch,fo);
}

/*:10*//*11:*/
#line 194 "./qprint.w"

static void emit_hex_encoded(int ch)
{
static char hex[16]= {ASCII_0,ASCII_0+1,ASCII_0+2,ASCII_0+3,
ASCII_0+4,ASCII_0+5,ASCII_0+6,
ASCII_0+7,ASCII_0+8,ASCII_0+9,
ASCII_A,ASCII_A+1,ASCII_A+2,ASCII_A+3,
ASCII_A+4,ASCII_A+5};

check_line_length(3);
putc(ASCII_EQUAL_SIGN,fo);
putc(hex[(ch>>4)&0xF],fo);
putc(hex[ch&0xF],fo);
}

/*:11*//*12:*/
#line 221 "./qprint.w"


static void encode(void)
{
int i,ch;

/*14:*/
#line 253 "./qprint.w"


/*15:*/
#line 265 "./qprint.w"

for(i= 0;i<=255;i++){
character_class[i]= Rule_1;
}

/*:15*/
#line 255 "./qprint.w"
;
/*16:*/
#line 273 "./qprint.w"

for(i= 33;i<=60;i++){
character_class[i]= Rule_2;
}

for(i= 62;i<=126;i++){
character_class[i]= Rule_2;
}

/*:16*/
#line 256 "./qprint.w"
;
/*17:*/
#line 285 "./qprint.w"

character_class[ASCII_HORIZONTAL_TAB]= Rule_3;
character_class[ASCII_SPACE]= Rule_3;

/*:17*/
#line 257 "./qprint.w"
;
/*18:*/
#line 295 "./qprint.w"

character_class[ASCII_LINE_FEED]= Rule_4;
character_class[ASCII_CARRIAGE_RETURN]= Rule_4;

/*:18*/
#line 258 "./qprint.w"
;
/*19:*/
#line 306 "./qprint.w"

character_class[33]= 
character_class[34]= 
character_class[35]= 
character_class[36]= 
character_class[64]= 
character_class[91]= 
character_class[92]= 
character_class[93]= 
character_class[94]= 
character_class[96]= 
character_class[123]= 
character_class[124]= 
character_class[125]= 
character_class[126]= Rule_EBCDIC;

/*:19*/
#line 259 "./qprint.w"
;

/*:14*/
#line 227 "./qprint.w"
;

while((ch= getc(fi))!=EOF){
/*20:*/
#line 331 "./qprint.w"

switch(character_class[ch]){
case Rule_1:
/*24:*/
#line 434 "./qprint.w"

if(pending_white_space!=0){
emit_literally(pending_white_space);
pending_white_space= 0;
}

/*:24*/
#line 334 "./qprint.w"
;
emit_hex_encoded(ch);
break;

case Rule_2:
/*24:*/
#line 434 "./qprint.w"

if(pending_white_space!=0){
emit_literally(pending_white_space);
pending_white_space= 0;
}

/*:24*/
#line 339 "./qprint.w"
;
if(paranoid){
emit_hex_encoded(ch);
}else{
emit_literally(ch);
}
break;

case Rule_3:
if(paranoid){
emit_hex_encoded(ch);
}else{
/*24:*/
#line 434 "./qprint.w"

if(pending_white_space!=0){
emit_literally(pending_white_space);
pending_white_space= 0;
}

/*:24*/
#line 351 "./qprint.w"
;
pending_white_space= ch;
}
break;

case Rule_4:
if(binary_input){




/*24:*/
#line 434 "./qprint.w"

if(pending_white_space!=0){
emit_literally(pending_white_space);
pending_white_space= 0;
}

/*:24*/
#line 362 "./qprint.w"
;
emit_hex_encoded(ch);
}else{
/*25:*/
#line 449 "./qprint.w"

{
int chn= getc(fi);

if(chn!=EOF){
if((chn==ASCII_LINE_FEED)||(chn==ASCII_CARRIAGE_RETURN)){
if(chn==ch){
ungetc(chn,fi);
}
}else{
ungetc(chn,fi);
}
}
}

/*:25*/
#line 365 "./qprint.w"
;



if(pending_white_space!=0){
emit_hex_encoded(pending_white_space);
pending_white_space= 0;
}
output_line_break();
}
break;

case Rule_EBCDIC:
/*24:*/
#line 434 "./qprint.w"

if(pending_white_space!=0){
emit_literally(pending_white_space);
pending_white_space= 0;
}

/*:24*/
#line 378 "./qprint.w"
;


if(EBCDIC_out||paranoid){
emit_hex_encoded(ch);
}else{
emit_literally(ch);
}
break;
}

/*:20*/
#line 230 "./qprint.w"
;
}
/*24:*/
#line 434 "./qprint.w"

if(pending_white_space!=0){
emit_literally(pending_white_space);
pending_white_space= 0;
}

/*:24*/
#line 232 "./qprint.w"
;
/*26:*/
#line 471 "./qprint.w"


if(current_line_length> 0){
putc(ASCII_EQUAL_SIGN,fo);
output_line_break();
}


/*:26*/
#line 233 "./qprint.w"
;
}

/*:12*//*21:*/
#line 395 "./qprint.w"

static int is_end_of_line_sequence(int ch)
{
if((ch==ASCII_CARRIAGE_RETURN)||(ch==ASCII_LINE_FEED)){
/*25:*/
#line 449 "./qprint.w"

{
int chn= getc(fi);

if(chn!=EOF){
if((chn==ASCII_LINE_FEED)||(chn==ASCII_CARRIAGE_RETURN)){
if(chn==ch){
ungetc(chn,fi);
}
}else{
ungetc(chn,fi);
}
}
}

/*:25*/
#line 399 "./qprint.w"
;
return TRUE;
}
return FALSE;
}

/*:21*//*28:*/
#line 487 "./qprint.w"


static void decode(void)
{
int ch,ch1,ch2;

while((ch= read_decode_character())!=EOF){
switch(ch){

case ASCII_EQUAL_SIGN:
/*29:*/
#line 529 "./qprint.w"

ch1= read_decode_character();
/*31:*/
#line 579 "./qprint.w"

while(/*30:*/
#line 566 "./qprint.w"

((ch1==ASCII_SPACE)||(ch1==ASCII_HORIZONTAL_TAB))

/*:30*/
#line 580 "./qprint.w"
){
ch1= read_decode_character();
if(is_end_of_line_sequence(ch1)){
break;
}
if(!/*30:*/
#line 566 "./qprint.w"

((ch1==ASCII_SPACE)||(ch1==ASCII_HORIZONTAL_TAB))

/*:30*/
#line 585 "./qprint.w"
){
if(ch1==EOF){
break;
}
/*39:*/
#line 747 "./qprint.w"

if(errcheck){
if(/*41:*/
#line 797 "./qprint.w"

('a'==0x61)

/*:41*/
#line 749 "./qprint.w"
&&
Character_is_printable_ISO_8859(ch1)){

fprintf(stderr,
"Error: invalid character \"%c\" in soft line break sequence at byte %"

FILE_ADDRESS_FORMAT_LENGTH

"u (0x%"

FILE_ADDRESS_FORMAT_LENGTH

"X) of input.\n",
ch1,decode_input_stream_position-1,
decode_input_stream_position-1);
}else{


fprintf(stderr,
"Error: invalid character \"0x%02X\" in soft line break sequence at byte %"

FILE_ADDRESS_FORMAT_LENGTH

"u (0x%"

FILE_ADDRESS_FORMAT_LENGTH

"X) of input.\n",
ch1,decode_input_stream_position-1,
decode_input_stream_position-1);
}
}

/*:39*/
#line 589 "./qprint.w"
;
decode_errors++;
ch1= ASCII_SPACE;
}
}

/*:31*/
#line 531 "./qprint.w"
;
if(ch1==EOF){
fprintf(stderr,"Error: unexpected end of file after soft line break sequence at byte %"

FILE_ADDRESS_FORMAT_LENGTH

"u (0x%"

FILE_ADDRESS_FORMAT_LENGTH

"X) of input.\n",
decode_input_stream_position-1,
decode_input_stream_position-1);
decode_errors++;
}
if(is_end_of_line_sequence(ch1)||(ch1==EOF)){
ch= EOF;
}else{
int n1,n2;

n1= hex_to_nybble(ch1);
ch2= read_decode_character();
n2= hex_to_nybble(ch2);
if(n1==EOF||n2==EOF){
/*38:*/
#line 701 "./qprint.w"

if(errcheck){
if(/*41:*/
#line 797 "./qprint.w"

('a'==0x61)

/*:41*/
#line 703 "./qprint.w"
&&
Character_is_printable_ISO_8859(ch1)&&
Character_is_printable_ISO_8859(ch2)){

fprintf(stderr,
"Error: bad equal sign escape \"=%c%c\" at byte %"

FILE_ADDRESS_FORMAT_LENGTH

"u (0x%"

FILE_ADDRESS_FORMAT_LENGTH

"X) of input.\n",
ch1,ch2,decode_input_stream_position-3,
decode_input_stream_position-3);
}else{


fprintf(stderr,
"Error: bad equal sign escape \"= 0x%02X 0x%02X\" at byte %"

FILE_ADDRESS_FORMAT_LENGTH

"u (0x%"

FILE_ADDRESS_FORMAT_LENGTH

"X) of input.\n",
ch1,ch2,decode_input_stream_position-3,
decode_input_stream_position-3);
}
}

/*:38*/
#line 555 "./qprint.w"
;
decode_errors++;
}
ch= (n1<<4)|n2;
}

/*:29*/
#line 497 "./qprint.w"
;
if(ch!=EOF){
putc(ch,fo);
}
break;

case ASCII_CARRIAGE_RETURN:
case ASCII_LINE_FEED:
/*25:*/
#line 449 "./qprint.w"

{
int chn= getc(fi);

if(chn!=EOF){
if((chn==ASCII_LINE_FEED)||(chn==ASCII_CARRIAGE_RETURN)){
if(chn==ch){
ungetc(chn,fi);
}
}else{
ungetc(chn,fi);
}
}
}

/*:25*/
#line 505 "./qprint.w"
;
putc('\n',fo);
break;

default:
putc(ch,fo);
break;
}
}
}

/*:28*//*35:*/
#line 652 "./qprint.w"

static int read_decode_character(void)
{
int ch;

ch= getc(fi);
if(ch!=EOF){
decode_input_stream_position++;
}
return ch;
}

/*:35*//*37:*/
#line 674 "./qprint.w"


static int hex_to_nybble(int ch)
{
if((ch>=ASCII_0)&&(ch<=(ASCII_0+9))){
return ch-'0';
}else if((ch>=ASCII_A)&&(ch<=(ASCII_A+5))){
return 10+(ch-ASCII_A);
}else if((ch>=ASCII_LOWER_CASE_A)&&(ch<=(ASCII_LOWER_CASE_A+5))){
return 10+(ch-ASCII_LOWER_CASE_A);
}
return EOF;
}

/*:37*//*49:*/
#line 1038 "./qprint.w"


static void usage(void)
{

printf("%s  --  Encode/decode file as Quoted-Printable.  Call:\n",PRODUCT);
printf("            %s [-e / -d] [options] [infile] [outfile]\n",PRODUCT);
printf("\n");
printf("Options:\n");
printf("           -b, --binary      Treat input as pure binary file\n");
printf("           --copyright       Print copyright information\n");
printf("           -d, --decode      Decode Quoted-Printable encoded file\n");
printf("           -e, --encode      Encode file into Quoted-Printable\n");
printf("           -i, --ebcdic      EBCDIC-compatible encoding output\n");
printf("           -n, --noerrcheck  Ignore errors when decoding\n");
printf("           -p, --paranoid    Paranoid: quote even printable characters\n");
printf("           -u, --help        Print this message\n");
printf("           --version         Print version number\n");
printf("\n");
printf("by John Walker\n");
printf("http://www.fourmilab.ch/\n");
}

/*:49*//*51:*/
#line 1076 "./qprint.w"


int main(int argc,char*argv[])
{
extern char*optarg;
extern int optind;

int f,opt;
#ifdef FORCE_BINARY_IO
int in_std= TRUE,out_std= TRUE;
#endif
char*cp;






fi= stdin;
fo= stdout;

/*45:*/
#line 837 "./qprint.w"

for(;;){

opt= getopt(argc,argv,"bdeinpu-:");
if(opt==-1){
break;
}

if(opt=='-'){





if(islower(optarg[0])){
opt= toupper(optarg[0]);
}
}

switch(opt){



case'b':
case'B':
binary_input= TRUE;
break;

case'C':
printf("This program is in the public domain.\n");
return 0;

case'd':
case'D':
decoding= TRUE;
break;

case'e':
encoding= TRUE;
break;

case'E':
/*46:*/
#line 921 "./qprint.w"

switch(optarg[1]){
case'b':
EBCDIC_out= TRUE;
break;

case'n':
encoding= TRUE;
break;

default:

fprintf(stderr,"Invalid option: --%s\n",optarg);
return 2;
}

/*:46*/
#line 879 "./qprint.w"
;
break;

case'H':
usage();
return 0;

case'i':
EBCDIC_out= TRUE;
break;

case'n':
case'N':
errcheck= FALSE;
break;

case'p':

case'P':
paranoid= TRUE;
break;

case'u':
case'?':
usage();
return 0;

case'V':
/*50:*/
#line 1064 "./qprint.w"

printf("%s %s\n",PRODUCT,VERSION);
printf("Last revised: %s\n",REVDATE);
printf("The latest version is always available\n");
printf("at http://www.fourmilab.ch/webtools/qprint/\n");

/*:50*/
#line 907 "./qprint.w"
;
return 0;

default:

fprintf(stderr,"Invalid option: --%s\n",optarg);
return 2;
}
}

/*:45*/
#line 1097 "./qprint.w"
;
/*47:*/
#line 942 "./qprint.w"

if(encoding&&decoding){

fprintf(stderr,"Cannot simultaneously encode and decode.\n");
return 2;
}
if(!(encoding||decoding)){

fprintf(stderr,"Please specify --encode (-e) or --decode (-d).\n");
return 2;
}

/*:47*/
#line 1098 "./qprint.w"
;
/*48:*/
#line 969 "./qprint.w"

f= 0;
for(;optind<argc;optind++){
cp= argv[optind];
switch(f){













case 0:
if(strcmp(cp,"-")!=0){
if((fi= fopen(cp,
#ifdef FORCE_BINARY_IO
"rb"
#else
"r"
#endif
))==NULL){

fprintf(stderr,"Cannot open input file %s\n",cp);
return 2;
}
#ifdef FORCE_BINARY_IO
in_std= FALSE;
#endif
}
f++;
break;

case 1:
if(strcmp(cp,"-")!=0){
if((fo= fopen(cp,
#ifdef FORCE_BINARY_IO
(decoding&&(!binary_input))?"w":"wb"
#else
"w"
#endif
))==NULL){

fprintf(stderr,"Cannot open output file %s\n",cp);
return 2;
}
#ifdef FORCE_BINARY_IO
out_std= FALSE;
#endif
}
f++;
break;

default:

fprintf(stderr,"Too many file names specified.\n");
usage();
return 2;
}
}

/*:48*/
#line 1099 "./qprint.w"
;
/*52:*/
#line 1123 "./qprint.w"

#ifdef FORCE_BINARY_IO
if(in_std){
#ifdef _WIN32
_setmode(_fileno(fi),O_BINARY);
#endif
}
if(((!decoding)||binary_input)&&out_std){
#ifdef _WIN32
_setmode(_fileno(fo),O_BINARY);
#endif
}
#endif

/*:52*/
#line 1100 "./qprint.w"
;

if(decoding){
decode();
}else{
encode();
}
return decode_errors?1:0;
}

/*:51*/
