package Lingua::StopWords::HU;

use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( getStopWords ) ] ); 
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our $VERSION = 0.08;

sub getStopWords {
    if ( @_ and $_[0] eq 'UTF-8' ) {
        # adding U0 causes the result to be flagged as UTF-8
        my %stoplist = map { ( pack("U0a*", $_), 1 ) } qw( 
            a ahogy ahol aki akik akkor alatt által általában amely
            amelyek amelyekben amelyeket amelyet amelynek ami amit amolyan
            amíg amikor át abban ahhoz annak arra arról az azok azon azt
            azzal azért aztán azután azonban bár be belül benne cikk
            cikkek cikkeket csak de e eddig egész egy egyes egyetlen
            egyéb egyik egyre ekkor el elég ellen elõ elõször elõtt
            elsõ én éppen ebben ehhez emilyen ennek erre ez ezt ezek
            ezen ezzel ezért és fel felé hanem hiszen hogy hogyan igen
            így illetve ill. ill ilyen ilyenkor ison ismét itt jó jól
            jobban kell kellett keresztül keressünk ki kívül között
            közül legalább lehet lehetett legyen lenne lenni lesz lett
            maga magát majd majd már más másik meg még mellett mert
            mely melyek mi mit míg miért milyen mikor minden mindent
            mindenki mindig mint mintha mivel most nagy nagyobb nagyon ne
            néha nekem neki nem néhány nélkül nincs olyan ott össze
            õ õk õket pedig persze rá s saját sem semmi sok sokat
            sokkal számára szemben szerint szinte talán tehát teljes
            tovább továbbá több úgy ugyanis új újabb újra után
            utána utolsó vagy vagyis valaki valami valamint való vagyok
            van vannak volt voltam voltak voltunk vissza vele viszont volna 
        );
        return \%stoplist;
    }
    else {
        my %stoplist = map { ( $_, 1 ) } qw( 
            a ahogy ahol aki akik akkor alatt ltal ltalban amely amelyek
            amelyekben amelyeket amelyet amelynek ami amit amolyan amg
            amikor t abban ahhoz annak arra arrl az azok azon azt azzal
            azrt aztn azutn azonban br be bell benne cikk cikkek
            cikkeket csak de e eddig egsz egy egyes egyetlen egyb egyik
            egyre ekkor el elg ellen el elszr eltt els n ppen ebben
            ehhez emilyen ennek erre ez ezt ezek ezen ezzel ezrt s fel
            fel hanem hiszen hogy hogyan igen gy illetve ill. ill ilyen
            ilyenkor ison ismt itt j jl jobban kell kellett keresztl
            keressnk ki kvl kztt kzl legalbb lehet lehetett legyen
            lenne lenni lesz lett maga magt majd majd mr ms msik meg
            mg mellett mert mely melyek mi mit mg mirt milyen mikor
            minden mindent mindenki mindig mint mintha mivel most nagy
            nagyobb nagyon ne nha nekem neki nem nhny nlkl nincs olyan
            ott ssze  k ket pedig persze r s sajt sem semmi sok sokat
            sokkal szmra szemben szerint szinte taln teht teljes tovbb
            tovbb tbb gy ugyanis j jabb jra utn utna utols vagy
            vagyis valaki valami valamint val vagyok van vannak volt
            voltam voltak voltunk vissza vele viszont volna 
        );
        return \%stoplist;
    }
}

1;
