Geg est une calculatrice numérique et graphique.

1] Caractéristiques principales

Le but principal de geg est de tracer des courbes 2D
définies par des fonctions mathématiques. La représentation
graphique associée apparaît instantanément dans la
fenêtre principale, et peut être exportée aux formats
EPS, PDF ou SVG.

Plusieurs courbes et fonctions peuvent être tracées sur
la même fenêtre graphique. 4 modes sont disponibles :
- Cartésien:    y=f(x)
- Polaire:      t→r(t)
- Paramétrique: t→(x,y)
- Suite:        n→u(n)

La commutation est faite avec les boutons ad hoc de la
barre d'outils, ou en utilisant les fonctions spéciales
cart, polar, param, sequ, voir plus loin pour plus de
détails.

Les symboles x, y désignent les coordonnées du plan,
t est utilisé comme variable dans les modes paramétrique
et polaire. En polaire, t désigne l'angle en radian, et
r est la distance à l'origine, soit r=sqrt(x^2+y^2).

En mode suite, n est une valeur entière utilisée
comme indice de la suite à représenter. La suite
est calculée de la valeur n=nmin à la valeur n=nmax
si nmax est spécifié. Les paramètres tmin ou tmax
peuvent aussi être utilisés. Sinon, la suite est
calculée pour toutes les valeurs de n visibles sur
l'écran.

L'entrée de texte du bas est utilisée pour saisir la
fonction à évaluer ou dessiner. Toutes les variables a-z
(sauf e=exp(1)=2.718 ... et les coordonnées x, y, t, r)
peuvent être utilisées en tant que paramètres additionnels.
Sauf pour e, elles sont préaffectées à 0 au démarrage,
et sont gardées inchangées jusqu'à ce qu'elles soient
affectées à une autre valeur par une opération ultérieure,
ou réinitialisées à 0 par un clic sur le bouton de
réinitialisation. Une telle affectation se fait par
exemple par

g=0.5772156649015328

Plusieurs calculs ou affectations peuvent être effectuées
dans une même ligne de commande en les séparant par le
symbole ";" , par exemple, en saisissant

m=pi/6;x=cos(m*t);y=sin(2*m*t)

Toute séquence de calculs peut être sauvegradée dans une
"feuille de calculs" sous forme d'un fichier *.geg qui
spécifie l'ensemble des paramètres à évaluer et des
fonctions à représenter. Ces fichiers peuvent ensuite
être réouverts par geg.

2] Liste des fonctions et opérateurs prédéfinis

Les fonctions suivantes sont reconnues :
    sin       (sinus)
    cos       (cosinus)
    tan       (tangent)
    cot       (cotangent, également cotan)
    sec       (secant)
    csc       (cosecant)
    asin      (arc-sinus, également arcsin)
    acos      (arc-cosinus, également arccos)
    atan      (arc-tan, également arctan)
    acot      (arc-cotan, également arccot)
    acsc      (arc-cosecant, également acsc)
    sinc      (sinus-cardinal = sin(pi*x)/pi*x)
    sinh      (sinus hyperbolique)
    cosh      (cosinus hyperbolique)
    tanh      (tangente hyperbolique)
    exp       (exponentielle naturelle)
    log       (logarithme base 10)
    ln        (logarithme naturel, base e)
    floor     (partie entière)    
    gamma     (fonction Gamma)
    sqrt      (racine carrée)
    cbrt      (racine cubique)
    abs       (valeur absolue)
    sign      (fonction signe)
    char      (fonction caractéristique x>=0)

Fonctions et opérateurs spéciaux
    clip      (restriction aux valeurs >=0 de l'argument)
    cut       (restriction aux valeurs  >0 de l'argument)
    cart      (passer en mode cartésien)
    polar     (passer en mode polaire)
    param     (passer en mode paramétrique)
    sequ      (passer en mode représentation de suite)    
    '         (opérateur de dérivation d'une fonction)
    int       (opérateur d'intégration)    
    tgt       (opérateur de tangente affine)
    

Les constantes suivantes sont reconnues :
    pi        (3.141592653....)
    e         (2.718281828....)
(mais e est un paramètre comme les autres et peut être
réaffecté à une autre valeur.)

Les opérateurs binaires suivants sont reconnus:
    + (Ajouter)
    - (Soustraire)
    * (Multiplier)
    / (Diviser)
    ^ (Élever à la puissance)
    = (Affectation,équations)

Les symboles divers suivants sont reconnus:
    (          (parenthèse gauche)
    )          (parenthèse droite)
    [          (crochet gauche)
    ]          (crochet droit)
    {          (accolade gauche)
    }          (accolade droite)
   a-z         (paramètres/variables)


3] Caractères spéciaux, directives

Ces modes ne produisent aucun tracé graphique et sont
destinés à effecter des calculs ou à initialiser des
paramètres.

a] Mode évaluation (?)

Le mode évaluation est activé en commençant la ligne
de commande par le caractère ?. De cette manère, geg
peut être utilisé comme une calculatrice numérique.
La précision est celle du type C "double", soit
environ 15-16 chiffres significatifs. Ainsi

?a=3,7;b=-1.2;a^b
va afficher: = 0.208045310600227

b] Résolution d'équations (=)

Toute entrée de la forme "=f(x)" initie un calcul des
racines de f(x)=0 par un procédé de dichotomie, en
restriction à l'intervalle réel tmin < x < tmax, ou
xmin < x < xmax si tmin, tmax ne sont pas spécifiés.

Les boutons de souris peuvent également être utilisés
sur la fenêtre graphique pour effectuer des résolutions
d'équations dans la zone sélectionnée. Voici les
actions possibles des boutons :

- Bouton gauche : sélection de la zone à zoomer
- Bouton du milieu : trouver les intersections f(x)=g(x)
- Bouton droit : résoudre f(x)=0

c] Définition de paramètres ou de fonctions (&)

Le caractère initial & est utilisé pour introduire
la définition de paramètres ou de fonctions. Par exemple

&c=2.31*sin(pi/7)

affecte la valeur spécifiée à la variable c.

Les paramètres tmin, tmax, amin, amax (bornes pour t,
et pour l'angle polaire, respectivement) sont également
assignables, par exemple via

&amax=7*pi

Les chaînes de caractères à 2 lettres lettres fa ... fz
sont réservées pour la définition de fonctions utilisateur.
Ces fonctions peuvent être appelées plus tard, à partir
de la feuille de calcul, exactement comme les fonctions
prédéfinies. La syntaxe pour définir une nouvelle
fonction fc(p) de la variable p utilise aussi & comme
marqueur initial : on peut définir par exemple

&fc(p)=sin(p*p)

Les variables a-z peut être indifféremment utilisées
dans la définition des fonctions, et celle-ci peut
inclure d'autres paramètres (éviter tout de même les
variables x, y, r, t qui sont réservées aux coordonnées).
Au moment de l'appel de telles fonctions, les paramètres
doivent avoir été préalablement initialisés à une valeur
(sinon le résultat sera indéfini). Une seule définition
de fonction est permise par ligne de calculs.

Si la fonction ff a déjà été définie,

&fg=ff'

introduit fg comme étant la dérivée de ff. Deux autres
constructions apparentées sont

&fs=int_c_ff
&ft=tgt_c_ff

Ceci définit fs(x) comme étant l'intégrale indéfinie de
ff s'annulant en c (intégrale de ff prise entre c et x),
et ft comme étant la fonction linéaire affine
qui représente la tangente à y = ff (x) au point x=c,
à savoir

ft(x)=ff'(c)(x-c) + ff(c)

c est utilisé ici comme paramètre formel qui doit être
préalablement spécifié pour pouvoir tracer la primitive,
respectivement la tangente, par exemple en saisissant

&c=0;
fs(x)
&c=2*pi
ft(x)

Les paramètres spéciaux der_step, et tgt_right, tgt_left
sont respectivement le pas (relatif) utilisé pour calculer
la différentiation numérique (0.001 par défaut), le
la taille relative du segment de tangente à tracer sur
la droite et sur la gauche (la valeur par défaut
est 100 qui donne une demi-tangente infinie sur le côté
correspondant). Enfin int_step est le pas absolu utilisé
pour l'intégration numérique (0.005 par défaut). On peut
par exemple saisir

&der_step=0.003
&int_step=0.002
&tgt_left=0;tgt_right=100

La dernière ligne correspond au choix d'une demi-tangente
infinie sur la droite.

Le paramètre 'gap' est utilisé pour détecter les
singularités et discontinuités. La valeur par défaut est

&gap=1.0

Des valeurs plus petites de 'gap' augmentent la
sensibilité de la détection, mais peuvent conduire
à ce que des parties de graphe soient perdues autour
des discontinuités.

d] Couleurs et épaisseur de ligne des courbes

Les directives

&lw=0.35
&color=127096008

qui peuvent être également être concaténées avec le
caractère ; comme suit :

&lw=0.35;color=127096008

spécifient une épaisseur de ligne égal à 0.35 et une
couleur RVB avec rouge=127/255, vert=96/255, bleu=8/255.
Ces paramètres s'appliquent aux courbes qui sont tracées
ensuite, jusqu'à ce que de nouvelles valeurs des
paramètres soient définies.

Les paramètres lw et color sont considérés comme non
spécifiés si on leur donne des valeurs négatives, par
exemple -1. Dans ce cas geg utilise les valeur de lw
globale par défault (lw=0.5) et la palette de couleurs
par défaut en fonction du numéro de la courbe.

La couleur et l'épaisseur de ligne des axes, ainsi que
la couleur des valeurs numériques de x, y, t peuvent
être spécifiées grâce au menu "Préférences".

e] Suites

Le 'mode suite' eut être activé grâce à la directive

&sequ

Dans ce contexte, le paramètre spécial 'ptrad' spécifie
le rayon des points représentant les valeurs (n,u(n)) de
la suite. Ce paramètre est affecté en posant par exemple

&ptrad=2

Les paramètres nmin et nmax peuvent être affectés pour
spécifier l'intervalle de calcul de la suite :

&nmin=3


f] Commentaires

Toute chaîne de caractères commençant par # est
considérée comme un commentaire. Une telle chaîne est
reproduite à l'identique dans la feuille de calculs,
sans induire quelque action que ce soit. Les lignes
blanches peuvent être créees en saisissant la chaîne
de 2 caractères "##".


4] Expressions symboliques formelles de geg

La notation étendue "Backus Naur" (EBNF) utilisée dans
geg est:
    <expression> :: = [ + | - ] <terme> { + | - <terme> } 
    <terme>      :: = <facteur> { * | / | ^ <facteur>}
    <facteur>    :: = <nombre> | <fonction> | (<expression>)
    <nombre>     :: = <flottant> | e pi | a-z
    <fonction>   :: = <nom_fonction>(<expression>);
