% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitIndices.R
\name{moreFitIndices}
\alias{moreFitIndices}
\title{Calculate more fit indices}
\usage{
moreFitIndices(object, fit.measures = "all", nPrior = 1)
}
\arguments{
\item{object}{The lavaan model object provided after running the \code{cfa},
\code{sem}, \code{growth}, or \code{lavaan} functions.}

\item{fit.measures}{Additional fit measures to be calculated. All additional
fit measures are calculated by default}

\item{nPrior}{The sample size on which prior is based. This argument is used
to compute BIC*.}
}
\value{
\enumerate{
 \item \code{gammaHat}: Gamma Hat
 \item \code{adjGammaHat}: Adjusted Gamma Hat
 \item \code{baseline.rmsea}: RMSEA of the Baseline (Null) Model
 \item \code{aic.smallN}: Corrected (for small sample size) Akaike Information Criterion
 \item \code{bic.priorN}: Bayesian Information Criterion with specified prior sample size
 \item \code{sic}: Stochastic Information Criterion
 \item \code{hqc}: Hannan-Quinn Information Criterion
 \item \code{gammaHat.scaled}: Gamma Hat using scaled \eqn{\chi^2}
 \item \code{adjGammaHat.scaled}: Adjusted Gamma Hat using scaled \eqn{\chi^2}
 \item \code{baseline.rmsea.scaled}: RMSEA of the Baseline (Null) Model using scaled \eqn{\chi^2}
}
}
\description{
Calculate more fit indices that are not already provided in lavaan.
}
\details{
Gamma Hat (gammaHat; West, Taylor, & Wu, 2012) is a global fit index which
can be computed (assuming equal number of indicators across groups) by

\deqn{ gammaHat =\frac{p}{p + 2 \times \frac{\chi^{2}_{k} - df_{k}}{N}} ,}

where \eqn{p} is the number of variables in the model, \eqn{\chi^{2}_{k}} is
the \eqn{\chi^2} test statistic value of the target model, \eqn{df_{k}} is
the degree of freedom when fitting the target model, and \eqn{N} is the
sample size (or sample size minus the number of groups if \code{mimic} is
set to \code{"EQS"}).

Adjusted Gamma Hat (adjGammaHat; West, Taylor, & Wu, 2012) is a global fit
index which can be computed by

\deqn{ adjGammaHat = \left(1 - \frac{K \times p \times (p + 1)}{2 \times
df_{k}} \right) \times \left( 1 - gammaHat \right) ,}

where \eqn{K} is the number of groups (please refer to Dudgeon, 2004 for the
multiple-group adjustment for agfi*).

Corrected Akaike Information Criterion (aic.smallN; Burnham & Anderson,
2003) is a corrected version of AIC for small sample size, often abbreviated
AICc:

\deqn{ aic.smallN = AIC + \frac{2k(k + 1)}{N - k - 1},}

where \eqn{AIC} is the original AIC: \eqn{-2 \times LL + 2k} (where \eqn{k}
= the number of estimated parameters in the target model). Note that AICc is
a small-sample correction derived for univariate regression models, so it is
probably \emph{not} appropriate for comparing SEMs.

Corrected Bayesian Information Criterion (bic.priorN; Kuha, 2004) is similar
to BIC but explicitly specifying the sample size on which the prior is based
(\eqn{N_{prior}}).

\deqn{ bic.priorN = f + k\log{(1 + N/N_{prior})},}

Stochastic information criterion (SIC; Preacher, 2006) is similar to AIC or
BIC. This index will account for model complexity in the model's function
form, in addition to the number of free parameters. This index will be
provided only when the \eqn{\chi^2} value is not scaled. The SIC can be
computed by

\deqn{ sic = \frac{1}{2}\left(f - \log{\det{I(\hat{\theta})}}\right),}

where \eqn{I(\hat{\theta})} is the information matrix of the parameters.

Hannan-Quinn Information Criterion (hqc; Hannan & Quinn, 1979) is used for
model selection similar to AIC or BIC.

\deqn{ hqc = f + 2k\log{(\log{N})},}

Note that if Satorra--Bentler or Yuan--Bentler's method is used, the fit
indices using the scaled \eqn{\chi^2} values are also provided.

See \code{\link{nullRMSEA}} for the further details of the computation of
RMSEA of the null model.
}
\examples{

HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 '

fit <- cfa(HS.model, data = HolzingerSwineford1939)
moreFitIndices(fit)

fit2 <- cfa(HS.model, data = HolzingerSwineford1939, estimator = "mlr")
moreFitIndices(fit2)

}
\references{
Burnham, K., & Anderson, D. (2003). \emph{Model selection and
multimodel inference: A practical--theoretic approach}. New York, NY:
Springer--Verlag.

Dudgeon, P. (2004). A note on extending Steiger's (1998) multiple sample
RMSEA adjustment to other noncentrality parameter-based statistic.
\emph{Structural Equation Modeling, 11}(3), 305--319.
doi:10.1207/s15328007sem1103_1

Kuha, J. (2004). AIC and BIC: Comparisons of assumptions and performance.
\emph{Sociological Methods Research, 33}(2), 188--229.
doi:10.1177/0049124103262065

Preacher, K. J. (2006). Quantifying parsimony in structural equation
modeling. \emph{Multivariate Behavioral Research, 43}(3), 227-259.
doi:10.1207/s15327906mbr4103_1

West, S. G., Taylor, A. B., & Wu, W. (2012). Model fit and model selection
in structural equation modeling. In R. H. Hoyle (Ed.), \emph{Handbook of
Structural Equation Modeling} (pp. 209--231). New York, NY: Guilford.
}
\seealso{
\itemize{ \item \code{\link{miPowerFit}} For the modification
indices and their power approach for model fit evaluation \item
\code{\link{nullRMSEA}} For RMSEA of the null model }
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})

Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})

Aaron Boulton (University of North Carolina, Chapel Hill; \email{aboulton@email.unc.edu})

Ruben Arslan (Humboldt-University of Berlin, \email{rubenarslan@gmail.com})

Yves Rosseel (Ghent University; \email{Yves.Rosseel@UGent.be})
}
