% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poll.R
\name{poll}
\alias{poll}
\title{Poll for process I/O or termination}
\usage{
poll(processes, ms)
}
\arguments{
\item{processes}{A list of connection objects or\code{process} objects to
wait on. (They can be mixed as well.) If this is a named list, then
the returned list will have the same names. This simplifies the
identification of the processes.}

\item{ms}{Integer scalar, a timeout for the polling, in milliseconds.
Supply -1 for an infitite timeout, and 0 for not waiting at all.}
}
\value{
A list of character vectors of length one or three.
There is one list element for each connection/process, in the same
order as in the input list. For connections the result is a single
string scalar. For processes the character vectors' elements are named
\code{output}, \code{error} and \code{process}. Possible values for each individual
result are: \code{nopipe}, \code{ready}, \code{timeout}, \code{closed}, \code{silent}.
See details about these below. \code{process} refers to the poll connection,
see the \code{poll_connection} argument of the \code{process} initializer.
}
\description{
Wait until one of the specified connections or processes produce
standard output or error, terminates, or a timeout occurs.
}
\section{Explanation of the return values}{

\itemize{
\item \code{nopipe} means that the stdout or stderr from this process was not
captured.
\item \code{ready} means that the connection or the stdout or stderr from this
process are ready to read from. Note that end-of-file on these
outputs also triggers \code{ready}.
\item timeout`: the connections or processes are not ready to read from
and a timeout happened.
\item \code{closed}: the connection was already closed, before the polling
started.
\item \code{silent}: the connection is not ready to read from, but another
connection was.
}
}

\examples{
## Different commands to run for windows and unix
\dontrun{
cmd1 <- switch(
  .Platform$OS.type,
  "unix" = c("sh", "-c", "sleep 1; ls"),
  c("cmd", "/c", "ping -n 2 127.0.0.1 && dir /b")
)
cmd2 <- switch(
  .Platform$OS.type,
  "unix" = c("sh", "-c", "sleep 2; ls 1>&2"),
  c("cmd", "/c", "ping -n 2 127.0.0.1 && dir /b 1>&2")
)

## Run them. p1 writes to stdout, p2 to stderr, after some sleep
p1 <- process$new(cmd1[1], cmd1[-1], stdout = "|")
p2 <- process$new(cmd2[1], cmd2[-1], stderr = "|")

## Nothing to read initially
poll(list(p1 = p1, p2 = p2), 0)

## Wait until p1 finishes. Now p1 has some output
p1$wait()
poll(list(p1 = p1, p2 = p2), -1)

## Close p1's connection, p2 will have output on stderr, eventually
close(p1$get_output_connection())
poll(list(p1 = p1, p2 = p2), -1)

## Close p2's connection as well, no nothing to poll
close(p2$get_error_connection())
poll(list(p1 = p1, p2 = p2), 0)
}
}
