% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree}
\alias{tree}
\title{Tree}
\usage{
tree(object = NULL)
}
\arguments{
\item{object}{the \code{commit} or \code{stash} object}
}
\value{
A S3 class git_tree object
}
\description{
Get the tree pointed to by a commit or stash.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a first user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

tree(last_commit(repo))
}
}
