% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{commits}
\alias{commits}
\title{Commits}
\usage{
commits(repo = ".", topological = TRUE, time = TRUE, reverse = FALSE,
  n = NULL)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{topological}{Sort the commits in topological order (parents
before children); can be combined with time sorting. Default
is TRUE.}

\item{time}{Sort the commits by commit time; Can be combined with
topological sorting. Default is TRUE.}

\item{reverse}{Sort the commits in reverse order; can be combined
with topological and/or time sorting. Default is FALSE.}

\item{n}{The upper limit of the number of commits to output. The
defualt is NULL for unlimited number of commits.}
}
\value{
list of commits in repository
}
\description{
Commits
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Second commit message")

## Change file again and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad",
             "minim veniam, quis nostrud exercitation ullamco laboris nisi ut"),
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "Third commit message")

## List commits in repository
commits(repo)
}
}
