% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{ahead_behind}
\alias{ahead_behind}
\title{Ahead Behind}
\usage{
ahead_behind(local = NULL, upstream = NULL)
}
\arguments{
\item{local}{a git_commit object.}

\item{upstream}{a git_commit object.}
}
\value{
An integer vector of length 2 with number of commits that
the upstream commit is ahead and behind the local commit
}
\description{
Count the number of unique commits between two commit objects.
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit_1 <- commit(repo, "Commit message 1")

# Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
             con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit_2 <- commit(repo, "Commit message 2")

ahead_behind(commit_1, commit_2)
}
}
